/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.CodeSigner;
import java.security.CryptoPrimitive;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import sun.security.jca.Providers;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.ManifestDigester;

public class SignatureFileVerifier {
    private static final Debug debug = Debug.getInstance("jar");
    private static final Set<CryptoPrimitive> DIGEST_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.MESSAGE_DIGEST));
    private static final DisabledAlgorithmConstraints JAR_DISABLED_CHECK = new DisabledAlgorithmConstraints("jdk.jar.disabledAlgorithms");
    private ArrayList<CodeSigner[]> signerCache;
    private static final String ATTR_DIGEST = "-DIGEST-Manifest-Main-Attributes".toUpperCase(Locale.ENGLISH);
    private PKCS7 block;
    private byte[] sfBytes;
    private String name;
    private ManifestDigester md;
    private HashMap<String, MessageDigest> createdDigests;
    private boolean workaround = false;
    private CertificateFactory certificateFactory = null;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureFileVerifier(ArrayList<CodeSigner[]> arrayList, ManifestDigester manifestDigester, String string, byte[] byArray) throws IOException, CertificateException {
        Object object = null;
        try {
            object = Providers.startJarVerification();
            this.block = new PKCS7(byArray);
            this.sfBytes = this.block.getContentInfo().getData();
            this.certificateFactory = CertificateFactory.getInstance("X509");
        }
        finally {
            Providers.stopJarVerification(object);
        }
        this.name = string.substring(0, string.lastIndexOf(".")).toUpperCase(Locale.ENGLISH);
        this.md = manifestDigester;
        this.signerCache = arrayList;
    }

    public boolean needSignatureFileBytes() {
        return this.sfBytes == null;
    }

    public boolean needSignatureFile(String string) {
        return this.name.equalsIgnoreCase(string);
    }

    public void setSignatureFile(byte[] byArray) {
        this.sfBytes = byArray;
    }

    public static boolean isBlockOrSF(String string) {
        return string.endsWith(".SF") || string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".EC");
    }

    public static boolean isSigningRelated(String string) {
        if (!(string = string.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/")) {
            return false;
        }
        if ((string = string.substring(9)).indexOf(47) != -1) {
            return false;
        }
        if (SignatureFileVerifier.isBlockOrSF(string) || string.equals("MANIFEST.MF")) {
            return true;
        }
        if (string.startsWith("SIG-")) {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                String string2 = string.substring(n + 1);
                if (string2.length() > 3 || string2.length() < 1) {
                    return false;
                }
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private MessageDigest getDigest(String string) throws SignatureException {
        MessageDigest messageDigest;
        if (!JAR_DISABLED_CHECK.permits(DIGEST_PRIMITIVE_SET, string, null)) {
            SignatureException signatureException = new SignatureException("SignatureFile check failed. Disabled algorithm used: " + string);
            throw signatureException;
        }
        if (this.createdDigests == null) {
            this.createdDigests = new HashMap();
        }
        if ((messageDigest = this.createdDigests.get(string)) == null) {
            try {
                messageDigest = MessageDigest.getInstance(string);
                this.createdDigests.put(string, messageDigest);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Hashtable<String, CodeSigner[]> hashtable, List<Object> list) throws IOException, SignatureException, NoSuchAlgorithmException, JarException, CertificateException {
        Object object = null;
        try {
            object = Providers.startJarVerification();
            this.processImpl(hashtable, list);
        }
        finally {
            Providers.stopJarVerification(object);
        }
    }

    private void processImpl(Hashtable<String, CodeSigner[]> hashtable, List<Object> list) throws IOException, SignatureException, NoSuchAlgorithmException, JarException, CertificateException {
        Manifest manifest = new Manifest();
        manifest.read(new ByteArrayInputStream(this.sfBytes));
        String string = manifest.getMainAttributes().getValue(Attributes.Name.SIGNATURE_VERSION);
        if (string == null || !string.equalsIgnoreCase("1.0")) {
            return;
        }
        SignerInfo[] signerInfoArray = this.block.verify(this.sfBytes);
        if (signerInfoArray == null) {
            throw new SecurityException("cannot verify signature block file " + this.name);
        }
        CodeSigner[] codeSignerArray = this.getSigners(signerInfoArray, this.block);
        if (codeSignerArray == null) {
            return;
        }
        Iterator<Map.Entry<String, Attributes>> iterator = manifest.getEntries().entrySet().iterator();
        boolean bl = this.verifyManifestHash(manifest, this.md, list);
        if (!bl && !this.verifyManifestMainAttrs(manifest, this.md)) {
            throw new SecurityException("Invalid signature file digest for Manifest main attributes");
        }
        while (iterator.hasNext()) {
            Map.Entry<String, Attributes> entry = iterator.next();
            String string2 = entry.getKey();
            if (bl || this.verifySection(entry.getValue(), string2, this.md)) {
                if (string2.startsWith("./")) {
                    string2 = string2.substring(2);
                }
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                this.updateSigners(codeSignerArray, hashtable, string2);
                if (debug == null) continue;
                debug.println("processSignature signed name = " + string2);
                continue;
            }
            if (debug == null) continue;
            debug.println("processSignature unsigned name = " + string2);
        }
        this.updateSigners(codeSignerArray, hashtable, "META-INF/MANIFEST.MF");
    }

    private boolean verifyManifestHash(Manifest manifest, ManifestDigester manifestDigester, List<Object> list) throws IOException, SignatureException {
        Attributes attributes = manifest.getMainAttributes();
        boolean bl = false;
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string = entry.getKey().toString();
            if (!string.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST-MANIFEST")) continue;
            String string2 = string.substring(0, string.length() - 16);
            list.add(string);
            list.add(entry.getValue());
            MessageDigest messageDigest = this.getDigest(string2);
            if (messageDigest == null) continue;
            byte[] byArray = manifestDigester.manifestDigest(messageDigest);
            byte[] byArray2 = Base64.getMimeDecoder().decode((String)entry.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest digest " + messageDigest.getAlgorithm());
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(byArray2));
                debug.println("  computed " + SignatureFileVerifier.toHex(byArray));
                debug.println();
            }
            if (!MessageDigest.isEqual(byArray, byArray2)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean verifyManifestMainAttrs(Manifest manifest, ManifestDigester manifestDigester) throws IOException, SignatureException {
        Attributes attributes = manifest.getMainAttributes();
        boolean bl = true;
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string;
            MessageDigest messageDigest;
            String string2 = entry.getKey().toString();
            if (!string2.toUpperCase(Locale.ENGLISH).endsWith(ATTR_DIGEST) || (messageDigest = this.getDigest(string = string2.substring(0, string2.length() - ATTR_DIGEST.length()))) == null) continue;
            ManifestDigester.Entry entry2 = manifestDigester.get("Manifest-Main-Attributes", false);
            byte[] byArray = entry2.digest(messageDigest);
            byte[] byArray2 = Base64.getMimeDecoder().decode((String)entry.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest Main Attributes digest " + messageDigest.getAlgorithm());
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(byArray2));
                debug.println("  computed " + SignatureFileVerifier.toHex(byArray));
                debug.println();
            }
            if (MessageDigest.isEqual(byArray, byArray2)) continue;
            bl = false;
            if (debug == null) break;
            debug.println("Verification of Manifest main attributes failed");
            debug.println();
            break;
        }
        return bl;
    }

    private boolean verifySection(Attributes attributes, String string, ManifestDigester manifestDigester) throws IOException, SignatureException {
        boolean bl = false;
        ManifestDigester.Entry entry = manifestDigester.get(string, this.block.isOldStyle());
        if (entry == null) {
            throw new SecurityException("no manifest section for signature file entry " + string);
        }
        if (attributes != null) {
            for (Map.Entry<Object, Object> entry2 : attributes.entrySet()) {
                String string2;
                MessageDigest messageDigest;
                String string3 = entry2.getKey().toString();
                if (!string3.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST") || (messageDigest = this.getDigest(string2 = string3.substring(0, string3.length() - 7))) == null) continue;
                boolean bl2 = false;
                byte[] byArray = Base64.getMimeDecoder().decode((String)entry2.getValue());
                byte[] byArray2 = this.workaround ? entry.digestWorkaround(messageDigest) : entry.digest(messageDigest);
                if (debug != null) {
                    debug.println("Signature Block File: " + string + " digest=" + messageDigest.getAlgorithm());
                    debug.println("  expected " + SignatureFileVerifier.toHex(byArray));
                    debug.println("  computed " + SignatureFileVerifier.toHex(byArray2));
                    debug.println();
                }
                if (MessageDigest.isEqual(byArray2, byArray)) {
                    bl = true;
                    bl2 = true;
                } else if (!this.workaround && MessageDigest.isEqual(byArray2 = entry.digestWorkaround(messageDigest), byArray)) {
                    if (debug != null) {
                        debug.println("  re-computed " + SignatureFileVerifier.toHex(byArray2));
                        debug.println();
                    }
                    this.workaround = true;
                    bl = true;
                    bl2 = true;
                }
                if (bl2) continue;
                throw new SecurityException("invalid " + messageDigest.getAlgorithm() + " signature file digest for " + string);
            }
        }
        return bl;
    }

    private CodeSigner[] getSigners(SignerInfo[] signerInfoArray, PKCS7 pKCS7) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        ArrayList<CodeSigner> arrayList = null;
        for (int i = 0; i < signerInfoArray.length; ++i) {
            SignerInfo signerInfo = signerInfoArray[i];
            ArrayList<X509Certificate> arrayList2 = signerInfo.getCertificateChain(pKCS7);
            CertPath certPath = this.certificateFactory.generateCertPath(arrayList2);
            if (arrayList == null) {
                arrayList = new ArrayList<CodeSigner>();
            }
            arrayList.add(new CodeSigner(certPath, signerInfo.getTimestamp()));
            if (debug == null) continue;
            debug.println("Signature Block Certificate: " + arrayList2.get(0));
        }
        if (arrayList != null) {
            return arrayList.toArray(new CodeSigner[arrayList.size()]);
        }
        return null;
    }

    static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexc[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexc[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    static boolean contains(CodeSigner[] codeSignerArray, CodeSigner codeSigner) {
        for (int i = 0; i < codeSignerArray.length; ++i) {
            if (!codeSignerArray[i].equals(codeSigner)) continue;
            return true;
        }
        return false;
    }

    static boolean isSubSet(CodeSigner[] codeSignerArray, CodeSigner[] codeSignerArray2) {
        if (codeSignerArray2 == codeSignerArray) {
            return true;
        }
        for (int i = 0; i < codeSignerArray.length; ++i) {
            if (SignatureFileVerifier.contains(codeSignerArray2, codeSignerArray[i])) continue;
            return false;
        }
        return true;
    }

    static boolean matches(CodeSigner[] codeSignerArray, CodeSigner[] codeSignerArray2, CodeSigner[] codeSignerArray3) {
        if (codeSignerArray2 == null && codeSignerArray == codeSignerArray3) {
            return true;
        }
        if (codeSignerArray2 != null && !SignatureFileVerifier.isSubSet(codeSignerArray2, codeSignerArray)) {
            return false;
        }
        if (!SignatureFileVerifier.isSubSet(codeSignerArray3, codeSignerArray)) {
            return false;
        }
        for (int i = 0; i < codeSignerArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = codeSignerArray2 != null && SignatureFileVerifier.contains(codeSignerArray2, codeSignerArray[i]) || SignatureFileVerifier.contains(codeSignerArray3, codeSignerArray[i]);
            if (bl) continue;
            return false;
        }
        return true;
    }

    void updateSigners(CodeSigner[] codeSignerArray, Hashtable<String, CodeSigner[]> hashtable, String string) {
        CodeSigner[] codeSignerArray2;
        CodeSigner[] codeSignerArray3 = hashtable.get(string);
        for (int i = this.signerCache.size() - 1; i != -1; --i) {
            codeSignerArray2 = this.signerCache.get(i);
            if (!SignatureFileVerifier.matches(codeSignerArray2, codeSignerArray3, codeSignerArray)) continue;
            hashtable.put(string, codeSignerArray2);
            return;
        }
        if (codeSignerArray3 == null) {
            codeSignerArray2 = codeSignerArray;
        } else {
            codeSignerArray2 = new CodeSigner[codeSignerArray3.length + codeSignerArray.length];
            System.arraycopy(codeSignerArray3, 0, codeSignerArray2, 0, codeSignerArray3.length);
            System.arraycopy(codeSignerArray, 0, codeSignerArray2, codeSignerArray3.length, codeSignerArray.length);
        }
        this.signerCache.add(codeSignerArray2);
        hashtable.put(string, codeSignerArray2);
    }
}

