/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class RenegotiationInfoExtension
extends HelloExtension {
    private final byte[] renegotiated_connection;

    RenegotiationInfoExtension(byte[] byArray, byte[] byArray2) {
        super(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (byArray.length != 0) {
            this.renegotiated_connection = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, this.renegotiated_connection, 0, byArray.length);
            if (byArray2.length != 0) {
                System.arraycopy(byArray2, 0, this.renegotiated_connection, byArray.length, byArray2.length);
            }
        } else {
            this.renegotiated_connection = new byte[0];
        }
    }

    RenegotiationInfoExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (n < 1) {
            throw new SSLProtocolException("Invalid " + this.type + " extension");
        }
        int n2 = handshakeInStream.getInt8();
        if (n2 + 1 != n) {
            throw new SSLProtocolException("Invalid " + this.type + " extension");
        }
        this.renegotiated_connection = new byte[n2];
        if (n2 != 0) {
            handshakeInStream.read(this.renegotiated_connection, 0, n2);
        }
    }

    @Override
    int length() {
        return 5 + this.renegotiated_connection.length;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        handshakeOutStream.putInt16(this.renegotiated_connection.length + 1);
        handshakeOutStream.putBytes8(this.renegotiated_connection);
    }

    boolean isEmpty() {
        return this.renegotiated_connection.length == 0;
    }

    byte[] getRenegotiatedConnection() {
        return this.renegotiated_connection;
    }

    @Override
    public String toString() {
        return "Extension " + this.type + ", renegotiated_connection: " + (this.renegotiated_connection.length == 0 ? "<empty>" : Debug.toString(this.renegotiated_connection));
    }
}

