//Vertex Shader -------------------------------------------
cbuffer constBuffer
{
  float4x4 world;		//0
  float4x4 projection;  //!
  float4x4 view;
  float IsInstanced;
  float Timer;
  float2 iResolution; 
  float4 circlesize0;
  float4 circlesize1;
  float4 circlesize2;
  float4 circlesize3;
  float4 circlesize4;
  float rotspeed;
  float posSpeed;
  float radFactor;
  float nGonTime;
  int nGons;
};

struct VS_Data
{
  float3 position : POSITION;
  float2 uv : UV;
};

struct PS_Data
{
  float4 position : SV_POSITION;
  float2 uv : UV;
};

#define phirad 2.39996322972865332

float gt(float x, float y)
{
    return floor(max(sign(x-y),0.0));
}

float sinIO( float x)
{
    return sin(x)*0.5+0.5;
}

float cosIO( float x)
{
    return cos(x)*0.5+0.5;
}

float sinBetween( float x,  float y,  float z)
{
    return (z - sinIO(x)*z ) + (sinIO(x)*y);
}

float cosBetween( float x,  float y,  float z)
{
    return (z - cosIO(x)*z) + (cosIO(x)*y);
}


float smin(float a, float b, float k) {
  float h = clamp(0.5 + 0.5 * (b - a) / k, 0.0, 1.0);
  return lerp(b, a, h) - k * h * (1.0 - h);
}

float nGonSDF(float2 uv, float2 pos, in int gons, in float radius, float rotation)
{
    uv -= pos;
    float stepSize = 6.28 / float(gons);
    float currentAngle = atan2(uv.y, uv.x) + rotation;
    
    float dist = (cos(floor(0.5 + currentAngle / stepSize)* stepSize - currentAngle)* length(uv)) - radius;
    
    return dist;
}


float3 Singular(float iGlobalTime, float2 uv)
{
  float3 fColor = float3(0.0,0.0,0.0);

  float2 oPos00 = float2(.0,.0);
  float2 oPos01 = float2(.0,.2);
  float2 oPos10 = float2(.0,-.3);
  float2 oPos11 = float2(.3,.0);
  
  float count = 15.;
    
  for(float i = 0.; i <  15.; ++i)
  {
     float2 oPos00 = float2(cos(iGlobalTime*0.5+i/ count * 6.28+0.5)*0.5,sin(i/count * 6.28)*0.5);
     float2 oPos01 = float2(cos(iGlobalTime*0.5+i/ count * 6.28+0.48)*0.5,sin(i/count * 6.28)*0.5);
     float2 oPos10 = float2(cos(iGlobalTime*0.5+i/ count * 6.28+0.45)*0.5,sin(i/count * 6.28)*0.5);
       
     float o00 = length(oPos00 - uv) - 0.05; 
     float o01 = length(oPos01 - uv) - 0.05; 
     float o10 = length(oPos10 - uv) - 0.05; 
        
     float3  mat00 = (1. - smoothstep(0.0,5.0/iResolution.x,o00)) * (float3(1.0,0.0,0.0)*1.0);
     float3  mat01 = (1. - smoothstep(0.0,5.0/iResolution.x,o01)) * (float3(0.0,1.0,0.0)*1.0);
     float3  mat10 = (1. - smoothstep(0.0,5.0/iResolution.x,o10)) * (float3(0.0,0.0,1.0)*1.0);
        
     fColor += mat00;
     fColor += mat01;
     fColor += mat10;  
  }
  
  return fColor;
}

float3 Edge(float iGlobalTime, float2 uv)
{
    float3 fColor = float3(0.0,0.0,0.0);
    
    fColor.r = smoothstep(0.0,0.018,(sin(iGlobalTime)*uv.y)+(cos(iGlobalTime)*uv.x));
    fColor.g = smoothstep(0.0,0.018,(sin(iGlobalTime+0.01)*uv.y)+(cos(iGlobalTime+0.01)*uv.x));
    fColor.b = smoothstep(0.0,0.020,(sin(iGlobalTime+0.02)*uv.y)+(cos(iGlobalTime+0.02)*uv.x));
    
    return fColor;
}

float Circle(float2 uv, float2 pos, float radius, float thickness)
{
	float c = length( pos - uv );

	
	if(radius > 0.1)
	{
		float dist =  (radius - c) /radius;
		
		float sdfCircle = clamp(pow(((2.0/thickness)*dist -1.0),2.0)-1.0,0.0,1.0);
		
		

		//return (1. - smoothstep(0.0,1.0/iResolution.x,sdfCircle));
		return 1.0- sdfCircle;
	}
	return 0.0;
	
	
}

float2 FlowerPos(float id, float rad,float t)
{
	
	float steps = 6.28318530f / 6.0f;
	float offset = 3.63467438+(rotspeed);//1.57079632679;
	
	float ang = steps*id+offset;
	
	return float2( cos(ang)*rad, sin(ang)*rad);
	
		
	//else if(id > 6)
	//{
	//	return float2( cos(steps*id+offset)*2.0, sin(steps*id+offset)*2.0);
	//}
	//ö return float2( 0.0, 0.0);
}

float3 Flower(float iGlobalTime, float2 uv,float t)
{
    float3 fColor = float3(0.0,0.0,0.0);
   float thick = 0.03;
	
	fColor += Circle(uv,float2(0.0,0.0),circlesize0.x,thick);
	fColor += Circle(uv,FlowerPos(1.0,0.5,t),circlesize0.y,thick);
	fColor += Circle(uv,FlowerPos(2.0,0.5,t),circlesize0.z,thick);
	fColor += Circle(uv,FlowerPos(3.0,0.5,t),circlesize0.w,thick);
	
	fColor += Circle(uv,FlowerPos(4.0,0.5,t),circlesize1.x,thick);
	fColor += Circle(uv,FlowerPos(5.0,0.5,t),circlesize1.y,thick);
	fColor += Circle(uv,FlowerPos(6.0,0.5,t),circlesize1.z,thick);
	fColor += Circle(uv,FlowerPos(1.0,1.0,t),circlesize1.w,thick);
	
	fColor += Circle(uv,FlowerPos(2.0,1.0,t)-FlowerPos(1.0,1.0,t) * 0.5,circlesize2.x,thick);
	fColor += Circle(uv,FlowerPos(2.0,1.0,t),circlesize2.y,thick);
	fColor += Circle(uv,FlowerPos(3.0,1.0,t)-FlowerPos(2.0,1.0,t) * 0.5,circlesize2.z,thick);
	fColor += Circle(uv,FlowerPos(3.0,1.0,t),circlesize2.w,thick);
	
	fColor += Circle(uv,FlowerPos(4.0,1.0,t)-FlowerPos(3.0,1.0,t) * 0.5,circlesize3.x,thick);
	fColor += Circle(uv,FlowerPos(4.0,1.0,t),circlesize3.y,thick);
	fColor += Circle(uv,FlowerPos(5.0,1.0,t)-FlowerPos(4.0,1.0,t) * 0.5,circlesize3.z,thick);
	fColor += Circle(uv,FlowerPos(5.0,1.0,t),circlesize3.w,thick);
	
	fColor += Circle(uv,FlowerPos(6.0,1.0,t)-FlowerPos(5.0,1.0,t) * 0.5,circlesize4.x,thick);
	fColor += Circle(uv,FlowerPos(6.0,1.0,t),circlesize4.y,thick);
	fColor += Circle(uv,FlowerPos(7.0,1.0,t)-FlowerPos(6.0,1.0,t) * 0.5,circlesize4.z,thick);
	fColor += Circle(uv,float2(0.0,0.0),circlesize4.w,thick*0.5);
	


    //for(float i = 20.0; i > 0.; --i)
   // {
   //     pos = float2(sin(iGlobalTime+(20.0 - i)*0.4)*0.02, sin(iGlobalTime+(20.0 - i)*0.4)*0.02);
   //   float dist = nGonSDF(uv,pos,4,0.5);
  //    float o = 1. - smoothstep(0.0,5.0/iResolution.x, dist);

  //      fColor = lerp(fColor , float3(1.,1.,1.)* (1. -fmod(i,2.)),o);
  //  }
    
	
  return fColor;
}

float mask = 0.0;
float4 Illusion(float iGlobalTime, float2 uv)
{
    float4 fColor = float4(0.0,0.0,0.0,0.0);
   
    for(float i = 50.; i > 0.; i--)
    {

      float radius = (radFactor + i*0.1f) + (iGlobalTime * 0.3);
      //float radius = (i+-400.0)*radFactor + iGlobalTime * 0.3;
      float2 pos = float2(0.0,0.0);//float2(cos(iGlobalTime+i*0.08) * posSpeed,sin(iGlobalTime+i+0.156)*posSpeed);
      float rot = 0.0;//sin(-iGlobalTime*0.1+(i/20.0))*6.28;

      float dist = nGonSDF(uv,pos,nGons,radius, rot);

      float o = 1. - smoothstep(0.0,5.0/iResolution.x, dist);
	  
	  fColor.w += o;
      float3 oColor = float3(1.0,1.0,1.0) * (1.0 -fmod(i,2.0));
      fColor.xyz = lerp(fColor.xyz,oColor.xyz,o);

    }

      



    //for(float i = 20.0; i > 0.; --i)
   // {
   //     pos = float2(sin(iGlobalTime+(20.0 - i)*0.4)*0.02, sin(iGlobalTime+(20.0 - i)*0.4)*0.02);
   //   float dist = nGonSDF(uv,pos,4,0.5);
  //    float o = 1. - smoothstep(0.0,5.0/iResolution.x, dist);

  //      fColor = lerp(fColor , float3(1.,1.,1.)* (1. -fmod(i,2.)),o);
  //  }
    
  return fColor;
}

PS_Data VS_Main(VS_Data input)
{
  PS_Data output;
  
  output.position = mul(float4(input.position, 1), world);
  output.position = mul(output.position, view);
  output.position = mul(output.position, projection);

  output.uv = input.uv;

  return output;
}

//PIXEL SHADER ---------------------------------------------
Texture2D DiffuseTexture;
Texture2D Texture;

SamplerState Sampler;

float4 PS_Main(PS_Data input) : SV_TARGET
{

  float iGlobalTime = Timer;

  float3 fColor = float3(.0,.0,.0);
  float2 uv = input.uv.xy;
  uv = 2.0 * uv - 1.0;
  uv.x *= iResolution.x / iResolution.y;

  uv *= 2.5;
  float3 a = Flower(iGlobalTime, uv, iGlobalTime);
  float4 b = Illusion(nGonTime,uv);
  a = lerp(a,b.xyz,b.w);

   //float3 s = Singular(iGlobalTime, uv);
   ////float3 e = Edge(iGlobalTime, uv);
   //
   //float t = fmod(iGlobalTime,100.);
 
  return float4(a,1.0);
}