//SamplerState sm:register(s1);
//Texture2D input:register(t0);

// cbuffer for ShaderScene
cbuffer c : register(b1)
{
	float4x4 matView; // N/A view matrix, (world space -> camera space) (if camera avaiable)
	float4x4 matProj; // N/A projection matrix, (camera space -> screen space)
	float4x4 matInvView; // N/A inverse view matrix (camera space -> world space) (if camera avaiable)
	float4x4 matInvProj; // N/A inverse projection matrix (screen space -> camera space);
	float4 worldCameraPosition; // N/A position of camera (if camera avaiable)
	float4 screenResolution; // resolution is provided if needed
	float4 debugMouse; // mouse coordinates from -1 to +1 for debug purposes (disabled for live)
	float normalizedTime; // scene time from 0 to 1
	float param1; // scene parameter 1
	float param2; // scene parameter 2
	float param3; // scene parameter 3
}

float glsl_mod(float x, float y) { return frac(x/y)*y; }
float2 glsl_mod(float2 x, float2 y) { return frac(x/y)*y; }
float3 glsl_mod(float3 x, float3 y) { return frac(x/y)*y; }
float4 glsl_mod(float4 x, float4 y) { return frac(x/y)*y; }

float df_big(float3 p)
{
	p = p +sin(p.yxz + normalizedTime*float3(1,3,-7));
	return length(p)-1.5;
}

//distance function
float df(float3 p){
	float rate = 0.125;
	float3 fp = glsl_mod(p, 2*rate);
	float3 rp = fp-rate;
	float3 ip = p-rp;
	float big = df_big(p);
	float size = 1.0-distance(df_big(ip),-0.5);
	float size2 = 1.0-distance(df_big(ip),32.5);
	size = min(size,rate*.5);
	float objects = length(rp)-size;
	float objects2 = length(rp)-size2;
	float floor = 2.0-p.y;
	return min(min(min(objects, big),objects2),floor);
}

// normal function
float3 nf(float3 p){
	float2 e = float2(0,0.1);
	float c = df(p);
	return normalize(float3( df(p+e.yxx)-c, df(p+e.xyx)-c, df(p+e.xxy)-c ));
}

void rotate( inout float2  v, float a)
{
	float c=cos(a),s=sin(a);
	v.xy = float2(v.x*c+v.y*s, v.x*-s+v.y*c);
}

float4 main(in float4 vertexPosition : SV_Position, in float2 uv : TEXCOORD, out float depth : SV_DEPTH) : SV_TARGET0
{ 
	float3 dir = normalize(float3(uv-.5,2.0));
	dir.x *= screenResolution.x/screenResolution.y;
	float3 pos = float3(0,0,-12);
	
	float time = normalizedTime;
	rotate(pos.xz, time);
	rotate(dir.xz, time);
	rotate(pos.xy, time*0.1 -.5);
	rotate(dir.xy, time*0.1 -.5);
	
	float3 original_pos = pos;
	
	int i;
	float t;
	for (i=0; i<96; i++)
	{
		t = df(pos);
		pos += dir*t;
		if (t<0.01){
			break;
		} 
	}
	for (i=0; i<32; i++)
	{
		t = df(pos)*.5;
		pos += dir*t;
	}
	float fi = float(i)/64.0;
	fi = 1.0-fi;
	
	float3 color;
	if (t<=0.01)
	{
		//object
		float3 n = nf(pos);
		float ao = df(pos+n);
		ao = ao*.75 + df(pos+n*.03)*.5;
		ao = ao*.75 + df(pos+n*.02)*.5;
		ao = ao*.75 + df(pos+n*.01)*.5;
		ao = ao*.5+.1;
		
		float3 light = normalize(float3(1-param2,-3,-3));
		
		float sh = 4.0;
		float eps = 0.5;
		for (int i=0; i<32; i++)
		{
			sh = min(sh, df(pos+light*eps)/eps);
			eps = eps*0.9;
		}
		color = (sh*.5+.5)*ao*2;
		color *= 20.0/distance(original_pos, pos);
		
		if (df_big(pos)<0.05){
			color = color*float3(2,0.2,0.1);
		}
		
		depth = distance(original_pos, pos)*0.001;
	}
	else 
	{
		//background
		color = 0;
		depth = 1.0; //infinte
	}
	
	
	return float4(color,1.0); // return color in linear space
}