Texture2D InputTexture0:register(t0);
SamplerState PointSampler:register(s0);
SamplerState LinearSampler:register(s1);

cbuffer PSConstants : register(b0)
{
    float2 InputSize;
    float2 OutputSize;
}

cbuffer PSConstants : register(b1)
{
    float width;
    float height;
	float _padding_0;
	float _padding_1;
}


struct VSOutput
{
	float4 PositionCS : SV_POSITION;
	float2 TexCoord : texcoord;
};

#define vec4 float4
#define vec3 float3
#define vec2 float2

float4 tex(float2 p)
{
	return	InputTexture0.Sample(LinearSampler,p*float2(1.0/width,1.0/height));
}

vec4 FxaaPixelShader(
  vec4 posPos) // Constant {1.0/frameWidth, 1.0/frameHeight}.
{
/*---------------------------------------------------------*/
    #define FXAA_REDUCE_MIN   (1.0/128.0)
    #define FXAA_REDUCE_MUL   (1.0/8.0)
    #define FXAA_SPAN_MAX     8.0
/*---------------------------------------------------------*/
    vec3 rgbNW = tex(posPos.zw).xyz;
    vec3 rgbNE = tex(posPos.zw + vec2(1.0,0.0)).xyz;
    vec3 rgbSW = tex(posPos.zw + vec2(0.0,1.0)).xyz;
    vec3 rgbSE = tex(posPos.zw + vec2(1.0,1.0)).xyz;
    vec3 rgbM  = tex(posPos.xy).xyz;
/*---------------------------------------------------------*/
	
    const vec3 luma = vec3(0.299, 0.587, 0.114);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);
/*---------------------------------------------------------*/
    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
/*---------------------------------------------------------*/
    vec2 dir;
    dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
    dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
/*---------------------------------------------------------*/
    float dirReduce = max(
        (lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),
        FXAA_REDUCE_MIN);
    float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);
    dir = min(vec2( FXAA_SPAN_MAX,  FXAA_SPAN_MAX),
          max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),
          dir * rcpDirMin)); //* rcpFrame.xy;
/*--------------------------------------------------------*/
    vec4 rgbA = (1.0/2.0) * (
        tex(posPos.xy + dir * (1.0/3.0 - 0.5)) +
        tex(posPos.xy + dir * (2.0/3.0 - 0.5)));
    vec4 rgbB = rgbA * (1.0/2.0) + (1.0/4.0) * (
        tex(posPos.xy + dir * (0.0/3.0 - 0.5)) +
        tex(posPos.xy + dir * (3.0/3.0 - 0.5)));
    float lumaB = dot(rgbB, vec4(luma, 0.0));
    if((lumaB < lumaMin) || (lumaB > lumaMax)) return rgbA;
	return rgbB; 
}

float4 main(in VSOutput input) : SV_Target
{
	float2 screenxy = input.TexCoord.xy*float2(width,height);
	return FxaaPixelShader(float4(screenxy,screenxy-0.5));
	//return float4(frac(input.TexCoord*float2(width/height, 1.0)), .5, 1.0);
	//return InputTexture0.Sample(LinearSampler,input.TexCoord.yx);
	//return FxaaPixelShader(input.TexCoord, float2(1.0f/width, 1.0f/height), 0.75f, 0.166f, 0.0833f);// Textur.Sample(sm,t.xy);
}