Array<LineIntersectProxy@> proxyRegistry;

bool lineIntersect(Vector3 lo, Vector3 u, float l, Vector3 &out intersect) {
	
	for (uint i = 0; i < proxyRegistry.length(); i++) {
		if (u.dot(proxyRegistry[i].n) > 0) {
			echo(">0");
			return proxyRegistry[i].lineIntersect(lo, u, l, intersect);
		}
	}	
	return false;
}

class LineIntersectProxy:Plane {
	Object@ object;
	Object@ orientationOrigin;
	Timer@ timer;
	float size;
	LineIntersectProxy() {
	
	}
	LineIntersectProxy(Object@ o, Object@ oo, Timer@ t, float s=1) {
		proxyRegistry.add(@this);
		@object = @o;
		@orientationOrigin = @oo;
		super(object.position, getDirectionVector(object.position, orientationOrigin.position));
		@timer = @t;
		size = s;
		timer.elapsed += Action(this.updateProxy);
	}
	
	bool lineIntersect(Vector3 lo, Vector3 u, float l, Vector3 &out intersect) {	
		if (Plane::lineIntersect(lo, u, l, intersect)) {
			//echo("\n");
			//echo(String(intersect.x)+","+String(intersect.y)+","+String(intersect.z)+"\n");
			if (abs(getVectorLength(intersect-a)) <= size) {
				return true;
			}		
		}
		return false;
	}
	
	void remove() {
		for (uint i = 0; i < proxyRegistry.length(); i++) {
			proxyRegistry.removeAt(i);
			break;
		}
	}
	
	private void updateProxy() {
		this.a = object.position;
		this.n = getDirectionVector(object.position, orientationOrigin.position);
		//echo(String(n.x)+", "+String(n.y)+", "+String(n.z)+"\n");
	}
}