UIInput@ INPUT_ELEMENT_FOCUSED;

class UIInput:UIElement {
	Label@ inputLabel;
	Map<int, String> mapInputKeys;
	bool pFocus = false;
	uint maxLength = 10;
	float labelScale = 0.8;
	BitmapFont@ font;


	UIEvent@ onFocus;
	UIEvent@ onUnfocus;
	UIEvent@ onInput;
	UIEvent@ onChange;
	UIEvent@ onMaxCharReached;

	private String initVal = "";
	private Color origBackground = Color(163,163,163,255);

	UIInput() {

	}
	UIInput(Vector3 pos, int w, int h, BitmapFont@ f) {
		UIElement::initElement(pos, w, h);
		@font = f;
		initInputElement();
	}

	UIInput(String text, Vector3 pos, int w, int h, BitmapFont@ f) {
		this.initElement(pos, w, h);
		initVal = text;
		@font = f;
		initInputElement();
	}

	UIInput(Vector3 pos, int w, int h, BitmapFont@ f, String resourceLocation) {
		this.initElement(pos, w, h);
		this.setBackgroundImage(resourceLocation);
		@font = f;
		initInputElement();
	}

	String value {
		get {
			return inputLabel.text;
		}

		set {
			inputLabel.text = value;
		}
	}

	uint MaxLength {
		get {
			return maxLength;
		}

		set {
			maxLength = value;
		}
	}

	float Scale {
		get {
			return labelScale;
		}

		set {
			inputLabel.setScale(value);
		}
	}

	void setText(String char) {
		if ((inputLabel.text.length()) < maxLength) {
			inputLabel.text += char;
			if (@onChange !is null) {
				UIEventInfo info = UIEventInfo();
				@info.element = this;
				info.type = UIE_CHANGED;
				onChange(info);
			}

		} else {
			if (@onMaxCharReached !is null) {
				UIEventInfo info = UIEventInfo();
				@info.element = this;
				info.type = UIE_MAX_CHAR_REACHED;
				onMaxCharReached(info);
			}
		}
		if (@onInput !is null) {
			UIEventInfo info = UIEventInfo();
			@info.element = this;
			info.type = UIE_INPUT;
			onInput(info);
		}

	}

	private void initInputElement() {
		mapInputKeys.insert(PK_q, "q");
		mapInputKeys.insert(PK_w, "w");
		mapInputKeys.insert(PK_e, "e");
		mapInputKeys.insert(PK_r, "r");
		mapInputKeys.insert(PK_t, "t");
		mapInputKeys.insert(PK_y, "y");
		mapInputKeys.insert(PK_u, "u");
		mapInputKeys.insert(PK_i, "i");
		mapInputKeys.insert(PK_o, "o");
		mapInputKeys.insert(PK_p, "p");
		mapInputKeys.insert(PK_a, "a");
		mapInputKeys.insert(PK_s, "s");
		mapInputKeys.insert(PK_d, "d");
		mapInputKeys.insert(PK_f, "f");
		mapInputKeys.insert(PK_g, "g");
		mapInputKeys.insert(PK_h, "h");
		mapInputKeys.insert(PK_j, "j");
		mapInputKeys.insert(PK_k, "k");
		mapInputKeys.insert(PK_l, "l");
		mapInputKeys.insert(PK_z, "z");
		mapInputKeys.insert(PK_x, "x");
		mapInputKeys.insert(PK_c, "c");
		mapInputKeys.insert(PK_v, "v");
		mapInputKeys.insert(PK_b, "b");
		mapInputKeys.insert(PK_n, "n");
		mapInputKeys.insert(PK_m, "m");

		mapInputKeys.insert(PK_0, "0");
		mapInputKeys.insert(PK_1, "1");
		mapInputKeys.insert(PK_2, "2");
		mapInputKeys.insert(PK_3, "3");
		mapInputKeys.insert(PK_4, "4");
		mapInputKeys.insert(PK_5, "5");
		mapInputKeys.insert(PK_6, "6");
		mapInputKeys.insert(PK_7, "7");
		mapInputKeys.insert(PK_8, "8");
		mapInputKeys.insert(PK_9, "9");
		mapInputKeys.insert(PK_PERIOD, ".");


		@inputLabel = Label(font,initVal);
		inputLabel.setScale(labelScale);
		this.addChild(inputLabel);
		this.setChildPosition(inputLabel, Vector3(-(this.width/2),0,this.height/2));
		@this.onClick = UIEvent(this.focus);
	}


	void unfocus(pKeyCode code) {
		unfocus();
	}

	void deselect(){
		unfocus();
		//UIElement::deslect();
	}

	void focus(UIEventInfo _info) {
		echo(String(this.height));


		if (!pFocus) {
			if (@INPUT_ELEMENT_FOCUSED !is null) {
				INPUT_ELEMENT_FOCUSED.unfocus();

			}
			@INPUT_ELEMENT_FOCUSED = this;
			origBackground = bgColor;

			this.setBackground(Color(255,163,163,255));
			pFocus = true;
			setListeners();
			if (@onFocus !is null) {
				UIEventInfo info = UIEventInfo();
				@info.element = this;
				info.type = UIE_FOCUS;
				onFocus(info);
			}
		}
	}

	void unfocus() {
		if (@INPUT_ELEMENT_FOCUSED is this) {
			@INPUT_ELEMENT_FOCUSED = null;
		}
		if (pFocus) {
			this.setBackground(origBackground);
			pFocus = false;
			unsetListeners();
			if (@onUnfocus !is null) {
				UIEventInfo info = UIEventInfo();
				@info.element = this;
				info.type = UIE_UNFOCUS;
				onUnfocus(info);
			}
		}
	}

	uint length() {
		return inputLabel.text.length();
	}

	private void setListeners() {
		CONTROL.Input.keyDown(PK_BACKSPACE) += KeyStateCallback(this.backspace);
		CONTROL.Input.keyUp(PK_BACKSPACE) += KeyStateCallback(this.onKeyReleased);
		CONTROL.Input.keyDown(PK_RETURN) += KeyStateCallback(this.unfocus);
		for (Map_iterator<int, String> iter = mapInputKeys.begin(); ++iter;) {
			//echo(String(iter.key)+" "+iter.value);
			CONTROL.Input.keyDown(pKeyCode(iter.key)) += KeyStateCallback(this.onKeyPressed);
			CONTROL.Input.keyUp(pKeyCode(iter.key)) += KeyStateCallback(this.onKeyReleased);
		}
	}

	private void unsetListeners() {
		CONTROL.Input.keyDown(PK_BACKSPACE) -= KeyStateCallback(this.backspace);
		CONTROL.Input.keyUp(PK_BACKSPACE) -= KeyStateCallback(this.onKeyReleased);
		CONTROL.Input.keyDown(PK_RETURN) -= KeyStateCallback(this.unfocus);
		for (Map_iterator<int, String> iter = mapInputKeys.begin(); ++iter;) {
			CONTROL.Input.keyDown(pKeyCode(iter.key)) -= KeyStateCallback(this.onKeyPressed);
			CONTROL.Input.keyUp(pKeyCode(iter.key)) -= KeyStateCallback(this.onKeyReleased);
		}
	}
	int count = 0;
	bool isRepeat = false;
	bool isRepeatAdded = false;
	bool isBackspace = false;
	String lastChar;
	private void RepeatCount() {
		count++;
		if(!isRepeat){
			if(count >= 55){
				isRepeat = true;
				count = 0;
			}
		} else {
			if(count >= 5){
				count = 0;
				if(!isBackspace){
					setText(lastChar);
				} else if(isBackspace){
					backspace();
				}
			}
		}
	}

	private void onKeyReleased(pKeyCode code){
		if(code == PK_BACKSPACE){
			isBackspace = false;
		}
		if(isRepeatAdded){
			isRepeatAdded = false;
			MAIN_TIMER.elapsed-= Action(RepeatCount);
		}
		count = 0;
		isRepeat = false;
	}

	private void onKeyPressed(pKeyCode code) {
		if(!isRepeatAdded){
			isRepeatAdded = true;
			MAIN_TIMER.elapsed+= Action(RepeatCount);
		}
		for (Map_iterator<int, String> iter = mapInputKeys.begin(); ++iter;) {
			if (iter.key == code) {
				lastChar = iter.value;
				setText(iter.value);
				break;
			}
		}
	}
	private void backspace(pKeyCode code){
		backspace();
	}
	private void backspace() {
		if(!isRepeatAdded){
			isBackspace = true;
			isRepeatAdded = true;
			MAIN_TIMER.elapsed+= Action(RepeatCount);
		}
		//echo(inputLabel.text.substr(0, inputLabel.text.length()-1));
		if (inputLabel.text.length() > 0) {
			inputLabel.text = inputLabel.text.subString(0, inputLabel.text.length()-1);
			if (@onChange !is null) {
				UIEventInfo info = UIEventInfo();
				@info.element = this;
				info.type = UIE_CHANGED;
				onChange(info);
			}
		}
	}
}
