
//depends on CONTROL
#include "UIEvent.as";
#include "UIElementChildAdapter.as";
#include "UIDepthManager.as";
#include "MouseClickManager.as";

class UIElement {
	Vector3 position;
	Scene@ scene;
	Array<UIElementChildAdapter@> arrSubObjects;
	Object@ background;
	UIDepthManager@ depthManager;
	UIDepthManager@ parentManager = UI_DEPTH_MANAGER;
	bool ignoreDepthManager = false;
	bool clickResponse = true;
	String id = "default";
	private UIEvent@ clickAction;
	private Vector3 min;
	private Vector3 max;
	private bool vis = true;
	private int widthProp;
	private int heightProp;
	Color bgColor = Color(163,163,163,255);
	UIElement() {
		//constuctor
    startMouseClickManager();
	}

	UIElement(Vector3 pos, int w, int h) {
		initElement(pos, w, h);
	}

	UIElement(Vector3 pos, int w, int h, String resourceLocation) {
		initElement(pos, w, h);
		setBackgroundImage(resourceLocation);
	}

	~UIElement() {
	}

	void initElement(Vector3 pos, int w, int h) {
		@depthManager = UIDepthManager(0);
		position = pos;
		width = w;
		height = h;
		min = Vector3(position.x-(width/2), 0, position.z-(height/2));
		max = Vector3(position.x+(width/2), 0, position.z+(height/2));
	}

	UIEvent@ onClick {
		get const {
			return clickAction;
		}
		set {
			CONTROL.Input.mouseBtnDown(PM_LEFT) += MouseBtnCallback(clickEvent);
			@clickAction = value;
		}
	}

	void clickEvent(pMouseCode code, int x, int y) {
		if (this.containsPoint(Vector3(x-(MAIN_WINDOW.width/2), 0, (y-(MAIN_WINDOW.height/2))*-1))
        && this.clickResponse && mouseClickManager.CanUseMouseDown) {
      mouseClickManager.UsedMouseDown();
      UIEventInfo info = UIEventInfo();
			@info.element = this;
			info.type = UIE_CLICK;
			clickAction(info);
		}
	}

	int width {
		get const {
			return widthProp;
		}
		set {
			widthProp = value;
			if (@background !is null) {
				background.setScale(Vector3(value, heightProp, 0.1));
			}
		}
	}

	int height {
		get const {
			return heightProp;
		}
		set {
			heightProp = value;
			if (@background !is null) {
				background.setScale(Vector3(widthProp, value, 0.1));
			}
		}
	}

	void setPosition(Vector3 value) {
		this.position = value;

		min = Vector3(position.x-(width/2), 0, position.z-(height/2));
		max = Vector3(position.x+(width/2), 0, position.z+(height/2));
		if (@background != null) {
			background.setPosition(position);
		}

		for (uint i = 0; i < arrSubObjects.length(); i++) {
			arrSubObjects[i].setPosition(arrSubObjects[i].localPosition+position);
		}
	}

	void translate(Vector3 value) {
		this.setPosition(position + value);
	}

	void setChildPosition(Object@ child, Vector3 pos) {
		for (uint i = 0; i < arrSubObjects.length(); i++) {
			if (arrSubObjects[i].typeOf == SO_OBJECT) {
				if (@arrSubObjects[i].object == @child) {
					arrSubObjects[i].localPosition = pos;
					arrSubObjects[i].setPosition(arrSubObjects[i].localPosition+position);
				}
			}
		}

	}
	void setChildPosition(UIElement@ child, Vector3 pos) {
		for (uint i = 0; i < arrSubObjects.length(); i++) {
			if (arrSubObjects[i].typeOf == SO_ELEMENT) {
				if (@arrSubObjects[i].element == @child) {
					arrSubObjects[i].localPosition = pos;
					arrSubObjects[i].setPosition(arrSubObjects[i].localPosition+position);
				}
			}
		}
	}


	bool visible {
		get const {
			return vis;
		}
		set {
			setVisible(value);
		}
	}

	void deselect(){
		//empty (no shit)
	}

	void setVisible(bool value){
		if (vis && !value) {
			this.translate(Vector3(0,-101,0));
		} else if (!vis && value) {
			this.translate(Vector3(0,101,0));
		}
		vis = value;
		clickResponse = value;
		for (uint i = 0; i < arrSubObjects.length(); i++) {
			arrSubObjects[i].clickResponse = value;
			if(arrSubObjects[i].typeOf == SO_ELEMENT)
			{
				UIElement@ test = arrSubObjects[i].element;
				if(@test != null){
					test.deselect();
				}
			}
		}
	}

	void setBackgroundImage(String resourceLocation) {
		@background = objectFactory.createPoster(resourceLocation);
		background.model.getSurface(0).material.mode = DM_EMISSIVE;
	}

	void setBackground(Color color) {
		Object@ bg = objectFactory.createCube();
		bg.model.getSurface(0).material.mode = DM_EMISSIVE;
		bg.setPosition(position);
		bg.setScale(this.width, 0.01, this.height);
		bg.model.setColor(color);
		bgColor = color;
		if (@scene !is null && @background !is null) {
			scene.remove(background);
			@background = null;
			scene.add(bg);
		}
		@this.background = bg;
	}

	UIElementChildAdapter@ addChild(UIElement@ element) {
		@element.parentManager = this.depthManager;
		UIElementChildAdapter@ adapter = UIElementChildAdapter(element);
		if (@scene !is null && !ignoreDepthManager) {
			depthManager.setIndex(adapter);
		}
		arrSubObjects.add(adapter);
		return adapter;
	}

	UIElementChildAdapter@ addChild(Object@ object) {
		UIElementChildAdapter@ adapter = UIElementChildAdapter(object);
		if (@scene !is null && !ignoreDepthManager) {
			depthManager.setIndex(adapter);
		}
		arrSubObjects.add(adapter);
		return adapter;
	}

	void addToScene(Scene@ s) {
		if (@scene is null) {
			@scene = s;
			if (@background != null) {
				scene.add(background);
			}
			if (!ignoreDepthManager) {
				depthManager.baseIndex = parentManager.setIndex(UIElementChildAdapter(this));
				for (uint i = 0; i < arrSubObjects.length(); i++) {
					arrSubObjects[i].addToScene(scene);
					depthManager.setIndex(arrSubObjects[i]);
				}
			} else {
				for (uint i = 0; i < arrSubObjects.length(); i++) {
					arrSubObjects[i].ignoreDepthManager = true;
					arrSubObjects[i].addToScene(scene);
					
				}				
			}
		}
	}

	void removeFromScene() {
		if (@background != null) {
			scene.remove(background);
		}
		for (uint i = 0; i < arrSubObjects.length(); i++) {
			arrSubObjects[i].removeFromScene();
		}
		@scene = null;
	}

	bool containsPoint(Vector3 p) {
		if (p.x < max.x && p.x > min.x && p.z < max.z && p.z > min.z) {
			return true;
		}
		return false;
	}
}
