// 	Controller.as
//

#include "InputControllerAction.as";
#include "InputControllerFunctions.as";

int INPUT_UID = 0;

enum ControllerType {
	C_KB,
	C_MOUSE
}

enum TriggerType {
	T_UP = 1,
	T_DOWN = 2
}

interface InputControllerInterface {
	void doAction(InputControllerAction, int val = 0);
}

class InputControlPair {
	pKeyCode key;
	pMouseCode button;
	InputControllerAction val;
	bool repeat;
	ControllerType type;
	TriggerType trigger;
	int id = INPUT_UID++;

	InputControlPair() {
		//empty constructor
	}
	InputControlPair(pKeyCode k, InputControllerAction v, bool r=true, TriggerType t=T_DOWN) {
		type = C_KB;
		key = k;
		this.init(v, r, t);
	}
	InputControlPair(pMouseCode b, InputControllerAction v, bool r=true, TriggerType t=T_DOWN) {
		type = C_MOUSE;
		button = b;
		this.init(v, r, t);
	}
	private void init(InputControllerAction v, bool r, TriggerType t) {
		val = v;
		repeat = r;
		trigger = t;
	}
}

class InputController {
	Array<InputControlPair@> pairs;
	Array<InputControllerAction> mouseActions;
	Timer@ timer;
	InputControllerInterface @target;
	private bool mouseControlSet = false;
	Window@ window;
	bool evalNext = true;
	Array<int> arrPrevPressed;
	int type = 0;
	int cursorX;
	int cursorY;
	int prevCursorX = 0;
	int prevCursorY = 0;
	bool controlStep = false;

	private Map<pKeyCode, InputControllerAction> actionMap;
	private bool controllerActive = false;

	InputController() {
		//default constructor
	}

	InputController(InputControllerInterface @a, Timer@ t, Window @w) {
		@target = @a;
		@timer = @t;
		@window = @w;

	}
	InputController(InputControllerInterface @a, Window @w) {
		@target = @a;
		controlStep = true;
		@window = @w;
	}

	~InputController() {
		//echo("controller removed! \n");
	}




	// // This way the input controller is a much thinner layer on the engine's input interface
	// // pause should be a method on scene (you can also pause all physics on a scene by saying scene.simulationspeed = 0)
	// ///////////////////////////////
	// void onKeyDown(pKeyCode key) {
		// target.doAction(actionMap[key]);
	// }

	// void onKeyUp(pKeyCode key) {
		// target.doAction(actionMap[key]);
	// }

	// void onMouseMove(pInt x, pInt y, pInt xrel, pInt yrel) {
		// // if (abs(xrel) > 0)
			// // target.doAction(mouseActions[0], x);
		// // if (abs(yrel) > 0)
			// // target.doAction(mouseActions[1], y);
		// // window.setCursorPos(int(window.width/2), int(window.height/2));


		// getCursorPos(cursorX, cursorY);

		// int cursorXDif = cursorX-int(window.width/2);
		// int cursorYDif = cursorY-int(window.height/2);

		// if (abs(cursorYDif) > 0) {
			// target.doAction(mouseActions[1], cursorYDif);
		// }
		// if (abs(cursorXDif) > 0) {
			// target.doAction(mouseActions[0], cursorXDif);
		// }
		// window.setCursorPos(int(window.width/2), int(window.height/2));
	// }

	// void register(pKeyCode key, InputControllerAction action, int t) {
		// actionMap[key] = action;
		// if (t & T_DOWN == T_DOWN)
			// window.Input.keyDown(key) += KeyStateCallback(this.onKeyDown);
		// if (t & T_UP == T_UP)
			// window.Input.keyUp(key) += KeyStateCallback(this.onKeyUp);
	// }

	// void registerMouseMove() {
		// window.setCursorPos(int(window.width/2), int(window.height/2));
		// mouseActions.add(PA_cursorX);
		// mouseActions.add(PA_cursorY);
		// window.Input.mouseMove() += MouseMoveCallback(this.onMouseMove);
	// }

	// ///////////////////////////////


	bool active {
		get const {
			return controllerActive;
		}
		set {
			if (controllerActive && !value) {
				echo("value is false\n");
				if (controlStep) {
					CONTROL.stepped -= StepCallback(this.eval);
				} else {
					timer.elapsed -= Action(this.eval);
				}
				window.GrabInput = false;
				CONTROL.Input.mouseMove() -= MouseMoveCallback(this.evalMouseMove);
			} else if (!controllerActive && value) {
				if (mouseControlSet) {
					window.GrabInput = true;
					CONTROL.Input.mouseMove() += MouseMoveCallback(this.evalMouseMove);
				}
				if (controlStep) {
					CONTROL.stepped += StepCallback(this.eval);
				} else {
					timer.elapsed += Action(this.eval);
				}
			}
			controllerActive = value;
		}
	}

	void eval(pFloat t) {
		this.eval();
	}

	void eval() {
		Array<int> pp;
		for (uint i = 0; i < pairs.length(); i++) {
			bool pressed = false;
			if (pairs[i].type == C_KB) {
				if (CONTROL.Input.keyIsPressed(pairs[i].key)) {
					pressed = true;
				}
			} else {
				if (CONTROL.Input.mouseButtonIsPressed(pairs[i].button)) {
					pressed = true;
				}
			}
			if (pressed) {
				pp.add(pairs[i].id);
				if (!pairs[i].repeat && checkPrevPressed(arrPrevPressed, pairs[i])) {
					continue;
				} else if (pairs[i].trigger == T_DOWN) {
					target.doAction(pairs[i].val, T_DOWN);
				}
			} else if(checkPrevPressed(arrPrevPressed, pairs[i]) && pairs[i].trigger == T_UP) {
				target.doAction(pairs[i].val, T_UP);
			}
		}
		arrPrevPressed = pp;
	}

	private bool checkPrevPressed(Array<int>@ arrPrevPressed, InputControlPair@ pair) {
		for (uint i = 0; i < arrPrevPressed.length(); i++) {
			if (pair.id == arrPrevPressed[i]) {
				return true;
			}
		}
		return false;
	}

	void setMouseControl(InputControllerAction xAction, InputControllerAction yAction, Window@ w) {
		@window = @w;
		if (mouseControlSet) {
			mouseActions.resize(0);
		}
		mouseControlSet = true;
		mouseActions.add(xAction);
		mouseActions.add(yAction);
	}

	void evalMouseMove(int x, int y, int xRel, int yRel) {
		target.doAction(mouseActions[0], xRel);
		target.doAction(mouseActions[1], yRel);
	}


	void remove() {
		echo("remove controller\n");
		if (@timer != null) {
			@timer = null;
		}
		@target = null;

	}
}
