
#include "../../input/InputController.as";
#include "../Weapon/ProjectileWeapon.as";
#include "../Weapon/RayGun.as";
#include "../../misc/geom.as";

class PlayerInfo : iRefObj
{
	PlayerInfo(pUByte id) 
	{
		networkID = id; 
	}

	pUByte networkID = 255;
}

class Player: InputControllerInterface {

	private Object@ playerBody;
	
	Array<Weapon@> weapons;
	pUInt selWeapon = 0;
	Object@ head;
	Object@ body;
	Camera@ cam;
	Object@ damageEffect;
	Object@ pickupEffect;
	Client@ client;
	
	Vector3 camVector = Vector3(0,-1,0);
	bool moving = false;
	int yRot = 0;
	float velocity = 0;
	float maxVelocity = 2;
	Vector3 direction = Vector3(0,0,0);
	//pUByte animState = 0;
	
	uint damageEffectCounter = 0;
	uint pickupEffectCounter = 0;
	
	Scene@ scene;
	CharacterController@ controller;
	
	Player() {
	}
	
	~Player() {
		echo ("Player destroyed");
		scene.remove(controller.weapon);
		scene.remove(controller.body);
		if (damageEffectCounter > 0) {
			CONTROL.stepped -= StepCallback(this.checkDamageEffect);
		}
		EFFECT_OVERLAY_SCENE.remove(damageEffect);
		EFFECT_OVERLAY_SCENE.remove(pickupEffect);
	}
	
	
	Player(Scene@ s, Timer@ t, Camera@ playerCam) {
		//echo(String(Vector3(-1,1,0).normalized().x)+","+String(Vector3(-1,1,0).normalized().y)+","+String(Vector3(1,1,1).normalized().z)+"\n");
		@scene = @s;
		@cam = @playerCam;
		//body.scale(Vector3(0.5,0.5,1.7));
		@controller = CharacterController(scene, t, playerCam);
		controller.body.setPosition(LEVEL.spawnLocations[0]);
		//controller.body.setPosition(0,-20,1);
		@body = controller.body;
		scene.add(controller.body);
		//scene.add(controller.weapon);
		WeaponHitCallback@ mHitCallback;
		addWeapon(RayGun(100, 1000, mHitCallback, true));
		
		auto@ listener = AL_CONTEXT.getListener();
		body.link.add(listener);
		
		EFFECT_OVERLAY_CAM.setPosition(0,-1,0);		
		
		@damageEffect = objectFactory.createPoster("../../Assets/3D/texture/damage_poster.png");
		damageEffect.position = Vector3(0,-2,0);
		EFFECT_OVERLAY_SCENE.add(damageEffect);

		
		@pickupEffect = objectFactory.createPoster("../../Assets/3D/texture/pickup_poster.png");
		pickupEffect.model.setDrawMode(DM_ADDITIVE);
		pickupEffect.position = Vector3(0,-2,0);
		EFFECT_OVERLAY_SCENE.add(pickupEffect);
	
		
		auto@ mat = damageEffect.model.getSurface(0).material;
		mat.type = MT_TRANSLUCENT;
		mat.mode = DM_EMISSIVE;		
		
	}
	
	void showDamageEffect() {
		damageEffectCounter = 6;	
		CONTROL.stepped += StepCallback(this.checkDamageEffect);
		damageEffect.position = Vector3(0,0,0);
	
	}
	void checkDamageEffect(float) {
		if (damageEffectCounter-- < 1) {
			CONTROL.stepped -= StepCallback(this.checkDamageEffect);
			damageEffect.position = Vector3(0,-2,0);
			damageEffectCounter = 0;
		}
	}	
	
	void showPickupEffect() {
		pickupEffectCounter = 6;	
		CONTROL.stepped += StepCallback(this.checkPickupEffect);
		pickupEffect.position = Vector3(0,0,0);
	
	}
	void checkPickupEffect(float) {
		if (pickupEffectCounter-- < 1) {
			CONTROL.stepped -= StepCallback(this.checkPickupEffect);
			pickupEffect.position = Vector3(0,-2,0);
			pickupEffectCounter = 0;
		}
	}		
	
	void addWeapon(Weapon weapon) {
		weapons.add(weapon);
	}
	
	void selectWeapon(int weaponId) {
	
	}
	
	void doAction(InputControllerAction action, int val) {
		switch(action){
			case PA_fireWeapon:
				{
					if (client !is null) {
						//echo("fire weapon");
						Transform xform(cam.xForm);
						xform.relTranslate(0,0.6,0);
						if(weapons[selWeapon].fire(xform, 100)){
							controller.playWeaponAnim();
						}
						client.fireWeapon(weapons[selWeapon].type, xform);
						
					}	
				}
				break;
		}
	}
	
	void playerCameraPosition(){
		//echo(String(playerBody.position.x)+","+String(playerBody.position.y)+","+String(playerBody.position.z)+"\n");
		//MAIN_CAM.position = playerBody.position;
		//MAIN_CAM.setRotation(playerBody.quaternion);
	}


}
