class PlayerController:InputControllerInterface{
	Object@ player;
	Camera@ playerCam;
	Vector3 movementVector = Vector3(0,0,0);
	Vector3 directionVelocity = Vector3(0,0,0);
	Vector3 directionVector = Vector3(0,0,0);
	Vector3 playerRotation = Vector3(0,0,0);
	float maxSpeed = 10;
	PlayerController() {

	}

	void doAction(InputControllerAction action, int val){
		switch(action){

			case PA_moveLeft:
			movementVector.x = -1;
			break;

			case PA_moveRight:
			movementVector.x = 1;
			break;

			case PA_moveForward:
			movementVector.y = 1;
			break;

			case PA_moveBackward:
			movementVector.y = -1;
			break;
			
			case PA_jump:
			if(player.proxy.character.onGround()){
				directionVelocity.z= 60;
			} else{
				directionVelocity.z = 0;
			}
			break;

			case PA_cursorX:
			{
			//echo(String(val)+"\n");
				//playerRotation.x += val;
				//echo(String(val)+", ");
				playerCam.rotate(Vector3(0,0,-1), PI*(val*0.001));		
				break;
			}
			case PA_cursorY:
			{
			//echo(String(val)+"\n");
			//playerRotation.y += val;
				
				playerCam.relRotate(Vector3(1,0,0), PI*(val*0.001));		
				break;
			}
		}
		//echo(String(movementVector.x)+","+String(movementVector.y)+","+String(movementVector.z)+"\n");

	}

	// void updaterPlayerControlls(){
		// //reset movementVector
		// directionVelocity.x = calculateDirectionalVelocity(movementVector.x, directionVelocity.x);
		// directionVelocity.y = calculateDirectionalVelocity(movementVector.y, directionVelocity.y);

		// //echo(String(directionVelocity.x)+","+String(directionVelocity.y)+","+String(directionVelocity.z)+"\n");

		// if(!player.proxy.character.onGround()){
			// directionVelocity.z = 0;
		// }

		// player.linVel = directionVelocity;

		// player.rotate(0,0,1,PI*-0.001*playerRotation.x);
		// //player.relRotate(1,0,0,PI*0.002*playerRotation.y);

		// //playerCam.rotate(0,0,1,PI*-0.001*playerRotation.x);
		// //playerCam.relRotate(1,0,0,PI*-0.001*playerRotation.y);

		// player.linVel = player.quaternion.rotVector3(directionVelocity);
		// playerCam.position = player.position;
		// echo(String(playerRotation.x)+"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
		// playerRotation = Vector3(0,0,0);

		// if(player.proxy.character.onGround()) movementVector = Vector3(0,0,0);

	// }

	float calculateDirectionalVelocity(float direction, float velocity){
		if(direction != 0){
			float velIncrease = 0;
			if(direction == 1 && velocity < maxSpeed){

				velIncrease = 0.2;

				if(velocity < 0){

					velocity = 0.3;
				}

				velocity += velIncrease;

				if(velocity > maxSpeed*1) velocity = maxSpeed*1;


			} else if(direction == -1 && velocity > maxSpeed*-1) {
				velIncrease = -0.2;

				if(velocity > 0){
					velIncrease = -0.3;
				}
				velocity += velIncrease;


				if(velocity < maxSpeed*-1) velocity = maxSpeed*-1;
			}

		} else {		
			if(abs(velocity) >= 0.01){

				velocity = velocity*0.8;

			} else {
				velocity = 0;
			}
		}

		return velocity;

	}

	void init(InputController@ ic, Object@ ob, Camera@ cam){

		@player = ob;
		@playerCam = cam;
		ic.pairs.add(InputControlPair(PK_a, PA_moveLeft));
		ic.pairs.add(InputControlPair(PK_d, PA_moveRight));
		ic.pairs.add(InputControlPair(PK_w, PA_moveForward));
		ic.pairs.add(InputControlPair(PK_s, PA_moveBackward));
		ic.pairs.add(InputControlPair(PK_SPACE, PA_jump));

		//init mouse;
		ic.setMouseControl(PA_cursorX,PA_cursorY);
		ic.setActive();
		//MAIN_TIMER.elapsed += Action(this.updaterPlayerControlls);

	}

	
}