

class CharacterController:InputControllerInterface {
	private Timer@ timer;
	private Camera@ camera;
	Object@ body;
	Object@ weapon;
	Animation@ weaponAnim;
	bool disabled = false;
	private Scene@ scene;
	Vector3 tempGravOrigin = Vector3(0,0,-25);
	Vector3 localGravVector = Vector3(0,0,-9);
	float turnSpeed = 0.002;
	// Contains the currently set directions of movement set on the body
	// directions[0] : the sum of all directions set on the body
	// directions[1] : the forwards direction set on the body
	// directions[2] : the backwards direction set on the body
	// directions[3] : the left direction set on the body
	// directions[4] : the right direction set on the body
	private Array<Vector3> directions(5);
	// The forward/backward direction used when moving
	private Vector3 forwardDir(0,1,0);
	// The left/right direction used when moving
	private Vector3 sideDir(1,0,0);
	// The current speed of the body
	float speed = 12.0;
	float jumpSpeed = 11.0;
	Array<CollisionInfo@> collisionActions;
	int jumpCounter = 0;
	private float rotateX = 0.0;
	private float rotateY = 0.0;
	private float yRot = 0.0;
	pUByte animState = 0;
	int playWeapon = 0;
	CharacterController() {

	}

	CharacterController(Scene@ s, Timer@ t, Camera@ c) {
		@camera = @c;
		@scene = @s;

		// @body = objectFactory.load("../../Assets/3D/character_animation.fbx");
		// Animation@ an = pool.getAnimation("../../Assets/3D/character_animation.fbx:Take 001");
		// // player.animator.play(SubAnimation(an, 0, 5), false);
		// @body.animator = Animator();
		// body.animator.play(an, true);
		//@body = objectFactory.createCapsule(0.25, 1.3);
		//@timer = t;
		@weapon = objectFactory.load("../../Assets/3D/c64_gun_hud.fbx");
		@weaponAnim = pool.getAnimation("../../Assets/3D/c64_gun_hud.fbx:Take 001");
		@weapon.animator = Animator();


		@body = Object();
		@body.proxy = s.world.createCharacterProxy();
		body.proxy.offset = Transform(Quaternion(), Vector3(0,0, 0.90));
		body.proxy.collisionGroupBitmask = COL_CHARACTER;
		body.proxy.collidesWithBitmask = COL_ALL & ~COL_BONES;
		CharacterProxy@ cp = cast<CharacterProxy>(body.proxy);
		cp.jumpspeed = jumpSpeed;
		body.proxy.addCapsule(0.25, 1.3, 1);

		//body.proxy.colliding += CollidingCallback(this.colliding);
		//timer.elapsed += Action(this.updateVel);
		LEVEL.gravityManager.registerEntity(body);
		CONTROL.stepped += StepCallback(this.step);
	}
	
	void playWeaponAnim() {
		echo("playWeaponAnim");
		//playWeapon = 1;
		weapon.animator.play(weaponAnim, false, 1);
	}
	
	Array<bool> keysPressed = {false, false, false, false};
	
	bool checkKeysPressed() {
		for (uint i = 0; i < keysPressed.length(); i++) {
			if (keysPressed[i]) return true;
		}
		return false;
	}
	
	void doAction(InputControllerAction action, int val) {


		switch(action){
			case PA_moveForward:
				this.moveForward();
				keysPressed[0] = (val == 2) ? true : false;		
				break;
			case PA_moveBackward:
				this.moveBackward();
				keysPressed[1] = (val == 2) ? true : false;
				break;
			case PA_moveLeft:
				this.strafeLeft();
				keysPressed[2] = (val == 2) ? true : false;
				break;
			case PA_moveRight:
				this.strafeRight();
				keysPressed[3] = (val == 2) ? true : false;

				break;
			case PA_jump:
				this.jump();
				break;
			case PA_cursorX:
				rotateX += val;
				break;
			case PA_cursorY:
				rotateY += val*mouseUp;//mouseUp is in init
				break;
		}
		if (!checkKeysPressed()) {
			animState = 0;
		}
		//echo(String(animState));

	}

	private void jump() {
		//jumpCounter = 500;
		CharacterProxy@ cp = cast<CharacterProxy>(body.proxy);
		if (cp.onGround()) {
			cp.jump();
			animState = 5;
		}	
	}
	private void moveForward() {
		animState = 1;
		if (directions[1].length2() > 0) {
			directions[0] -= directions[1];
			directions[1] = Vector3(0,0,0);
			return;
		}
		directions[1] = forwardDir;
		directions[0] += directions[1];
	}
	private void moveBackward() {
		animState = 2;
		if (directions[2].length2() > 0) {
			directions[0] -= directions[2];
			directions[2] = Vector3(0,0,0);
			return;
		}
		directions[2] = forwardDir*-1.0f;
		directions[0] += directions[2];
	}
	private void strafeLeft() {
		animState = 3;
		if (directions[3].length2() > 0) {
			directions[0] -= directions[3];
			directions[3] = Vector3(0,0,0);
			return;
		}
		directions[3] = sideDir*-1.0f;
		directions[0] += directions[3];
	}
	private void strafeRight() {
		animState = 4;
		if (directions[4].length2() > 0) {
			directions[0] -= directions[4];
			directions[4] = Vector3(0,0,0);
			return;
		}
		directions[4] = sideDir;
		directions[0] += sideDir;
	}


	void colliding(Entity@ ent1, Entity@ ent2, CollisionInfo@ ci) {
		//echo(String(normal.x)+", "+String(normal.y)+", "+String(normal.z)+"\n");
		collisionActions.add(ci);
	}
	private void step(pFloat dt) {

		CharacterProxy@ cp = cast<CharacterProxy>(body.proxy);

		if (disabled) {
			cp.move(Vector3(0,0,0));
			return;
		}

		//Vector3 gravityVector = getDirectionVector(body.position, tempGravOrigin);
		//cp.gravity = gravityVector * localGravVector.length();
		//cp.gravity = gravityManager.calcGrav(body.position);
		// after the gravity has been set, the body has a new orientation
		// rotate the body over it's up axis in a frame independent way
		if (rotateX != 0) {
			//body.relRotate(Quaternion(Vector3(0,0,-1), turnSpeed * rotateX * dt).normalized());
			body.relRotate(Quaternion(Vector3(0,0,-1), rotateX * 0.005).normalized());
			rotateX = 0;
		}
		// rotate the camera over it's side axis in a frame independent way
		if (rotateY != 0) {
			//yRot += turnSpeed * rotateY * dt;
			if (abs(yRot + rotateY*0.01) < 1.6) {
				yRot += rotateY*0.01;
			}
			rotateY = 0;
			//echo(String(yRot));
		}

		if (camera !is null) {
			camera.quaternion = body.quaternion * Quaternion(Vector3(1,0,0), yRot).normalized();
			camera.position = body.position + body.quaternion.rotVector3(Vector3(0,0,1.70));
			weapon.quaternion = camera.quaternion;//body.quaternion * Quaternion(Vector3(1,0,0), yRot).normalized();
			weapon.position =  camera.position + camera.quaternion.rotVector3(Vector3(0.4,1.0,-0.4));

		}
		//camera.relTranslate(0,-5,0);

		// if we are moving forwards and backwards at the same time or left and right at the same time,
		// we don't move at all
		if ((directions[1].length2() == 0.0 && directions[2].length2() == 0.0 &&
			directions[3].length2() > 0.0 && directions[4].length2() > 0.0) ||
			(directions[1].length2() > 0.0 && directions[2].length2() > 0.0 &&
			directions[3].length2() == 0.0 && directions[4].length2() == 0.0) ||
			(directions[1].length2() == 0.0 && directions[2].length2() == 0.0 &&
			directions[3].length2() == 0.0 && directions[4].length2() == 0.0))
			directions[0] = Vector3(0,0,0);

		// set the linear velocity of the body with the correct direction and magnitude
		Vector3 linVel = body.quaternion.rotVector3(directions[0]);
		if (linVel.length2() > 0)
			linVel = linVel.normalized() * speed;

		cp.move(linVel);
	}
}
