#include "Ammo.as";
#include "PickingCone.as";
#include "Projectile.as";

class RayGun : Weapon {
	Timer@ cooldownTimer;
	Camera@ camera;
	int damage;
	Projectile@ projectile;
	bool onCooldown;
	OpenALSource@ fxSrcGun;
	OpenALContext@ fxContext;
	Sound@ SND_WEAPON_1;
	RayGun(int _damage, int firerate, WeaponHitCallback@ hitcallback, bool local = false)
	{
		super(WT_RayGun, hitcallback);

		damage = _damage;

		@cooldownTimer = CONTROL.createTimer(firerate, false);
		cooldownTimer.elapsed += Action(this.cooldownReset);

		@fxSrcGun = AL_CONTEXT.createSource();

		MAIN_SCENE.add(fxSrcGun);


		if (local) {
			fxSrcGun.volume = 0.4;
			@SND_WEAPON_1 = pool.getSound("../../Assets/Sounds/Effects/gun.wav");
		}
		else {
			@SND_WEAPON_1 = pool.getSound("../../Assets/Sounds/Effects/gun_mono.wav");
		}

	}

	~RayGun()
	{
		MAIN_SCENE.remove(fxSrcGun);
	}

	void cooldownReset()
	{
		onCooldown = false;
	}

	bool fire(Transform xForm, pUByte id)
	{

		if (onCooldown) return false;

		onCooldown = true;
		cooldownTimer.start();

		Vector3 v = xForm.quaternion.rotVector3(Vector3(0, 1, 0)) * range;
		v += xForm.position;

		fxSrcGun.position = xForm.position;
		echo ("Playing sound from position: " + xForm.position.toString());

		@projectile = Projectile(xForm);
		fxSrcGun.stop();
		if(!EFFECTS_MUTED)
		fxSrcGun.play(SND_WEAPON_1);

		MAIN_SCENE.world.pickClosestObject(xForm.position,v , PickingCallback(this.pickCallback));
		return true;
	}

	bool pick(Transform xForm) {
		if (onCooldown) return false;
		onCooldown = true;
		cooldownTimer.start();
		Vector3 v = xForm.quaternion.rotVector3(Vector3(0, 1, 0)) * range;
		v += xForm.position;
		MAIN_SCENE.world.pickClosestObject(xForm.position,v , PickingCallback(this.pickOnlyCallback));
		return true;
	}

	void pickOnlyCallback(Object@ obj, Vector3 pos, Vector3 normal)
	{
		if(@obj != null) {
			if (@mHitCallback != null) {
				mHitCallback(type, obj, pos, normal, damage);
			}
		}
	}

	void pickCallback(Object@ obj, Vector3 pos, Vector3 normal)
	{
		float distance = 100;
		Vector3 nv = pos-projectile.transform.position;
		float nd = nv.length();
		//makeCube(pos, Color(255,0,0,255));
		//makeCube(projectile.transform.position, Color(0,0,255,255));
		bool splash = false;
		if(@obj != null) {
			if (nd < distance) {
				distance = nd;
				splash = true;
			}
			//distance = (nd < distance) ? nd : distance;
			if (@mHitCallback != null) {
				mHitCallback(type, obj, pos, normal, damage);
			}
		}
		projectile.createBeam(1000, distance, splash, pos, normal);
	}

	void makeCube(Vector3 pos, Color c) {
		Object@ o = objectFactory.createCube();
		o.model.setDrawMode(DM_ADDITIVE);
		o.model.setColor(c);
		o.setPosition(pos);
		o.setScale(Vector3(0.2, 0.2, 0.2));
		MAIN_SCENE.add(o);
	}


	Object@ Body {
		get {return body;}
		set {@body = value;}
	}
}
