#include "Weapon.as";

class ProjectileWeapon:Weapon {

	int falloff;
	int damage;
	int ProjectilesPerShot;
	PickingCone@ pickingCone;
	Camera@ camera;

	ProjectileWeapon(Object@ body, Camera@ cam, int fo = 100, int d = 20) {
		
		super(WT_ShotGun, null);
		
		@camera = cam;
		@body = body;
		falloff = fo;
		damage = d;
		ProjectilesPerShot = 10;
		@pickingCone = PickingCone();

	}

	ProjectileWeapon(Object@ body, Camera@ cam, PickingCone@ cone, int d = 20, int fo = 100,int pps = 1) {
	
		super( WT_ShotGun, null);
		
		@camera = cam;
		@body = body;
		falloff	= fo;
		damage = d;
		ProjectilesPerShot = pps;
		@pickingCone = cone;
	}

	bool fire(Transform xForm, pUByte id) {
		for(int i = 0; i<ProjectilesPerShot; i++){
			Vector3 projectileVector = pickingCone.ProjectProjectile(xForm.position, xForm.quaternion, falloff);
			Object@ o = objectFactory.createCube();
			o.setPosition(projectileVector);
			MAIN_SCENE.add(o);
			MAIN_SCENE.world.pickClosestObject(camera.position, projectileVector, PickingCallback(this.cb));
		}
		return true;
	}

	void cb(Object@ obj, Vector3 pos, Vector3 normal)
	{
		if(@obj != null) {

			InteractableEntity@ IE = reg.GetEntity(@obj);
			
			if(@IE != null)
				if(IE.Type == IE_Object) {
					InteractableObject blu = cast<InteractableObject>(@IE);
					blu.hit(damage);
				}
		}

	}

	void reload() {

	}

}

