
class Projectile : iRefObj{
	Transform transform;
	
	Object@ projectile;
	Array<Object@> arrP;
	Timer@ timer;
	int t = 0;
	float beamSegmentLength = 0.5;
	bool splash = false;
	PointLight@ SplashLight;
	
	Projectile(Transform t) {
		transform = t;
		@SplashLight = PointLight();
		SplashLight.color = RED;
	}
	~Projectile() {
		echo("destruct projectile");
	}
	void createBeam(int lifetime, float range, bool s, Vector3 pos, Vector3 normal) {
		splash = s;
		@timer = CONTROL.createTimer(10, true);
		timer.elapsed += Action(this.removeProjectile);	
		
		int dRange = int(range);
		
		Vector3 target = transform.quaternion.rotVector3(Vector3(-0.3, range, 0.3)); 
		Vector3 orientation = target.normalized();
		float angle = acos(Vector3(0,1,0).dot(orientation));
		Vector3 axis = Vector3(0,1,0).cross(orientation);
		for (int i = 0; i < range*2; i++) {
			Vector3 p = (orientation * (i*0.5)) + transform.position +  transform.quaternion.rotVector3(Vector3(0.3, 2.05, -0.3));
			Object@ projectile;
			Object@ projectile2; 
			if (splash && i  > (range*2)-1) {
				@projectile = objectFactory.createSphere();
				@projectile2 = objectFactory.createSphere();
				projectile.setScale(Vector3(0.5, 0.5, 0.5));
				projectile2.setScale(Vector3(0.2, 0.2, 0.2));
				SplashLight.range = 2;
				MAIN_SCENE.add(SplashLight);
				SplashLight.setPosition(pos + normal * 0.5);
				
			} else {
				@projectile = objectFactory.createCube();
				@projectile2 = objectFactory.createCube();
				projectile.setScale(Vector3(0.09, beamSegmentLength, 0.4));
				projectile2.setScale(Vector3(0.04, beamSegmentLength, 0.2));	
			}
			
			projectile.model.setDrawMode(DM_ADDITIVE);
			projectile.model.setColor(Color(255,0,0,255));
			projectile.setRotation(axis, angle);
			projectile.setPosition(p);
			
			arrP.add(projectile);
			MAIN_SCENE.add(projectile);	
			
			projectile2.model.setDrawMode(DM_ADDITIVE);
			projectile2.model.setColor(Color(255,0,255,255));
			projectile2.setRotation(axis, angle);
			projectile2.setPosition(p);
					
			arrP.add(projectile2);
			MAIN_SCENE.add(projectile2);			
		}
		
		//Vector3 p = (transform.quaternion.rotVector3(Vector3(0, 1, 0)) * ((range / 2)+1)) + transform.position;
		@arrP[uint(range-1)].userRef = this;
		timer.start();
	}
	
	void removeProjectile() {
		float initScaleX = 0.09;
		float initScaleZ = 0.4;
		int time = 20;
		if (t++ < time) {
			float scale = float(time - t)/float(time); 		
			for (uint i = 0; i < arrP.length(); i+=2) {
				if (splash && i == arrP.length() -2) {
					float scale2 = float(t)/float(time)*4;
					arrP[i].setScale(scale2*initScaleZ, scale2*0.8, scale2*initScaleZ);
					arrP[i+1].setScale(scale2*(initScaleZ/2), scale2*0.8, scale2*(initScaleZ/2));
					SplashLight.range *= 1.1;
					
				} else {
					arrP[i].setScale(scale*initScaleX, beamSegmentLength, scale*initScaleZ);
					arrP[i+1].setScale(scale*(initScaleX/2), beamSegmentLength, scale*(initScaleZ/2));
				}
			}				
		} else {
			timer.elapsed -= Action(this.removeProjectile);
			for (uint i = 0; i < arrP.length(); i++) {
				MAIN_SCENE.remove(arrP[i]);
			}
			MAIN_SCENE.remove(SplashLight);
			@arrP[arrP.length()-1].userRef = null;	
			arrP.length = 0;
		}
		
	}
	
}