#include "ControlsElement.as";
#include "resolutionElement.as";
#include "SoundElement.as";

UIElement@ controlsElement;
UIElement@ resolutionElement;
UIElement@ soundElement;

UIElement@ OptionElement() {
  Color buttonColor = Color(163,163,163,255);
  int offset = 170;
  UIElement@ element = UIElement(Vector3(0,1,10),450,400);
  element.setBackground(Color(66,80,88,255));

  Label@ title = Label(aldoFont,"Options");
  title.setScale(0.8);
  element.addChild(@title);
  element.setChildPosition(@title,Vector3(-80,0,0+offset));

  //controls
  UIElement@ buttonControls = UIElement(Vector3(0,0,0), 300, 75);
  buttonControls.setBackground(buttonColor);
  Label@ controlsText = Label(aldoFont, "Controls");
  controlsText.setScale(0.8);
  element.addChild(@buttonControls);
  buttonControls.addChild(controlsText);
  element.setChildPosition(@buttonControls,Vector3(0,0,-130+offset));
  buttonControls.setChildPosition(@controlsText,Vector3(-115,1,35));

  @buttonControls.onClick = @openControlsMenu;

  @controlsElement = ControlsElement();
  controlsElement.addToScene(INTERFACE_SCENE);
  controlsElement.visible = false;
  /////////////////////////////

  //Resolution
  UIElement@ buttonResolution = UIElement(Vector3(0,0,0), 300, 75);
  buttonResolution.setBackground(buttonColor);
  Label@ resolutionText = Label(aldoFont, "Resolution");
  resolutionText.setScale(0.8);
  element.addChild(@buttonResolution);
  buttonResolution.addChild(resolutionText);
  element.setChildPosition(@buttonResolution,Vector3(0,0,-220+offset));
  buttonResolution.setChildPosition(@resolutionText,Vector3(-130,1,35));


  @buttonResolution.onClick = @openResolutionMenu;

  @resolutionElement = ResolutionElement();
  resolutionElement.addToScene(INTERFACE_SCENE);
  resolutionElement.visible = false;
  /////////////////////////////

  //Resolution
  UIElement@ buttonSound = UIElement(Vector3(0,0,0), 300, 75);
  buttonSound.setBackground(buttonColor);
  Label@ soundText = Label(aldoFont, "Sound");
  soundText.setScale(0.8);
  element.addChild(@buttonSound);
  buttonSound.addChild(soundText);
  element.setChildPosition(@buttonSound,Vector3(0,0,-310+offset));
  buttonSound.setChildPosition(@soundText,Vector3(-130,1,35));


  @buttonSound.onClick = @openSoundMenu;

  @soundElement = SoundElement();
  soundElement.addToScene(INTERFACE_SCENE);
  soundElement.visible = false;
  /////////////////////////////


  //close button
  UIElement@ closeButton = CloseElement();
	element.addChild(@closeButton);
	element.setChildPosition(@closeButton,Vector3(205,1,15+offset));
  closeButton.visible = false;
  /////////////////////////////

  return @element;
}

void openControlsMenu(UIEventInfo event) {
	setMenu(lvl_2, true, controlsElement);
}

void openResolutionMenu(UIEventInfo event) {
	setMenu(lvl_2, true, resolutionElement);
}

void openSoundMenu(UIEventInfo event) {
	setMenu(lvl_2, true, soundElement);
}
