KeyBindElement@ keybinderForward;
KeyBindElement@ keybinderBackward;
KeyBindElement@ keybinderRight;
KeyBindElement@ keybinderLeft;
KeyBindElement@ keybinderJump;

UIElement@ ControlsElement() {
  Color buttonColor = Color(163,163,163,255);
  int offset = 195;

  UIElement@ element = UIElement(Vector3(0,1,-15),450,450);
  element.setBackground(Color(66,80,88,255));


  Label@ title = Label(aldoFont,"Controls");
  title.setScale(0.8);
  element.addChild(@title);
  element.setChildPosition(@title,Vector3(-110,0,0+offset));

  //movement text
  Label@ forwardText = Label(aldoFont,"Forward");
  Label@ backwardText = Label(aldoFont,"Backward");
  Label@ leftTest = Label(aldoFont,"Left");
  Label@ rightText = Label(aldoFont,"Right");
  Label@ jumpText = Label(aldoFont,"Jump");
  Label@ invert = Label(aldoFont,"Inverted mouse");

  float scale = 0.7;
  forwardText.setScale(scale);
  backwardText.setScale(scale);
  leftTest.setScale(scale);
  rightText.setScale(scale);
  jumpText.setScale(scale);
  invert.setScale(0.5);

  element.addChild(@forwardText);
  element.addChild(@backwardText);
  element.addChild(@leftTest);
  element.addChild(@rightText);
  element.addChild(@jumpText);
  element.addChild(@invert);


  int textSize = -50;
  int textOffset = -70;
  int textHorAlign = -180;

  element.setChildPosition(@forwardText,Vector3(30+textHorAlign,0,textOffset+(textSize*0)+offset));
  element.setChildPosition(@backwardText,Vector3(0+textHorAlign,0,textOffset+(textSize*1)+offset));
  element.setChildPosition(@leftTest,Vector3(125+textHorAlign,0,textOffset+(textSize*2)+offset));
  element.setChildPosition(@rightText,Vector3(105+textHorAlign,0,textOffset+(textSize*3)+offset));
  element.setChildPosition(@jumpText,Vector3(105+textHorAlign,0,textOffset+(textSize*4)+offset));
  element.setChildPosition(@invert,Vector3(-35+textHorAlign,0,textOffset+(textSize*5)+offset-20));
  //////////////// end movement text

  //movement input
  @keybinderForward = KeyBindElement("forward", @ICPForwardUp,@ICPForwardDown);
  @keybinderBackward = KeyBindElement("backward",@ICPBackwardUp,@ICPBackwardDown);
  @keybinderLeft = KeyBindElement("left", @ICPLeftUp,@ICPLeftDown);
  @keybinderRight = KeyBindElement("right", @ICPRightUp,@ICPRightDown);
  @keybinderJump = KeyBindElement("jump", @ICPJump);

  element.addChild(@keybinderForward.element);
  element.addChild(@keybinderBackward.element);
  element.addChild(@keybinderLeft.element);
  element.addChild(@keybinderRight.element);
  element.addChild(@keybinderJump.element);

  int inputOffset = -103;
  int inputSize = -(45+5);
  int inputHorAlign = 110;

  element.setChildPosition(@keybinderForward.element,Vector3(inputHorAlign,0,(inputSize*0)+inputOffset+offset));
  element.setChildPosition(@keybinderBackward.element,Vector3(inputHorAlign,0,(inputSize*1)+inputOffset+offset));
  element.setChildPosition(@keybinderLeft.element,Vector3(inputHorAlign,0,(inputSize*2)+inputOffset+offset));
  element.setChildPosition(@keybinderRight.element,Vector3(inputHorAlign,0,(inputSize*3)+inputOffset+offset));
  element.setChildPosition(@keybinderJump.element,Vector3(inputHorAlign,0,(inputSize*4)+inputOffset+offset));
  //////////////// end movement input

  bool mouseState = false;
  if(mouseUp == 1){
    mouseState = true;
  }
  bool loadedMouseState;
  if(GAME_SETTINGS.loadBool("mouseDir", loadedMouseState)){
    mouseState = loadedMouseState;
    setMouseInversion(mouseState);
  }
  CheckBox@ invertedMouse = CheckBox(mouseState);
  element.addChild(@invertedMouse.element);
  element.setChildPosition(@invertedMouse.element,Vector3(inputHorAlign,0,-360+offset));
  @invertedMouse.checkboxEvent = @setMouseInversion;

  //closebutton
  UIElement@ closeButton = CloseElement();
	element.addChild(@closeButton);
	element.setChildPosition(@closeButton,Vector3(205,0,15+offset));
  closeButton.visible = false;
  //////////////// end close button
  return @element;
}

void setMouseInversion(bool state){
  if(state){
    mouseUp = 1;
  } else {
    mouseUp = -1;
  }
  GAME_SETTINGS.saveValue("mouseDir",state);
  GAME_SETTINGS.save();
}

class KeyBindElement{
  Map<int, String> mapInputKeys;
  UIElement@ element;
  UIElement@ popup;
  Label@ key;
  bool isListening = false;
  InputControlPair@ up;
  InputControlPair@ down;
  String id;

  KeyBindElement(String _id, InputControlPair@ _up, InputControlPair@ _down = null){
    id = _id;
    @up = @_up;
    @down = @_down;
    addKeyDescriptions();
    @element = UIElement(Vector3(0,0,0),130,45);

    element.setBackground(Color(32,32,32,255));
    @element.onClick = UIEvent(this.onClickEvent);
    @key = Label(aldoFont,"");
    key.scale(0.5);

    @popup = UIElement(Vector3(0,0,0),300,300);
    popup.setBackground(Color(66,80,88,255));
    element.addChild(@key);
    element.setChildPosition(@key, Vector3(-60,1,22));
  //  element.addChild(@popup);
    //element.setChildPosition(@popup,Vector3(0,3,0));
    popup.visible = false;
    Label@ popupText = Label(aldoFont,"Press ANY key");

    popup.addChild(@popupText);

    //get pKeyCode from save file if available
    uint loadedCode;
    if(GAME_SETTINGS.loadUint(id,loadedCode)){
      bindCode(pKeyCode(loadedCode));
    }
    key.text = mapInputKeys[up.key];
  }

  void onClickEvent(UIEventInfo info){
    if(!isEscOverride){
      element.setBackground(Color(163,163,163,255));
      //popup.visible = !popup.visible;
      setAnyKeyListener();
    }
  }

  void setAnyKeyListener(){
    if(!isListening){
      isListening = true;
      CONTROL.Input.keys() += KeyCallback(this.anyKeyCallback);
      isEscOverride = true;
    }
  }

  void anyKeyCallback(pKeyCode code, pByte count){
    if(code != PK_ESCAPE){
      bindCode(code);
      GAME_SETTINGS.saveValue(id, code);
      GAME_SETTINGS.save();
    }


    CONTROL.Input.keys() -= KeyCallback(this.anyKeyCallback);
    element.setBackground(Color(32,32,32,255));
    isListening = false;
    isEscOverride = false;
  }
  void bindCode(pKeyCode code) {
    key.text = mapInputKeys[code];
    up.key = code;
    if(@down != null)
    down.key = code;
  }

  private void addKeyDescriptions() {
    mapInputKeys.insert(PK_RETURN,"RETURN");
    mapInputKeys.insert(PK_ESCAPE,"ESCAPE");
    mapInputKeys.insert(PK_BACKSPACE,"BACKSPACE");
    mapInputKeys.insert(PK_TAB,"TAB");
    mapInputKeys.insert(PK_SPACE,"SPACE");
    mapInputKeys.insert(PK_EXCLAIM,"!");
    mapInputKeys.insert(PK_QUOTEDBL,"\"");
    mapInputKeys.insert(PK_HASH,"#");
    mapInputKeys.insert(PK_PERCENT,"%");
    mapInputKeys.insert(PK_DOLLAR,"$");
    mapInputKeys.insert(PK_AMPERSAND,"&");
    mapInputKeys.insert(PK_QUOTE,"'");
    mapInputKeys.insert(PK_LEFTPAREN,"(");
    mapInputKeys.insert(PK_RIGHTPAREN,")");
    mapInputKeys.insert(PK_ASTERISK,"*");
    mapInputKeys.insert(PK_PLUS,"+");
    mapInputKeys.insert(PK_COMMA,",");
    mapInputKeys.insert(PK_MINUS,"-");
    mapInputKeys.insert(PK_PERIOD,".");
    mapInputKeys.insert(PK_SLASH,"/");
    mapInputKeys.insert(PK_0,"0");
    mapInputKeys.insert(PK_1,"1");
    mapInputKeys.insert(PK_2,"2");
    mapInputKeys.insert(PK_3,"3");
    mapInputKeys.insert(PK_4,"4");
    mapInputKeys.insert(PK_5,"5");
    mapInputKeys.insert(PK_6,"6");
    mapInputKeys.insert(PK_7,"7");
    mapInputKeys.insert(PK_8,"8");
    mapInputKeys.insert(PK_9,"9");
    mapInputKeys.insert(PK_COLON,":");
    mapInputKeys.insert(PK_SEMICOLON,";");
    mapInputKeys.insert(PK_LESS,"<");
    mapInputKeys.insert(PK_EQUALS,"=");
    mapInputKeys.insert(PK_GREATER,">");
    mapInputKeys.insert(PK_QUESTION,"?");
    mapInputKeys.insert(PK_AT,"@");
    mapInputKeys.insert(PK_LEFTBRACKET,"[");
    mapInputKeys.insert(PK_BACKSLASH,"\\");
    mapInputKeys.insert(PK_RIGHTBRACKET,"]");
    mapInputKeys.insert(PK_CARET,"^");
    mapInputKeys.insert(PK_UNDERSCORE,"_");
    mapInputKeys.insert(PK_BACKQUOTE,"`");
    mapInputKeys.insert(PK_a,"a");
    mapInputKeys.insert(PK_b,"b");
    mapInputKeys.insert(PK_c,"c");
    mapInputKeys.insert(PK_d,"d");
    mapInputKeys.insert(PK_e,"e");
    mapInputKeys.insert(PK_f,"f");
    mapInputKeys.insert(PK_g,"g");
    mapInputKeys.insert(PK_h,"h");
    mapInputKeys.insert(PK_i,"i");
    mapInputKeys.insert(PK_j,"j");
    mapInputKeys.insert(PK_k,"k");
    mapInputKeys.insert(PK_l,"l");
    mapInputKeys.insert(PK_m,"m");
    mapInputKeys.insert(PK_n,"n");
    mapInputKeys.insert(PK_o,"o");
    mapInputKeys.insert(PK_p,"p");
    mapInputKeys.insert(PK_q,"q");
    mapInputKeys.insert(PK_r,"r");
    mapInputKeys.insert(PK_s,"s");
    mapInputKeys.insert(PK_t,"t");
    mapInputKeys.insert(PK_u,"u");
    mapInputKeys.insert(PK_v,"v");
    mapInputKeys.insert(PK_w,"w");
    mapInputKeys.insert(PK_x,"x");
    mapInputKeys.insert(PK_y,"y");
    mapInputKeys.insert(PK_z,"z");
    mapInputKeys.insert(PK_CAPSLOCK,"CAPSLOCK");
    mapInputKeys.insert(PK_F1,"F1");
    mapInputKeys.insert(PK_F2,"F2");
    mapInputKeys.insert(PK_F3,"F3");
    mapInputKeys.insert(PK_F4,"F4");
    mapInputKeys.insert(PK_F5,"F5");
    mapInputKeys.insert(PK_F6,"F6");
    mapInputKeys.insert(PK_F7,"F7");
    mapInputKeys.insert(PK_F8,"F8");
    mapInputKeys.insert(PK_F9,"F9");
    mapInputKeys.insert(PK_F10,"F10");
    mapInputKeys.insert(PK_F11,"F11");
    mapInputKeys.insert(PK_F12,"F12");
    mapInputKeys.insert(PK_PRINTSCREEN,"PRINTSCREEN");
    mapInputKeys.insert(PK_SCROLLLOCK,"SCROLLLOCK");
    mapInputKeys.insert(PK_PAUSE,"PAUSE");
    mapInputKeys.insert(PK_INSERT,"INSERT");
    mapInputKeys.insert(PK_HOME,"HOME");
    mapInputKeys.insert(PK_PAGEUP,"PAGEUP");
    mapInputKeys.insert(PK_DELETE,"DELETE");
    mapInputKeys.insert(PK_END,"END");
    mapInputKeys.insert(PK_PAGEDOWN,"PAGEDOWN");
    mapInputKeys.insert(PK_RIGHT,"RIGHT");
    mapInputKeys.insert(PK_LEFT,"LEFT");
    mapInputKeys.insert(PK_DOWN,"DOWN");
    mapInputKeys.insert(PK_UP,"UP");

    mapInputKeys.insert(PK_LCTRL,"LCTRL");
    mapInputKeys.insert(PK_LSHIFT,"LSHIFT");
    mapInputKeys.insert(PK_LALT,"LALT");
    mapInputKeys.insert(PK_LGUI,"LGUI");
    mapInputKeys.insert(PK_RCTRL,"RCTRL");
    mapInputKeys.insert(PK_RSHIFT,"RSHIFT");
    mapInputKeys.insert(PK_RALT,"RALT");
    mapInputKeys.insert(PK_RGUI,"RGUI");
    /*mapInputKeys.insert(PK_NUMLOCKCLEAR,"NUMLOCKCLEAR");
    mapInputKeys.insert(PK_KP_DIVIDE,"KP_DIVIDE");
    mapInputKeys.insert(PK_KP_MULTIPLY,"KP_MULTIPLY");
    mapInputKeys.insert(PK_KP_MINUS,"KP_MINUS");
    mapInputKeys.insert(PK_KP_PLUS,"KP_PLUS");
    mapInputKeys.insert(PK_KP_ENTER,"KP_ENTER");
    mapInputKeys.insert(PK_KP_1,"KP_1");
    mapInputKeys.insert(PK_KP_2,"KP_2");
    mapInputKeys.insert(PK_KP_3,"KP_3");
    mapInputKeys.insert(PK_KP_4,"KP_4");
    mapInputKeys.insert(PK_KP_5,"KP_5");
    mapInputKeys.insert(PK_KP_6,"KP_6");
    mapInputKeys.insert(PK_KP_7,"KP_7");
    mapInputKeys.insert(PK_KP_8,"KP_8");
    mapInputKeys.insert(PK_KP_9,"KP_9");
    mapInputKeys.insert(PK_KP_0,"KP_0");
    mapInputKeys.insert(PK_KP_PERIOD,"KP_PERIOD");*/
  }

}
