funcdef void CheckboxEvent(bool state);
class CheckBox{
  UIElement@ element;
  UIElement@ yes;
  UIElement@ no;
  Color active = Color(163,163,163,255);
  Color passive = Color(32,32,32,255);

  CheckboxEvent@ checkboxEvent;
  bool state;
  CheckBox(bool _state = false){
    state = _state;
    int checkboxWidth = 130;
    int checkboxHeight = 45;
    @element = UIElement(Vector3(0,0,0), checkboxWidth, checkboxHeight);
    element.setBackground(Color(32,32,32,255));

    @yes = UIElement(Vector3(0,0,0), checkboxWidth/2, checkboxHeight);
    yes.setBackground(Color(225,0,0,255));
    Label@ yesText = Label(aldoFont,"Yes");
    yesText.setScale(0.5);
    yes.addChild(@yesText);
    yes.setChildPosition(@yesText,Vector3(-27,0,22));
    element.addChild(@yes);
    element.setChildPosition(@yes,Vector3(-checkboxWidth/4,0,0));

    @no = UIElement(Vector3(0,0,0), checkboxWidth/2, checkboxHeight);
    no.setBackground(Color(225,0,0,255));
    Label@ noText = Label(aldoFont,"No");
    noText.setScale(0.5);
    no.addChild(@noText);
    no.setChildPosition(@noText,Vector3(-17,0,22));
    element.addChild(@no);
    element.setChildPosition(@no,Vector3(checkboxWidth/4,0,0));

    @element.onClick = UIEvent(@click);

    setHighlight();
  }

  void click(UIEventInfo event) {
    state = !state;
    setHighlight();
    if(@checkboxEvent != null) checkboxEvent(state);
  }

  void setHighlight() {

    if(state){
      yes.setBackground(active);
      no.setBackground(passive);
    } else {
      no.setBackground(active);
      yes.setBackground(passive);
    }

  }

}
