#include "../../network/client.as";
#include "../../network/NetworkPlayer.as";
#include "PlayerList.as";
#include "MessageTicker.as";

Label@ playerHealthText;
Label@ playerWeaponText;
Label@ playerAmmoText;


Panel@ mainPanel;
Panel@ weaponInfoPanel;
PlayerList@ mPlayerList;

UIElement@ StartGameBtn;
UIElement@ BackBtn;
MessageTicker@ messageTicker;

void LobbyInit(UIEvent@ onStart, UIEvent@ onBack, bool hosting) {
	PlayerListInit();

	@StartGameBtn = UIElement(Vector3(mPlayerList.mWidth / 2 - 130,-1, mPlayerList.mPosY - (mPlayerList.mHeight - 35)),250,60);
	StartGameBtn.ignoreDepthManager = true;
	@BackBtn = UIElement(Vector3(-mPlayerList.mWidth / 2 + 130,-1, mPlayerList.mPosY - (mPlayerList.mHeight - 35)),250,60);
	BackBtn.ignoreDepthManager = true;
	Color bgGrey = Color(163,163,163,255);

	if (hosting) {
		Label@ StartGameTxt = Label(aldoFont,"Start game");
		StartGameTxt.setScale(0.6);
		StartGameBtn.setBackground(bgGrey);
		StartGameBtn.addChild(StartGameTxt);
		StartGameBtn.setChildPosition(StartGameTxt, Vector3(-105, 1, 25));

		@StartGameBtn.onClick = onStart;
	} else {
		Label@ StartGameTxt = Label(aldoFont,"Waiting for host");
		StartGameTxt.setScale(0.4);
		StartGameBtn.setBackground(bgGrey);
		StartGameBtn.addChild(StartGameTxt);
		StartGameBtn.setChildPosition(StartGameTxt, Vector3(-105, 1, 25));
	}


	Label@ BackTxt = Label(aldoFont,"Back");
	BackTxt.setScale(0.6);
	BackBtn.setBackground(bgGrey);
	BackBtn.addChild(BackTxt);
	BackBtn.setChildPosition(BackTxt, Vector3(-50, 1, 25));

	@BackBtn.onClick = onBack;

	StartGameBtn.addToScene(INTERFACE_SCENE);
	BackBtn.addToScene(INTERFACE_SCENE);
}

void HideLobby()
{
	if(@mPlayerList != null){
		mPlayerList.hide();
		StartGameBtn.visible = false;
		BackBtn.visible = false;
	}
}

void ShowLobby()
{
	if(@mPlayerList != null){
		mPlayerList.show();
		StartGameBtn.visible = true;
		BackBtn.visible = true;
		MAIN_TIMER.elapsed += @Update;
		mPlayerList.disableToggle();
	}
}


void PlayerListInit()
{
  @mPlayerList = PlayerList();
  INTERFACE_SCENE.add(@mPlayerList.Container);

  mPlayerList.Start();

  MAIN_TIMER.elapsed += @Update;
}
/*int add = 0;
void testDing(pKeyCode, pByte) {
	messageTicker.CreateMessage("kak"+String(add));
	add++;
}*/
void OverlayInit() {

	//CONTROL.Input.key(PK_g) += testDing;
	
	
	mPlayerList.enableToggle();


	// @playerWeaponText = Label(aldoFont,"Weapon:");
	// @playerAmmoText = Label(aldoFont,"Ammo:");
	

	if (mainPanel is null) {
	
		@messageTicker = MessageTicker();
		
		@mainPanel = Panel(gameWidth, gameHeight);
		mainPanel.translate(-gameWidth/2,-1,gameHeight/2);
		INTERFACE_SCENE.add(@mainPanel);
		mainPanel.hide();
		mainPanel.addChild(@messageTicker.container);
		messageTicker.container.hAlign = GHA_RIGHT;
		messageTicker.container.vAlign = GVA_TOP;
		messageTicker.container.relTranslate(0, -3, 0);
		

	// @weaponInfoPanel = Panel(300, 100);

		@crosshair = objectFactory.load("../../Assets/3D/crosshair.fbx");
		crosshair.model.setDrawMode(DM_EMISSIVE);
		HUD_SCENE.add(crosshair);

		HUD_CAM.translate(0,-5,0);
	
		@playerHealthText = Label(aldoFont,"Health:");
		mainPanel.addChild(playerHealthText);
		playerHealthText.hAlign = GHA_LEFT;
		playerHealthText.vAlign = GVA_BOTTOM;
		playerHealthText.setScale(0.6);
		playerHealthText.margin = Vector2(10,10);
	}

	// Object@ tempObj = objectFactory.createPoster("../../Assets/3D/texture/damage_poster.png");
	// //tempObj.setScale(20);
	// EFFECT_OVERLAY_SCENE.add(tempObj);
	// //EFFECT_OVERLAY_SCENE.add(objectFactory.createPoster("../../Assets/3D/texture/damage_poster.png"));
	// EFFECT_OVERLAY_CAM.translate(0,-21,0);
	
	// auto@ mat = tempObj.model.getSurface(0).material;
	// mat.type = MT_TRANSLUCENT;
	// mat.mode = DM_EMISSIVE;

	/*weaponInfoPanel.hAlign = GHA_RIGHT;
	weaponInfoPanel.vAlign = GVA_BOTTOM;
	weaponInfoPanel.hide();
	weaponInfoPanel.addChild(playerWeaponText);
	weaponInfoPanel.addChild(playerAmmoText);

	weaponInfoPanel.relTranslate(0,-2,0);// fix for playerList overlap
	mainPanel.addChild(weaponInfoPanel);*/

	//INTERFACE_SCENE.add(@weaponInfoPanel);
	// mainPanel.addChild(@mPlayerList.Container);

	//refinement
	

	// playerAmmoText.relTranslate(0,-0,-40);
	// playerWeaponText.setScale(0.6);
	// playerAmmoText.setScale(0.4);

	//add elements to panels

	// weaponInfoPanel.addChild(playerWeaponText);
	// weaponInfoPanel.addChild(playerAmmoText);
}

void cleanupOverlay() {
	if(@mPlayerList != null){
		MAIN_TIMER.elapsed -= @Update;

		INTERFACE_SCENE.remove(playerHealthText);
		INTERFACE_SCENE.remove(playerWeaponText);
		INTERFACE_SCENE.remove(playerAmmoText);

		INTERFACE_SCENE.remove(mainPanel);
		INTERFACE_SCENE.remove(weaponInfoPanel);
		INTERFACE_SCENE.remove(mPlayerList.Container);

		StartGameBtn.removeFromScene();
		BackBtn.removeFromScene();

		HUD_SCENE.remove(crosshair);

		@playerHealthText = null;
		@playerWeaponText = null;
		@playerAmmoText = null;

		@mainPanel = null;
		@weaponInfoPanel = null;
		@mPlayerList = null;

		@StartGameBtn = null;
		@BackBtn = null;

		@crosshair = null;

	//UI_DEPTH_MANAGER.arrElementOrder.length = 0;
	}

}



void Update() {
  //panel pos bug spul, niet vergeten weg te halen

  if(@gClient != null){

	if (gClient.getLocalPlayer() !is null) {
		NetworkPlayer@ self = gClient.getLocalPlayer();
		if (playerHealthText !is null)
			playerHealthText.text = "Health:"+String(self.health);
		//echo("client "+String(self.health));
    }
	mPlayerList.Update(gClient);
	if(@messageTicker != null)
		messageTicker.Update();
  }
  //echo("Ingame gui update");
}
