#include "../../network/client.as";
#include "../../network/NetworkPlayer.as";
#include "PlayerEntry.as";

class PlayerList
{
  Map<pUByte, NetworkPlayer@> mPlayers;
  Map<pUByte, PlayerEntry@> mPlayerEntries;
  Client@ mClient;
  Panel@ mPlayerPanel;
  bool mDisplayState = false;

  float mWidth = 300;
  float mHeight = 300;
  float mPosX = 0;
  float mPosY = 0;

  Label@ mNames;
  Label@ mKD;
  Label@ mPing;
  Label@ mWinnerMessage;
  
  Label@ mPlayerCount;


  Panel@ Container{
    get {return @mPlayerPanel;}
  }

  PlayerList(){
    calcPanelSettings();
    @mPlayerPanel = Panel(mWidth, mHeight);
  	mPlayerPanel.hAlign = GHA_CENTER;
  	mPlayerPanel.vAlign = GVA_CENTER;
    mPlayerPanel.model.getSurface(0).material.mode = DM_EMISSIVE;
    mPlayerPanel.model.setColor(Color(66,80,88,255));
	

    //labels
    @mNames = createStatName("Players");
    @mKD = createStatName(" Kills - Deaths");//space at start is for better alignment...
	@mWinnerMessage = createStatName("Testing... ");
	
	@mPlayerCount = createStatName("Players: 0/0");
		

    //creating some fake players
    /*for(pUByte tmpPlyr = 0; tmpPlyr<4; tmpPlyr++){
      NetworkPlayer@ tempPlayer = NetworkPlayer(tmpPlyr);
      tempPlayer.connected = true;
      tempPlayer.username = "player "+String(tmpPlyr);
      @mPlayers[tmpPlyr] = @tempPlayer;
    }*/
  }

  Label@ createStatName(String name){
    Label@ statName= Label(aldoFont,name);
    statName.scale(0.5);
    return @statName;
  }
  
  void enableToggle()
  {
	hide();
    CONTROL.Input.keyDown(PK_TAB) += KeyStateCallback(this.TabDown);
    CONTROL.Input.keyUp(PK_TAB) += KeyStateCallback(this.TabUp);
  }
  
  void disableToggle()
  {
    CONTROL.Input.keyDown(PK_TAB) -= KeyStateCallback(this.TabDown);
    CONTROL.Input.keyUp(PK_TAB) -= KeyStateCallback(this.TabUp);
  }
  

  void Start(){
    mPlayerPanel.relTranslate(mPosX, -8, mPosY);
    //hide panel;
    mPlayerPanel.addChild(mNames);
    mPlayerPanel.addChild(mKD);
	mPlayerPanel.addChild(mPlayerCount);
	mPlayerPanel.addChild(mWinnerMessage);

    mNames.hAlign = GHA_LEFT;
    mNames.vAlign = GVA_TOP;


    mKD.hAlign = GHA_RIGHT;
    mKD.vAlign = GVA_TOP;
	mKD.margin = Vector2(30, 0);

	
	mPlayerCount.hAlign = GHA_CENTER;
	mPlayerCount.vAlign = GVA_BOTTOM;
	
	mWinnerMessage.hAlign = GHA_CENTER;
	mWinnerMessage.vAlign = GVA_TOP;
	mWinnerMessage.margin = Vector2(0, -100);

    mNames.relTranslate(0, mPlayerPanel.position.y+0.01, 0);
    mKD.relTranslate(0, mPlayerPanel.position.y+0.01, 0);
	mPlayerCount.relTranslate(0, mPlayerPanel.position.y+0.01, 0);
	
    float startDepth;
  }

  
  void Update(Client@ _client) {
    @mClient = _client;
    //TODO: replace mPlayer for mClient.mOtherPlayers
    //check mOtherPlayers for new players not added to mPlayersEntries.

    int pos = 0;
    if(@mClient != null){
      for(auto it = mClient.mPlayers.begin(); it++;){
        pUByte key = it.key;

        if(!mPlayerEntries.contains(key)){
            
          PlayerEntry@ pe = PlayerEntry(mWidth, 50, -1);
		  if(mPlayerPanel.isHidden()){
			pe.Container.hide();
			echo ("Hiding!");
		  }
		  
          mPlayerPanel.addChild(@pe.Container);
          pe.start();
          @mPlayerEntries[key] = pe;

        }
      }

      //Compare mPlayerEntires to mOtherPlayers

	  //Ok so I can't modify a map when it is being iterated... so i'm going to work around that for now. Revision deadline coming up!
	  Array<pUInt> oldClients;

	  bool wehaveawinner = false;
	  pUInt playerCount = 0;
      for(auto it = mPlayerEntries.begin(); it++;){
        pUByte key = it.key;
        PlayerEntry@ playerEntry = it.value;
        if(!mClient.mPlayers.contains(key)){
          //Cannot find player, BYE!
          mPlayerEntries[key].Remove();
          oldClients.add(key);
        } else{
          float newX = 55+(55 * pos);
          NetworkPlayer@ currPlayer = mClient.mPlayers[key];
          playerEntry.UpdateInfo(currPlayer.username, currPlayer.kills, currPlayer.deaths, currPlayer.winner);
          playerEntry.setVerticalPosition(newX);
          pos++;
		  
		  if (currPlayer.winner) {
			wehaveawinner = true;
			if (currPlayer.id == mClient.Me.id)
				mWinnerMessage.text = "Congratulations! You have won the match!!";
			else
				mWinnerMessage.text = currPlayer.username + " has won the match!";
				
		  }
		  
		  //Hack for a weird bug where setVerticalPosition gets called OVER AND OVER AGAIN! No time to fix better.
		  // if (newX > 4000)
			// break;
		  
		  ++playerCount;
          //update stats
        }
      }
	 if (!wehaveawinner)
		mWinnerMessage.text = "" ;
	  
	  
	 mPlayerCount.text = "Players: " + String(playerCount) + "/" + String(mClient.mMaxPlayers);

  	  for (pUInt i = 0; i < oldClients.length(); ++i) {
    	echo ("Removing player : " + String(oldClients[i]));
    	mPlayerEntries.erase(oldClients[i]);
      }
    }
  }
  
  void hide() 
  {
    mPlayerPanel.hide();
  }
  
  void show()
  {
	mPlayerPanel.show();
  }
			
  void TabDown(pKeyCode code){
	show();
  }

  void TabUp(pKeyCode code){
	hide();
  }

  private void calcPanelSettings(){
    mWidth = gameWidth*0.9;
    mHeight = gameHeight*0.8;

    mPosX = -mWidth/2;
    mPosY = mHeight/2;
  }
}
