class PlayerEntry {
  float mWidth = 100;
  float mHeight = 100;
  Panel@ mPlayerEntryPanel;
  float mCurrentX = 0;
  Label@ mPLayerName;
  Label@ mPlayerKD;
  float startDepth;
  PlayerEntry(float _width, float _height, float _startDepth) {
    startDepth = _startDepth;
    mWidth = _width;
    mHeight = _height;
    @mPLayerName = Label(aldoFont,"John Doe");
    @mPlayerKD = Label(aldoFont,"0 - 0");
    mPLayerName.model.setColor(Color(64,64,64,255));
    @mPlayerEntryPanel = Panel(mWidth, mHeight);
    mPlayerEntryPanel.hAlign = GHA_LEFT;
    mPlayerEntryPanel.vAlign = GVA_TOP;
    mPlayerEntryPanel.model.getSurface(0).material.mode = DM_EMISSIVE;
    mPlayerEntryPanel.model.setColor(Color(64,64,64,255));

    mPlayerEntryPanel.relTranslate(0,startDepth,0);
    //mPlayerEntryPanel.addChild(@mPLayerName);
    mPLayerName.setScale(0.5);
    mPlayerKD.setScale(0.5);

    //tmpAddToScene();
  }

  Panel@ Container{
    get{ return mPlayerEntryPanel; }
  }

  void tmpAddToScene(){
    INTERFACE_SCENE.add(mPlayerEntryPanel);
    INTERFACE_SCENE.add(mPLayerName);
  }

  void start() {
	if (mPlayerEntryPanel.isHidden())
	{
		mPLayerName.hide();
		mPlayerKD.hide();
	}
	
    mPlayerEntryPanel.addChild(mPLayerName);
    mPlayerEntryPanel.addChild(mPlayerKD);

    mPLayerName.hAlign = GHA_LEFT;
    mPLayerName.vAlign = GVA_TOP;

    mPlayerKD.hAlign = GHA_RIGHT;
    mPlayerKD.vAlign = GVA_TOP;
	mPlayerKD.margin = Vector2(180, 0);


    mPLayerName.relTranslate(0,mPlayerEntryPanel.position.y+0.01,0);
    mPlayerKD.relTranslate(0,mPlayerEntryPanel.position.y+0.01,0);
  }

  void setVerticalPosition(float _newX){
    if(mCurrentX != _newX){
      mCurrentX = mCurrentX;
      mCurrentX = _newX;
      this.Container.margin = Vector2(0, mCurrentX);
    }
  }

  void UpdateInfo(String name, pUByte kills, pUByte deaths, bool winner){
    mPLayerName.text = name;
    mPlayerKD.text = String(kills)+" - "+String(deaths);
	if (winner) 
		mPlayerEntryPanel.model.setColor(Color(0, 128, 0, 255));
	else
		mPlayerEntryPanel.model.setColor(Color(64,64,64,255));;
  }

  void Remove() {
    INTERFACE_SCENE.remove(@mPlayerEntryPanel);
  }
}
