funcdef void UpdateMessages(TickMessage@);

class MessageTicker{
  Deque<Label@> displayedMessages;
  Deque<Label@> waitingMessages;
  Panel@ container;
  int max;
  int removeSpeed = 100;
  MessageTicker(int _max = 5){
    max = _max;
    @container = Panel(300,500);
    container.hide();
    //container.model.getSurface(0).material.mode = DM_EMISSIVE;
    //container.model.setColor(Color(66,80,88,255));
  }

  int removeTime = 0;
  void Update(){
    if(displayedMessages.size()< max){
      removeSpeed = 400;
      if(waitingMessages.size()!= 0){
        Label@ text = waitingMessages.front();
        displayedMessages.push_back(@text);
        waitingMessages.pop_front();
        container.addChild(text);

      }
    } else {
      removeSpeed = 100;
    }
    for(int count = 0; count < displayedMessages.size(); count++){
      //displayedMessages[count].tick();
      displayedMessages[count].margin = Vector2(0,75*count);
    }
    if(displayedMessages.size()>0) {
      removeTime++;
      if(removeTime >= removeSpeed){
        Label@ text = displayedMessages.front();
        INTERFACE_SCENE.remove(@text);
        displayedMessages.pop_front();
        removeTime = 0;
      }
    } else {
      removeTime = 0;
    }
  }

  void CreateMessage(String _message){
    Label@ text = Label(aldoFont, _message);
    text.hAlign = GHA_RIGHT;
    text.vAlign = GVA_TOP;
    text.setScale(0.4);
    waitingMessages.push_back(text);
  }

}

class TickMessage {
  Label@ text;
  TickMessage(String _message){
    @text = Label(aldoFont, _message);

    //container.addChild(text);
    text.setScale(0.4);
    text.hAlign = GHA_LEFT;
    text.vAlign = GVA_TOP;
  }

}
