funcdef void PARTICLE_CALLBACK();
funcdef bool P_BEHAVIOUR(Object@);
class ParticleBehaviours {
	int scale;
	int duration;
	Vector3 direction;
	Vector3 directionAbs;
	float decay;
	Timer@ timer;
	Scene@ scene;
	Quaternion orientation;
	float velocity;
	P_BEHAVIOUR@ trail() {
		scale = 10;
		return P_BEHAVIOUR(this.doTrail);
	}
	bool doTrail(Object@ object) {
		scale -= 1;
		object.setScale(object.scale*0.8);
		if (scale < 0) {
			return false;
		}	
		return true;
	}
	
	P_BEHAVIOUR@ move(Vector3 dir, int dur, float dec) {
		direction = dir;
		duration = dur;
		decay = dec;
		return P_BEHAVIOUR(this.doMove);
	}
	bool doMove(Object@ object) {
		object.relTranslate(direction);
		direction = direction*decay;
		if (duration < 1) {
			return false;
		}	
		duration -= 1;
		return true;
	}	
	P_BEHAVIOUR@ moveScale(Quaternion orient, float vel, int dur, float dec) {
		velocity = vel;
		orientation = orient;
		direction = orient.rotVector3(Vector3(0,1,0))*vel;
		//direction = Vector3(0,1,0)*vel;
		duration = dur;
		decay = dec;
		scale = duration;
		return P_BEHAVIOUR(this.doMoveScale);
	}
	bool doMoveScale(Object@ object) {
		object.translate(direction);
		direction = direction*decay;
		if (scale > 0) {
			object.setScale(object.scale*0.95);		
		}	
		if (duration < 1) {
			return false;
		}	
		duration -= 1;
		scale -= 1;
		return true;
	}
	P_BEHAVIOUR@ moveScaleRotate(Vector3 dir, int dur, float dec) {
		direction = dir;
		directionAbs = normalizeVector(direction);
		duration = dur;
		decay = dec;
		scale = duration;
		return P_BEHAVIOUR(this.doMoveScaleRotate);
	}
	bool doMoveScaleRotate(Object@ object) {
		object.translate(direction);
		direction = direction*decay;
		if (scale > 0) {
			object.setScale(object.scale*0.95);		
		}
		object.relRotate(directionAbs, PI*0.06);
		if (duration < 1) {
			return false;
		}	
		duration -= 1;
		scale -= 1;
		return true;
	}	
	
	P_BEHAVIOUR@ moveScaleTrail(Vector3 dir, int dur, float dec,Timer@ t, Scene@ s) {
		direction = dir;
		duration = dur;
		decay = dec;
		@timer = @t;
		@scene = @s;
		scale = duration;
		return P_BEHAVIOUR(this.doMoveScaleTrail);
	}
	bool doMoveScaleTrail(Object@ object) {
		object.relTranslate(direction);
		direction = direction*decay;
		if (scale > 0) {
			object.setScale(object.scale*0.95);		
		}	
		if (duration < 1) {
			return false;
		}
		Particle(timer, ParticleBehaviours().trail(), object.position, 0.18, scene);			
		duration -= 1;
		scale -= 1;
		return true;
	}	
}

class Particle:Base {
	Object@ object;
	Timer@ timer;
	//Scene@ scene;
	P_BEHAVIOUR @behaviour;
	//PARTICLE_CALLBACK @checkRef; 
	//bool addedToScene = false;
	Particle() {
		
	}
	Particle(Object@ obj, Timer@ t, P_BEHAVIOUR@ b, Vector3 origin, float scale, Scene@ s) {
		@object = @obj;
		object.scale(scale);
		object.setPosition(origin);
		addToScene(s);
		@behaviour = @b;
		@timer = @t;
		//@checkRef = PARTICLE_CALLBACK(this.check);
		timer.elapsed += Action(this.check);
		//timer.elapsed += Action(this.check);		
	}
	Particle(Timer@ t, P_BEHAVIOUR@ b, Vector3 origin, float scale, Scene@ s) {
		@object = objectFactory.createSphere();
		@behaviour = @b;
		object.scale(scale);
		object.setPosition(origin);
		addToScene(s);
		@timer = @t;
		//@checkRef = PARTICLE_CALLBACK(this.check);
		timer.elapsed += Action(this.check);
	}	
	~Particle() {
		if (addedToScene) {
			scene.remove(object);
		} 
	}
	
	void check() {

			if (!behaviour(object)) {
				timer.elapsed -= Action(this.check);
				removeFromScene();
				@behaviour = null;
			}

	}
	void addToScene(Scene@ s) {
		if (!addedToScene) {
			@scene = @s;
			scene.add(object);
			addedToScene = true; 
			Base::addToScene(s);
		} else {
			echo("WARNING: Object already added to scene!");
		}
	}
	void removeFromScene() {
		if (addedToScene) {
			scene.remove(object);
			addedToScene = false;
			
		} else {
			echo("WARNING: Can't Remove; Object not in any scene!");
		}
		Base::removeFromScene();
	}
}