
enum LevelObjectType {
	LO_DirectionalLight,
	LO_PointLight,
	LO_SpotLight,
	LO_Object
}

class LevelObject {
	DirectionalLight@ dLight;
	PointLight@ pLight;
	SpotLight@	sLight;
	Object@ obj;
	
	Vector3 position;
	Quaternion quaternion;
	Vector3 scale;
	Vector3 color;
	
	String name;
	uint uid = ;
	
	LevelObjectType type;
	
	LevelObject(DirectionalLight@ l, String n = "undefined") {
		type = LO_DirectionalLight;
		
	}
	LevelObject(PointLight@ p, String n) {
		type = LO_PointLight;
	}
	LevelObject(SpotLight@ s, String n) {
		type = LO_SpotLight;
	}	
	LevelObject(Object@ o, String n) {
		type = LO_Object;
	}	
	
	String getScript() {
		String s;
		switch(this.type) {
			case LO_DirectionalLight:
					s = "
					DirectionalLight@ "+name+" = DirectionalLight();
					"+name+".setPosition("+position.x+", "+position.y+", "+position.z+");
					"+name+".rotate(1, 0, 0, -0.7*PI);
					"+name+".color = Color("+color.r+","+color.g+","+color.b+","+color.a+");
					"+sceneName+".add("+name+");
					";
				break;
			case LO_PointLight:
				break;
			case LO_SpotLight:
				break;
			case LO_Object:
				break;			
		}
	}
	
}

class LevelBuilder {
	Array<String> arrObjects;
	
	LevelBuilder() {
		
	}
	
	
	
}