class CamController:InputControllerInterface {
	Camera@ camera;
	Vector3 movementVector;
	float speed = 0.01;
	
	CamController(Camera@ cam) {
		@camera = cam;
	}
	
	void doAction(InputControllerAction action, int val){
		switch (action) {
			case PA_moveLeft:
				camera.relTranslate(Vector3(-1*speed,0,0));
				break;

			case PA_moveRight:
				camera.relTranslate(Vector3(1*speed,0,0));
				break;

			case PA_moveForward:
				//movementVector.y = 1;
				camera.relTranslate(Vector3(0,1*speed,0));
				break;

			case PA_moveBackward:
				camera.relTranslate(Vector3(0,-1*speed,0));
				break;
			
			case PA_moveUp:
				camera.relTranslate(Vector3(0,0,1*speed));
				break;
				
			case PA_moveDown:
				camera.relTranslate(Vector3(0,0,-1*speed));
				break;
				
			case PA_cursorX:
				{
				//echo(String(val)+"\n");
					//playerRotation.x += val;
					//echo(String(val)+", ");
					camera.rotate(Vector3(0,0,-1), PI*(val*0.001));		
					break;
				}
			case PA_cursorY:
				{
				//echo(String(val)+"\n");
				//playerRotation.y += val;
					camera.relRotate(Vector3(1,0,0), PI*(val*0.001));		
				}
		}
	}
	
	
	
}