var Flakeblur = function(){
    PartBase.call(this);
    this.setEdgeDetection();
    this.setBloom(6);

    this.texture = TDEMO.TEXTURES.getTextures().flake2;
    var material = new THREE.MeshBasicMaterial({map: this.texture, side: THREE.BackSide});
    var geometry = new THREE.SphereGeometry(200, 32, 32);
    this.sphere = new THREE.Mesh(geometry, material);


    this.bgtexture = TDEMO.TEXTURES.getTextures().flake_repeat;
    var bgmaterial = new THREE.MeshBasicMaterial({map: this.bgtexture, side: THREE.BackSide});
    var bggeom = new THREE.SphereGeometry(1200, 32, 32);
    this.bg = new THREE.Mesh(bggeom, bgmaterial);

    this.scene.add(this.sphere);
    this.scene.add(this.bg);
};


Flakeblur.prototype = PartBase.prototype.inheritance();

Flakeblur.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
    var hb = TDEMO.SYNC.getHeartBeat();
    this.texture.offset.x = hb;
    this.texture.needsUpdate = true;
    this.sphere.rotation.x += 0.2;
    this.sphere.rotation.y += 0.3;
};
