var Domination = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(4);

    this.scene.fog = new THREE.Fog(0x202080, this.near, this.far/2);

    var geometry1 = new THREE.Geometry();
    var geometry2 = new THREE.Geometry();
    var geometry3 = new THREE.Geometry();
    var geometry4 = new THREE.Geometry();
    this.points = new THREE.Object3D();

    for (var i = 0; i < 600; i++) {

          var particle = new THREE.Vector3();
          particle.x = Math.random() * 400 - 200;
          particle.y = Math.random() * 500 - 250;
          particle.z = Math.random() * 800 - 400;

          if(i%2 === 0){
              geometry2.vertices.push(particle);
          }
          else if(i%3 === 0){
              geometry3.vertices.push(particle);
          }
          else if(i%4 === 0){
              geometry4.vertices.push(particle);
          }
          else{
              geometry1.vertices.push(particle);
          }
    }

    var material1 = new THREE.PointsMaterial({map : TDEMO.TEXTURES.getTextures().party_w, size : 50, transparent : true});
    var material2 = new THREE.PointsMaterial({map : TDEMO.TEXTURES.getTextures().hello_w, size : 50, transparent : true});
    var material3 = new THREE.PointsMaterial({map : TDEMO.TEXTURES.getTextures().world_w, size : 50, transparent : true});
    var material4 = new THREE.PointsMaterial({map : TDEMO.TEXTURES.getTextures().domination_w, size : 50, transparent : true});

    var p1 = new THREE.Points(geometry1, material1);
    this.points.add(p1);
    var p2 = new THREE.Points(geometry2, material2);
    this.points.add(p2);
    var p3 = new THREE.Points(geometry3, material3);
    this.points.add(p3);
    var p4 = new THREE.Points(geometry4, material4);
    this.points.add(p4);
    this.scene.add(this.points);

    this.bgTexture = TDEMO.TEXTURES.getTextures().kalat_lila;

    var sphere = new THREE.SphereGeometry(400, 32, 32);
    var material = new THREE.MeshBasicMaterial({
        map: this.bgTexture,
        side : THREE.BackSide
    });
    var bg = new THREE.Mesh(sphere, material);
    bg.rotation.x = -Math.PI/2;
    this.scene.add(bg);
};

Domination.prototype = PartBase.prototype.inheritance();

Domination.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var rot = TDEMO.SYNC.getObjRotation();
    this.points.rotation.x = rot.x;
    this.points.rotation.y = rot.y;
    this.points.rotation.z = rot.z;

    var hb = TDEMO.SYNC.getHeartBeat();
    this.bgTexture.offset.y = hb;
    this.bgTexture.needsUpdate = true;
};
