pico-8 cartridge // http://www.pico-8.com
version 8
__lua__
-- 2 and 1/2 men
-- by virgill, cons, slimey

--------------------------------
-- alcatraz : 2 and 1/2 men 
-- code by virgill
-- graphics by cons
-- music by slimey
--------------------------------

--main time
timer =0.0

--music
musicflag1 = 0
musicflag2 = 0

--rotsprites
t = 0
t2= 0

--vector
vectimer = 0
veccoltab = {1,5,1,2,6,7,7}

--sinescroll
sin_mii = 0
sin_timer = 0
sin_timer2 =0

--raster
linex1 = 0
liney1 = 0
linex2 = 127
liney2 = 127
rottimer = 0.25
flashtimer = 0
copytimer = 0
rastertimer = 0

--rotzoom
rotzoomtimer = 0

--towers
towtimer = 0

--chaoszoom
chtimer = 0
chaoscoltab= {1,2,1,2,1,2,5,6,5,6,5,6,2,1,2,1}
chflag = false
chcam = 90

--logo
beat = 0
beatflag = 0
beatnu = 0

--borders
borderx = 16
bordery = 111
bordertime = 0

-- timing
scene0 = 1.0 --logo
scene1 = 2.0 --vector
scene2 = 3.0 --flash+filling rasters
scene3 = 3.55--spare
scene4 = 3.64 --rasterbar
scene5 = 4.5 --rotate rasters
scene6 = 5.5 --rotate rasters 3d
scene7 = 7.0 --rotate rasters with fadeout
scene8 = 7.5 --rotzoom with fade in
scene9 = 9.5 --todo:transition
scene10=11.0	--rotsprites layer1
scene11=12.0 --rotsprites layer2
scene12=13.5 --todo:transition
scene13=14.0 --towers
scene14=16.5 --chaoszoom1
scene15=19.0	--chaoszoom2
scene16=20.97--end

-- rotobar colors
r_space = {}
r_bar   = {0,0,1,0,1,5,12,13,7,7,13,12,5,1,0,1,0,0}
r_back  = {0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5,0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5,0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5,0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5,0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5,0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5,0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5,0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5,0,0,
5,8,5,8,9,10,7,7,10,9,8,5,8,5}


circtab={0,0,0,0,1,0,1,1,1,1,5,1,5,5,5,5,2,5,2,2,2,2,6,2,6,6,6,6,7,6,7,7,7,7}

cube = {{{-1,-1,-0.1}, 
         {-1,-1, 0.1},
         { 1,-1, 0.1},
         { 1,-1,-0.1},
         {-1, 1,-0.1},
         {-1, 1, 0.1},
         { 1, 1, 0.1},
         { 1, 1,-0.1}},
        {{1,2},                    
         {2,3}, 
         {3,4},
         {4,1},
         {5,6},
         {6,7},
         {7,8},
         {8,5},
         {1,5},
         {2,6},
         {3,7},
         {4,8}}}

local fadetable={
 {0,0,1,1,5,5,5,13,13,13,6,6,6,6,7},
 {1,1,5,5,13,13,13,13,13,6,6,6,6,6,7},
 {2,2,2,13,13,13,13,13,6,6,6,6,6,7,7},
 {3,3,3,3,13,13,13,13,6,6,6,6,6,7,7},
 {4,4,4,4,4,14,14,14,15,15,15,15,15,7,7},
 {5,5,13,13,13,13,13,6,6,6,6,6,6,7,7},
 {6,6,6,6,6,6,6,6,7,7,7,7,7,7,7},
 {7,7,7,7,7,7,7,7,7,7,7,7,7,7,7},
 {8,8,8,8,14,14,14,14,14,14,15,15,15,7,7},
 {9,9,9,10,10,10,15,15,15,15,15,15,15,7,7},
 {10,10,10,10,10,15,15,15,15,15,15,15,7,7,7},
 {11,11,11,11,11,11,6,6,6,6,6,6,6,7,7},
 {12,12,12,12,12,12,6,6,6,6,6,6,7,7,7},
 {13,13,13,13,6,6,6,6,6,6,6,6,7,7,7},
 {14,14,14,14,14,15,15,15,15,15,15,7,7,7,7},
 {15,15,15,15,15,15,15,7,7,7,7,7,7,7,7}
}

fadetimer  = 16
fadetimer2 = 16 
fadetimer3 = 0
fadetimer4 = 16
fadetimer5 = 16
----------------------------------
function fade(i) --from the pico-8 forum
 for c=0,15 do
  if flr(i+1)>=16 then
   pal(c,7)
  else
   pal(c,fadetable[c+1][flr(i+1)])
  end
 end
end


function drawlogo()
 spr(128,2,50*-cos(timer)+4*sin(towtimer),32,4)
end


logocirctab = {1,2,5,13,6,13,7,13,6,13,5,2,1,0}
function logocircles()
 for x=0,63 do
  circfill(63+59*sin(4*timer+x/32),20+50*-cos(timer)+4*sin(towtimer)+19*sin(timer*2.2+x/22),2*sin(x/12+timer*3)+3,logocirctab[(flr(timer*100)+x)%15+1])
 end
end

function drawlogo2()
	spr(128,2,52-20*cos(timer)+4*sin(towtimer),32,4)
end

function credits()
	spr(224,0,114,32,2)
end


function sline(x1,y1,x2,y2,col)
	line(x1,y1,x2,y2,col)
	line(x1+1,y1,x2+1,y2,col)
	line(x1,y1+1,x2,y2+1,col)
	line(x1-1,y1,x2-1,y2,col)
	line(x1,y1-1,x2,y2-1,col)
end

function copytable()
	copytimer+=1
	for i=1,copytimer do
		r_space[i]=r_back[i]
 end
end

function cleartable()
	for i=1,128 do
		r_space[i]=0
	end
end

function copybar(pos)
	for i=1,18 do
		r_space[pos+i]=r_bar[i]
	end
end

function rotatetable()
 merk = r_back[1]
 for v=1,128 do
  r_back[v]=r_back[v+1]
	end
	r_back[128]=merk
end

function drawborder(x,y)
	rectfill(0,0,x,127,1)
	rectfill(0,0,127,x,1)
	rectfill(127,127,y,0,1)
	rectfill(127,127,0,y,1)
 line(x,x,x,y,7)
 line(x,x,y,x,7)
 line(y,x,y,y,7)
 line(x,y,y,y,7)
end

function drawflash()
 flashtimer = flashtimer +1
	rectfill(17,17,110,110,r_bar[flashtimer+7])
end

function draw_shape(s,col)
	for l in all(s[2]) do -- for each line in the shape
		draw_line(s[1][l[1]],s[1][l[2]],col)
	end
end

function draw_line(p1,p2,c)
	x0,y0=project(p1) --get the 2d location of the 3d points..
	x1,y1=project(p2)
	line(x0,y0,x1,y1,c) --draw line
end	
	
function project(p)
	x=(p[1]-cam[1])*mult/(p[3]-cam[3])+127/2
	y=-(p[2]-cam[2])*mult/(p[3]-cam[3])+127/2
	return x,y
end


function rotate_shape(s,a,r)
	ns = {{},s[2]}
	for p in all(s[1]) do -- for each point in the original shape...
 	add(ns[1], rotate_point(p,a,r))
	end
	return ns 
end

function rotate_point(p,a,r) -- from the pico-8 magazine
	 x,y,z = 1,3,2
	_x = cos(r)*(p[x]) - sin(r) * (p[y])
	_y = sin(r)*(p[x]) + cos(r) * (p[y])
	np = {}
	np[x] = _x
	np[y] = _y
	np[z] = p[z]
	return np 
end


function rotzoom()
 local stimer = sin(timer)
 local ctimer = cos(timer)
	local sintimer=sin(timer*1.4)+1.1
 for zx=8,55 do
 	local zxdouble =zx*2
  local zxsin=zx*stimer
  local zxcos=zx*ctimer
  for zy=17,110 do
  	local zyperc=zy%2
  	local zydif =zy/2
  	local u = (zxcos+zydif*-stimer)*sintimer
  	local v = (zxsin+zydif* ctimer)*sintimer
  	u = u%64
  	v = v%64
 	 local col=sget(u,v)
  	pset(zxdouble+zyperc,zy,col)
  	pset(zxdouble-zyperc+1,zy,col/4)
  end
	end
end

-- rotate sprite (from the pico-8 forums)
function spra(angle,n,x,y,w,h,flip_x,flip_y)
 if w==nil or h==nil then
  w,h=8,8
 else
  w=w*8
  h=h*8
 end
 local diag,w,h=flr(sqrt(w*w+h*h))/2,w/2,h/2
 flip_x,flip_y=flip_x and -1 or 1,flip_y and -1 or 1
 local cosa,sina,nx,ny=cos(angle),sin(angle),n%16*8,flr(n/16)*8
 for i=-diag,diag do
  for j=-diag,diag do
   local ox,oy=(cosa*i + sina*j),(cosa*j - sina*i)
   if ox==mid(-w,ox,w) and oy==mid(-h,oy,h) then
    local col=sget(ox+w+nx,oy+h+ny)
    if col!=0 then
     sset(x+flip_x*i+w,y+flip_y*j+h,col)
    end
   end   
  end
 end
end


function rotsprites()
 t+=0.003+0.02*(sin(t2*0.7))
 t2+=0.003
	for x=0, 31 do
		for y=0, 31 do
			sset(x,y,0)
		end
	end
 spra(t,8,4,4,3,3)
--lower layer  
	if timer>=scene11 then
	pal(3,1)
	pal(5,5)
	pal(6,5)
	pal(7,6)
	pal(11,5)
	yv=sin(t2*5)*26
	xv=cos(t2*3)*26
	spr(0,48+yv,48+xv,4,4)
	spr(0,48+yv+sin(t)*23,48+xv-cos(t)*23,4,4)
	spr(0,48+yv+sin(t)*46,48+xv-cos(t)*46,4,4)
	spr(0,48+yv-sin(t)*23,48+xv+cos(t)*23,4,4)
	spr(0,48+yv-sin(t)*46,48+xv+cos(t)*46,4,4)
	spr(0,48+yv+sin(t+0.25)*23,48+xv-cos(t+0.25)*23,4,4)
	spr(0,48+yv+sin(t+0.25)*46,48+xv-cos(t+0.25)*46,4,4)
	spr(0,48+yv-sin(t+0.25)*23,48+xv+cos(t+0.25)*23,4,4)
	spr(0,48+yv-sin(t+0.25)*46,48+xv+cos(t+0.25)*46,4,4)
	spr(0,48+yv+sin(t+0.375)*33,48+xv-cos(t+0.375)*33,4,4)
	spr(0,48+yv+sin(t+0.375)*65,48+xv-cos(t+0.375)*65,4,4)
	spr(0,48+yv-sin(t+0.375)*33,48+xv+cos(t+0.375)*33,4,4)
	spr(0,48+yv-sin(t+0.375)*65,48+xv+cos(t+0.375)*65,4,4)
	spr(0,48+yv+sin(t-0.375)*33,48+xv-cos(t-0.375)*33,4,4)
	spr(0,48+yv+sin(t-0.375)*65,48+xv-cos(t-0.375)*65,4,4)
	spr(0,48+yv-sin(t-0.375)*33,48+xv+cos(t-0.375)*33,4,4)
	spr(0,48+yv-sin(t-0.375)*65,48+xv+cos(t-0.375)*65,4,4)
	spr(0,48+yv-sin(t-0.325)*52,48+xv+cos(t-0.325)*52,4,4)
	spr(0,48+yv-sin(t+0.325)*52,48+xv+cos(t+0.325)*52,4,4)
	spr(0,48+yv+sin(t-0.325)*52,48+xv-cos(t-0.325)*52,4,4)
	spr(0,48+yv+sin(t+0.325)*52,48+xv-cos(t+0.325)*52,4,4)
	spr(0,48+yv-sin(t-0.425)*52,48+xv+cos(t-0.425)*52,4,4)
	spr(0,48+yv-sin(t+0.425)*52,48+xv+cos(t+0.425)*52,4,4)
	spr(0,48+yv+sin(t-0.425)*52,48+xv-cos(t-0.425)*52,4,4)
	spr(0,48+yv+sin(t+0.425)*52,48+xv-cos(t+0.425)*52,4,4)
-- shadow layer 
 pal(3,0)
	pal(5,0)
	pal(6,0)
	pal(7,0)
	pal(11,0)
	yv=sin(t2*5+0.11)*26
	xv=cos(t2*3+0.11)*26
	spr(0,48+yv,48+xv,4,4)
	spr(0,48+yv+sin(t)*23,48+xv-cos(t)*23,4,4)
	spr(0,48+yv+sin(t)*46,48+xv-cos(t)*46,4,4)
	spr(0,48+yv-sin(t)*23,48+xv+cos(t)*23,4,4)
	spr(0,48+yv-sin(t)*46,48+xv+cos(t)*46,4,4)
	spr(0,48+yv+sin(t+0.25)*23,48+xv-cos(t+0.25)*23,4,4)
	spr(0,48+yv+sin(t+0.25)*46,48+xv-cos(t+0.25)*46,4,4)
	spr(0,48+yv-sin(t+0.25)*23,48+xv+cos(t+0.25)*23,4,4)
	spr(0,48+yv-sin(t+0.25)*46,48+xv+cos(t+0.25)*46,4,4)
	spr(0,48+yv+sin(t+0.375)*33,48+xv-cos(t+0.375)*33,4,4)
	spr(0,48+yv+sin(t+0.375)*65,48+xv-cos(t+0.375)*65,4,4)
	spr(0,48+yv-sin(t+0.375)*33,48+xv+cos(t+0.375)*33,4,4)
	spr(0,48+yv-sin(t+0.375)*65,48+xv+cos(t+0.375)*65,4,4)
	spr(0,48+yv+sin(t-0.375)*33,48+xv-cos(t-0.375)*33,4,4)
	spr(0,48+yv+sin(t-0.375)*65,48+xv-cos(t-0.375)*65,4,4)
	spr(0,48+yv-sin(t-0.375)*33,48+xv+cos(t-0.375)*33,4,4)
	spr(0,48+yv-sin(t-0.375)*65,48+xv+cos(t-0.375)*65,4,4)
	spr(0,48+yv-sin(t-0.325)*52,48+xv+cos(t-0.325)*52,4,4)
	spr(0,48+yv-sin(t+0.325)*52,48+xv+cos(t+0.325)*52,4,4)
	spr(0,48+yv+sin(t-0.325)*52,48+xv-cos(t-0.325)*52,4,4)
	spr(0,48+yv+sin(t+0.325)*52,48+xv-cos(t+0.325)*52,4,4)
	spr(0,48+yv-sin(t-0.425)*52,48+xv+cos(t-0.425)*52,4,4)
	spr(0,48+yv-sin(t+0.425)*52,48+xv+cos(t+0.425)*52,4,4)
	spr(0,48+yv+sin(t-0.425)*52,48+xv-cos(t-0.425)*52,4,4)
	spr(0,48+yv+sin(t+0.425)*52,48+xv-cos(t+0.425)*52,4,4)
 end 
-- upper layer
	pal(3,3)
	pal(5,5)
	pal(7,7)
	pal(6,6)
	pal(11,11)
	yv=sin(t2*5+0.1)*26
	xv=cos(t2*3+0.1)*26
	spr(0,48+yv,48+xv,4,4)
	spr(0,48+yv+sin(t)*23,48+xv-cos(t)*23,4,4)
	spr(0,48+yv+sin(t)*46,48+xv-cos(t)*46,4,4)
	spr(0,48+yv-sin(t)*23,48+xv+cos(t)*23,4,4)
	spr(0,48+yv-sin(t)*46,48+xv+cos(t)*46,4,4)
	spr(0,48+yv+sin(t+0.25)*23,48+xv-cos(t+0.25)*23,4,4)
	spr(0,48+yv+sin(t+0.25)*46,48+xv-cos(t+0.25)*46,4,4)
	spr(0,48+yv-sin(t+0.25)*23,48+xv+cos(t+0.25)*23,4,4)
	spr(0,48+yv-sin(t+0.25)*46,48+xv+cos(t+0.25)*46,4,4)
	spr(0,48+yv+sin(t+0.375)*33,48+xv-cos(t+0.375)*33,4,4)
	spr(0,48+yv+sin(t+0.375)*65,48+xv-cos(t+0.375)*65,4,4)
	spr(0,48+yv-sin(t+0.375)*33,48+xv+cos(t+0.375)*33,4,4)
	spr(0,48+yv-sin(t+0.375)*65,48+xv+cos(t+0.375)*65,4,4)
	spr(0,48+yv+sin(t-0.375)*33,48+xv-cos(t-0.375)*33,4,4)
	spr(0,48+yv+sin(t-0.375)*65,48+xv-cos(t-0.375)*65,4,4)
	spr(0,48+yv-sin(t-0.375)*33,48+xv+cos(t-0.375)*33,4,4)
	spr(0,48+yv-sin(t-0.375)*65,48+xv+cos(t-0.375)*65,4,4)
	spr(0,48+yv-sin(t-0.325)*52,48+xv+cos(t-0.325)*52,4,4)
	spr(0,48+yv-sin(t+0.325)*52,48+xv+cos(t+0.325)*52,4,4)
	spr(0,48+yv+sin(t-0.325)*52,48+xv-cos(t-0.325)*52,4,4)
	spr(0,48+yv+sin(t+0.325)*52,48+xv-cos(t+0.325)*52,4,4)
	spr(0,48+yv-sin(t-0.425)*52,48+xv+cos(t-0.425)*52,4,4)
	spr(0,48+yv-sin(t+0.425)*52,48+xv+cos(t+0.425)*52,4,4)
	spr(0,48+yv+sin(t-0.425)*52,48+xv-cos(t-0.425)*52,4,4)
	spr(0,48+yv+sin(t+0.425)*52,48+xv-cos(t+0.425)*52,4,4)
end

function towers()
 local offsa=0
 local spread=0.2*sin(towtimer*0.1) -- spread of sinewaves 
 local speed=16
 local offsy=16
 local offsx=(towtimer*speed)%15
 local fact=16    -- amp of y movenemt
 offsa+=spread 
 for x=-1,8 do
  for y=8,0,-1 do
   spr(12,(x*15+offsx),y*7+sin(1.4*towtimer+(x-offsx)/8+offsa)*fact+offsy,2,2)
  end
 end
 offsy=32
 offsx=(7+towtimer*speed)%15
 offsa+=spread
 for x=-1,8 do
  for y=8,0,-1 do
   spr(12,(x*15+offsx),y*7+sin(1.4*towtimer+(x-offsx)/8+offsa)*fact+offsy,2,2)
  end
 end
 offsy=48
 offsx=(14+towtimer*speed)%15
 offsa+=spread
 for x=-1,8 do
  for y=8,0,-1 do
   spr(12,(x*15+offsx),y*7+sin(1.4*towtimer+(x-offsx)/8+offsa)*fact+offsy,2,2)
  end
 end
 offsy=64
 offsx=(21+towtimer*speed)%15
 offsa+=spread
 for x=-1,8 do
  for y=8,0,-1 do
   spr(12,(x*15+offsx),y*7+sin(1.4*towtimer+(x-offsx)/8+offsa)*fact+offsy,2,2)
  end
 end
 offsy=80
 offsx=(28+towtimer*speed)%15
 offsa+=spread
 for x=-1,8 do
  for y=8,0,-1 do
   spr(12,(x*15+offsx),y*7+sin(1.4*towtimer+(x-offsx)/8+offsa)*fact+offsy,2,2)
  end
 end
 offsy=96
 offsx=(35+towtimer*speed)%15
 offsa+=spread
 for x=-1,8 do
  for y=8,0,-1 do
   spr(12,(x*15+offsx),y*7+sin(1.4*towtimer+(x-offsx)/8+offsa)*fact+offsy,2,2)
  end
 end
end

function chaoszoom1()
	local cost=0.25*cos(chtimer/1.5)-0.6
	local sint=0.25*sin(chtimer/1.5)-0.6
	local offs =40
	for x=0,79 do
	 local xcost = (offs-x)*cost
	 local xsint = (offs-x)*sint
		for y=0,78 do
			local u = (xcost+(offs-y)*-sint)*0.895
			local v = (xsint+(offs-y)* cost)*0.85
			u = u%80
			v = v%80
			pset(x,y,sget(u,v))
		end
	end
 circfill (28+16*sin(chtimer),28+10*cos(1.8*chtimer),3,0)
 circfill (28+16*sin(chtimer),28+10*cos(1.8*chtimer),2,13)
 circfill(40+7*sin(chtimer*2),40+7*cos(chtimer*2),6,0)
 circfill(40+7*sin(chtimer*2),40+7*cos(chtimer*2),4,chaoscoltab[flr(timer*20%16+1)]  )
	for i=0,39 do
		local p=64*i
		memcpy(0x0000+p,0x7020+p,20)
		memcpy(0x0014+p,0x700c+p,20)
		memcpy(0x0a00+p,0x6620+p,20)
		memcpy(0x0a14+p,0x660c+p,20)
 end
end


function chaoszoom2()
poke (0x5f2c,7)
	local cost=cos(0.49)+0.09*cos(chtimer)
	local sint=sin(0.51)+0.09*sin(chtimer)
	local offs =31.5+3*sin(chtimer/2)
	for x=0,63 do
	 local xcost = (offs-x)*cost
	 local xsint = (offs-x)*sint
		for y=0,63 do
			local u = (xcost+(offs-y)*-sint)*1.02
			local v = (xsint+(offs-y)* cost)*1.02
			u = u%64
			v = v%64
			pset(x,y,sget(u,v))
		end
	end
for x=0,3 do
for y=0,3 do
colorr=flr(chtimer*20)%15+1
pset(0+x,0+y,colorr)
end
end
	for i=0,31 do
		local p=64*i
		memcpy(0x0800+p,0x6010+p,16)
		memcpy(0x0810+p,0x6000+p,16)
  memcpy(0x0000+p,0x6810+p,16)
  memcpy(0x0010+p,0x6800+p,16)
 end
 for x=0,3 do
  for y=0,3 do
   pset(0+x,0+y,0)
  end
 end
 rect(0,0,127,127,7)
end

---------------------------------------------------------
---------------------------------------------------------
---------------------------------------------------------
---------------------------------------------------------
function _init()
cam = {-0.01,0.01,-2.5} 
mult = 113
end

---------------------------------------------------------

function _update()
	timer   +=0.005
 towtimer+=0.03
 chtimer +=0.01

--music on
	if timer >= scene0 and musicflag1 == 0 then
		musicflag1=1
		music(0)
	end

--music off
	if timer >= scene16 and musicflag2 == 0 then
		musicflag2=1
		music(-1,4000)
	end

--vector
	if timer>=scene1 and timer < scene2 then
  cam[3] =10-(timer-scene1)*10+2.5
  cube = rotate_shape(cube,a,0.01)--rotate cube
 end

--rasters
	if timer>=scene2 and timer<scene8 then
	sin_timer +=1
	sin_timer2 -=0.06
	if timer>=scene5 then rottimer+=0.005 end
		linex1= sin(rottimer)*64+63.5
		liney1= cos(rottimer)*64+63.5
		linex2=-sin(rottimer)*64+63.5
		liney2=-cos(rottimer)*64+63.5
		cx= cos(rottimer)
		cy= -sin(rottimer)
		if timer>=scene6 then cy= -sin(rottimer*2+0.75) end
		cleartable() 
		copytable()
		if timer>=scene4 then copybar(flr(-abs(sin(1.5707*timer+0.05)*82)+98)) end
		if timer>=scene3 then rotatetable() end
	end
end
---------------------------------------------------------

function _draw()
	rectfill(0,0,127,127,0)

--beatcircle
		if timer<scene2 and timer >=scene0 then
		 beat =stat(23)%8
	  if beat==3 then
		  circfill(63,63,32,1)
		  circ(63,63,32,7)
		  beatnu=3
   end
   if beatnu==3 and beat != 3 then
    circ(63,63,34,6)
	   beatnu=2
	  end
	  if beatnu==2 and beat != 3 then
    circ(63,63,36,2)
	  beatnu=1
	  end
	  if beatnu==1 and beat != 3 then
    circ(63,63,38,1)
	  beatnu=0
	  end
  end
	  
--startlogo
 if timer<scene1 and timer >= scene0 then
  logocircles()
  drawlogo()
 end	
	
--vector -- from the pico-8 magazine
	if timer>=scene1 and timer<scene2 then
  vectimer+=0.5
  if vectimer <= 6 then 
   veccolor=veccoltab[flr(vectimer+1)] 
  end
  draw_shape(cube,veccolor)
	end
	
--rasters
	if timer>=scene2 and timer<=scene8 then
	 if timer>=scene7 then 
   rastertimer+=2 
   camera(0,rastertimer)
		end
 	for i=0,128 do
 		sline (linex1+(i-64)*cx,liney1+(i-64)*cy,linex2+(i-64)*cx,liney2+(i-64)*cy,r_space[i])
 	end
	 drawborder(16,111)
	 camera(0,0)
	 rectfill(0,127-rastertimer,127,127,1)	  
	 if timer < (scene2+0.04) then
   drawflash()
	 end
	 if (timer>=scene4 and timer <scene5) then 	print(" rasterbars ftw ",25,flr(-abs(sin(1.5707*timer+0.05)*82)+103),r_bar[flr(abs(sin(5*timer))*16)]) end
	end


--sinescroll
 if timer>=scene2 and timer <scene7 then
 print("                    alcatraz at nordlicht 2017. with a little pico-8 production called    2 and 1/2 men     this platform is so much fun!!"
 ,-sin_timer+128,119,7)
 for sin_x=0,127 do
 	for sin_y=114,123  do
 	  sincalc=sin_y+((sin((sin_x)/40+sin_timer2)+1)*3)
 		 if sincalc>127 then sincalc=127 end
 		 pset(sin_x,sin_y,  pget(sin_x,sincalc))
 		end
 	end
 end

--rotzoom
 if timer>=scene8 and timer<scene10 then 
  rectfill(0,0,127,127,1)
  if rotzoomtimer >= -127 then rotzoomtimer-=1 end
  camera(0,128+rotzoomtimer)
  rotzoom() 
  if timer>=(scene8+3.26) then
   borderx+=1
   bordery-=1
   drawborder(borderx,bordery)
  else
   borderx=16
   bordery=111
   drawborder(borderx,bordery)
  end
  if timer>=(scene8+2.26) then poke (0x5f2c,7) end
	end 

--rotsprites
 if timer>=scene10 and timer <scene13 then 
  poke (0x5f2c,0)
  rotsprites()
   if timer<=(scene10+0.24) then
  		borderx-=1
  		bordery+=1
   end
   if timer>=scene12 then 
    bordertime+=0.16
    borderx=16-bordertime*-sin(timer*7+0.28)
    bordery=111+bordertime*-sin(timer*7+0.28)
		 end
		drawborder(borderx,bordery)
	end 

--towers
 if timer>=scene13 and timer <scene14 then
-- fade in
  if fadetimer>0 then
   fade(flr(fadetimer))
   fadetimer-=1.5
  end
  -- fade out
  if timer>(scene14-0.1) and fadetimer3<16 then
   fade(flr(fadetimer3))
   fadetimer3+=1.5
  end
  rectfill(0,0,127,127,1) 
  towers() 
  drawlogo2()
		drawborder(0,127)
  credits()
	end 

 if timer>=scene14 and fadetimer4>0 then	
  rectfill(0,0,127,127,1)
	 fade(flr(fadetimer4))
  fadetimer4-=1.5
 end 
--chaoszoom1
 if timer>=(scene14+0.07) and timer<scene15 then
  if chflag==false then 
   cls(1)
   chflag=true
  end
  if chcam>-24 then
   rectfill(0,0,127,127,1)
   camera(chcam,-24)
   rectfill(0,0,80,80,0) 
   rect(0,0,80,80,7)
  	chcam-=1
  end
  if timer>=(scene14+0.63) then 
  	if fadetimer2>0 then
  		fade(flr(fadetimer2))
  		rectfill(-24,-24,127,127,1) 
  		fadetimer2-=2.1
  		if fadetimer2<=0 then
   		fadetimer2=0 
  		end
  	end	
   chaoszoom1() 
   drawborder(0,79)
  end
 end

-- chaoszoom2
if timer>=scene15 and timer<scene16 then
camera(0,0)
chaoszoom2()
end

if timer>=scene16 then
poke (0x5f2c,4)

  -- fade out
  if fadetimer5>0 then
   fade(flr(fadetimer5))
   fadetimer5-=1.5
  end
  local xpos=32
  local ypos=40
  spr(192,xpos,ypos)
  spr(203,xpos+8,ypos)
  spr(194,xpos+16,ypos)
  spr(192,xpos+24,ypos)
  spr(211,xpos+32,ypos) 
  spr(209,xpos+40,ypos) 
  spr(192,xpos+48,ypos) 
  spr(217,xpos+56,ypos) 
  
  xpos=29
  spr(205,xpos,ypos+16)  
  spr(206,xpos+8,ypos+16)
  spr(209,xpos+16,ypos+16)
  spr(195,xpos+24,ypos+16)
  spr(203,xpos+32,ypos+16) 
  spr(200,xpos+40,ypos+16)
  spr(194,xpos+48,ypos+16)
  spr(199,xpos+56,ypos+16)
  spr(211,xpos+64,ypos+16)
  
  xpos=43
  spr(204,xpos,ypos+32) 
  spr(204,xpos+8,ypos+32)
  spr(215,xpos+16,ypos+32) 
  spr(213,xpos+24,ypos+32)                            
  spr(200,xpos+32,ypos+32) 
  spr(200,xpos+36,ypos+32) 
end

if timer>(scene16+0.5) then cls() end

--status
--print("cpu "..stat(1)*100.0, 0, 0,7)
--print("time "..timer, 64, 0,7)
--print("row "..stat(23)%8,64,0,7)
end

---------------------------------------------------------


     
         



__gfx__
7f424210000000000000000000222222222222000000000000000000012424f70000000000667600000000000000000000000005500000000000000000000000
f44422100000000000000022227676762676762222000000000000000122444f0000000000667600000000000000000000000557755000000000000000000000
44242100000000000000226676676767276767667622000000000000001242440000000000667600000000000000000000055777777550000000000000000000
24422100000000000022266666667676267676666666220000000000001224420000000005556550000000000000000005577777777775500000000000000000
42225610000000002266526666766767276766766662562200000000016522240000000333333333300000000000000057777777777777750000000000000000
22111561000100226666626666666676267666666662666622001000165111220000003333336b6b330000000000000055577777777775550000000000000000
11001156101652566656662666667667276676666626665666216101651000110000033333b6b667733000000000000056555777777556650000000000000000
00000115616526666666662666666766266766666626666666625616510000000000333333bb6677773300000000000055656557755666650000000000000000
0000001156525666566656626666666727666666662656665666256510000000000033333bb6b667763300000000000056565655566666650000000000000000
0000000155266666666666626666666626666666626666666666625510000000000533333bbb6b666b3350000000000055656565666666650000000000000000
0000001512266656665666562666000000006666265666566656622151000000666533333bbbb6b6b63356660000000056565655666666650000000000000000
00000111265266666666666660000000000000002666666666662652111000006665333333bbbb6b633356660000000055656565666666650000000000000000
00000012656526665666560000022220022220000066566656626565210000007776333333bbbbb6b33367770000000005565655666665500000000000000000
000000265656526666660000022424200242422200006666662656565200000066653b3b3333bbb3333356660000000000055565666550000000000000000000
0000026565656526665000222442422002242444200006566265656565200000000533b3b3333333333350000000000000000555655000000000000000000000
000002565656565266000244424444200244444f00222006265656565620000000003b3b3b333333333300000000000000000005500000000000000000000000
0000256565656565000200f4444444f00f444f4f024242006565656565620000000033b3b3333333333300000000000000000000000000000000000000000000
00002656565656560024200f4f4f44f00f44f4f00224242056565656565200000000033b3b333333333000000000000000000000000000000000000000000000
000265656565656002424200f44fff0110fff4f02444424200656565656520000000003333333333330000000000000000000000000000000000000000000000
0002265656565600242424200ff0111111111f002444444420565656565622000000000333333333300000000000000000000000000000000000000000000000
00256225656565024244444201111511115110024444444420056565652262000000000005556550000000000000000000000000000000000000000000000000
002555622656500f44444f4f111511555511511044444444f0065656226552000000000000667600000000000000000000000000000000000000000000000000
025565556225600ff4f4f4f11111555555551111f4f4f44ff0006522655565200000000000667600000000000000000000000000000000000000000000000000
02655565556200000fff4f1111551556655155111f4f4ff000002265556555200000000000667600000000000000000000000000000000000000000000000000
02556555655502200000f011151556666665551011f4f00022200555655565200000000000000000000000000000000000000000000000000000000000000000
0265556555650242220001115555656775665151110f000224220565556555200000000000000000000000000000000000000000000000000000000000000000
25556555655002424422011515566676676665551510022442420055655565200000000000000000000000000000000000000000000000000000000000000000
256555655560242444f1111555565766567565515110244444242065556555620000000000000000000000000000000000000000000000000000000000000000
25556555655022444ff11151556565655656565551511f4444422055655565520000000000000000000000000000000000000000000000000000000000000000
2565556555002444f4f11555555655555555655515111ff444444065556555620000000000000000000000000000000000000000000000000000000000000000
255565556502ffffff011555555555555555555555151f4f4f44f055655565520000000000000000000000000000000000000000000000000000000000000000
2222222222000000001155555515515151155155515110fffffff065556555620000000000000000000000000000000000000000000000000000000000000000
25551555150000000011155551511515155115155551110000000022222222220000000000000000000000000000000000000000000000000000000000000000
25555555550022222201155515151151511151515551102222222055555555520000000000000000000000000000000000000000000000000000000000000000
251555155500f42424211551515151151151151551511242424f0015551555120000000000000000000000000000000000000000000000000000000000000000
255555555550f44442215115151115151515111115151224444f0555555555520000000000000000000000000000000000000000000000000000000000000000
255515551550f44444201551111111515151111111511244444f0555155515520000000000000000000000000000000000000000000000000000000000000000
255555555550f4f4f442011111111115111111111111f44f4f4f0555555555520000000000000000000000000000000000000000000000000000000000000000
0215551555100f4f44f011511111111111111111111100fff4f00515551555200000000000000000000000000000000000000000000000000000000000000000
0255555555550ff4ff0021111111111511111111110000000ff02555555555200000000000000000000000000000000000000000000000000000000000000000
02551555152200ff0002421111111110111111111122220000000225155515200000000000000000000000000000000000000000000000000000000000000000
02555552221510f00024242011111151511151151242442220005152255555200000000000000000000000000000000000000000000000000000000000000000
00252221515150002242424201511556551115512424424242001515121552000000000000000000000000000000000000000000000000000000000000000000
002215151515150224244444255555666555550024444444f0015151512252000000000000000000000000000000000000000000000000000000000000000000
000251515151510004444444f0005556565502200f444f4f00151515151520000000000000000000000000000000000000000000000000000000000000000000
00021515151515100f44ff4f002222555522242200f4f4f001515151515120000000000000000000000000000000000000000000000000000000000000000000
000021515151515100f444f0024244200242424420ff4f0015151515151200000000000000000000000000000000000000000000000000000000000000000000
0000251515151515200fff00242424f00f444424200ff00251515151515200000000000000000000000000000000000000000000000000000000000000000000
000002515151515251000002424444f00f4444444200001125151515152000000000000000000000000000000000000000000000000000000000000000000000
0000021515151521115100244444f4f00f444f44ff20111112515151512000000000000000000000000000000000000000000000000000000000000000000000
000000215151521151115000ff4f4ff00ff4f4ff0001111111251515120000000000000000000000000000000000000000000000000000000000000000000000
00000012151521511151115000fff4f00f4fff000111111111125151210000000000000000000000000000000000000000000000000000000000000000000000
00000165215251115111512110000ff00fff00021111111111112512561000000000000000000000000000000000000000000000000000000000000000000000
00000016522111511151121111110000000011121111111111111225610000000000000000000000000000000000000000000000000000000000000000000000
00000001652151115111521111111112111111112111111111111256100000000000000000000000000000000000000000000000000000000000000000000000
00000016551211511151211111111102011111112111111111112155600000000000000000000000000000000000000000000000000000000000000000000000
00000165115121115111211111110112110111111211111111121511560000000000000000000000000000000000000000000000000000000000000000000000
11001651001112511151211111101102011011111211111111211100156000110000000000000000000000000000000000000000000000000000000000000000
22116510000100225112111111111012101111111121111122001000015611220000000000000000000000000000000000000000000000000000000000000000
42225100000000002221111110110102010110111121112200000000001522240000000000000000000000000000000000000000000000000000000000000000
24422100000000000022111111101012101011111112220000000000001224420000000000000000000000000000000000000000000000000000000000000000
44242100000000000000221011010102010101111122000000000000001242440000000000000000000000000000000000000000000000000000000000000000
f44422100000000000000022222010121010102222000000000000000122444f0000000000000000000000000000000000000000000000000000000000000000
7f424210000000000000000000022222222222000000000000000000012424f70000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000aaaaaaa7a7770000009aaaaaaaaaaaaaaaaa7a77777009aaaaaaaaaaa7aa7a770000000000000000000000000000000
0000000000000000000000000000009aaaaaaaaaaaaaa700099aaaaaaaaaaaaaaaaaaaaaa7d1007799a9aaaaaaaaaaaaa7700000000000000000000000000000
00000000000000000000000000009aaaaa71ddd9aaaaa70099999a9aa9aaaaaaaaaaaaaa71d100767767dd9a9a99aaaaaaa70000000000000000000000000000
000000000000000000000000009aaaaaa711dd9aaaaaa700777767d6d1d19aaaaaad6d66d1d1007666d6ddd1d1119aaaaaa70000000000000000000000000000
00000000000000000000000009aaaaaa7111d9aaaaaa71007666d6d6d1d19aaaaa7d6d66d1d1007666da77d1d11119aaaa710000000000000000000000000000
0000000000000000000000009aaaaaa7d111d9aaaaaaa1007666d6d6d1d9aaaaaa7d6d66d1d10076669aaa77a119aaaa71d10000000000000000000000000000
0000000000000000000000009a999aa7d1119aa999aa71007666d6d6d1d9aa99aa7d6d66d1d10076669aaaaaa999aaadd1d10000000000000000000000000000
0000000000000000000000066666666666666666666611007666d6d6d1d66666666d6d66d1d1007666111666666666ddd1d10000000000000000000000000000
00000000000eeeeeeeeeee499aaa9999999999aaa99a11ee7666d6d6d1d499aa99ad6d66d1d6ee776611499aaa9999aad1d1eeeeeeeeeeeee200000000000000
00000000002e8222222221499999999999999999999a11227666d6d6d1d4999999ad6d66d16221217744999999999999a1d12222222222228e00000000000000
0000000000e822222222149999999a1dd6d9999999a11121777767676664999999a676776722221244999999add99999a1d12222222222222e20000000000000
0000000002e22222222124999999a11dd6d9999999a111221212121212149999999a1212122221249999999a1dd76999d1d122222222222228e0000000000000
000000000e82222222124999999a111dd699999999a112212121212121249999999a212122221249999999a11dd6d777d1d222222222222222e2000000000000
000000002e22222222249999999a111dd69999999ad112221212121212149999999a121222222149999999a11dd6d666d212222222222222228e000000000000
00000000e82222222214994499a1111dd99994449ad112222222222221249944499a222222221249944499a11dd6d666d122222222229222222e200000000000
00000002e2222222215555555551111dd555555555d1222222222222221555555555222222222155555555551dd6d666d2222222229992222228e00000000000
0000000e822222221544499449d1111dd544999449d12222222222222125449994492222222212544999444449d6d666d2222229994492222222e20000000000
0000002e222222212544444449d1111d5444444491d12222222222222215444444492222222221544444444444999666d22229944449122222228e0000000000
000000e8222222225444444491d111215444444491d22222222222222125444444492222222212154444444444444999999994444491122222222e2000000000
000002e22222222154444449d1d112121554444491d222222222222222154444449122222222211544444444444444444444444449111222222228e000000000
00000e8222222215444444d1d1d122211d154449d1d22222222222222154444491d12222222212115444444444444444444444491d111222222222e200000000
00002e222222225444446dd1d1d122121d1d5549d12222222222222212544446d1d122222222211115444444444444444444491d1d1112222222228e00000000
0000e822222221544467ddd1d1d222211d1dd659d1222222222222222154446dd1d12222222212111d1544444444444444446d1d1d1112222222222e20000000
0002e2222222127777d6ddd1d1d222121d1dd6d6d122222222222222127767ddd1d12222222221111d1d6d644444444446d6dd1d1d11122222222228e0000000
000e82222222217666d6ddd1d12222211d1dd6d6d1222222222222222176d6ddd1d12222222212111d1dddd7677777767ddddd1d1d11122222222222e2000000
002e22222222127666d6ddd1d12222121d1dd6d6d2222222222222221276d6ddd1d12222222221111d1dddd6d666666d6ddddd1d1d112222222222228e200000
02eeeeeeeeeeee7666d6ddd16eeeeeee1d1dd6d6deeeeeeeeeeeeeeeee76d6ddd1ddeeeeeeeeeee11d1dddd6d666666d6ddddd1d1d1eeeeeeeeeeeeeeee00000
002822222222227666d6dd6d222222222d1dd6d6d2222222222222222276d6dddd622222222222211d1dddd6d666666d6ddddd1d1d2222222222222228200000
000282222222227666d66622222222222226d6d622222222222222222276d6d662222222222222221d1dddd6d666666d6ddddd16222222222222222282000000
00002888888888766667888888888888888867d788888888888888888876d6688888888888888888861dddd6d666666d6ddd6688888888888888888820000000
000000000000007777000000000000000000006700000000000000000077670000000000000000000006d6676777777676d60000000000000000000000000000
00070000777770000077770077777000777777707777777000777000700000700007000000000070700000707000000000707000777777700077700077777000
00707000700007000700007070000700700000007000000007000700700000700007000000000070770007007000000000707000770000700700070070000700
00707000707700707000000070000070700700007007000070000000700000700007000000000070707070007000000007070700707000707000007070000070
07000700770077007000000070000070707770007077700070000700707770700007000000000070700700007000000007070700700700707000007070000070
07777700707700707000000070000070700700007007000070007770700700700007000000000070707070007000000070070070700070707000007070000700
70000070700007000700007070000700700000007000000007000700700000700007000007000700770007007000000070707070700007700700070070077000
77777770777770000077770077777000777777707000000000777700700000700007000000777000700000707777777070777070700000700077700070000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00777000777770000007000000070000777777707777777070777070700000707000007077777770070000000070000000000000000000000000000000000000
07000700700007000070000000070000000000000000000070707070070007007000007000000700070000000707000000000000000000000000000000000000
70000070700000700070000007777700700000700700070070070070007070007000007000000700070000000007000007000000000000000000000000000000
70000070700000700007000000070000700000700070700007070700000700000700007000007000070000000007000000000000000000000000000000000000
77777770700007000000700000070000700000700070700007070700007070000077777000770000070000000070000007000000007000000000000000777700
07000770700770000000700000070000070007000007000000707000070007007000070077000000000000000000000000000000007000000000000000000000
00777070700007700007000000070000007770000007000000707000700000700777700077777770070000000070000000000000070000000700000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
77700000000000000000000000000000000000007770000000000000000000000000000777000000000000000000000000000000000000000000000000000000
77766600000000000000000000000000000006667776660000000000000000000000666777666000000000000000000000000000000000000000000000000000
777666ddd0000000000000000000000000ddd666777666dd00000000000000000ddd666777666ddd000000000000000000000000000000000000000000000000
777666ddd5555555555555555555555555ddd622222226dd55555555555555555ddd662272266ddd555555555555555555555550000000000000000000000000
727262d2d5757575775577757575557555ddd626727626dd57775777575755775ddd666777666ddd557757555757575777575755500000000000000000000000
7726262dd5757575757575557575557555ddd626272626dd57555757577757555ddd662272266ddd575557555757775755575755555000000000000000000000
727262d2d5757575775575557575557555ddd622727226dd57555757577755755ddd666777666ddd557557555757575775575755555500000000000000000000
7726262dd5757575757575757575557555ddd626272626dd57555757577755575ddd662272266ddd555757555757575755557555555000000000000000000000
777666ddd5575575757577757577757775ddd622222226dd57775777575757755ddd662272266ddd577557775757575777557555500000000000000000000000
777666ddd5555555555555555555555555ddd666777666dd55555555555555555ddd666777666ddd555555555555555555555550000000000000000000000000
777666ddd0000000000000000000000000ddd666777666dd00000000000000000ddd666777666ddd000000000000000000000000000000000000000000000000
77766600000000000000000000000000000006667776660000000000000000000000666777666000000000000000000000000000000000000000000000000000
77700000000000000000000000000000000000007770000000000000000000000000000777000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000ddd00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0ddddddd000000000000000000000000000000000000000000000000000000000000000000222000000000000000000000000000000000000000000000000000
0ddd555dd00000000000000000000000000000000000000000000000000000011100000002222200000005550000000000000000000000000000000000000000
ddd55555ddd0000000000000000000000000000000000000000000000000011111110000222222200000555550000000000000050000000d0000000000000000
dd5555555dd000000000000000000000000aaaaaaa7a7770000009aaaaaaaaaaaaaaaaa7a77777209aaaaaaaaaaa7aa7a7700055500000ddd006660000000000
dd5555555ddd777000000000000000009aaaaaaaaaaaaaa700099aaaaaaaaaaaaaaaaaaaaaa7d1207799a9aaaaaaaaaaaaa770050000000d0066666000000000
0d555555222d7777700000000000009aaaaa71ddd9aaaaa70099999a9aa9aaaaaaaaaaaaaa71d100767767dd9a9a99aaaaaaa700000000000066666ddd000000
0dd55552222277777000000000009aaaaaa711dd9aaaaaa700777767d6d1d19aaaaaad6d66d1d1007666d6ddd1d1119aaaaaa700060000000066666dddd00000
000d555222227777770000000009aaaaaa7111d9aaaaaa71007666d6d6d1d19aaaaa7d6d66d1d1007666da77d1d11119aaaa710066600000000666dddddd0000
0000ddd22222777777000000009aaaaaa7d111d9aaaaaaa1007666d6d6d1d9aaaaaa7d6d66d1d10076669aaa77a119aaaa71d1000600000000000ddddddd0000
000000dd22277777770ddd00009a999aa7d1119aa999aa71007666d6d6d1d9aa99aa7d6d66d1d10076669aaaaaa999aaadd1d1000000000000000ddddddd7000
000000000077777770ddddd0066666666666666666666611007666d6d6d1d66666666d6d66d1d1007666111666666666ddd1d10000000000d00000ddddd77000
0000000000777eeeeeeeeeee499aaa9999999999aaa99a11ee7666d6d6d1d499aa99ad6d66d1d6ee776611499aaa9999aad1d1eeeeeeeeeeeee2077ddd777700
0000000000002e8222222221499999999999999999999a11227666d6d6d1d4999999ad6d66d16221217744999999999999a1d12222222222228e077777777700
000000000000e822222222149999999a1dd6d9999999a11121777767676664999999a676776722221244999999add99999a1d12222222222222e277777777700
000000000002e22222222124999999a11dd6d9999999a111221212121212149999999a1212122221249999999a1dd76999d1d122222222222228e07777777000
00000000000e82222222124999999a111dd699999999a112212121212121249999999a212122221249999999a11dd6d777d1d222222222222222e27777777000
00000000002e22222222249999999a111dd69999999ad112221212121212149999999a121222222149999999a11dd6d666d212222222222222228e7d777ddd00
0000000000e82222222214994499a1111dd99994449ad112222222222221249944499a222222221249944499a11dd6d666d122222222229222222e2ddddddd00
0000000002e2222222215555555551111dd555555555d1222222222222221555555555222222222155555555551dd6d666d2222222229992222228eddddddd00
000000000e822222221544499449d1111dd544999449d12222222222222125449994492222222212544999444449d6d666d2222229994492222222e2ddddd000
000000002e222222212544444449d1111d5444444491d12222222222222215444444492222222221544444444444999666d22229944449122222228eddddd000
00000000e8222222225444444491d111215444444491d22222222222222125444444492222222212154444444444444999999994444491122222222e2ddd0000
00000002e22222222154444449d1d112121554444491d222222222222222154444449122222222211544444444444444444444444449111222222228eddd0000
0000000e8222222215444444d1d1d122211d154449d1d22222222222222154444491d12222222212115444444444444444444444491d111222222222e2600000
0000002e222222225444446dd1d1d122121d1d5549d12222222222222212544446d1d122222222211115444444444444444444491d1d1112222222228e660000
000000e822222221544467ddd1d1d222211d1dd659d1222222222222222154446dd1d12222222212111d1544444444444444446d1d1d1112222222222e266000
000002e2222222127777d6ddd1d1d222121d1dd6d6d122222222222222127767ddd1d12222222221111d1d6d644444444446d6dd1d1d11122222222228e66000
00000e82222222217666d6ddd1d12222211d1dd6d6d1222222222222222176d6ddd1d12222222212111d1dddd7677777767ddddd1d1d11122222222222e26000
00002e22222222127666d6ddd1d12222121d1dd6d6d2222222222222221276d6ddd1d12222222221111d1dddd6d666666d6ddddd1d1d112222222222228e2000
0002eeeeeeeeeeee7666d6ddd16eeeeeee1d1dd6d6deeeeeeeeeeeeeeeee76d6ddd1ddeeeeeeeeeee11d1dddd6d666666d6ddddd1d1d1eeeeeeeeeeeeeeee000
00002822222222227666d6dd6d222222222d1dd6d6d2222222222222222276d6dddd622222222222211d1dddd6d666666d6ddddd1d1d22222222222222282000
00000282222222227666d66622222222222226d6d622222222222222222276d6d662222222222222221d1dddd6d666666d6ddddd16222222222222222282d000
0000002888888888766667888888888888888867d788888888888888888876d6688888888888888888861dddd6d666666d6ddd668888888888888888882dd000
00000000ddd000007777dddd00555555550000006720000000000000000077670000000000000000000006d6676777777676d6555555500005555555dddd0000
000000000d000000ddddddddd055555550000002222200000000000000000200000000000000000000000000000000000000005555555000555555555ddd0000
0000000000000000ddddddddd000555000000002222200000000000000000000000000000000000000000000000000022200000555550022255555555d000000
0000060000006660ddddddddd0000000000000022222000000000000000000000000000001000000000000000000002222200011155022222225555550000000
00006660000666660ddddddd00000000000000002220000000000000000000000000000011100000000000000000002222201111111022222225555500000000
0000d6ddd06666666ddddddd00000000000000000000000000001000000000000000000001000000000000000000000022201111111222222222555500000000
000ddddddd666666600ddd0000000000000000000000000000011100000000000000000000000000000000010000000002011111111122222222550000000000
0000dddddd6666666000000000000000000000000000000000001000000000000000000000000000000000000000000000011111111122222222000000000000
000777dddd0666660000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111122222220000000000000
000070ddd00066600000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111022222220000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111000222000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

__gff__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
011000001805013000180501d1001d0501f0502005019050140501d100140501d100190501805016050180501405014000140501d100190501805016050180501b0501b0001b0501d100200501f0501b05016050
0010000011250182001125011200192001820016200192000d2500f2000d2500d2001d2000d2001f2002020018250000001825016200000001920000000192001325018200132501420000000142001120018200
00100000115500f5001150000000000000000011550000001455000000000001455000000000001455000000135500000000000135000000013500135500f5000c550000000c5000c5500f550135001355011500
0010000005150000000d600051503c6530d6000d6000d60001150000000d600011503c653000000d6000d600081500000000000081503c653000000000000000071500710000000071503c653000000015003150
000200000f0700f0700e0700c0700b07008070040000c0700a0700a0700b0700a0700907008070060700407002070010000807007070070700707007070050700307003070010000507005070040700307002070
000200000907008070070700707006070050700207002070000000607006070050700507004070030700107000000040700207001070010700107001070000000407003070020700207001070010700107001070
001000002c0000000000000000002c0700000000000000002b0700000029070000002407000000220702307124071240702207020000200701f0001f0700000000000000001d0700000028200000000000000000
00100000000000000000000000002c0500000000000000002b050000002c050000002e05000000300502f05130051300502e0502c0002c0502e0002b050000002c000000002905000000270502f0000000000000
011000002400028000290500000024050000002205000000240502000029050220002b000000002c0502e05130051300502e0503000030050300002e0502e0002e0002d0002c0502c0002b0502b0002b00029000
011000003000000000300502d0002e050000002c05000000240500000029050000002c050000002b0522b0522b0522b052290502900227050270022b0522b0522b0522b0522c0502c0022b0502b0022905029002
010100001565015440156401f50012600126001364013430136301e50019500135000e6300e4200e6201f50019500135000a6200a4100a6101e50019500155001b50018500135001a50015500115000000000000
00010000100500f0500d0500c0500b0500805006050050500305002050010500105002050050500a0500c0500d0500e0500f05010050110501105000000000000000000000000000000000000000000000000000
0110000024156201561d1561815624150201501d1501815026156221561d1561a15626150221501d1501a15025156201561d1561915625150201501d1501915027156221561f1561b15627150221501f1501b150
0110000024050300002d00020000290501d100240501d100260502600024100241002e05022100260502110025050000001f100000002c05025000250500000027050000001c100291002e050270002705000000
01100000242501f2001d250000001d25000000000002425026250252001d250000001d2500000000000262502525024200192501c200192500000000000202501f250000001b2500000022250202501f25020250
011000000505005050050500505005050050500505005050020500205002050020500205002050020500205001050010500105001050010500105001050010500305003050030500305003050030500305003050
01100000242501f2001d250000001d25000000000002425026250252001d250000001d2500000000000262502725024200292501c20024250000000000022250242500000022250000002025022250202501f250
011000002c0000000000000000002c0700000000000000002b0700000029070000002407000000220702307124071240702207020000200701f0001f0700000000000000001d070000001b0501b0001b0001b000
00100000242501f2001d250000001d25000000000002425026250252001d250000001d2500000000000262502725024200292501c20024250000000000022250242500000022250000002025022250202501f250
001000002c0000000000000000002c0700000000000000002b0700000029070000002407000000220702307124071240702207020000200701f0001f0700000000000000001d0700000028200000000000000000
001000003000000000300502d0002e0500000030050000002e050000002c05000000240500000029050290522905229002290502900227050270022b0522b0522b0522b0022b0502b000270502b0022905029002
001000003000000000300502d0002e0500000030050000002e050000002c05000000240500000029050290522905229002290502900227050270022b0522b0522b0522b0022b0502b000270502b0022907329002
01100000241502a1002c15024110291502c1102e150291102b1502e110331502b1102715033110291502711025150291102510025110010000100025110010003010030100301502e15030150301102c15030110
01100000271502c110241502711028150241102b150281102c1502b110291502c1100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001d057110571d057110071d000110001d00011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001d1501d1501d1501d1501d107000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000002915029150291502915029100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001d3501d3501d3501d3501d350000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0010000011200112001125011250112501125011250112510f2500f2500f2500f2500f2500f2500d2500d2500d2500d2500d2500d2500d2500d2500d2500d2500d2500d2500d2500d25014250142501425014250
0110000012210122100f2100f210122101220012210122100f2100f21012210122101321013210102101021000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 40414303
00 00414203
00 00014203
00 00010203
01 00010203
00 00010203
00 04424344
00 05424344
00 00010603
00 00010703
00 00010803
00 00010903
00 0a42434a
00 4b42430b
00 0a42434b
00 4a42430b
00 0a42434b
00 4142430b
00 0a424344
00 4142430b
00 0c0e0d4f
00 0c0e0d0f
00 0c100d0f
00 0c100d0f
00 0c0e110f
00 0c0e070f
00 0c10080f
00 0c10140f
00 02101506
00 02101507
00 02101508
02 02101509
00 01070306
00 58191a5b
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344

