@VERTEX
#version 410
precision highp float;
uniform mat4 projection_matrix;
uniform mat4 modelview_matrix;
uniform float time;
layout(location = 0) in vec3 in_position;
layout(location = 1) in vec3 in_normal;
layout(location = 2) in vec2 in_texCoord0;


out vec3 normal;
out vec2 texCoord0;

float rand(float n){return fract(sin(n) * 43758.5453123);}

void main(void)
{

	normal = (modelview_matrix * vec4(in_normal, 0)).xyz;
	texCoord0 = in_texCoord0;


	vec3 position = in_position;


	gl_Position = projection_matrix * modelview_matrix *  vec4(position, 1);
};

@FRAGMENT
#version 410
precision highp float;
in vec3 normal;
in vec2 texCoord0;
uniform sampler2D tex; 
uniform float time;
out vec4 out_frag_color;
void main(void)
{
	vec2 texcoord0 = mod(texCoord0, 1.0);
	texcoord0.x += sin(texcoord0.y*4.0+time)*0.1;
	texcoord0.y += cos(texcoord0.x*4.3+time)*0.1;
   	out_frag_color = texture(tex, texcoord0);
  // out_frag_color = vec4(texCoord0, 0,0);
 //  out_frag_color = data;
   //out_frag_color= data;
};
