@VERTEX
#version 410
precision highp float;
uniform mat4 projection_matrix;
uniform mat4 modelview_matrix;
uniform mat4 u_joint_matrix[3];
uniform vec3 eyeVector;
layout(location = 0) in vec3 in_position;
layout(location = 1) in vec3 in_normal;
layout(location = 2) in vec2 in_texCoord0;


out vec3 normal;
out vec2 texCoord0;




float rand(float n){return fract(sin(n) * 43758.5453123);}

void main(void)
{

	normal = (modelview_matrix * vec4(in_normal, 0)).xyz;
	texCoord0 = in_texCoord0;


	vec3 position = in_position;


	gl_Position = projection_matrix * modelview_matrix *  vec4(position, 1);
};

@FRAGMENT
#version 410
precision highp float;
const vec3 ambient = vec3(0.3, 0.3, 0.3);
const vec3 lightVecNormalized = normalize(vec3(2.0, 0.5, 0.4));
const vec3 lightColor = vec3(1.0, 1.0, 1.0);
in vec3 normal;
in vec2 texCoord0;
uniform sampler2D tex; 
uniform sampler2D matcapTex; 
uniform float matcapRatio;
uniform vec3 normalVector; 
uniform vec3 eyeVector; 


layout (location = 0) out vec4 out_frag_color;

vec2 matcap(vec3 eye, vec3 normal2) {
  vec3 reflected = reflect(eye, normal2);
  float m = 2.8284271247461903 * sqrt( reflected.z+1.0 );
  return reflected.xy / m + 0.5;
}

void main(void)
{
	vec2 texcoord0 = mod(texCoord0, 1.0);
	//float diffuse = clamp(dot(lightVecNormalized, normalize(normal)), 0.0, 1.0);
   	
   	vec2 uv = matcap(vec3(0,0,1), normal);
  	vec4 matCapColor = vec4(texture2D( matcapTex, uv).rgb, 1.0);
  out_frag_color =matCapColor;
   //	out_frag_color = mix(texture(tex, texcoord0), matCapColor, matcapRatio);
  // out_frag_color = vec4(texCoord0, 0,0);
 //  out_frag_color = data;
   //out_frag_color= data;
};
