class Presentation extends demoBase {
 
  PShape rectangle;
  PImage imgJugge;
  PImage imgHai;
  PImage imgMax;
  PImage imgTimo;
  PImage img;
  
  float angle;
  boolean large = false;
  float timeDelta = 0;
  float timePrev = 0;
  float startTime = -1;
  
  SoundFile sample;
  String s;
  public Presentation(PImage j, PImage h,PImage m,PImage t, SoundFile sample) {
    imgJugge = j;
    imgHai = h;
    imgMax = m;
    imgTimo = t;
    
    angle = 0;
    s = "";
    rectangle = createShape(SPHERE,250);
    rectangle.setTexture(img);
    
    this.sample = sample;
  }
 
  void playDemo() {
    background(66,240,240);
    if(startTime == -1) {
      sample.loop();
      startTime = millis()/1000.0;
    }
    getFace();
    float time = millis()/1000.0;
    timeDelta = time - timePrev;
  if(timeDelta > 0.20) {
      timePrev = time;
      
      if(large) {
        background(66,241,161);
        noStroke();
        fill(255);
        rectangle = createShape(SPHERE,250);
        rectangle.setTexture(img);
        large = false;
      }
      else{
        background(66,240,240);
        noStroke();
        fill(255);
        rectangle = createShape(SPHERE,450);
        rectangle.setTexture(img);
        large = true;
      }
    }
    else {
      if(large) {
        pushMatrix();
        background(66,241,161);
        noStroke();
        fill(255);
        rectangle = createShape(SPHERE,250);
        rectangle.setTexture(img);
        popMatrix();
      }
      else{
        pushMatrix();
        background(66,240,240);
        noStroke();
        fill(255);
        rectangle = createShape(SPHERE,450);
        rectangle.setTexture(img);
        popMatrix();
      }
    }
    
    //translate(width/2,height/2);
    pushMatrix();
    translate(width/2,height/2);
    rotateY(radians(angle));
    rotateX(radians(angle));
    shape(rectangle);
    popMatrix();
    
    pushMatrix();
    translate(10,10,0);
    noFill();
    stroke(255);
    sphere(280);
    popMatrix();
    
    pushMatrix();
    translate(80,height - 40,0);
    noFill();
    stroke(255);
    sphere(150);
    popMatrix();
    
    pushMatrix();
    textSize(28);
    fill(0, 102, 153);
    text(s, width - 500, 150); 
    text("song: Furious Freak", width - 300, height - 150); 
    popMatrix();

    angle++;
  }
  
  void getFace() {
    float t = millis()/1000.0 - startTime;
    if(t < 4) {
      s = "HaiTech"; 
      img = imgHai;
    }
    else if(t < 8) {
      s = "Max";
      img = imgTimo;
    }
    else if(t < 13) {
      s = "Jidoor";
      img = imgMax;  
    }
    else if(t < 16) {
      s = "Juge";
      img = imgJugge;
    }
  }
  boolean isOver() {
    boolean result = false;
    if(millis()/1000.0 - startTime > 19) {
      sample.stop();
      result = true;
    }
    return result;
  }
}