/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import moonlander.library.Controller;
import moonlander.library.Moonlander;
import moonlander.library.TimeController;
import processing.core.PApplet;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PShader;

public class Graffathon
extends PApplet {
    Moonlander ml;
    TerrainManager terrain;
    ShipRowManager shipRows;
    Sky sky;
    AudioController ac;
    CameraController cam;
    City c = new City(0.45f, 5);
    Ship s;
    ArrayList<PVector> shipRoute = new ArrayList();
    private Scene currentScene;

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D", 1);
    }

    public void setup() {
        this.frameRate(60.0f);
        this.colorMode(1, 255.0f);
        this.sky = new Sky();
        this.ml = new Moonlander((PApplet)this, (Controller)new TimeController(10));
        this.ml.start();
        this.ac = new AudioController(new Minim((Object)this));
        this.cam = new CameraController(new PVector(320.0f, -240.0f, 640.0f), new PVector(0.0f, 0.0f, 0.0f), this.ml);
        this.s = new Ship(new PVector(320.0f, -120.0f, 320.0f), this.ml);
        this.terrain = new TerrainManager();
        this.cam.setViewTarget(this.s.pos);
        this.shipRows = new ShipRowManager();
        this.currentScene = new StartScene(this.cam, this.ac, this.s, this.c, this.terrain, this.shipRows);
        int SEED = 0;
        this.randomSeed(SEED);
    }

    public void draw() {
        this.ml.update();
        this.ac.update();
        this.background(0);
        this.currentScene = this.currentScene.update();
        this.cam.update();
        this.directionalLight(153.0f, 192.0f, 255.0f, 0.5f, 1.0f, 0.5f);
        float f = this.ac.getBassIntensity() > 0.3f ? Graffathon.pow((float)this.ac.getBassIntensity(), (float)0.5f) : 0.1f;
        float ambient = f * 255.0f;
        this.ambientLight(ambient, ambient, ambient);
        float skyIntensity = this.ac.getBassIntensity() > 0.3f ? Graffathon.constrain((float)((this.ac.getBassIntensity() - 0.3f) / 0.7f), (float)0.0f, (float)1.0f) : 0.0f;
        this.sky.draw(this.cam.pos, skyIntensity);
        this.terrain.draw(this.cam);
        this.c.draw(this.cam.pos);
        this.s.draw();
        this.shipRows.draw();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Graffathon"};
        if (passedArgs != null) {
            PApplet.main((String[])Graffathon.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AudioController {
        Minim minim;
        public AudioPlayer ap;
        FFT fft;
        private float bass;
        private float mid;
        private float treble;

        AudioController(Minim minim) {
            this.minim = minim;
            this.ap = minim.loadFile("Exit the Premises.mp3");
            this.ap.play();
            this.fft = new FFT(this.ap.bufferSize(), this.ap.sampleRate());
        }

        public void update() {
            this.treble = 0.0f;
            this.mid = 0.0f;
            this.bass = 0.0f;
            int thirdOfBand = (this.fft.specSize() - 120) / 3;
            this.fft.forward(this.ap.mix);
            int i = 20;
            while (i < this.fft.specSize() - 100) {
                if (i < thirdOfBand) {
                    this.bass += this.fft.getBand(i);
                } else if (i - thirdOfBand < thirdOfBand) {
                    this.mid += this.fft.getBand(i);
                } else {
                    this.treble += this.fft.getBand(i);
                }
                ++i;
            }
            this.bass = this.bass / (float)thirdOfBand / 8.0f;
            this.mid = this.mid / (float)thirdOfBand / 3.75f;
            this.treble = this.treble / (float)thirdOfBand / 2.85f;
        }

        public float getBassIntensity() {
            return this.bass;
        }

        public float getMidIntensity() {
            return this.mid;
        }

        public float getTrebleIntensity() {
            return this.treble;
        }
    }

    class CameraController {
        public PVector pos;
        private PVector lookAt;
        private MovementTracker movement;
        private Moonlander ml;
        private ArrayList<PVector> waypoints;
        private PVector viewTarget;

        public CameraController(Moonlander _ml) {
            this.pos = new PVector(0.0f, 0.0f, 0.0f);
            this.lookAt = new PVector(0.0f, 0.0f, 0.0f);
            this.movement = new MovementTracker(this.pos, this.lookAt);
            this.ml = _ml;
            this.waypoints = new ArrayList();
            this.movement.route = this.waypoints;
        }

        public CameraController(PVector _pos, PVector _lookAt, Moonlander _ml) {
            this.pos = _pos;
            this.lookAt = _lookAt;
            this.movement = new MovementTracker(this.pos, this.lookAt);
            this.ml = _ml;
            this.waypoints = new ArrayList();
            this.movement.route = this.waypoints;
        }

        public void addWayPoints(ArrayList<PVector> p) {
            if (this.movement.route == null) {
                this.movement.route = this.waypoints;
            }
            this.waypoints.addAll(p);
        }

        public void setViewTarget(PVector _target) {
            this.movement.fixedTarget = this.viewTarget = _target;
        }

        public void update() {
            float time = (float)this.ml.getValue("camera");
            this.movement.update(time);
            Graffathon.this.camera(this.pos.x, this.pos.y, this.pos.z, this.lookAt.x, this.lookAt.y, this.lookAt.z, 0.0f, 1.0f, 0.0f);
        }
    }

    class City {
        private static final float w = 25.0f;
        private static final float h_avg = 150.0f;
        private static final float h_stdev = 100.0f;
        private static final int drawAmount = 35;
        private float density;
        private int blockSize;
        private boolean active = false;
        private HashMap<Integer, HashMap<Integer, House>> houses;

        City(float _density, int _block) {
            this.density = _density;
            this.blockSize = _block;
            this.houses = new HashMap();
        }

        public void draw(PVector pos) {
            float _x = pos.x;
            float _z = pos.z;
            this.genHouses(_x, _z);
            int x_index = Graffathon.floor((float)(_x / (25.0f / this.density)));
            int z_index = Graffathon.floor((float)(_z / (25.0f / this.density)));
            int n = x_index < 0 ? -1 : 1;
            z_index -= Graffathon.floor((float)(z_index / (this.blockSize + 1))) * ((x_index -= Graffathon.floor((float)(x_index / (this.blockSize + 1))) * n) < 0 ? -1 : 1);
            int x = x_index - 35;
            while (x < x_index + 35) {
                Graffathon.this.pushMatrix();
                Graffathon.this.translate((float)(x + Graffathon.floor((float)(x / (this.blockSize + 1)))) * (25.0f / this.density), 0.0f, 0.0f);
                int z = z_index - 35;
                while (z < z_index + 35) {
                    Graffathon.this.pushMatrix();
                    Graffathon.this.translate(0.0f, 0.0f, (float)(z + Graffathon.floor((float)(z / (this.blockSize + 1)))) * (25.0f / this.density));
                    this.houses.get(x).get(z).update_height(this.active);
                    this.houses.get(x).get(z).draw();
                    Graffathon.this.popMatrix();
                    ++z;
                }
                Graffathon.this.popMatrix();
                ++x;
            }
        }

        public float getBlockDist(int n) {
            return 25.0f / this.density * ((float)((this.blockSize + 1) * n) - 0.5f) + 25.0f;
        }

        public void setActive(boolean value) {
            this.active = value;
        }

        public void genHouses(float _x, float _z) {
            int x_index = Graffathon.floor((float)(_x / (25.0f / this.density)));
            int z_index = Graffathon.floor((float)(_z / (25.0f / this.density)));
            int n = x_index < 0 ? -1 : 1;
            z_index -= Graffathon.floor((float)(z_index / (this.blockSize + 1))) * ((x_index -= Graffathon.floor((float)(x_index / (this.blockSize + 1))) * n) < 0 ? -1 : 1);
            int x = x_index - 35;
            while (x < x_index + 35) {
                if (this.houses.get(x) == null) {
                    this.houses.put(x, new HashMap());
                }
                int z = z_index - 35;
                while (z < z_index + 35) {
                    if (this.houses.get(x).get(z) == null) {
                        float h = Graffathon.abs((float)(Graffathon.this.randomGaussian() * 100.0f + 150.0f));
                        this.houses.get(x).put(z, new House(25.0f, 25.0f, h));
                    }
                    ++z;
                }
                ++x;
            }
        }
    }

    class CityScene
    extends Scene {
        CityScene(CameraController camera, AudioController audio, Ship ship, City city, TerrainManager terrain) {
            super(camera, audio, ship, city, terrain);
            city.setActive(true);
            ArrayList<PVector> route = new ArrayList<PVector>();
            float radius = 1200.0f;
            route.add(new PVector(0.0f, -1200.0f, radius));
            route.add(new PVector(radius / 4.0f, -1150.0f, 3.0f * radius / 4.0f));
            route.add(new PVector(radius / 2.0f, -1100.0f, radius / 2.0f));
            route.add(new PVector(3.0f * radius / 4.0f, -1050.0f, radius / 4.0f));
            route.add(new PVector(radius, -1000.0f, 0.0f));
            route.add(new PVector(3.0f * radius / 4.0f, -950.0f, -radius / 4.0f));
            route.add(new PVector(radius / 2.0f, -900.0f, -radius / 2.0f));
            route.add(new PVector(radius / 4.0f, -850.0f, -3.0f * radius / 4.0f));
            route.add(new PVector(0.0f, -800.0f, -radius));
            route.add(new PVector(-radius / 4.0f, -750.0f, -3.0f * radius / 4.0f));
            route.add(new PVector(-radius / 2.0f, -700.0f, -radius / 2.0f));
            route.add(new PVector(-3.0f * radius / 4.0f, -650.0f, -radius / 4.0f));
            route.add(new PVector(-radius, -600.0f, 0.0f));
            route.add(new PVector(-3.0f * radius / 4.0f, -550.0f, radius / 4.0f));
            route.add(new PVector(-radius / 2.0f, -500.0f, radius / 2.0f));
            route.add(new PVector(-radius / 4.0f, -450.0f, 3.0f * radius / 4.0f));
            route.add(new PVector(0.0f, -400.0f, radius));
            route.add(new PVector(100.0f, -400.0f, 600.0f));
            route.add(new PVector(400.0f, -400.0f, -1200.0f));
            route.add(new PVector(1200.0f, -500.0f, 15.0f));
            route.add(new PVector(0.0f, -500.0f, 15.0f));
            route.add(new PVector(320.0f, -400.0f, 320.0f));
            route.add(new PVector(-320.0f, -100.0f, -320.0f));
            route.add(new PVector(0.0f, -1200.0f, 0.0f));
            this.camera.addWayPoints(route);
            camera.setViewTarget(new PVector(0.0f, 50.0f, 0.0f));
            ArrayList<PVector> shipRoute = new ArrayList<PVector>();
            shipRoute.add(new PVector(320.0f, -400.0f, 320.0f));
            this.ship.addWayPoints(shipRoute);
        }

        @Override
        public Scene update() {
            if (this.camera.movement.isVisited(16)) {
                this.camera.setViewTarget(new PVector(100.0f, -200.0f, 0.0f));
            }
            if (this.camera.movement.isVisited(18)) {
                this.camera.setViewTarget(new PVector(1200.0f, -350.0f, 0.0f));
            }
            if (this.camera.movement.isVisited(19)) {
                this.camera.setViewTarget(new PVector(-1000.0f, -400.0f, 15.0f));
            }
            if (this.camera.movement.allVisited()) {
                return new FollowScene(this.camera, this.audio, this.ship, this.city, this.terrain);
            }
            return this;
        }
    }

    class DumbShip {
        public final PVector size;
        public final float speedMultiplier;
        public final PVector offset;

        public DumbShip(PVector size, float speedMultiplier, PVector offset) {
            this.size = size;
            this.speedMultiplier = speedMultiplier;
            this.offset = offset;
        }

        public void draw(PVector pos, float rotationX) {
            Graffathon.this.pushMatrix();
            Graffathon.this.translate(pos.x, pos.y, pos.z);
            Graffathon.this.rotateY(rotationX);
            Graffathon.this.box(this.size.x, this.size.y, this.size.z);
            Graffathon.this.popMatrix();
        }
    }

    class FollowScene
    extends Scene {
        FollowScene(CameraController camera, AudioController audio, Ship ship, City city, TerrainManager terrain) {
            super(camera, audio, ship, city, terrain);
            terrain.setMountainsStatic(true);
            this.camera.setViewTarget(this.ship.pos);
            ArrayList<PVector> route = new ArrayList<PVector>();
            route.add(new PVector(320.0f, -500.0f, 640.0f));
            route.add(new PVector(320.0f, -500.0f, 3000.0f));
            route.add(new PVector(640.0f, -500.0f, 5900.0f));
            route.add(new PVector(320.0f, -500.0f, 15100.0f));
            route.add(new PVector(5100.0f, -500.0f, 15100.0f));
            route.add(new PVector(3000.0f, -1000.0f, 13000.0f));
            this.camera.addWayPoints(route);
            ArrayList<PVector> shipRoute = new ArrayList<PVector>();
            shipRoute.add(new PVector(320.0f, -400.0f, 320.0f));
            shipRoute.add(new PVector(320.0f, -400.0f, 3000.0f));
            shipRoute.add(new PVector(320.0f, -200.0f, 15100.0f));
            shipRoute.add(new PVector(5200.0f, -200.0f, 15100.0f));
            shipRoute.add(new PVector(8000.0f, -1000.0f, 18050.0f));
            this.ship.addWayPoints(shipRoute);
            city.setActive(true);
        }

        @Override
        public Scene update() {
            if (this.ship.movement.allVisited()) {
                float endTime = (float)Graffathon.this.ml.getValue("time");
                Graffathon.println((float)endTime);
                Graffathon.this.camera();
                Graffathon.this.fill(230.0f, 230.0f, 230.0f);
                if (endTime >= 0.5f) {
                    Graffathon.this.beginShape(16);
                    Graffathon.this.vertex(-100.0f, -100.0f, 0.0f);
                    Graffathon.this.vertex(-100.0f, Graffathon.this.height + 100, 0.0f);
                    Graffathon.this.vertex((float)Graffathon.this.width / 3.0f, Graffathon.this.height + 100, 0.0f);
                    Graffathon.this.vertex((float)Graffathon.this.width / 4.0f, -100.0f, 0.0f);
                    Graffathon.this.endShape();
                }
                if (endTime >= 1.0f) {
                    Graffathon.this.beginShape(16);
                    Graffathon.this.vertex(Graffathon.this.width + 100, -100.0f, 0.0f);
                    Graffathon.this.vertex(Graffathon.this.width + 100, Graffathon.this.height + 100, 0.0f);
                    Graffathon.this.vertex((float)Graffathon.this.width - (float)Graffathon.this.width / 3.0f, Graffathon.this.height + 100, 0.0f);
                    Graffathon.this.vertex((float)Graffathon.this.width - (float)Graffathon.this.width / 4.0f, -100.0f, 0.0f);
                    Graffathon.this.endShape();
                }
                if (endTime >= 1.5f) {
                    Graffathon.this.beginShape(16);
                    Graffathon.this.vertex(Graffathon.this.width + 100, -100.0f, 0.0f);
                    Graffathon.this.vertex(Graffathon.this.width + 100, Graffathon.this.height + 100, 0.0f);
                    Graffathon.this.vertex(-100.0f, Graffathon.this.height + 100, 0.0f);
                    Graffathon.this.vertex(-100.0f, -100.0f, 0.0f);
                    Graffathon.this.endShape();
                }
                if (endTime >= 2.5f) {
                    Graffathon.this.fill(0.0f, 0.0f, 0.0f);
                    Graffathon.this.textSize(72.0f);
                    Graffathon.this.text("Heart of Neon", 138.0f, 96.0f);
                    Graffathon.this.text("GNU/Konala", 240.0f, 280.0f);
                }
                if (endTime >= 3.5f) {
                    Graffathon.this.textSize(48.0f);
                    Graffathon.this.text("impliedfeline", Graffathon.this.width - 360, Graffathon.this.height - 64);
                }
                if (endTime >= 3.7f) {
                    Graffathon.this.text("ruuben", Graffathon.this.width - 360, Graffathon.this.height - 192);
                }
                if (endTime >= 3.9f) {
                    Graffathon.this.text("flai", Graffathon.this.width - 360, Graffathon.this.height - 320);
                }
                if (endTime >= 5.0f) {
                    Graffathon.this.text("Music: Kevin MacLeod - Exit the Premises", 22.0f, Graffathon.this.height - 96);
                }
                if (endTime >= 10.0f) {
                    Graffathon.this.exit();
                }
                Graffathon.this.ac.ap.setGain(-32.0f * endTime / 10.0f);
                return this;
            }
            return this;
        }
    }

    class House {
        private float w;
        private float d;
        private float h;
        private float current_h = 0.0f;
        private static final float growSpeed = 5.0f;
        private float prevMillis = 0.0f;

        House(float _w, float _d, float _h) {
            this.w = _w;
            this.d = _d;
            this.h = _h;
            this.prevMillis = Graffathon.this.millis();
        }

        public void draw() {
            if (Graffathon.abs((float)this.current_h) < 0.01f) {
                return;
            }
            Graffathon.this.pushMatrix();
            Graffathon.this.translate(0.0f, -this.current_h / 2.0f, 0.0f);
            Graffathon.this.fill(Graffathon.this.color(24, 24, 64));
            Graffathon.this.stroke(128.0f, 64.0f, 64.0f);
            Graffathon.this.shapeMode(0);
            Graffathon.this.box(this.w, this.current_h, this.d);
            Graffathon.this.popMatrix();
        }

        public void update_height(boolean active) {
            if (this.current_h >= this.h) {
                return;
            }
            float coeff = active ? 1 : -1;
            this.current_h += coeff * 5.0f * ((float)Graffathon.this.millis() - this.prevMillis) / 1000.0f;
            this.current_h = Graffathon.constrain((float)this.current_h, (float)0.0f, (float)this.h);
        }
    }

    class LineEffect {
        final int maxX = 1000;
        final int maxY = -3000;
        final int maxZ = 1000;
        ArrayList<PVector> lines = new ArrayList();
        float millisCounter = 0.0f;
        float lastTime = 0.0f;

        LineEffect() {
        }

        public void update() {
            float elapsedTime = (float)Graffathon.this.millis() - this.lastTime;
            this.lastTime = Graffathon.this.millis();
            if (this.millisCounter > 0.0f) {
                this.millisCounter -= elapsedTime;
                return;
            }
            this.millisCounter = 0.0f;
            this.lines.clear();
            int i = 0;
            while (i < 50) {
                this.lines.add(new PVector(Graffathon.this.random(-1000.0f, 1000.0f), 0.0f, Graffathon.this.random(-1000.0f, 1000.0f)));
                ++i;
            }
        }

        public void draw() {
            for (PVector line : this.lines) {
                int colour = (int)Graffathon.this.random(0.0f, 3.0f);
                if (colour == 0) {
                    Graffathon.this.stroke(255.0f, 0.0f, 0.0f);
                } else if (colour == 1) {
                    Graffathon.this.stroke(0.0f, 255.0f, 0.0f);
                } else {
                    Graffathon.this.stroke(0.0f, 0.0f, 255.0f);
                }
                float xOffSet = Graffathon.this.random(-1.0f, 1.0f);
                float zOffSet = Graffathon.this.random(-1.0f, 1.0f);
                Graffathon.this.strokeWeight(4.0f);
                Graffathon.this.line(line.x + xOffSet * 1000.0f / 2.0f, 0.0f, line.z + zOffSet * 1000.0f / 2.0f, line.x - xOffSet * 1000.0f / 2.0f, -3000.0f, line.z - zOffSet * 1000.0f / 2.0f);
                Graffathon.this.strokeWeight(1.0f);
            }
        }
    }

    class MovementTracker {
        private PVector pos;
        private PVector lookAt;
        private static final int prevSize = 15;
        private ArrayDeque<PVector> prevPos;
        public int lastVisited = -1;
        private static final float steeringPower = 0.02f;
        public float maxVel = 5.0f;
        public ArrayList<PVector> route;
        public PVector fixedTarget;

        public MovementTracker() {
            this.pos = new PVector(0.0f, 0.0f, 0.0f);
            this.prevPos = new ArrayDeque(15);
            this.prevPos.addLast(new PVector(0.0f, 0.0f, 0.0f));
            this.lookAt = new PVector(0.0f, 0.0f, 0.0f);
        }

        public MovementTracker(PVector _pos, PVector _lookAt) {
            this.pos = _pos;
            this.prevPos = new ArrayDeque(15);
            this.prevPos.add(this.pos.copy());
            this.lookAt = _lookAt;
        }

        public boolean isVisited(int index) {
            return index <= this.lastVisited;
        }

        public boolean allVisited() {
            return this.route.size() - 1 <= this.lastVisited;
        }

        public void update(float lerpValue) {
            int prev;
            int next = Graffathon.ceil((float)lerpValue);
            this.lastVisited = prev = Graffathon.floor((float)lerpValue);
            if (this.route.size() <= next) {
                return;
            }
            PVector goal = this.route.get(next);
            PVector start = this.route.get(prev);
            PVector heading = PVector.lerp((PVector)start, (PVector)goal, (float)(lerpValue - (float)prev));
            PVector vel = this.pos.copy().sub(this.prevPos.peek()).div((float)this.prevPos.size());
            PVector direction = goal.copy().sub(this.pos);
            float deg = PVector.angleBetween((PVector)direction, (PVector)goal);
            PVector steering = direction.copy().limit(0.02f).mult(Graffathon.abs((float)(deg / (float)Math.PI)));
            PVector newVel = vel.copy().add(steering).limit(this.maxVel);
            PVector steered = this.pos.copy().add(newVel);
            PVector newPos = PVector.lerp((PVector)steered, (PVector)heading, (float)(lerpValue - (float)prev));
            if (this.prevPos.size() >= 15) {
                this.prevPos.removeFirst();
            }
            this.prevPos.add(this.pos.copy());
            this.pos.set(newPos);
            if (this.fixedTarget == null) {
                PVector lookDirection = this.pos.copy().add(vel);
                this.lookAt.set(lookDirection);
            } else {
                this.lookAt.set(this.fixedTarget);
            }
        }
    }

    abstract class Scene {
        protected CameraController camera;
        protected AudioController audio;
        protected Ship ship;
        protected City city;
        protected TerrainManager terrain;

        Scene(CameraController camera, AudioController audio, Ship ship, City city, TerrainManager terrain) {
            this.camera = camera;
            this.audio = audio;
            this.ship = ship;
            this.city = city;
            this.terrain = terrain;
        }

        public abstract Scene update();
    }

    class Ship {
        private PShape model;
        public PVector pos;
        public PVector direction;
        public MovementTracker movement;
        private Moonlander ml;
        private ArrayList<PVector> waypoints;

        Ship(PVector _pos, Moonlander _ml) {
            this.pos = _pos;
            this.direction = new PVector(0.0f, 0.0f, 0.0f);
            this.movement = new MovementTracker(this.pos, this.direction);
            this.model = Graffathon.this.loadShape("ship.obj");
            this.ml = _ml;
            this.waypoints = new ArrayList();
            this.movement.route = this.waypoints;
        }

        public void addWayPoints(ArrayList<PVector> p) {
            if (this.movement.route == null) {
                this.movement.route = this.waypoints;
            }
            this.waypoints.addAll(p);
        }

        public void draw() {
            float time = (float)this.ml.getValue("ship");
            this.movement.update(time);
            Graffathon.this.pushMatrix();
            Graffathon.this.translate(this.pos.x, this.pos.y, this.pos.z);
            Graffathon.this.scale(0.75f);
            PVector diff = this.direction.copy().sub(this.pos);
            float rotY = Graffathon.atan2((float)diff.x, (float)diff.z);
            Graffathon.this.rotateY(rotY);
            Graffathon.this.shape(this.model);
            Graffathon.this.popMatrix();
        }
    }

    class ShipRow {
        public static final float BaseSpeed = 40.0f;
        public final PVector from;
        public final PVector to;
        public final float dist;
        public final int count;
        private ArrayList<DumbShip> ships = new ArrayList();

        public ShipRow(PVector from, PVector to) {
            this.from = from;
            this.to = to;
            this.dist = from.dist(to);
            this.count = (int)(this.dist / 10.0f);
            this.generateShips();
        }

        public void draw() {
            float seconds = (float)Graffathon.this.millis() / 1000.0f;
            float speed = 40.0f / this.dist;
            float spacing = 1.0f / (float)this.count;
            Graffathon.this.fill(24.0f, 24.0f, 40.0f);
            Graffathon.this.stroke(96.0f, 96.0f, 160.0f);
            Graffathon.this.strokeWeight(1.0f);
            PVector diff = this.to.copy().sub(this.from);
            float rotationX = Graffathon.atan2((float)diff.x, (float)diff.z);
            int i = 0;
            while (i < this.ships.size()) {
                this.ships.get(i).draw(PVector.lerp((PVector)this.from, (PVector)this.to, (float)((spacing * (float)i + seconds * speed * this.ships.get((int)i).speedMultiplier) % 1.0f)).add(this.ships.get((int)i).offset), rotationX);
                ++i;
            }
        }

        public void generateShips() {
            int i = 0;
            while (i < this.count) {
                float width = Graffathon.this.random(2.5f, 4.0f);
                float height = Graffathon.this.random(1.2f, 2.0f);
                float depth = Graffathon.this.random(5.0f, 10.0f);
                PVector offset = new PVector(Graffathon.this.random(-4.0f, 4.0f), Graffathon.this.random(-4.0f, 4.0f), 0.0f);
                this.ships.add(new DumbShip(new PVector(width, height, depth), Graffathon.this.random(0.5f, 1.5f), offset));
                ++i;
            }
        }
    }

    class ShipRowManager {
        ArrayList<ShipRow> shipRows = new ArrayList();
        float y = 0.0f;
        boolean visible = true;

        ShipRowManager() {
            this.shipRows.add(new ShipRow(new PVector(-1550.0f, -360.0f, -40.0f), new PVector(1000.0f, -360.0f, -40.0f)));
            this.shipRows.add(new ShipRow(new PVector(-40.0f, -400.0f, -1500.0f), new PVector(-40.0f, -400.0f, 1000.0f)));
            this.shipRows.add(new ShipRow(new PVector(-1000.0f, -380.0f, -1000.0f), new PVector(1000.0f, -380.0f, 1000.0f)));
            int i = 1;
            while (i < 7) {
                int axis = (int)Graffathon.this.random(-10.0f, 5.0f);
                int start = (int)Graffathon.this.random(-20.0f, 20.0f);
                int goal = (int)Graffathon.this.random(-20.0f, 20.0f);
                this.shipRows.add(new ShipRow(new PVector(Graffathon.this.c.getBlockDist(axis), (float)(-70 * i), Graffathon.this.c.getBlockDist(start)), new PVector(Graffathon.this.c.getBlockDist(axis), (float)(-70 * i), Graffathon.this.c.getBlockDist(goal))));
                this.shipRows.add(new ShipRow(new PVector(Graffathon.this.c.getBlockDist(start), (float)(-70 * i), Graffathon.this.c.getBlockDist(axis)), new PVector(Graffathon.this.c.getBlockDist(goal), (float)(-70 * i), Graffathon.this.c.getBlockDist(axis))));
                ++i;
            }
        }

        public void setIsVisible(boolean val) {
            if (!val) {
                this.y = 640.0f;
            }
            this.visible = val;
        }

        public void draw() {
            if (this.visible && this.y > 0.0f) {
                this.y -= 1.0f / Graffathon.this.frameRate * 600.0f;
            }
            Graffathon.this.pushMatrix();
            Graffathon.this.translate(0.0f, this.y, 0.0f);
            for (ShipRow shipRow : this.shipRows) {
                shipRow.draw();
            }
            Graffathon.this.popMatrix();
        }
    }

    class Sky {
        private PShader skyShader;

        public Sky() {
            this.skyShader = Graffathon.this.loadShader("sky-frag.glsl", "sky-vert.glsl");
        }

        public void draw(PVector cameraPos, float intensity) {
            this.skyShader.set("intensity", intensity);
            Graffathon.this.shader(this.skyShader);
            Graffathon.this.pushMatrix();
            Graffathon.this.translate(cameraPos.x, cameraPos.y, cameraPos.z);
            Graffathon.this.noStroke();
            Graffathon.this.sphere(5000.0f);
            Graffathon.this.popMatrix();
            Graffathon.this.resetShader();
        }
    }

    class StartScene
    extends Scene {
        private static final float StartZ = -8000.0f;
        private ShipRowManager shipRows;

        StartScene(CameraController camera, AudioController audio, Ship ship, City city, TerrainManager terrain, ShipRowManager shipRow) {
            super(camera, audio, ship, city, terrain);
            this.shipRows = shipRow;
            terrain.setMountainsStatic(false);
            terrain.setRenderingOutside(true);
            this.shipRows.setIsVisible(false);
            city.setActive(false);
        }

        @Override
        public Scene update() {
            float time = Graffathon.constrain((float)((float)Graffathon.this.ml.getValue("time")), (float)0.0f, (float)1.0f);
            float y = time < 0.48f ? -520.0f : Graffathon.lerp((float)-520.0f, (float)-50.0f, (float)this.slerp(0.0f, 1.0f, Graffathon.constrain((float)((time - 0.48f) * 4.5f), (float)0.0f, (float)1.0f)));
            PVector cameraPos = PVector.lerp((PVector)new PVector(30.0f, y, -8000.0f), (PVector)new PVector(30.0f, y, 0.0f), (float)this.slerp(0.0f, 1.0f, time));
            this.camera.pos.set(cameraPos);
            this.ship.pos.set(PVector.lerp((PVector)new PVector(0.0f, -120.0f, -8000.0f), (PVector)new PVector(0.0f, -120.0f, 0.0f), (float)this.slerp(0.0f, 1.0f, time)));
            this.camera.lookAt.set(new PVector(0.0f, -120.0f, 10000.0f));
            if (time > 0.75f) {
                this.terrain.setRenderingOutside(false);
            }
            if (time > 0.93f) {
                this.shipRows.setIsVisible(true);
            }
            if (time > 0.95f) {
                this.city.setActive(true);
            }
            if (time > 0.999f) {
                this.terrain.setMountainsStatic(true);
                return new CityScene(this.camera, this.audio, this.ship, this.city, this.terrain);
            }
            return this;
        }

        public PVector slerp(PVector from, PVector to, float t) {
            return new PVector(this.slerp(from.x, to.x, t), this.slerp(from.y, to.y, t), this.slerp(from.z, to.z, t));
        }

        public float slerp(float edge0, float edge1, float x) {
            x = this.clamp((x - edge0) / (edge1 - edge0), 0.0f, 1.0f);
            return x * x * (3.0f - 2.0f * x);
        }

        public float clamp(float x, float lowerlimit, float upperlimit) {
            if (x < lowerlimit) {
                x = lowerlimit;
            }
            if (x > upperlimit) {
                x = upperlimit;
            }
            return x;
        }
    }

    class Terrain {
        public static final int GridCellSize = 50;
        public final float[] heightMap;
        public final boolean[] isMountain;
        public final int _sizeX;
        public final int _sizeY;
        public final int hmapSizeX;
        public final int hmapSizeY;
        public final int hmapOffsetX;
        public final int hmapOffsetY;
        public final boolean isMountains;
        public final ArrayList<PVector> vertices = new ArrayList();
        public final PShape shape;
        private final float HeightMapBias = 100.0f;

        public Terrain(int sizeX, int sizeY, int hmapOffsetX, int hmapOffsetY, boolean isMountains) {
            this._sizeX = sizeX;
            this._sizeY = sizeY;
            this.hmapSizeX = sizeX / 50;
            this.hmapSizeY = sizeY / 50;
            this.hmapOffsetX = hmapOffsetX;
            this.hmapOffsetY = hmapOffsetY;
            this.isMountains = isMountains;
            this.isMountain = new boolean[(this.hmapSizeX + 1) * (this.hmapSizeY + 1)];
            this.heightMap = this.generateHeightMap(this.hmapSizeX, this.hmapSizeY);
            this.shape = Graffathon.this.createShape();
            this.genVertices();
        }

        public void draw(PVector cameraPos) {
            this.draw(cameraPos, false);
        }

        public void draw(PVector cameraPos, boolean forceDrawWithCamera) {
            Graffathon.this.pushMatrix();
            PVector t = new PVector(cameraPos.x - cameraPos.x % 50.0f, cameraPos.z - cameraPos.z % 50.0f);
            PVector baseOffset = new PVector((float)(-this._sizeX / 2) + (float)this.hmapOffsetX / 50.0f * (float)this._sizeX, (float)(-this._sizeY / 2) + (float)this.hmapOffsetY / 50.0f * (float)this._sizeY);
            if (forceDrawWithCamera) {
                Graffathon.this.translate(baseOffset.x, 0.0f, baseOffset.y);
            } else if (!this.isMountains) {
                Graffathon.this.translate(baseOffset.x + t.x, 0.0f, baseOffset.y + t.y);
            } else {
                Graffathon.this.translate(baseOffset.x + cameraPos.x, 0.0f, baseOffset.y + cameraPos.z);
            }
            this.shape.setFill(Graffathon.this.color(24, 24, 64));
            this.shape.setStroke(Graffathon.this.color(255, 0, 0));
            this.shape.setStrokeWeight(2.0f);
            Graffathon.this.shape(this.shape);
            Graffathon.this.popMatrix();
        }

        private void genVertices() {
            this.shape.setFill(Graffathon.this.color(24, 24, 64));
            this.shape.beginShape(17);
            int hx = 0;
            while (hx < this.hmapSizeX) {
                int hy = 0;
                while (hy < this.hmapSizeY) {
                    if (this.isMountains == this.isMountain[hx + hy * this.hmapSizeX]) {
                        float x = hx * 50;
                        float y = hy * 50;
                        Graffathon.this.stroke(255.0f, 0.0f, 0.0f);
                        Graffathon.this.strokeWeight(2.0f);
                        this.shape.vertex(x, this.getZ(hx, hy), y);
                        this.shape.vertex(x + 50.0f, this.getZ(hx + 1, hy), y);
                        this.shape.vertex(x + 50.0f, this.getZ(hx + 1, hy + 1), y + 50.0f);
                        this.shape.vertex(x, this.getZ(hx, hy + 1), y + 50.0f);
                        this.vertices.add(new PVector(x, this.getZ(hx, hy), y));
                        this.vertices.add(new PVector(x + 50.0f, this.getZ(hx + 1, hy), y));
                        this.vertices.add(new PVector(x + 50.0f, this.getZ(hx + 1, hy + 1), y + 50.0f));
                        this.vertices.add(new PVector(x, this.getZ(hx, hy + 1), y + 50.0f));
                    }
                    ++hy;
                }
                ++hx;
            }
            this.shape.endShape();
        }

        private float getZ(int x, int y) {
            x = Graffathon.constrain((int)x, (int)0, (int)(this.hmapSizeX - 1));
            y = Graffathon.constrain((int)y, (int)0, (int)(this.hmapSizeY - 1));
            return this.heightMap[x + y * this.hmapSizeX] + 0.1f;
        }

        private float[] generateHeightMap(int sizeX, int sizeY) {
            float[] hmap = new float[sizeX * sizeY];
            PVector center = new PVector((float)sizeX, (float)sizeY).div(2.0f);
            int y = 0;
            while (y < sizeY) {
                int x = 0;
                while (x < sizeX) {
                    PVector cur = new PVector((float)x, (float)y);
                    float distFromCenter = center.dist(cur) / (float)(sizeX / 2);
                    if (this.hmapOffsetX != 0 || this.hmapOffsetY != 0) {
                        distFromCenter = 1.0f;
                    }
                    float multiplier = 10.0f;
                    float baseAdd = 0.0f;
                    this.isMountain[x + y * sizeX] = false;
                    if (distFromCenter > 0.6f) {
                        float lerpVal = (distFromCenter - 0.6f) * 5.0f;
                        multiplier = Graffathon.lerp((float)10.0f, (float)400.0f, (float)lerpVal);
                        baseAdd += Graffathon.lerp((float)0.0f, (float)-500.0f, (float)Graffathon.constrain((float)lerpVal, (float)0.0f, (float)1.0f));
                        this.isMountain[x + y * sizeX] = true;
                    }
                    if (this.hmapOffsetX != 0 || this.hmapOffsetY != 0) {
                        multiplier *= 0.2f;
                    }
                    int testX = x + this.hmapOffsetX;
                    int testY = y + this.hmapOffsetY;
                    hmap[x + y * sizeX] = Graffathon.this.noise((float)(testX * 50) / 100.0f, (float)(testY * 50) / 100.0f) * multiplier + baseAdd;
                    ++x;
                }
                ++y;
            }
            return hmap;
        }
    }

    class TerrainManager {
        static final int GridSize = 8000;
        Terrain grid;
        Terrain mountains;
        Terrain outsideMountains;
        boolean areMountainsStatic = false;
        boolean renderingOutside = false;

        public TerrainManager() {
            Graffathon.this.noiseSeed(0L);
            this.grid = new Terrain(8000, 8000, 0, 0, false);
            this.mountains = new Terrain(8000, 8000, 0, 0, true);
            this.outsideMountains = new Terrain(8000, 8000, 0, -50, true);
        }

        public void setMountainsStatic(boolean value) {
            this.areMountainsStatic = value;
        }

        public void setRenderingOutside(boolean val) {
            this.renderingOutside = val;
        }

        public void draw(CameraController camera) {
            boolean forceDrawWithCamera = !this.areMountainsStatic;
            this.grid.draw(camera.pos, forceDrawWithCamera);
            this.mountains.draw(camera.pos, forceDrawWithCamera);
            if (this.renderingOutside) {
                this.outsideMountains.draw(camera.pos, forceDrawWithCamera);
            }
        }
    }
}

