final int W = 1920, H = 1080;
//final int W = 960, H = 540;
//final int W = 2880/2, H = 1800/2;



import moonlander.library.*;

import ddf.minim.*;
import ddf.minim.analysis.*;

Moonlander moonlander;
Minim minim;
AudioPlayer song;
AudioSample explosion;

FFT fft;

PImage[] text = new PImage[8];

void settings() {
  size(W, H, P3D);
}

void setup() {
  frameRate(20);
  setupKuutamo();
  
  minim = new Minim(this);
  explosion = minim.loadSample("boom.wav", 512);
  song = minim.loadFile("tausta.mp3", 1024);
  MinimController controller = new MinimController(song, 60, 1);
  moonlander = new Moonlander(this, controller);
  
  text[1] = loadImage("text1_kuutamo.png");
  text[2] = loadImage("text2_graffathon.png");
  text[3] = loadImage("text3_tuomas.png");
  text[4] = loadImage("text4_juuso.png");
  text[5] = loadImage("text5_food.png");
  text[6] = loadImage("text6_greetings.png");

  fft = new FFT(song.bufferSize(), song.sampleRate());

  moonlander.start();
}

void draw() {
  moonlander.update();
  float t = (float)moonlander.getCurrentTime();
  
  fft.forward(song.mix);
  float bass = 0.f;
  for (int i = 0; i < 4; i++) { 
    bass += fft.getBand(i) * 0.25f;
  }
  println(bass);
  drawSpectrum(fft);
  
  float pumpThreshold = (float)moonlander.getValue("thresh");
  float pumpStrength = (float)moonlander.getValue("pump");
  
  if (bass > pumpThreshold) {
    float x = sin(t/PI) * 0.3 + random(-0.2, 0.2);
    float y = cos(t/5) * 0.3 + random(-0.2, 0.2);
    pump(x, y, 1000, pumpStrength*random(0.2,0.4));
  }
  
  int phase = (int)moonlander.getValue("phase");
  if (phase == 1) {
    explosion.trigger();
  }
  if (phase == 2) {
    exit();
  }
  
  drawKuutamo(t, bass, phase);
  
  if (phase == 3 || phase == 4) {
    drawGrid(t, bass, 1);
  }
  
  int textNum = (int)moonlander.getValue("textNum");
  if (textNum > 0) {
    float text_x = (float)moonlander.getValue("textX");
    float text_y = (float)moonlander.getValue("textY");
    float text_ripple = (float)moonlander.getValue("textRipple");
    drawText(text_x*960, text_y*540, text_ripple*540, text[textNum]);
  }
}