/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.AudioSample;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;
import moonlander.library.Controller;
import moonlander.library.MinimController;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class kuutamo
extends PApplet {
    final int W = 1440;
    final int H = 900;
    Moonlander moonlander;
    Minim minim;
    AudioPlayer song;
    AudioSample explosion;
    FFT fft;
    PImage[] text = new PImage[8];
    int block_w = 20;
    int block_h = 20;
    float b_rot = 0.0f;
    final int N = 100;
    float[][] ARR = new float[100][100];
    float[][] ARRVEL = new float[100][100];
    PVector[][] norm = new PVector[100][100];
    PImage img;
    PImage img_mask;
    PImage tex;
    boolean FILL = true;
    int R = 10000;
    PVector[] rockets = new PVector[this.R];
    float[] init_time = new float[this.R];
    int[] rocket_col = new int[this.R];
    float rocket_start = 25.0f;
    float rocket_delay = 10.0f;
    float rocket_flytime = 10.0f;
    float cube_start = 45.0f;
    float shadow_start = 75.0f;
    float cube_stop = 114.0f;

    public void settings() {
        this.size(1440, 900, "processing.opengl.PGraphics3D");
    }

    public void setup() {
        this.frameRate(20.0f);
        this.setupKuutamo();
        this.minim = new Minim((Object)this);
        this.explosion = this.minim.loadSample("../music/boom.wav", 512);
        this.song = this.minim.loadFile("../music/tausta.mp3", 1024);
        MinimController controller = new MinimController(this.song, 60, 1);
        this.moonlander = new Moonlander((PApplet)this, (Controller)controller);
        this.text[1] = this.loadImage("text1_kuutamo.png");
        this.text[2] = this.loadImage("text2_graffathon.png");
        this.text[3] = this.loadImage("text3_tuomas.png");
        this.text[4] = this.loadImage("text4_juuso.png");
        this.text[5] = this.loadImage("text5_food.png");
        this.text[6] = this.loadImage("text6_greetings.png");
        this.fft = new FFT(this.song.bufferSize(), this.song.sampleRate());
        this.moonlander.start();
    }

    public void draw() {
        int textNum;
        int phase;
        this.moonlander.update();
        float t = (float)this.moonlander.getCurrentTime();
        this.fft.forward(this.song.mix);
        float bass = 0.0f;
        int i = 0;
        while (i < 4) {
            bass += this.fft.getBand(i) * 0.25f;
            ++i;
        }
        kuutamo.println((float)bass);
        this.drawSpectrum(this.fft);
        float pumpThreshold = (float)this.moonlander.getValue("thresh");
        float pumpStrength = (float)this.moonlander.getValue("pump");
        if (bass > pumpThreshold) {
            float x = kuutamo.sin((float)(t / (float)Math.PI)) * 0.3f + this.random(-0.2f, 0.2f);
            float y = kuutamo.cos((float)(t / 5.0f)) * 0.3f + this.random(-0.2f, 0.2f);
            this.pump(x, y, 1000.0f, pumpStrength * this.random(0.2f, 0.4f));
        }
        if ((phase = (int)this.moonlander.getValue("phase")) == 1) {
            this.explosion.trigger();
        }
        if (phase == 2) {
            this.exit();
        }
        this.drawKuutamo(t, bass, phase);
        if (phase == 3 || phase == 4) {
            this.drawGrid(t, bass, 1);
        }
        if ((textNum = (int)this.moonlander.getValue("textNum")) > 0) {
            float text_x = (float)this.moonlander.getValue("textX");
            float text_y = (float)this.moonlander.getValue("textY");
            float text_ripple = (float)this.moonlander.getValue("textRipple");
            this.drawText(text_x * 960.0f, text_y * 540.0f, text_ripple * 540.0f, this.text[textNum]);
        }
    }

    public void drawGrid(float t, float bass, int type) {
        this.pushMatrix();
        this.camera(480.0f, 270.0f, 490.0f, 480.0f, 270.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.noLights();
        int nx = 960 / this.block_w;
        int ny = 540 / this.block_h;
        float cx = 0.355f;
        float cy = 0.28f;
        int iy = 0;
        while (iy < ny) {
            int ix = 0;
            while (ix < nx) {
                int px = (int)((float)ix - (float)nx * cx);
                int py = (int)((float)iy - (float)ny * cy);
                kuutamo.println((int)type);
                if (type < 1) {
                    this.plainBlocks(px, py, ix * this.block_w, iy * this.block_h, bass);
                } else if (type == 1) {
                    this.colorBlocks(px, py, ix * this.block_w, iy * this.block_h, bass, t);
                } else if (type == 2) {
                    this.plainSpheres(px, py, ix * this.block_w, iy * this.block_h, bass);
                } else {
                    this.plainRotatingBlocks(px, py, ix * this.block_w, iy * this.block_h, bass);
                }
                ++ix;
            }
            ++iy;
        }
        this.popMatrix();
    }

    public void plainBlocks(int ix, int iy, float x, float y, float bass) {
        float size = 1500.0f / (100.0f + (float)(ix * ix) + (float)(iy * iy) - bass);
        this.pushMatrix();
        this.translate(x, y, 1.0f);
        this.box(size);
        this.popMatrix();
    }

    public void plainRotatingBlocks(int ix, int iy, float x, float y, float bass) {
        float size = 5.0f + 1000.0f / (100.0f + (float)(ix * ix) + (float)(iy * iy) - bass);
        this.pushMatrix();
        this.translate(x, y, 1.0f);
        this.b_rot += bass * 3.0E-6f;
        this.rotate(this.b_rot);
        this.box(size);
        this.popMatrix();
    }

    public void plainSpheres(int ix, int iy, float x, float y, float bass) {
        float size = 1.0f + 1000.0f / (100.0f + (float)(ix * ix) + (float)(iy * iy) - bass);
        this.pushMatrix();
        this.translate(x, y, 1.0f);
        this.sphere(size);
        this.popMatrix();
    }

    public void colorBlocks(int ix, int iy, float x, float y, float bass, float t) {
        float size = 2000.0f / (100.0f + (float)(ix * ix) + (float)(iy * iy) - bass);
        float r = kuutamo.sqrt((float)(ix * ix + iy * iy));
        float angle = kuutamo.atan2((float)iy, (float)ix);
        float curl = 0.003f * bass;
        float h2 = 0.001f * bass + 1.0f * t + angle + curl * kuutamo.sin((float)r);
        float h = h2 - (float)((int)h2);
        this.colorMode(3, 1.0f);
        this.pushMatrix();
        this.fill(h, 0.8f, 1.0f);
        this.translate(x, y, 1.0f);
        this.box(size);
        this.popMatrix();
        this.colorMode(1, 256.0f);
    }

    public void setupKuutamo() {
        this.randomSeed(123124L);
        this.img = this.loadImage("cloud.jpg");
        this.img_mask = this.loadImage("cloud_mask.jpg");
        this.tex = this.createImage(this.img.width, this.img.height, 2);
        int k = 0;
        while (k < this.img.pixels.length) {
            int col = this.img.pixels[k];
            int mask = this.img_mask.pixels[k];
            float c = this.red(col);
            float alpha = this.red(mask);
            this.tex.pixels[k] = this.color(c / 2.0f, alpha * 1.5f);
            ++k;
        }
        k = 0;
        while (k < this.R) {
            float x = 2000.0f;
            float y = 2000.0f;
            while (kuutamo.sqrt((float)(x * x + y * y)) > 400.0f) {
                x = this.random(-400.0f, 400.0f);
                y = this.random(-400.0f, 400.0f);
            }
            this.rockets[k] = new PVector(x, y, 0.0f);
            this.init_time[k] = this.random(this.rocket_start, this.rocket_start + this.rocket_delay);
            this.rocket_col[k] = this.color(255);
            ++k;
        }
        int i = 0;
        while (i < 100) {
            int j = 0;
            while (j < 100) {
                float x = (float)i / 100.0f;
                float z = (float)j / 100.0f;
                this.ARR[i][j] = 0.1f * kuutamo.sin((float)((x + 2.0f * z) * (float)Math.PI * 4.0f)) * kuutamo.cos((float)((z - x) * 6.0f * (float)Math.PI)) + 0.2f * kuutamo.cos((float)(z * (float)Math.PI * 2.0f)) + this.random(-0.01f, 0.01f);
                this.ARRVEL[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
    }

    public void drawKuutamo(float t, float bass, int phase) {
        this.update();
        this.noStroke();
        if (t <= this.shadow_start) {
            this.FILL = true;
        } else if (t < this.cube_stop) {
            this.FILL = false;
            this.stroke(255);
            this.strokeWeight(1.0f);
            this.noFill();
        } else {
            this.FILL = true;
        }
        this.camera(0.0f, -0.3f + 0.025f * kuutamo.sin((float)(t * 2.0f)) + 0.025f, -1.0f, 0.0f, -0.225f + 0.025f * kuutamo.sin((float)(t * 2.0f)) + 0.025f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.perspective(0.7853982f, 1.6f, 0.01f, 500.0f);
        this.textureMode(1);
        this.lightSpecular(255.0f, 255.0f, 200.0f);
        this.pointLight(127.0f, 255.0f, 255.0f, 3.0f, -5.0f, 10.0f);
        this.ambientLight(255.0f, 255.0f, 255.0f);
        this.background(0.0f, 10.0f, 30.0f);
        this.pushMatrix();
        this.emissive(255.0f, 255.0f, 225.0f);
        this.specular(0.0f, 0.0f, 0.0f);
        this.ambient(0);
        this.translate(22.0f, -14.0f, 80.0f);
        this.sphereDetail(20);
        this.sphere(8.0f);
        this.popMatrix();
        int k = 0;
        while (k < this.R) {
            if (t > this.init_time[k] && t < this.init_time[k] + this.rocket_flytime) {
                PVector moon = new PVector(22.0f, -14.0f, 80.0f);
                PVector vec = this.rockets[k];
                vec.lerp(moon, (t - this.init_time[k]) / this.rocket_flytime);
                this.pushMatrix();
                this.emissive(this.rocket_col[k]);
                this.specular(0.0f, 0.0f, 0.0f);
                this.ambient(0);
                this.translate(vec.x, vec.y, vec.z);
                this.sphereDetail(2);
                this.sphere(0.1f);
                this.popMatrix();
            }
            ++k;
        }
        if (t > this.cube_start && t < this.cube_stop) {
            this.cube(phase, new PVector(22.0f, -14.0f, 80.0f), 0, 4.0f + bass / 20.0f, (t - this.cube_start) * 2.5f, t * 0.1f);
        }
        if (this.FILL && phase != 3 && phase != 4) {
            this.emissive(0.0f, 0.0f, 0.0f);
            this.ambient(100);
            this.fill(0);
            this.beginShape(17);
            this.texture(this.tex);
            this.vertex(48.0f, 4.0f, 56.0f, 1.0f, 0.0f);
            this.vertex(48.0f, -20.0f, 40.0f, 1.0f, 1.0f);
            this.vertex(-48.0f, -20.0f, 40.0f, 0.0f, 1.0f);
            this.vertex(-48.0f, 4.0f, 56.0f, 0.0f, 0.0f);
            this.endShape();
        }
        this.ambient(0);
        this.emissive(0);
        this.specular(200);
        this.shininess(30.0f);
        int fillcol = this.color(0, 100, 200);
        int fillcol2 = this.color(0, 65, 65);
        int i = 0;
        while (i < 100) {
            float x_ = ((float)i / 100.0f * 2.0f - 1.0f) * 4.0f;
            float x = ((float)(i + 1) / 100.0f * 2.0f - 1.0f) * 4.0f;
            int ii = (i + 1) % 100;
            int j = 0;
            while (j < 100) {
                float z_ = ((float)j / 100.0f * 2.0f - 1.0f) * 3.0f;
                float z = ((float)(j + 1) / 100.0f * 2.0f - 1.0f) * 3.0f;
                int jj = (j + 1) % 100;
                this.noFill();
                this.beginShape(17);
                if (this.FILL) {
                    this.fill(this.lerpColor(fillcol, fillcol2, this.ARRVEL[i][j] * 10.0f));
                }
                this.normal(this.norm[i][j].x, this.norm[i][j].y, this.norm[i][j].z);
                this.vertex(x_, -this.ARR[i][j], 1.5f + z_);
                if (this.FILL) {
                    this.fill(this.lerpColor(fillcol, fillcol2, this.ARRVEL[i][jj] * 10.0f));
                }
                this.normal(this.norm[i][jj].x, this.norm[i][jj].y, this.norm[i][jj].z);
                this.vertex(x_, -this.ARR[i][jj], 1.5f + z);
                if (this.FILL) {
                    this.fill(this.lerpColor(fillcol, fillcol2, this.ARRVEL[ii][jj] * 10.0f));
                }
                this.normal(this.norm[ii][jj].x, this.norm[ii][jj].y, this.norm[ii][jj].z);
                this.vertex(x, -this.ARR[ii][jj], 1.5f + z);
                if (this.FILL) {
                    this.fill(this.lerpColor(fillcol, fillcol2, this.ARRVEL[ii][j] * 10.0f));
                }
                this.normal(this.norm[ii][j].x, this.norm[ii][j].y, this.norm[ii][j].z);
                this.vertex(x, -this.ARR[ii][j], 1.5f + z_);
                this.endShape();
                ++j;
            }
            ++i;
        }
        kuutamo.println((float)this.frameRate);
    }

    public void update() {
        int j;
        int i = 0;
        while (i < 100) {
            j = 0;
            while (j < 100) {
                float[] fArray = this.ARRVEL[i];
                int n = j;
                fArray[n] = fArray[n] + 0.25f * (this.ARR[(i - 1 + 100) % 100][j] + this.ARR[(i + 1) % 100][j] + this.ARR[i][(j + 1) % 100] + this.ARR[i][(j - 1 + 100) % 100] - 4.0f * this.ARR[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 100) {
            j = 0;
            while (j < 100) {
                float[] fArray = this.ARR[i];
                int n = j;
                fArray[n] = fArray[n] + this.ARRVEL[i][j] * 0.05f;
                if (kuutamo.abs((float)this.ARR[i][j]) > 0.2f) {
                    float[] fArray2 = this.ARR[i];
                    int n2 = j;
                    fArray2[n2] = fArray2[n2] * 0.99f;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 100) {
            int ii = (i + 1) % 100;
            int ii_ = (i - 1 + 100) % 100;
            int j2 = 0;
            while (j2 < 100) {
                int jj = (j2 + 1) % 100;
                int jj_ = (j2 - 1 + 100) % 100;
                this.norm[i][j2] = new PVector(this.ARR[ii][j2] - this.ARR[ii_][j2], 0.35f, this.ARR[i][jj] - this.ARR[i][jj_]);
                this.norm[i][j2].normalize();
                ++j2;
            }
            ++i;
        }
        int texW = this.tex.width;
        int texH = this.tex.height;
        int l = 0;
        while (l < texH) {
            int index0 = l * texW;
            int temp = this.tex.pixels[index0];
            int k = 0;
            while (k < texW - 1) {
                this.tex.pixels[index0 + k] = this.tex.pixels[index0 + k + 1];
                ++k;
            }
            this.tex.pixels[index0 + texW - 1] = temp;
            ++l;
        }
        this.tex.updatePixels();
    }

    public void pump(float x0, float y0, float rad, float amp) {
        int i = 0;
        while (i < 100) {
            int j = 0;
            while (j < 100) {
                float x = (float)i / 100.0f * 2.0f - 1.0f - x0;
                float z = (float)j / 100.0f * 2.0f - 1.0f - y0;
                float[] fArray = this.ARR[i];
                int n = j++;
                fArray[n] = fArray[n] + amp / (1.0f + (x * x + z * z) * rad);
            }
            ++i;
        }
    }

    public void cube(int theme, PVector cen, int D, float rad, float delta, float t) {
        float x;
        int col = this.color(0);
        if (theme == 9) {
            if (D < 2) {
                col = this.color(55, 0, 55);
            }
            if (D == 3) {
                col = this.color(55, 0, 0);
            }
            if (D == 4) {
                col = this.color(0, 55, 55);
            }
        }
        if (theme == 8) {
            if (D < 2) {
                col = this.color(200, 255, 255);
            }
            if (D == 3) {
                col = this.color(65);
            }
            if (D == 4) {
                col = this.color(255, 255, 200);
            }
        }
        if (theme == 4) {
            this.colorMode(3, 100.0f);
            x = cen.y * 0.015f;
            x -= (float)kuutamo.floor((float)x);
            col = this.color(x *= 100.0f, 80.0f, 100.0f);
            this.colorMode(1, 255.0f);
        }
        if (theme == 3) {
            this.colorMode(3, 100.0f);
            x = cen.x * 0.025f;
            x -= (float)kuutamo.floor((float)x);
            col = this.color(x *= 100.0f, 100.0f, 100.0f);
            this.colorMode(1, 255.0f);
        }
        this.pushMatrix();
        if (this.FILL) {
            this.emissive(0.0f, 0.0f, 0.0f);
        }
        if (this.FILL) {
            this.fill(col);
        }
        this.specular(0.0f, 0.0f, 0.0f);
        if (this.FILL) {
            this.ambient(127);
        }
        this.translate(cen.x, cen.y, cen.z);
        this.box(rad, rad, rad);
        this.popMatrix();
        if (D < 4) {
            PVector vec1 = new PVector(delta, 0.0f, 0.0f);
            vec1 = this.rotate(vec1, t, 1.0471976f);
            this.cube(theme, PVector.add((PVector)cen, (PVector)vec1), D + 1, rad * 0.7f, delta, t);
            PVector vec2 = new PVector(-delta, 0.0f, 0.0f);
            vec2 = this.rotate(vec2, -t, 1.5707964f);
            this.cube(theme, PVector.add((PVector)cen, (PVector)vec2), D + 1, rad * 0.7f, delta, t);
            PVector vec3 = new PVector(0.0f, delta, 0.0f);
            vec3 = this.rotate(vec3, -1.5707964f, -t);
            this.cube(theme, PVector.add((PVector)cen, (PVector)vec3), D + 1, rad * 0.7f, delta, t * 1.5f);
            PVector vec4 = new PVector(0.0f, -delta, 0.0f);
            vec4 = this.rotate(vec4, 1.0471976f, t);
            this.cube(theme, PVector.add((PVector)cen, (PVector)vec4), D + 1, rad * 0.7f, delta, t * 1.5f);
            PVector vec5 = new PVector(0.0f, 0.0f, delta);
            vec5 = this.rotate(vec5, -1.0471976f, t);
            this.cube(theme, PVector.add((PVector)cen, (PVector)vec5), D + 1, rad * 0.7f, delta, 0.5f * t);
            PVector vec6 = new PVector(0.0f, 0.0f, -delta);
            vec6 = this.rotate(vec6, -1.5707964f, -t);
            this.cube(theme, PVector.add((PVector)cen, (PVector)vec6), D + 1, rad * 0.7f, delta, 0.5f * t);
        }
    }

    public PVector rotate(PVector vec, float rot_y, float rot_z) {
        PVector vec1 = new PVector(vec.x * kuutamo.cos((float)rot_y) - vec.z * kuutamo.sin((float)rot_y), vec.y, vec.z * kuutamo.cos((float)rot_y) + vec.x * kuutamo.sin((float)rot_y));
        return new PVector(vec1.x * kuutamo.cos((float)rot_z) - vec1.y * kuutamo.sin((float)rot_z), vec1.y * kuutamo.cos((float)rot_z) + vec1.x * kuutamo.sin((float)rot_z), vec1.z);
    }

    public void drawText(float left, float top, float ripple, PImage img) {
        this.pushMatrix();
        this.camera(480.0f, 270.0f, 490.0f, 480.0f, 270.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.hint(2);
        this.beginShape(10);
        this.textureMode(2);
        this.texture(img);
        this.noStroke();
        float block_w = img.width / 20;
        float x = 0.0f;
        while (x < (float)img.width) {
            this.addStripVertices(left, top, img.height, x, ripple);
            x += block_w;
        }
        this.addStripVertices(left, top, img.height, img.width, ripple);
        this.endShape();
        this.hint(-2);
        this.popMatrix();
    }

    public void addStripVertices(float left, float top, float height, float x, float ripple) {
        float y = ripple * kuutamo.sin((float)((left + x) / 20.0f));
        this.vertex(left + x, top + y + height, 0.0f, x, height);
        this.vertex(left + x, top + y, 0.0f, x, 0.0f);
    }

    public void drawText2(float left, float top, float ripple, PImage img) {
        this.pushMatrix();
        this.camera(720.0f, 450.0f, 450.0f / kuutamo.tan((float)0.5235988f), 720.0f, 450.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.hint(2);
        this.beginShape(17);
        this.textureMode(2);
        this.texture(img);
        this.noStroke();
        float block_w = 10.0f;
        float x = 0.0f;
        while (x < (float)img.width) {
            float bottom = top + (float)img.height;
            float y = ripple * kuutamo.sin((float)((left + x) / 20.0f));
            this.vertex(left + x, top + y, 1.0f, x, 0.0f);
            this.vertex(left + x + block_w, top + y, 1.0f, x + block_w, 0.0f);
            this.vertex(left + x + block_w, bottom + y, 1.0f, x + block_w, img.height);
            this.vertex(left + x, bottom + y, 1.0f, x, img.height);
            x += block_w;
        }
        this.endShape();
        this.hint(-2);
        this.popMatrix();
    }

    public void drawSpectrum(FFT fft) {
        int i = 0;
        while (i < fft.specSize()) {
            this.line(i, this.height, i, (float)this.height - fft.getBand(i) * 8.0f);
            ++i;
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--hide-stop", "kuutamo"};
        if (passedArgs != null) {
            PApplet.main((String[])kuutamo.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

