/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PImage;
import processing.opengl.PShader;

public class gthon2017
extends PApplet {
    Moonlander moonlander;
    PShader shader;
    final int bpm = 140;
    final int rows_per_beat = 4;
    final float song_offset_seconds = -0.117f;
    PImage floor_texture;
    PImage intro_header;
    PImage intro_createdby;
    PImage intro_wno;
    PImage intro_qazhax;
    PImage intro_locketeerian;
    PImage intro_music;
    PImage fake_scene;
    final int cubes_color_blue1 = this.color(25, 52, 65);
    final int cubes_color_blue2 = this.color(252, 255, 245);
    float untzCounter = 0.0f;
    float untz_xMax = this.random(-1.0f, 1.0f);
    float untz_yMax = this.random(-1.0f, 1.0f);
    float untz_zMax = this.random(-1.0f, 1.0f);
    float untz_x = 0.0f;
    float untz_y = 0.0f;
    float untz_z = 0.0f;

    public void setup() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"Gunnar_Olsen-Dub_Zap_fadeout.wav", (int)140, (int)4);
        this.noCursor();
        this.floor_texture = this.loadImage("floor.png");
        this.intro_header = this.loadImage("title_header.png");
        this.intro_createdby = this.loadImage("title_createdby.png");
        this.intro_wno = this.loadImage("title_wno.png");
        this.intro_qazhax = this.loadImage("title_qazhax.png");
        this.intro_locketeerian = this.loadImage("title_locketeerian.png");
        this.intro_music = this.loadImage("title_music.png");
        this.fake_scene = this.loadImage("fakeshadertex.png");
        this.frameRate(60.0f);
        this.shader = this.loadShader("waves.glsl", "wavevert.glsl");
        this.shader.set("iResolution", (float)this.width, (float)this.height);
        this.untzReset();
        this.moonlander.start();
    }

    public void draw() {
        this.moonlander.update();
        float time = (float)this.moonlander.getCurrentTime() + -0.117f;
        float beats = (float)this.moonlander.getCurrentRow() / 4.0f;
        int scene = this.moonlander.getIntValue("scene");
        if (scene == 1) {
            this.drawCubeScene(time, beats);
        } else if (scene == 2) {
            this.drawCubeScene2(time, beats);
        } else if (scene == 3) {
            this.drawCubeMoveScene1(time, beats);
        } else if (scene == 4) {
            this.drawCubeSpinScene3(time, beats);
        } else if (scene == 5) {
            this.drawCubeSpinScene1(time, beats);
        } else if (scene == 6) {
            this.drawCubeSpinScene2(time, beats);
        } else if (scene == 7) {
            this.drawIntroScene(time, beats);
        } else if (scene == 8) {
            this.drawCubeSpinScene4(time, beats);
        } else if (scene == 9) {
            this.drawCubeMoveScene2(time, beats);
        } else if (scene == 10) {
            this.drawCubeSpinScene5(time, beats);
        } else if (scene == 11) {
            this.drawCubeScene4(time, beats);
        } else if (scene == 12) {
            this.drawShaderScene(time, beats);
        } else if (scene == 999) {
            this.drawBlackScene(time, beats);
        } else if (scene == 666) {
            this.exit();
        }
    }

    public void drawBlackScene(float time, float beats) {
        this.background(8);
    }

    public void drawCubeMoveScene1(float time, float beats) {
        this.background(16.0f, 16.0f, 16.0f);
        this.noStroke();
        this.lights();
        int boxes = 11;
        int boxSize = (int)((float)this.width / ((float)boxes * 1.25f));
        float off = ((float)boxes + 1.0f) / 2.0f;
        float space = boxSize + boxSize;
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.translate(space * (beats % 1.0f), space * (beats % 1.0f), 0.0f);
        this.translate(-space * off, -space * off, -space * (float)boxes);
        int i = 0;
        while (i < boxes) {
            this.translate(0.0f, space, 0.0f);
            this.pushMatrix();
            int j = 0;
            while (j < boxes) {
                this.translate(space, 0.0f, 0.0f);
                this.pushMatrix();
                int k = 0;
                while (k < boxes) {
                    this.translate(0.0f, 0.0f, space);
                    int fill_color = this.lerpColor(this.cubes_color_blue1, this.cubes_color_blue2, (float)(i + j + k) / ((float)boxes * 3.0f));
                    this.fill(fill_color);
                    this.box(boxSize);
                    ++k;
                }
                this.popMatrix();
                ++j;
            }
            this.popMatrix();
            ++i;
        }
        this.popMatrix();
    }

    public void drawCubeMoveScene2(float time, float beats) {
        this.background(16.0f, 16.0f, 16.0f);
        this.noStroke();
        this.lights();
        int boxes = 9;
        int boxSize = (int)((float)this.width / ((float)boxes * 1.25f));
        float off = ((float)boxes + 1.0f) / 2.0f;
        float space = (float)boxSize + (float)boxSize / 4.0f + 20.0f;
        float test = beats / 8.0f * (float)Math.PI;
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        float direction = (float)this.moonlander.getValue("direction");
        this.translate(gthon2017.cos((float)test) * space * 0.6f, gthon2017.sin((float)test) * space * 0.6f, space + direction * space * (beats % 1.0f));
        this.translate(-space * off, -space * off, -space * off);
        int i = 0;
        while (i < boxes) {
            this.translate(0.0f, space, 0.0f);
            this.pushMatrix();
            int j = 0;
            while (j < boxes) {
                this.translate(space, 0.0f, 0.0f);
                this.pushMatrix();
                int k = 0;
                while (k < boxes) {
                    this.translate(0.0f, 0.0f, space);
                    int fill_color = this.lerpColor(this.cubes_color_blue1, this.cubes_color_blue2, (float)k * 3.0f / ((float)boxes * 3.0f));
                    this.fill(fill_color);
                    this.box(boxSize);
                    ++k;
                }
                this.popMatrix();
                ++j;
            }
            this.popMatrix();
            ++i;
        }
        this.popMatrix();
    }

    public void drawCubeSpinScene4(float time, float beats) {
        this.background(16.0f, 16.0f, 16.0f);
        this.noStroke();
        this.lights();
        int boxes = 10;
        int boxSize = (int)((float)this.width / ((float)boxes * 2.5f));
        float off = ((float)boxes + 1.0f) / 2.0f;
        float space = boxSize + boxSize / 2;
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotateY(beats);
        this.translate(-space * off, -space * off, -space * off);
        int i = 0;
        while (i < boxes) {
            this.translate(0.0f, space, 0.0f);
            this.rotateY(beats / 4.0f);
            this.pushMatrix();
            int j = 0;
            while (j < boxes) {
                this.translate(space, 0.0f, 0.0f);
                this.rotateX(beats / 8.0f);
                this.pushMatrix();
                int k = 0;
                while (k < boxes) {
                    this.translate(0.0f, 0.0f, space);
                    this.rotateZ(beats / 16.0f);
                    int fill_color = this.lerpColor(this.cubes_color_blue1, this.cubes_color_blue2, (float)k * 3.0f / ((float)boxes * 3.0f));
                    this.fill(fill_color);
                    this.box(boxSize);
                    ++k;
                }
                this.popMatrix();
                ++j;
            }
            this.popMatrix();
            ++i;
        }
        this.popMatrix();
    }

    public void drawCubeSpinScene5(float time, float beats) {
        this.background(16.0f, 16.0f, 16.0f);
        this.noStroke();
        this.lights();
        int boxes = 10;
        int boxSize = (int)((float)this.width / ((float)boxes * 3.0f));
        float off = ((float)boxes + 1.0f) / 2.0f;
        float space = (float)boxSize + (float)boxSize / 2.0f + (float)boxSize / 2.0f * (beats % 1.0f);
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotateY(beats);
        this.translate(-space * off, -space * off, -space * off);
        int i = 0;
        while (i < boxes) {
            this.translate(0.0f, space, 0.0f);
            this.rotateY(beats / 4.0f);
            this.pushMatrix();
            int j = 0;
            while (j < boxes) {
                this.translate(space, 0.0f, 0.0f);
                this.rotateX(beats / 8.0f);
                this.pushMatrix();
                int k = 0;
                while (k < boxes) {
                    this.translate(0.0f, 0.0f, space);
                    this.rotateY(beats / 16.0f);
                    int fill_color = this.lerpColor(this.cubes_color_blue1, this.cubes_color_blue2, (float)k * 3.0f / ((float)boxes * 3.0f));
                    this.fill(fill_color);
                    this.box(boxSize);
                    ++k;
                }
                this.popMatrix();
                ++j;
            }
            this.popMatrix();
            ++i;
        }
        this.popMatrix();
    }

    public void drawCubeSpinScene3(float time, float beats) {
        this.background(16.0f, 16.0f, 16.0f);
        this.noStroke();
        this.lights();
        int boxes = gthon2017.floor((float)beats) % 10 + 1;
        int boxSize = this.width / (boxes * 4);
        float off = ((float)boxes + 1.0f) / 2.0f;
        float space = (float)boxSize + (float)boxSize / 1.25f * (beats % 1.0f);
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotateY(beats * (float)Math.PI / 4.0f);
        this.translate(-space * off, -space * off, -space * off);
        int i = 0;
        while (i < boxes) {
            this.translate(0.0f, space, 0.0f);
            this.pushMatrix();
            int j = 0;
            while (j < boxes) {
                this.translate(space, 0.0f, 0.0f);
                this.pushMatrix();
                int k = 0;
                while (k < boxes) {
                    this.translate(0.0f, 0.0f, space);
                    int fill_color = this.cubes_color_blue2;
                    this.fill(fill_color);
                    this.box(boxSize);
                    ++k;
                }
                this.popMatrix();
                ++j;
            }
            this.popMatrix();
            ++i;
        }
        this.popMatrix();
    }

    public void drawCubeSpinScene1(float time, float beats) {
        this.background(16.0f, 16.0f, 16.0f);
        this.noStroke();
        this.lights();
        int boxes = 3;
        int boxSize = 100;
        float space = 110.0f;
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.translate(-space * 2.0f, -space * 2.0f, -space * 2.0f);
        int i = 0;
        while (i < boxes) {
            this.translate(0.0f, space, 0.0f);
            this.pushMatrix();
            int j = 0;
            while (j < boxes) {
                this.translate(space, 0.0f, 0.0f);
                this.rotateY(beats);
                this.pushMatrix();
                int k = 0;
                while (k < boxes) {
                    this.translate(0.0f, 0.0f, space);
                    int fill_color = this.cubes_color_blue2;
                    this.fill(fill_color);
                    this.box(boxSize);
                    ++k;
                }
                this.popMatrix();
                ++j;
            }
            this.popMatrix();
            ++i;
        }
        this.popMatrix();
    }

    public void drawCubeSpinScene2(float time, float beats) {
        this.background(16.0f, 16.0f, 16.0f);
        this.noStroke();
        this.lights();
        int boxes = 3;
        int boxSize = 100;
        float space = 110.0f;
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.translate(-space * 2.0f, -space * 2.0f, -space * 2.0f);
        int i = 0;
        while (i < boxes) {
            this.translate(0.0f, space, 0.0f);
            this.pushMatrix();
            int j = 0;
            while (j < boxes) {
                this.translate(space, 0.0f, 0.0f);
                this.pushMatrix();
                int k = 0;
                while (k < boxes) {
                    this.translate(0.0f, 0.0f, space);
                    this.rotateY(beats);
                    int fill_color = this.cubes_color_blue2;
                    this.fill(fill_color);
                    this.box(boxSize);
                    ++k;
                }
                this.popMatrix();
                ++j;
            }
            this.popMatrix();
            ++i;
        }
        this.popMatrix();
    }

    public void drawCubeScene3(float time, float beats) {
        this.background(32);
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.noStroke();
        this.pushMatrix();
        float cube_bounce = 0.0625f * ((beats += 0.3f) % 64.0f);
        this.scale(0.5f + cube_bounce);
        this.cubes_DrawCubeCluster(time, beats);
        this.popMatrix();
    }

    public void drawCubeScene4(float time, float beats) {
        this.background(32);
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.noStroke();
        this.pushMatrix();
        float cube_bounce = gthon2017.abs((float)gthon2017.cos((float)((beats += 0.3f) % 1.0f * (float)Math.PI)));
        this.scale(10.0f + cube_bounce);
        this.cubes_DrawCubeCluster(time, beats);
        this.popMatrix();
    }

    public void drawCubeScene(float time, float beats) {
        this.background(32);
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.noStroke();
        this.pushMatrix();
        float cube_bounce = gthon2017.abs((float)gthon2017.cos((float)((beats += 0.3f) % 1.0f * (float)Math.PI)));
        this.scale(1.0f + cube_bounce);
        this.cubes_DrawCubeCluster(time, beats);
        this.popMatrix();
    }

    public void drawCubeScene2(float time, float beats) {
        this.background(0);
        this.noStroke();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        beats += 0.3f;
        float camera_away_movement = gthon2017.sin((float)time) * 10.0f;
        this.translate(0.0f, 20.0f, 0.0f);
        this.translate(0.0f, 0.0f, 30.0f + camera_away_movement);
        this.rotateX(-0.6f);
        this.rotateY(time);
        this.pushMatrix();
        this.translate(0.0f, 1.5f * (float)this.height, 0.0f);
        this.rectMode(3);
        this.rotateX(1.5707964f);
        this.translate(-3.0f * (float)this.height, -3.0f * (float)this.height);
        this.image(this.floor_texture, 0.0f, 0.0f, 6.0f * (float)this.height, 6.0f * (float)this.height);
        this.popMatrix();
        int i = 0;
        while (i < 3) {
            this.pushMatrix();
            this.rotateY((float)i * 2.0943952f);
            this.translate(0.0f, 0.0f, (float)this.moonlander.getValue("translateZ") * 100.0f);
            this.cubes_DrawCubeCluster(time, beats);
            this.popMatrix();
            ++i;
        }
    }

    public void cubes_DrawCubeCluster(float time, float beats) {
        int i = 0;
        while (i < 10) {
            this.pushMatrix();
            this.lights();
            this.cubes_DrawCube(time, beats, i);
            this.popMatrix();
            ++i;
        }
    }

    public void cubes_DrawCube(float time, float beats, int index) {
        int fill_color = this.lerpColor(this.cubes_color_blue1, this.cubes_color_blue2, (float)index / 10.0f);
        this.fill(fill_color);
        this.rotateY(time += 0.1f * (float)index);
        this.rotateX(time * 1.3f);
        this.rotateZ(time * 1.9f);
        this.box((float)this.height * 0.4f);
    }

    public void drawGradientScene(float time, float beats) {
        int from = this.color(100, 0, 153);
        int to = this.color(200, 20, 39);
        int lines = 9;
        this.drawGradient(from, to, lines);
    }

    public void drawGradient(int startcolor, int endcolor, int lines) {
        this.strokeWeight(0.0f);
        this.rectMode(0);
        int i = 0;
        while (i < lines) {
            float iterating = (float)i / ((float)lines - 1.0f);
            float iterating2 = (float)i / (float)lines;
            int inter = this.lerpColor(startcolor, endcolor, iterating);
            this.fill(inter);
            this.rect(0.0f, (float)this.height * iterating2, this.width, this.height / lines + 1);
            ++i;
        }
    }

    public void drawIntroScene(float time, float beats) {
        this.background(8);
        int intro_text_select = this.moonlander.getIntValue("intro_text");
        this.translate((float)this.width / 2.0f - (float)this.height / 2.0f, 0.0f, 0.0f);
        int untz_reset_signal = this.moonlander.getIntValue("untz_reset");
        if (untz_reset_signal == 1) {
            this.untzReset();
        }
        this.untz(0.0f, 0.0f, 0.0f, 10.0f, 100.0f);
        this.translate(this.untz_x, this.untz_y);
        this.scale(1.0f + this.untz_x * 0.003f);
        if (intro_text_select == 1) {
            this.image(this.intro_header, 0.0f, 0.0f, this.height, this.height);
        } else if (intro_text_select == 2) {
            this.image(this.intro_qazhax, 0.0f, 0.0f, this.height, this.height);
        } else if (intro_text_select == 3) {
            this.image(this.intro_locketeerian, 0.0f, 0.0f, this.height, this.height);
        } else if (intro_text_select == 4) {
            this.image(this.intro_wno, 0.0f, 0.0f, this.height, this.height);
        } else if (intro_text_select == 5) {
            this.image(this.intro_createdby, 0.0f, 0.0f, this.height, this.height);
        } else if (intro_text_select == 6) {
            this.image(this.intro_music, 0.0f, 0.0f, this.height, this.height);
        }
    }

    public void drawShaderScene(float time, float beats) {
        this.background(0);
        this.shader(this.shader);
        this.shader.set("iGlobalTime", (float)this.moonlander.getCurrentTime());
        this.shader.set("iIntensity", (float)this.moonlander.getValue("translateZ"));
        this.beginShape();
        this.texture(this.fake_scene);
        this.vertex(0.0f, 0.0f);
        this.vertex(this.width, 0.0f);
        this.vertex(this.width, this.height);
        this.vertex(0.0f, this.height);
        this.endShape();
    }

    public void untzReset() {
        this.untz_xMax = this.random(-1.0f, 1.0f);
        this.untz_yMax = this.random(-1.0f, 1.0f);
        this.untz_zMax = this.random(-1.0f, 1.0f);
        float scaleDown = gthon2017.sqrt((float)(gthon2017.sq((float)this.untz_xMax) + gthon2017.sq((float)this.untz_yMax) + gthon2017.sq((float)this.untz_zMax)));
        this.untz_xMax /= scaleDown;
        this.untz_yMax /= scaleDown;
        this.untz_zMax /= scaleDown;
        this.untzCounter = 0.0f;
    }

    public void untz(float xx, float yy, float zz, float dampening, float maxAmplitude) {
        this.untzCounter += 1.0f;
        float temp = maxAmplitude * gthon2017.exp((float)(-this.untzCounter / dampening)) * gthon2017.sin((float)this.untzCounter);
        this.untz_x = xx + this.untz_xMax * temp;
        this.untz_y = yy + this.untz_yMax * temp;
        this.untz_z = zz + this.untz_zMax * temp;
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"gthon2017"};
        if (passedArgs != null) {
            PApplet.main((String[])gthon2017.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

