#ifndef __DEMO_H
#define __DEMO_H

#include <math.h>
#include <stdbool.h>
#include <stdint.h>
#include <time.h>

#define GL3_PROTOTYPES 1
#include <GL/glew.h>

#include <SDL2/SDL.h>
#include <SDL2/SDL_opengl.h>
#include <SDL2/SDL_mixer.h>

#include <SOIL/SOIL.h>

#include <pango/pangocairo.h>
#define FONT "Sans Bold 36"
#define BIGFONT "Sans Bold 500"

#include "single-header-file-c-libs/math_3d.h"

#define ARRAY_SIZE(x) (sizeof(x) / sizeof(x[0]))

#define max(a,b) ({ __typeof__ (a) _a = (a);  __typeof__ (b) _b = (b); _a > _b ? _a : _b; })
#define min(a,b) ({ __typeof__ (a) _a = (a);  __typeof__ (b) _b = (b); _a < _b ? _a : _b; })

struct shaderProgram {
	GLuint vertexShader;
       	GLuint fragmentShader;
        GLuint shaderProgram;
	const GLchar * const *vertexShadersrc, * const *fragmentShadersrc;
	GLint *vertexShadersize, *fragmentShadersize;
	char *name;
};

struct attribute {
	char *name;
	int size;
	int offset;
};

struct textTexture {
	GLuint texID;
	int width;
	int height;
	char *text;
};

GLuint create_texture_from_image(int width, int height, uint8_t *image, GLenum format, GLenum repeat);
GLuint create_texture_from_file(char *name, GLenum repeat);
cairo_t* create_cairo_context(int width, int height, int channels, cairo_surface_t** surf, unsigned char** buffer) ;
cairo_t* create_layout_context(void);
void get_text_size (PangoLayout *layout, int *width, int *height);
GLuint render_text (const char *text, int *text_width, int *text_height, char *font, GLenum repeat);
int setup_shaders(struct shaderProgram *p);
void setup_attributes(struct shaderProgram *p, struct attribute *attrs, int size, int stride);
void setup_vertices(GLuint *vao, GLuint *vbo, GLfloat *vertices, GLint size);

void setup_intro(int width, int height);
void do_loop_intro(double ts, double base_ts);
void do_loop_outro(double ts, double base_ts);
void setup_raymarcher(int width, int height);
void do_raymarcher(double ts, double base_ts);

#endif
