Star[] starsl = new Star [800];
Star[] starsr = new Star [800];

void starInit() {
    for(int i = 0; i < starsl.length; i++) {
      starsl[i] = new Star(#ff0000);
      starsr[i] = new Star(#0000ff);
    }
}

class Star {
  float x;
  float y;
  float z;
  int col;
  
  Star(int c) {
    this.col = c;
    x = random(-width, width);
    y = random(-height, height);
    z = random(width);
  }
  void update(float speed) {
    z = z - speed;
    if (z < 1) {
      z = width;
      x = random(-width, width);
      y = random(-height, height);
    }
  }
  void show() {
    float sx = map(x/z, 0, 1, 0, width);
    float sy = map(y/z, 0, 1, 0, height);
    float r = map(z, 0, width, 100, 0);
    fill(col);
    ellipse(sx, sy, r, r);
  }
}


void drawStarL(float sx, float sy, float s) {
  translate(sx, sy);
  for(int i= 0; i < starsl.length; i++) {
    starsl[i].update(s);
    starsl[i].show();
  }
}

void drawStarR(float sx, float sy, float s) {
  translate(sx, sy);
  for(int i = 0; i < starsr.length; i++) {
    starsr[i].update(s);
    starsr[i].show();
  }
}