#include "update.h"
#include "imgui_impl_sdl_gl3.h"

float clamp(float n, float lower, float upper) {
    return std::max(lower, std::min(n, upper));
}

float smoothstep(float edge0, float edge1, float x)
{
    // Scale, bias and saturate x to 0..1 range
    x = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
    // Evaluate polynomial
    return x*x*(3 - 2 * x);
}

void ExplodeCubes();

void Update(float timeElapsed)
{

    const float mouseSensitivity = 0.5f;
    int mouseX = 0;
    int mouseY = 0;

	SDL_Event evt;
    while (SDL_PollEvent(&evt) != 0)
    {
        ImGui_ImplSdlGL3_ProcessEvent(&evt);
        if (evt.type == SDL_QUIT)
        {
            gameRunning = 0;
        }

        else if (evt.type == SDL_KEYDOWN)
        {
            switch (evt.key.keysym.sym)
            {
            case SDLK_ESCAPE:
                gameRunning = 0;
                break;
            case SDLK_F1:
                demoPhase = !demoPhase;
                break;
            case SDLK_F2:
                show_debug_window = !show_debug_window;
                break;
            case SDLK_F3:
                SDL_SetRelativeMouseMode(SDL_FALSE);
                break;
            case SDLK_F4:
                demoPaused = !demoPaused;
                break;
            case SDLK_F5:
                demoPhase = 2;
                break;
            case SDLK_F8:
                ExplodeCubes();
                break;
            }
        }

        else if (evt.type == SDL_MOUSEBUTTONDOWN && evt.button.button == SDL_BUTTON_RIGHT)
        {
            // Toggle mouselook
            if (SDL_GetRelativeMouseMode())
            {                
                SDL_SetRelativeMouseMode(SDL_FALSE);
                SDL_WarpMouseInWindow(window, storedMouseCoordX, storedMouseCoordY);
            } else
            {
                SDL_GetMouseState(&storedMouseCoordX, &storedMouseCoordY);
                SDL_SetRelativeMouseMode(SDL_TRUE);                
            }            
        }

        else if (evt.type == SDL_MOUSEMOTION && SDL_GetRelativeMouseMode())
        {
            mouseX = evt.motion.xrel;
            mouseY = evt.motion.yrel;
        }



    }


    const Uint8 *keyboardState;
    keyboardState = SDL_GetKeyboardState(NULL);
    const float moveSpeed = 0.006f; //units per second

    if (keyboardState[SDL_SCANCODE_S])
    {
        OffsetCameraPosition(&camera, v3_muls( GetCameraForwardVector(&camera), timeElapsed * moveSpeed) );
    }
    if (keyboardState[SDL_SCANCODE_W])
    {
        OffsetCameraPosition(&camera, v3_muls( GetCameraForwardVector(&camera), timeElapsed * -moveSpeed));
    }

    if (keyboardState[SDL_SCANCODE_A])
    {
        OffsetCameraPosition(&camera, v3_muls( GetCameraRightVector(&camera), timeElapsed * moveSpeed));
    }

    if (keyboardState[SDL_SCANCODE_D])
    {
        OffsetCameraPosition(&camera, v3_muls( GetCameraRightVector(&camera), timeElapsed * -moveSpeed));
    }
    if (keyboardState[SDL_SCANCODE_Z])
    {
        OffsetCameraPosition(&camera, v3_muls (vec3(0.0f,1.0f,0.0f), timeElapsed * -moveSpeed));
    }
    if (keyboardState[SDL_SCANCODE_X])
    {
        OffsetCameraPosition(&camera, v3_muls (vec3(0.0f,1.0f,0.0f), timeElapsed * moveSpeed));
    }

    if (keyboardState[SDL_SCANCODE_1])
    {
        gLight.position.x = camera.position.x;
        gLight.position.y = camera.position.y;
        gLight.position.z = camera.position.z;
    }
    // current demo time
    // high boundary keyframe time
    // low boundary keyframe time
    // high boundary keyframe position
    // low boundary keyframe position

    // (high - current) / (high - low) 

    //float progressThroughTimeBetweenKeyFrame = (float)( cameraKeyFrames[1].demoTime - demoTimer ) / (float)( cameraKeyFrames[1].demoTime - cameraKeyFrames[0].demoTime);

    camera.horizontalAngle += ( mouseSensitivity * (float)mouseX );
    camera.verticalAngle += ( mouseSensitivity * (float)mouseY );
    CameraNormalizeAngles(&camera);

    if (demoTimer > 84848) { gameRunning = false;}
    else if (demoTimer > 81652) { demoPhase = 2; }
    else if (demoTimer > 67000) { demoPhase = 1; seaAlpha = smoothstep(67000,69000,demoTimer); }
    else if (demoTimer > 44000) { demoPhase = 3; }
    else if (demoTimer > 31400) { demoPhase = 2; }
    else if (demoTimer > 9500 && demoTimer < 15500) { seaAlpha = 1.0f - 0.5f * smoothstep(10000,15000,demoTimer); }
    else if (demoTimer < 5500) { seaAlpha = smoothstep(0, 5000, demoTimer); }
    

    
    



    //ExplodeCubes();
    if (!freeMove)
    {
        if (demoTimer > cameraKeyFrames[0].demoTime && demoTimer < cameraKeyFrames[1].demoTime)
        {
            camera.position.x = cameraKeyFrames[0].position.x + (cameraKeyFrames[1].position.x - cameraKeyFrames[0].position.x) * smoothstep(cameraKeyFrames[0].demoTime, cameraKeyFrames[1].demoTime, demoTimer);
            camera.position.y = cameraKeyFrames[0].position.y + (cameraKeyFrames[1].position.y - cameraKeyFrames[0].position.y) * smoothstep(cameraKeyFrames[0].demoTime, cameraKeyFrames[1].demoTime, demoTimer);
            camera.position.z = cameraKeyFrames[0].position.z + (cameraKeyFrames[1].position.z - cameraKeyFrames[0].position.z) * smoothstep(cameraKeyFrames[0].demoTime, cameraKeyFrames[1].demoTime, demoTimer);
            camera.horizontalAngle = cameraKeyFrames[0].horizontalAngle + (cameraKeyFrames[1].horizontalAngle - cameraKeyFrames[0].horizontalAngle) * smoothstep(cameraKeyFrames[0].demoTime, cameraKeyFrames[1].demoTime, demoTimer);
            camera.verticalAngle = cameraKeyFrames[0].verticalAngle + (cameraKeyFrames[1].verticalAngle - cameraKeyFrames[0].verticalAngle) * smoothstep(cameraKeyFrames[0].demoTime, cameraKeyFrames[1].demoTime, demoTimer);    
        }
        else if (demoTimer > cameraKeyFrames[2].demoTime && demoTimer < cameraKeyFrames[3].demoTime)
        {
            ExplodeCubes();
            camera.position.x = cameraKeyFrames[2].position.x + (cameraKeyFrames[3].position.x - cameraKeyFrames[2].position.x) * smoothstep(cameraKeyFrames[2].demoTime, cameraKeyFrames[3].demoTime, demoTimer);
            camera.position.y = cameraKeyFrames[2].position.y + (cameraKeyFrames[3].position.y - cameraKeyFrames[2].position.y) * smoothstep(cameraKeyFrames[2].demoTime, cameraKeyFrames[3].demoTime, demoTimer);
            camera.position.z = cameraKeyFrames[2].position.z + (cameraKeyFrames[3].position.z - cameraKeyFrames[2].position.z) * smoothstep(cameraKeyFrames[2].demoTime, cameraKeyFrames[3].demoTime, demoTimer);
            camera.horizontalAngle = cameraKeyFrames[2].horizontalAngle + (cameraKeyFrames[3].horizontalAngle - cameraKeyFrames[2].horizontalAngle) * smoothstep(cameraKeyFrames[2].demoTime, cameraKeyFrames[3].demoTime, demoTimer);
            camera.verticalAngle = cameraKeyFrames[2].verticalAngle + (cameraKeyFrames[3].verticalAngle - cameraKeyFrames[2].verticalAngle) * smoothstep(cameraKeyFrames[2].demoTime, cameraKeyFrames[3].demoTime, demoTimer);
        }
    }


    ImGui_ImplSdlGL3_NewFrame(window);

    // 1. Show a simple window
    // Tip: if we don't call ImGui::Begin()/ImGui::End() the widgets appears in a window automatically called "Debug"
    if (show_debug_window)
    {
        static float f = 0.0f;
        ImGui::Text("Hello, world!");
        ImGui::SliderFloat("float", &f, 0.0f, 1.0f);
        ImGui::ColorEdit3("clear color", (float*)&clear_color);
        if (ImGui::Button("Test Window")) show_test_window ^= 1;
        //if (ImGui::Button("Another Window")) show_another_window ^= 1;
        //if (ImGui::Button("Nebula")) show_nebula_background ^= 1;
        //if (ImGui::Button("Triangle/Rectangle switch")) drawTriangle ^= 1;
        ImGui::Text("Application average %.3f ms/frame (%.1f FPS)", 1000.0f / ImGui::GetIO().Framerate, ImGui::GetIO().Framerate);
        ImGui::Text("Demo time: %d ms", demoTimer);
        ImGui::InputInt("demo time", &demoTimer);
        ImGui::Text("Camera X: %.3f Y: %.3f Z: %.3f", camera.position.x, camera.position.y, camera.position.z);
        ImGui::Text("Camera horizontal angle: %.3f vertical angle: %.3f", camera.horizontalAngle, camera.verticalAngle);
        ImGui::Text("Light  X: %.3f Y: %.3f Z: %.3f", gLight.position.x, gLight.position.y, gLight.position.z);

        if (ImGui::Button("free move")) { freeMove = !freeMove; }
        if (freeMove)
        {
            ImGui::SameLine();
            ImGui::Text("free move on");
        }
        ImGui::SliderFloat("slider float", &seaAlpha, 0.0f, 1.0f, "alpha = %.3f");


    }

    /*
    // 2. Show another simple window, this time using an explicit Begin/End pair
    if (show_another_window)
    {
        //ImGui::SetNextWindowSize(ImVec2(200,100), ImGuiSetCond_FirstUseEver);
        ImGui::SetNextWindowSize(ImVec2(1600,180), 0);
        ImGui::SetNextWindowPos(ImVec2(0, 720), 0);
        ImGui::Begin("Another Window", &show_another_window, ImGuiWindowFlags_NoTitleBar | ImGuiWindowFlags_NoMove | ImGuiWindowFlags_NoResize); // ImGuiWindowFlags_NoTitleBar
        ImGui::Text("Hello");
        ImGui::SliderFloat("variaabeli", &variaabeli, 0.0f, 800.0f);
        ImGui::SliderFloat("vari2", &variaabeli2, 1.0f, 40.0f);
        ImGui::End();
    }
    */

    // 3. Show the ImGui test window. Most of the sample code is in ImGui::ShowTestWindow()
    if (show_test_window)
    {
        ImGui::SetNextWindowPos(ImVec2(650, 20), ImGuiSetCond_FirstUseEver);
        ImGui::ShowTestWindow(&show_test_window);
    }


}


void ExplodeCubes()
{
    for (int i = 0; i < NUMBER_OF_CUBES; i++)
    {
        int rows = 16;

        float zOffset = 4.0f * sinf( (float)(i*8.0f + (float)demoTimer/1000.0f));
        //float zOffset = 0.0f;

        boxInstances[i].transform = m4_translation( vec3(0.0f + ( i / rows ) * 4.0f, 0.0f + zOffset, 0.0f + (i % rows) * 4.0f));
    }    
}