#include "loader.h"
#include <SDL_mixer.h>
#include <GL/glew.h>
#include "stb_image.h"
#include "globals.h"

void LoadSomeData()
{
	ruxiTexture = LoadTexture("data/gfx/ruxi.jpg");
	hanhiMusic12 = Mix_LoadMUS("data/takkihanhi12.ogg");

    GLuint vertShaderStar = NewShader(GL_VERTEX_SHADER, "data/shaders/test-vert.glsl");
    GLuint fragShaderStar = NewShader(GL_FRAGMENT_SHADER, "data/shaders/test-frag.glsl");

    GLuint starShaders[2] = { vertShaderStar, fragShaderStar };

    triangleProgram = NewProgram(starShaders, 2);
    
	timeLoc = glGetUniformLocation(triangleProgram, "time");

	seaAlphaLoc = glGetUniformLocation(triangleProgram, "alpha");

	rectProgram = triangleProgram;

	LoadTestTriangle();

	LoadTestRectangle();


	GLuint cubeVertShader = NewShader(GL_VERTEX_SHADER, "data/shaders/cube-vert.glsl");
	GLuint cubeFragShader = NewShader(GL_FRAGMENT_SHADER, "data/shaders/cube-frag.glsl");
	GLuint cubeShaders[2] = { cubeVertShader, cubeFragShader };
	cubeProgram = NewProgram(cubeShaders, 2);


	GLuint voroFragShader = NewShader(GL_FRAGMENT_SHADER, "data/shaders/voro-frag.glsl");
	GLuint voroShaders[2] = { vertShaderStar, voroFragShader};
	voroProgram = NewProgram( voroShaders, 2);
	voroTimeLoc = glGetUniformLocation(voroProgram, "time");

	LoadCube();

	testCube = CreateModelAsset(cubeProgram, ruxiTexture, cubeVBO, cubeVAO, GL_TRIANGLES, 0, 6*3*2);

    for (int i = 0; i < NUMBER_OF_CUBES; i++)
    {
        int rows = 4;

        //float zOffset = sinf( (float)i + 300000.0f);
        float zOffset = 0.0f;

        boxInstances[i].asset = &testCube;

        boxInstances[i].transform = m4_translation( vec3(0.0f + ( i / rows ) * 2.0f, 0.0f + zOffset, 0.0f + (i % rows) * 2.0f));
    }
}

GLuint NewShader(GLenum shaderType, std::string filePath)
{
	// 1. create shader(id)
	GLuint newShader = glCreateShader(shaderType);

	// 2. load shader code
	std::ifstream f;
	f.open(filePath.c_str(), std::ios::in | std::ios::binary);
    //read whole file into stringstream buffer
    std::stringstream buffer;
    buffer << f.rdbuf();
    std::string shaderCode = buffer.str();



    //printf("%s\n", shaderCode.c_str());
    glShaderSource(newShader, 1, (const GLchar**)&shaderCode, NULL);

    // 3. compile shader code
    // compile shader and check for any errors
    glCompileShader(newShader);
	int status;
	glGetShaderiv(newShader, GL_COMPILE_STATUS, &status);
	if (!status)
	{
		char buf[1024];
		glGetShaderInfoLog(newShader, sizeof(buf), NULL, buf);
		printf("Failed to compile shader:\n%s\n", buf);
	}

	return newShader;
}

GLuint NewProgram(GLuint *shaders, int numberOfShaders)
{
	// 4. create program
	GLuint newProgram = glCreateProgram();

	// 5. attach shaders to program
	for (int i=0; i < numberOfShaders; i++)
	{
		glAttachShader(newProgram, shaders[i]);
	}

	//EeEHHh
	glBindAttribLocation(newProgram, 0, "vert");
	glBindFragDataLocation(newProgram, 0, "out_color");

	// link and check for link errors
	glLinkProgram(newProgram);
	int status;
	glGetProgramiv(newProgram, GL_LINK_STATUS, &status);
	if (!status)
	{
		char buf[1024];
		glGetProgramInfoLog(newProgram, sizeof(buf), NULL, buf);
		printf("Failed to link program:\n%s\n", buf);
	}

	return newProgram;
}

GLuint LoadTexture(const char *filePath)
{
    GLuint newTexture;
	int x,y,n;
    unsigned char *data = stbi_load(filePath, &x, &y, &n, 0);
    printf("%s: %d, %d, %d\n",filePath, x, y, n);

    glGenTextures(1, &newTexture);

    glBindTexture(GL_TEXTURE_2D, newTexture);

    //glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);

	//float color[] = { 1.0f, 0.0f, 0.0f, 1.0f };
	//glTexParameterfv(GL_TEXTURE_2D, GL_TEXTURE_BORDER_COLOR, color);

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	//glGenerateMipmap(GL_TEXTURE_2D);

    /*
    // Black/white checkerboard
	float pixels[] = {
	    0.0f, 0.0f, 0.0f,   1.0f, 1.0f, 1.0f,
	    1.0f, 1.0f, 1.0f,   0.0f, 0.0f, 0.0f
	};
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 2, 2, 0, GL_RGB, GL_FLOAT, pixels);
    */

	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, x, y, 0, GL_RGB, GL_UNSIGNED_BYTE, data);
	//glBindTexture(GL_TEXTURE_2D, 0);

    stbi_image_free(data);

    return newTexture;
}

ModelAsset CreateModelAsset(GLuint _shaderProgram, GLuint _texture, GLuint _vbo, GLuint _vao, GLenum _drawType, GLint _drawStart, GLint _drawCount)
{
	struct ModelAsset newModelAsset;
	newModelAsset.shaderProgram = _shaderProgram;
	newModelAsset.texture = _texture;
    newModelAsset.vbo = _vbo;
    newModelAsset.vao = _vao;
    newModelAsset.drawType = _drawType;
    newModelAsset.drawStart = _drawStart;
    newModelAsset.drawCount = _drawCount;

	return newModelAsset;
}

void LoadTestTriangle()
{
	// make and bind the VAO
    glGenVertexArrays(1, &triangleVAO);
    glBindVertexArray(triangleVAO);
    
    // make and bind the VBO
    glGenBuffers(1, &triangleVBO);
    glBindBuffer(GL_ARRAY_BUFFER, triangleVBO);

    GLfloat vertexData[] = {
        //  X     Y     Z      U 	V
         0.0f, 0.8f, -1.0f, 0.5f,  1.0f,
        -0.8f,-0.8f, -1.0f, 0.0f,  0.0f,
         0.8f,-0.8f, -1.0f, 1.0f, 0.0f,
    };
    glBufferData(GL_ARRAY_BUFFER, sizeof(vertexData), vertexData, GL_STATIC_DRAW);

	glEnableVertexAttribArray( glGetAttribLocation(triangleProgram, "in_position") );
	glVertexAttribPointer(glGetAttribLocation(triangleProgram, "in_position"), 3, GL_FLOAT, GL_FALSE, 5 * sizeof(GLfloat), NULL);

	glEnableVertexAttribArray( glGetAttribLocation(triangleProgram, "vertexCoord") );
	glVertexAttribPointer( glGetAttribLocation(triangleProgram, "vertexCoord"), 2, GL_FLOAT, GL_FALSE, 5* sizeof(GLfloat), (const GLvoid*)(3 * sizeof(GLfloat)));

	//glEnableVertexAttribArray( glGetAttribLocation(prog_id, "vert") );
	//glVertexAttribPointer(glGetAttribLocation(prog_id, "vert"), 3, GL_FLOAT, GL_FALSE, 0, NULL);

	// unbind the VBO(?)
	glBindBuffer(GL_ARRAY_BUFFER, 0);
    // unbind the VAO
    glBindVertexArray(0);
}

void LoadTestRectangle()
{
    // make and bind the VAO
    glGenVertexArrays(1, &rectVAO);
    glBindVertexArray(rectVAO);
    
    // make and bind the VBO
    glGenBuffers(1, &rectVBO);
    glBindBuffer(GL_ARRAY_BUFFER, rectVBO);

    GLfloat vertexData[] = {
        //  X     Y     Z      U     V
         -1.0f, 1.0f, 0.0f,  0.0f, 1.0f,
         1.0f, 1.0f,  0.0f,  1.0f, 1.0f,
         -1.0f,-1.0f, 0.0f,  0.0f, 0.0f,
         -1.0f, -1.0f,0.0f,  0.0f, 0.0f,
         1.0f, 1.0f,  0.0f,  1.0f, 1.0f,
         1.0f, -1.0f, 0.0f,  1.0f, 0.0f
    };
    glBufferData(GL_ARRAY_BUFFER, sizeof(vertexData), vertexData, GL_STATIC_DRAW);

    glEnableVertexAttribArray( glGetAttribLocation(rectProgram, "in_position") );
    glVertexAttribPointer(glGetAttribLocation(rectProgram, "in_position"), 3, GL_FLOAT, GL_FALSE, 5 * sizeof(GLfloat), NULL);

    glEnableVertexAttribArray( glGetAttribLocation(rectProgram, "vertexCoord") );
    glVertexAttribPointer(glGetAttribLocation(rectProgram, "vertexCoord"), 2, GL_FLOAT, GL_FALSE, 5* sizeof(GLfloat), (const GLvoid*)(3 * sizeof(GLfloat)));

    // unbind the VBO(?)
    glBindBuffer(GL_ARRAY_BUFFER, 0);
    // unbind the VAO
    glBindVertexArray(0);
}

void LoadCube() {
    // make and bind the VAO
    glGenVertexArrays(1, &cubeVAO);
    glBindVertexArray(cubeVAO);
    
    // make and bind the VBO
    glGenBuffers(1, &cubeVBO);
    glBindBuffer(GL_ARRAY_BUFFER, cubeVBO);

    // Make a cube out of triangles (two triangles per side)
    GLfloat vertexData[] = {
        //  X     Y     Z       U     V          Normal
        // bottom
        -1.0f,-1.0f,-1.0f,   0.0f, 0.0f,   0.0f, -1.0f, 0.0f,
         1.0f,-1.0f,-1.0f,   1.0f, 0.0f,   0.0f, -1.0f, 0.0f,
        -1.0f,-1.0f, 1.0f,   0.0f, 1.0f,   0.0f, -1.0f, 0.0f,
         1.0f,-1.0f,-1.0f,   1.0f, 0.0f,   0.0f, -1.0f, 0.0f,
         1.0f,-1.0f, 1.0f,   1.0f, 1.0f,   0.0f, -1.0f, 0.0f,
        -1.0f,-1.0f, 1.0f,   0.0f, 1.0f,   0.0f, -1.0f, 0.0f,

        // top
        -1.0f, 1.0f,-1.0f,   0.0f, 0.0f,   0.0f, 1.0f, 0.0f,
        -1.0f, 1.0f, 1.0f,   0.0f, 1.0f,   0.0f, 1.0f, 0.0f,
         1.0f, 1.0f,-1.0f,   1.0f, 0.0f,   0.0f, 1.0f, 0.0f,
         1.0f, 1.0f,-1.0f,   1.0f, 0.0f,   0.0f, 1.0f, 0.0f,
        -1.0f, 1.0f, 1.0f,   0.0f, 1.0f,   0.0f, 1.0f, 0.0f,
         1.0f, 1.0f, 1.0f,   1.0f, 1.0f,   0.0f, 1.0f, 0.0f,

        // front
        -1.0f,-1.0f, 1.0f,   1.0f, 0.0f,   0.0f, 0.0f, 1.0f,
         1.0f,-1.0f, 1.0f,   0.0f, 0.0f,   0.0f, 0.0f, 1.0f,
        -1.0f, 1.0f, 1.0f,   1.0f, 1.0f,   0.0f, 0.0f, 1.0f,
         1.0f,-1.0f, 1.0f,   0.0f, 0.0f,   0.0f, 0.0f, 1.0f,
         1.0f, 1.0f, 1.0f,   0.0f, 1.0f,   0.0f, 0.0f, 1.0f,
        -1.0f, 1.0f, 1.0f,   1.0f, 1.0f,   0.0f, 0.0f, 1.0f,

        // back
        -1.0f,-1.0f,-1.0f,   0.0f, 0.0f,   0.0f, 0.0f, -1.0f,
        -1.0f, 1.0f,-1.0f,   0.0f, 1.0f,   0.0f, 0.0f, -1.0f,
         1.0f,-1.0f,-1.0f,   1.0f, 0.0f,   0.0f, 0.0f, -1.0f,
         1.0f,-1.0f,-1.0f,   1.0f, 0.0f,   0.0f, 0.0f, -1.0f,
        -1.0f, 1.0f,-1.0f,   0.0f, 1.0f,   0.0f, 0.0f, -1.0f,
         1.0f, 1.0f,-1.0f,   1.0f, 1.0f,   0.0f, 0.0f, -1.0f,

        // left
        -1.0f,-1.0f, 1.0f,   0.0f, 1.0f,   -1.0f, 0.0f, 0.0f,
        -1.0f, 1.0f,-1.0f,   1.0f, 0.0f,   -1.0f, 0.0f, 0.0f,
        -1.0f,-1.0f,-1.0f,   0.0f, 0.0f,   -1.0f, 0.0f, 0.0f,
        -1.0f,-1.0f, 1.0f,   0.0f, 1.0f,   -1.0f, 0.0f, 0.0f,
        -1.0f, 1.0f, 1.0f,   1.0f, 1.0f,   -1.0f, 0.0f, 0.0f,
        -1.0f, 1.0f,-1.0f,   1.0f, 0.0f,   -1.0f, 0.0f, 0.0f,

        // right
         1.0f,-1.0f, 1.0f,   1.0f, 1.0f,   1.0f, 0.0f, 0.0f,
         1.0f,-1.0f,-1.0f,   1.0f, 0.0f,   1.0f, 0.0f, 0.0f,
         1.0f, 1.0f,-1.0f,   0.0f, 0.0f,   1.0f, 0.0f, 0.0f,
         1.0f,-1.0f, 1.0f,   1.0f, 1.0f,   1.0f, 0.0f, 0.0f,
         1.0f, 1.0f,-1.0f,   0.0f, 0.0f,   1.0f, 0.0f, 0.0f,
         1.0f, 1.0f, 1.0f,   0.0f, 1.0f,   1.0f, 0.0f, 0.0f
    };

    glBufferData(GL_ARRAY_BUFFER, sizeof(vertexData), vertexData, GL_STATIC_DRAW);

    // connect the xyz to the "vert" attribute of the vertex shader
    glEnableVertexAttribArray(glGetAttribLocation(cubeProgram, "vert"));
    glVertexAttribPointer(glGetAttribLocation(cubeProgram, "vert"), 3, GL_FLOAT, GL_FALSE, 8*sizeof(GLfloat), NULL);
        
    // connect the uv coords to the "vertTexCoord" attribute of the vertex shader
    glEnableVertexAttribArray(glGetAttribLocation(cubeProgram, "vertTexCoord"));
    glVertexAttribPointer(glGetAttribLocation(cubeProgram, "vertTexCoord"), 2, GL_FLOAT, GL_TRUE,  8*sizeof(GLfloat), (const GLvoid*)(3 * sizeof(GLfloat)));

    glEnableVertexAttribArray(glGetAttribLocation(cubeProgram, "vertNormal"));
    glVertexAttribPointer(glGetAttribLocation(cubeProgram, "vertNormal"), 3, GL_FLOAT, GL_TRUE, 8*sizeof(GLfloat), (const GLvoid*)(5 * sizeof(GLfloat)));

    glBindBuffer(GL_ARRAY_BUFFER, 0);
    // unbind the VAO
    glBindVertexArray(0);
}
