#ifndef GLOBALS_H_
#define GLOBALS_H_

#include <vector>
#include <SDL.h>
#include <SDL_mixer.h>
#include <GL/glew.h>
#include "camera.h"
#include "loader.h"
#include "imgui.h"

#define DEGREES_TO_RADS 0.01745329252

#define NUMBER_OF_CUBES 256

struct Light {
    vec3_t position;
    vec3_t intensities; //a.k.a. the color of the light
};

extern SDL_Window* window;
extern SDL_GLContext glContext;

extern Mix_Music* hanhiMusic12;

extern const int WINDOW_SIZE_X;
extern const int WINDOW_SIZE_Y;
extern const int CREATE_WINDOW_FLAGS;

extern int currentFPS;
extern int gameRunning;
extern int masterTimer;
extern int demoTimer;
extern int disableVSyncAtStartup;

extern Camera camera;

extern GLuint ruxiTexture;

extern GLuint triangleVAO;
extern GLuint triangleVBO;
extern GLuint triangleProgram;

extern GLuint rectVAO;
extern GLuint rectVBO;
extern GLuint rectProgram;

extern GLuint cubeVAO;
extern GLuint cubeVBO;
extern GLuint cubeProgram;

extern GLuint voroProgram;
extern int voroTimeLoc;

extern int timeLoc;

extern Light gLight;

extern bool mouseModeFreeLook;
extern int storedMouseCoordX;
extern int storedMouseCoordY;

extern int demoPhase;
extern bool demoPaused;

extern bool freeMove;

extern std::vector<CameraKeyFrame> cameraKeyFrames;

extern bool show_test_window;
extern bool show_debug_window;
extern ImVec4 clear_color;

extern ModelAsset testCube;

extern ModelInstance boxInstances[NUMBER_OF_CUBES];

extern float seaAlpha;
extern int seaAlphaLoc;

#endif