#version 330
// The MIT License
// Copyright © 2013 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

uniform float time;
float iGlobalTime = time / 500.0f;
vec2 iResolution = vec2(0.2f,0.2f);

vec2 hash( vec2 p ) { p=vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))); return fract(sin(p)*18.5453); }

// return distance, and cell id
vec2 voronoi( in vec2 x )
{
    vec2 n = floor( x );
    vec2 f = fract( x );

	vec3 m = vec3( 8.0 );
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        vec2  g = vec2( float(i), float(j) );
        vec2  o = hash( n + g );
        //vec2  r = g - f + o;
	    vec2  r = g - f + (0.5+0.5*sin(iGlobalTime+6.2831*o));
		float d = dot( r, r );
        if( d<m.x )
            m = vec3( d, o );
    }

    return vec2( sqrt(m.x), m.y+m.z );
}
out vec4 fragColor;
in vec2 fragCoord;
void main(  )
{
    vec2 p = fragCoord.xy/max(iResolution.x,iResolution.y);
    
    // computer voronoi patterm
    vec2 c = voronoi( (14.0+6.0*sin(0.03*iGlobalTime))*p );

    // colorize
    vec3 col = 0.5 + 0.5*cos( c.y*6.2831 + vec3(0.0,1.0,2.0) );	
    //col *= clamp(1.0 - 0.4*c.x*c.x,0.0,1.0);
    //col -= (1.0-smoothstep( 0.08, 0.09, c.x));
    float paletteShift = 166.0f;
	
    float alpha = 1.0f;
    if (time < 60000.0f)
    {
        alpha = 1.0 -0-smoothstep(39000,43000,time);
    }
    else { alpha = 1.0f; paletteShift = 53.0f; }

    int timei = int(time/paletteShift);

    if (timei % 4 == 0)
    {
        fragColor = vec4( col.y, col.x, col.z, alpha );
    }
    else if (timei % 4 == 1)
    {
       fragColor = vec4( col.y, 1.0 - col.x, col.z, alpha ); 
    }
    else if (timei % 4 == 2)
    {
        fragColor = vec4( col.x, col.z, 1.0-col.y, alpha ); 
    }
    else
    {
        fragColor = vec4( col.z, col.y, col.x, alpha);
    }
    
}