#version 410

#include "uniforms.glsl"

// Inputs
uniform float uExposure;
uniform float uOnlyGreen;
uniform float uScanlines;

// Hdr-input
uniform sampler2D uHdrSampler;

// Output
out vec4 fragColor;

// Apply exposure and gamma-correction
void main()
{
    const float gamma = 2.2;
    vec2 texCoord = gl_FragCoord.xy / uRes;
    vec3 hdr = texture(uHdrSampler, texCoord).rgb;
    vec3 mapped = vec3(1) - exp(-hdr * uExposure);
    mapped = pow(mapped, vec3(1 / gamma));
    // Scanlines
    if (uScanlines > 0) mapped *= clamp(pow(sin(texCoord.y * 800), 2), 0, 1);
    // Colorgrading
    if (uOnlyGreen > 0) mapped.rb *= 0.2;
    fragColor = vec4(mapped, 1);
}
