#version 410

#include "uniforms.glsl"
#include "hg_sdf.glsl"
#include "material.glsl"
#include "math.glsl"
#include "noise.glsl"

// Uniforms
uniform float uTwistAmount;
uniform float uLightPosX;
uniform float uLightPosY;
uniform float uLightPosZ;
uniform float uLightColR;
uniform float uLightColG;
uniform float uLightColB;

// Textures
uniform sampler2D uFbmSampler;

// Lights
const int NUM_LIGHTS = 1;
vec3      LIGHT_POS[NUM_LIGHTS] = vec3[](vec3(uLightPosX, uLightPosY, uLightPosZ));
vec3      LIGHT_INT[NUM_LIGHTS] = vec3[](vec3(uLightColR, uLightColG, uLightColB));

SceneResult scene(vec3 p)
{
    vec3 pTube = p;
    pR(pTube.xz, uTwistAmount * length(pTube));
    vec3 nWall1 = vec3(0, 0, -1);
    pR(nWall1.xz, 1);
    vec3 nWall2 = vec3(0, 0, -1);
    pR(nWall2.xz, -1);
    vec3 nWall3 = vec3(0, 0, 1);
    float fWalls = min(min(fPlane(pTube, nWall1, 1), fPlane(pTube, nWall2, 1)), fPlane(pTube, nWall3, 1));
    SceneResult walls = SceneResult(fWalls, 1);
    return walls;
}

Material evalMaterial(vec3 p, float matI)
{
    Material mat;
    if (matI < 1) {
        mat = mWhiteLight;
        mat.emissivity = LIGHT_INT[0];
    } else {
        mat = mIron;
        mat.roughness = 0.3 + 0.2 * fbm(p + vec3(0, uGT * 0.01, 0));
    }
    return mat;
}

// Main sphere tracing -stuff
#include "sphere_tracing_end.glsl"
