#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform sampler2D iChannel0;

varying vec4 vertColor;
varying vec3 vertNormal;
varying vec3 vertLightDir;
vec3 noise(in vec2 c)
{
  return vec3(fract(sin(dot(c.xy, vec2(12.9898,78.233))) * 43758.5453));
}

vec4 mod289(vec4 x)
{
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 permute(in vec4 x)
{
  return mod289(((x*34.0)+1.0)*x);
}

vec4 taylorInvSqrt(in vec4 r)
{
  return 1.79284291400159 - 0.85373472095314 * r;
}

vec2 fade(vec2 t) {
  return t*t*t*(t*(t*6.0-15.0)+10.0);
}

// Classic Perlin noise
vec3 perlin(in vec2 p)
{
  vec4 Pi = floor(p.xyxy) + vec4(0.0, 0.0, 1.0, 1.0);
  vec4 Pf = fract(p.xyxy) - vec4(0.0, 0.0, 1.0, 1.0);
  Pi = mod289(Pi); // To avoid truncation effects in permutation
  vec4 ix = Pi.xzxz;
  vec4 iy = Pi.yyww;
  vec4 fx = Pf.xzxz;
  vec4 fy = Pf.yyww;

  vec4 i = permute(permute(ix) + iy);

  vec4 gx = fract(i * (1.0 / 41.0)) * 2.0 - 1.0 ;
  vec4 gy = abs(gx) - 0.5 ;
  vec4 tx = floor(gx + 0.5);
  gx = gx - tx;

  vec2 g00 = vec2(gx.x,gy.x);
  vec2 g10 = vec2(gx.y,gy.y);
  vec2 g01 = vec2(gx.z,gy.z);
  vec2 g11 = vec2(gx.w,gy.w);

  g00 *= pow(dot(g00, g00), -0.5);
  g01 *= pow(dot(g01, g01), -0.5);
  g10 *= pow(dot(g10, g10), -0.5);
  g11 *= pow(dot(g11, g11), -0.5);

  float n00 = dot(g00, vec2(fx.x, fy.x));
  float n10 = dot(g10, vec2(fx.y, fy.y));
  float n01 = dot(g01, vec2(fx.z, fy.z));
  float n11 = dot(g11, vec2(fx.w, fy.w));

  vec2 fade_xy = fade(Pf.xy);
  vec2 n_x = mix(vec2(n00, n01), vec2(n10, n11), fade_xy.x);
  float n_xy = mix(n_x.x, n_x.y, fade_xy.y);
  return vec3(n_xy);
}


float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
vec4 mainImage(vec2 fragCoord ){
  vec4 fragColor;
  vec2 p = fragCoord.xy / iResolution.xy;

  float aspectCorrection = (iResolution.x/iResolution.y);
  vec2 coordinate_entered = 2.0 * p - 1.0;
  vec2 coord = vec2(aspectCorrection,1.0) * coordinate_entered;
    
    coord.x -= -0.5+rand(vec2(floor(iGlobalTime+121.)));
    coord.y -= -0.5+rand(vec2(floor(iGlobalTime)));
    coord *= 1.0+mod(iGlobalTime,1.0)*ceil(rand(vec2(floor(iGlobalTime)))*1.25-0.75);
    
    float rr = pow( float( 1.5*perlin( vec2(iGlobalTime*0.1) ) ), 2.0);
    
    float rt = 0.7*iGlobalTime;
    mat2 rot = mat2(cos(rr),-sin(rr),sin(rr),cos(rr));
    float z = 0.5+0.3*float(perlin(vec2(rt*2.2, length(0.5*coord))));
    
    vec2 tc = coord;
    vec2 unreal=6.0*z*tc*rot;
    unreal*=4.+sin(iGlobalTime)*.1;
    unreal.x = mod(unreal.x,.5)-0.35;
    unreal.y = mod(unreal.y,.5)-0.35;
    float sizer1 = 1.+abs(coord.y*0.2);
    vec3 rgb = vec3(0.3);
    rgb  = vec3(max(min(floor(length(unreal)*10.*sizer1),1.),0.3));
    rgb *= vec3(max(min(floor(length(unreal+vec2(.25))*10.*sizer1),1.),0.));
    rgb *= vec3(min(max(rgb.r,0.0),1.),min(max(rgb.g,0.),1.),min(max(rgb.b,0.),1.));
    rgb -= vec3(0.8,0.5,0.28);
    
    vec2 cyclicmovement = vec2(cos(iGlobalTime*1.121),sin(iGlobalTime*1.121));
    vec2 magicCoord = cyclicmovement+coord*length(coord+cyclicmovement*mod(iGlobalTime*2.,4.));
    float s=texture(iChannel0,magicCoord*0.25).r*0.1-0.022;
    
    
    if(length(coord+s)*(1.+.6*sin(iGlobalTime))<.1)
    {
        rgb = vec3(1.0, 0.5, 0.2)*(1.0+texture(iChannel0,unreal*2.0).r*0.2-0.1);
    }
    else
    {
        rgb += vec3(.11)+texture(iChannel0,unreal*2.0).rgb*0.2;
    }
    
    vec3 f = vec3(1.0);
    rgb /= smoothstep(0.0, 1.5, pow(f, vec3(-1.0)));
  
    
    rgb += vec3(1.-min(mod(floor(length(coord)*(-9.12+mod(iGlobalTime+floor(iGlobalTime)+length(coord)*4.121,4.)))+iGlobalTime,4.),1.));
    fragColor = vec4( vec3(1.0)-min(max(rgb,vec3(0.0)),vec3(1.0)), 1.0 );
    fragColor.rgb = smoothstep(0.5, 0.5, fragColor.rgb);
    return fragColor;
}
void main() {
  vec4 fragColor;
  
  gl_FragColor = mainImage( gl_FragCoord.xy );
}