pico-8 cartridge // http://www.pico-8.com
version 8
__lua__

app_muspos=0
app_hilvl=0
lvl=0

function reset(nlvl)
 -- app stuff
 app_hilvl=max(app_hilvl,lvl)
 app_muspos=(flr(app_muspos+lvl/10)*2)%24 
 -- time
 t=0 
 -- player vars
	xp=14
	xs=1
	yp=72
	ys=-5
	ldx=0
	-- state vars
	dead=false
	canreset=false
	resetting=false
	deadt=0
	lvl=nlvl
	-- anim
	blinkt=16
	eyect=32
	windy=false
	winginv=0
	fadet=72
	-- generator state
	gen_x=180
	gen_y=64
	gen_h=24
	-- init pipes
	pipes={}
	--local pipe_start=170;
	if (app_hilvl>4) gen_x-=60;
	if (app_hilvl>8) gen_x-=30;
	if (app_hilvl>16) gen_x-=15;
	if (app_hilvl>32) gen_x-=15;
	for i=1,8,1 do
	 local pipe={ }
	 regen_pipe(pipe,false)
	 add(pipes,pipe);
	end
	music(app_muspos) 
end

function regen_pipe(pipe)
 local offs=60
 if (lvl>10 and rnd(12)>10) offs+=60
 if (lvl>5 and rnd(6)>3) offs-=10
 if (lvl>10 and rnd(6)>3) offs-=10
 if (lvl>15 and rnd(6)>3) offs-=10
 if (lvl>20 and rnd(6)>3) offs-=10
 if (lvl>25 and rnd(6)>3) offs-=10
 gen_x+=offs
 pipe.x=gen_x
 pipe.armed=true
 pipe.ys=0
 if (lvl>20 and rnd(8)>6) pipe.ys+=(rnd(4)-rnd(4))/4
 if (lvl>30 and rnd(8)>6) pipe.ys+=(rnd(4)-rnd(4))/4
 gen_y+=rnd(offs+lvl)
 gen_y-=rnd(offs+lvl)
 gen_h+=rnd(offs+lvl)
 gen_h-=rnd(offs+lvl)
 gen_h=max(gen_h,16)
 gen_h=mid(24-lvl*4,gen_h,32)
 gen_y=mid(16+gen_h,gen_y,112-gen_h)
 pipe.y=flr(gen_y)
 pipe.h=flr(gen_h)
end

function update_pipes(dt,doy)
 -- update generator coord
 gen_x-=dt
 -- update each pipe
 for pipe in all(pipes) do
  if(not dead) then
	  if (pipe.x<-16) regen_pipe(pipe);
	  if (pipe.armed) then
		  if (xp>=pipe.x+14) then
		   pipe.armed=false
		   sfx(3,1) 
		   lvl+=1
		  end
	  end
	  if (xp<pipe.x+14 and xp>pipe.x and (yp<pipe.y-pipe.h or yp>pipe.y+pipe.h)) then
		  dead=true sfx(2,0)
	  end
	  -- moving pipe
	  pipe.y+=pipe.ys
			if (pipe.y-pipe.h<16) pipe.ys=abs(pipe.ys)
			if (pipe.y+pipe.h>112) pipe.ys=-abs(pipe.ys)
 	end
		pipe.x-=dt
 end
end

function draw_pipes()
 for pipe in all(pipes) do
 	map(0,32,pipe.x,pipe.y-pipe.h-10*8,2,10);
 	map(2,32,pipe.x,pipe.y+pipe.h,2,10);
 end
end

function _update()
 -- state machine
 if (resetting) then
 	deadt+=1
  if (deadt<35) t+=0.25 xp-=0.25 update_pipes(0.25)
  fadet+=5
  if (btnp(2)or btnp(4) or btnp(5)) fadet+=20
  if (fadet>74) reset(max(0,flr(lvl*0.75)-4))
 elseif (canreset) then
  deadt+=1
  if (deadt<35) t+=0.25 xp-=0.25 update_pipes(0.25)
  if (btnp(2)or btnp(4) or btnp(5)) resetting=true
 elseif (dead) then 
  -- player is dead
  deadt+=1
  if (yp>121) yp=121
  if (deadt>5) canreset=true
  t+=0.5
  xp-=0.5
  update_pipes(0.25)
		music(-1) 
 else
  -- player is alive
  local dt=mid(50,lvl,100)/50
  -- handle input
  if (btnp(2)or btnp(4) or btnp(5)) then
   if(ys<0) winginv=2
  	ys=-5.1 sfx(0,0)
  end
  if (btn(1)) xs+=0.1
  if (btn(0)) xs-=0.1
  xs*=0.95
  xp+=xs
  xp=mid(8,xp,120);
  ys+=0.48
  yp+=ys
  t+=dt
		-- wind effect
		if (windy) then
		 if (ys<0) windy=false
		else
		 if (ys>2.5) windy=true sfx(14,0)
		end
  -- state change
  if (yp>124) dead=true sfx(1,0)   
  -- pipes
  update_pipes(dt);
  -- anim stuff
  if (fadet>0)fadet-=8
  blinkt-=1
  eyect-=1
  if (eyect<0)eyect=rnd(120)
		if(blinkt<0)blinkt=rnd(64)
 end
 
end

function fade(anim)
 for i=1,15,1 do
  pal(i,i)
 end
 if (anim<=0) return
 local data={
  14,8, 13,5, 6,13,
  12,13, 10,9, 8,2, 11,3,
  5,1,  7,6,   9,4,  4,2,  3,5,
  9,1,   4,1,  1,0,  14,2, 3,1,
  13,1, 5,0, 12,5, 7,13, 4,0, 12,1, 11,1, 3,0,
  9,0, 13,0, 8,1, 2,0, 
  12,0, 8,0, 15,0, 6,0, 7,0
 }
 local limit=min(anim,count(data))
	for i=1,limit,2 do
		pal(data[i],data[i+1])
	end
end

function _draw()
 fade(fadet)
 if(dead and deadt<1) then
  pal(1,8)
 end
 rectfill(0,0,127,127,1);
 -- cloud hi
 map(0,0,-(t/13%256),    12,128,10)
 map(0,0,-(t/13%256)+256,12,128,10)
 
 -- cloud lower
 map(0,10,-(t/7%256)-64    ,60,128,6)
 map(0,10,-(t/7%256)-64+256,60,128,6)
 -- hills
 map(0,18,-(t/3%256)    ,68,128,8)
 map(0,18,-(t/3%256)+256,68,128,8)
 -- cloud lowest
 map(0,25,-(t/2%256)    ,80,128,6)
 map(0,25,-(t/2%256)+256,80,128,6)
 
 -- score when playing
 if (not dead and lvl>0) then
	 print(lvl,56,4,12)
	 -- print(app_hilvl,56,10,12)
	end

 -- pipe a
 draw_pipes()
 -- floor
 map(0,16,-(t%256)    ,120,32,1)
 map(0,16,-(t%256)+256,120,32,1)
 -- bird
 local x=(xp+ldx*4)/5
 local y=yp-2
 local lys=ys
 ldx = x
 -- body
 spr(12,x-5,y-mid(-1,ys/3,1));
 spr(11,x-8,y-mid(-2,ys/2,2));
 spr(10,x-10,y-mid(-3,ys/1.6,3));
 -- wing
 if (winginv>0) lys=2*winginv winginv-=1
 if(lys>0.5)  spr(15,x-7,y-1-min(lys*1.2,3))
 if(lys<-0.5) spr(14,x-7,y-1-max(lys*1.2,-3))
 -- eye
 x-=1
 y+=1
 -- blink
 if (blinkt<2) then
	 spr(31,x-2,y-2)
	else
	 spr(13,x-2,y-2)
	 if (dead) then
	  for i=-1,1,1 do
	   for j=-1,1,1 do
	    if((i+j+2)%2==0) pset(x-i,y-j,0)
	   end
	  end
	 else 
			-- center eye
	  if eyect<2 then
	   pset(x,y,0)
	  else
		  pset(x+1,y+mid(-1,(64-yp)/32,1),0)
	  end
	 end
 end
  
 -- score
	if (dead) then 
	 local x=xp+16
	 if (x>90) x-=64
		print("game over!",x,58,1)
		print("level",x,64,1)
		print(lvl,x+6*4,64,1)
	end
end

-- start game
reset(0)
__gfx__
0000000000000000000000cccccccccc00000000000000ccc00000000000000d00000000dddddddd000000000000000000111000011100000000000000011000
00000000000000000000ccccccccccccccc0000000000ccccc000000000000dd10000000dddddddd000000000111100001999100166610000000000000199100
007007000cccc000000cccccccccccccccccc0000000ccccccc0000000000ddd11000000dddddddd001100001999900019999910177710000000000001944100
00077000cccccc0000cccccccccccccccccccc000000ccccccc000000000dddd11100000dddddddd019900001999900019999981477710000199910001444100
00077000cccccc000ccccccccccccccccccccc0000ccccccccccc000000dddddd1110000dddddddd011400001444900019999981044400000199910001444100
007007000cccc0000cccccccccccccccccccccc00ccccccccccccc0000ddddddd1111000dddddddd000100000114400014444421000000000149910000444000
0000000000000000ccccccccccccccccccccccc0ccccccccccccccc00dddddddd1111100dddddddd000000000001100001444110000000000014410000444000
0000000000000000ccccccccccccccccccccccc0ccccccccccccccc0dddddddddd111110dddddddd000000000000000000111000000000000001100000000000
00000000000000007777777777000000007777700000000000000000000000000000000000000000000000000000000000000000000000000000000001110000
00000000000007777777777777770000077777770000000000000000000000001000010000000100000000000000000000000110000000000000000019991000
00000000000777777777777777777000077777770010001000000110001000103110131100111311000001100100000001111311000000000000000019991000
00000000007777777777777777777700007777700131013100001331013101313131331301333313011113311310001013313313000000000000000044441000
00000000007777777777777777777770000000001331013111113333133101313131333313333333133333331331013133333333000000000000000004440000
00000000077777777777777777777770000000003333133333333553333313333333333333555533333335533333133333333333000000000000000000000000
00000000077777777777777777777777000000003333333333335544333333554333555335544453333354443333333353335553000000000000000000000000
00000000077777777777777777777777000000003355355555555444535335544435544433543444555544445353335544354445000000000000000000000000
111111111111111101cb7bb3b3113c1001cb7bb3b3113c1000000000111111111111111100000000000000000000000000000000000000000000000000000000
1c7777ccccccccc101cb7bb3b3113c1001cb7bb3b3113c1010000000111111111111111100000000000000000000000000000000000000000000000000000000
1cb7bbb3333113c101cb7bb3b3113c1001cb7bb3b3113c101100000011111111d111111100000000000000000000000000000000000000000000000000000000
1cb7bb333b3113c101cb7bb3b3113c1001cb7bb3b3113c10d110000011111111d111111100000000000000000000000000000000000000000000000000000000
1cb7bb333b3113c101cb7bb3b3113c1001cb7bb3b3113c10d111000011111111dd11111100000000000000000000000000000000000000000000000000000000
1cb7bb333b3113c101cb7bb3b3113c10013b7bb3b3113c10dd11100011111111dd11111100000000000000000000000000000000000000000000000000000000
13bbbb333b3113c101cb7bb3b3113c10013b7bb3b3113c10dd11110011111111ddd1111100000000000000000000000000000000000000000000000000000000
111111111111111101cb7bb3b3113c100113b33131111310ddd1111011111111ddd1111100000000000000000000000000000000000000000000000000000000
013111111111111001cb7bb3b3113c101111111111111111ddd11111000000001ddddddd1111dddd000000000000000000000000000000000000000000000000
013b31111111111001cb7bb3b3113c101cb7bbb33b333cc1dddd1111100000001ddddddd11111ddd000000000000000000000000000000000000000000000000
01cb73311111131001cb7bb3b3113c101cb7bb333b3113c1dddd11111100000011dddddd11111ddd000000000000000000000000000000000000000000000000
01cb7bb333113c1001cb7bb3b3113c101cb7bb333b3113c1dddd11111110000011dddddd111111dd000000000000000000000000000000000000000000000000
01cb7bb3b3113c1001cb7bb3b3113c101cb7bb333b3113c1ddddd11111110000111ddddd111111dd000000000000000000000000000000000000000000000000
01cb7bb3b3113c1001cb7bb3b3113c101cb7bb333b3113c1dddddd1111111000111ddddd1111111d000000000000000000000000000000000000000000000000
01cb7bb3b3113c1001cb7bb3b3113c101cbbbb3333311331dddddd11111111001111dddd1111111d000000000000000000000000000000000000000000000000
01cb7bb3b3113c1001cb7bb3b3113c101111111111111111ddddddd1111111101111dddd11111111000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
22320212000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
23330313000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
22322232000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
22322333000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
23332232000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
23332333000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
22322232000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
23332333000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
42522232000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
43532333000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

__gff__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
0001000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000001000000020306050600000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000020304000203060203030303030303030401000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0005030303050303030303030303030303030304000000000203030304000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0303030303030303030303030303030303030303030600050303030303030600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0303030303030303030303030303030303030303030303030303030303030303000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0303030303030303030303030303030303030303030303030303030303030303000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0303030303030303030303030303030303030303030303030303030303030303000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0303030303030303030303030303030303030303030303030303030303030303000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0303030303030303030303030303030303030303030303030303030303030303000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0303030303030303030303030303030303030303030303030303030303030303000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000140000001112130000000000000011121213140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000140011121311121212121311121311131112121212121311121314000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1411121212121212121212121212121212121212121212121212121212121213000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1212121212121212121212121212121212121212121212121212121212121212000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1212121212121212121212121212121212121212121212121212121212121212000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
151c18181516171b151a17181515151a19161b1c1515191b171c171b15181519000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000070800000000000000000007080000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000070800000000000007093637072600000000000709363700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0726000007093637000000000709090928383637000708070909092837072600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0936370709090928380800070909090936390928380936380909093627383637000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0909283809090936393639090909090909363836390909283909090936390928000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0909362738090909283828390909090909090909363809362738090909363836000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000111213000000000014111213140000000000000000000000000011121300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1411121212140000001112121212130011121300000000001113141112121213000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1112121212130011121212121212121212121212131411121212121212121212000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1212121212121212121212121212121212121212121212121212121212121212000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
000100000c61316623126331f6532462012240031500d150181602b460214502342013420157201472014720137201371013710127101271011710107100f7100e7100c7100a7100871005710037100171000010
00020000207701a770126700d77010660017600965009650096400a6300563005620056200d620057200472004720047200472004720047200472004720037200472004720047200472004720047200472004720
0002151439270242700c2600567038670356701667015670256701165024630136500424004220042400424004230042300423004220042200422004220042200422004210042100421004210042100421004210
000100001f3701f3701f3701f3701f3601f3601f3501f3401f3301f33030370303703037030370303703036030360303503035030350303503034030340303403033030330303303032030320303103031030310
011400000c0231a0000c0231c000186250000034425210000c0230c0230c0230000018625000000c023000000c023024240c02302424186250000034425000000c0230c0230c0230000018625186051862518625
011400000c053054240543105441186550542405431054410c053074240743107441186550742407431074410c053024240243102441186550242402431024410c05301424014310144118655004240c0530c053
011400000c053054350541505445186550543505415054450c053074350741507445186550743507415074450c053024350241502445186550243502415024450c05301435014150144518655004350041500445
011400000c053051350521505345186550513505215053450c053073350721507145186550713507215073450c053021350221502345186550233502215021450c05301335012150114518655001350021500345
011400000c0530c053052150c053186550513505215053450c05307135072150c053186550c05307215073450c053021350221502345186550c05318655023450c05301135012150c05318655186550021518655
011400000513505235053150544505135052350531505445074350733507215071450713507235073150744502135022350231502445024350233502215021450113501235013150144500135002350031500445
01140000117311173111731117311173111731117311173113731137311373113731137311373113731137310e7310e7310e7310e7310e7310e7310e7310e7310d7310d7310d7310d7310c7310c7310c7310c731
01140000117221172211722117221172211722117221172213722137221372213722137221372213722137220e7220e7220e7220e7220e7220e7220e7220e7220d7220d7220d7220d7220c7220c7220c7220c722
011400000261405711047110071100701027010461105711057110471100701027010761105711047110071102701047010761100611046110071104711007110571109711007110271104701077010561100715
011400000c0131a0000c0031c0001860500000186152100018615000000000000000000000000000000000000c0131a0000c0031c000186050000018615210001861500000000000000018615000000c0130c003
00041d1f13601156111661117621196111a6211b6111c6211d6211f631206212163123631256412763127641296412b6512c6412b6512e6512d66130651316613466136671386613a6713b6713f6713f6713f671
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 410c4b4c
00 410c434d
00 410c430d
00 410c430d
00 410c0b0d
00 410c0a0d
00 410b0a04
00 410b0a04
00 41424309
00 41424309
01 41424308
00 41424308
00 41424307
00 41424307
00 41424305
00 41424305
00 41420b09
00 41420b09
00 41420b08
00 41420b08
00 41420b07
00 41420b07
00 41420b05
02 41420b05
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344

