/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 72);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/* no static exports found */
/* all exports used */
/*!*******************************!*\
  !*** ./~/p2/src/math/vec2.js ***!
  \*******************************/
/***/ (function(module, exports, __webpack_require__) {

eval("/* Copyright (c) 2013, Brandon Jones, Colin MacKenzie IV. All rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification,\nare permitted provided that the following conditions are met:\n\n  * Redistributions of source code must retain the above copyright notice, this\n    list of conditions and the following disclaimer.\n  * Redistributions in binary form must reproduce the above copyright notice,\n    this list of conditions and the following disclaimer in the documentation\n    and/or other materials provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND\nANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\nDISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR\nANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\nLOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON\nANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\nSOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */\n\n/**\n * The vec2 object from glMatrix, with some extensions and some removed methods. See http://glmatrix.net.\n * @class vec2\n */\n\nvar vec2 = module.exports = {};\n\nvar Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\n/**\n * Make a cross product and only return the z component\n * @method crossLength\n * @static\n * @param  {Array} a\n * @param  {Array} b\n * @return {Number}\n */\nvec2.crossLength = function(a,b){\n    return a[0] * b[1] - a[1] * b[0];\n};\n\n/**\n * Cross product between a vector and the Z component of a vector\n * @method crossVZ\n * @static\n * @param  {Array} out\n * @param  {Array} vec\n * @param  {Number} zcomp\n * @return {Number}\n */\nvec2.crossVZ = function(out, vec, zcomp){\n    vec2.rotate(out,vec,-Math.PI/2);// Rotate according to the right hand rule\n    vec2.scale(out,out,zcomp);      // Scale with z\n    return out;\n};\n\n/**\n * Cross product between a vector and the Z component of a vector\n * @method crossZV\n * @static\n * @param  {Array} out\n * @param  {Number} zcomp\n * @param  {Array} vec\n * @return {Number}\n */\nvec2.crossZV = function(out, zcomp, vec){\n    vec2.rotate(out,vec,Math.PI/2); // Rotate according to the right hand rule\n    vec2.scale(out,out,zcomp);      // Scale with z\n    return out;\n};\n\n/**\n * Rotate a vector by an angle\n * @method rotate\n * @static\n * @param  {Array} out\n * @param  {Array} a\n * @param  {Number} angle\n */\nvec2.rotate = function(out,a,angle){\n    if(angle !== 0){\n        var c = Math.cos(angle),\n            s = Math.sin(angle),\n            x = a[0],\n            y = a[1];\n        out[0] = c*x -s*y;\n        out[1] = s*x +c*y;\n    } else {\n        out[0] = a[0];\n        out[1] = a[1];\n    }\n};\n\n/**\n * Rotate a vector 90 degrees clockwise\n * @method rotate90cw\n * @static\n * @param  {Array} out\n * @param  {Array} a\n * @param  {Number} angle\n */\nvec2.rotate90cw = function(out, a) {\n    var x = a[0];\n    var y = a[1];\n    out[0] = y;\n    out[1] = -x;\n};\n\n/**\n * Transform a point position to local frame.\n * @method toLocalFrame\n * @param  {Array} out\n * @param  {Array} worldPoint\n * @param  {Array} framePosition\n * @param  {Number} frameAngle\n */\nvec2.toLocalFrame = function(out, worldPoint, framePosition, frameAngle){\n    vec2.copy(out, worldPoint);\n    vec2.sub(out, out, framePosition);\n    vec2.rotate(out, out, -frameAngle);\n};\n\n/**\n * Transform a point position to global frame.\n * @method toGlobalFrame\n * @param  {Array} out\n * @param  {Array} localPoint\n * @param  {Array} framePosition\n * @param  {Number} frameAngle\n */\nvec2.toGlobalFrame = function(out, localPoint, framePosition, frameAngle){\n    vec2.copy(out, localPoint);\n    vec2.rotate(out, out, frameAngle);\n    vec2.add(out, out, framePosition);\n};\n\n/**\n * Transform a vector to local frame.\n * @method vectorToLocalFrame\n * @param  {Array} out\n * @param  {Array} worldVector\n * @param  {Number} frameAngle\n */\nvec2.vectorToLocalFrame = function(out, worldVector, frameAngle){\n    vec2.rotate(out, worldVector, -frameAngle);\n};\n\n/**\n * Transform a point position to global frame.\n * @method toGlobalFrame\n * @param  {Array} out\n * @param  {Array} localVector\n * @param  {Number} frameAngle\n */\nvec2.vectorToGlobalFrame = function(out, localVector, frameAngle){\n    vec2.rotate(out, localVector, frameAngle);\n};\n\n/**\n * Compute centroid of a triangle spanned by vectors a,b,c. See http://easycalculation.com/analytical/learn-centroid.php\n * @method centroid\n * @static\n * @param  {Array} out\n * @param  {Array} a\n * @param  {Array} b\n * @param  {Array} c\n * @return  {Array} The out object\n */\nvec2.centroid = function(out, a, b, c){\n    vec2.add(out, a, b);\n    vec2.add(out, out, c);\n    vec2.scale(out, out, 1/3);\n    return out;\n};\n\n/**\n * Creates a new, empty vec2\n * @static\n * @method create\n * @return {Array} a new 2D vector\n */\nvec2.create = function() {\n    var out = new Utils.ARRAY_TYPE(2);\n    out[0] = 0;\n    out[1] = 0;\n    return out;\n};\n\n/**\n * Creates a new vec2 initialized with values from an existing vector\n * @static\n * @method clone\n * @param {Array} a vector to clone\n * @return {Array} a new 2D vector\n */\nvec2.clone = function(a) {\n    var out = new Utils.ARRAY_TYPE(2);\n    out[0] = a[0];\n    out[1] = a[1];\n    return out;\n};\n\n/**\n * Creates a new vec2 initialized with the given values\n * @static\n * @method fromValues\n * @param {Number} x X component\n * @param {Number} y Y component\n * @return {Array} a new 2D vector\n */\nvec2.fromValues = function(x, y) {\n    var out = new Utils.ARRAY_TYPE(2);\n    out[0] = x;\n    out[1] = y;\n    return out;\n};\n\n/**\n * Copy the values from one vec2 to another\n * @static\n * @method copy\n * @param {Array} out the receiving vector\n * @param {Array} a the source vector\n * @return {Array} out\n */\nvec2.copy = function(out, a) {\n    out[0] = a[0];\n    out[1] = a[1];\n    return out;\n};\n\n/**\n * Set the components of a vec2 to the given values\n * @static\n * @method set\n * @param {Array} out the receiving vector\n * @param {Number} x X component\n * @param {Number} y Y component\n * @return {Array} out\n */\nvec2.set = function(out, x, y) {\n    out[0] = x;\n    out[1] = y;\n    return out;\n};\n\n/**\n * Adds two vec2's\n * @static\n * @method add\n * @param {Array} out the receiving vector\n * @param {Array} a the first operand\n * @param {Array} b the second operand\n * @return {Array} out\n */\nvec2.add = function(out, a, b) {\n    out[0] = a[0] + b[0];\n    out[1] = a[1] + b[1];\n    return out;\n};\n\n/**\n * Subtracts two vec2's\n * @static\n * @method subtract\n * @param {Array} out the receiving vector\n * @param {Array} a the first operand\n * @param {Array} b the second operand\n * @return {Array} out\n */\nvec2.subtract = function(out, a, b) {\n    out[0] = a[0] - b[0];\n    out[1] = a[1] - b[1];\n    return out;\n};\n\n/**\n * Alias for vec2.subtract\n * @static\n * @method sub\n */\nvec2.sub = vec2.subtract;\n\n/**\n * Multiplies two vec2's\n * @static\n * @method multiply\n * @param {Array} out the receiving vector\n * @param {Array} a the first operand\n * @param {Array} b the second operand\n * @return {Array} out\n */\nvec2.multiply = function(out, a, b) {\n    out[0] = a[0] * b[0];\n    out[1] = a[1] * b[1];\n    return out;\n};\n\n/**\n * Alias for vec2.multiply\n * @static\n * @method mul\n */\nvec2.mul = vec2.multiply;\n\n/**\n * Divides two vec2's\n * @static\n * @method divide\n * @param {Array} out the receiving vector\n * @param {Array} a the first operand\n * @param {Array} b the second operand\n * @return {Array} out\n */\nvec2.divide = function(out, a, b) {\n    out[0] = a[0] / b[0];\n    out[1] = a[1] / b[1];\n    return out;\n};\n\n/**\n * Alias for vec2.divide\n * @static\n * @method div\n */\nvec2.div = vec2.divide;\n\n/**\n * Scales a vec2 by a scalar number\n * @static\n * @method scale\n * @param {Array} out the receiving vector\n * @param {Array} a the vector to scale\n * @param {Number} b amount to scale the vector by\n * @return {Array} out\n */\nvec2.scale = function(out, a, b) {\n    out[0] = a[0] * b;\n    out[1] = a[1] * b;\n    return out;\n};\n\n/**\n * Calculates the euclidian distance between two vec2's\n * @static\n * @method distance\n * @param {Array} a the first operand\n * @param {Array} b the second operand\n * @return {Number} distance between a and b\n */\nvec2.distance = function(a, b) {\n    var x = b[0] - a[0],\n        y = b[1] - a[1];\n    return Math.sqrt(x*x + y*y);\n};\n\n/**\n * Alias for vec2.distance\n * @static\n * @method dist\n */\nvec2.dist = vec2.distance;\n\n/**\n * Calculates the squared euclidian distance between two vec2's\n * @static\n * @method squaredDistance\n * @param {Array} a the first operand\n * @param {Array} b the second operand\n * @return {Number} squared distance between a and b\n */\nvec2.squaredDistance = function(a, b) {\n    var x = b[0] - a[0],\n        y = b[1] - a[1];\n    return x*x + y*y;\n};\n\n/**\n * Alias for vec2.squaredDistance\n * @static\n * @method sqrDist\n */\nvec2.sqrDist = vec2.squaredDistance;\n\n/**\n * Calculates the length of a vec2\n * @static\n * @method length\n * @param {Array} a vector to calculate length of\n * @return {Number} length of a\n */\nvec2.length = function (a) {\n    var x = a[0],\n        y = a[1];\n    return Math.sqrt(x*x + y*y);\n};\n\n/**\n * Alias for vec2.length\n * @method len\n * @static\n */\nvec2.len = vec2.length;\n\n/**\n * Calculates the squared length of a vec2\n * @static\n * @method squaredLength\n * @param {Array} a vector to calculate squared length of\n * @return {Number} squared length of a\n */\nvec2.squaredLength = function (a) {\n    var x = a[0],\n        y = a[1];\n    return x*x + y*y;\n};\n\n/**\n * Alias for vec2.squaredLength\n * @static\n * @method sqrLen\n */\nvec2.sqrLen = vec2.squaredLength;\n\n/**\n * Negates the components of a vec2\n * @static\n * @method negate\n * @param {Array} out the receiving vector\n * @param {Array} a vector to negate\n * @return {Array} out\n */\nvec2.negate = function(out, a) {\n    out[0] = -a[0];\n    out[1] = -a[1];\n    return out;\n};\n\n/**\n * Normalize a vec2\n * @static\n * @method normalize\n * @param {Array} out the receiving vector\n * @param {Array} a vector to normalize\n * @return {Array} out\n */\nvec2.normalize = function(out, a) {\n    var x = a[0],\n        y = a[1];\n    var len = x*x + y*y;\n    if (len > 0) {\n        //TODO: evaluate use of glm_invsqrt here?\n        len = 1 / Math.sqrt(len);\n        out[0] = a[0] * len;\n        out[1] = a[1] * len;\n    }\n    return out;\n};\n\n/**\n * Calculates the dot product of two vec2's\n * @static\n * @method dot\n * @param {Array} a the first operand\n * @param {Array} b the second operand\n * @return {Number} dot product of a and b\n */\nvec2.dot = function (a, b) {\n    return a[0] * b[0] + a[1] * b[1];\n};\n\n/**\n * Returns a string representation of a vector\n * @static\n * @method str\n * @param {Array} vec vector to represent as a string\n * @return {String} string representation of the vector\n */\nvec2.str = function (a) {\n    return 'vec2(' + a[0] + ', ' + a[1] + ')';\n};\n\n/**\n * Linearly interpolate/mix two vectors.\n * @static\n * @method lerp\n * @param {Array} out\n * @param {Array} a First vector\n * @param {Array} b Second vector\n * @param {number} t Lerp factor\n */\nvec2.lerp = function (out, a, b, t) {\n    var ax = a[0],\n        ay = a[1];\n    out[0] = ax + t * (b[0] - ax);\n    out[1] = ay + t * (b[1] - ay);\n    return out;\n};\n\n/**\n * Reflect a vector along a normal.\n * @static\n * @method reflect\n * @param {Array} out\n * @param {Array} vector\n * @param {Array} normal\n */\nvec2.reflect = function(out, vector, normal){\n    var dot = vector[0] * normal[0] + vector[1] * normal[1];\n    out[0] = vector[0] - 2 * normal[0] * dot;\n    out[1] = vector[1] - 2 * normal[1] * dot;\n};\n\n/**\n * Get the intersection point between two line segments.\n * @static\n * @method getLineSegmentsIntersection\n * @param  {Array} out\n * @param  {Array} p0\n * @param  {Array} p1\n * @param  {Array} p2\n * @param  {Array} p3\n * @return {boolean} True if there was an intersection, otherwise false.\n */\nvec2.getLineSegmentsIntersection = function(out, p0, p1, p2, p3) {\n    var t = vec2.getLineSegmentsIntersectionFraction(p0, p1, p2, p3);\n    if(t < 0){\n        return false;\n    } else {\n        out[0] = p0[0] + (t * (p1[0] - p0[0]));\n        out[1] = p0[1] + (t * (p1[1] - p0[1]));\n        return true;\n    }\n};\n\n/**\n * Get the intersection fraction between two line segments. If successful, the intersection is at p0 + t * (p1 - p0)\n * @static\n * @method getLineSegmentsIntersectionFraction\n * @param  {Array} p0\n * @param  {Array} p1\n * @param  {Array} p2\n * @param  {Array} p3\n * @return {number} A number between 0 and 1 if there was an intersection, otherwise -1.\n */\nvec2.getLineSegmentsIntersectionFraction = function(p0, p1, p2, p3) {\n    var s1_x = p1[0] - p0[0];\n    var s1_y = p1[1] - p0[1];\n    var s2_x = p3[0] - p2[0];\n    var s2_y = p3[1] - p2[1];\n\n    var s, t;\n    s = (-s1_y * (p0[0] - p2[0]) + s1_x * (p0[1] - p2[1])) / (-s2_x * s1_y + s1_x * s2_y);\n    t = ( s2_x * (p0[1] - p2[1]) - s2_y * (p0[0] - p2[0])) / (-s2_x * s1_y + s1_x * s2_y);\n    if (s >= 0 && s <= 1 && t >= 0 && t <= 1) { // Collision detected\n        return t;\n    }\n    return -1; // No collision\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///0\n");

/***/ }),
/* 1 */
/* no static exports found */
/* all exports used */
/*!*********************************!*\
  !*** ./~/p2/src/utils/Utils.js ***!
  \*********************************/
/***/ (function(module, exports) {

eval("/* global P2_ARRAY_TYPE */\n\nmodule.exports = Utils;\n\n/**\n * Misc utility functions\n * @class Utils\n * @constructor\n */\nfunction Utils(){}\n\n/**\n * Append the values in array b to the array a. See <a href=\"http://stackoverflow.com/questions/1374126/how-to-append-an-array-to-an-existing-javascript-array/1374131#1374131\">this</a> for an explanation.\n * @method appendArray\n * @static\n * @param  {Array} a\n * @param  {Array} b\n */\nUtils.appendArray = function(a,b){\n    if (b.length < 150000) {\n        a.push.apply(a, b);\n    } else {\n        for (var i = 0, len = b.length; i !== len; ++i) {\n            a.push(b[i]);\n        }\n    }\n};\n\n/**\n * Garbage free Array.splice(). Does not allocate a new array.\n * @method splice\n * @static\n * @param  {Array} array\n * @param  {Number} index\n * @param  {Number} howmany\n */\nUtils.splice = function(array,index,howmany){\n    howmany = howmany || 1;\n    for (var i=index, len=array.length-howmany; i < len; i++){\n        array[i] = array[i + howmany];\n    }\n    array.length = len;\n};\n\n/**\n * The array type to use for internal numeric computations throughout the library. Float32Array is used if it is available, but falls back on Array. If you want to set array type manually, inject it via the global variable P2_ARRAY_TYPE. See example below.\n * @static\n * @property {function} ARRAY_TYPE\n * @example\n *     <script>\n *         <!-- Inject your preferred array type before loading p2.js -->\n *         P2_ARRAY_TYPE = Array;\n *     </script>\n *     <script src=\"p2.js\"></script>\n */\nif(typeof P2_ARRAY_TYPE !== 'undefined') {\n    Utils.ARRAY_TYPE = P2_ARRAY_TYPE;\n} else if (typeof Float32Array !== 'undefined'){\n    Utils.ARRAY_TYPE = Float32Array;\n} else {\n    Utils.ARRAY_TYPE = Array;\n}\n\n/**\n * Extend an object with the properties of another\n * @static\n * @method extend\n * @param  {object} a\n * @param  {object} b\n */\nUtils.extend = function(a,b){\n    for(var key in b){\n        a[key] = b[key];\n    }\n};\n\n/**\n * Extend an options object with default values.\n * @static\n * @method defaults\n * @param  {object} options The options object. May be falsy: in this case, a new object is created and returned.\n * @param  {object} defaults An object containing default values.\n * @return {object} The modified options object.\n */\nUtils.defaults = function(options, defaults){\n    options = options || {};\n    for(var key in defaults){\n        if(!(key in options)){\n            options[key] = defaults[key];\n        }\n    }\n    return options;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///1\n");

/***/ }),
/* 2 */
/* no static exports found */
/* all exports used */
/*!****************************************!*\
  !*** ./~/p2/src/equations/Equation.js ***!
  \****************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("module.exports = Equation;\n\nvar vec2 = __webpack_require__(/*! ../math/vec2 */ 0),\n    Utils = __webpack_require__(/*! ../utils/Utils */ 1),\n    Body = __webpack_require__(/*! ../objects/Body */ 7);\n\n/**\n * Base class for constraint equations.\n * @class Equation\n * @constructor\n * @param {Body} bodyA First body participating in the equation\n * @param {Body} bodyB Second body participating in the equation\n * @param {number} minForce Minimum force to apply. Default: -Number.MAX_VALUE\n * @param {number} maxForce Maximum force to apply. Default: Number.MAX_VALUE\n */\nfunction Equation(bodyA, bodyB, minForce, maxForce){\n\n    /**\n     * Minimum force to apply when solving.\n     * @property minForce\n     * @type {Number}\n     */\n    this.minForce = typeof(minForce)===\"undefined\" ? -Number.MAX_VALUE : minForce;\n\n    /**\n     * Max force to apply when solving.\n     * @property maxForce\n     * @type {Number}\n     */\n    this.maxForce = typeof(maxForce)===\"undefined\" ? Number.MAX_VALUE : maxForce;\n\n    /**\n     * First body participating in the constraint\n     * @property bodyA\n     * @type {Body}\n     */\n    this.bodyA = bodyA;\n\n    /**\n     * Second body participating in the constraint\n     * @property bodyB\n     * @type {Body}\n     */\n    this.bodyB = bodyB;\n\n    /**\n     * The stiffness of this equation. Typically chosen to a large number (~1e7), but can be chosen somewhat freely to get a stable simulation.\n     * @property stiffness\n     * @type {Number}\n     */\n    this.stiffness = Equation.DEFAULT_STIFFNESS;\n\n    /**\n     * The number of time steps needed to stabilize the constraint equation. Typically between 3 and 5 time steps.\n     * @property relaxation\n     * @type {Number}\n     */\n    this.relaxation = Equation.DEFAULT_RELAXATION;\n\n    /**\n     * The Jacobian entry of this equation. 6 numbers, 3 per body (x,y,angle).\n     * @property G\n     * @type {Array}\n     */\n    this.G = new Utils.ARRAY_TYPE(6);\n    for(var i=0; i<6; i++){\n        this.G[i]=0;\n    }\n\n    this.offset = 0;\n\n    this.a = 0;\n    this.b = 0;\n    this.epsilon = 0;\n    this.timeStep = 1/60;\n\n    /**\n     * Indicates if stiffness or relaxation was changed.\n     * @property {Boolean} needsUpdate\n     */\n    this.needsUpdate = true;\n\n    /**\n     * The resulting constraint multiplier from the last solve. This is mostly equivalent to the force produced by the constraint.\n     * @property multiplier\n     * @type {Number}\n     */\n    this.multiplier = 0;\n\n    /**\n     * Relative velocity.\n     * @property {Number} relativeVelocity\n     */\n    this.relativeVelocity = 0;\n\n    /**\n     * Whether this equation is enabled or not. If true, it will be added to the solver.\n     * @property {Boolean} enabled\n     */\n    this.enabled = true;\n}\nEquation.prototype.constructor = Equation;\n\n/**\n * The default stiffness when creating a new Equation.\n * @static\n * @property {Number} DEFAULT_STIFFNESS\n * @default 1e6\n */\nEquation.DEFAULT_STIFFNESS = 1e6;\n\n/**\n * The default relaxation when creating a new Equation.\n * @static\n * @property {Number} DEFAULT_RELAXATION\n * @default 4\n */\nEquation.DEFAULT_RELAXATION = 4;\n\n/**\n * Compute SPOOK parameters .a, .b and .epsilon according to the current parameters. See equations 9, 10 and 11 in the <a href=\"http://www8.cs.umu.se/kurser/5DV058/VT09/lectures/spooknotes.pdf\">SPOOK notes</a>.\n * @method update\n */\nEquation.prototype.update = function(){\n    var k = this.stiffness,\n        d = this.relaxation,\n        h = this.timeStep;\n\n    this.a = 4.0 / (h * (1 + 4 * d));\n    this.b = (4.0 * d) / (1 + 4 * d);\n    this.epsilon = 4.0 / (h * h * k * (1 + 4 * d));\n\n    this.needsUpdate = false;\n};\n\n/**\n * Multiply a jacobian entry with corresponding positions or velocities\n * @method gmult\n * @return {Number}\n */\nEquation.prototype.gmult = function(G,vi,wi,vj,wj){\n    return  G[0] * vi[0] +\n            G[1] * vi[1] +\n            G[2] * wi +\n            G[3] * vj[0] +\n            G[4] * vj[1] +\n            G[5] * wj;\n};\n\n/**\n * Computes the RHS of the SPOOK equation\n * @method computeB\n * @return {Number}\n */\nEquation.prototype.computeB = function(a,b,h){\n    var GW = this.computeGW();\n    var Gq = this.computeGq();\n    var GiMf = this.computeGiMf();\n    return - Gq * a - GW * b - GiMf*h;\n};\n\n/**\n * Computes G\\*q, where q are the generalized body coordinates\n * @method computeGq\n * @return {Number}\n */\nvar qi = vec2.create(),\n    qj = vec2.create();\nEquation.prototype.computeGq = function(){\n    var G = this.G,\n        bi = this.bodyA,\n        bj = this.bodyB,\n        xi = bi.position,\n        xj = bj.position,\n        ai = bi.angle,\n        aj = bj.angle;\n\n    return this.gmult(G, qi, ai, qj, aj) + this.offset;\n};\n\n/**\n * Computes G\\*W, where W are the body velocities\n * @method computeGW\n * @return {Number}\n */\nEquation.prototype.computeGW = function(){\n    var G = this.G,\n        bi = this.bodyA,\n        bj = this.bodyB,\n        vi = bi.velocity,\n        vj = bj.velocity,\n        wi = bi.angularVelocity,\n        wj = bj.angularVelocity;\n    return this.gmult(G,vi,wi,vj,wj) + this.relativeVelocity;\n};\n\n/**\n * Computes G\\*Wlambda, where W are the body velocities\n * @method computeGWlambda\n * @return {Number}\n */\nEquation.prototype.computeGWlambda = function(){\n    var G = this.G,\n        bi = this.bodyA,\n        bj = this.bodyB,\n        vi = bi.vlambda,\n        vj = bj.vlambda,\n        wi = bi.wlambda,\n        wj = bj.wlambda;\n    return this.gmult(G,vi,wi,vj,wj);\n};\n\n/**\n * Computes G\\*inv(M)\\*f, where M is the mass matrix with diagonal blocks for each body, and f are the forces on the bodies.\n * @method computeGiMf\n * @return {Number}\n */\nvar iMfi = vec2.create(),\n    iMfj = vec2.create();\nEquation.prototype.computeGiMf = function(){\n    var bi = this.bodyA,\n        bj = this.bodyB,\n        fi = bi.force,\n        ti = bi.angularForce,\n        fj = bj.force,\n        tj = bj.angularForce,\n        invMassi = bi.invMassSolve,\n        invMassj = bj.invMassSolve,\n        invIi = bi.invInertiaSolve,\n        invIj = bj.invInertiaSolve,\n        G = this.G;\n\n    vec2.scale(iMfi, fi, invMassi);\n    vec2.multiply(iMfi, bi.massMultiplier, iMfi);\n    vec2.scale(iMfj, fj,invMassj);\n    vec2.multiply(iMfj, bj.massMultiplier, iMfj);\n\n    return this.gmult(G,iMfi,ti*invIi,iMfj,tj*invIj);\n};\n\n/**\n * Computes G\\*inv(M)\\*G'\n * @method computeGiMGt\n * @return {Number}\n */\nEquation.prototype.computeGiMGt = function(){\n    var bi = this.bodyA,\n        bj = this.bodyB,\n        invMassi = bi.invMassSolve,\n        invMassj = bj.invMassSolve,\n        invIi = bi.invInertiaSolve,\n        invIj = bj.invInertiaSolve,\n        G = this.G;\n\n    return  G[0] * G[0] * invMassi * bi.massMultiplier[0] +\n            G[1] * G[1] * invMassi * bi.massMultiplier[1] +\n            G[2] * G[2] *    invIi +\n            G[3] * G[3] * invMassj * bj.massMultiplier[0] +\n            G[4] * G[4] * invMassj * bj.massMultiplier[1] +\n            G[5] * G[5] *    invIj;\n};\n\nvar addToWlambda_temp = vec2.create(),\n    addToWlambda_Gi = vec2.create(),\n    addToWlambda_Gj = vec2.create(),\n    addToWlambda_ri = vec2.create(),\n    addToWlambda_rj = vec2.create(),\n    addToWlambda_Mdiag = vec2.create();\n\n/**\n * Add constraint velocity to the bodies.\n * @method addToWlambda\n * @param {Number} deltalambda\n */\nEquation.prototype.addToWlambda = function(deltalambda){\n    var bi = this.bodyA,\n        bj = this.bodyB,\n        temp = addToWlambda_temp,\n        Gi = addToWlambda_Gi,\n        Gj = addToWlambda_Gj,\n        ri = addToWlambda_ri,\n        rj = addToWlambda_rj,\n        invMassi = bi.invMassSolve,\n        invMassj = bj.invMassSolve,\n        invIi = bi.invInertiaSolve,\n        invIj = bj.invInertiaSolve,\n        Mdiag = addToWlambda_Mdiag,\n        G = this.G;\n\n    Gi[0] = G[0];\n    Gi[1] = G[1];\n    Gj[0] = G[3];\n    Gj[1] = G[4];\n\n    // Add to linear velocity\n    // v_lambda += inv(M) * delta_lamba * G\n    vec2.scale(temp, Gi, invMassi*deltalambda);\n    vec2.multiply(temp, temp, bi.massMultiplier);\n    vec2.add( bi.vlambda, bi.vlambda, temp);\n    // This impulse is in the offset frame\n    // Also add contribution to angular\n    //bi.wlambda -= vec2.crossLength(temp,ri);\n    bi.wlambda += invIi * G[2] * deltalambda;\n\n\n    vec2.scale(temp, Gj, invMassj*deltalambda);\n    vec2.multiply(temp, temp, bj.massMultiplier);\n    vec2.add( bj.vlambda, bj.vlambda, temp);\n    //bj.wlambda -= vec2.crossLength(temp,rj);\n    bj.wlambda += invIj * G[5] * deltalambda;\n};\n\n/**\n * Compute the denominator part of the SPOOK equation: C = G\\*inv(M)\\*G' + eps\n * @method computeInvC\n * @param  {Number} eps\n * @return {Number}\n */\nEquation.prototype.computeInvC = function(eps){\n    return 1.0 / (this.computeGiMGt() + eps);\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///2\n");

/***/ }),
/* 3 */
/* no static exports found */
/* all exports used */
/*!**********************************!*\
  !*** ./~/p2/src/shapes/Shape.js ***!
  \**********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("module.exports = Shape;\n\nvar vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\n/**\n * Base class for shapes.\n * @class Shape\n * @constructor\n * @param {object} [options]\n * @param {array} [options.position]\n * @param {number} [options.angle=0]\n * @param {number} [options.collisionGroup=1]\n * @param {number} [options.collisionMask=1]\n * @param {boolean} [options.sensor=false]\n * @param {boolean} [options.collisionResponse=true]\n * @param {object} [options.type=0]\n */\nfunction Shape(options){\n    options = options || {};\n\n    /**\n     * The body this shape is attached to. A shape can only be attached to a single body.\n     * @property {Body} body\n     */\n    this.body = null;\n\n    /**\n     * Body-local position of the shape.\n     * @property {Array} position\n     */\n    this.position = vec2.fromValues(0,0);\n    if(options.position){\n        vec2.copy(this.position, options.position);\n    }\n\n    /**\n     * Body-local angle of the shape.\n     * @property {number} angle\n     */\n    this.angle = options.angle || 0;\n\n    /**\n     * The type of the shape. One of:\n     *\n     * * {{#crossLink \"Shape/CIRCLE:property\"}}Shape.CIRCLE{{/crossLink}}\n     * * {{#crossLink \"Shape/PARTICLE:property\"}}Shape.PARTICLE{{/crossLink}}\n     * * {{#crossLink \"Shape/PLANE:property\"}}Shape.PLANE{{/crossLink}}\n     * * {{#crossLink \"Shape/CONVEX:property\"}}Shape.CONVEX{{/crossLink}}\n     * * {{#crossLink \"Shape/LINE:property\"}}Shape.LINE{{/crossLink}}\n     * * {{#crossLink \"Shape/BOX:property\"}}Shape.BOX{{/crossLink}}\n     * * {{#crossLink \"Shape/CAPSULE:property\"}}Shape.CAPSULE{{/crossLink}}\n     * * {{#crossLink \"Shape/HEIGHTFIELD:property\"}}Shape.HEIGHTFIELD{{/crossLink}}\n     *\n     * @property {number} type\n     */\n    this.type = options.type || 0;\n\n    /**\n     * Shape object identifier.\n     * @type {Number}\n     * @property id\n     */\n    this.id = Shape.idCounter++;\n\n    /**\n     * Bounding circle radius of this shape\n     * @property boundingRadius\n     * @type {Number}\n     */\n    this.boundingRadius = 0;\n\n    /**\n     * Collision group that this shape belongs to (bit mask). See <a href=\"http://www.aurelienribon.com/blog/2011/07/box2d-tutorial-collision-filtering/\">this tutorial</a>.\n     * @property collisionGroup\n     * @type {Number}\n     * @example\n     *     // Setup bits for each available group\n     *     var PLAYER = Math.pow(2,0),\n     *         ENEMY =  Math.pow(2,1),\n     *         GROUND = Math.pow(2,2)\n     *\n     *     // Put shapes into their groups\n     *     player1Shape.collisionGroup = PLAYER;\n     *     player2Shape.collisionGroup = PLAYER;\n     *     enemyShape  .collisionGroup = ENEMY;\n     *     groundShape .collisionGroup = GROUND;\n     *\n     *     // Assign groups that each shape collide with.\n     *     // Note that the players can collide with ground and enemies, but not with other players.\n     *     player1Shape.collisionMask = ENEMY | GROUND;\n     *     player2Shape.collisionMask = ENEMY | GROUND;\n     *     enemyShape  .collisionMask = PLAYER | GROUND;\n     *     groundShape .collisionMask = PLAYER | ENEMY;\n     *\n     * @example\n     *     // How collision check is done\n     *     if(shapeA.collisionGroup & shapeB.collisionMask)!=0 && (shapeB.collisionGroup & shapeA.collisionMask)!=0){\n     *         // The shapes will collide\n     *     }\n     */\n    this.collisionGroup = options.collisionGroup !== undefined ? options.collisionGroup : 1;\n\n    /**\n     * Whether to produce contact forces when in contact with other bodies. Note that contacts will be generated, but they will be disabled. That means that this shape will move through other body shapes, but it will still trigger contact events, etc.\n     * @property {Boolean} collisionResponse\n     */\n    this.collisionResponse = options.collisionResponse !== undefined ? options.collisionResponse : true;\n\n    /**\n     * Collision mask of this shape. See .collisionGroup.\n     * @property collisionMask\n     * @type {Number}\n     */\n    this.collisionMask = options.collisionMask !== undefined ? options.collisionMask : 1;\n\n    /**\n     * Material to use in collisions for this Shape. If this is set to null, the world will use default material properties instead.\n     * @property material\n     * @type {Material}\n     */\n    this.material = options.material || null;\n\n    /**\n     * Area of this shape.\n     * @property area\n     * @type {Number}\n     */\n    this.area = 0;\n\n    /**\n     * Set to true if you want this shape to be a sensor. A sensor does not generate contacts, but it still reports contact events. This is good if you want to know if a shape is overlapping another shape, without them generating contacts.\n     * @property {Boolean} sensor\n     */\n    this.sensor = options.sensor !== undefined ? options.sensor : false;\n\n    if(this.type){\n        this.updateBoundingRadius();\n    }\n\n    this.updateArea();\n}\n\nShape.idCounter = 0;\n\n/**\n * @static\n * @property {Number} CIRCLE\n */\nShape.CIRCLE =      1;\n\n/**\n * @static\n * @property {Number} PARTICLE\n */\nShape.PARTICLE =    2;\n\n/**\n * @static\n * @property {Number} PLANE\n */\nShape.PLANE =       4;\n\n/**\n * @static\n * @property {Number} CONVEX\n */\nShape.CONVEX =      8;\n\n/**\n * @static\n * @property {Number} LINE\n */\nShape.LINE =        16;\n\n/**\n * @static\n * @property {Number} BOX\n */\nShape.BOX =   32;\n\nObject.defineProperty(Shape, 'RECTANGLE', {\n    get: function() {\n        console.warn('Shape.RECTANGLE is deprecated, use Shape.BOX instead.');\n        return Shape.BOX;\n    }\n});\n\n/**\n * @static\n * @property {Number} CAPSULE\n */\nShape.CAPSULE =     64;\n\n/**\n * @static\n * @property {Number} HEIGHTFIELD\n */\nShape.HEIGHTFIELD = 128;\n\n/**\n * Should return the moment of inertia around the Z axis of the body given the total mass. See <a href=\"http://en.wikipedia.org/wiki/List_of_moments_of_inertia\">Wikipedia's list of moments of inertia</a>.\n * @method computeMomentOfInertia\n * @param  {Number} mass\n * @return {Number} If the inertia is infinity or if the object simply isn't possible to rotate, return 0.\n */\nShape.prototype.computeMomentOfInertia = function(mass){};\n\n/**\n * Returns the bounding circle radius of this shape.\n * @method updateBoundingRadius\n * @return {Number}\n */\nShape.prototype.updateBoundingRadius = function(){};\n\n/**\n * Update the .area property of the shape.\n * @method updateArea\n */\nShape.prototype.updateArea = function(){\n    // To be implemented in all subclasses\n};\n\n/**\n * Compute the world axis-aligned bounding box (AABB) of this shape.\n * @method computeAABB\n * @param  {AABB} out The resulting AABB.\n * @param  {Array} position World position of the shape.\n * @param  {Number} angle World angle of the shape.\n */\nShape.prototype.computeAABB = function(out, position, angle){\n    // To be implemented in each subclass\n};\n\n/**\n * Perform raycasting on this shape.\n * @method raycast\n * @param  {RayResult} result Where to store the resulting data.\n * @param  {Ray} ray The Ray that you want to use for raycasting.\n * @param  {array} position World position of the shape (the .position property will be ignored).\n * @param  {number} angle World angle of the shape (the .angle property will be ignored).\n */\nShape.prototype.raycast = function(result, ray, position, angle){\n    // To be implemented in each subclass\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///3\n");

/***/ }),
/* 4 */
/* exports provided: default */
/* all exports used */
/*!**********************************!*\
  !*** ./src/js/LaserApiConfig.js ***!
  \**********************************/
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("Object.defineProperty(__webpack_exports__, \"__esModule\", { value: true });\nvar config = {\r\n    gameIndex: 0,\r\n    debugVideo: true,\r\n    testColor: [255, 32, 32],\r\n    gridResolution: 64,\r\n    playfieldScale: 1,\r\n    tickIntervalMilliseconds: 25,\r\n    videoResolution: {\r\n        width: 640,\r\n        height: 480\r\n    },\r\n    testResolution: {\r\n        width: 320,\r\n        height: 240\r\n    },\r\n    canvasResolution: {\r\n        width: 640,\r\n        height: 480\r\n    },\r\n    canvasOriginalResolution: {\r\n        width: 640,\r\n        height: 480\r\n    },\r\n    treshold: 120,\r\n\r\n    videoTransform: {\r\n        scale: 0,\r\n        rotate: 0,\r\n        skew: {\r\n            x: 0,\r\n            y: 0\r\n        },\r\n        translate: {\r\n            x: 0,\r\n            y: 0.5\r\n        }\r\n    },\r\n    transform: {\r\n        topleft: {\r\n            x: 0,\r\n            y: 0.5\r\n        },\r\n        topright: {\r\n            x: 1,\r\n            y: 0\r\n        },\r\n        bottomleft: {\r\n            x: 0,\r\n            y: 1\r\n        },\r\n        bottomright: {\r\n            x: 1,\r\n            y: 1\r\n        }\r\n\r\n    }\r\n\r\n};\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (config);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///4\n");

/***/ }),
/* 5 */
/* exports provided: default */
/* all exports used */
/*!********************************!*\
  !*** ./src/js/MasterCanvas.js ***!
  \********************************/
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("Object.defineProperty(__webpack_exports__, \"__esModule\", { value: true });\n// the main canvas is organized here\r\n\r\nvar laserConfig = __webpack_require__(/*! ./LaserApiConfig.js */ 4).default\r\nvar canvas = null\r\nvar context2d = null\r\nvar context3d = null\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\r\n    clear: function () {\r\n        context2d.beginPath();\r\n        context2d.rect(0, 0, laserConfig.canvasResolution.width, laserConfig.canvasResolution.height);\r\n        context2d.fillStyle = \"black\";\r\n        context2d.fill();\r\n    },\r\n    getCanvas: function () {\r\n        return canvas\r\n    },\r\n    get2dContext: function () {\r\n        return context2d\r\n    },\r\n    get3dContext: function () {\r\n        return context3d\r\n    },\r\n    init: function (canvasIn) {\r\n        canvas = canvasIn\r\n        canvas.width = laserConfig.canvasResolution.width\r\n        canvas.height = laserConfig.canvasResolution.height\r\n        console.log('Initialising from canvas DOM element', this)\r\n        console.log('Initialising from canvas DOM element', canvas)\r\n        context2d = canvas.getContext(\"2d\");\r\n        context3d = canvas.getContext(\"webgl\") || canvas.getContext(\"experimental-webgl\");\r\n\r\n    },\r\n\r\n});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///5\n");

/***/ }),
/* 6 */
/* no static exports found */
/* all exports used */
/*!********************************************!*\
  !*** ./~/p2/src/constraints/Constraint.js ***!
  \********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("module.exports = Constraint;\n\nvar Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\n/**\n * Base constraint class.\n *\n * @class Constraint\n * @constructor\n * @author schteppe\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {Number} type\n * @param {Object} [options]\n * @param {Object} [options.collideConnected=true]\n */\nfunction Constraint(bodyA, bodyB, type, options){\n\n    /**\n     * The type of constraint. May be one of Constraint.DISTANCE, Constraint.GEAR, Constraint.LOCK, Constraint.PRISMATIC or Constraint.REVOLUTE.\n     * @property {number} type\n     */\n    this.type = type;\n\n    options = Utils.defaults(options,{\n        collideConnected : true,\n        wakeUpBodies : true,\n    });\n\n    /**\n     * Equations to be solved in this constraint\n     *\n     * @property equations\n     * @type {Array}\n     */\n    this.equations = [];\n\n    /**\n     * First body participating in the constraint.\n     * @property bodyA\n     * @type {Body}\n     */\n    this.bodyA = bodyA;\n\n    /**\n     * Second body participating in the constraint.\n     * @property bodyB\n     * @type {Body}\n     */\n    this.bodyB = bodyB;\n\n    /**\n     * Set to true if you want the connected bodies to collide.\n     * @property collideConnected\n     * @type {Boolean}\n     * @default true\n     */\n    this.collideConnected = options.collideConnected;\n\n    // Wake up bodies when connected\n    if(options.wakeUpBodies){\n        if(bodyA){\n            bodyA.wakeUp();\n        }\n        if(bodyB){\n            bodyB.wakeUp();\n        }\n    }\n}\n\n/**\n * Updates the internal constraint parameters before solve.\n * @method update\n */\nConstraint.prototype.update = function(){\n    throw new Error(\"method update() not implmemented in this Constraint subclass!\");\n};\n\n/**\n * @static\n * @property {number} DISTANCE\n */\nConstraint.DISTANCE = 1;\n\n/**\n * @static\n * @property {number} GEAR\n */\nConstraint.GEAR = 2;\n\n/**\n * @static\n * @property {number} LOCK\n */\nConstraint.LOCK = 3;\n\n/**\n * @static\n * @property {number} PRISMATIC\n */\nConstraint.PRISMATIC = 4;\n\n/**\n * @static\n * @property {number} REVOLUTE\n */\nConstraint.REVOLUTE = 5;\n\n/**\n * Set stiffness for this constraint.\n * @method setStiffness\n * @param {Number} stiffness\n */\nConstraint.prototype.setStiffness = function(stiffness){\n    var eqs = this.equations;\n    for(var i=0; i !== eqs.length; i++){\n        var eq = eqs[i];\n        eq.stiffness = stiffness;\n        eq.needsUpdate = true;\n    }\n};\n\n/**\n * Set relaxation for this constraint.\n * @method setRelaxation\n * @param {Number} relaxation\n */\nConstraint.prototype.setRelaxation = function(relaxation){\n    var eqs = this.equations;\n    for(var i=0; i !== eqs.length; i++){\n        var eq = eqs[i];\n        eq.relaxation = relaxation;\n        eq.needsUpdate = true;\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///6\n");

/***/ }),
/* 7 */
/* no static exports found */
/* all exports used */
/*!**********************************!*\
  !*** ./~/p2/src/objects/Body.js ***!
  \**********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   decomp = __webpack_require__(/*! poly-decomp */ 50)\n,   Convex = __webpack_require__(/*! ../shapes/Convex */ 10)\n,   RaycastResult = __webpack_require__(/*! ../collision/RaycastResult */ 18)\n,   Ray = __webpack_require__(/*! ../collision/Ray */ 13)\n,   AABB = __webpack_require__(/*! ../collision/AABB */ 11)\n,   EventEmitter = __webpack_require__(/*! ../events/EventEmitter */ 15);\n\nmodule.exports = Body;\n\n/**\n * A rigid body. Has got a center of mass, position, velocity and a number of\n * shapes that are used for collisions.\n *\n * @class Body\n * @constructor\n * @extends EventEmitter\n * @param {Object} [options]\n * @param {Array} [options.force]\n * @param {Array} [options.position]\n * @param {Array} [options.velocity]\n * @param {Boolean} [options.allowSleep]\n * @param {Boolean} [options.collisionResponse]\n * @param {Number} [options.angle=0]\n * @param {Number} [options.angularForce=0]\n * @param {Number} [options.angularVelocity=0]\n * @param {Number} [options.ccdIterations=10]\n * @param {Number} [options.ccdSpeedThreshold=-1]\n * @param {Number} [options.fixedRotation=false]\n * @param {Number} [options.gravityScale]\n * @param {Number} [options.id]\n * @param {Number} [options.mass=0] A number >= 0. If zero, the .type will be set to Body.STATIC.\n * @param {Number} [options.sleepSpeedLimit]\n * @param {Number} [options.sleepTimeLimit]\n *\n * @example\n *\n *     // Create a typical dynamic body\n *     var body = new Body({\n *         mass: 1,\n *         position: [0, 0],\n *         angle: 0,\n *         velocity: [0, 0],\n *         angularVelocity: 0\n *     });\n *\n *     // Add a circular shape to the body\n *     body.addShape(new Circle({ radius: 1 }));\n *\n *     // Add the body to the world\n *     world.addBody(body);\n */\nfunction Body(options){\n    options = options || {};\n\n    EventEmitter.call(this);\n\n    /**\n     * The body identifyer\n     * @property id\n     * @type {Number}\n     */\n    this.id = options.id || ++Body._idCounter;\n\n    /**\n     * The world that this body is added to. This property is set to NULL if the body is not added to any world.\n     * @property world\n     * @type {World}\n     */\n    this.world = null;\n\n    /**\n     * The shapes of the body.\n     *\n     * @property shapes\n     * @type {Array}\n     */\n    this.shapes = [];\n\n    /**\n     * The mass of the body.\n     * @property mass\n     * @type {number}\n     */\n    this.mass = options.mass || 0;\n\n    /**\n     * The inverse mass of the body.\n     * @property invMass\n     * @type {number}\n     */\n    this.invMass = 0;\n\n    /**\n     * The inertia of the body around the Z axis.\n     * @property inertia\n     * @type {number}\n     */\n    this.inertia = 0;\n\n    /**\n     * The inverse inertia of the body.\n     * @property invInertia\n     * @type {number}\n     */\n    this.invInertia = 0;\n\n    this.invMassSolve = 0;\n    this.invInertiaSolve = 0;\n\n    /**\n     * Set to true if you want to fix the rotation of the body.\n     * @property fixedRotation\n     * @type {Boolean}\n     */\n    this.fixedRotation = !!options.fixedRotation;\n\n    /**\n     * Set to true if you want to fix the body movement along the X axis. The body will still be able to move along Y.\n     * @property {Boolean} fixedX\n     */\n    this.fixedX = !!options.fixedX;\n\n    /**\n     * Set to true if you want to fix the body movement along the Y axis. The body will still be able to move along X.\n     * @property {Boolean} fixedY\n     */\n    this.fixedY = !!options.fixedY;\n\n    /**\n     * @private\n     * @property {array} massMultiplier\n     */\n    this.massMultiplier = vec2.create();\n\n    /**\n     * The position of the body\n     * @property position\n     * @type {Array}\n     */\n    this.position = vec2.fromValues(0,0);\n    if(options.position){\n        vec2.copy(this.position, options.position);\n    }\n\n    /**\n     * The interpolated position of the body. Use this for rendering.\n     * @property interpolatedPosition\n     * @type {Array}\n     */\n    this.interpolatedPosition = vec2.fromValues(0,0);\n\n    /**\n     * The interpolated angle of the body. Use this for rendering.\n     * @property interpolatedAngle\n     * @type {Number}\n     */\n    this.interpolatedAngle = 0;\n\n    /**\n     * The previous position of the body.\n     * @property previousPosition\n     * @type {Array}\n     */\n    this.previousPosition = vec2.fromValues(0,0);\n\n    /**\n     * The previous angle of the body.\n     * @property previousAngle\n     * @type {Number}\n     */\n    this.previousAngle = 0;\n\n    /**\n     * The current velocity of the body.\n     * @property velocity\n     * @type {Array}\n     */\n    this.velocity = vec2.fromValues(0,0);\n    if(options.velocity){\n        vec2.copy(this.velocity, options.velocity);\n    }\n\n    /**\n     * Constraint velocity that was added to the body during the last step.\n     * @property vlambda\n     * @type {Array}\n     */\n    this.vlambda = vec2.fromValues(0,0);\n\n    /**\n     * Angular constraint velocity that was added to the body during last step.\n     * @property wlambda\n     * @type {Array}\n     */\n    this.wlambda = 0;\n\n    /**\n     * The angle of the body, in radians.\n     * @property angle\n     * @type {number}\n     * @example\n     *     // The angle property is not normalized to the interval 0 to 2*pi, it can be any value.\n     *     // If you need a value between 0 and 2*pi, use the following function to normalize it.\n     *     function normalizeAngle(angle){\n     *         angle = angle % (2*Math.PI);\n     *         if(angle < 0){\n     *             angle += (2*Math.PI);\n     *         }\n     *         return angle;\n     *     }\n     */\n    this.angle = options.angle || 0;\n\n    /**\n     * The angular velocity of the body, in radians per second.\n     * @property angularVelocity\n     * @type {number}\n     */\n    this.angularVelocity = options.angularVelocity || 0;\n\n    /**\n     * The force acting on the body. Since the body force (and {{#crossLink \"Body/angularForce:property\"}}{{/crossLink}}) will be zeroed after each step, so you need to set the force before each step.\n     * @property force\n     * @type {Array}\n     *\n     * @example\n     *     // This produces a forcefield of 1 Newton in the positive x direction.\n     *     for(var i=0; i<numSteps; i++){\n     *         body.force[0] = 1;\n     *         world.step(1/60);\n     *     }\n     *\n     * @example\n     *     // This will apply a rotational force on the body\n     *     for(var i=0; i<numSteps; i++){\n     *         body.angularForce = -3;\n     *         world.step(1/60);\n     *     }\n     */\n    this.force = vec2.create();\n    if(options.force){\n        vec2.copy(this.force, options.force);\n    }\n\n    /**\n     * The angular force acting on the body. See {{#crossLink \"Body/force:property\"}}{{/crossLink}}.\n     * @property angularForce\n     * @type {number}\n     */\n    this.angularForce = options.angularForce || 0;\n\n    /**\n     * The linear damping acting on the body in the velocity direction. Should be a value between 0 and 1.\n     * @property damping\n     * @type {Number}\n     * @default 0.1\n     */\n    this.damping = typeof(options.damping) === \"number\" ? options.damping : 0.1;\n\n    /**\n     * The angular force acting on the body. Should be a value between 0 and 1.\n     * @property angularDamping\n     * @type {Number}\n     * @default 0.1\n     */\n    this.angularDamping = typeof(options.angularDamping) === \"number\" ? options.angularDamping : 0.1;\n\n    /**\n     * The type of motion this body has. Should be one of: {{#crossLink \"Body/STATIC:property\"}}Body.STATIC{{/crossLink}}, {{#crossLink \"Body/DYNAMIC:property\"}}Body.DYNAMIC{{/crossLink}} and {{#crossLink \"Body/KINEMATIC:property\"}}Body.KINEMATIC{{/crossLink}}.\n     *\n     * * Static bodies do not move, and they do not respond to forces or collision.\n     * * Dynamic bodies body can move and respond to collisions and forces.\n     * * Kinematic bodies only moves according to its .velocity, and does not respond to collisions or force.\n     *\n     * @property type\n     * @type {number}\n     *\n     * @example\n     *     // Bodies are static by default. Static bodies will never move.\n     *     var body = new Body();\n     *     console.log(body.type == Body.STATIC); // true\n     *\n     * @example\n     *     // By setting the mass of a body to a nonzero number, the body\n     *     // will become dynamic and will move and interact with other bodies.\n     *     var dynamicBody = new Body({\n     *         mass : 1\n     *     });\n     *     console.log(dynamicBody.type == Body.DYNAMIC); // true\n     *\n     * @example\n     *     // Kinematic bodies will only move if you change their velocity.\n     *     var kinematicBody = new Body({\n     *         type: Body.KINEMATIC // Type can be set via the options object.\n     *     });\n     */\n    this.type = Body.STATIC;\n\n    if(typeof(options.type) !== 'undefined'){\n        this.type = options.type;\n    } else if(!options.mass){\n        this.type = Body.STATIC;\n    } else {\n        this.type = Body.DYNAMIC;\n    }\n\n    /**\n     * Bounding circle radius.\n     * @property boundingRadius\n     * @type {Number}\n     */\n    this.boundingRadius = 0;\n\n    /**\n     * Bounding box of this body.\n     * @property aabb\n     * @type {AABB}\n     */\n    this.aabb = new AABB();\n\n    /**\n     * Indicates if the AABB needs update. Update it with {{#crossLink \"Body/updateAABB:method\"}}.updateAABB(){{/crossLink}}.\n     * @property aabbNeedsUpdate\n     * @type {Boolean}\n     * @see updateAABB\n     *\n     * @example\n     *     // Force update the AABB\n     *     body.aabbNeedsUpdate = true;\n     *     body.updateAABB();\n     *     console.log(body.aabbNeedsUpdate); // false\n     */\n    this.aabbNeedsUpdate = true;\n\n    /**\n     * If true, the body will automatically fall to sleep. Note that you need to enable sleeping in the {{#crossLink \"World\"}}{{/crossLink}} before anything will happen.\n     * @property allowSleep\n     * @type {Boolean}\n     * @default true\n     */\n    this.allowSleep = options.allowSleep !== undefined ? options.allowSleep : true;\n\n    this.wantsToSleep = false;\n\n    /**\n     * One of {{#crossLink \"Body/AWAKE:property\"}}Body.AWAKE{{/crossLink}}, {{#crossLink \"Body/SLEEPY:property\"}}Body.SLEEPY{{/crossLink}} and {{#crossLink \"Body/SLEEPING:property\"}}Body.SLEEPING{{/crossLink}}.\n     *\n     * The body is initially Body.AWAKE. If its velocity norm is below .sleepSpeedLimit, the sleepState will become Body.SLEEPY. If the body continues to be Body.SLEEPY for .sleepTimeLimit seconds, it will fall asleep (Body.SLEEPY).\n     *\n     * @property sleepState\n     * @type {Number}\n     * @default Body.AWAKE\n     */\n    this.sleepState = Body.AWAKE;\n\n    /**\n     * If the speed (the norm of the velocity) is smaller than this value, the body is considered sleepy.\n     * @property sleepSpeedLimit\n     * @type {Number}\n     * @default 0.2\n     */\n    this.sleepSpeedLimit = options.sleepSpeedLimit !== undefined ? options.sleepSpeedLimit : 0.2;\n\n    /**\n     * If the body has been sleepy for this sleepTimeLimit seconds, it is considered sleeping.\n     * @property sleepTimeLimit\n     * @type {Number}\n     * @default 1\n     */\n    this.sleepTimeLimit = options.sleepTimeLimit !== undefined ? options.sleepTimeLimit : 1;\n\n    /**\n     * Gravity scaling factor. If you want the body to ignore gravity, set this to zero. If you want to reverse gravity, set it to -1.\n     * @property {Number} gravityScale\n     * @default 1\n     */\n    this.gravityScale = options.gravityScale !== undefined ? options.gravityScale : 1;\n\n    /**\n     * Whether to produce contact forces when in contact with other bodies. Note that contacts will be generated, but they will be disabled. That means that this body will move through other bodies, but it will still trigger contact events, etc.\n     * @property {Boolean} collisionResponse\n     */\n    this.collisionResponse = options.collisionResponse !== undefined ? options.collisionResponse : true;\n\n    /**\n     * How long the body has been sleeping.\n     * @property {Number} idleTime\n     */\n    this.idleTime = 0;\n\n    /**\n     * The last time when the body went to SLEEPY state.\n     * @property {Number} timeLastSleepy\n     * @private\n     */\n    this.timeLastSleepy = 0;\n\n    /**\n     * If the body speed exceeds this threshold, CCD (continuous collision detection) will be enabled. Set it to a negative number to disable CCD completely for this body.\n     * @property {number} ccdSpeedThreshold\n     * @default -1\n     */\n    this.ccdSpeedThreshold = options.ccdSpeedThreshold !== undefined ? options.ccdSpeedThreshold : -1;\n\n    /**\n     * The number of iterations that should be used when searching for the time of impact during CCD. A larger number will assure that there's a small penetration on CCD collision, but a small number will give more performance.\n     * @property {number} ccdIterations\n     * @default 10\n     */\n    this.ccdIterations = options.ccdIterations !== undefined ? options.ccdIterations : 10;\n\n    this.concavePath = null;\n\n    this._wakeUpAfterNarrowphase = false;\n\n    this.updateMassProperties();\n}\nBody.prototype = new EventEmitter();\nBody.prototype.constructor = Body;\n\nBody._idCounter = 0;\n\n/**\n * @private\n * @method updateSolveMassProperties\n */\nBody.prototype.updateSolveMassProperties = function(){\n    if(this.sleepState === Body.SLEEPING || this.type === Body.KINEMATIC){\n        this.invMassSolve = 0;\n        this.invInertiaSolve = 0;\n    } else {\n        this.invMassSolve = this.invMass;\n        this.invInertiaSolve = this.invInertia;\n    }\n};\n\n/**\n * Set the total density of the body\n * @method setDensity\n * @param {number} density\n */\nBody.prototype.setDensity = function(density) {\n    var totalArea = this.getArea();\n    this.mass = totalArea * density;\n    this.updateMassProperties();\n};\n\n/**\n * Get the total area of all shapes in the body\n * @method getArea\n * @return {Number}\n */\nBody.prototype.getArea = function() {\n    var totalArea = 0;\n    for(var i=0; i<this.shapes.length; i++){\n        totalArea += this.shapes[i].area;\n    }\n    return totalArea;\n};\n\n/**\n * Get the AABB from the body. The AABB is updated if necessary.\n * @method getAABB\n * @return {AABB} The AABB instance (this.aabb)\n */\nBody.prototype.getAABB = function(){\n    if(this.aabbNeedsUpdate){\n        this.updateAABB();\n    }\n    return this.aabb;\n};\n\nvar shapeAABB = new AABB(),\n    tmp = vec2.create();\n\n/**\n * Updates the AABB of the Body, and set .aabbNeedsUpdate = false.\n * @method updateAABB\n */\nBody.prototype.updateAABB = function() {\n    var shapes = this.shapes,\n        N = shapes.length,\n        offset = tmp,\n        bodyAngle = this.angle;\n\n    for(var i=0; i!==N; i++){\n        var shape = shapes[i],\n            angle = shape.angle + bodyAngle;\n\n        // Get shape world offset\n        vec2.rotate(offset, shape.position, bodyAngle);\n        vec2.add(offset, offset, this.position);\n\n        // Get shape AABB\n        shape.computeAABB(shapeAABB, offset, angle);\n\n        if(i===0){\n            this.aabb.copy(shapeAABB);\n        } else {\n            this.aabb.extend(shapeAABB);\n        }\n    }\n\n    this.aabbNeedsUpdate = false;\n};\n\n/**\n * Update the bounding radius of the body (this.boundingRadius). Should be done if any of the shape dimensions or positions are changed.\n * @method updateBoundingRadius\n */\nBody.prototype.updateBoundingRadius = function(){\n    var shapes = this.shapes,\n        N = shapes.length,\n        radius = 0;\n\n    for(var i=0; i!==N; i++){\n        var shape = shapes[i],\n            offset = vec2.length(shape.position),\n            r = shape.boundingRadius;\n        if(offset + r > radius){\n            radius = offset + r;\n        }\n    }\n\n    this.boundingRadius = radius;\n};\n\n/**\n * Add a shape to the body. You can pass a local transform when adding a shape,\n * so that the shape gets an offset and angle relative to the body center of mass.\n * Will automatically update the mass properties and bounding radius.\n *\n * @method addShape\n * @param  {Shape}              shape\n * @param  {Array} [offset] Local body offset of the shape.\n * @param  {Number}             [angle]  Local body angle.\n *\n * @example\n *     var body = new Body(),\n *         shape = new Circle({ radius: 1 });\n *\n *     // Add the shape to the body, positioned in the center\n *     body.addShape(shape);\n *\n *     // Add another shape to the body, positioned 1 unit length from the body center of mass along the local x-axis.\n *     body.addShape(shape,[1,0]);\n *\n *     // Add another shape to the body, positioned 1 unit length from the body center of mass along the local y-axis, and rotated 90 degrees CCW.\n *     body.addShape(shape,[0,1],Math.PI/2);\n */\nBody.prototype.addShape = function(shape, offset, angle){\n    if(shape.body){\n        throw new Error('A shape can only be added to one body.');\n    }\n    shape.body = this;\n\n    // Copy the offset vector\n    if(offset){\n        vec2.copy(shape.position, offset);\n    } else {\n        vec2.set(shape.position, 0, 0);\n    }\n\n    shape.angle = angle || 0;\n\n    this.shapes.push(shape);\n    this.updateMassProperties();\n    this.updateBoundingRadius();\n\n    this.aabbNeedsUpdate = true;\n};\n\n/**\n * Remove a shape\n * @method removeShape\n * @param  {Shape} shape\n * @return {Boolean} True if the shape was found and removed, else false.\n */\nBody.prototype.removeShape = function(shape){\n    var idx = this.shapes.indexOf(shape);\n\n    if(idx !== -1){\n        this.shapes.splice(idx,1);\n        this.aabbNeedsUpdate = true;\n        shape.body = null;\n        return true;\n    } else {\n        return false;\n    }\n};\n\n/**\n * Updates .inertia, .invMass, .invInertia for this Body. Should be called when\n * changing the structure or mass of the Body.\n *\n * @method updateMassProperties\n *\n * @example\n *     body.mass += 1;\n *     body.updateMassProperties();\n */\nBody.prototype.updateMassProperties = function(){\n    if(this.type === Body.STATIC || this.type === Body.KINEMATIC){\n\n        this.mass = Number.MAX_VALUE;\n        this.invMass = 0;\n        this.inertia = Number.MAX_VALUE;\n        this.invInertia = 0;\n\n    } else {\n\n        var shapes = this.shapes,\n            N = shapes.length,\n            m = this.mass / N,\n            I = 0;\n\n        if(!this.fixedRotation){\n            for(var i=0; i<N; i++){\n                var shape = shapes[i],\n                    r2 = vec2.squaredLength(shape.position),\n                    Icm = shape.computeMomentOfInertia(m);\n                I += Icm + m*r2;\n            }\n            this.inertia = I;\n            this.invInertia = I>0 ? 1/I : 0;\n\n        } else {\n            this.inertia = Number.MAX_VALUE;\n            this.invInertia = 0;\n        }\n\n        // Inverse mass properties are easy\n        this.invMass = 1 / this.mass;\n\n        vec2.set(\n            this.massMultiplier,\n            this.fixedX ? 0 : 1,\n            this.fixedY ? 0 : 1\n        );\n    }\n};\n\nvar Body_applyForce_r = vec2.create();\n\n/**\n * Apply force to a point relative to the center of mass of the body. This could for example be a point on the RigidBody surface. Applying force this way will add to Body.force and Body.angularForce. If relativePoint is zero, the force will be applied directly on the center of mass, and the torque produced will be zero.\n * @method applyForce\n * @param {Array} force The force to add.\n * @param {Array} [relativePoint] A world point to apply the force on.\n */\nBody.prototype.applyForce = function(force, relativePoint){\n\n    // Add linear force\n    vec2.add(this.force, this.force, force);\n\n    if(relativePoint){\n\n        // Compute produced rotational force\n        var rotForce = vec2.crossLength(relativePoint,force);\n\n        // Add rotational force\n        this.angularForce += rotForce;\n    }\n};\n\n/**\n * Apply force to a body-local point.\n * @method applyForceLocal\n * @param  {Array} localForce The force vector to add, oriented in local body space.\n * @param  {Array} [localPoint] A point relative to the body in world space. If not given, it is set to zero and all of the impulse will be excerted on the center of mass.\n */\nvar Body_applyForce_forceWorld = vec2.create();\nvar Body_applyForce_pointWorld = vec2.create();\nvar Body_applyForce_pointLocal = vec2.create();\nBody.prototype.applyForceLocal = function(localForce, localPoint){\n    localPoint = localPoint || Body_applyForce_pointLocal;\n    var worldForce = Body_applyForce_forceWorld;\n    var worldPoint = Body_applyForce_pointWorld;\n    this.vectorToWorldFrame(worldForce, localForce);\n    this.vectorToWorldFrame(worldPoint, localPoint);\n    this.applyForce(worldForce, worldPoint);\n};\n\n/**\n * Apply impulse to a point relative to the body. This could for example be a point on the Body surface. An impulse is a force added to a body during a short period of time (impulse = force * time). Impulses will be added to Body.velocity and Body.angularVelocity.\n * @method applyImpulse\n * @param  {Array} impulse The impulse vector to add, oriented in world space.\n * @param  {Array} [relativePoint] A point relative to the body in world space. If not given, it is set to zero and all of the impulse will be excerted on the center of mass.\n */\nvar Body_applyImpulse_velo = vec2.create();\nBody.prototype.applyImpulse = function(impulseVector, relativePoint){\n    if(this.type !== Body.DYNAMIC){\n        return;\n    }\n\n    // Compute produced central impulse velocity\n    var velo = Body_applyImpulse_velo;\n    vec2.scale(velo, impulseVector, this.invMass);\n    vec2.multiply(velo, this.massMultiplier, velo);\n\n    // Add linear impulse\n    vec2.add(this.velocity, velo, this.velocity);\n\n    if(relativePoint){\n        // Compute produced rotational impulse velocity\n        var rotVelo = vec2.crossLength(relativePoint, impulseVector);\n        rotVelo *= this.invInertia;\n\n        // Add rotational Impulse\n        this.angularVelocity += rotVelo;\n    }\n};\n\n/**\n * Apply impulse to a point relative to the body. This could for example be a point on the Body surface. An impulse is a force added to a body during a short period of time (impulse = force * time). Impulses will be added to Body.velocity and Body.angularVelocity.\n * @method applyImpulseLocal\n * @param  {Array} impulse The impulse vector to add, oriented in world space.\n * @param  {Array} [relativePoint] A point relative to the body in world space. If not given, it is set to zero and all of the impulse will be excerted on the center of mass.\n */\nvar Body_applyImpulse_impulseWorld = vec2.create();\nvar Body_applyImpulse_pointWorld = vec2.create();\nvar Body_applyImpulse_pointLocal = vec2.create();\nBody.prototype.applyImpulseLocal = function(localImpulse, localPoint){\n    localPoint = localPoint || Body_applyImpulse_pointLocal;\n    var worldImpulse = Body_applyImpulse_impulseWorld;\n    var worldPoint = Body_applyImpulse_pointWorld;\n    this.vectorToWorldFrame(worldImpulse, localImpulse);\n    this.vectorToWorldFrame(worldPoint, localPoint);\n    this.applyImpulse(worldImpulse, worldPoint);\n};\n\n/**\n * Transform a world point to local body frame.\n * @method toLocalFrame\n * @param  {Array} out          The vector to store the result in\n * @param  {Array} worldPoint   The input world point\n */\nBody.prototype.toLocalFrame = function(out, worldPoint){\n    vec2.toLocalFrame(out, worldPoint, this.position, this.angle);\n};\n\n/**\n * Transform a local point to world frame.\n * @method toWorldFrame\n * @param  {Array} out          The vector to store the result in\n * @param  {Array} localPoint   The input local point\n */\nBody.prototype.toWorldFrame = function(out, localPoint){\n    vec2.toGlobalFrame(out, localPoint, this.position, this.angle);\n};\n\n/**\n * Transform a world point to local body frame.\n * @method vectorToLocalFrame\n * @param  {Array} out          The vector to store the result in\n * @param  {Array} worldVector  The input world vector\n */\nBody.prototype.vectorToLocalFrame = function(out, worldVector){\n    vec2.vectorToLocalFrame(out, worldVector, this.angle);\n};\n\n/**\n * Transform a local point to world frame.\n * @method vectorToWorldFrame\n * @param  {Array} out          The vector to store the result in\n * @param  {Array} localVector  The input local vector\n */\nBody.prototype.vectorToWorldFrame = function(out, localVector){\n    vec2.vectorToGlobalFrame(out, localVector, this.angle);\n};\n\n/**\n * Reads a polygon shape path, and assembles convex shapes from that and puts them at proper offset points.\n * @method fromPolygon\n * @param {Array} path An array of 2d vectors, e.g. [[0,0],[0,1],...] that resembles a concave or convex polygon. The shape must be simple and without holes.\n * @param {Object} [options]\n * @param {Boolean} [options.optimalDecomp=false]   Set to true if you need optimal decomposition. Warning: very slow for polygons with more than 10 vertices.\n * @param {Boolean} [options.skipSimpleCheck=false] Set to true if you already know that the path is not intersecting itself.\n * @param {Boolean|Number} [options.removeCollinearPoints=false] Set to a number (angle threshold value) to remove collinear points, or false to keep all points.\n * @return {Boolean} True on success, else false.\n */\nBody.prototype.fromPolygon = function(path,options){\n    options = options || {};\n\n    // Remove all shapes\n    for(var i=this.shapes.length; i>=0; --i){\n        this.removeShape(this.shapes[i]);\n    }\n\n    var p = new decomp.Polygon();\n    p.vertices = path;\n\n    // Make it counter-clockwise\n    p.makeCCW();\n\n    if(typeof(options.removeCollinearPoints) === \"number\"){\n        p.removeCollinearPoints(options.removeCollinearPoints);\n    }\n\n    // Check if any line segment intersects the path itself\n    if(typeof(options.skipSimpleCheck) === \"undefined\"){\n        if(!p.isSimple()){\n            return false;\n        }\n    }\n\n    // Save this path for later\n    this.concavePath = p.vertices.slice(0);\n    for(var i=0; i<this.concavePath.length; i++){\n        var v = [0,0];\n        vec2.copy(v,this.concavePath[i]);\n        this.concavePath[i] = v;\n    }\n\n    // Slow or fast decomp?\n    var convexes;\n    if(options.optimalDecomp){\n        convexes = p.decomp();\n    } else {\n        convexes = p.quickDecomp();\n    }\n\n    var cm = vec2.create();\n\n    // Add convexes\n    for(var i=0; i!==convexes.length; i++){\n        // Create convex\n        var c = new Convex({ vertices: convexes[i].vertices });\n\n        // Move all vertices so its center of mass is in the local center of the convex\n        for(var j=0; j!==c.vertices.length; j++){\n            var v = c.vertices[j];\n            vec2.sub(v,v,c.centerOfMass);\n        }\n\n        vec2.scale(cm,c.centerOfMass,1);\n        c.updateTriangles();\n        c.updateCenterOfMass();\n        c.updateBoundingRadius();\n\n        // Add the shape\n        this.addShape(c,cm);\n    }\n\n    this.adjustCenterOfMass();\n\n    this.aabbNeedsUpdate = true;\n\n    return true;\n};\n\nvar adjustCenterOfMass_tmp1 = vec2.fromValues(0,0),\n    adjustCenterOfMass_tmp2 = vec2.fromValues(0,0),\n    adjustCenterOfMass_tmp3 = vec2.fromValues(0,0),\n    adjustCenterOfMass_tmp4 = vec2.fromValues(0,0);\n\n/**\n * Moves the shape offsets so their center of mass becomes the body center of mass.\n * @method adjustCenterOfMass\n */\nBody.prototype.adjustCenterOfMass = function(){\n    var offset_times_area = adjustCenterOfMass_tmp2,\n        sum =               adjustCenterOfMass_tmp3,\n        cm =                adjustCenterOfMass_tmp4,\n        totalArea =         0;\n    vec2.set(sum,0,0);\n\n    for(var i=0; i!==this.shapes.length; i++){\n        var s = this.shapes[i];\n        vec2.scale(offset_times_area, s.position, s.area);\n        vec2.add(sum, sum, offset_times_area);\n        totalArea += s.area;\n    }\n\n    vec2.scale(cm,sum,1/totalArea);\n\n    // Now move all shapes\n    for(var i=0; i!==this.shapes.length; i++){\n        var s = this.shapes[i];\n        vec2.sub(s.position, s.position, cm);\n    }\n\n    // Move the body position too\n    vec2.add(this.position,this.position,cm);\n\n    // And concave path\n    for(var i=0; this.concavePath && i<this.concavePath.length; i++){\n        vec2.sub(this.concavePath[i], this.concavePath[i], cm);\n    }\n\n    this.updateMassProperties();\n    this.updateBoundingRadius();\n};\n\n/**\n * Sets the force on the body to zero.\n * @method setZeroForce\n */\nBody.prototype.setZeroForce = function(){\n    vec2.set(this.force,0.0,0.0);\n    this.angularForce = 0.0;\n};\n\nBody.prototype.resetConstraintVelocity = function(){\n    var b = this,\n        vlambda = b.vlambda;\n    vec2.set(vlambda,0,0);\n    b.wlambda = 0;\n};\n\nBody.prototype.addConstraintVelocity = function(){\n    var b = this,\n        v = b.velocity;\n    vec2.add( v, v, b.vlambda);\n    b.angularVelocity += b.wlambda;\n};\n\n/**\n * Apply damping, see <a href=\"http://code.google.com/p/bullet/issues/detail?id=74\">this</a> for details.\n * @method applyDamping\n * @param  {number} dt Current time step\n */\nBody.prototype.applyDamping = function(dt){\n    if(this.type === Body.DYNAMIC){ // Only for dynamic bodies\n        var v = this.velocity;\n        vec2.scale(v, v, Math.pow(1.0 - this.damping,dt));\n        this.angularVelocity *= Math.pow(1.0 - this.angularDamping,dt);\n    }\n};\n\n/**\n * Wake the body up. Normally you should not need this, as the body is automatically awoken at events such as collisions.\n * Sets the sleepState to {{#crossLink \"Body/AWAKE:property\"}}Body.AWAKE{{/crossLink}} and emits the wakeUp event if the body wasn't awake before.\n * @method wakeUp\n */\nBody.prototype.wakeUp = function(){\n    var s = this.sleepState;\n    this.sleepState = Body.AWAKE;\n    this.idleTime = 0;\n    if(s !== Body.AWAKE){\n        this.emit(Body.wakeUpEvent);\n    }\n};\n\n/**\n * Force body sleep\n * @method sleep\n */\nBody.prototype.sleep = function(){\n    this.sleepState = Body.SLEEPING;\n    this.angularVelocity = 0;\n    this.angularForce = 0;\n    vec2.set(this.velocity,0,0);\n    vec2.set(this.force,0,0);\n    this.emit(Body.sleepEvent);\n};\n\n/**\n * Called every timestep to update internal sleep timer and change sleep state if needed.\n * @method sleepTick\n * @param {number} time The world time in seconds\n * @param {boolean} dontSleep\n * @param {number} dt\n */\nBody.prototype.sleepTick = function(time, dontSleep, dt){\n    if(!this.allowSleep || this.type === Body.SLEEPING){\n        return;\n    }\n\n    this.wantsToSleep = false;\n\n    var sleepState = this.sleepState,\n        speedSquared = vec2.squaredLength(this.velocity) + Math.pow(this.angularVelocity,2),\n        speedLimitSquared = Math.pow(this.sleepSpeedLimit,2);\n\n    // Add to idle time\n    if(speedSquared >= speedLimitSquared){\n        this.idleTime = 0;\n        this.sleepState = Body.AWAKE;\n    } else {\n        this.idleTime += dt;\n        this.sleepState = Body.SLEEPY;\n    }\n    if(this.idleTime > this.sleepTimeLimit){\n        if(!dontSleep){\n            this.sleep();\n        } else {\n            this.wantsToSleep = true;\n        }\n    }\n};\n\n/**\n * Check if the body is overlapping another body. Note that this method only works if the body was added to a World and if at least one step was taken.\n * @method overlaps\n * @param  {Body} body\n * @return {boolean}\n */\nBody.prototype.overlaps = function(body){\n    return this.world.overlapKeeper.bodiesAreOverlapping(this, body);\n};\n\nvar integrate_fhMinv = vec2.create();\nvar integrate_velodt = vec2.create();\n\n/**\n * Move the body forward in time given its current velocity.\n * @method integrate\n * @param  {Number} dt\n */\nBody.prototype.integrate = function(dt){\n    var minv = this.invMass,\n        f = this.force,\n        pos = this.position,\n        velo = this.velocity;\n\n    // Save old position\n    vec2.copy(this.previousPosition, this.position);\n    this.previousAngle = this.angle;\n\n    // Velocity update\n    if(!this.fixedRotation){\n        this.angularVelocity += this.angularForce * this.invInertia * dt;\n    }\n    vec2.scale(integrate_fhMinv, f, dt * minv);\n    vec2.multiply(integrate_fhMinv, this.massMultiplier, integrate_fhMinv);\n    vec2.add(velo, integrate_fhMinv, velo);\n\n    // CCD\n    if(!this.integrateToTimeOfImpact(dt)){\n\n        // Regular position update\n        vec2.scale(integrate_velodt, velo, dt);\n        vec2.add(pos, pos, integrate_velodt);\n        if(!this.fixedRotation){\n            this.angle += this.angularVelocity * dt;\n        }\n    }\n\n    this.aabbNeedsUpdate = true;\n};\n\nvar result = new RaycastResult();\nvar ray = new Ray({\n    mode: Ray.ALL\n});\nvar direction = vec2.create();\nvar end = vec2.create();\nvar startToEnd = vec2.create();\nvar rememberPosition = vec2.create();\nBody.prototype.integrateToTimeOfImpact = function(dt){\n\n    if(this.ccdSpeedThreshold < 0 || vec2.squaredLength(this.velocity) < Math.pow(this.ccdSpeedThreshold, 2)){\n        return false;\n    }\n\n    vec2.normalize(direction, this.velocity);\n\n    vec2.scale(end, this.velocity, dt);\n    vec2.add(end, end, this.position);\n\n    vec2.sub(startToEnd, end, this.position);\n    var startToEndAngle = this.angularVelocity * dt;\n    var len = vec2.length(startToEnd);\n\n    var timeOfImpact = 1;\n\n    var hit;\n    var that = this;\n    result.reset();\n    ray.callback = function (result) {\n        if(result.body === that){\n            return;\n        }\n        hit = result.body;\n        result.getHitPoint(end, ray);\n        vec2.sub(startToEnd, end, that.position);\n        timeOfImpact = vec2.length(startToEnd) / len;\n        result.stop();\n    };\n    vec2.copy(ray.from, this.position);\n    vec2.copy(ray.to, end);\n    ray.update();\n    this.world.raycast(result, ray);\n\n    if(!hit){\n        return false;\n    }\n\n    var rememberAngle = this.angle;\n    vec2.copy(rememberPosition, this.position);\n\n    // Got a start and end point. Approximate time of impact using binary search\n    var iter = 0;\n    var tmin = 0;\n    var tmid = 0;\n    var tmax = timeOfImpact;\n    while (tmax >= tmin && iter < this.ccdIterations) {\n        iter++;\n\n        // calculate the midpoint\n        tmid = (tmax - tmin) / 2;\n\n        // Move the body to that point\n        vec2.scale(integrate_velodt, startToEnd, timeOfImpact);\n        vec2.add(this.position, rememberPosition, integrate_velodt);\n        this.angle = rememberAngle + startToEndAngle * timeOfImpact;\n        this.updateAABB();\n\n        // check overlap\n        var overlaps = this.aabb.overlaps(hit.aabb) && this.world.narrowphase.bodiesOverlap(this, hit);\n\n        if (overlaps) {\n            // change min to search upper interval\n            tmin = tmid;\n        } else {\n            // change max to search lower interval\n            tmax = tmid;\n        }\n    }\n\n    timeOfImpact = tmid;\n\n    vec2.copy(this.position, rememberPosition);\n    this.angle = rememberAngle;\n\n    // move to TOI\n    vec2.scale(integrate_velodt, startToEnd, timeOfImpact);\n    vec2.add(this.position, this.position, integrate_velodt);\n    if(!this.fixedRotation){\n        this.angle += startToEndAngle * timeOfImpact;\n    }\n\n    return true;\n};\n\n/**\n * Get velocity of a point in the body.\n * @method getVelocityAtPoint\n * @param  {Array} result A vector to store the result in\n * @param  {Array} relativePoint A world oriented vector, indicating the position of the point to get the velocity from\n * @return {Array} The result vector\n */\nBody.prototype.getVelocityAtPoint = function(result, relativePoint){\n    vec2.crossVZ(result, relativePoint, this.angularVelocity);\n    vec2.subtract(result, this.velocity, result);\n    return result;\n};\n\n/**\n * @event sleepy\n */\nBody.sleepyEvent = {\n    type: \"sleepy\"\n};\n\n/**\n * @event sleep\n */\nBody.sleepEvent = {\n    type: \"sleep\"\n};\n\n/**\n * @event wakeup\n */\nBody.wakeUpEvent = {\n    type: \"wakeup\"\n};\n\n/**\n * Dynamic body.\n * @property DYNAMIC\n * @type {Number}\n * @static\n */\nBody.DYNAMIC = 1;\n\n/**\n * Static body.\n * @property STATIC\n * @type {Number}\n * @static\n */\nBody.STATIC = 2;\n\n/**\n * Kinematic body.\n * @property KINEMATIC\n * @type {Number}\n * @static\n */\nBody.KINEMATIC = 4;\n\n/**\n * @property AWAKE\n * @type {Number}\n * @static\n */\nBody.AWAKE = 0;\n\n/**\n * @property SLEEPY\n * @type {Number}\n * @static\n */\nBody.SLEEPY = 1;\n\n/**\n * @property SLEEPING\n * @type {Number}\n * @static\n */\nBody.SLEEPING = 2;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///7\n");

/***/ }),
/* 8 */
/* no static exports found */
/* all exports used */
/*!********************************!*\
  !*** ./~/p2/src/utils/Pool.js ***!
  \********************************/
/***/ (function(module, exports) {

eval("module.exports = Pool;\n\n/**\n * @class Object pooling utility.\n */\nfunction Pool(options) {\n\toptions = options || {};\n\n\t/**\n\t * @property {Array} objects\n\t * @type {Array}\n\t */\n\tthis.objects = [];\n\n\tif(options.size !== undefined){\n\t\tthis.resize(options.size);\n\t}\n}\n\n/**\n * @method resize\n * @param {number} size\n * @return {Pool} Self, for chaining\n */\nPool.prototype.resize = function (size) {\n\tvar objects = this.objects;\n\n\twhile (objects.length > size) {\n\t\tobjects.pop();\n\t}\n\n\twhile (objects.length < size) {\n\t\tobjects.push(this.create());\n\t}\n\n\treturn this;\n};\n\n/**\n * Get an object from the pool or create a new instance.\n * @method get\n * @return {Object}\n */\nPool.prototype.get = function () {\n\tvar objects = this.objects;\n\treturn objects.length ? objects.pop() : this.create();\n};\n\n/**\n * Clean up and put the object back into the pool for later use.\n * @method release\n * @param {Object} object\n * @return {Pool} Self for chaining\n */\nPool.prototype.release = function (object) {\n\tthis.destroy(object);\n\tthis.objects.push(object);\n\treturn this;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///8\n");

/***/ }),
/* 9 */
/* no static exports found */
/* all exports used */
/*!************************************************!*\
  !*** ./~/p2/src/equations/FrictionEquation.js ***!
  \************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   Equation = __webpack_require__(/*! ./Equation */ 2)\n,   Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\nmodule.exports = FrictionEquation;\n\n/**\n * Constrains the slipping in a contact along a tangent\n *\n * @class FrictionEquation\n * @constructor\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {Number} slipForce\n * @extends Equation\n */\nfunction FrictionEquation(bodyA, bodyB, slipForce){\n    Equation.call(this, bodyA, bodyB, -slipForce, slipForce);\n\n    /**\n     * Relative vector from center of body A to the contact point, world oriented.\n     * @property contactPointA\n     * @type {Array}\n     */\n    this.contactPointA = vec2.create();\n\n    /**\n     * Relative vector from center of body B to the contact point, world oriented.\n     * @property contactPointB\n     * @type {Array}\n     */\n    this.contactPointB = vec2.create();\n\n    /**\n     * Tangent vector that the friction force will act along. World oriented.\n     * @property t\n     * @type {Array}\n     */\n    this.t = vec2.create();\n\n    /**\n     * ContactEquations connected to this friction equation. The contact equations can be used to rescale the max force for the friction. If more than one contact equation is given, then the max force can be set to the average.\n     * @property contactEquations\n     * @type {ContactEquation}\n     */\n    this.contactEquations = [];\n\n    /**\n     * The shape in body i that triggered this friction.\n     * @property shapeA\n     * @type {Shape}\n     * @todo Needed? The shape can be looked up via contactEquation.shapeA...\n     */\n    this.shapeA = null;\n\n    /**\n     * The shape in body j that triggered this friction.\n     * @property shapeB\n     * @type {Shape}\n     * @todo Needed? The shape can be looked up via contactEquation.shapeB...\n     */\n    this.shapeB = null;\n\n    /**\n     * The friction coefficient to use.\n     * @property frictionCoefficient\n     * @type {Number}\n     */\n    this.frictionCoefficient = 0.3;\n}\nFrictionEquation.prototype = new Equation();\nFrictionEquation.prototype.constructor = FrictionEquation;\n\n/**\n * Set the slipping condition for the constraint. The friction force cannot be\n * larger than this value.\n * @method setSlipForce\n * @param  {Number} slipForce\n */\nFrictionEquation.prototype.setSlipForce = function(slipForce){\n    this.maxForce = slipForce;\n    this.minForce = -slipForce;\n};\n\n/**\n * Get the max force for the constraint.\n * @method getSlipForce\n * @return {Number}\n */\nFrictionEquation.prototype.getSlipForce = function(){\n    return this.maxForce;\n};\n\nFrictionEquation.prototype.computeB = function(a,b,h){\n    var bi = this.bodyA,\n        bj = this.bodyB,\n        ri = this.contactPointA,\n        rj = this.contactPointB,\n        t = this.t,\n        G = this.G;\n\n    // G = [-t -rixt t rjxt]\n    // And remember, this is a pure velocity constraint, g is always zero!\n    G[0] = -t[0];\n    G[1] = -t[1];\n    G[2] = -vec2.crossLength(ri,t);\n    G[3] = t[0];\n    G[4] = t[1];\n    G[5] = vec2.crossLength(rj,t);\n\n    var GW = this.computeGW(),\n        GiMf = this.computeGiMf();\n\n    var B = /* - g * a  */ - GW * b - h*GiMf;\n\n    return B;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///9\n");

/***/ }),
/* 10 */
/* no static exports found */
/* all exports used */
/*!***********************************!*\
  !*** ./~/p2/src/shapes/Convex.js ***!
  \***********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Shape = __webpack_require__(/*! ./Shape */ 3)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   polyk = __webpack_require__(/*! ../math/polyk */ 57)\n,   decomp = __webpack_require__(/*! poly-decomp */ 50);\n\nmodule.exports = Convex;\n\n/**\n * Convex shape class.\n * @class Convex\n * @constructor\n * @extends Shape\n * @param {object} [options] (Note that this options object will be passed on to the {{#crossLink \"Shape\"}}{{/crossLink}} constructor.)\n * @param {Array} [options.vertices] An array of vertices that span this shape. Vertices are given in counter-clockwise (CCW) direction.\n * @param {Array} [options.axes] An array of unit length vectors, representing the symmetry axes in the convex.\n * @example\n *     // Create a box\n *     var vertices = [[-1,-1], [1,-1], [1,1], [-1,1]];\n *     var convexShape = new Convex({ vertices: vertices });\n *     body.addShape(convexShape);\n */\nfunction Convex(options){\n    if(Array.isArray(arguments[0])){\n        options = {\n            vertices: arguments[0],\n            axes: arguments[1]\n        };\n        console.warn('The Convex constructor signature has changed. Please use the following format: new Convex({ vertices: [...], ... })');\n    }\n    options = options || {};\n\n    /**\n     * Vertices defined in the local frame.\n     * @property vertices\n     * @type {Array}\n     */\n    this.vertices = [];\n\n    // Copy the verts\n    var vertices = options.vertices !== undefined ? options.vertices : [];\n    for(var i=0; i < vertices.length; i++){\n        var v = vec2.create();\n        vec2.copy(v, vertices[i]);\n        this.vertices.push(v);\n    }\n\n    /**\n     * Axes defined in the local frame.\n     * @property axes\n     * @type {Array}\n     */\n    this.axes = [];\n\n    if(options.axes){\n\n        // Copy the axes\n        for(var i=0; i < options.axes.length; i++){\n            var axis = vec2.create();\n            vec2.copy(axis, options.axes[i]);\n            this.axes.push(axis);\n        }\n\n    } else {\n\n        // Construct axes from the vertex data\n        for(var i = 0; i < this.vertices.length; i++){\n            // Get the world edge\n            var worldPoint0 = this.vertices[i];\n            var worldPoint1 = this.vertices[(i+1) % this.vertices.length];\n\n            var normal = vec2.create();\n            vec2.sub(normal, worldPoint1, worldPoint0);\n\n            // Get normal - just rotate 90 degrees since vertices are given in CCW\n            vec2.rotate90cw(normal, normal);\n            vec2.normalize(normal, normal);\n\n            this.axes.push(normal);\n        }\n\n    }\n\n    /**\n     * The center of mass of the Convex\n     * @property centerOfMass\n     * @type {Array}\n     */\n    this.centerOfMass = vec2.fromValues(0,0);\n\n    /**\n     * Triangulated version of this convex. The structure is Array of 3-Arrays, and each subarray contains 3 integers, referencing the vertices.\n     * @property triangles\n     * @type {Array}\n     */\n    this.triangles = [];\n\n    if(this.vertices.length){\n        this.updateTriangles();\n        this.updateCenterOfMass();\n    }\n\n    /**\n     * The bounding radius of the convex\n     * @property boundingRadius\n     * @type {Number}\n     */\n    this.boundingRadius = 0;\n\n    options.type = Shape.CONVEX;\n    Shape.call(this, options);\n\n    this.updateBoundingRadius();\n    this.updateArea();\n    if(this.area < 0){\n        throw new Error(\"Convex vertices must be given in conter-clockwise winding.\");\n    }\n}\nConvex.prototype = new Shape();\nConvex.prototype.constructor = Convex;\n\nvar tmpVec1 = vec2.create();\nvar tmpVec2 = vec2.create();\n\n/**\n * Project a Convex onto a world-oriented axis\n * @method projectOntoAxis\n * @static\n * @param  {Array} offset\n * @param  {Array} localAxis\n * @param  {Array} result\n */\nConvex.prototype.projectOntoLocalAxis = function(localAxis, result){\n    var max=null,\n        min=null,\n        v,\n        value,\n        localAxis = tmpVec1;\n\n    // Get projected position of all vertices\n    for(var i=0; i<this.vertices.length; i++){\n        v = this.vertices[i];\n        value = vec2.dot(v, localAxis);\n        if(max === null || value > max){\n            max = value;\n        }\n        if(min === null || value < min){\n            min = value;\n        }\n    }\n\n    if(min > max){\n        var t = min;\n        min = max;\n        max = t;\n    }\n\n    vec2.set(result, min, max);\n};\n\nConvex.prototype.projectOntoWorldAxis = function(localAxis, shapeOffset, shapeAngle, result){\n    var worldAxis = tmpVec2;\n\n    this.projectOntoLocalAxis(localAxis, result);\n\n    // Project the position of the body onto the axis - need to add this to the result\n    if(shapeAngle !== 0){\n        vec2.rotate(worldAxis, localAxis, shapeAngle);\n    } else {\n        worldAxis = localAxis;\n    }\n    var offset = vec2.dot(shapeOffset, worldAxis);\n\n    vec2.set(result, result[0] + offset, result[1] + offset);\n};\n\n\n/**\n * Update the .triangles property\n * @method updateTriangles\n */\nConvex.prototype.updateTriangles = function(){\n\n    this.triangles.length = 0;\n\n    // Rewrite on polyk notation, array of numbers\n    var polykVerts = [];\n    for(var i=0; i<this.vertices.length; i++){\n        var v = this.vertices[i];\n        polykVerts.push(v[0],v[1]);\n    }\n\n    // Triangulate\n    var triangles = polyk.Triangulate(polykVerts);\n\n    // Loop over all triangles, add their inertia contributions to I\n    for(var i=0; i<triangles.length; i+=3){\n        var id1 = triangles[i],\n            id2 = triangles[i+1],\n            id3 = triangles[i+2];\n\n        // Add to triangles\n        this.triangles.push([id1,id2,id3]);\n    }\n};\n\nvar updateCenterOfMass_centroid = vec2.create(),\n    updateCenterOfMass_centroid_times_mass = vec2.create(),\n    updateCenterOfMass_a = vec2.create(),\n    updateCenterOfMass_b = vec2.create(),\n    updateCenterOfMass_c = vec2.create(),\n    updateCenterOfMass_ac = vec2.create(),\n    updateCenterOfMass_ca = vec2.create(),\n    updateCenterOfMass_cb = vec2.create(),\n    updateCenterOfMass_n = vec2.create();\n\n/**\n * Update the .centerOfMass property.\n * @method updateCenterOfMass\n */\nConvex.prototype.updateCenterOfMass = function(){\n    var triangles = this.triangles,\n        verts = this.vertices,\n        cm = this.centerOfMass,\n        centroid = updateCenterOfMass_centroid,\n        n = updateCenterOfMass_n,\n        a = updateCenterOfMass_a,\n        b = updateCenterOfMass_b,\n        c = updateCenterOfMass_c,\n        ac = updateCenterOfMass_ac,\n        ca = updateCenterOfMass_ca,\n        cb = updateCenterOfMass_cb,\n        centroid_times_mass = updateCenterOfMass_centroid_times_mass;\n\n    vec2.set(cm,0,0);\n    var totalArea = 0;\n\n    for(var i=0; i!==triangles.length; i++){\n        var t = triangles[i],\n            a = verts[t[0]],\n            b = verts[t[1]],\n            c = verts[t[2]];\n\n        vec2.centroid(centroid,a,b,c);\n\n        // Get mass for the triangle (density=1 in this case)\n        // http://math.stackexchange.com/questions/80198/area-of-triangle-via-vectors\n        var m = Convex.triangleArea(a,b,c);\n        totalArea += m;\n\n        // Add to center of mass\n        vec2.scale(centroid_times_mass, centroid, m);\n        vec2.add(cm, cm, centroid_times_mass);\n    }\n\n    vec2.scale(cm,cm,1/totalArea);\n};\n\n/**\n * Compute the mass moment of inertia of the Convex.\n * @method computeMomentOfInertia\n * @param  {Number} mass\n * @return {Number}\n * @see http://www.gamedev.net/topic/342822-moment-of-inertia-of-a-polygon-2d/\n */\nConvex.prototype.computeMomentOfInertia = function(mass){\n    var denom = 0.0,\n        numer = 0.0,\n        N = this.vertices.length;\n    for(var j = N-1, i = 0; i < N; j = i, i ++){\n        var p0 = this.vertices[j];\n        var p1 = this.vertices[i];\n        var a = Math.abs(vec2.crossLength(p0,p1));\n        var b = vec2.dot(p1,p1) + vec2.dot(p1,p0) + vec2.dot(p0,p0);\n        denom += a * b;\n        numer += a;\n    }\n    return (mass / 6.0) * (denom / numer);\n};\n\n/**\n * Updates the .boundingRadius property\n * @method updateBoundingRadius\n */\nConvex.prototype.updateBoundingRadius = function(){\n    var verts = this.vertices,\n        r2 = 0;\n\n    for(var i=0; i!==verts.length; i++){\n        var l2 = vec2.squaredLength(verts[i]);\n        if(l2 > r2){\n            r2 = l2;\n        }\n    }\n\n    this.boundingRadius = Math.sqrt(r2);\n};\n\n/**\n * Get the area of the triangle spanned by the three points a, b, c. The area is positive if the points are given in counter-clockwise order, otherwise negative.\n * @static\n * @method triangleArea\n * @param {Array} a\n * @param {Array} b\n * @param {Array} c\n * @return {Number}\n */\nConvex.triangleArea = function(a,b,c){\n    return (((b[0] - a[0])*(c[1] - a[1]))-((c[0] - a[0])*(b[1] - a[1]))) * 0.5;\n};\n\n/**\n * Update the .area\n * @method updateArea\n */\nConvex.prototype.updateArea = function(){\n    this.updateTriangles();\n    this.area = 0;\n\n    var triangles = this.triangles,\n        verts = this.vertices;\n    for(var i=0; i!==triangles.length; i++){\n        var t = triangles[i],\n            a = verts[t[0]],\n            b = verts[t[1]],\n            c = verts[t[2]];\n\n        // Get mass for the triangle (density=1 in this case)\n        var m = Convex.triangleArea(a,b,c);\n        this.area += m;\n    }\n};\n\n/**\n * @method computeAABB\n * @param  {AABB}   out\n * @param  {Array}  position\n * @param  {Number} angle\n */\nConvex.prototype.computeAABB = function(out, position, angle){\n    out.setFromPoints(this.vertices, position, angle, 0);\n};\n\nvar intersectConvex_rayStart = vec2.create();\nvar intersectConvex_rayEnd = vec2.create();\nvar intersectConvex_normal = vec2.create();\n\n/**\n * @method raycast\n * @param  {RaycastResult} result\n * @param  {Ray} ray\n * @param  {array} position\n * @param  {number} angle\n */\nConvex.prototype.raycast = function(result, ray, position, angle){\n    var rayStart = intersectConvex_rayStart;\n    var rayEnd = intersectConvex_rayEnd;\n    var normal = intersectConvex_normal;\n    var vertices = this.vertices;\n\n    // Transform to local shape space\n    vec2.toLocalFrame(rayStart, ray.from, position, angle);\n    vec2.toLocalFrame(rayEnd, ray.to, position, angle);\n\n    var n = vertices.length;\n\n    for (var i = 0; i < n && !result.shouldStop(ray); i++) {\n        var q1 = vertices[i];\n        var q2 = vertices[(i+1) % n];\n        var delta = vec2.getLineSegmentsIntersectionFraction(rayStart, rayEnd, q1, q2);\n\n        if(delta >= 0){\n            vec2.sub(normal, q2, q1);\n            vec2.rotate(normal, normal, -Math.PI / 2 + angle);\n            vec2.normalize(normal, normal);\n            ray.reportIntersection(result, delta, normal, i);\n        }\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTAuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy9zaGFwZXMvQ29udmV4LmpzPzA1ODkiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIFNoYXBlID0gcmVxdWlyZSgnLi9TaGFwZScpXG4sICAgdmVjMiA9IHJlcXVpcmUoJy4uL21hdGgvdmVjMicpXG4sICAgcG9seWsgPSByZXF1aXJlKCcuLi9tYXRoL3BvbHlrJylcbiwgICBkZWNvbXAgPSByZXF1aXJlKCdwb2x5LWRlY29tcCcpO1xuXG5tb2R1bGUuZXhwb3J0cyA9IENvbnZleDtcblxuLyoqXG4gKiBDb252ZXggc2hhcGUgY2xhc3MuXG4gKiBAY2xhc3MgQ29udmV4XG4gKiBAY29uc3RydWN0b3JcbiAqIEBleHRlbmRzIFNoYXBlXG4gKiBAcGFyYW0ge29iamVjdH0gW29wdGlvbnNdIChOb3RlIHRoYXQgdGhpcyBvcHRpb25zIG9iamVjdCB3aWxsIGJlIHBhc3NlZCBvbiB0byB0aGUge3sjY3Jvc3NMaW5rIFwiU2hhcGVcIn19e3svY3Jvc3NMaW5rfX0gY29uc3RydWN0b3IuKVxuICogQHBhcmFtIHtBcnJheX0gW29wdGlvbnMudmVydGljZXNdIEFuIGFycmF5IG9mIHZlcnRpY2VzIHRoYXQgc3BhbiB0aGlzIHNoYXBlLiBWZXJ0aWNlcyBhcmUgZ2l2ZW4gaW4gY291bnRlci1jbG9ja3dpc2UgKENDVykgZGlyZWN0aW9uLlxuICogQHBhcmFtIHtBcnJheX0gW29wdGlvbnMuYXhlc10gQW4gYXJyYXkgb2YgdW5pdCBsZW5ndGggdmVjdG9ycywgcmVwcmVzZW50aW5nIHRoZSBzeW1tZXRyeSBheGVzIGluIHRoZSBjb252ZXguXG4gKiBAZXhhbXBsZVxuICogICAgIC8vIENyZWF0ZSBhIGJveFxuICogICAgIHZhciB2ZXJ0aWNlcyA9IFtbLTEsLTFdLCBbMSwtMV0sIFsxLDFdLCBbLTEsMV1dO1xuICogICAgIHZhciBjb252ZXhTaGFwZSA9IG5ldyBDb252ZXgoeyB2ZXJ0aWNlczogdmVydGljZXMgfSk7XG4gKiAgICAgYm9keS5hZGRTaGFwZShjb252ZXhTaGFwZSk7XG4gKi9cbmZ1bmN0aW9uIENvbnZleChvcHRpb25zKXtcbiAgICBpZihBcnJheS5pc0FycmF5KGFyZ3VtZW50c1swXSkpe1xuICAgICAgICBvcHRpb25zID0ge1xuICAgICAgICAgICAgdmVydGljZXM6IGFyZ3VtZW50c1swXSxcbiAgICAgICAgICAgIGF4ZXM6IGFyZ3VtZW50c1sxXVxuICAgICAgICB9O1xuICAgICAgICBjb25zb2xlLndhcm4oJ1RoZSBDb252ZXggY29uc3RydWN0b3Igc2lnbmF0dXJlIGhhcyBjaGFuZ2VkLiBQbGVhc2UgdXNlIHRoZSBmb2xsb3dpbmcgZm9ybWF0OiBuZXcgQ29udmV4KHsgdmVydGljZXM6IFsuLi5dLCAuLi4gfSknKTtcbiAgICB9XG4gICAgb3B0aW9ucyA9IG9wdGlvbnMgfHwge307XG5cbiAgICAvKipcbiAgICAgKiBWZXJ0aWNlcyBkZWZpbmVkIGluIHRoZSBsb2NhbCBmcmFtZS5cbiAgICAgKiBAcHJvcGVydHkgdmVydGljZXNcbiAgICAgKiBAdHlwZSB7QXJyYXl9XG4gICAgICovXG4gICAgdGhpcy52ZXJ0aWNlcyA9IFtdO1xuXG4gICAgLy8gQ29weSB0aGUgdmVydHNcbiAgICB2YXIgdmVydGljZXMgPSBvcHRpb25zLnZlcnRpY2VzICE9PSB1bmRlZmluZWQgPyBvcHRpb25zLnZlcnRpY2VzIDogW107XG4gICAgZm9yKHZhciBpPTA7IGkgPCB2ZXJ0aWNlcy5sZW5ndGg7IGkrKyl7XG4gICAgICAgIHZhciB2ID0gdmVjMi5jcmVhdGUoKTtcbiAgICAgICAgdmVjMi5jb3B5KHYsIHZlcnRpY2VzW2ldKTtcbiAgICAgICAgdGhpcy52ZXJ0aWNlcy5wdXNoKHYpO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEF4ZXMgZGVmaW5lZCBpbiB0aGUgbG9jYWwgZnJhbWUuXG4gICAgICogQHByb3BlcnR5IGF4ZXNcbiAgICAgKiBAdHlwZSB7QXJyYXl9XG4gICAgICovXG4gICAgdGhpcy5heGVzID0gW107XG5cbiAgICBpZihvcHRpb25zLmF4ZXMpe1xuXG4gICAgICAgIC8vIENvcHkgdGhlIGF4ZXNcbiAgICAgICAgZm9yKHZhciBpPTA7IGkgPCBvcHRpb25zLmF4ZXMubGVuZ3RoOyBpKyspe1xuICAgICAgICAgICAgdmFyIGF4aXMgPSB2ZWMyLmNyZWF0ZSgpO1xuICAgICAgICAgICAgdmVjMi5jb3B5KGF4aXMsIG9wdGlvbnMuYXhlc1tpXSk7XG4gICAgICAgICAgICB0aGlzLmF4ZXMucHVzaChheGlzKTtcbiAgICAgICAgfVxuXG4gICAgfSBlbHNlIHtcblxuICAgICAgICAvLyBDb25zdHJ1Y3QgYXhlcyBmcm9tIHRoZSB2ZXJ0ZXggZGF0YVxuICAgICAgICBmb3IodmFyIGkgPSAwOyBpIDwgdGhpcy52ZXJ0aWNlcy5sZW5ndGg7IGkrKyl7XG4gICAgICAgICAgICAvLyBHZXQgdGhlIHdvcmxkIGVkZ2VcbiAgICAgICAgICAgIHZhciB3b3JsZFBvaW50MCA9IHRoaXMudmVydGljZXNbaV07XG4gICAgICAgICAgICB2YXIgd29ybGRQb2ludDEgPSB0aGlzLnZlcnRpY2VzWyhpKzEpICUgdGhpcy52ZXJ0aWNlcy5sZW5ndGhdO1xuXG4gICAgICAgICAgICB2YXIgbm9ybWFsID0gdmVjMi5jcmVhdGUoKTtcbiAgICAgICAgICAgIHZlYzIuc3ViKG5vcm1hbCwgd29ybGRQb2ludDEsIHdvcmxkUG9pbnQwKTtcblxuICAgICAgICAgICAgLy8gR2V0IG5vcm1hbCAtIGp1c3Qgcm90YXRlIDkwIGRlZ3JlZXMgc2luY2UgdmVydGljZXMgYXJlIGdpdmVuIGluIENDV1xuICAgICAgICAgICAgdmVjMi5yb3RhdGU5MGN3KG5vcm1hbCwgbm9ybWFsKTtcbiAgICAgICAgICAgIHZlYzIubm9ybWFsaXplKG5vcm1hbCwgbm9ybWFsKTtcblxuICAgICAgICAgICAgdGhpcy5heGVzLnB1c2gobm9ybWFsKTtcbiAgICAgICAgfVxuXG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogVGhlIGNlbnRlciBvZiBtYXNzIG9mIHRoZSBDb252ZXhcbiAgICAgKiBAcHJvcGVydHkgY2VudGVyT2ZNYXNzXG4gICAgICogQHR5cGUge0FycmF5fVxuICAgICAqL1xuICAgIHRoaXMuY2VudGVyT2ZNYXNzID0gdmVjMi5mcm9tVmFsdWVzKDAsMCk7XG5cbiAgICAvKipcbiAgICAgKiBUcmlhbmd1bGF0ZWQgdmVyc2lvbiBvZiB0aGlzIGNvbnZleC4gVGhlIHN0cnVjdHVyZSBpcyBBcnJheSBvZiAzLUFycmF5cywgYW5kIGVhY2ggc3ViYXJyYXkgY29udGFpbnMgMyBpbnRlZ2VycywgcmVmZXJlbmNpbmcgdGhlIHZlcnRpY2VzLlxuICAgICAqIEBwcm9wZXJ0eSB0cmlhbmdsZXNcbiAgICAgKiBAdHlwZSB7QXJyYXl9XG4gICAgICovXG4gICAgdGhpcy50cmlhbmdsZXMgPSBbXTtcblxuICAgIGlmKHRoaXMudmVydGljZXMubGVuZ3RoKXtcbiAgICAgICAgdGhpcy51cGRhdGVUcmlhbmdsZXMoKTtcbiAgICAgICAgdGhpcy51cGRhdGVDZW50ZXJPZk1hc3MoKTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYm91bmRpbmcgcmFkaXVzIG9mIHRoZSBjb252ZXhcbiAgICAgKiBAcHJvcGVydHkgYm91bmRpbmdSYWRpdXNcbiAgICAgKiBAdHlwZSB7TnVtYmVyfVxuICAgICAqL1xuICAgIHRoaXMuYm91bmRpbmdSYWRpdXMgPSAwO1xuXG4gICAgb3B0aW9ucy50eXBlID0gU2hhcGUuQ09OVkVYO1xuICAgIFNoYXBlLmNhbGwodGhpcywgb3B0aW9ucyk7XG5cbiAgICB0aGlzLnVwZGF0ZUJvdW5kaW5nUmFkaXVzKCk7XG4gICAgdGhpcy51cGRhdGVBcmVhKCk7XG4gICAgaWYodGhpcy5hcmVhIDwgMCl7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihcIkNvbnZleCB2ZXJ0aWNlcyBtdXN0IGJlIGdpdmVuIGluIGNvbnRlci1jbG9ja3dpc2Ugd2luZGluZy5cIik7XG4gICAgfVxufVxuQ29udmV4LnByb3RvdHlwZSA9IG5ldyBTaGFwZSgpO1xuQ29udmV4LnByb3RvdHlwZS5jb25zdHJ1Y3RvciA9IENvbnZleDtcblxudmFyIHRtcFZlYzEgPSB2ZWMyLmNyZWF0ZSgpO1xudmFyIHRtcFZlYzIgPSB2ZWMyLmNyZWF0ZSgpO1xuXG4vKipcbiAqIFByb2plY3QgYSBDb252ZXggb250byBhIHdvcmxkLW9yaWVudGVkIGF4aXNcbiAqIEBtZXRob2QgcHJvamVjdE9udG9BeGlzXG4gKiBAc3RhdGljXG4gKiBAcGFyYW0gIHtBcnJheX0gb2Zmc2V0XG4gKiBAcGFyYW0gIHtBcnJheX0gbG9jYWxBeGlzXG4gKiBAcGFyYW0gIHtBcnJheX0gcmVzdWx0XG4gKi9cbkNvbnZleC5wcm90b3R5cGUucHJvamVjdE9udG9Mb2NhbEF4aXMgPSBmdW5jdGlvbihsb2NhbEF4aXMsIHJlc3VsdCl7XG4gICAgdmFyIG1heD1udWxsLFxuICAgICAgICBtaW49bnVsbCxcbiAgICAgICAgdixcbiAgICAgICAgdmFsdWUsXG4gICAgICAgIGxvY2FsQXhpcyA9IHRtcFZlYzE7XG5cbiAgICAvLyBHZXQgcHJvamVjdGVkIHBvc2l0aW9uIG9mIGFsbCB2ZXJ0aWNlc1xuICAgIGZvcih2YXIgaT0wOyBpPHRoaXMudmVydGljZXMubGVuZ3RoOyBpKyspe1xuICAgICAgICB2ID0gdGhpcy52ZXJ0aWNlc1tpXTtcbiAgICAgICAgdmFsdWUgPSB2ZWMyLmRvdCh2LCBsb2NhbEF4aXMpO1xuICAgICAgICBpZihtYXggPT09IG51bGwgfHwgdmFsdWUgPiBtYXgpe1xuICAgICAgICAgICAgbWF4ID0gdmFsdWU7XG4gICAgICAgIH1cbiAgICAgICAgaWYobWluID09PSBudWxsIHx8IHZhbHVlIDwgbWluKXtcbiAgICAgICAgICAgIG1pbiA9IHZhbHVlO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgaWYobWluID4gbWF4KXtcbiAgICAgICAgdmFyIHQgPSBtaW47XG4gICAgICAgIG1pbiA9IG1heDtcbiAgICAgICAgbWF4ID0gdDtcbiAgICB9XG5cbiAgICB2ZWMyLnNldChyZXN1bHQsIG1pbiwgbWF4KTtcbn07XG5cbkNvbnZleC5wcm90b3R5cGUucHJvamVjdE9udG9Xb3JsZEF4aXMgPSBmdW5jdGlvbihsb2NhbEF4aXMsIHNoYXBlT2Zmc2V0LCBzaGFwZUFuZ2xlLCByZXN1bHQpe1xuICAgIHZhciB3b3JsZEF4aXMgPSB0bXBWZWMyO1xuXG4gICAgdGhpcy5wcm9qZWN0T250b0xvY2FsQXhpcyhsb2NhbEF4aXMsIHJlc3VsdCk7XG5cbiAgICAvLyBQcm9qZWN0IHRoZSBwb3NpdGlvbiBvZiB0aGUgYm9keSBvbnRvIHRoZSBheGlzIC0gbmVlZCB0byBhZGQgdGhpcyB0byB0aGUgcmVzdWx0XG4gICAgaWYoc2hhcGVBbmdsZSAhPT0gMCl7XG4gICAgICAgIHZlYzIucm90YXRlKHdvcmxkQXhpcywgbG9jYWxBeGlzLCBzaGFwZUFuZ2xlKTtcbiAgICB9IGVsc2Uge1xuICAgICAgICB3b3JsZEF4aXMgPSBsb2NhbEF4aXM7XG4gICAgfVxuICAgIHZhciBvZmZzZXQgPSB2ZWMyLmRvdChzaGFwZU9mZnNldCwgd29ybGRBeGlzKTtcblxuICAgIHZlYzIuc2V0KHJlc3VsdCwgcmVzdWx0WzBdICsgb2Zmc2V0LCByZXN1bHRbMV0gKyBvZmZzZXQpO1xufTtcblxuXG4vKipcbiAqIFVwZGF0ZSB0aGUgLnRyaWFuZ2xlcyBwcm9wZXJ0eVxuICogQG1ldGhvZCB1cGRhdGVUcmlhbmdsZXNcbiAqL1xuQ29udmV4LnByb3RvdHlwZS51cGRhdGVUcmlhbmdsZXMgPSBmdW5jdGlvbigpe1xuXG4gICAgdGhpcy50cmlhbmdsZXMubGVuZ3RoID0gMDtcblxuICAgIC8vIFJld3JpdGUgb24gcG9seWsgbm90YXRpb24sIGFycmF5IG9mIG51bWJlcnNcbiAgICB2YXIgcG9seWtWZXJ0cyA9IFtdO1xuICAgIGZvcih2YXIgaT0wOyBpPHRoaXMudmVydGljZXMubGVuZ3RoOyBpKyspe1xuICAgICAgICB2YXIgdiA9IHRoaXMudmVydGljZXNbaV07XG4gICAgICAgIHBvbHlrVmVydHMucHVzaCh2WzBdLHZbMV0pO1xuICAgIH1cblxuICAgIC8vIFRyaWFuZ3VsYXRlXG4gICAgdmFyIHRyaWFuZ2xlcyA9IHBvbHlrLlRyaWFuZ3VsYXRlKHBvbHlrVmVydHMpO1xuXG4gICAgLy8gTG9vcCBvdmVyIGFsbCB0cmlhbmdsZXMsIGFkZCB0aGVpciBpbmVydGlhIGNvbnRyaWJ1dGlvbnMgdG8gSVxuICAgIGZvcih2YXIgaT0wOyBpPHRyaWFuZ2xlcy5sZW5ndGg7IGkrPTMpe1xuICAgICAgICB2YXIgaWQxID0gdHJpYW5nbGVzW2ldLFxuICAgICAgICAgICAgaWQyID0gdHJpYW5nbGVzW2krMV0sXG4gICAgICAgICAgICBpZDMgPSB0cmlhbmdsZXNbaSsyXTtcblxuICAgICAgICAvLyBBZGQgdG8gdHJpYW5nbGVzXG4gICAgICAgIHRoaXMudHJpYW5nbGVzLnB1c2goW2lkMSxpZDIsaWQzXSk7XG4gICAgfVxufTtcblxudmFyIHVwZGF0ZUNlbnRlck9mTWFzc19jZW50cm9pZCA9IHZlYzIuY3JlYXRlKCksXG4gICAgdXBkYXRlQ2VudGVyT2ZNYXNzX2NlbnRyb2lkX3RpbWVzX21hc3MgPSB2ZWMyLmNyZWF0ZSgpLFxuICAgIHVwZGF0ZUNlbnRlck9mTWFzc19hID0gdmVjMi5jcmVhdGUoKSxcbiAgICB1cGRhdGVDZW50ZXJPZk1hc3NfYiA9IHZlYzIuY3JlYXRlKCksXG4gICAgdXBkYXRlQ2VudGVyT2ZNYXNzX2MgPSB2ZWMyLmNyZWF0ZSgpLFxuICAgIHVwZGF0ZUNlbnRlck9mTWFzc19hYyA9IHZlYzIuY3JlYXRlKCksXG4gICAgdXBkYXRlQ2VudGVyT2ZNYXNzX2NhID0gdmVjMi5jcmVhdGUoKSxcbiAgICB1cGRhdGVDZW50ZXJPZk1hc3NfY2IgPSB2ZWMyLmNyZWF0ZSgpLFxuICAgIHVwZGF0ZUNlbnRlck9mTWFzc19uID0gdmVjMi5jcmVhdGUoKTtcblxuLyoqXG4gKiBVcGRhdGUgdGhlIC5jZW50ZXJPZk1hc3MgcHJvcGVydHkuXG4gKiBAbWV0aG9kIHVwZGF0ZUNlbnRlck9mTWFzc1xuICovXG5Db252ZXgucHJvdG90eXBlLnVwZGF0ZUNlbnRlck9mTWFzcyA9IGZ1bmN0aW9uKCl7XG4gICAgdmFyIHRyaWFuZ2xlcyA9IHRoaXMudHJpYW5nbGVzLFxuICAgICAgICB2ZXJ0cyA9IHRoaXMudmVydGljZXMsXG4gICAgICAgIGNtID0gdGhpcy5jZW50ZXJPZk1hc3MsXG4gICAgICAgIGNlbnRyb2lkID0gdXBkYXRlQ2VudGVyT2ZNYXNzX2NlbnRyb2lkLFxuICAgICAgICBuID0gdXBkYXRlQ2VudGVyT2ZNYXNzX24sXG4gICAgICAgIGEgPSB1cGRhdGVDZW50ZXJPZk1hc3NfYSxcbiAgICAgICAgYiA9IHVwZGF0ZUNlbnRlck9mTWFzc19iLFxuICAgICAgICBjID0gdXBkYXRlQ2VudGVyT2ZNYXNzX2MsXG4gICAgICAgIGFjID0gdXBkYXRlQ2VudGVyT2ZNYXNzX2FjLFxuICAgICAgICBjYSA9IHVwZGF0ZUNlbnRlck9mTWFzc19jYSxcbiAgICAgICAgY2IgPSB1cGRhdGVDZW50ZXJPZk1hc3NfY2IsXG4gICAgICAgIGNlbnRyb2lkX3RpbWVzX21hc3MgPSB1cGRhdGVDZW50ZXJPZk1hc3NfY2VudHJvaWRfdGltZXNfbWFzcztcblxuICAgIHZlYzIuc2V0KGNtLDAsMCk7XG4gICAgdmFyIHRvdGFsQXJlYSA9IDA7XG5cbiAgICBmb3IodmFyIGk9MDsgaSE9PXRyaWFuZ2xlcy5sZW5ndGg7IGkrKyl7XG4gICAgICAgIHZhciB0ID0gdHJpYW5nbGVzW2ldLFxuICAgICAgICAgICAgYSA9IHZlcnRzW3RbMF1dLFxuICAgICAgICAgICAgYiA9IHZlcnRzW3RbMV1dLFxuICAgICAgICAgICAgYyA9IHZlcnRzW3RbMl1dO1xuXG4gICAgICAgIHZlYzIuY2VudHJvaWQoY2VudHJvaWQsYSxiLGMpO1xuXG4gICAgICAgIC8vIEdldCBtYXNzIGZvciB0aGUgdHJpYW5nbGUgKGRlbnNpdHk9MSBpbiB0aGlzIGNhc2UpXG4gICAgICAgIC8vIGh0dHA6Ly9tYXRoLnN0YWNrZXhjaGFuZ2UuY29tL3F1ZXN0aW9ucy84MDE5OC9hcmVhLW9mLXRyaWFuZ2xlLXZpYS12ZWN0b3JzXG4gICAgICAgIHZhciBtID0gQ29udmV4LnRyaWFuZ2xlQXJlYShhLGIsYyk7XG4gICAgICAgIHRvdGFsQXJlYSArPSBtO1xuXG4gICAgICAgIC8vIEFkZCB0byBjZW50ZXIgb2YgbWFzc1xuICAgICAgICB2ZWMyLnNjYWxlKGNlbnRyb2lkX3RpbWVzX21hc3MsIGNlbnRyb2lkLCBtKTtcbiAgICAgICAgdmVjMi5hZGQoY20sIGNtLCBjZW50cm9pZF90aW1lc19tYXNzKTtcbiAgICB9XG5cbiAgICB2ZWMyLnNjYWxlKGNtLGNtLDEvdG90YWxBcmVhKTtcbn07XG5cbi8qKlxuICogQ29tcHV0ZSB0aGUgbWFzcyBtb21lbnQgb2YgaW5lcnRpYSBvZiB0aGUgQ29udmV4LlxuICogQG1ldGhvZCBjb21wdXRlTW9tZW50T2ZJbmVydGlhXG4gKiBAcGFyYW0gIHtOdW1iZXJ9IG1hc3NcbiAqIEByZXR1cm4ge051bWJlcn1cbiAqIEBzZWUgaHR0cDovL3d3dy5nYW1lZGV2Lm5ldC90b3BpYy8zNDI4MjItbW9tZW50LW9mLWluZXJ0aWEtb2YtYS1wb2x5Z29uLTJkL1xuICovXG5Db252ZXgucHJvdG90eXBlLmNvbXB1dGVNb21lbnRPZkluZXJ0aWEgPSBmdW5jdGlvbihtYXNzKXtcbiAgICB2YXIgZGVub20gPSAwLjAsXG4gICAgICAgIG51bWVyID0gMC4wLFxuICAgICAgICBOID0gdGhpcy52ZXJ0aWNlcy5sZW5ndGg7XG4gICAgZm9yKHZhciBqID0gTi0xLCBpID0gMDsgaSA8IE47IGogPSBpLCBpICsrKXtcbiAgICAgICAgdmFyIHAwID0gdGhpcy52ZXJ0aWNlc1tqXTtcbiAgICAgICAgdmFyIHAxID0gdGhpcy52ZXJ0aWNlc1tpXTtcbiAgICAgICAgdmFyIGEgPSBNYXRoLmFicyh2ZWMyLmNyb3NzTGVuZ3RoKHAwLHAxKSk7XG4gICAgICAgIHZhciBiID0gdmVjMi5kb3QocDEscDEpICsgdmVjMi5kb3QocDEscDApICsgdmVjMi5kb3QocDAscDApO1xuICAgICAgICBkZW5vbSArPSBhICogYjtcbiAgICAgICAgbnVtZXIgKz0gYTtcbiAgICB9XG4gICAgcmV0dXJuIChtYXNzIC8gNi4wKSAqIChkZW5vbSAvIG51bWVyKTtcbn07XG5cbi8qKlxuICogVXBkYXRlcyB0aGUgLmJvdW5kaW5nUmFkaXVzIHByb3BlcnR5XG4gKiBAbWV0aG9kIHVwZGF0ZUJvdW5kaW5nUmFkaXVzXG4gKi9cbkNvbnZleC5wcm90b3R5cGUudXBkYXRlQm91bmRpbmdSYWRpdXMgPSBmdW5jdGlvbigpe1xuICAgIHZhciB2ZXJ0cyA9IHRoaXMudmVydGljZXMsXG4gICAgICAgIHIyID0gMDtcblxuICAgIGZvcih2YXIgaT0wOyBpIT09dmVydHMubGVuZ3RoOyBpKyspe1xuICAgICAgICB2YXIgbDIgPSB2ZWMyLnNxdWFyZWRMZW5ndGgodmVydHNbaV0pO1xuICAgICAgICBpZihsMiA+IHIyKXtcbiAgICAgICAgICAgIHIyID0gbDI7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICB0aGlzLmJvdW5kaW5nUmFkaXVzID0gTWF0aC5zcXJ0KHIyKTtcbn07XG5cbi8qKlxuICogR2V0IHRoZSBhcmVhIG9mIHRoZSB0cmlhbmdsZSBzcGFubmVkIGJ5IHRoZSB0aHJlZSBwb2ludHMgYSwgYiwgYy4gVGhlIGFyZWEgaXMgcG9zaXRpdmUgaWYgdGhlIHBvaW50cyBhcmUgZ2l2ZW4gaW4gY291bnRlci1jbG9ja3dpc2Ugb3JkZXIsIG90aGVyd2lzZSBuZWdhdGl2ZS5cbiAqIEBzdGF0aWNcbiAqIEBtZXRob2QgdHJpYW5nbGVBcmVhXG4gKiBAcGFyYW0ge0FycmF5fSBhXG4gKiBAcGFyYW0ge0FycmF5fSBiXG4gKiBAcGFyYW0ge0FycmF5fSBjXG4gKiBAcmV0dXJuIHtOdW1iZXJ9XG4gKi9cbkNvbnZleC50cmlhbmdsZUFyZWEgPSBmdW5jdGlvbihhLGIsYyl7XG4gICAgcmV0dXJuICgoKGJbMF0gLSBhWzBdKSooY1sxXSAtIGFbMV0pKS0oKGNbMF0gLSBhWzBdKSooYlsxXSAtIGFbMV0pKSkgKiAwLjU7XG59O1xuXG4vKipcbiAqIFVwZGF0ZSB0aGUgLmFyZWFcbiAqIEBtZXRob2QgdXBkYXRlQXJlYVxuICovXG5Db252ZXgucHJvdG90eXBlLnVwZGF0ZUFyZWEgPSBmdW5jdGlvbigpe1xuICAgIHRoaXMudXBkYXRlVHJpYW5nbGVzKCk7XG4gICAgdGhpcy5hcmVhID0gMDtcblxuICAgIHZhciB0cmlhbmdsZXMgPSB0aGlzLnRyaWFuZ2xlcyxcbiAgICAgICAgdmVydHMgPSB0aGlzLnZlcnRpY2VzO1xuICAgIGZvcih2YXIgaT0wOyBpIT09dHJpYW5nbGVzLmxlbmd0aDsgaSsrKXtcbiAgICAgICAgdmFyIHQgPSB0cmlhbmdsZXNbaV0sXG4gICAgICAgICAgICBhID0gdmVydHNbdFswXV0sXG4gICAgICAgICAgICBiID0gdmVydHNbdFsxXV0sXG4gICAgICAgICAgICBjID0gdmVydHNbdFsyXV07XG5cbiAgICAgICAgLy8gR2V0IG1hc3MgZm9yIHRoZSB0cmlhbmdsZSAoZGVuc2l0eT0xIGluIHRoaXMgY2FzZSlcbiAgICAgICAgdmFyIG0gPSBDb252ZXgudHJpYW5nbGVBcmVhKGEsYixjKTtcbiAgICAgICAgdGhpcy5hcmVhICs9IG07XG4gICAgfVxufTtcblxuLyoqXG4gKiBAbWV0aG9kIGNvbXB1dGVBQUJCXG4gKiBAcGFyYW0gIHtBQUJCfSAgIG91dFxuICogQHBhcmFtICB7QXJyYXl9ICBwb3NpdGlvblxuICogQHBhcmFtICB7TnVtYmVyfSBhbmdsZVxuICovXG5Db252ZXgucHJvdG90eXBlLmNvbXB1dGVBQUJCID0gZnVuY3Rpb24ob3V0LCBwb3NpdGlvbiwgYW5nbGUpe1xuICAgIG91dC5zZXRGcm9tUG9pbnRzKHRoaXMudmVydGljZXMsIHBvc2l0aW9uLCBhbmdsZSwgMCk7XG59O1xuXG52YXIgaW50ZXJzZWN0Q29udmV4X3JheVN0YXJ0ID0gdmVjMi5jcmVhdGUoKTtcbnZhciBpbnRlcnNlY3RDb252ZXhfcmF5RW5kID0gdmVjMi5jcmVhdGUoKTtcbnZhciBpbnRlcnNlY3RDb252ZXhfbm9ybWFsID0gdmVjMi5jcmVhdGUoKTtcblxuLyoqXG4gKiBAbWV0aG9kIHJheWNhc3RcbiAqIEBwYXJhbSAge1JheWNhc3RSZXN1bHR9IHJlc3VsdFxuICogQHBhcmFtICB7UmF5fSByYXlcbiAqIEBwYXJhbSAge2FycmF5fSBwb3NpdGlvblxuICogQHBhcmFtICB7bnVtYmVyfSBhbmdsZVxuICovXG5Db252ZXgucHJvdG90eXBlLnJheWNhc3QgPSBmdW5jdGlvbihyZXN1bHQsIHJheSwgcG9zaXRpb24sIGFuZ2xlKXtcbiAgICB2YXIgcmF5U3RhcnQgPSBpbnRlcnNlY3RDb252ZXhfcmF5U3RhcnQ7XG4gICAgdmFyIHJheUVuZCA9IGludGVyc2VjdENvbnZleF9yYXlFbmQ7XG4gICAgdmFyIG5vcm1hbCA9IGludGVyc2VjdENvbnZleF9ub3JtYWw7XG4gICAgdmFyIHZlcnRpY2VzID0gdGhpcy52ZXJ0aWNlcztcblxuICAgIC8vIFRyYW5zZm9ybSB0byBsb2NhbCBzaGFwZSBzcGFjZVxuICAgIHZlYzIudG9Mb2NhbEZyYW1lKHJheVN0YXJ0LCByYXkuZnJvbSwgcG9zaXRpb24sIGFuZ2xlKTtcbiAgICB2ZWMyLnRvTG9jYWxGcmFtZShyYXlFbmQsIHJheS50bywgcG9zaXRpb24sIGFuZ2xlKTtcblxuICAgIHZhciBuID0gdmVydGljZXMubGVuZ3RoO1xuXG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCBuICYmICFyZXN1bHQuc2hvdWxkU3RvcChyYXkpOyBpKyspIHtcbiAgICAgICAgdmFyIHExID0gdmVydGljZXNbaV07XG4gICAgICAgIHZhciBxMiA9IHZlcnRpY2VzWyhpKzEpICUgbl07XG4gICAgICAgIHZhciBkZWx0YSA9IHZlYzIuZ2V0TGluZVNlZ21lbnRzSW50ZXJzZWN0aW9uRnJhY3Rpb24ocmF5U3RhcnQsIHJheUVuZCwgcTEsIHEyKTtcblxuICAgICAgICBpZihkZWx0YSA+PSAwKXtcbiAgICAgICAgICAgIHZlYzIuc3ViKG5vcm1hbCwgcTIsIHExKTtcbiAgICAgICAgICAgIHZlYzIucm90YXRlKG5vcm1hbCwgbm9ybWFsLCAtTWF0aC5QSSAvIDIgKyBhbmdsZSk7XG4gICAgICAgICAgICB2ZWMyLm5vcm1hbGl6ZShub3JtYWwsIG5vcm1hbCk7XG4gICAgICAgICAgICByYXkucmVwb3J0SW50ZXJzZWN0aW9uKHJlc3VsdCwgZGVsdGEsIG5vcm1hbCwgaSk7XG4gICAgICAgIH1cbiAgICB9XG59O1xuXG5cblxuLy8vLy8vLy8vLy8vLy8vLy8vXG4vLyBXRUJQQUNLIEZPT1RFUlxuLy8gLi9+L3AyL3NyYy9zaGFwZXMvQ29udmV4LmpzXG4vLyBtb2R1bGUgaWQgPSAxMFxuLy8gbW9kdWxlIGNodW5rcyA9IDAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///10\n");

/***/ }),
/* 11 */
/* no static exports found */
/* all exports used */
/*!************************************!*\
  !*** ./~/p2/src/collision/AABB.js ***!
  \************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\nmodule.exports = AABB;\n\n/**\n * Axis aligned bounding box class.\n * @class AABB\n * @constructor\n * @param {Object}  [options]\n * @param {Array}   [options.upperBound]\n * @param {Array}   [options.lowerBound]\n */\nfunction AABB(options){\n\n    /**\n     * The lower bound of the bounding box.\n     * @property lowerBound\n     * @type {Array}\n     */\n    this.lowerBound = vec2.create();\n    if(options && options.lowerBound){\n        vec2.copy(this.lowerBound, options.lowerBound);\n    }\n\n    /**\n     * The upper bound of the bounding box.\n     * @property upperBound\n     * @type {Array}\n     */\n    this.upperBound = vec2.create();\n    if(options && options.upperBound){\n        vec2.copy(this.upperBound, options.upperBound);\n    }\n}\n\nvar tmp = vec2.create();\n\n/**\n * Set the AABB bounds from a set of points, transformed by the given position and angle.\n * @method setFromPoints\n * @param {Array} points An array of vec2's.\n * @param {Array} position\n * @param {number} angle\n * @param {number} skinSize Some margin to be added to the AABB.\n */\nAABB.prototype.setFromPoints = function(points, position, angle, skinSize){\n    var l = this.lowerBound,\n        u = this.upperBound;\n\n    if(typeof(angle) !== \"number\"){\n        angle = 0;\n    }\n\n    // Set to the first point\n    if(angle !== 0){\n        vec2.rotate(l, points[0], angle);\n    } else {\n        vec2.copy(l, points[0]);\n    }\n    vec2.copy(u, l);\n\n    // Compute cosines and sines just once\n    var cosAngle = Math.cos(angle),\n        sinAngle = Math.sin(angle);\n    for(var i = 1; i<points.length; i++){\n        var p = points[i];\n\n        if(angle !== 0){\n            var x = p[0],\n                y = p[1];\n            tmp[0] = cosAngle * x -sinAngle * y;\n            tmp[1] = sinAngle * x +cosAngle * y;\n            p = tmp;\n        }\n\n        for(var j=0; j<2; j++){\n            if(p[j] > u[j]){\n                u[j] = p[j];\n            }\n            if(p[j] < l[j]){\n                l[j] = p[j];\n            }\n        }\n    }\n\n    // Add offset\n    if(position){\n        vec2.add(this.lowerBound, this.lowerBound, position);\n        vec2.add(this.upperBound, this.upperBound, position);\n    }\n\n    if(skinSize){\n        this.lowerBound[0] -= skinSize;\n        this.lowerBound[1] -= skinSize;\n        this.upperBound[0] += skinSize;\n        this.upperBound[1] += skinSize;\n    }\n};\n\n/**\n * Copy bounds from an AABB to this AABB\n * @method copy\n * @param  {AABB} aabb\n */\nAABB.prototype.copy = function(aabb){\n    vec2.copy(this.lowerBound, aabb.lowerBound);\n    vec2.copy(this.upperBound, aabb.upperBound);\n};\n\n/**\n * Extend this AABB so that it covers the given AABB too.\n * @method extend\n * @param  {AABB} aabb\n */\nAABB.prototype.extend = function(aabb){\n    // Loop over x and y\n    var i = 2;\n    while(i--){\n        // Extend lower bound\n        var l = aabb.lowerBound[i];\n        if(this.lowerBound[i] > l){\n            this.lowerBound[i] = l;\n        }\n\n        // Upper\n        var u = aabb.upperBound[i];\n        if(this.upperBound[i] < u){\n            this.upperBound[i] = u;\n        }\n    }\n};\n\n/**\n * Returns true if the given AABB overlaps this AABB.\n * @method overlaps\n * @param  {AABB} aabb\n * @return {Boolean}\n */\nAABB.prototype.overlaps = function(aabb){\n    var l1 = this.lowerBound,\n        u1 = this.upperBound,\n        l2 = aabb.lowerBound,\n        u2 = aabb.upperBound;\n\n    //      l2        u2\n    //      |---------|\n    // |--------|\n    // l1       u1\n\n    return ((l2[0] <= u1[0] && u1[0] <= u2[0]) || (l1[0] <= u2[0] && u2[0] <= u1[0])) &&\n           ((l2[1] <= u1[1] && u1[1] <= u2[1]) || (l1[1] <= u2[1] && u2[1] <= u1[1]));\n};\n\n/**\n * @method containsPoint\n * @param  {Array} point\n * @return {boolean}\n */\nAABB.prototype.containsPoint = function(point){\n    var l = this.lowerBound,\n        u = this.upperBound;\n    return l[0] <= point[0] && point[0] <= u[0] && l[1] <= point[1] && point[1] <= u[1];\n};\n\n/**\n * Check if the AABB is hit by a ray.\n * @method overlapsRay\n * @param  {Ray} ray\n * @return {number} -1 if no hit, a number between 0 and 1 if hit.\n */\nAABB.prototype.overlapsRay = function(ray){\n    var t = 0;\n\n    // ray.direction is unit direction vector of ray\n    var dirFracX = 1 / ray.direction[0];\n    var dirFracY = 1 / ray.direction[1];\n\n    // this.lowerBound is the corner of AABB with minimal coordinates - left bottom, rt is maximal corner\n    var t1 = (this.lowerBound[0] - ray.from[0]) * dirFracX;\n    var t2 = (this.upperBound[0] - ray.from[0]) * dirFracX;\n    var t3 = (this.lowerBound[1] - ray.from[1]) * dirFracY;\n    var t4 = (this.upperBound[1] - ray.from[1]) * dirFracY;\n\n    var tmin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)));\n    var tmax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)));\n\n    // if tmax < 0, ray (line) is intersecting AABB, but whole AABB is behing us\n    if (tmax < 0){\n        //t = tmax;\n        return -1;\n    }\n\n    // if tmin > tmax, ray doesn't intersect AABB\n    if (tmin > tmax){\n        //t = tmax;\n        return -1;\n    }\n\n    return tmin;\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///11\n");

/***/ }),
/* 12 */
/* no static exports found */
/* all exports used */
/*!******************************************!*\
  !*** ./~/p2/src/collision/Broadphase.js ***!
  \******************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\nvar Body = __webpack_require__(/*! ../objects/Body */ 7);\n\nmodule.exports = Broadphase;\n\n/**\n * Base class for broadphase implementations.\n * @class Broadphase\n * @constructor\n */\nfunction Broadphase(type){\n\n    this.type = type;\n\n    /**\n     * The resulting overlapping pairs. Will be filled with results during .getCollisionPairs().\n     * @property result\n     * @type {Array}\n     */\n    this.result = [];\n\n    /**\n     * The world to search for collision pairs in. To change it, use .setWorld()\n     * @property world\n     * @type {World}\n     * @readOnly\n     */\n    this.world = null;\n\n    /**\n     * The bounding volume type to use in the broadphase algorithms. Should be set to Broadphase.AABB or Broadphase.BOUNDING_CIRCLE.\n     * @property {Number} boundingVolumeType\n     */\n    this.boundingVolumeType = Broadphase.AABB;\n}\n\n/**\n * Axis aligned bounding box type.\n * @static\n * @property {Number} AABB\n */\nBroadphase.AABB = 1;\n\n/**\n * Bounding circle type.\n * @static\n * @property {Number} BOUNDING_CIRCLE\n */\nBroadphase.BOUNDING_CIRCLE = 2;\n\n/**\n * Set the world that we are searching for collision pairs in.\n * @method setWorld\n * @param  {World} world\n */\nBroadphase.prototype.setWorld = function(world){\n    this.world = world;\n};\n\n/**\n * Get all potential intersecting body pairs.\n * @method getCollisionPairs\n * @param  {World} world The world to search in.\n * @return {Array} An array of the bodies, ordered in pairs. Example: A result of [a,b,c,d] means that the potential pairs are: (a,b), (c,d).\n */\nBroadphase.prototype.getCollisionPairs = function(world){};\n\nvar dist = vec2.create();\n\n/**\n * Check whether the bounding radius of two bodies overlap.\n * @method  boundingRadiusCheck\n * @param  {Body} bodyA\n * @param  {Body} bodyB\n * @return {Boolean}\n */\nBroadphase.boundingRadiusCheck = function(bodyA, bodyB){\n    vec2.sub(dist, bodyA.position, bodyB.position);\n    var d2 = vec2.squaredLength(dist),\n        r = bodyA.boundingRadius + bodyB.boundingRadius;\n    return d2 <= r*r;\n};\n\n/**\n * Check whether the bounding radius of two bodies overlap.\n * @method  boundingRadiusCheck\n * @param  {Body} bodyA\n * @param  {Body} bodyB\n * @return {Boolean}\n */\nBroadphase.aabbCheck = function(bodyA, bodyB){\n    return bodyA.getAABB().overlaps(bodyB.getAABB());\n};\n\n/**\n * Check whether the bounding radius of two bodies overlap.\n * @method  boundingRadiusCheck\n * @param  {Body} bodyA\n * @param  {Body} bodyB\n * @return {Boolean}\n */\nBroadphase.prototype.boundingVolumeCheck = function(bodyA, bodyB){\n    var result;\n\n    switch(this.boundingVolumeType){\n    case Broadphase.BOUNDING_CIRCLE:\n        result =  Broadphase.boundingRadiusCheck(bodyA,bodyB);\n        break;\n    case Broadphase.AABB:\n        result = Broadphase.aabbCheck(bodyA,bodyB);\n        break;\n    default:\n        throw new Error('Bounding volume type not recognized: '+this.boundingVolumeType);\n    }\n    return result;\n};\n\n/**\n * Check whether two bodies are allowed to collide at all.\n * @method  canCollide\n * @param  {Body} bodyA\n * @param  {Body} bodyB\n * @return {Boolean}\n */\nBroadphase.canCollide = function(bodyA, bodyB){\n    var KINEMATIC = Body.KINEMATIC;\n    var STATIC = Body.STATIC;\n\n    // Cannot collide static bodies\n    if(bodyA.type === STATIC && bodyB.type === STATIC){\n        return false;\n    }\n\n    // Cannot collide static vs kinematic bodies\n    if( (bodyA.type === KINEMATIC && bodyB.type === STATIC) ||\n        (bodyA.type === STATIC    && bodyB.type === KINEMATIC)){\n        return false;\n    }\n\n    // Cannot collide kinematic vs kinematic\n    if(bodyA.type === KINEMATIC && bodyB.type === KINEMATIC){\n        return false;\n    }\n\n    // Cannot collide both sleeping bodies\n    if(bodyA.sleepState === Body.SLEEPING && bodyB.sleepState === Body.SLEEPING){\n        return false;\n    }\n\n    // Cannot collide if one is static and the other is sleeping\n    if( (bodyA.sleepState === Body.SLEEPING && bodyB.type === STATIC) ||\n        (bodyB.sleepState === Body.SLEEPING && bodyA.type === STATIC)){\n        return false;\n    }\n\n    return true;\n};\n\nBroadphase.NAIVE = 1;\nBroadphase.SAP = 2;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///12\n");

/***/ }),
/* 13 */
/* no static exports found */
/* all exports used */
/*!***********************************!*\
  !*** ./~/p2/src/collision/Ray.js ***!
  \***********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("module.exports = Ray;\n\nvar vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\nvar RaycastResult = __webpack_require__(/*! ../collision/RaycastResult */ 18);\nvar Shape = __webpack_require__(/*! ../shapes/Shape */ 3);\nvar AABB = __webpack_require__(/*! ../collision/AABB */ 11);\n\n/**\n * A line with a start and end point that is used to intersect shapes. For an example, see {{#crossLink \"World/raycast:method\"}}World.raycast{{/crossLink}}\n * @class Ray\n * @constructor\n * @param {object} [options]\n * @param {array} [options.from]\n * @param {array} [options.to]\n * @param {boolean} [options.checkCollisionResponse=true]\n * @param {boolean} [options.skipBackfaces=false]\n * @param {number} [options.collisionMask=-1]\n * @param {number} [options.collisionGroup=-1]\n * @param {number} [options.mode=Ray.ANY]\n * @param {number} [options.callback]\n */\nfunction Ray(options){\n    options = options || {};\n\n    /**\n     * Ray start point.\n     * @property {array} from\n     */\n    this.from = options.from ? vec2.fromValues(options.from[0], options.from[1]) : vec2.create();\n\n    /**\n     * Ray end point\n     * @property {array} to\n     */\n    this.to = options.to ? vec2.fromValues(options.to[0], options.to[1]) : vec2.create();\n\n    /**\n     * Set to true if you want the Ray to take .collisionResponse flags into account on bodies and shapes.\n     * @property {Boolean} checkCollisionResponse\n     */\n    this.checkCollisionResponse = options.checkCollisionResponse !== undefined ? options.checkCollisionResponse : true;\n\n    /**\n     * If set to true, the ray skips any hits with normal.dot(rayDirection) < 0.\n     * @property {Boolean} skipBackfaces\n     */\n    this.skipBackfaces = !!options.skipBackfaces;\n\n    /**\n     * @property {number} collisionMask\n     * @default -1\n     */\n    this.collisionMask = options.collisionMask !== undefined ? options.collisionMask : -1;\n\n    /**\n     * @property {number} collisionGroup\n     * @default -1\n     */\n    this.collisionGroup = options.collisionGroup !== undefined ? options.collisionGroup : -1;\n\n    /**\n     * The intersection mode. Should be {{#crossLink \"Ray/ANY:property\"}}Ray.ANY{{/crossLink}}, {{#crossLink \"Ray/ALL:property\"}}Ray.ALL{{/crossLink}} or {{#crossLink \"Ray/CLOSEST:property\"}}Ray.CLOSEST{{/crossLink}}.\n     * @property {number} mode\n     */\n    this.mode = options.mode !== undefined ? options.mode : Ray.ANY;\n\n    /**\n     * Current, user-provided result callback. Will be used if mode is Ray.ALL.\n     * @property {Function} callback\n     */\n    this.callback = options.callback || function(result){};\n\n    /**\n     * @readOnly\n     * @property {array} direction\n     */\n    this.direction = vec2.create();\n\n    /**\n     * Length of the ray\n     * @readOnly\n     * @property {number} length\n     */\n    this.length = 1;\n\n    this.update();\n}\nRay.prototype.constructor = Ray;\n\n/**\n * This raycasting mode will make the Ray traverse through all intersection points and only return the closest one.\n * @static\n * @property {Number} CLOSEST\n */\nRay.CLOSEST = 1;\n\n/**\n * This raycasting mode will make the Ray stop when it finds the first intersection point.\n * @static\n * @property {Number} ANY\n */\nRay.ANY = 2;\n\n/**\n * This raycasting mode will traverse all intersection points and executes a callback for each one.\n * @static\n * @property {Number} ALL\n */\nRay.ALL = 4;\n\n/**\n * Should be called if you change the from or to point.\n * @method update\n */\nRay.prototype.update = function(){\n\n    // Update .direction and .length\n    var d = this.direction;\n    vec2.sub(d, this.to, this.from);\n    this.length = vec2.length(d);\n    vec2.normalize(d, d);\n\n};\n\n/**\n * @method intersectBodies\n * @param {Array} bodies An array of Body objects.\n */\nRay.prototype.intersectBodies = function (result, bodies) {\n    for (var i = 0, l = bodies.length; !result.shouldStop(this) && i < l; i++) {\n        var body = bodies[i];\n        var aabb = body.getAABB();\n        if(aabb.overlapsRay(this) >= 0 || aabb.containsPoint(this.from)){\n            this.intersectBody(result, body);\n        }\n    }\n};\n\nvar intersectBody_worldPosition = vec2.create();\n\n/**\n * Shoot a ray at a body, get back information about the hit.\n * @method intersectBody\n * @private\n * @param {Body} body\n */\nRay.prototype.intersectBody = function (result, body) {\n    var checkCollisionResponse = this.checkCollisionResponse;\n\n    if(checkCollisionResponse && !body.collisionResponse){\n        return;\n    }\n\n    var worldPosition = intersectBody_worldPosition;\n\n    for (var i = 0, N = body.shapes.length; i < N; i++) {\n        var shape = body.shapes[i];\n\n        if(checkCollisionResponse && !shape.collisionResponse){\n            continue; // Skip\n        }\n\n        if((this.collisionGroup & shape.collisionMask) === 0 || (shape.collisionGroup & this.collisionMask) === 0){\n            continue;\n        }\n\n        // Get world angle and position of the shape\n        vec2.rotate(worldPosition, shape.position, body.angle);\n        vec2.add(worldPosition, worldPosition, body.position);\n        var worldAngle = shape.angle + body.angle;\n\n        this.intersectShape(\n            result,\n            shape,\n            worldAngle,\n            worldPosition,\n            body\n        );\n\n        if(result.shouldStop(this)){\n            break;\n        }\n    }\n};\n\n/**\n * @method intersectShape\n * @private\n * @param {Shape} shape\n * @param {number} angle\n * @param {array} position\n * @param {Body} body\n */\nRay.prototype.intersectShape = function(result, shape, angle, position, body){\n    var from = this.from;\n\n    // Checking radius\n    var distance = distanceFromIntersectionSquared(from, this.direction, position);\n    if (distance > shape.boundingRadius * shape.boundingRadius) {\n        return;\n    }\n\n    this._currentBody = body;\n    this._currentShape = shape;\n\n    shape.raycast(result, this, position, angle);\n\n    this._currentBody = this._currentShape = null;\n};\n\n/**\n * Get the AABB of the ray.\n * @method getAABB\n * @param  {AABB} aabb\n */\nRay.prototype.getAABB = function(result){\n    var to = this.to;\n    var from = this.from;\n    vec2.set(\n        result.lowerBound,\n        Math.min(to[0], from[0]),\n        Math.min(to[1], from[1])\n    );\n    vec2.set(\n        result.upperBound,\n        Math.max(to[0], from[0]),\n        Math.max(to[1], from[1])\n    );\n};\n\nvar hitPointWorld = vec2.create();\n\n/**\n * @method reportIntersection\n * @private\n * @param  {number} fraction\n * @param  {array} normal\n * @param  {number} [faceIndex=-1]\n * @return {boolean} True if the intersections should continue\n */\nRay.prototype.reportIntersection = function(result, fraction, normal, faceIndex){\n    var from = this.from;\n    var to = this.to;\n    var shape = this._currentShape;\n    var body = this._currentBody;\n\n    // Skip back faces?\n    if(this.skipBackfaces && vec2.dot(normal, this.direction) > 0){\n        return;\n    }\n\n    switch(this.mode){\n\n    case Ray.ALL:\n        result.set(\n            normal,\n            shape,\n            body,\n            fraction,\n            faceIndex\n        );\n        this.callback(result);\n        break;\n\n    case Ray.CLOSEST:\n\n        // Store if closer than current closest\n        if(fraction < result.fraction || !result.hasHit()){\n            result.set(\n                normal,\n                shape,\n                body,\n                fraction,\n                faceIndex\n            );\n        }\n        break;\n\n    case Ray.ANY:\n\n        // Report and stop.\n        result.set(\n            normal,\n            shape,\n            body,\n            fraction,\n            faceIndex\n        );\n        break;\n    }\n};\n\nvar v0 = vec2.create(),\n    intersect = vec2.create();\nfunction distanceFromIntersectionSquared(from, direction, position) {\n\n    // v0 is vector from from to position\n    vec2.sub(v0, position, from);\n    var dot = vec2.dot(v0, direction);\n\n    // intersect = direction * dot + from\n    vec2.scale(intersect, direction, dot);\n    vec2.add(intersect, intersect, from);\n\n    return vec2.squaredDistance(position, intersect);\n}\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///13\n");

/***/ }),
/* 14 */
/* no static exports found */
/* all exports used */
/*!***********************************************!*\
  !*** ./~/p2/src/equations/ContactEquation.js ***!
  \***********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Equation = __webpack_require__(/*! ./Equation */ 2),\n    vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = ContactEquation;\n\n/**\n * Non-penetration constraint equation. Tries to make the contactPointA and contactPointB vectors coincide, while keeping the applied force repulsive.\n *\n * @class ContactEquation\n * @constructor\n * @extends Equation\n * @param {Body} bodyA\n * @param {Body} bodyB\n */\nfunction ContactEquation(bodyA, bodyB){\n    Equation.call(this, bodyA, bodyB, 0, Number.MAX_VALUE);\n\n    /**\n     * Vector from body i center of mass to the contact point.\n     * @property contactPointA\n     * @type {Array}\n     */\n    this.contactPointA = vec2.create();\n    this.penetrationVec = vec2.create();\n\n    /**\n     * World-oriented vector from body A center of mass to the contact point.\n     * @property contactPointB\n     * @type {Array}\n     */\n    this.contactPointB = vec2.create();\n\n    /**\n     * The normal vector, pointing out of body i\n     * @property normalA\n     * @type {Array}\n     */\n    this.normalA = vec2.create();\n\n    /**\n     * The restitution to use (0=no bounciness, 1=max bounciness).\n     * @property restitution\n     * @type {Number}\n     */\n    this.restitution = 0;\n\n    /**\n     * This property is set to true if this is the first impact between the bodies (not persistant contact).\n     * @property firstImpact\n     * @type {Boolean}\n     * @readOnly\n     */\n    this.firstImpact = false;\n\n    /**\n     * The shape in body i that triggered this contact.\n     * @property shapeA\n     * @type {Shape}\n     */\n    this.shapeA = null;\n\n    /**\n     * The shape in body j that triggered this contact.\n     * @property shapeB\n     * @type {Shape}\n     */\n    this.shapeB = null;\n}\nContactEquation.prototype = new Equation();\nContactEquation.prototype.constructor = ContactEquation;\nContactEquation.prototype.computeB = function(a,b,h){\n    var bi = this.bodyA,\n        bj = this.bodyB,\n        ri = this.contactPointA,\n        rj = this.contactPointB,\n        xi = bi.position,\n        xj = bj.position;\n\n    var penetrationVec = this.penetrationVec,\n        n = this.normalA,\n        G = this.G;\n\n    // Caluclate cross products\n    var rixn = vec2.crossLength(ri,n),\n        rjxn = vec2.crossLength(rj,n);\n\n    // G = [-n -rixn n rjxn]\n    G[0] = -n[0];\n    G[1] = -n[1];\n    G[2] = -rixn;\n    G[3] = n[0];\n    G[4] = n[1];\n    G[5] = rjxn;\n\n    // Calculate q = xj+rj -(xi+ri) i.e. the penetration vector\n    vec2.add(penetrationVec,xj,rj);\n    vec2.sub(penetrationVec,penetrationVec,xi);\n    vec2.sub(penetrationVec,penetrationVec,ri);\n\n    // Compute iteration\n    var GW, Gq;\n    if(this.firstImpact && this.restitution !== 0){\n        Gq = 0;\n        GW = (1/b)*(1+this.restitution) * this.computeGW();\n    } else {\n        Gq = vec2.dot(n,penetrationVec) + this.offset;\n        GW = this.computeGW();\n    }\n\n    var GiMf = this.computeGiMf();\n    var B = - Gq * a - GW * b - h*GiMf;\n\n    return B;\n};\n\nvar vi = vec2.create();\nvar vj = vec2.create();\nvar relVel = vec2.create();\n\n/**\n * Get the relative velocity along the normal vector.\n * @return {number}\n */\nContactEquation.prototype.getVelocityAlongNormal = function(){\n\n    this.bodyA.getVelocityAtPoint(vi, this.contactPointA);\n    this.bodyB.getVelocityAtPoint(vj, this.contactPointB);\n\n    vec2.subtract(relVel, vi, vj);\n\n    return vec2.dot(this.normalA, relVel);\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///14\n");

/***/ }),
/* 15 */
/* no static exports found */
/* all exports used */
/*!*****************************************!*\
  !*** ./~/p2/src/events/EventEmitter.js ***!
  \*****************************************/
/***/ (function(module, exports) {

eval("/**\n * Base class for objects that dispatches events.\n * @class EventEmitter\n * @constructor\n */\nvar EventEmitter = function () {};\n\nmodule.exports = EventEmitter;\n\nEventEmitter.prototype = {\n    constructor: EventEmitter,\n\n    /**\n     * Add an event listener\n     * @method on\n     * @param  {String} type\n     * @param  {Function} listener\n     * @return {EventEmitter} The self object, for chainability.\n     */\n    on: function ( type, listener, context ) {\n        listener.context = context || this;\n        if ( this._listeners === undefined ){\n            this._listeners = {};\n        }\n        var listeners = this._listeners;\n        if ( listeners[ type ] === undefined ) {\n            listeners[ type ] = [];\n        }\n        if ( listeners[ type ].indexOf( listener ) === - 1 ) {\n            listeners[ type ].push( listener );\n        }\n        return this;\n    },\n\n    /**\n     * Check if an event listener is added\n     * @method has\n     * @param  {String} type\n     * @param  {Function} listener\n     * @return {Boolean}\n     */\n    has: function ( type, listener ) {\n        if ( this._listeners === undefined ){\n            return false;\n        }\n        var listeners = this._listeners;\n        if(listener){\n            if ( listeners[ type ] !== undefined && listeners[ type ].indexOf( listener ) !== - 1 ) {\n                return true;\n            }\n        } else {\n            if ( listeners[ type ] !== undefined ) {\n                return true;\n            }\n        }\n\n        return false;\n    },\n\n    /**\n     * Remove an event listener\n     * @method off\n     * @param  {String} type\n     * @param  {Function} listener\n     * @return {EventEmitter} The self object, for chainability.\n     */\n    off: function ( type, listener ) {\n        if ( this._listeners === undefined ){\n            return this;\n        }\n        var listeners = this._listeners;\n        var index = listeners[ type ].indexOf( listener );\n        if ( index !== - 1 ) {\n            listeners[ type ].splice( index, 1 );\n        }\n        return this;\n    },\n\n    /**\n     * Emit an event.\n     * @method emit\n     * @param  {Object} event\n     * @param  {String} event.type\n     * @return {EventEmitter} The self object, for chainability.\n     */\n    emit: function ( event ) {\n        if ( this._listeners === undefined ){\n            return this;\n        }\n        var listeners = this._listeners;\n        var listenerArray = listeners[ event.type ];\n        if ( listenerArray !== undefined ) {\n            event.target = this;\n            for ( var i = 0, l = listenerArray.length; i < l; i ++ ) {\n                var listener = listenerArray[ i ];\n                listener.call( listener.context, event );\n            }\n        }\n        return this;\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///15\n");

/***/ }),
/* 16 */
/* no static exports found */
/* all exports used */
/*!***********************************!*\
  !*** ./~/p2/src/shapes/Circle.js ***!
  \***********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Shape = __webpack_require__(/*! ./Shape */ 3)\n,    vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = Circle;\n\n/**\n * Circle shape class.\n * @class Circle\n * @extends Shape\n * @constructor\n * @param {options} [options] (Note that this options object will be passed on to the {{#crossLink \"Shape\"}}{{/crossLink}} constructor.)\n * @param {number} [options.radius=1] The radius of this circle\n *\n * @example\n *     var circleShape = new Circle({ radius: 1 });\n *     body.addShape(circleShape);\n */\nfunction Circle(options){\n    if(typeof(arguments[0]) === 'number'){\n        options = {\n            radius: arguments[0]\n        };\n        console.warn('The Circle constructor signature has changed. Please use the following format: new Circle({ radius: 1 })');\n    }\n    options = options || {};\n\n    /**\n     * The radius of the circle.\n     * @property radius\n     * @type {number}\n     */\n    this.radius = options.radius || 1;\n\n    options.type = Shape.CIRCLE;\n    Shape.call(this, options);\n}\nCircle.prototype = new Shape();\nCircle.prototype.constructor = Circle;\n\n/**\n * @method computeMomentOfInertia\n * @param  {Number} mass\n * @return {Number}\n */\nCircle.prototype.computeMomentOfInertia = function(mass){\n    var r = this.radius;\n    return mass * r * r / 2;\n};\n\n/**\n * @method updateBoundingRadius\n * @return {Number}\n */\nCircle.prototype.updateBoundingRadius = function(){\n    this.boundingRadius = this.radius;\n};\n\n/**\n * @method updateArea\n * @return {Number}\n */\nCircle.prototype.updateArea = function(){\n    this.area = Math.PI * this.radius * this.radius;\n};\n\n/**\n * @method computeAABB\n * @param  {AABB}   out      The resulting AABB.\n * @param  {Array}  position\n * @param  {Number} angle\n */\nCircle.prototype.computeAABB = function(out, position, angle){\n    var r = this.radius;\n    vec2.set(out.upperBound,  r,  r);\n    vec2.set(out.lowerBound, -r, -r);\n    if(position){\n        vec2.add(out.lowerBound, out.lowerBound, position);\n        vec2.add(out.upperBound, out.upperBound, position);\n    }\n};\n\nvar Ray_intersectSphere_intersectionPoint = vec2.create();\nvar Ray_intersectSphere_normal = vec2.create();\n\n/**\n * @method raycast\n * @param  {RaycastResult} result\n * @param  {Ray} ray\n * @param  {array} position\n * @param  {number} angle\n */\nCircle.prototype.raycast = function(result, ray, position, angle){\n    var from = ray.from,\n        to = ray.to,\n        r = this.radius;\n\n    var a = Math.pow(to[0] - from[0], 2) + Math.pow(to[1] - from[1], 2);\n    var b = 2 * ((to[0] - from[0]) * (from[0] - position[0]) + (to[1] - from[1]) * (from[1] - position[1]));\n    var c = Math.pow(from[0] - position[0], 2) + Math.pow(from[1] - position[1], 2) - Math.pow(r, 2);\n    var delta = Math.pow(b, 2) - 4 * a * c;\n\n    var intersectionPoint = Ray_intersectSphere_intersectionPoint;\n    var normal = Ray_intersectSphere_normal;\n\n    if(delta < 0){\n        // No intersection\n        return;\n\n    } else if(delta === 0){\n        // single intersection point\n        vec2.lerp(intersectionPoint, from, to, delta);\n\n        vec2.sub(normal, intersectionPoint, position);\n        vec2.normalize(normal,normal);\n\n        ray.reportIntersection(result, delta, normal, -1);\n\n    } else {\n        var sqrtDelta = Math.sqrt(delta);\n        var inv2a = 1 / (2 * a);\n        var d1 = (- b - sqrtDelta) * inv2a;\n        var d2 = (- b + sqrtDelta) * inv2a;\n\n        if(d1 >= 0 && d1 <= 1){\n            vec2.lerp(intersectionPoint, from, to, d1);\n\n            vec2.sub(normal, intersectionPoint, position);\n            vec2.normalize(normal,normal);\n\n            ray.reportIntersection(result, d1, normal, -1);\n\n            if(result.shouldStop(ray)){\n                return;\n            }\n        }\n\n        if(d2 >= 0 && d2 <= 1){\n            vec2.lerp(intersectionPoint, from, to, d2);\n\n            vec2.sub(normal, intersectionPoint, position);\n            vec2.normalize(normal,normal);\n\n            ray.reportIntersection(result, d2, normal, -1);\n        }\n    }\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///16\n");

/***/ }),
/* 17 */
/* no static exports found */
/* all exports used */
/*!**************************!*\
  !*** ./src/js/helper.js ***!
  \**************************/
/***/ (function(module, exports) {

eval("function getCursorPosition(canvas, event) {\r\n    var rect = canvas.getBoundingClientRect()\r\n    return {x: event.clientX - rect.left, y: event.clientY - rect.top}\r\n}\r\n\r\nfunction getAverageValue(array) {\r\n    var values = 0\r\n    var average\r\n\r\n    var length = array.length\r\n\r\n    for (var i = 0; i < length; i++) {\r\n        values += array[i]\r\n    }\r\n\r\n    average = values / length\r\n    return average\r\n}\r\n\r\n\r\nfunction getUserMedia() {\r\n    return ( navigator.getUserMedia ||\r\n    navigator.webkitGetUserMedia ||\r\n    navigator.mozGetUserMedia ||\r\n    navigator.msGetUserMedia)\r\n\r\n\r\n}\r\n\r\nfunction getAudioContext() {\r\n    return ( window.AudioContext ||\r\n    window.webkitAudioContext ||\r\n    window.mozAudioContext ||\r\n    window.msAudioContext)\r\n}\r\nmodule.exports = {\r\n    getCursorPosition: getCursorPosition,\r\n    getAverageValue: getAverageValue,\r\n    getUserMedia: getUserMedia,\r\n    getAudioContext: getAudioContext\r\n}\r\n\r\n\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTcuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9zcmMvanMvaGVscGVyLmpzPzY2MzIiXSwic291cmNlc0NvbnRlbnQiOlsiZnVuY3Rpb24gZ2V0Q3Vyc29yUG9zaXRpb24oY2FudmFzLCBldmVudCkge1xyXG4gICAgdmFyIHJlY3QgPSBjYW52YXMuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KClcclxuICAgIHJldHVybiB7eDogZXZlbnQuY2xpZW50WCAtIHJlY3QubGVmdCwgeTogZXZlbnQuY2xpZW50WSAtIHJlY3QudG9wfVxyXG59XHJcblxyXG5mdW5jdGlvbiBnZXRBdmVyYWdlVmFsdWUoYXJyYXkpIHtcclxuICAgIHZhciB2YWx1ZXMgPSAwXHJcbiAgICB2YXIgYXZlcmFnZVxyXG5cclxuICAgIHZhciBsZW5ndGggPSBhcnJheS5sZW5ndGhcclxuXHJcbiAgICBmb3IgKHZhciBpID0gMDsgaSA8IGxlbmd0aDsgaSsrKSB7XHJcbiAgICAgICAgdmFsdWVzICs9IGFycmF5W2ldXHJcbiAgICB9XHJcblxyXG4gICAgYXZlcmFnZSA9IHZhbHVlcyAvIGxlbmd0aFxyXG4gICAgcmV0dXJuIGF2ZXJhZ2VcclxufVxyXG5cclxuXHJcbmZ1bmN0aW9uIGdldFVzZXJNZWRpYSgpIHtcclxuICAgIHJldHVybiAoIG5hdmlnYXRvci5nZXRVc2VyTWVkaWEgfHxcclxuICAgIG5hdmlnYXRvci53ZWJraXRHZXRVc2VyTWVkaWEgfHxcclxuICAgIG5hdmlnYXRvci5tb3pHZXRVc2VyTWVkaWEgfHxcclxuICAgIG5hdmlnYXRvci5tc0dldFVzZXJNZWRpYSlcclxuXHJcblxyXG59XHJcblxyXG5mdW5jdGlvbiBnZXRBdWRpb0NvbnRleHQoKSB7XHJcbiAgICByZXR1cm4gKCB3aW5kb3cuQXVkaW9Db250ZXh0IHx8XHJcbiAgICB3aW5kb3cud2Via2l0QXVkaW9Db250ZXh0IHx8XHJcbiAgICB3aW5kb3cubW96QXVkaW9Db250ZXh0IHx8XHJcbiAgICB3aW5kb3cubXNBdWRpb0NvbnRleHQpXHJcbn1cclxubW9kdWxlLmV4cG9ydHMgPSB7XHJcbiAgICBnZXRDdXJzb3JQb3NpdGlvbjogZ2V0Q3Vyc29yUG9zaXRpb24sXHJcbiAgICBnZXRBdmVyYWdlVmFsdWU6IGdldEF2ZXJhZ2VWYWx1ZSxcclxuICAgIGdldFVzZXJNZWRpYTogZ2V0VXNlck1lZGlhLFxyXG4gICAgZ2V0QXVkaW9Db250ZXh0OiBnZXRBdWRpb0NvbnRleHRcclxufVxyXG5cclxuXHJcblxuXG5cbi8vLy8vLy8vLy8vLy8vLy8vL1xuLy8gV0VCUEFDSyBGT09URVJcbi8vIC4vc3JjL2pzL2hlbHBlci5qc1xuLy8gbW9kdWxlIGlkID0gMTdcbi8vIG1vZHVsZSBjaHVua3MgPSAwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///17\n");

/***/ }),
/* 18 */
/* no static exports found */
/* all exports used */
/*!*********************************************!*\
  !*** ./~/p2/src/collision/RaycastResult.js ***!
  \*********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\nvar Ray = __webpack_require__(/*! ../collision/Ray */ 13);\n\nmodule.exports = RaycastResult;\n\n/**\n * Storage for Ray casting hit data.\n * @class RaycastResult\n * @constructor\n */\nfunction RaycastResult(){\n\n\t/**\n\t * The normal of the hit, oriented in world space.\n\t * @property {array} normal\n\t */\n\tthis.normal = vec2.create();\n\n\t/**\n\t * The hit shape, or null.\n\t * @property {Shape} shape\n\t */\n\tthis.shape = null;\n\n\t/**\n\t * The hit body, or null.\n\t * @property {Body} body\n\t */\n\tthis.body = null;\n\n\t/**\n\t * The index of the hit triangle, if the hit shape was indexable.\n\t * @property {number} faceIndex\n\t * @default -1\n\t */\n\tthis.faceIndex = -1;\n\n\t/**\n\t * Distance to the hit, as a fraction. 0 is at the \"from\" point, 1 is at the \"to\" point. Will be set to -1 if there was no hit yet.\n\t * @property {number} fraction\n\t * @default -1\n\t */\n\tthis.fraction = -1;\n\n\t/**\n\t * If the ray should stop traversing.\n\t * @readonly\n\t * @property {Boolean} isStopped\n\t */\n\tthis.isStopped = false;\n}\n\n/**\n * Reset all result data. Must be done before re-using the result object.\n * @method reset\n */\nRaycastResult.prototype.reset = function () {\n\tvec2.set(this.normal, 0, 0);\n\tthis.shape = null;\n\tthis.body = null;\n\tthis.faceIndex = -1;\n\tthis.fraction = -1;\n\tthis.isStopped = false;\n};\n\n/**\n * Get the distance to the hit point.\n * @method getHitDistance\n * @param {Ray} ray\n */\nRaycastResult.prototype.getHitDistance = function (ray) {\n\treturn vec2.distance(ray.from, ray.to) * this.fraction;\n};\n\n/**\n * Returns true if the ray hit something since the last reset().\n * @method hasHit\n */\nRaycastResult.prototype.hasHit = function () {\n\treturn this.fraction !== -1;\n};\n\n/**\n * Get world hit point.\n * @method getHitPoint\n * @param {array} out\n * @param {Ray} ray\n */\nRaycastResult.prototype.getHitPoint = function (out, ray) {\n\tvec2.lerp(out, ray.from, ray.to, this.fraction);\n};\n\n/**\n * Can be called while iterating over hits to stop searching for hit points.\n * @method stop\n */\nRaycastResult.prototype.stop = function(){\n\tthis.isStopped = true;\n};\n\n/**\n * @method shouldStop\n * @private\n * @param {Ray} ray\n * @return {boolean}\n */\nRaycastResult.prototype.shouldStop = function(ray){\n\treturn this.isStopped || (this.fraction !== -1 && ray.mode === Ray.ANY);\n};\n\n/**\n * @method set\n * @private\n * @param {array} normal\n * @param {Shape} shape\n * @param {Body} body\n * @param {number} fraction\n */\nRaycastResult.prototype.set = function(\n\tnormal,\n\tshape,\n\tbody,\n\tfraction,\n\tfaceIndex\n){\n\tvec2.copy(this.normal, normal);\n\tthis.shape = shape;\n\tthis.body = body;\n\tthis.fraction = fraction;\n\tthis.faceIndex = faceIndex;\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///18\n");

/***/ }),
/* 19 */
/* no static exports found */
/* all exports used */
/*!***************************************!*\
  !*** ./~/p2/src/material/Material.js ***!
  \***************************************/
/***/ (function(module, exports) {

eval("module.exports = Material;\n\n/**\n * Defines a physics material.\n * @class Material\n * @constructor\n * @param {number} id Material identifier\n * @author schteppe\n */\nfunction Material(id){\n    /**\n     * The material identifier\n     * @property id\n     * @type {Number}\n     */\n    this.id = id || Material.idCounter++;\n}\n\nMaterial.idCounter = 0;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTkuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy9tYXRlcmlhbC9NYXRlcmlhbC5qcz83MjNlIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gTWF0ZXJpYWw7XG5cbi8qKlxuICogRGVmaW5lcyBhIHBoeXNpY3MgbWF0ZXJpYWwuXG4gKiBAY2xhc3MgTWF0ZXJpYWxcbiAqIEBjb25zdHJ1Y3RvclxuICogQHBhcmFtIHtudW1iZXJ9IGlkIE1hdGVyaWFsIGlkZW50aWZpZXJcbiAqIEBhdXRob3Igc2NodGVwcGVcbiAqL1xuZnVuY3Rpb24gTWF0ZXJpYWwoaWQpe1xuICAgIC8qKlxuICAgICAqIFRoZSBtYXRlcmlhbCBpZGVudGlmaWVyXG4gICAgICogQHByb3BlcnR5IGlkXG4gICAgICogQHR5cGUge051bWJlcn1cbiAgICAgKi9cbiAgICB0aGlzLmlkID0gaWQgfHwgTWF0ZXJpYWwuaWRDb3VudGVyKys7XG59XG5cbk1hdGVyaWFsLmlkQ291bnRlciA9IDA7XG5cblxuXG4vLy8vLy8vLy8vLy8vLy8vLy9cbi8vIFdFQlBBQ0sgRk9PVEVSXG4vLyAuL34vcDIvc3JjL21hdGVyaWFsL01hdGVyaWFsLmpzXG4vLyBtb2R1bGUgaWQgPSAxOVxuLy8gbW9kdWxlIGNodW5rcyA9IDAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///19\n");

/***/ }),
/* 20 */
/* no static exports found */
/* all exports used */
/*!************************************!*\
  !*** ./~/p2/src/objects/Spring.js ***!
  \************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\nvar Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\nmodule.exports = Spring;\n\n/**\n * A spring, connecting two bodies. The Spring explicitly adds force and angularForce to the bodies and does therefore not put load on the constraint solver.\n *\n * @class Spring\n * @constructor\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {Object} [options]\n * @param {number} [options.stiffness=100]  Spring constant (see Hookes Law). A number >= 0.\n * @param {number} [options.damping=1]      A number >= 0. Default: 1\n * @param {Array}  [options.localAnchorA]   Where to hook the spring to body A, in local body coordinates. Defaults to the body center.\n * @param {Array}  [options.localAnchorB]\n * @param {Array}  [options.worldAnchorA]   Where to hook the spring to body A, in world coordinates. Overrides the option \"localAnchorA\" if given.\n * @param {Array}  [options.worldAnchorB]\n */\nfunction Spring(bodyA, bodyB, options){\n    options = Utils.defaults(options,{\n        stiffness: 100,\n        damping: 1,\n    });\n\n    /**\n     * Stiffness of the spring.\n     * @property stiffness\n     * @type {number}\n     */\n    this.stiffness = options.stiffness;\n\n    /**\n     * Damping of the spring.\n     * @property damping\n     * @type {number}\n     */\n    this.damping = options.damping;\n\n    /**\n     * First connected body.\n     * @property bodyA\n     * @type {Body}\n     */\n    this.bodyA = bodyA;\n\n    /**\n     * Second connected body.\n     * @property bodyB\n     * @type {Body}\n     */\n    this.bodyB = bodyB;\n}\n\n/**\n * Apply the spring force to the connected bodies.\n * @method applyForce\n */\nSpring.prototype.applyForce = function(){\n    // To be implemented by subclasses\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///20\n");

/***/ }),
/* 21 */
/* no static exports found */
/* all exports used */
/*!*************************************!*\
  !*** ./~/p2/src/shapes/Particle.js ***!
  \*************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Shape = __webpack_require__(/*! ./Shape */ 3)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = Particle;\n\n/**\n * Particle shape class.\n * @class Particle\n * @constructor\n * @param {object} [options] (Note that this options object will be passed on to the {{#crossLink \"Shape\"}}{{/crossLink}} constructor.)\n * @extends Shape\n */\nfunction Particle(options){\n    options = options || {};\n\toptions.type = Shape.PARTICLE;\n    Shape.call(this, options);\n}\nParticle.prototype = new Shape();\nParticle.prototype.constructor = Particle;\n\nParticle.prototype.computeMomentOfInertia = function(mass){\n    return 0; // Can't rotate a particle\n};\n\nParticle.prototype.updateBoundingRadius = function(){\n    this.boundingRadius = 0;\n};\n\n/**\n * @method computeAABB\n * @param  {AABB}   out\n * @param  {Array}  position\n * @param  {Number} angle\n */\nParticle.prototype.computeAABB = function(out, position, angle){\n    vec2.copy(out.lowerBound, position);\n    vec2.copy(out.upperBound, position);\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjEuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy9zaGFwZXMvUGFydGljbGUuanM/ZjlhYSJdLCJzb3VyY2VzQ29udGVudCI6WyJ2YXIgU2hhcGUgPSByZXF1aXJlKCcuL1NoYXBlJylcbiwgICB2ZWMyID0gcmVxdWlyZSgnLi4vbWF0aC92ZWMyJyk7XG5cbm1vZHVsZS5leHBvcnRzID0gUGFydGljbGU7XG5cbi8qKlxuICogUGFydGljbGUgc2hhcGUgY2xhc3MuXG4gKiBAY2xhc3MgUGFydGljbGVcbiAqIEBjb25zdHJ1Y3RvclxuICogQHBhcmFtIHtvYmplY3R9IFtvcHRpb25zXSAoTm90ZSB0aGF0IHRoaXMgb3B0aW9ucyBvYmplY3Qgd2lsbCBiZSBwYXNzZWQgb24gdG8gdGhlIHt7I2Nyb3NzTGluayBcIlNoYXBlXCJ9fXt7L2Nyb3NzTGlua319IGNvbnN0cnVjdG9yLilcbiAqIEBleHRlbmRzIFNoYXBlXG4gKi9cbmZ1bmN0aW9uIFBhcnRpY2xlKG9wdGlvbnMpe1xuICAgIG9wdGlvbnMgPSBvcHRpb25zIHx8IHt9O1xuXHRvcHRpb25zLnR5cGUgPSBTaGFwZS5QQVJUSUNMRTtcbiAgICBTaGFwZS5jYWxsKHRoaXMsIG9wdGlvbnMpO1xufVxuUGFydGljbGUucHJvdG90eXBlID0gbmV3IFNoYXBlKCk7XG5QYXJ0aWNsZS5wcm90b3R5cGUuY29uc3RydWN0b3IgPSBQYXJ0aWNsZTtcblxuUGFydGljbGUucHJvdG90eXBlLmNvbXB1dGVNb21lbnRPZkluZXJ0aWEgPSBmdW5jdGlvbihtYXNzKXtcbiAgICByZXR1cm4gMDsgLy8gQ2FuJ3Qgcm90YXRlIGEgcGFydGljbGVcbn07XG5cblBhcnRpY2xlLnByb3RvdHlwZS51cGRhdGVCb3VuZGluZ1JhZGl1cyA9IGZ1bmN0aW9uKCl7XG4gICAgdGhpcy5ib3VuZGluZ1JhZGl1cyA9IDA7XG59O1xuXG4vKipcbiAqIEBtZXRob2QgY29tcHV0ZUFBQkJcbiAqIEBwYXJhbSAge0FBQkJ9ICAgb3V0XG4gKiBAcGFyYW0gIHtBcnJheX0gIHBvc2l0aW9uXG4gKiBAcGFyYW0gIHtOdW1iZXJ9IGFuZ2xlXG4gKi9cblBhcnRpY2xlLnByb3RvdHlwZS5jb21wdXRlQUFCQiA9IGZ1bmN0aW9uKG91dCwgcG9zaXRpb24sIGFuZ2xlKXtcbiAgICB2ZWMyLmNvcHkob3V0Lmxvd2VyQm91bmQsIHBvc2l0aW9uKTtcbiAgICB2ZWMyLmNvcHkob3V0LnVwcGVyQm91bmQsIHBvc2l0aW9uKTtcbn07XG5cblxuXG4vLy8vLy8vLy8vLy8vLy8vLy9cbi8vIFdFQlBBQ0sgRk9PVEVSXG4vLyAuL34vcDIvc3JjL3NoYXBlcy9QYXJ0aWNsZS5qc1xuLy8gbW9kdWxlIGlkID0gMjFcbi8vIG1vZHVsZSBjaHVua3MgPSAwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///21\n");

/***/ }),
/* 22 */
/* no static exports found */
/* all exports used */
/*!**********************************!*\
  !*** ./~/p2/src/shapes/Plane.js ***!
  \**********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Shape =  __webpack_require__(/*! ./Shape */ 3)\n,    vec2 =  __webpack_require__(/*! ../math/vec2 */ 0)\n,    Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\nmodule.exports = Plane;\n\n/**\n * Plane shape class. The plane is facing in the Y direction.\n * @class Plane\n * @extends Shape\n * @constructor\n * @param {object} [options] (Note that this options object will be passed on to the {{#crossLink \"Shape\"}}{{/crossLink}} constructor.)\n */\nfunction Plane(options){\n    options = options || {};\n    options.type = Shape.PLANE;\n    Shape.call(this, options);\n}\nPlane.prototype = new Shape();\nPlane.prototype.constructor = Plane;\n\n/**\n * Compute moment of inertia\n * @method computeMomentOfInertia\n */\nPlane.prototype.computeMomentOfInertia = function(mass){\n    return 0; // Plane is infinite. The inertia should therefore be infinty but by convention we set 0 here\n};\n\n/**\n * Update the bounding radius\n * @method updateBoundingRadius\n */\nPlane.prototype.updateBoundingRadius = function(){\n    this.boundingRadius = Number.MAX_VALUE;\n};\n\n/**\n * @method computeAABB\n * @param  {AABB}   out\n * @param  {Array}  position\n * @param  {Number} angle\n */\nPlane.prototype.computeAABB = function(out, position, angle){\n    var a = angle % (2 * Math.PI);\n    var set = vec2.set;\n    var max = 1e7;\n    var lowerBound = out.lowerBound;\n    var upperBound = out.upperBound;\n\n    // Set max bounds\n    set(lowerBound, -max, -max);\n    set(upperBound,  max,  max);\n\n    if(a === 0){\n        // y goes from -inf to 0\n        upperBound[1] = 0;\n        // set(lowerBound, -max, -max);\n        // set(upperBound,  max,  0);\n\n    } else if(a === Math.PI / 2){\n\n        // x goes from 0 to inf\n        lowerBound[0] = 0;\n        // set(lowerBound, 0, -max);\n        // set(upperBound,      max,  max);\n\n    } else if(a === Math.PI){\n\n        // y goes from 0 to inf\n        lowerBound[1] = 0;\n        // set(lowerBound, -max, 0);\n        // set(upperBound,  max, max);\n\n    } else if(a === 3*Math.PI/2){\n\n        // x goes from -inf to 0\n        upperBound[0] = 0;\n        // set(lowerBound, -max,     -max);\n        // set(upperBound,  0,  max);\n\n    }\n};\n\nPlane.prototype.updateArea = function(){\n    this.area = Number.MAX_VALUE;\n};\n\nvar intersectPlane_planePointToFrom = vec2.create();\nvar intersectPlane_dir_scaled_with_t = vec2.create();\nvar intersectPlane_hitPoint = vec2.create();\nvar intersectPlane_normal = vec2.create();\nvar intersectPlane_len = vec2.create();\n\n/**\n * @method raycast\n * @param  {RayResult} result\n * @param  {Ray} ray\n * @param  {array} position\n * @param  {number} angle\n */\nPlane.prototype.raycast = function(result, ray, position, angle){\n    var from = ray.from;\n    var to = ray.to;\n    var direction = ray.direction;\n    var planePointToFrom = intersectPlane_planePointToFrom;\n    var dir_scaled_with_t = intersectPlane_dir_scaled_with_t;\n    var hitPoint = intersectPlane_hitPoint;\n    var normal = intersectPlane_normal;\n    var len = intersectPlane_len;\n\n    // Get plane normal\n    vec2.set(normal, 0, 1);\n    vec2.rotate(normal, normal, angle);\n\n    vec2.sub(len, from, position);\n    var planeToFrom = vec2.dot(len, normal);\n    vec2.sub(len, to, position);\n    var planeToTo = vec2.dot(len, normal);\n\n    if(planeToFrom * planeToTo > 0){\n        // \"from\" and \"to\" are on the same side of the plane... bail out\n        return;\n    }\n\n    if(vec2.squaredDistance(from, to) < planeToFrom * planeToFrom){\n        return;\n    }\n\n    var n_dot_dir = vec2.dot(normal, direction);\n\n    vec2.sub(planePointToFrom, from, position);\n    var t = -vec2.dot(normal, planePointToFrom) / n_dot_dir / ray.length;\n\n    ray.reportIntersection(result, t, normal, -1);\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///22\n");

/***/ }),
/* 23 */
/* no static exports found */
/* all exports used */
/*!***********************************!*\
  !*** ./~/p2/src/solver/Solver.js ***!
  \***********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Utils = __webpack_require__(/*! ../utils/Utils */ 1)\n,   EventEmitter = __webpack_require__(/*! ../events/EventEmitter */ 15);\n\nmodule.exports = Solver;\n\n/**\n * Base class for constraint solvers.\n * @class Solver\n * @constructor\n * @extends EventEmitter\n */\nfunction Solver(options,type){\n    options = options || {};\n\n    EventEmitter.call(this);\n\n    this.type = type;\n\n    /**\n     * Current equations in the solver.\n     *\n     * @property equations\n     * @type {Array}\n     */\n    this.equations = [];\n\n    /**\n     * Function that is used to sort all equations before each solve.\n     * @property equationSortFunction\n     * @type {function|boolean}\n     */\n    this.equationSortFunction = options.equationSortFunction || false;\n}\nSolver.prototype = new EventEmitter();\nSolver.prototype.constructor = Solver;\n\n/**\n * Method to be implemented in each subclass\n * @method solve\n * @param  {Number} dt\n * @param  {World} world\n */\nSolver.prototype.solve = function(dt,world){\n    throw new Error(\"Solver.solve should be implemented by subclasses!\");\n};\n\nvar mockWorld = {bodies:[]};\n\n/**\n * Solves all constraints in an island.\n * @method solveIsland\n * @param  {Number} dt\n * @param  {Island} island\n */\nSolver.prototype.solveIsland = function(dt,island){\n\n    this.removeAllEquations();\n\n    if(island.equations.length){\n        // Add equations to solver\n        this.addEquations(island.equations);\n        mockWorld.bodies.length = 0;\n        island.getBodies(mockWorld.bodies);\n\n        // Solve\n        if(mockWorld.bodies.length){\n            this.solve(dt,mockWorld);\n        }\n    }\n};\n\n/**\n * Sort all equations using the .equationSortFunction. Should be called by subclasses before solving.\n * @method sortEquations\n */\nSolver.prototype.sortEquations = function(){\n    if(this.equationSortFunction){\n        this.equations.sort(this.equationSortFunction);\n    }\n};\n\n/**\n * Add an equation to be solved.\n *\n * @method addEquation\n * @param {Equation} eq\n */\nSolver.prototype.addEquation = function(eq){\n    if(eq.enabled){\n        this.equations.push(eq);\n    }\n};\n\n/**\n * Add equations. Same as .addEquation, but this time the argument is an array of Equations\n *\n * @method addEquations\n * @param {Array} eqs\n */\nSolver.prototype.addEquations = function(eqs){\n    //Utils.appendArray(this.equations,eqs);\n    for(var i=0, N=eqs.length; i!==N; i++){\n        var eq = eqs[i];\n        if(eq.enabled){\n            this.equations.push(eq);\n        }\n    }\n};\n\n/**\n * Remove an equation.\n *\n * @method removeEquation\n * @param {Equation} eq\n */\nSolver.prototype.removeEquation = function(eq){\n    var i = this.equations.indexOf(eq);\n    if(i !== -1){\n        this.equations.splice(i,1);\n    }\n};\n\n/**\n * Remove all currently added equations.\n *\n * @method removeAllEquations\n */\nSolver.prototype.removeAllEquations = function(){\n    this.equations.length=0;\n};\n\nSolver.GS = 1;\nSolver.ISLAND = 2;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///23\n");

/***/ }),
/* 24 */
/* no static exports found */
/* all exports used */
/*!***************************!*\
  !*** ./~/p2/package.json ***!
  \***************************/
/***/ (function(module, exports) {

eval("module.exports = {\"_args\":[[\"p2@^0.7.1\",\"C:\\\\ARBEIT\\\\froso\\\\laserapi\"]],\"_from\":\"p2@>=0.7.1 <0.8.0\",\"_id\":\"p2@0.7.1\",\"_inCache\":true,\"_installable\":true,\"_location\":\"/p2\",\"_nodeVersion\":\"4.2.2\",\"_npmUser\":{\"email\":\"schteppe@gmail.com\",\"name\":\"schteppe\"},\"_npmVersion\":\"2.14.7\",\"_phantomChildren\":{},\"_requested\":{\"name\":\"p2\",\"raw\":\"p2@^0.7.1\",\"rawSpec\":\"^0.7.1\",\"scope\":null,\"spec\":\">=0.7.1 <0.8.0\",\"type\":\"range\"},\"_requiredBy\":[\"/\"],\"_resolved\":\"http://registry.npmjs.org/p2/-/p2-0.7.1.tgz\",\"_shasum\":\"25f2474d9bc3a6d3140a1da26a67c9e118ac9543\",\"_shrinkwrap\":null,\"_spec\":\"p2@^0.7.1\",\"_where\":\"C:\\\\ARBEIT\\\\froso\\\\laserapi\",\"author\":{\"email\":\"schteppe@gmail.com\",\"name\":\"Stefan Hedman\",\"url\":\"http://steffe.se\"},\"bugs\":{\"url\":\"https://github.com/schteppe/p2.js/issues\"},\"dependencies\":{\"poly-decomp\":\"0.1.1\"},\"description\":\"A JavaScript 2D physics engine.\",\"devDependencies\":{\"grunt\":\"^0.4.5\",\"grunt-browserify\":\"~2.0.1\",\"grunt-contrib-concat\":\"^0.4.0\",\"grunt-contrib-jshint\":\"^0.11.2\",\"grunt-contrib-nodeunit\":\"^0.4.1\",\"grunt-contrib-uglify\":\"~0.4.0\",\"grunt-contrib-watch\":\"~0.5.0\"},\"directories\":{},\"dist\":{\"shasum\":\"25f2474d9bc3a6d3140a1da26a67c9e118ac9543\",\"tarball\":\"https://registry.npmjs.org/p2/-/p2-0.7.1.tgz\"},\"engines\":{\"node\":\"*\"},\"gitHead\":\"d83c483f912362fd6e57c74b0634ea3f1f3e0c82\",\"homepage\":\"https://github.com/schteppe/p2.js#readme\",\"keywords\":[\"2d\",\"engine\",\"p2\",\"p2.js\",\"physics\"],\"licenses\":[{\"type\":\"MIT\"}],\"main\":\"./src/p2.js\",\"maintainers\":[{\"name\":\"schteppe\",\"email\":\"schteppe@gmail.com\"}],\"name\":\"p2\",\"optionalDependencies\":{},\"readme\":\"ERROR: No README data found!\",\"repository\":{\"type\":\"git\",\"url\":\"git+https://github.com/schteppe/p2.js.git\"},\"scripts\":{},\"version\":\"0.7.1\"}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///24\n");

/***/ }),
/* 25 */
/* no static exports found */
/* all exports used */
/*!*******************************************!*\
  !*** ./~/p2/src/collision/Narrowphase.js ***!
  \*******************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   sub = vec2.sub\n,   add = vec2.add\n,   dot = vec2.dot\n,   Utils = __webpack_require__(/*! ../utils/Utils */ 1)\n,   ContactEquationPool = __webpack_require__(/*! ../utils/ContactEquationPool */ 42)\n,   FrictionEquationPool = __webpack_require__(/*! ../utils/FrictionEquationPool */ 43)\n,   TupleDictionary = __webpack_require__(/*! ../utils/TupleDictionary */ 45)\n,   Equation = __webpack_require__(/*! ../equations/Equation */ 2)\n,   ContactEquation = __webpack_require__(/*! ../equations/ContactEquation */ 14)\n,   FrictionEquation = __webpack_require__(/*! ../equations/FrictionEquation */ 9)\n,   Circle = __webpack_require__(/*! ../shapes/Circle */ 16)\n,   Convex = __webpack_require__(/*! ../shapes/Convex */ 10)\n,   Shape = __webpack_require__(/*! ../shapes/Shape */ 3)\n,   Body = __webpack_require__(/*! ../objects/Body */ 7)\n,   Box = __webpack_require__(/*! ../shapes/Box */ 38);\n\nmodule.exports = Narrowphase;\n\n// Temp things\nvar yAxis = vec2.fromValues(0,1);\n\nvar tmp1 = vec2.fromValues(0,0)\n,   tmp2 = vec2.fromValues(0,0)\n,   tmp3 = vec2.fromValues(0,0)\n,   tmp4 = vec2.fromValues(0,0)\n,   tmp5 = vec2.fromValues(0,0)\n,   tmp6 = vec2.fromValues(0,0)\n,   tmp7 = vec2.fromValues(0,0)\n,   tmp8 = vec2.fromValues(0,0)\n,   tmp9 = vec2.fromValues(0,0)\n,   tmp10 = vec2.fromValues(0,0)\n,   tmp11 = vec2.fromValues(0,0)\n,   tmp12 = vec2.fromValues(0,0)\n,   tmp13 = vec2.fromValues(0,0)\n,   tmp14 = vec2.fromValues(0,0)\n,   tmp15 = vec2.fromValues(0,0)\n,   tmp16 = vec2.fromValues(0,0)\n,   tmp17 = vec2.fromValues(0,0)\n,   tmp18 = vec2.fromValues(0,0)\n,   tmpArray = [];\n\n/**\n * Narrowphase. Creates contacts and friction given shapes and transforms.\n * @class Narrowphase\n * @constructor\n */\nfunction Narrowphase(){\n\n    /**\n     * @property contactEquations\n     * @type {Array}\n     */\n    this.contactEquations = [];\n\n    /**\n     * @property frictionEquations\n     * @type {Array}\n     */\n    this.frictionEquations = [];\n\n    /**\n     * Whether to make friction equations in the upcoming contacts.\n     * @property enableFriction\n     * @type {Boolean}\n     */\n    this.enableFriction = true;\n\n    /**\n     * Whether to make equations enabled in upcoming contacts.\n     * @property enabledEquations\n     * @type {Boolean}\n     */\n    this.enabledEquations = true;\n\n    /**\n     * The friction slip force to use when creating friction equations.\n     * @property slipForce\n     * @type {Number}\n     */\n    this.slipForce = 10.0;\n\n    /**\n     * The friction value to use in the upcoming friction equations.\n     * @property frictionCoefficient\n     * @type {Number}\n     */\n    this.frictionCoefficient = 0.3;\n\n    /**\n     * Will be the .relativeVelocity in each produced FrictionEquation.\n     * @property {Number} surfaceVelocity\n     */\n    this.surfaceVelocity = 0;\n\n    /**\n     * Keeps track of the allocated ContactEquations.\n     * @property {ContactEquationPool} contactEquationPool\n     *\n     * @example\n     *\n     *     // Allocate a few equations before starting the simulation.\n     *     // This way, no contact objects need to be created on the fly in the game loop.\n     *     world.narrowphase.contactEquationPool.resize(1024);\n     *     world.narrowphase.frictionEquationPool.resize(1024);\n     */\n    this.contactEquationPool = new ContactEquationPool({ size: 32 });\n\n    /**\n     * Keeps track of the allocated ContactEquations.\n     * @property {FrictionEquationPool} frictionEquationPool\n     */\n    this.frictionEquationPool = new FrictionEquationPool({ size: 64 });\n\n    /**\n     * The restitution value to use in the next contact equations.\n     * @property restitution\n     * @type {Number}\n     */\n    this.restitution = 0;\n\n    /**\n     * The stiffness value to use in the next contact equations.\n     * @property {Number} stiffness\n     */\n    this.stiffness = Equation.DEFAULT_STIFFNESS;\n\n    /**\n     * The stiffness value to use in the next contact equations.\n     * @property {Number} stiffness\n     */\n    this.relaxation = Equation.DEFAULT_RELAXATION;\n\n    /**\n     * The stiffness value to use in the next friction equations.\n     * @property frictionStiffness\n     * @type {Number}\n     */\n    this.frictionStiffness = Equation.DEFAULT_STIFFNESS;\n\n    /**\n     * The relaxation value to use in the next friction equations.\n     * @property frictionRelaxation\n     * @type {Number}\n     */\n    this.frictionRelaxation = Equation.DEFAULT_RELAXATION;\n\n    /**\n     * Enable reduction of friction equations. If disabled, a box on a plane will generate 2 contact equations and 2 friction equations. If enabled, there will be only one friction equation. Same kind of simplifications are made  for all collision types.\n     * @property enableFrictionReduction\n     * @type {Boolean}\n     * @deprecated This flag will be removed when the feature is stable enough.\n     * @default true\n     */\n    this.enableFrictionReduction = true;\n\n    /**\n     * Keeps track of the colliding bodies last step.\n     * @private\n     * @property collidingBodiesLastStep\n     * @type {TupleDictionary}\n     */\n    this.collidingBodiesLastStep = new TupleDictionary();\n\n    /**\n     * Contact skin size value to use in the next contact equations.\n     * @property {Number} contactSkinSize\n     * @default 0.01\n     */\n    this.contactSkinSize = 0.01;\n}\n\nvar bodiesOverlap_shapePositionA = vec2.create();\nvar bodiesOverlap_shapePositionB = vec2.create();\n\n/**\n * @method bodiesOverlap\n * @param  {Body} bodyA\n * @param  {Body} bodyB\n * @return {Boolean}\n * @todo shape world transforms are wrong\n */\nNarrowphase.prototype.bodiesOverlap = function(bodyA, bodyB){\n    var shapePositionA = bodiesOverlap_shapePositionA;\n    var shapePositionB = bodiesOverlap_shapePositionB;\n\n    // Loop over all shapes of bodyA\n    for(var k=0, Nshapesi=bodyA.shapes.length; k!==Nshapesi; k++){\n        var shapeA = bodyA.shapes[k];\n\n        bodyA.toWorldFrame(shapePositionA, shapeA.position);\n\n        // All shapes of body j\n        for(var l=0, Nshapesj=bodyB.shapes.length; l!==Nshapesj; l++){\n            var shapeB = bodyB.shapes[l];\n\n            bodyB.toWorldFrame(shapePositionB, shapeB.position);\n\n            if(this[shapeA.type | shapeB.type](\n                bodyA,\n                shapeA,\n                shapePositionA,\n                shapeA.angle + bodyA.angle,\n                bodyB,\n                shapeB,\n                shapePositionB,\n                shapeB.angle + bodyB.angle,\n                true\n            )){\n                return true;\n            }\n        }\n    }\n\n    return false;\n};\n\n/**\n * Check if the bodies were in contact since the last reset().\n * @method collidedLastStep\n * @param  {Body} bodyA\n * @param  {Body} bodyB\n * @return {Boolean}\n */\nNarrowphase.prototype.collidedLastStep = function(bodyA, bodyB){\n    var id1 = bodyA.id|0,\n        id2 = bodyB.id|0;\n    return !!this.collidingBodiesLastStep.get(id1, id2);\n};\n\n/**\n * Throws away the old equations and gets ready to create new\n * @method reset\n */\nNarrowphase.prototype.reset = function(){\n    this.collidingBodiesLastStep.reset();\n\n    var eqs = this.contactEquations;\n    var l = eqs.length;\n    while(l--){\n        var eq = eqs[l],\n            id1 = eq.bodyA.id,\n            id2 = eq.bodyB.id;\n        this.collidingBodiesLastStep.set(id1, id2, true);\n    }\n\n    var ce = this.contactEquations,\n        fe = this.frictionEquations;\n    for(var i=0; i<ce.length; i++){\n        this.contactEquationPool.release(ce[i]);\n    }\n    for(var i=0; i<fe.length; i++){\n        this.frictionEquationPool.release(fe[i]);\n    }\n\n    // Reset\n    this.contactEquations.length = this.frictionEquations.length = 0;\n};\n\n/**\n * Creates a ContactEquation, either by reusing an existing object or creating a new one.\n * @method createContactEquation\n * @param  {Body} bodyA\n * @param  {Body} bodyB\n * @return {ContactEquation}\n */\nNarrowphase.prototype.createContactEquation = function(bodyA, bodyB, shapeA, shapeB){\n    var c = this.contactEquationPool.get();\n    c.bodyA = bodyA;\n    c.bodyB = bodyB;\n    c.shapeA = shapeA;\n    c.shapeB = shapeB;\n    c.restitution = this.restitution;\n    c.firstImpact = !this.collidedLastStep(bodyA,bodyB);\n    c.stiffness = this.stiffness;\n    c.relaxation = this.relaxation;\n    c.needsUpdate = true;\n    c.enabled = this.enabledEquations;\n    c.offset = this.contactSkinSize;\n\n    return c;\n};\n\n/**\n * Creates a FrictionEquation, either by reusing an existing object or creating a new one.\n * @method createFrictionEquation\n * @param  {Body} bodyA\n * @param  {Body} bodyB\n * @return {FrictionEquation}\n */\nNarrowphase.prototype.createFrictionEquation = function(bodyA, bodyB, shapeA, shapeB){\n    var c = this.frictionEquationPool.get();\n    c.bodyA = bodyA;\n    c.bodyB = bodyB;\n    c.shapeA = shapeA;\n    c.shapeB = shapeB;\n    c.setSlipForce(this.slipForce);\n    c.frictionCoefficient = this.frictionCoefficient;\n    c.relativeVelocity = this.surfaceVelocity;\n    c.enabled = this.enabledEquations;\n    c.needsUpdate = true;\n    c.stiffness = this.frictionStiffness;\n    c.relaxation = this.frictionRelaxation;\n    c.contactEquations.length = 0;\n    return c;\n};\n\n/**\n * Creates a FrictionEquation given the data in the ContactEquation. Uses same offset vectors ri and rj, but the tangent vector will be constructed from the collision normal.\n * @method createFrictionFromContact\n * @param  {ContactEquation} contactEquation\n * @return {FrictionEquation}\n */\nNarrowphase.prototype.createFrictionFromContact = function(c){\n    var eq = this.createFrictionEquation(c.bodyA, c.bodyB, c.shapeA, c.shapeB);\n    vec2.copy(eq.contactPointA, c.contactPointA);\n    vec2.copy(eq.contactPointB, c.contactPointB);\n    vec2.rotate90cw(eq.t, c.normalA);\n    eq.contactEquations.push(c);\n    return eq;\n};\n\n// Take the average N latest contact point on the plane.\nNarrowphase.prototype.createFrictionFromAverage = function(numContacts){\n    var c = this.contactEquations[this.contactEquations.length - 1];\n    var eq = this.createFrictionEquation(c.bodyA, c.bodyB, c.shapeA, c.shapeB);\n    var bodyA = c.bodyA;\n    var bodyB = c.bodyB;\n    vec2.set(eq.contactPointA, 0, 0);\n    vec2.set(eq.contactPointB, 0, 0);\n    vec2.set(eq.t, 0, 0);\n    for(var i=0; i!==numContacts; i++){\n        c = this.contactEquations[this.contactEquations.length - 1 - i];\n        if(c.bodyA === bodyA){\n            vec2.add(eq.t, eq.t, c.normalA);\n            vec2.add(eq.contactPointA, eq.contactPointA, c.contactPointA);\n            vec2.add(eq.contactPointB, eq.contactPointB, c.contactPointB);\n        } else {\n            vec2.sub(eq.t, eq.t, c.normalA);\n            vec2.add(eq.contactPointA, eq.contactPointA, c.contactPointB);\n            vec2.add(eq.contactPointB, eq.contactPointB, c.contactPointA);\n        }\n        eq.contactEquations.push(c);\n    }\n\n    var invNumContacts = 1/numContacts;\n    vec2.scale(eq.contactPointA, eq.contactPointA, invNumContacts);\n    vec2.scale(eq.contactPointB, eq.contactPointB, invNumContacts);\n    vec2.normalize(eq.t, eq.t);\n    vec2.rotate90cw(eq.t, eq.t);\n    return eq;\n};\n\n/**\n * Convex/line narrowphase\n * @method convexLine\n * @param  {Body}       convexBody\n * @param  {Convex}     convexShape\n * @param  {Array}      convexOffset\n * @param  {Number}     convexAngle\n * @param  {Body}       lineBody\n * @param  {Line}       lineShape\n * @param  {Array}      lineOffset\n * @param  {Number}     lineAngle\n * @param {boolean}     justTest\n * @todo Implement me!\n */\nNarrowphase.prototype[Shape.LINE | Shape.CONVEX] =\nNarrowphase.prototype.convexLine = function(\n    convexBody,\n    convexShape,\n    convexOffset,\n    convexAngle,\n    lineBody,\n    lineShape,\n    lineOffset,\n    lineAngle,\n    justTest\n){\n    // TODO\n    if(justTest){\n        return false;\n    } else {\n        return 0;\n    }\n};\n\n/**\n * Line/box narrowphase\n * @method lineBox\n * @param  {Body}       lineBody\n * @param  {Line}       lineShape\n * @param  {Array}      lineOffset\n * @param  {Number}     lineAngle\n * @param  {Body}       boxBody\n * @param  {Box}  boxShape\n * @param  {Array}      boxOffset\n * @param  {Number}     boxAngle\n * @param  {Boolean}    justTest\n * @todo Implement me!\n */\nNarrowphase.prototype[Shape.LINE | Shape.BOX] =\nNarrowphase.prototype.lineBox = function(\n    lineBody,\n    lineShape,\n    lineOffset,\n    lineAngle,\n    boxBody,\n    boxShape,\n    boxOffset,\n    boxAngle,\n    justTest\n){\n    // TODO\n    if(justTest){\n        return false;\n    } else {\n        return 0;\n    }\n};\n\nfunction setConvexToCapsuleShapeMiddle(convexShape, capsuleShape){\n    vec2.set(convexShape.vertices[0], -capsuleShape.length * 0.5, -capsuleShape.radius);\n    vec2.set(convexShape.vertices[1],  capsuleShape.length * 0.5, -capsuleShape.radius);\n    vec2.set(convexShape.vertices[2],  capsuleShape.length * 0.5,  capsuleShape.radius);\n    vec2.set(convexShape.vertices[3], -capsuleShape.length * 0.5,  capsuleShape.radius);\n}\n\nvar convexCapsule_tempRect = new Box({ width: 1, height: 1 }),\n    convexCapsule_tempVec = vec2.create();\n\n/**\n * Convex/capsule narrowphase\n * @method convexCapsule\n * @param  {Body}       convexBody\n * @param  {Convex}     convexShape\n * @param  {Array}      convexPosition\n * @param  {Number}     convexAngle\n * @param  {Body}       capsuleBody\n * @param  {Capsule}    capsuleShape\n * @param  {Array}      capsulePosition\n * @param  {Number}     capsuleAngle\n */\nNarrowphase.prototype[Shape.CAPSULE | Shape.CONVEX] =\nNarrowphase.prototype[Shape.CAPSULE | Shape.BOX] =\nNarrowphase.prototype.convexCapsule = function(\n    convexBody,\n    convexShape,\n    convexPosition,\n    convexAngle,\n    capsuleBody,\n    capsuleShape,\n    capsulePosition,\n    capsuleAngle,\n    justTest\n){\n\n    // Check the circles\n    // Add offsets!\n    var circlePos = convexCapsule_tempVec;\n    vec2.set(circlePos, capsuleShape.length/2,0);\n    vec2.rotate(circlePos,circlePos,capsuleAngle);\n    vec2.add(circlePos,circlePos,capsulePosition);\n    var result1 = this.circleConvex(capsuleBody,capsuleShape,circlePos,capsuleAngle, convexBody,convexShape,convexPosition,convexAngle, justTest, capsuleShape.radius);\n\n    vec2.set(circlePos,-capsuleShape.length/2, 0);\n    vec2.rotate(circlePos,circlePos,capsuleAngle);\n    vec2.add(circlePos,circlePos,capsulePosition);\n    var result2 = this.circleConvex(capsuleBody,capsuleShape,circlePos,capsuleAngle, convexBody,convexShape,convexPosition,convexAngle, justTest, capsuleShape.radius);\n\n    if(justTest && (result1 || result2)){\n        return true;\n    }\n\n    // Check center rect\n    var r = convexCapsule_tempRect;\n    setConvexToCapsuleShapeMiddle(r,capsuleShape);\n    var result = this.convexConvex(convexBody,convexShape,convexPosition,convexAngle, capsuleBody,r,capsulePosition,capsuleAngle, justTest);\n\n    return result + result1 + result2;\n};\n\n/**\n * Capsule/line narrowphase\n * @method lineCapsule\n * @param  {Body}       lineBody\n * @param  {Line}       lineShape\n * @param  {Array}      linePosition\n * @param  {Number}     lineAngle\n * @param  {Body}       capsuleBody\n * @param  {Capsule}    capsuleShape\n * @param  {Array}      capsulePosition\n * @param  {Number}     capsuleAngle\n * @todo Implement me!\n */\nNarrowphase.prototype[Shape.CAPSULE | Shape.LINE] =\nNarrowphase.prototype.lineCapsule = function(\n    lineBody,\n    lineShape,\n    linePosition,\n    lineAngle,\n    capsuleBody,\n    capsuleShape,\n    capsulePosition,\n    capsuleAngle,\n    justTest\n){\n    // TODO\n    if(justTest){\n        return false;\n    } else {\n        return 0;\n    }\n};\n\nvar capsuleCapsule_tempVec1 = vec2.create();\nvar capsuleCapsule_tempVec2 = vec2.create();\nvar capsuleCapsule_tempRect1 = new Box({ width: 1, height: 1 });\n\n/**\n * Capsule/capsule narrowphase\n * @method capsuleCapsule\n * @param  {Body}       bi\n * @param  {Capsule}    si\n * @param  {Array}      xi\n * @param  {Number}     ai\n * @param  {Body}       bj\n * @param  {Capsule}    sj\n * @param  {Array}      xj\n * @param  {Number}     aj\n */\nNarrowphase.prototype[Shape.CAPSULE | Shape.CAPSULE] =\nNarrowphase.prototype.capsuleCapsule = function(bi,si,xi,ai, bj,sj,xj,aj, justTest){\n\n    var enableFrictionBefore;\n\n    // Check the circles\n    // Add offsets!\n    var circlePosi = capsuleCapsule_tempVec1,\n        circlePosj = capsuleCapsule_tempVec2;\n\n    var numContacts = 0;\n\n\n    // Need 4 circle checks, between all\n    for(var i=0; i<2; i++){\n\n        vec2.set(circlePosi,(i===0?-1:1)*si.length/2,0);\n        vec2.rotate(circlePosi,circlePosi,ai);\n        vec2.add(circlePosi,circlePosi,xi);\n\n        for(var j=0; j<2; j++){\n\n            vec2.set(circlePosj,(j===0?-1:1)*sj.length/2, 0);\n            vec2.rotate(circlePosj,circlePosj,aj);\n            vec2.add(circlePosj,circlePosj,xj);\n\n            // Temporarily turn off friction\n            if(this.enableFrictionReduction){\n                enableFrictionBefore = this.enableFriction;\n                this.enableFriction = false;\n            }\n\n            var result = this.circleCircle(bi,si,circlePosi,ai, bj,sj,circlePosj,aj, justTest, si.radius, sj.radius);\n\n            if(this.enableFrictionReduction){\n                this.enableFriction = enableFrictionBefore;\n            }\n\n            if(justTest && result){\n                return true;\n            }\n\n            numContacts += result;\n        }\n    }\n\n    if(this.enableFrictionReduction){\n        // Temporarily turn off friction\n        enableFrictionBefore = this.enableFriction;\n        this.enableFriction = false;\n    }\n\n    // Check circles against the center boxs\n    var rect = capsuleCapsule_tempRect1;\n    setConvexToCapsuleShapeMiddle(rect,si);\n    var result1 = this.convexCapsule(bi,rect,xi,ai, bj,sj,xj,aj, justTest);\n\n    if(this.enableFrictionReduction){\n        this.enableFriction = enableFrictionBefore;\n    }\n\n    if(justTest && result1){\n        return true;\n    }\n    numContacts += result1;\n\n    if(this.enableFrictionReduction){\n        // Temporarily turn off friction\n        var enableFrictionBefore = this.enableFriction;\n        this.enableFriction = false;\n    }\n\n    setConvexToCapsuleShapeMiddle(rect,sj);\n    var result2 = this.convexCapsule(bj,rect,xj,aj, bi,si,xi,ai, justTest);\n\n    if(this.enableFrictionReduction){\n        this.enableFriction = enableFrictionBefore;\n    }\n\n    if(justTest && result2){\n        return true;\n    }\n    numContacts += result2;\n\n    if(this.enableFrictionReduction){\n        if(numContacts && this.enableFriction){\n            this.frictionEquations.push(this.createFrictionFromAverage(numContacts));\n        }\n    }\n\n    return numContacts;\n};\n\n/**\n * Line/line narrowphase\n * @method lineLine\n * @param  {Body}       bodyA\n * @param  {Line}       shapeA\n * @param  {Array}      positionA\n * @param  {Number}     angleA\n * @param  {Body}       bodyB\n * @param  {Line}       shapeB\n * @param  {Array}      positionB\n * @param  {Number}     angleB\n * @todo Implement me!\n */\nNarrowphase.prototype[Shape.LINE | Shape.LINE] =\nNarrowphase.prototype.lineLine = function(\n    bodyA,\n    shapeA,\n    positionA,\n    angleA,\n    bodyB,\n    shapeB,\n    positionB,\n    angleB,\n    justTest\n){\n    // TODO\n    if(justTest){\n        return false;\n    } else {\n        return 0;\n    }\n};\n\n/**\n * Plane/line Narrowphase\n * @method planeLine\n * @param  {Body}   planeBody\n * @param  {Plane}  planeShape\n * @param  {Array}  planeOffset\n * @param  {Number} planeAngle\n * @param  {Body}   lineBody\n * @param  {Line}   lineShape\n * @param  {Array}  lineOffset\n * @param  {Number} lineAngle\n */\nNarrowphase.prototype[Shape.PLANE | Shape.LINE] =\nNarrowphase.prototype.planeLine = function(planeBody, planeShape, planeOffset, planeAngle,\n                                           lineBody,  lineShape,  lineOffset,  lineAngle, justTest){\n    var worldVertex0 = tmp1,\n        worldVertex1 = tmp2,\n        worldVertex01 = tmp3,\n        worldVertex11 = tmp4,\n        worldEdge = tmp5,\n        worldEdgeUnit = tmp6,\n        dist = tmp7,\n        worldNormal = tmp8,\n        worldTangent = tmp9,\n        verts = tmpArray,\n        numContacts = 0;\n\n    // Get start and end points\n    vec2.set(worldVertex0, -lineShape.length/2, 0);\n    vec2.set(worldVertex1,  lineShape.length/2, 0);\n\n    // Not sure why we have to use worldVertex*1 here, but it won't work otherwise. Tired.\n    vec2.rotate(worldVertex01, worldVertex0, lineAngle);\n    vec2.rotate(worldVertex11, worldVertex1, lineAngle);\n\n    add(worldVertex01, worldVertex01, lineOffset);\n    add(worldVertex11, worldVertex11, lineOffset);\n\n    vec2.copy(worldVertex0,worldVertex01);\n    vec2.copy(worldVertex1,worldVertex11);\n\n    // Get vector along the line\n    sub(worldEdge, worldVertex1, worldVertex0);\n    vec2.normalize(worldEdgeUnit, worldEdge);\n\n    // Get tangent to the edge.\n    vec2.rotate90cw(worldTangent, worldEdgeUnit);\n\n    vec2.rotate(worldNormal, yAxis, planeAngle);\n\n    // Check line ends\n    verts[0] = worldVertex0;\n    verts[1] = worldVertex1;\n    for(var i=0; i<verts.length; i++){\n        var v = verts[i];\n\n        sub(dist, v, planeOffset);\n\n        var d = dot(dist,worldNormal);\n\n        if(d < 0){\n\n            if(justTest){\n                return true;\n            }\n\n            var c = this.createContactEquation(planeBody,lineBody,planeShape,lineShape);\n            numContacts++;\n\n            vec2.copy(c.normalA, worldNormal);\n            vec2.normalize(c.normalA,c.normalA);\n\n            // distance vector along plane normal\n            vec2.scale(dist, worldNormal, d);\n\n            // Vector from plane center to contact\n            sub(c.contactPointA, v, dist);\n            sub(c.contactPointA, c.contactPointA, planeBody.position);\n\n            // From line center to contact\n            sub(c.contactPointB, v,    lineOffset);\n            add(c.contactPointB, c.contactPointB, lineOffset);\n            sub(c.contactPointB, c.contactPointB, lineBody.position);\n\n            this.contactEquations.push(c);\n\n            if(!this.enableFrictionReduction){\n                if(this.enableFriction){\n                    this.frictionEquations.push(this.createFrictionFromContact(c));\n                }\n            }\n        }\n    }\n\n    if(justTest){\n        return false;\n    }\n\n    if(!this.enableFrictionReduction){\n        if(numContacts && this.enableFriction){\n            this.frictionEquations.push(this.createFrictionFromAverage(numContacts));\n        }\n    }\n\n    return numContacts;\n};\n\nNarrowphase.prototype[Shape.PARTICLE | Shape.CAPSULE] =\nNarrowphase.prototype.particleCapsule = function(\n    particleBody,\n    particleShape,\n    particlePosition,\n    particleAngle,\n    capsuleBody,\n    capsuleShape,\n    capsulePosition,\n    capsuleAngle,\n    justTest\n){\n    return this.circleLine(particleBody,particleShape,particlePosition,particleAngle, capsuleBody,capsuleShape,capsulePosition,capsuleAngle, justTest, capsuleShape.radius, 0);\n};\n\n/**\n * Circle/line Narrowphase\n * @method circleLine\n * @param  {Body} circleBody\n * @param  {Circle} circleShape\n * @param  {Array} circleOffset\n * @param  {Number} circleAngle\n * @param  {Body} lineBody\n * @param  {Line} lineShape\n * @param  {Array} lineOffset\n * @param  {Number} lineAngle\n * @param {Boolean} justTest If set to true, this function will return the result (intersection or not) without adding equations.\n * @param {Number} lineRadius Radius to add to the line. Can be used to test Capsules.\n * @param {Number} circleRadius If set, this value overrides the circle shape radius.\n */\nNarrowphase.prototype[Shape.CIRCLE | Shape.LINE] =\nNarrowphase.prototype.circleLine = function(\n    circleBody,\n    circleShape,\n    circleOffset,\n    circleAngle,\n    lineBody,\n    lineShape,\n    lineOffset,\n    lineAngle,\n    justTest,\n    lineRadius,\n    circleRadius\n){\n    var lineRadius = lineRadius || 0,\n        circleRadius = typeof(circleRadius)!==\"undefined\" ? circleRadius : circleShape.radius,\n\n        orthoDist = tmp1,\n        lineToCircleOrthoUnit = tmp2,\n        projectedPoint = tmp3,\n        centerDist = tmp4,\n        worldTangent = tmp5,\n        worldEdge = tmp6,\n        worldEdgeUnit = tmp7,\n        worldVertex0 = tmp8,\n        worldVertex1 = tmp9,\n        worldVertex01 = tmp10,\n        worldVertex11 = tmp11,\n        dist = tmp12,\n        lineToCircle = tmp13,\n        lineEndToLineRadius = tmp14,\n\n        verts = tmpArray;\n\n    // Get start and end points\n    vec2.set(worldVertex0, -lineShape.length/2, 0);\n    vec2.set(worldVertex1,  lineShape.length/2, 0);\n\n    // Not sure why we have to use worldVertex*1 here, but it won't work otherwise. Tired.\n    vec2.rotate(worldVertex01, worldVertex0, lineAngle);\n    vec2.rotate(worldVertex11, worldVertex1, lineAngle);\n\n    add(worldVertex01, worldVertex01, lineOffset);\n    add(worldVertex11, worldVertex11, lineOffset);\n\n    vec2.copy(worldVertex0,worldVertex01);\n    vec2.copy(worldVertex1,worldVertex11);\n\n    // Get vector along the line\n    sub(worldEdge, worldVertex1, worldVertex0);\n    vec2.normalize(worldEdgeUnit, worldEdge);\n\n    // Get tangent to the edge.\n    vec2.rotate90cw(worldTangent, worldEdgeUnit);\n\n    // Check distance from the plane spanned by the edge vs the circle\n    sub(dist, circleOffset, worldVertex0);\n    var d = dot(dist, worldTangent); // Distance from center of line to circle center\n    sub(centerDist, worldVertex0, lineOffset);\n\n    sub(lineToCircle, circleOffset, lineOffset);\n\n    var radiusSum = circleRadius + lineRadius;\n\n    if(Math.abs(d) < radiusSum){\n\n        // Now project the circle onto the edge\n        vec2.scale(orthoDist, worldTangent, d);\n        sub(projectedPoint, circleOffset, orthoDist);\n\n        // Add the missing line radius\n        vec2.scale(lineToCircleOrthoUnit, worldTangent, dot(worldTangent, lineToCircle));\n        vec2.normalize(lineToCircleOrthoUnit,lineToCircleOrthoUnit);\n        vec2.scale(lineToCircleOrthoUnit, lineToCircleOrthoUnit, lineRadius);\n        add(projectedPoint,projectedPoint,lineToCircleOrthoUnit);\n\n        // Check if the point is within the edge span\n        var pos =  dot(worldEdgeUnit, projectedPoint);\n        var pos0 = dot(worldEdgeUnit, worldVertex0);\n        var pos1 = dot(worldEdgeUnit, worldVertex1);\n\n        if(pos > pos0 && pos < pos1){\n            // We got contact!\n\n            if(justTest){\n                return true;\n            }\n\n            var c = this.createContactEquation(circleBody,lineBody,circleShape,lineShape);\n\n            vec2.scale(c.normalA, orthoDist, -1);\n            vec2.normalize(c.normalA, c.normalA);\n\n            vec2.scale( c.contactPointA, c.normalA,  circleRadius);\n            add(c.contactPointA, c.contactPointA, circleOffset);\n            sub(c.contactPointA, c.contactPointA, circleBody.position);\n\n            sub(c.contactPointB, projectedPoint, lineOffset);\n            add(c.contactPointB, c.contactPointB, lineOffset);\n            sub(c.contactPointB, c.contactPointB, lineBody.position);\n\n            this.contactEquations.push(c);\n\n            if(this.enableFriction){\n                this.frictionEquations.push(this.createFrictionFromContact(c));\n            }\n\n            return 1;\n        }\n    }\n\n    // Add corner\n    verts[0] = worldVertex0;\n    verts[1] = worldVertex1;\n\n    for(var i=0; i<verts.length; i++){\n        var v = verts[i];\n\n        sub(dist, v, circleOffset);\n\n        if(vec2.squaredLength(dist) < Math.pow(radiusSum, 2)){\n\n            if(justTest){\n                return true;\n            }\n\n            var c = this.createContactEquation(circleBody,lineBody,circleShape,lineShape);\n\n            vec2.copy(c.normalA, dist);\n            vec2.normalize(c.normalA,c.normalA);\n\n            // Vector from circle to contact point is the normal times the circle radius\n            vec2.scale(c.contactPointA, c.normalA, circleRadius);\n            add(c.contactPointA, c.contactPointA, circleOffset);\n            sub(c.contactPointA, c.contactPointA, circleBody.position);\n\n            sub(c.contactPointB, v, lineOffset);\n            vec2.scale(lineEndToLineRadius, c.normalA, -lineRadius);\n            add(c.contactPointB, c.contactPointB, lineEndToLineRadius);\n            add(c.contactPointB, c.contactPointB, lineOffset);\n            sub(c.contactPointB, c.contactPointB, lineBody.position);\n\n            this.contactEquations.push(c);\n\n            if(this.enableFriction){\n                this.frictionEquations.push(this.createFrictionFromContact(c));\n            }\n\n            return 1;\n        }\n    }\n\n    return 0;\n};\n\n/**\n * Circle/capsule Narrowphase\n * @method circleCapsule\n * @param  {Body}   bi\n * @param  {Circle} si\n * @param  {Array}  xi\n * @param  {Number} ai\n * @param  {Body}   bj\n * @param  {Line}   sj\n * @param  {Array}  xj\n * @param  {Number} aj\n */\nNarrowphase.prototype[Shape.CIRCLE | Shape.CAPSULE] =\nNarrowphase.prototype.circleCapsule = function(bi,si,xi,ai, bj,sj,xj,aj, justTest){\n    return this.circleLine(bi,si,xi,ai, bj,sj,xj,aj, justTest, sj.radius);\n};\n\n/**\n * Circle/convex Narrowphase.\n * @method circleConvex\n * @param  {Body} circleBody\n * @param  {Circle} circleShape\n * @param  {Array} circleOffset\n * @param  {Number} circleAngle\n * @param  {Body} convexBody\n * @param  {Convex} convexShape\n * @param  {Array} convexOffset\n * @param  {Number} convexAngle\n * @param  {Boolean} justTest\n * @param  {Number} circleRadius\n */\nNarrowphase.prototype[Shape.CIRCLE | Shape.CONVEX] =\nNarrowphase.prototype[Shape.CIRCLE | Shape.BOX] =\nNarrowphase.prototype.circleConvex = function(\n    circleBody,\n    circleShape,\n    circleOffset,\n    circleAngle,\n    convexBody,\n    convexShape,\n    convexOffset,\n    convexAngle,\n    justTest,\n    circleRadius\n){\n    var circleRadius = typeof(circleRadius)===\"number\" ? circleRadius : circleShape.radius;\n\n    var worldVertex0 = tmp1,\n        worldVertex1 = tmp2,\n        worldEdge = tmp3,\n        worldEdgeUnit = tmp4,\n        worldNormal = tmp5,\n        centerDist = tmp6,\n        convexToCircle = tmp7,\n        orthoDist = tmp8,\n        projectedPoint = tmp9,\n        dist = tmp10,\n        worldVertex = tmp11,\n\n        closestEdge = -1,\n        closestEdgeDistance = null,\n        closestEdgeOrthoDist = tmp12,\n        closestEdgeProjectedPoint = tmp13,\n        candidate = tmp14,\n        candidateDist = tmp15,\n        minCandidate = tmp16,\n\n        found = false,\n        minCandidateDistance = Number.MAX_VALUE;\n\n    var numReported = 0;\n\n    // New algorithm:\n    // 1. Check so center of circle is not inside the polygon. If it is, this wont work...\n    // 2. For each edge\n    // 2. 1. Get point on circle that is closest to the edge (scale normal with -radius)\n    // 2. 2. Check if point is inside.\n\n    var verts = convexShape.vertices;\n\n    // Check all edges first\n    for(var i=0; i!==verts.length+1; i++){\n        var v0 = verts[i%verts.length],\n            v1 = verts[(i+1)%verts.length];\n\n        vec2.rotate(worldVertex0, v0, convexAngle);\n        vec2.rotate(worldVertex1, v1, convexAngle);\n        add(worldVertex0, worldVertex0, convexOffset);\n        add(worldVertex1, worldVertex1, convexOffset);\n        sub(worldEdge, worldVertex1, worldVertex0);\n\n        vec2.normalize(worldEdgeUnit, worldEdge);\n\n        // Get tangent to the edge. Points out of the Convex\n        vec2.rotate90cw(worldNormal, worldEdgeUnit);\n\n        // Get point on circle, closest to the polygon\n        vec2.scale(candidate,worldNormal,-circleShape.radius);\n        add(candidate,candidate,circleOffset);\n\n        if(pointInConvex(candidate,convexShape,convexOffset,convexAngle)){\n\n            vec2.sub(candidateDist,worldVertex0,candidate);\n            var candidateDistance = Math.abs(vec2.dot(candidateDist,worldNormal));\n\n            if(candidateDistance < minCandidateDistance){\n                vec2.copy(minCandidate,candidate);\n                minCandidateDistance = candidateDistance;\n                vec2.scale(closestEdgeProjectedPoint,worldNormal,candidateDistance);\n                vec2.add(closestEdgeProjectedPoint,closestEdgeProjectedPoint,candidate);\n                found = true;\n            }\n        }\n    }\n\n    if(found){\n\n        if(justTest){\n            return true;\n        }\n\n        var c = this.createContactEquation(circleBody,convexBody,circleShape,convexShape);\n        vec2.sub(c.normalA, minCandidate, circleOffset);\n        vec2.normalize(c.normalA, c.normalA);\n\n        vec2.scale(c.contactPointA,  c.normalA, circleRadius);\n        add(c.contactPointA, c.contactPointA, circleOffset);\n        sub(c.contactPointA, c.contactPointA, circleBody.position);\n\n        sub(c.contactPointB, closestEdgeProjectedPoint, convexOffset);\n        add(c.contactPointB, c.contactPointB, convexOffset);\n        sub(c.contactPointB, c.contactPointB, convexBody.position);\n\n        this.contactEquations.push(c);\n\n        if(this.enableFriction){\n            this.frictionEquations.push( this.createFrictionFromContact(c) );\n        }\n\n        return 1;\n    }\n\n    // Check all vertices\n    if(circleRadius > 0){\n        for(var i=0; i<verts.length; i++){\n            var localVertex = verts[i];\n            vec2.rotate(worldVertex, localVertex, convexAngle);\n            add(worldVertex, worldVertex, convexOffset);\n\n            sub(dist, worldVertex, circleOffset);\n            if(vec2.squaredLength(dist) < Math.pow(circleRadius, 2)){\n\n                if(justTest){\n                    return true;\n                }\n\n                var c = this.createContactEquation(circleBody,convexBody,circleShape,convexShape);\n\n                vec2.copy(c.normalA, dist);\n                vec2.normalize(c.normalA,c.normalA);\n\n                // Vector from circle to contact point is the normal times the circle radius\n                vec2.scale(c.contactPointA, c.normalA, circleRadius);\n                add(c.contactPointA, c.contactPointA, circleOffset);\n                sub(c.contactPointA, c.contactPointA, circleBody.position);\n\n                sub(c.contactPointB, worldVertex, convexOffset);\n                add(c.contactPointB, c.contactPointB, convexOffset);\n                sub(c.contactPointB, c.contactPointB, convexBody.position);\n\n                this.contactEquations.push(c);\n\n                if(this.enableFriction){\n                    this.frictionEquations.push(this.createFrictionFromContact(c));\n                }\n\n                return 1;\n            }\n        }\n    }\n\n    return 0;\n};\n\nvar pic_worldVertex0 = vec2.create(),\n    pic_worldVertex1 = vec2.create(),\n    pic_r0 = vec2.create(),\n    pic_r1 = vec2.create();\n\n/*\n * Check if a point is in a polygon\n */\nfunction pointInConvex(worldPoint,convexShape,convexOffset,convexAngle){\n    var worldVertex0 = pic_worldVertex0,\n        worldVertex1 = pic_worldVertex1,\n        r0 = pic_r0,\n        r1 = pic_r1,\n        point = worldPoint,\n        verts = convexShape.vertices,\n        lastCross = null;\n    for(var i=0; i!==verts.length+1; i++){\n        var v0 = verts[i%verts.length],\n            v1 = verts[(i+1)%verts.length];\n\n        // Transform vertices to world\n        // @todo The point should be transformed to local coordinates in the convex, no need to transform each vertex\n        vec2.rotate(worldVertex0, v0, convexAngle);\n        vec2.rotate(worldVertex1, v1, convexAngle);\n        add(worldVertex0, worldVertex0, convexOffset);\n        add(worldVertex1, worldVertex1, convexOffset);\n\n        sub(r0, worldVertex0, point);\n        sub(r1, worldVertex1, point);\n        var cross = vec2.crossLength(r0,r1);\n\n        if(lastCross===null){\n            lastCross = cross;\n        }\n\n        // If we got a different sign of the distance vector, the point is out of the polygon\n        if(cross*lastCross <= 0){\n            return false;\n        }\n        lastCross = cross;\n    }\n    return true;\n}\n\n/**\n * Particle/convex Narrowphase\n * @method particleConvex\n * @param  {Body} particleBody\n * @param  {Particle} particleShape\n * @param  {Array} particleOffset\n * @param  {Number} particleAngle\n * @param  {Body} convexBody\n * @param  {Convex} convexShape\n * @param  {Array} convexOffset\n * @param  {Number} convexAngle\n * @param {Boolean} justTest\n * @todo use pointInConvex and code more similar to circleConvex\n * @todo don't transform each vertex, but transform the particle position to convex-local instead\n */\nNarrowphase.prototype[Shape.PARTICLE | Shape.CONVEX] =\nNarrowphase.prototype[Shape.PARTICLE | Shape.BOX] =\nNarrowphase.prototype.particleConvex = function(\n    particleBody,\n    particleShape,\n    particleOffset,\n    particleAngle,\n    convexBody,\n    convexShape,\n    convexOffset,\n    convexAngle,\n    justTest\n){\n    var worldVertex0 = tmp1,\n        worldVertex1 = tmp2,\n        worldEdge = tmp3,\n        worldEdgeUnit = tmp4,\n        worldTangent = tmp5,\n        centerDist = tmp6,\n        convexToparticle = tmp7,\n        orthoDist = tmp8,\n        projectedPoint = tmp9,\n        dist = tmp10,\n        worldVertex = tmp11,\n        closestEdge = -1,\n        closestEdgeDistance = null,\n        closestEdgeOrthoDist = tmp12,\n        closestEdgeProjectedPoint = tmp13,\n        r0 = tmp14, // vector from particle to vertex0\n        r1 = tmp15,\n        localPoint = tmp16,\n        candidateDist = tmp17,\n        minEdgeNormal = tmp18,\n        minCandidateDistance = Number.MAX_VALUE;\n\n    var numReported = 0,\n        found = false,\n        verts = convexShape.vertices;\n\n    // Check if the particle is in the polygon at all\n    if(!pointInConvex(particleOffset,convexShape,convexOffset,convexAngle)){\n        return 0;\n    }\n\n    if(justTest){\n        return true;\n    }\n\n    // Check edges first\n    var lastCross = null;\n    for(var i=0; i!==verts.length+1; i++){\n        var v0 = verts[i%verts.length],\n            v1 = verts[(i+1)%verts.length];\n\n        // Transform vertices to world\n        vec2.rotate(worldVertex0, v0, convexAngle);\n        vec2.rotate(worldVertex1, v1, convexAngle);\n        add(worldVertex0, worldVertex0, convexOffset);\n        add(worldVertex1, worldVertex1, convexOffset);\n\n        // Get world edge\n        sub(worldEdge, worldVertex1, worldVertex0);\n        vec2.normalize(worldEdgeUnit, worldEdge);\n\n        // Get tangent to the edge. Points out of the Convex\n        vec2.rotate90cw(worldTangent, worldEdgeUnit);\n\n        // Check distance from the infinite line (spanned by the edge) to the particle\n        sub(dist, particleOffset, worldVertex0);\n        var d = dot(dist, worldTangent);\n        sub(centerDist, worldVertex0, convexOffset);\n\n        sub(convexToparticle, particleOffset, convexOffset);\n\n        vec2.sub(candidateDist,worldVertex0,particleOffset);\n        var candidateDistance = Math.abs(vec2.dot(candidateDist,worldTangent));\n\n        if(candidateDistance < minCandidateDistance){\n            minCandidateDistance = candidateDistance;\n            vec2.scale(closestEdgeProjectedPoint,worldTangent,candidateDistance);\n            vec2.add(closestEdgeProjectedPoint,closestEdgeProjectedPoint,particleOffset);\n            vec2.copy(minEdgeNormal,worldTangent);\n            found = true;\n        }\n    }\n\n    if(found){\n        var c = this.createContactEquation(particleBody,convexBody,particleShape,convexShape);\n\n        vec2.scale(c.normalA, minEdgeNormal, -1);\n        vec2.normalize(c.normalA, c.normalA);\n\n        // Particle has no extent to the contact point\n        vec2.set(c.contactPointA,  0, 0);\n        add(c.contactPointA, c.contactPointA, particleOffset);\n        sub(c.contactPointA, c.contactPointA, particleBody.position);\n\n        // From convex center to point\n        sub(c.contactPointB, closestEdgeProjectedPoint, convexOffset);\n        add(c.contactPointB, c.contactPointB, convexOffset);\n        sub(c.contactPointB, c.contactPointB, convexBody.position);\n\n        this.contactEquations.push(c);\n\n        if(this.enableFriction){\n            this.frictionEquations.push( this.createFrictionFromContact(c) );\n        }\n\n        return 1;\n    }\n\n\n    return 0;\n};\n\n/**\n * Circle/circle Narrowphase\n * @method circleCircle\n * @param  {Body} bodyA\n * @param  {Circle} shapeA\n * @param  {Array} offsetA\n * @param  {Number} angleA\n * @param  {Body} bodyB\n * @param  {Circle} shapeB\n * @param  {Array} offsetB\n * @param  {Number} angleB\n * @param {Boolean} justTest\n * @param {Number} [radiusA] Optional radius to use for shapeA\n * @param {Number} [radiusB] Optional radius to use for shapeB\n */\nNarrowphase.prototype[Shape.CIRCLE] =\nNarrowphase.prototype.circleCircle = function(\n    bodyA,\n    shapeA,\n    offsetA,\n    angleA,\n    bodyB,\n    shapeB,\n    offsetB,\n    angleB,\n    justTest,\n    radiusA,\n    radiusB\n){\n\n    var dist = tmp1,\n        radiusA = radiusA || shapeA.radius,\n        radiusB = radiusB || shapeB.radius;\n\n    sub(dist,offsetA,offsetB);\n    var r = radiusA + radiusB;\n    if(vec2.squaredLength(dist) > Math.pow(r,2)){\n        return 0;\n    }\n\n    if(justTest){\n        return true;\n    }\n\n    var c = this.createContactEquation(bodyA,bodyB,shapeA,shapeB);\n    sub(c.normalA, offsetB, offsetA);\n    vec2.normalize(c.normalA,c.normalA);\n\n    vec2.scale( c.contactPointA, c.normalA,  radiusA);\n    vec2.scale( c.contactPointB, c.normalA, -radiusB);\n\n    add(c.contactPointA, c.contactPointA, offsetA);\n    sub(c.contactPointA, c.contactPointA, bodyA.position);\n\n    add(c.contactPointB, c.contactPointB, offsetB);\n    sub(c.contactPointB, c.contactPointB, bodyB.position);\n\n    this.contactEquations.push(c);\n\n    if(this.enableFriction){\n        this.frictionEquations.push(this.createFrictionFromContact(c));\n    }\n    return 1;\n};\n\n/**\n * Plane/Convex Narrowphase\n * @method planeConvex\n * @param  {Body} planeBody\n * @param  {Plane} planeShape\n * @param  {Array} planeOffset\n * @param  {Number} planeAngle\n * @param  {Body} convexBody\n * @param  {Convex} convexShape\n * @param  {Array} convexOffset\n * @param  {Number} convexAngle\n * @param {Boolean} justTest\n */\nNarrowphase.prototype[Shape.PLANE | Shape.CONVEX] =\nNarrowphase.prototype[Shape.PLANE | Shape.BOX] =\nNarrowphase.prototype.planeConvex = function(\n    planeBody,\n    planeShape,\n    planeOffset,\n    planeAngle,\n    convexBody,\n    convexShape,\n    convexOffset,\n    convexAngle,\n    justTest\n){\n    var worldVertex = tmp1,\n        worldNormal = tmp2,\n        dist = tmp3;\n\n    var numReported = 0;\n    vec2.rotate(worldNormal, yAxis, planeAngle);\n\n    for(var i=0; i!==convexShape.vertices.length; i++){\n        var v = convexShape.vertices[i];\n        vec2.rotate(worldVertex, v, convexAngle);\n        add(worldVertex, worldVertex, convexOffset);\n\n        sub(dist, worldVertex, planeOffset);\n\n        if(dot(dist,worldNormal) <= 0){\n\n            if(justTest){\n                return true;\n            }\n\n            // Found vertex\n            numReported++;\n\n            var c = this.createContactEquation(planeBody,convexBody,planeShape,convexShape);\n\n            sub(dist, worldVertex, planeOffset);\n\n            vec2.copy(c.normalA, worldNormal);\n\n            var d = dot(dist, c.normalA);\n            vec2.scale(dist, c.normalA, d);\n\n            // rj is from convex center to contact\n            sub(c.contactPointB, worldVertex, convexBody.position);\n\n\n            // ri is from plane center to contact\n            sub( c.contactPointA, worldVertex, dist);\n            sub( c.contactPointA, c.contactPointA, planeBody.position);\n\n            this.contactEquations.push(c);\n\n            if(!this.enableFrictionReduction){\n                if(this.enableFriction){\n                    this.frictionEquations.push(this.createFrictionFromContact(c));\n                }\n            }\n        }\n    }\n\n    if(this.enableFrictionReduction){\n        if(this.enableFriction && numReported){\n            this.frictionEquations.push(this.createFrictionFromAverage(numReported));\n        }\n    }\n\n    return numReported;\n};\n\n/**\n * Narrowphase for particle vs plane\n * @method particlePlane\n * @param  {Body}       particleBody\n * @param  {Particle}   particleShape\n * @param  {Array}      particleOffset\n * @param  {Number}     particleAngle\n * @param  {Body}       planeBody\n * @param  {Plane}      planeShape\n * @param  {Array}      planeOffset\n * @param  {Number}     planeAngle\n * @param {Boolean}     justTest\n */\nNarrowphase.prototype[Shape.PARTICLE | Shape.PLANE] =\nNarrowphase.prototype.particlePlane = function(\n    particleBody,\n    particleShape,\n    particleOffset,\n    particleAngle,\n    planeBody,\n    planeShape,\n    planeOffset,\n    planeAngle,\n    justTest\n){\n    var dist = tmp1,\n        worldNormal = tmp2;\n\n    planeAngle = planeAngle || 0;\n\n    sub(dist, particleOffset, planeOffset);\n    vec2.rotate(worldNormal, yAxis, planeAngle);\n\n    var d = dot(dist, worldNormal);\n\n    if(d > 0){\n        return 0;\n    }\n    if(justTest){\n        return true;\n    }\n\n    var c = this.createContactEquation(planeBody,particleBody,planeShape,particleShape);\n\n    vec2.copy(c.normalA, worldNormal);\n    vec2.scale( dist, c.normalA, d );\n    // dist is now the distance vector in the normal direction\n\n    // ri is the particle position projected down onto the plane, from the plane center\n    sub( c.contactPointA, particleOffset, dist);\n    sub( c.contactPointA, c.contactPointA, planeBody.position);\n\n    // rj is from the body center to the particle center\n    sub( c.contactPointB, particleOffset, particleBody.position );\n\n    this.contactEquations.push(c);\n\n    if(this.enableFriction){\n        this.frictionEquations.push(this.createFrictionFromContact(c));\n    }\n    return 1;\n};\n\n/**\n * Circle/Particle Narrowphase\n * @method circleParticle\n * @param  {Body} circleBody\n * @param  {Circle} circleShape\n * @param  {Array} circleOffset\n * @param  {Number} circleAngle\n * @param  {Body} particleBody\n * @param  {Particle} particleShape\n * @param  {Array} particleOffset\n * @param  {Number} particleAngle\n * @param  {Boolean} justTest\n */\nNarrowphase.prototype[Shape.CIRCLE | Shape.PARTICLE] =\nNarrowphase.prototype.circleParticle = function(\n    circleBody,\n    circleShape,\n    circleOffset,\n    circleAngle,\n    particleBody,\n    particleShape,\n    particleOffset,\n    particleAngle,\n    justTest\n){\n    var dist = tmp1;\n\n    sub(dist, particleOffset, circleOffset);\n    if(vec2.squaredLength(dist) > Math.pow(circleShape.radius, 2)){\n        return 0;\n    }\n    if(justTest){\n        return true;\n    }\n\n    var c = this.createContactEquation(circleBody,particleBody,circleShape,particleShape);\n    vec2.copy(c.normalA, dist);\n    vec2.normalize(c.normalA,c.normalA);\n\n    // Vector from circle to contact point is the normal times the circle radius\n    vec2.scale(c.contactPointA, c.normalA, circleShape.radius);\n    add(c.contactPointA, c.contactPointA, circleOffset);\n    sub(c.contactPointA, c.contactPointA, circleBody.position);\n\n    // Vector from particle center to contact point is zero\n    sub(c.contactPointB, particleOffset, particleBody.position);\n\n    this.contactEquations.push(c);\n\n    if(this.enableFriction){\n        this.frictionEquations.push(this.createFrictionFromContact(c));\n    }\n\n    return 1;\n};\n\nvar planeCapsule_tmpCircle = new Circle({ radius: 1 }),\n    planeCapsule_tmp1 = vec2.create(),\n    planeCapsule_tmp2 = vec2.create(),\n    planeCapsule_tmp3 = vec2.create();\n\n/**\n * @method planeCapsule\n * @param  {Body} planeBody\n * @param  {Circle} planeShape\n * @param  {Array} planeOffset\n * @param  {Number} planeAngle\n * @param  {Body} capsuleBody\n * @param  {Particle} capsuleShape\n * @param  {Array} capsuleOffset\n * @param  {Number} capsuleAngle\n * @param {Boolean} justTest\n */\nNarrowphase.prototype[Shape.PLANE | Shape.CAPSULE] =\nNarrowphase.prototype.planeCapsule = function(\n    planeBody,\n    planeShape,\n    planeOffset,\n    planeAngle,\n    capsuleBody,\n    capsuleShape,\n    capsuleOffset,\n    capsuleAngle,\n    justTest\n){\n    var end1 = planeCapsule_tmp1,\n        end2 = planeCapsule_tmp2,\n        circle = planeCapsule_tmpCircle,\n        dst = planeCapsule_tmp3;\n\n    // Compute world end positions\n    vec2.set(end1, -capsuleShape.length/2, 0);\n    vec2.rotate(end1,end1,capsuleAngle);\n    add(end1,end1,capsuleOffset);\n\n    vec2.set(end2,  capsuleShape.length/2, 0);\n    vec2.rotate(end2,end2,capsuleAngle);\n    add(end2,end2,capsuleOffset);\n\n    circle.radius = capsuleShape.radius;\n\n    var enableFrictionBefore;\n\n    // Temporarily turn off friction\n    if(this.enableFrictionReduction){\n        enableFrictionBefore = this.enableFriction;\n        this.enableFriction = false;\n    }\n\n    // Do Narrowphase as two circles\n    var numContacts1 = this.circlePlane(capsuleBody,circle,end1,0, planeBody,planeShape,planeOffset,planeAngle, justTest),\n        numContacts2 = this.circlePlane(capsuleBody,circle,end2,0, planeBody,planeShape,planeOffset,planeAngle, justTest);\n\n    // Restore friction\n    if(this.enableFrictionReduction){\n        this.enableFriction = enableFrictionBefore;\n    }\n\n    if(justTest){\n        return numContacts1 || numContacts2;\n    } else {\n        var numTotal = numContacts1 + numContacts2;\n        if(this.enableFrictionReduction){\n            if(numTotal){\n                this.frictionEquations.push(this.createFrictionFromAverage(numTotal));\n            }\n        }\n        return numTotal;\n    }\n};\n\n/**\n * Creates ContactEquations and FrictionEquations for a collision.\n * @method circlePlane\n * @param  {Body}    bi     The first body that should be connected to the equations.\n * @param  {Circle}  si     The circle shape participating in the collision.\n * @param  {Array}   xi     Extra offset to take into account for the Shape, in addition to the one in circleBody.position. Will *not* be rotated by circleBody.angle (maybe it should, for sake of homogenity?). Set to null if none.\n * @param  {Body}    bj     The second body that should be connected to the equations.\n * @param  {Plane}   sj     The Plane shape that is participating\n * @param  {Array}   xj     Extra offset for the plane shape.\n * @param  {Number}  aj     Extra angle to apply to the plane\n */\nNarrowphase.prototype[Shape.CIRCLE | Shape.PLANE] =\nNarrowphase.prototype.circlePlane = function(   bi,si,xi,ai, bj,sj,xj,aj, justTest ){\n    var circleBody = bi,\n        circleShape = si,\n        circleOffset = xi, // Offset from body center, rotated!\n        planeBody = bj,\n        shapeB = sj,\n        planeOffset = xj,\n        planeAngle = aj;\n\n    planeAngle = planeAngle || 0;\n\n    // Vector from plane to circle\n    var planeToCircle = tmp1,\n        worldNormal = tmp2,\n        temp = tmp3;\n\n    sub(planeToCircle, circleOffset, planeOffset);\n\n    // World plane normal\n    vec2.rotate(worldNormal, yAxis, planeAngle);\n\n    // Normal direction distance\n    var d = dot(worldNormal, planeToCircle);\n\n    if(d > circleShape.radius){\n        return 0; // No overlap. Abort.\n    }\n\n    if(justTest){\n        return true;\n    }\n\n    // Create contact\n    var contact = this.createContactEquation(planeBody,circleBody,sj,si);\n\n    // ni is the plane world normal\n    vec2.copy(contact.normalA, worldNormal);\n\n    // rj is the vector from circle center to the contact point\n    vec2.scale(contact.contactPointB, contact.normalA, -circleShape.radius);\n    add(contact.contactPointB, contact.contactPointB, circleOffset);\n    sub(contact.contactPointB, contact.contactPointB, circleBody.position);\n\n    // ri is the distance from plane center to contact.\n    vec2.scale(temp, contact.normalA, d);\n    sub(contact.contactPointA, planeToCircle, temp ); // Subtract normal distance vector from the distance vector\n    add(contact.contactPointA, contact.contactPointA, planeOffset);\n    sub(contact.contactPointA, contact.contactPointA, planeBody.position);\n\n    this.contactEquations.push(contact);\n\n    if(this.enableFriction){\n        this.frictionEquations.push( this.createFrictionFromContact(contact) );\n    }\n\n    return 1;\n};\n\n/**\n * Convex/convex Narrowphase.See <a href=\"http://www.altdevblogaday.com/2011/05/13/contact-generation-between-3d-convex-meshes/\">this article</a> for more info.\n * @method convexConvex\n * @param  {Body} bi\n * @param  {Convex} si\n * @param  {Array} xi\n * @param  {Number} ai\n * @param  {Body} bj\n * @param  {Convex} sj\n * @param  {Array} xj\n * @param  {Number} aj\n */\nNarrowphase.prototype[Shape.CONVEX] =\nNarrowphase.prototype[Shape.CONVEX | Shape.BOX] =\nNarrowphase.prototype[Shape.BOX] =\nNarrowphase.prototype.convexConvex = function(  bi,si,xi,ai, bj,sj,xj,aj, justTest, precision ){\n    var sepAxis = tmp1,\n        worldPoint = tmp2,\n        worldPoint0 = tmp3,\n        worldPoint1 = tmp4,\n        worldEdge = tmp5,\n        projected = tmp6,\n        penetrationVec = tmp7,\n        dist = tmp8,\n        worldNormal = tmp9,\n        numContacts = 0,\n        precision = typeof(precision) === 'number' ? precision : 0;\n\n    var found = Narrowphase.findSeparatingAxis(si,xi,ai,sj,xj,aj,sepAxis);\n    if(!found){\n        return 0;\n    }\n\n    // Make sure the separating axis is directed from shape i to shape j\n    sub(dist,xj,xi);\n    if(dot(sepAxis,dist) > 0){\n        vec2.scale(sepAxis,sepAxis,-1);\n    }\n\n    // Find edges with normals closest to the separating axis\n    var closestEdge1 = Narrowphase.getClosestEdge(si,ai,sepAxis,true), // Flipped axis\n        closestEdge2 = Narrowphase.getClosestEdge(sj,aj,sepAxis);\n\n    if(closestEdge1 === -1 || closestEdge2 === -1){\n        return 0;\n    }\n\n    // Loop over the shapes\n    for(var k=0; k<2; k++){\n\n        var closestEdgeA = closestEdge1,\n            closestEdgeB = closestEdge2,\n            shapeA =  si, shapeB =  sj,\n            offsetA = xi, offsetB = xj,\n            angleA = ai, angleB = aj,\n            bodyA = bi, bodyB = bj;\n\n        if(k === 0){\n            // Swap!\n            var tmp;\n            tmp = closestEdgeA;\n            closestEdgeA = closestEdgeB;\n            closestEdgeB = tmp;\n\n            tmp = shapeA;\n            shapeA = shapeB;\n            shapeB = tmp;\n\n            tmp = offsetA;\n            offsetA = offsetB;\n            offsetB = tmp;\n\n            tmp = angleA;\n            angleA = angleB;\n            angleB = tmp;\n\n            tmp = bodyA;\n            bodyA = bodyB;\n            bodyB = tmp;\n        }\n\n        // Loop over 2 points in convex B\n        for(var j=closestEdgeB; j<closestEdgeB+2; j++){\n\n            // Get world point\n            var v = shapeB.vertices[(j+shapeB.vertices.length)%shapeB.vertices.length];\n            vec2.rotate(worldPoint, v, angleB);\n            add(worldPoint, worldPoint, offsetB);\n\n            var insideNumEdges = 0;\n\n            // Loop over the 3 closest edges in convex A\n            for(var i=closestEdgeA-1; i<closestEdgeA+2; i++){\n\n                var v0 = shapeA.vertices[(i  +shapeA.vertices.length)%shapeA.vertices.length],\n                    v1 = shapeA.vertices[(i+1+shapeA.vertices.length)%shapeA.vertices.length];\n\n                // Construct the edge\n                vec2.rotate(worldPoint0, v0, angleA);\n                vec2.rotate(worldPoint1, v1, angleA);\n                add(worldPoint0, worldPoint0, offsetA);\n                add(worldPoint1, worldPoint1, offsetA);\n\n                sub(worldEdge, worldPoint1, worldPoint0);\n\n                vec2.rotate90cw(worldNormal, worldEdge); // Normal points out of convex 1\n                vec2.normalize(worldNormal,worldNormal);\n\n                sub(dist, worldPoint, worldPoint0);\n\n                var d = dot(worldNormal,dist);\n\n                if((i === closestEdgeA && d <= precision) || (i !== closestEdgeA && d <= 0)){\n                    insideNumEdges++;\n                }\n            }\n\n            if(insideNumEdges >= 3){\n\n                if(justTest){\n                    return true;\n                }\n\n                // worldPoint was on the \"inside\" side of each of the 3 checked edges.\n                // Project it to the center edge and use the projection direction as normal\n\n                // Create contact\n                var c = this.createContactEquation(bodyA,bodyB,shapeA,shapeB);\n                numContacts++;\n\n                // Get center edge from body A\n                var v0 = shapeA.vertices[(closestEdgeA)   % shapeA.vertices.length],\n                    v1 = shapeA.vertices[(closestEdgeA+1) % shapeA.vertices.length];\n\n                // Construct the edge\n                vec2.rotate(worldPoint0, v0, angleA);\n                vec2.rotate(worldPoint1, v1, angleA);\n                add(worldPoint0, worldPoint0, offsetA);\n                add(worldPoint1, worldPoint1, offsetA);\n\n                sub(worldEdge, worldPoint1, worldPoint0);\n\n                vec2.rotate90cw(c.normalA, worldEdge); // Normal points out of convex A\n                vec2.normalize(c.normalA,c.normalA);\n\n                sub(dist, worldPoint, worldPoint0); // From edge point to the penetrating point\n                var d = dot(c.normalA,dist);             // Penetration\n                vec2.scale(penetrationVec, c.normalA, d);     // Vector penetration\n\n                sub(c.contactPointA, worldPoint, offsetA);\n                sub(c.contactPointA, c.contactPointA, penetrationVec);\n                add(c.contactPointA, c.contactPointA, offsetA);\n                sub(c.contactPointA, c.contactPointA, bodyA.position);\n\n                sub(c.contactPointB, worldPoint, offsetB);\n                add(c.contactPointB, c.contactPointB, offsetB);\n                sub(c.contactPointB, c.contactPointB, bodyB.position);\n\n                this.contactEquations.push(c);\n\n                // Todo reduce to 1 friction equation if we have 2 contact points\n                if(!this.enableFrictionReduction){\n                    if(this.enableFriction){\n                        this.frictionEquations.push(this.createFrictionFromContact(c));\n                    }\n                }\n            }\n        }\n    }\n\n    if(this.enableFrictionReduction){\n        if(this.enableFriction && numContacts){\n            this.frictionEquations.push(this.createFrictionFromAverage(numContacts));\n        }\n    }\n\n    return numContacts;\n};\n\n// .projectConvex is called by other functions, need local tmp vectors\nvar pcoa_tmp1 = vec2.fromValues(0,0);\n\n/**\n * Project a Convex onto a world-oriented axis\n * @method projectConvexOntoAxis\n * @static\n * @param  {Convex} convexShape\n * @param  {Array} convexOffset\n * @param  {Number} convexAngle\n * @param  {Array} worldAxis\n * @param  {Array} result\n */\nNarrowphase.projectConvexOntoAxis = function(convexShape, convexOffset, convexAngle, worldAxis, result){\n    var max=null,\n        min=null,\n        v,\n        value,\n        localAxis = pcoa_tmp1;\n\n    // Convert the axis to local coords of the body\n    vec2.rotate(localAxis, worldAxis, -convexAngle);\n\n    // Get projected position of all vertices\n    for(var i=0; i<convexShape.vertices.length; i++){\n        v = convexShape.vertices[i];\n        value = dot(v,localAxis);\n        if(max === null || value > max){\n            max = value;\n        }\n        if(min === null || value < min){\n            min = value;\n        }\n    }\n\n    if(min > max){\n        var t = min;\n        min = max;\n        max = t;\n    }\n\n    // Project the position of the body onto the axis - need to add this to the result\n    var offset = dot(convexOffset, worldAxis);\n\n    vec2.set( result, min + offset, max + offset);\n};\n\n// .findSeparatingAxis is called by other functions, need local tmp vectors\nvar fsa_tmp1 = vec2.fromValues(0,0)\n,   fsa_tmp2 = vec2.fromValues(0,0)\n,   fsa_tmp3 = vec2.fromValues(0,0)\n,   fsa_tmp4 = vec2.fromValues(0,0)\n,   fsa_tmp5 = vec2.fromValues(0,0)\n,   fsa_tmp6 = vec2.fromValues(0,0);\n\n/**\n * Find a separating axis between the shapes, that maximizes the separating distance between them.\n * @method findSeparatingAxis\n * @static\n * @param  {Convex}     c1\n * @param  {Array}      offset1\n * @param  {Number}     angle1\n * @param  {Convex}     c2\n * @param  {Array}      offset2\n * @param  {Number}     angle2\n * @param  {Array}      sepAxis     The resulting axis\n * @return {Boolean}                Whether the axis could be found.\n */\nNarrowphase.findSeparatingAxis = function(c1,offset1,angle1,c2,offset2,angle2,sepAxis){\n    var maxDist = null,\n        overlap = false,\n        found = false,\n        edge = fsa_tmp1,\n        worldPoint0 = fsa_tmp2,\n        worldPoint1 = fsa_tmp3,\n        normal = fsa_tmp4,\n        span1 = fsa_tmp5,\n        span2 = fsa_tmp6;\n\n    if(c1 instanceof Box && c2 instanceof Box){\n\n        for(var j=0; j!==2; j++){\n            var c = c1,\n                angle = angle1;\n            if(j===1){\n                c = c2;\n                angle = angle2;\n            }\n\n            for(var i=0; i!==2; i++){\n\n                // Get the world edge\n                if(i === 0){\n                    vec2.set(normal, 0, 1);\n                } else if(i === 1) {\n                    vec2.set(normal, 1, 0);\n                }\n                if(angle !== 0){\n                    vec2.rotate(normal, normal, angle);\n                }\n\n                // Project hulls onto that normal\n                Narrowphase.projectConvexOntoAxis(c1,offset1,angle1,normal,span1);\n                Narrowphase.projectConvexOntoAxis(c2,offset2,angle2,normal,span2);\n\n                // Order by span position\n                var a=span1,\n                    b=span2,\n                    swapped = false;\n                if(span1[0] > span2[0]){\n                    b=span1;\n                    a=span2;\n                    swapped = true;\n                }\n\n                // Get separating distance\n                var dist = b[0] - a[1];\n                overlap = (dist <= 0);\n\n                if(maxDist===null || dist > maxDist){\n                    vec2.copy(sepAxis, normal);\n                    maxDist = dist;\n                    found = overlap;\n                }\n            }\n        }\n\n    } else {\n\n        for(var j=0; j!==2; j++){\n            var c = c1,\n                angle = angle1;\n            if(j===1){\n                c = c2;\n                angle = angle2;\n            }\n\n            for(var i=0; i!==c.vertices.length; i++){\n                // Get the world edge\n                vec2.rotate(worldPoint0, c.vertices[i], angle);\n                vec2.rotate(worldPoint1, c.vertices[(i+1)%c.vertices.length], angle);\n\n                sub(edge, worldPoint1, worldPoint0);\n\n                // Get normal - just rotate 90 degrees since vertices are given in CCW\n                vec2.rotate90cw(normal, edge);\n                vec2.normalize(normal,normal);\n\n                // Project hulls onto that normal\n                Narrowphase.projectConvexOntoAxis(c1,offset1,angle1,normal,span1);\n                Narrowphase.projectConvexOntoAxis(c2,offset2,angle2,normal,span2);\n\n                // Order by span position\n                var a=span1,\n                    b=span2,\n                    swapped = false;\n                if(span1[0] > span2[0]){\n                    b=span1;\n                    a=span2;\n                    swapped = true;\n                }\n\n                // Get separating distance\n                var dist = b[0] - a[1];\n                overlap = (dist <= 0);\n\n                if(maxDist===null || dist > maxDist){\n                    vec2.copy(sepAxis, normal);\n                    maxDist = dist;\n                    found = overlap;\n                }\n            }\n        }\n    }\n\n\n    /*\n    // Needs to be tested some more\n    for(var j=0; j!==2; j++){\n        var c = c1,\n            angle = angle1;\n        if(j===1){\n            c = c2;\n            angle = angle2;\n        }\n\n        for(var i=0; i!==c.axes.length; i++){\n\n            var normal = c.axes[i];\n\n            // Project hulls onto that normal\n            Narrowphase.projectConvexOntoAxis(c1, offset1, angle1, normal, span1);\n            Narrowphase.projectConvexOntoAxis(c2, offset2, angle2, normal, span2);\n\n            // Order by span position\n            var a=span1,\n                b=span2,\n                swapped = false;\n            if(span1[0] > span2[0]){\n                b=span1;\n                a=span2;\n                swapped = true;\n            }\n\n            // Get separating distance\n            var dist = b[0] - a[1];\n            overlap = (dist <= Narrowphase.convexPrecision);\n\n            if(maxDist===null || dist > maxDist){\n                vec2.copy(sepAxis, normal);\n                maxDist = dist;\n                found = overlap;\n            }\n        }\n    }\n    */\n\n    return found;\n};\n\n// .getClosestEdge is called by other functions, need local tmp vectors\nvar gce_tmp1 = vec2.fromValues(0,0)\n,   gce_tmp2 = vec2.fromValues(0,0)\n,   gce_tmp3 = vec2.fromValues(0,0);\n\n/**\n * Get the edge that has a normal closest to an axis.\n * @method getClosestEdge\n * @static\n * @param  {Convex}     c\n * @param  {Number}     angle\n * @param  {Array}      axis\n * @param  {Boolean}    flip\n * @return {Number}             Index of the edge that is closest. This index and the next spans the resulting edge. Returns -1 if failed.\n */\nNarrowphase.getClosestEdge = function(c,angle,axis,flip){\n    var localAxis = gce_tmp1,\n        edge = gce_tmp2,\n        normal = gce_tmp3;\n\n    // Convert the axis to local coords of the body\n    vec2.rotate(localAxis, axis, -angle);\n    if(flip){\n        vec2.scale(localAxis,localAxis,-1);\n    }\n\n    var closestEdge = -1,\n        N = c.vertices.length,\n        maxDot = -1;\n    for(var i=0; i!==N; i++){\n        // Get the edge\n        sub(edge, c.vertices[(i+1)%N], c.vertices[i%N]);\n\n        // Get normal - just rotate 90 degrees since vertices are given in CCW\n        vec2.rotate90cw(normal, edge);\n        vec2.normalize(normal,normal);\n\n        var d = dot(normal,localAxis);\n        if(closestEdge === -1 || d > maxDot){\n            closestEdge = i % N;\n            maxDot = d;\n        }\n    }\n\n    return closestEdge;\n};\n\nvar circleHeightfield_candidate = vec2.create(),\n    circleHeightfield_dist = vec2.create(),\n    circleHeightfield_v0 = vec2.create(),\n    circleHeightfield_v1 = vec2.create(),\n    circleHeightfield_minCandidate = vec2.create(),\n    circleHeightfield_worldNormal = vec2.create(),\n    circleHeightfield_minCandidateNormal = vec2.create();\n\n/**\n * @method circleHeightfield\n * @param  {Body}           bi\n * @param  {Circle}         si\n * @param  {Array}          xi\n * @param  {Body}           bj\n * @param  {Heightfield}    sj\n * @param  {Array}          xj\n * @param  {Number}         aj\n */\nNarrowphase.prototype[Shape.CIRCLE | Shape.HEIGHTFIELD] =\nNarrowphase.prototype.circleHeightfield = function( circleBody,circleShape,circlePos,circleAngle,\n                                                    hfBody,hfShape,hfPos,hfAngle, justTest, radius ){\n    var data = hfShape.heights,\n        radius = radius || circleShape.radius,\n        w = hfShape.elementWidth,\n        dist = circleHeightfield_dist,\n        candidate = circleHeightfield_candidate,\n        minCandidate = circleHeightfield_minCandidate,\n        minCandidateNormal = circleHeightfield_minCandidateNormal,\n        worldNormal = circleHeightfield_worldNormal,\n        v0 = circleHeightfield_v0,\n        v1 = circleHeightfield_v1;\n\n    // Get the index of the points to test against\n    var idxA = Math.floor( (circlePos[0] - radius - hfPos[0]) / w ),\n        idxB = Math.ceil(  (circlePos[0] + radius - hfPos[0]) / w );\n\n    /*if(idxB < 0 || idxA >= data.length)\n        return justTest ? false : 0;*/\n\n    if(idxA < 0){\n        idxA = 0;\n    }\n    if(idxB >= data.length){\n        idxB = data.length-1;\n    }\n\n    // Get max and min\n    var max = data[idxA],\n        min = data[idxB];\n    for(var i=idxA; i<idxB; i++){\n        if(data[i] < min){\n            min = data[i];\n        }\n        if(data[i] > max){\n            max = data[i];\n        }\n    }\n\n    if(circlePos[1]-radius > max){\n        return justTest ? false : 0;\n    }\n\n    /*\n    if(circlePos[1]+radius < min){\n        // Below the minimum point... We can just guess.\n        // TODO\n    }\n    */\n\n    // 1. Check so center of circle is not inside the field. If it is, this wont work...\n    // 2. For each edge\n    // 2. 1. Get point on circle that is closest to the edge (scale normal with -radius)\n    // 2. 2. Check if point is inside.\n\n    var found = false;\n\n    // Check all edges first\n    for(var i=idxA; i<idxB; i++){\n\n        // Get points\n        vec2.set(v0,     i*w, data[i]  );\n        vec2.set(v1, (i+1)*w, data[i+1]);\n        vec2.add(v0,v0,hfPos);\n        vec2.add(v1,v1,hfPos);\n\n        // Get normal\n        vec2.sub(worldNormal, v1, v0);\n        vec2.rotate(worldNormal, worldNormal, Math.PI/2);\n        vec2.normalize(worldNormal,worldNormal);\n\n        // Get point on circle, closest to the edge\n        vec2.scale(candidate,worldNormal,-radius);\n        vec2.add(candidate,candidate,circlePos);\n\n        // Distance from v0 to the candidate point\n        vec2.sub(dist,candidate,v0);\n\n        // Check if it is in the element \"stick\"\n        var d = vec2.dot(dist,worldNormal);\n        if(candidate[0] >= v0[0] && candidate[0] < v1[0] && d <= 0){\n\n            if(justTest){\n                return true;\n            }\n\n            found = true;\n\n            // Store the candidate point, projected to the edge\n            vec2.scale(dist,worldNormal,-d);\n            vec2.add(minCandidate,candidate,dist);\n            vec2.copy(minCandidateNormal,worldNormal);\n\n            var c = this.createContactEquation(hfBody,circleBody,hfShape,circleShape);\n\n            // Normal is out of the heightfield\n            vec2.copy(c.normalA, minCandidateNormal);\n\n            // Vector from circle to heightfield\n            vec2.scale(c.contactPointB,  c.normalA, -radius);\n            add(c.contactPointB, c.contactPointB, circlePos);\n            sub(c.contactPointB, c.contactPointB, circleBody.position);\n\n            vec2.copy(c.contactPointA, minCandidate);\n            vec2.sub(c.contactPointA, c.contactPointA, hfBody.position);\n\n            this.contactEquations.push(c);\n\n            if(this.enableFriction){\n                this.frictionEquations.push( this.createFrictionFromContact(c) );\n            }\n        }\n    }\n\n    // Check all vertices\n    found = false;\n    if(radius > 0){\n        for(var i=idxA; i<=idxB; i++){\n\n            // Get point\n            vec2.set(v0, i*w, data[i]);\n            vec2.add(v0,v0,hfPos);\n\n            vec2.sub(dist, circlePos, v0);\n\n            if(vec2.squaredLength(dist) < Math.pow(radius, 2)){\n\n                if(justTest){\n                    return true;\n                }\n\n                found = true;\n\n                var c = this.createContactEquation(hfBody,circleBody,hfShape,circleShape);\n\n                // Construct normal - out of heightfield\n                vec2.copy(c.normalA, dist);\n                vec2.normalize(c.normalA,c.normalA);\n\n                vec2.scale(c.contactPointB, c.normalA, -radius);\n                add(c.contactPointB, c.contactPointB, circlePos);\n                sub(c.contactPointB, c.contactPointB, circleBody.position);\n\n                sub(c.contactPointA, v0, hfPos);\n                add(c.contactPointA, c.contactPointA, hfPos);\n                sub(c.contactPointA, c.contactPointA, hfBody.position);\n\n                this.contactEquations.push(c);\n\n                if(this.enableFriction){\n                    this.frictionEquations.push(this.createFrictionFromContact(c));\n                }\n            }\n        }\n    }\n\n    if(found){\n        return 1;\n    }\n\n    return 0;\n\n};\n\nvar convexHeightfield_v0 = vec2.create(),\n    convexHeightfield_v1 = vec2.create(),\n    convexHeightfield_tilePos = vec2.create(),\n    convexHeightfield_tempConvexShape = new Convex({ vertices: [vec2.create(),vec2.create(),vec2.create(),vec2.create()] });\n/**\n * @method circleHeightfield\n * @param  {Body}           bi\n * @param  {Circle}         si\n * @param  {Array}          xi\n * @param  {Body}           bj\n * @param  {Heightfield}    sj\n * @param  {Array}          xj\n * @param  {Number}         aj\n */\nNarrowphase.prototype[Shape.BOX | Shape.HEIGHTFIELD] =\nNarrowphase.prototype[Shape.CONVEX | Shape.HEIGHTFIELD] =\nNarrowphase.prototype.convexHeightfield = function( convexBody,convexShape,convexPos,convexAngle,\n                                                    hfBody,hfShape,hfPos,hfAngle, justTest ){\n    var data = hfShape.heights,\n        w = hfShape.elementWidth,\n        v0 = convexHeightfield_v0,\n        v1 = convexHeightfield_v1,\n        tilePos = convexHeightfield_tilePos,\n        tileConvex = convexHeightfield_tempConvexShape;\n\n    // Get the index of the points to test against\n    var idxA = Math.floor( (convexBody.aabb.lowerBound[0] - hfPos[0]) / w ),\n        idxB = Math.ceil(  (convexBody.aabb.upperBound[0] - hfPos[0]) / w );\n\n    if(idxA < 0){\n        idxA = 0;\n    }\n    if(idxB >= data.length){\n        idxB = data.length-1;\n    }\n\n    // Get max and min\n    var max = data[idxA],\n        min = data[idxB];\n    for(var i=idxA; i<idxB; i++){\n        if(data[i] < min){\n            min = data[i];\n        }\n        if(data[i] > max){\n            max = data[i];\n        }\n    }\n\n    if(convexBody.aabb.lowerBound[1] > max){\n        return justTest ? false : 0;\n    }\n\n    var found = false;\n    var numContacts = 0;\n\n    // Loop over all edges\n    // TODO: If possible, construct a convex from several data points (need o check if the points make a convex shape)\n    for(var i=idxA; i<idxB; i++){\n\n        // Get points\n        vec2.set(v0,     i*w, data[i]  );\n        vec2.set(v1, (i+1)*w, data[i+1]);\n        vec2.add(v0,v0,hfPos);\n        vec2.add(v1,v1,hfPos);\n\n        // Construct a convex\n        var tileHeight = 100; // todo\n        vec2.set(tilePos, (v1[0] + v0[0])*0.5, (v1[1] + v0[1] - tileHeight)*0.5);\n\n        vec2.sub(tileConvex.vertices[0], v1, tilePos);\n        vec2.sub(tileConvex.vertices[1], v0, tilePos);\n        vec2.copy(tileConvex.vertices[2], tileConvex.vertices[1]);\n        vec2.copy(tileConvex.vertices[3], tileConvex.vertices[0]);\n        tileConvex.vertices[2][1] -= tileHeight;\n        tileConvex.vertices[3][1] -= tileHeight;\n\n        // Do convex collision\n        numContacts += this.convexConvex(   convexBody, convexShape, convexPos, convexAngle,\n                                            hfBody, tileConvex, tilePos, 0, justTest);\n    }\n\n    return numContacts;\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///25\n");

/***/ }),
/* 26 */
/* no static exports found */
/* all exports used */
/*!*********************************************!*\
  !*** ./~/p2/src/collision/SAPBroadphase.js ***!
  \*********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Utils = __webpack_require__(/*! ../utils/Utils */ 1)\n,   Broadphase = __webpack_require__(/*! ../collision/Broadphase */ 12);\n\nmodule.exports = SAPBroadphase;\n\n/**\n * Sweep and prune broadphase along one axis.\n *\n * @class SAPBroadphase\n * @constructor\n * @extends Broadphase\n */\nfunction SAPBroadphase(){\n    Broadphase.call(this,Broadphase.SAP);\n\n    /**\n     * List of bodies currently in the broadphase.\n     * @property axisList\n     * @type {Array}\n     */\n    this.axisList = [];\n\n    /**\n     * The axis to sort along. 0 means x-axis and 1 y-axis. If your bodies are more spread out over the X axis, set axisIndex to 0, and you will gain some performance.\n     * @property axisIndex\n     * @type {Number}\n     */\n    this.axisIndex = 0;\n\n    var that = this;\n    this._addBodyHandler = function(e){\n        that.axisList.push(e.body);\n    };\n\n    this._removeBodyHandler = function(e){\n        // Remove from list\n        var idx = that.axisList.indexOf(e.body);\n        if(idx !== -1){\n            that.axisList.splice(idx,1);\n        }\n    };\n}\nSAPBroadphase.prototype = new Broadphase();\nSAPBroadphase.prototype.constructor = SAPBroadphase;\n\n/**\n * Change the world\n * @method setWorld\n * @param {World} world\n */\nSAPBroadphase.prototype.setWorld = function(world){\n    // Clear the old axis array\n    this.axisList.length = 0;\n\n    // Add all bodies from the new world\n    Utils.appendArray(this.axisList, world.bodies);\n\n    // Remove old handlers, if any\n    world\n        .off(\"addBody\",this._addBodyHandler)\n        .off(\"removeBody\",this._removeBodyHandler);\n\n    // Add handlers to update the list of bodies.\n    world.on(\"addBody\",this._addBodyHandler).on(\"removeBody\",this._removeBodyHandler);\n\n    this.world = world;\n};\n\n/**\n * Sorts bodies along an axis.\n * @method sortAxisList\n * @param {Array} a\n * @param {number} axisIndex\n * @return {Array}\n */\nSAPBroadphase.sortAxisList = function(a, axisIndex){\n    axisIndex = axisIndex|0;\n    for(var i=1,l=a.length; i<l; i++) {\n        var v = a[i];\n        for(var j=i - 1;j>=0;j--) {\n            if(a[j].aabb.lowerBound[axisIndex] <= v.aabb.lowerBound[axisIndex]){\n                break;\n            }\n            a[j+1] = a[j];\n        }\n        a[j+1] = v;\n    }\n    return a;\n};\n\nSAPBroadphase.prototype.sortList = function(){\n    var bodies = this.axisList,\n    axisIndex = this.axisIndex;\n\n    // Sort the lists\n    SAPBroadphase.sortAxisList(bodies, axisIndex);\n};\n\n/**\n * Get the colliding pairs\n * @method getCollisionPairs\n * @param  {World} world\n * @return {Array}\n */\nSAPBroadphase.prototype.getCollisionPairs = function(world){\n    var bodies = this.axisList,\n        result = this.result,\n        axisIndex = this.axisIndex;\n\n    result.length = 0;\n\n    // Update all AABBs if needed\n    var l = bodies.length;\n    while(l--){\n        var b = bodies[l];\n        if(b.aabbNeedsUpdate){\n            b.updateAABB();\n        }\n    }\n\n    // Sort the lists\n    this.sortList();\n\n    // Look through the X list\n    for(var i=0, N=bodies.length|0; i!==N; i++){\n        var bi = bodies[i];\n\n        for(var j=i+1; j<N; j++){\n            var bj = bodies[j];\n\n            // Bounds overlap?\n            var overlaps = (bj.aabb.lowerBound[axisIndex] <= bi.aabb.upperBound[axisIndex]);\n            if(!overlaps){\n                break;\n            }\n\n            if(Broadphase.canCollide(bi,bj) && this.boundingVolumeCheck(bi,bj)){\n                result.push(bi,bj);\n            }\n        }\n    }\n\n    return result;\n};\n\n/**\n * Returns all the bodies within an AABB.\n * @method aabbQuery\n * @param  {World} world\n * @param  {AABB} aabb\n * @param {array} result An array to store resulting bodies in.\n * @return {array}\n */\nSAPBroadphase.prototype.aabbQuery = function(world, aabb, result){\n    result = result || [];\n\n    this.sortList();\n\n    var axisIndex = this.axisIndex;\n    var axis = 'x';\n    if(axisIndex === 1){ axis = 'y'; }\n    if(axisIndex === 2){ axis = 'z'; }\n\n    var axisList = this.axisList;\n    var lower = aabb.lowerBound[axis];\n    var upper = aabb.upperBound[axis];\n    for(var i = 0; i < axisList.length; i++){\n        var b = axisList[i];\n\n        if(b.aabbNeedsUpdate){\n            b.updateAABB();\n        }\n\n        if(b.aabb.overlaps(aabb)){\n            result.push(b);\n        }\n    }\n\n    return result;\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///26\n");

/***/ }),
/* 27 */
/* no static exports found */
/* all exports used */
/*!****************************************************!*\
  !*** ./~/p2/src/constraints/DistanceConstraint.js ***!
  \****************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Constraint = __webpack_require__(/*! ./Constraint */ 6)\n,   Equation = __webpack_require__(/*! ../equations/Equation */ 2)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\nmodule.exports = DistanceConstraint;\n\n/**\n * Constraint that tries to keep the distance between two bodies constant.\n *\n * @class DistanceConstraint\n * @constructor\n * @author schteppe\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {object} [options]\n * @param {number} [options.distance] The distance to keep between the anchor points. Defaults to the current distance between the bodies.\n * @param {Array} [options.localAnchorA] The anchor point for bodyA, defined locally in bodyA frame. Defaults to [0,0].\n * @param {Array} [options.localAnchorB] The anchor point for bodyB, defined locally in bodyB frame. Defaults to [0,0].\n * @param {object} [options.maxForce=Number.MAX_VALUE] Maximum force to apply.\n * @extends Constraint\n *\n * @example\n *     // If distance is not given as an option, then the current distance between the bodies is used.\n *     // In this example, the bodies will be constrained to have a distance of 2 between their centers.\n *     var bodyA = new Body({ mass: 1, position: [-1, 0] });\n *     var bodyB = new Body({ mass: 1, position: [1, 0] });\n *     var constraint = new DistanceConstraint(bodyA, bodyB);\n *     world.addConstraint(constraint);\n *\n * @example\n *     // Manually set the distance and anchors\n *     var constraint = new DistanceConstraint(bodyA, bodyB, {\n *         distance: 1,          // Distance to keep between the points\n *         localAnchorA: [1, 0], // Point on bodyA\n *         localAnchorB: [-1, 0] // Point on bodyB\n *     });\n *     world.addConstraint(constraint);\n */\nfunction DistanceConstraint(bodyA,bodyB,options){\n    options = Utils.defaults(options,{\n        localAnchorA:[0,0],\n        localAnchorB:[0,0]\n    });\n\n    Constraint.call(this,bodyA,bodyB,Constraint.DISTANCE,options);\n\n    /**\n     * Local anchor in body A.\n     * @property localAnchorA\n     * @type {Array}\n     */\n    this.localAnchorA = vec2.fromValues(options.localAnchorA[0], options.localAnchorA[1]);\n\n    /**\n     * Local anchor in body B.\n     * @property localAnchorB\n     * @type {Array}\n     */\n    this.localAnchorB = vec2.fromValues(options.localAnchorB[0], options.localAnchorB[1]);\n\n    var localAnchorA = this.localAnchorA;\n    var localAnchorB = this.localAnchorB;\n\n    /**\n     * The distance to keep.\n     * @property distance\n     * @type {Number}\n     */\n    this.distance = 0;\n\n    if(typeof(options.distance) === 'number'){\n        this.distance = options.distance;\n    } else {\n        // Use the current world distance between the world anchor points.\n        var worldAnchorA = vec2.create(),\n            worldAnchorB = vec2.create(),\n            r = vec2.create();\n\n        // Transform local anchors to world\n        vec2.rotate(worldAnchorA, localAnchorA, bodyA.angle);\n        vec2.rotate(worldAnchorB, localAnchorB, bodyB.angle);\n\n        vec2.add(r, bodyB.position, worldAnchorB);\n        vec2.sub(r, r, worldAnchorA);\n        vec2.sub(r, r, bodyA.position);\n\n        this.distance = vec2.length(r);\n    }\n\n    var maxForce;\n    if(typeof(options.maxForce)===\"undefined\" ){\n        maxForce = Number.MAX_VALUE;\n    } else {\n        maxForce = options.maxForce;\n    }\n\n    var normal = new Equation(bodyA,bodyB,-maxForce,maxForce); // Just in the normal direction\n    this.equations = [ normal ];\n\n    /**\n     * Max force to apply.\n     * @property {number} maxForce\n     */\n    this.maxForce = maxForce;\n\n    // g = (xi - xj).dot(n)\n    // dg/dt = (vi - vj).dot(n) = G*W = [n 0 -n 0] * [vi wi vj wj]'\n\n    // ...and if we were to include offset points:\n    // g =\n    //      (xj + rj - xi - ri).dot(n) - distance\n    //\n    // dg/dt =\n    //      (vj + wj x rj - vi - wi x ri).dot(n) =\n    //      { term 2 is near zero } =\n    //      [-n   -ri x n   n   rj x n] * [vi wi vj wj]' =\n    //      G * W\n    //\n    // => G = [-n -rixn n rjxn]\n\n    var r = vec2.create();\n    var ri = vec2.create(); // worldAnchorA\n    var rj = vec2.create(); // worldAnchorB\n    var that = this;\n    normal.computeGq = function(){\n        var bodyA = this.bodyA,\n            bodyB = this.bodyB,\n            xi = bodyA.position,\n            xj = bodyB.position;\n\n        // Transform local anchors to world\n        vec2.rotate(ri, localAnchorA, bodyA.angle);\n        vec2.rotate(rj, localAnchorB, bodyB.angle);\n\n        vec2.add(r, xj, rj);\n        vec2.sub(r, r, ri);\n        vec2.sub(r, r, xi);\n\n        //vec2.sub(r, bodyB.position, bodyA.position);\n        return vec2.length(r) - that.distance;\n    };\n\n    // Make the contact constraint bilateral\n    this.setMaxForce(maxForce);\n\n    /**\n     * If the upper limit is enabled or not.\n     * @property {Boolean} upperLimitEnabled\n     */\n    this.upperLimitEnabled = false;\n\n    /**\n     * The upper constraint limit.\n     * @property {number} upperLimit\n     */\n    this.upperLimit = 1;\n\n    /**\n     * If the lower limit is enabled or not.\n     * @property {Boolean} lowerLimitEnabled\n     */\n    this.lowerLimitEnabled = false;\n\n    /**\n     * The lower constraint limit.\n     * @property {number} lowerLimit\n     */\n    this.lowerLimit = 0;\n\n    /**\n     * Current constraint position. This is equal to the current distance between the world anchor points.\n     * @property {number} position\n     */\n    this.position = 0;\n}\nDistanceConstraint.prototype = new Constraint();\nDistanceConstraint.prototype.constructor = DistanceConstraint;\n\n/**\n * Update the constraint equations. Should be done if any of the bodies changed position, before solving.\n * @method update\n */\nvar n = vec2.create();\nvar ri = vec2.create(); // worldAnchorA\nvar rj = vec2.create(); // worldAnchorB\nDistanceConstraint.prototype.update = function(){\n    var normal = this.equations[0],\n        bodyA = this.bodyA,\n        bodyB = this.bodyB,\n        distance = this.distance,\n        xi = bodyA.position,\n        xj = bodyB.position,\n        normalEquation = this.equations[0],\n        G = normal.G;\n\n    // Transform local anchors to world\n    vec2.rotate(ri, this.localAnchorA, bodyA.angle);\n    vec2.rotate(rj, this.localAnchorB, bodyB.angle);\n\n    // Get world anchor points and normal\n    vec2.add(n, xj, rj);\n    vec2.sub(n, n, ri);\n    vec2.sub(n, n, xi);\n    this.position = vec2.length(n);\n\n    var violating = false;\n    if(this.upperLimitEnabled){\n        if(this.position > this.upperLimit){\n            normalEquation.maxForce = 0;\n            normalEquation.minForce = -this.maxForce;\n            this.distance = this.upperLimit;\n            violating = true;\n        }\n    }\n\n    if(this.lowerLimitEnabled){\n        if(this.position < this.lowerLimit){\n            normalEquation.maxForce = this.maxForce;\n            normalEquation.minForce = 0;\n            this.distance = this.lowerLimit;\n            violating = true;\n        }\n    }\n\n    if((this.lowerLimitEnabled || this.upperLimitEnabled) && !violating){\n        // No constraint needed.\n        normalEquation.enabled = false;\n        return;\n    }\n\n    normalEquation.enabled = true;\n\n    vec2.normalize(n,n);\n\n    // Caluclate cross products\n    var rixn = vec2.crossLength(ri, n),\n        rjxn = vec2.crossLength(rj, n);\n\n    // G = [-n -rixn n rjxn]\n    G[0] = -n[0];\n    G[1] = -n[1];\n    G[2] = -rixn;\n    G[3] = n[0];\n    G[4] = n[1];\n    G[5] = rjxn;\n};\n\n/**\n * Set the max force to be used\n * @method setMaxForce\n * @param {Number} maxForce\n */\nDistanceConstraint.prototype.setMaxForce = function(maxForce){\n    var normal = this.equations[0];\n    normal.minForce = -maxForce;\n    normal.maxForce =  maxForce;\n};\n\n/**\n * Get the max force\n * @method getMaxForce\n * @return {Number}\n */\nDistanceConstraint.prototype.getMaxForce = function(){\n    var normal = this.equations[0];\n    return normal.maxForce;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///27\n");

/***/ }),
/* 28 */
/* no static exports found */
/* all exports used */
/*!************************************************!*\
  !*** ./~/p2/src/constraints/GearConstraint.js ***!
  \************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Constraint = __webpack_require__(/*! ./Constraint */ 6)\n,   Equation = __webpack_require__(/*! ../equations/Equation */ 2)\n,   AngleLockEquation = __webpack_require__(/*! ../equations/AngleLockEquation */ 32)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = GearConstraint;\n\n/**\n * Constrains the angle of two bodies to each other to be equal. If a gear ratio is not one, the angle of bodyA must be a multiple of the angle of bodyB.\n * @class GearConstraint\n * @constructor\n * @author schteppe\n * @param {Body}            bodyA\n * @param {Body}            bodyB\n * @param {Object}          [options]\n * @param {Number}          [options.angle=0] Relative angle between the bodies. Will be set to the current angle between the bodies (the gear ratio is accounted for).\n * @param {Number}          [options.ratio=1] Gear ratio.\n * @param {Number}          [options.maxTorque] Maximum torque to apply.\n * @extends Constraint\n *\n * @example\n *     var constraint = new GearConstraint(bodyA, bodyB);\n *     world.addConstraint(constraint);\n *\n * @example\n *     var constraint = new GearConstraint(bodyA, bodyB, {\n *         ratio: 2,\n *         maxTorque: 1000\n *     });\n *     world.addConstraint(constraint);\n */\nfunction GearConstraint(bodyA, bodyB, options){\n    options = options || {};\n\n    Constraint.call(this, bodyA, bodyB, Constraint.GEAR, options);\n\n    /**\n     * The gear ratio.\n     * @property ratio\n     * @type {Number}\n     */\n    this.ratio = options.ratio !== undefined ? options.ratio : 1;\n\n    /**\n     * The relative angle\n     * @property angle\n     * @type {Number}\n     */\n    this.angle = options.angle !== undefined ? options.angle : bodyB.angle - this.ratio * bodyA.angle;\n\n    // Send same parameters to the equation\n    options.angle = this.angle;\n    options.ratio = this.ratio;\n\n    this.equations = [\n        new AngleLockEquation(bodyA,bodyB,options),\n    ];\n\n    // Set max torque\n    if(options.maxTorque !== undefined){\n        this.setMaxTorque(options.maxTorque);\n    }\n}\nGearConstraint.prototype = new Constraint();\nGearConstraint.prototype.constructor = GearConstraint;\n\nGearConstraint.prototype.update = function(){\n    var eq = this.equations[0];\n    if(eq.ratio !== this.ratio){\n        eq.setRatio(this.ratio);\n    }\n    eq.angle = this.angle;\n};\n\n/**\n * Set the max torque for the constraint.\n * @method setMaxTorque\n * @param {Number} torque\n */\nGearConstraint.prototype.setMaxTorque = function(torque){\n    this.equations[0].setMaxTorque(torque);\n};\n\n/**\n * Get the max torque for the constraint.\n * @method getMaxTorque\n * @return {Number}\n */\nGearConstraint.prototype.getMaxTorque = function(torque){\n    return this.equations[0].maxForce;\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///28\n");

/***/ }),
/* 29 */
/* no static exports found */
/* all exports used */
/*!************************************************!*\
  !*** ./~/p2/src/constraints/LockConstraint.js ***!
  \************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Constraint = __webpack_require__(/*! ./Constraint */ 6)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   Equation = __webpack_require__(/*! ../equations/Equation */ 2);\n\nmodule.exports = LockConstraint;\n\n/**\n * Locks the relative position and rotation between two bodies.\n *\n * @class LockConstraint\n * @constructor\n * @author schteppe\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {Object} [options]\n * @param {Array}  [options.localOffsetB] The offset of bodyB in bodyA's frame. If not given the offset is computed from current positions.\n * @param {number} [options.localAngleB] The angle of bodyB in bodyA's frame. If not given, the angle is computed from current angles.\n * @param {number} [options.maxForce]\n * @extends Constraint\n *\n * @example\n *     // Locks the relative position and rotation between bodyA and bodyB\n *     var constraint = new LockConstraint(bodyA, bodyB);\n *     world.addConstraint(constraint);\n */\nfunction LockConstraint(bodyA, bodyB, options){\n    options = options || {};\n\n    Constraint.call(this,bodyA,bodyB,Constraint.LOCK,options);\n\n    var maxForce = ( typeof(options.maxForce)===\"undefined\" ? Number.MAX_VALUE : options.maxForce );\n\n    var localAngleB = options.localAngleB || 0;\n\n    // Use 3 equations:\n    // gx =   (xj - xi - l) * xhat = 0\n    // gy =   (xj - xi - l) * yhat = 0\n    // gr =   (xi - xj + r) * that = 0\n    //\n    // ...where:\n    //   l is the localOffsetB vector rotated to world in bodyA frame\n    //   r is the same vector but reversed and rotated from bodyB frame\n    //   xhat, yhat are world axis vectors\n    //   that is the tangent of r\n    //\n    // For the first two constraints, we get\n    // G*W = (vj - vi - ldot  ) * xhat\n    //     = (vj - vi - wi x l) * xhat\n    //\n    // Since (wi x l) * xhat = (l x xhat) * wi, we get\n    // G*W = [ -1   0   (-l x xhat)  1   0   0] * [vi wi vj wj]\n    //\n    // The last constraint gives\n    // GW = (vi - vj + wj x r) * that\n    //    = [  that   0  -that  (r x t) ]\n\n    var x =     new Equation(bodyA,bodyB,-maxForce,maxForce),\n        y =     new Equation(bodyA,bodyB,-maxForce,maxForce),\n        rot =   new Equation(bodyA,bodyB,-maxForce,maxForce);\n\n    var l = vec2.create(),\n        g = vec2.create(),\n        that = this;\n    x.computeGq = function(){\n        vec2.rotate(l, that.localOffsetB, bodyA.angle);\n        vec2.sub(g, bodyB.position, bodyA.position);\n        vec2.sub(g, g, l);\n        return g[0];\n    };\n    y.computeGq = function(){\n        vec2.rotate(l, that.localOffsetB, bodyA.angle);\n        vec2.sub(g, bodyB.position, bodyA.position);\n        vec2.sub(g, g, l);\n        return g[1];\n    };\n    var r = vec2.create(),\n        t = vec2.create();\n    rot.computeGq = function(){\n        vec2.rotate(r, that.localOffsetB, bodyB.angle - that.localAngleB);\n        vec2.scale(r,r,-1);\n        vec2.sub(g,bodyA.position,bodyB.position);\n        vec2.add(g,g,r);\n        vec2.rotate(t,r,-Math.PI/2);\n        vec2.normalize(t,t);\n        return vec2.dot(g,t);\n    };\n\n    /**\n     * The offset of bodyB in bodyA's frame.\n     * @property {Array} localOffsetB\n     */\n    this.localOffsetB = vec2.create();\n    if(options.localOffsetB){\n        vec2.copy(this.localOffsetB, options.localOffsetB);\n    } else {\n        // Construct from current positions\n        vec2.sub(this.localOffsetB, bodyB.position, bodyA.position);\n        vec2.rotate(this.localOffsetB, this.localOffsetB, -bodyA.angle);\n    }\n\n    /**\n     * The offset angle of bodyB in bodyA's frame.\n     * @property {Number} localAngleB\n     */\n    this.localAngleB = 0;\n    if(typeof(options.localAngleB) === 'number'){\n        this.localAngleB = options.localAngleB;\n    } else {\n        // Construct\n        this.localAngleB = bodyB.angle - bodyA.angle;\n    }\n\n    this.equations.push(x, y, rot);\n    this.setMaxForce(maxForce);\n}\nLockConstraint.prototype = new Constraint();\nLockConstraint.prototype.constructor = LockConstraint;\n\n/**\n * Set the maximum force to be applied.\n * @method setMaxForce\n * @param {Number} force\n */\nLockConstraint.prototype.setMaxForce = function(force){\n    var eqs = this.equations;\n    for(var i=0; i<this.equations.length; i++){\n        eqs[i].maxForce =  force;\n        eqs[i].minForce = -force;\n    }\n};\n\n/**\n * Get the max force.\n * @method getMaxForce\n * @return {Number}\n */\nLockConstraint.prototype.getMaxForce = function(){\n    return this.equations[0].maxForce;\n};\n\nvar l = vec2.create();\nvar r = vec2.create();\nvar t = vec2.create();\nvar xAxis = vec2.fromValues(1,0);\nvar yAxis = vec2.fromValues(0,1);\nLockConstraint.prototype.update = function(){\n    var x =   this.equations[0],\n        y =   this.equations[1],\n        rot = this.equations[2],\n        bodyA = this.bodyA,\n        bodyB = this.bodyB;\n\n    vec2.rotate(l,this.localOffsetB,bodyA.angle);\n    vec2.rotate(r,this.localOffsetB,bodyB.angle - this.localAngleB);\n    vec2.scale(r,r,-1);\n\n    vec2.rotate(t,r,Math.PI/2);\n    vec2.normalize(t,t);\n\n    x.G[0] = -1;\n    x.G[1] =  0;\n    x.G[2] = -vec2.crossLength(l,xAxis);\n    x.G[3] =  1;\n\n    y.G[0] =  0;\n    y.G[1] = -1;\n    y.G[2] = -vec2.crossLength(l,yAxis);\n    y.G[4] =  1;\n\n    rot.G[0] =  -t[0];\n    rot.G[1] =  -t[1];\n    rot.G[3] =  t[0];\n    rot.G[4] =  t[1];\n    rot.G[5] =  vec2.crossLength(r,t);\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///29\n");

/***/ }),
/* 30 */
/* no static exports found */
/* all exports used */
/*!*****************************************************!*\
  !*** ./~/p2/src/constraints/PrismaticConstraint.js ***!
  \*****************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Constraint = __webpack_require__(/*! ./Constraint */ 6)\n,   ContactEquation = __webpack_require__(/*! ../equations/ContactEquation */ 14)\n,   Equation = __webpack_require__(/*! ../equations/Equation */ 2)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   RotationalLockEquation = __webpack_require__(/*! ../equations/RotationalLockEquation */ 33);\n\nmodule.exports = PrismaticConstraint;\n\n/**\n * Constraint that only allows bodies to move along a line, relative to each other. See <a href=\"http://www.iforce2d.net/b2dtut/joints-prismatic\">this tutorial</a>. Also called \"slider constraint\".\n *\n * @class PrismaticConstraint\n * @constructor\n * @extends Constraint\n * @author schteppe\n * @param {Body}    bodyA\n * @param {Body}    bodyB\n * @param {Object}  [options]\n * @param {Number}  [options.maxForce]                Max force to be applied by the constraint\n * @param {Array}   [options.localAnchorA]            Body A's anchor point, defined in its own local frame.\n * @param {Array}   [options.localAnchorB]            Body B's anchor point, defined in its own local frame.\n * @param {Array}   [options.localAxisA]              An axis, defined in body A frame, that body B's anchor point may slide along.\n * @param {Boolean} [options.disableRotationalLock]   If set to true, bodyB will be free to rotate around its anchor point.\n * @param {Number}  [options.upperLimit]\n * @param {Number}  [options.lowerLimit]\n * @todo Ability to create using only a point and a worldAxis\n */\nfunction PrismaticConstraint(bodyA, bodyB, options){\n    options = options || {};\n    Constraint.call(this,bodyA,bodyB,Constraint.PRISMATIC,options);\n\n    // Get anchors\n    var localAnchorA = vec2.fromValues(0,0),\n        localAxisA = vec2.fromValues(1,0),\n        localAnchorB = vec2.fromValues(0,0);\n    if(options.localAnchorA){ vec2.copy(localAnchorA, options.localAnchorA); }\n    if(options.localAxisA){ vec2.copy(localAxisA,   options.localAxisA); }\n    if(options.localAnchorB){ vec2.copy(localAnchorB, options.localAnchorB); }\n\n    /**\n     * @property localAnchorA\n     * @type {Array}\n     */\n    this.localAnchorA = localAnchorA;\n\n    /**\n     * @property localAnchorB\n     * @type {Array}\n     */\n    this.localAnchorB = localAnchorB;\n\n    /**\n     * @property localAxisA\n     * @type {Array}\n     */\n    this.localAxisA = localAxisA;\n\n    /*\n\n    The constraint violation for the common axis point is\n\n        g = ( xj + rj - xi - ri ) * t   :=  gg*t\n\n    where r are body-local anchor points, and t is a tangent to the constraint axis defined in body i frame.\n\n        gdot =  ( vj + wj x rj - vi - wi x ri ) * t + ( xj + rj - xi - ri ) * ( wi x t )\n\n    Note the use of the chain rule. Now we identify the jacobian\n\n        G*W = [ -t      -ri x t + t x gg     t    rj x t ] * [vi wi vj wj]\n\n    The rotational part is just a rotation lock.\n\n     */\n\n    var maxForce = this.maxForce = typeof(options.maxForce)!==\"undefined\" ? options.maxForce : Number.MAX_VALUE;\n\n    // Translational part\n    var trans = new Equation(bodyA,bodyB,-maxForce,maxForce);\n    var ri = new vec2.create(),\n        rj = new vec2.create(),\n        gg = new vec2.create(),\n        t =  new vec2.create();\n    trans.computeGq = function(){\n        // g = ( xj + rj - xi - ri ) * t\n        return vec2.dot(gg,t);\n    };\n    trans.updateJacobian = function(){\n        var G = this.G,\n            xi = bodyA.position,\n            xj = bodyB.position;\n        vec2.rotate(ri,localAnchorA,bodyA.angle);\n        vec2.rotate(rj,localAnchorB,bodyB.angle);\n        vec2.add(gg,xj,rj);\n        vec2.sub(gg,gg,xi);\n        vec2.sub(gg,gg,ri);\n        vec2.rotate(t,localAxisA,bodyA.angle+Math.PI/2);\n\n        G[0] = -t[0];\n        G[1] = -t[1];\n        G[2] = -vec2.crossLength(ri,t) + vec2.crossLength(t,gg);\n        G[3] = t[0];\n        G[4] = t[1];\n        G[5] = vec2.crossLength(rj,t);\n    };\n    this.equations.push(trans);\n\n    // Rotational part\n    if(!options.disableRotationalLock){\n        var rot = new RotationalLockEquation(bodyA,bodyB,-maxForce,maxForce);\n        this.equations.push(rot);\n    }\n\n    /**\n     * The position of anchor A relative to anchor B, along the constraint axis.\n     * @property position\n     * @type {Number}\n     */\n    this.position = 0;\n\n    // Is this one used at all?\n    this.velocity = 0;\n\n    /**\n     * Set to true to enable lower limit.\n     * @property lowerLimitEnabled\n     * @type {Boolean}\n     */\n    this.lowerLimitEnabled = typeof(options.lowerLimit)!==\"undefined\" ? true : false;\n\n    /**\n     * Set to true to enable upper limit.\n     * @property upperLimitEnabled\n     * @type {Boolean}\n     */\n    this.upperLimitEnabled = typeof(options.upperLimit)!==\"undefined\" ? true : false;\n\n    /**\n     * Lower constraint limit. The constraint position is forced to be larger than this value.\n     * @property lowerLimit\n     * @type {Number}\n     */\n    this.lowerLimit = typeof(options.lowerLimit)!==\"undefined\" ? options.lowerLimit : 0;\n\n    /**\n     * Upper constraint limit. The constraint position is forced to be smaller than this value.\n     * @property upperLimit\n     * @type {Number}\n     */\n    this.upperLimit = typeof(options.upperLimit)!==\"undefined\" ? options.upperLimit : 1;\n\n    // Equations used for limits\n    this.upperLimitEquation = new ContactEquation(bodyA,bodyB);\n    this.lowerLimitEquation = new ContactEquation(bodyA,bodyB);\n\n    // Set max/min forces\n    this.upperLimitEquation.minForce = this.lowerLimitEquation.minForce = 0;\n    this.upperLimitEquation.maxForce = this.lowerLimitEquation.maxForce = maxForce;\n\n    /**\n     * Equation used for the motor.\n     * @property motorEquation\n     * @type {Equation}\n     */\n    this.motorEquation = new Equation(bodyA,bodyB);\n\n    /**\n     * The current motor state. Enable or disable the motor using .enableMotor\n     * @property motorEnabled\n     * @type {Boolean}\n     */\n    this.motorEnabled = false;\n\n    /**\n     * Set the target speed for the motor.\n     * @property motorSpeed\n     * @type {Number}\n     */\n    this.motorSpeed = 0;\n\n    var that = this;\n    var motorEquation = this.motorEquation;\n    var old = motorEquation.computeGW;\n    motorEquation.computeGq = function(){ return 0; };\n    motorEquation.computeGW = function(){\n        var G = this.G,\n            bi = this.bodyA,\n            bj = this.bodyB,\n            vi = bi.velocity,\n            vj = bj.velocity,\n            wi = bi.angularVelocity,\n            wj = bj.angularVelocity;\n        return this.gmult(G,vi,wi,vj,wj) + that.motorSpeed;\n    };\n}\n\nPrismaticConstraint.prototype = new Constraint();\nPrismaticConstraint.prototype.constructor = PrismaticConstraint;\n\nvar worldAxisA = vec2.create(),\n    worldAnchorA = vec2.create(),\n    worldAnchorB = vec2.create(),\n    orientedAnchorA = vec2.create(),\n    orientedAnchorB = vec2.create(),\n    tmp = vec2.create();\n\n/**\n * Update the constraint equations. Should be done if any of the bodies changed position, before solving.\n * @method update\n */\nPrismaticConstraint.prototype.update = function(){\n    var eqs = this.equations,\n        trans = eqs[0],\n        upperLimit = this.upperLimit,\n        lowerLimit = this.lowerLimit,\n        upperLimitEquation = this.upperLimitEquation,\n        lowerLimitEquation = this.lowerLimitEquation,\n        bodyA = this.bodyA,\n        bodyB = this.bodyB,\n        localAxisA = this.localAxisA,\n        localAnchorA = this.localAnchorA,\n        localAnchorB = this.localAnchorB;\n\n    trans.updateJacobian();\n\n    // Transform local things to world\n    vec2.rotate(worldAxisA,      localAxisA,      bodyA.angle);\n    vec2.rotate(orientedAnchorA, localAnchorA,    bodyA.angle);\n    vec2.add(worldAnchorA,       orientedAnchorA, bodyA.position);\n    vec2.rotate(orientedAnchorB, localAnchorB,    bodyB.angle);\n    vec2.add(worldAnchorB,       orientedAnchorB, bodyB.position);\n\n    var relPosition = this.position = vec2.dot(worldAnchorB,worldAxisA) - vec2.dot(worldAnchorA,worldAxisA);\n\n    // Motor\n    if(this.motorEnabled){\n        // G = [ a     a x ri   -a   -a x rj ]\n        var G = this.motorEquation.G;\n        G[0] = worldAxisA[0];\n        G[1] = worldAxisA[1];\n        G[2] = vec2.crossLength(worldAxisA,orientedAnchorB);\n        G[3] = -worldAxisA[0];\n        G[4] = -worldAxisA[1];\n        G[5] = -vec2.crossLength(worldAxisA,orientedAnchorA);\n    }\n\n    /*\n        Limits strategy:\n        Add contact equation, with normal along the constraint axis.\n        min/maxForce is set so the constraint is repulsive in the correct direction.\n        Some offset is added to either equation.contactPointA or .contactPointB to get the correct upper/lower limit.\n\n                 ^\n                 |\n      upperLimit x\n                 |    ------\n         anchorB x<---|  B |\n                 |    |    |\n        ------   |    ------\n        |    |   |\n        |  A |-->x anchorA\n        ------   |\n                 x lowerLimit\n                 |\n                axis\n     */\n\n\n    if(this.upperLimitEnabled && relPosition > upperLimit){\n        // Update contact constraint normal, etc\n        vec2.scale(upperLimitEquation.normalA, worldAxisA, -1);\n        vec2.sub(upperLimitEquation.contactPointA, worldAnchorA, bodyA.position);\n        vec2.sub(upperLimitEquation.contactPointB, worldAnchorB, bodyB.position);\n        vec2.scale(tmp,worldAxisA,upperLimit);\n        vec2.add(upperLimitEquation.contactPointA,upperLimitEquation.contactPointA,tmp);\n        if(eqs.indexOf(upperLimitEquation) === -1){\n            eqs.push(upperLimitEquation);\n        }\n    } else {\n        var idx = eqs.indexOf(upperLimitEquation);\n        if(idx !== -1){\n            eqs.splice(idx,1);\n        }\n    }\n\n    if(this.lowerLimitEnabled && relPosition < lowerLimit){\n        // Update contact constraint normal, etc\n        vec2.scale(lowerLimitEquation.normalA, worldAxisA, 1);\n        vec2.sub(lowerLimitEquation.contactPointA, worldAnchorA, bodyA.position);\n        vec2.sub(lowerLimitEquation.contactPointB, worldAnchorB, bodyB.position);\n        vec2.scale(tmp,worldAxisA,lowerLimit);\n        vec2.sub(lowerLimitEquation.contactPointB,lowerLimitEquation.contactPointB,tmp);\n        if(eqs.indexOf(lowerLimitEquation) === -1){\n            eqs.push(lowerLimitEquation);\n        }\n    } else {\n        var idx = eqs.indexOf(lowerLimitEquation);\n        if(idx !== -1){\n            eqs.splice(idx,1);\n        }\n    }\n};\n\n/**\n * Enable the motor\n * @method enableMotor\n */\nPrismaticConstraint.prototype.enableMotor = function(){\n    if(this.motorEnabled){\n        return;\n    }\n    this.equations.push(this.motorEquation);\n    this.motorEnabled = true;\n};\n\n/**\n * Disable the rotational motor\n * @method disableMotor\n */\nPrismaticConstraint.prototype.disableMotor = function(){\n    if(!this.motorEnabled){\n        return;\n    }\n    var i = this.equations.indexOf(this.motorEquation);\n    this.equations.splice(i,1);\n    this.motorEnabled = false;\n};\n\n/**\n * Set the constraint limits.\n * @method setLimits\n * @param {number} lower Lower limit.\n * @param {number} upper Upper limit.\n */\nPrismaticConstraint.prototype.setLimits = function (lower, upper) {\n    if(typeof(lower) === 'number'){\n        this.lowerLimit = lower;\n        this.lowerLimitEnabled = true;\n    } else {\n        this.lowerLimit = lower;\n        this.lowerLimitEnabled = false;\n    }\n\n    if(typeof(upper) === 'number'){\n        this.upperLimit = upper;\n        this.upperLimitEnabled = true;\n    } else {\n        this.upperLimit = upper;\n        this.upperLimitEnabled = false;\n    }\n};\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///30\n");

/***/ }),
/* 31 */
/* no static exports found */
/* all exports used */
/*!****************************************************!*\
  !*** ./~/p2/src/constraints/RevoluteConstraint.js ***!
  \****************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Constraint = __webpack_require__(/*! ./Constraint */ 6)\n,   Equation = __webpack_require__(/*! ../equations/Equation */ 2)\n,   RotationalVelocityEquation = __webpack_require__(/*! ../equations/RotationalVelocityEquation */ 34)\n,   RotationalLockEquation = __webpack_require__(/*! ../equations/RotationalLockEquation */ 33)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = RevoluteConstraint;\n\nvar worldPivotA = vec2.create(),\n    worldPivotB = vec2.create(),\n    xAxis = vec2.fromValues(1,0),\n    yAxis = vec2.fromValues(0,1),\n    g = vec2.create();\n\n/**\n * Connects two bodies at given offset points, letting them rotate relative to each other around this point.\n * @class RevoluteConstraint\n * @constructor\n * @author schteppe\n * @param {Body}    bodyA\n * @param {Body}    bodyB\n * @param {Object}  [options]\n * @param {Array}   [options.worldPivot] A pivot point given in world coordinates. If specified, localPivotA and localPivotB are automatically computed from this value.\n * @param {Array}   [options.localPivotA] The point relative to the center of mass of bodyA which bodyA is constrained to.\n * @param {Array}   [options.localPivotB] See localPivotA.\n * @param {Number}  [options.maxForce] The maximum force that should be applied to constrain the bodies.\n * @extends Constraint\n *\n * @example\n *     // This will create a revolute constraint between two bodies with pivot point in between them.\n *     var bodyA = new Body({ mass: 1, position: [-1, 0] });\n *     var bodyB = new Body({ mass: 1, position: [1, 0] });\n *     var constraint = new RevoluteConstraint(bodyA, bodyB, {\n *         worldPivot: [0, 0]\n *     });\n *     world.addConstraint(constraint);\n *\n *     // Using body-local pivot points, the constraint could have been constructed like this:\n *     var constraint = new RevoluteConstraint(bodyA, bodyB, {\n *         localPivotA: [1, 0],\n *         localPivotB: [-1, 0]\n *     });\n */\nfunction RevoluteConstraint(bodyA, bodyB, options){\n    options = options || {};\n    Constraint.call(this,bodyA,bodyB,Constraint.REVOLUTE,options);\n\n    var maxForce = this.maxForce = typeof(options.maxForce) !== \"undefined\" ? options.maxForce : Number.MAX_VALUE;\n\n    /**\n     * @property {Array} pivotA\n     */\n    this.pivotA = vec2.create();\n\n    /**\n     * @property {Array} pivotB\n     */\n    this.pivotB = vec2.create();\n\n    if(options.worldPivot){\n        // Compute pivotA and pivotB\n        vec2.sub(this.pivotA, options.worldPivot, bodyA.position);\n        vec2.sub(this.pivotB, options.worldPivot, bodyB.position);\n        // Rotate to local coordinate system\n        vec2.rotate(this.pivotA, this.pivotA, -bodyA.angle);\n        vec2.rotate(this.pivotB, this.pivotB, -bodyB.angle);\n    } else {\n        // Get pivotA and pivotB\n        vec2.copy(this.pivotA, options.localPivotA);\n        vec2.copy(this.pivotB, options.localPivotB);\n    }\n\n    // Equations to be fed to the solver\n    var eqs = this.equations = [\n        new Equation(bodyA,bodyB,-maxForce,maxForce),\n        new Equation(bodyA,bodyB,-maxForce,maxForce),\n    ];\n\n    var x = eqs[0];\n    var y = eqs[1];\n    var that = this;\n\n    x.computeGq = function(){\n        vec2.rotate(worldPivotA, that.pivotA, bodyA.angle);\n        vec2.rotate(worldPivotB, that.pivotB, bodyB.angle);\n        vec2.add(g, bodyB.position, worldPivotB);\n        vec2.sub(g, g, bodyA.position);\n        vec2.sub(g, g, worldPivotA);\n        return vec2.dot(g,xAxis);\n    };\n\n    y.computeGq = function(){\n        vec2.rotate(worldPivotA, that.pivotA, bodyA.angle);\n        vec2.rotate(worldPivotB, that.pivotB, bodyB.angle);\n        vec2.add(g, bodyB.position, worldPivotB);\n        vec2.sub(g, g, bodyA.position);\n        vec2.sub(g, g, worldPivotA);\n        return vec2.dot(g,yAxis);\n    };\n\n    y.minForce = x.minForce = -maxForce;\n    y.maxForce = x.maxForce =  maxForce;\n\n    this.motorEquation = new RotationalVelocityEquation(bodyA,bodyB);\n\n    /**\n     * Indicates whether the motor is enabled. Use .enableMotor() to enable the constraint motor.\n     * @property {Boolean} motorEnabled\n     * @readOnly\n     */\n    this.motorEnabled = false;\n\n    /**\n     * The constraint position.\n     * @property angle\n     * @type {Number}\n     * @readOnly\n     */\n    this.angle = 0;\n\n    /**\n     * Set to true to enable lower limit\n     * @property lowerLimitEnabled\n     * @type {Boolean}\n     */\n    this.lowerLimitEnabled = false;\n\n    /**\n     * Set to true to enable upper limit\n     * @property upperLimitEnabled\n     * @type {Boolean}\n     */\n    this.upperLimitEnabled = false;\n\n    /**\n     * The lower limit on the constraint angle.\n     * @property lowerLimit\n     * @type {Boolean}\n     */\n    this.lowerLimit = 0;\n\n    /**\n     * The upper limit on the constraint angle.\n     * @property upperLimit\n     * @type {Boolean}\n     */\n    this.upperLimit = 0;\n\n    this.upperLimitEquation = new RotationalLockEquation(bodyA,bodyB);\n    this.lowerLimitEquation = new RotationalLockEquation(bodyA,bodyB);\n    this.upperLimitEquation.minForce = 0;\n    this.lowerLimitEquation.maxForce = 0;\n}\nRevoluteConstraint.prototype = new Constraint();\nRevoluteConstraint.prototype.constructor = RevoluteConstraint;\n\n/**\n * Set the constraint angle limits.\n * @method setLimits\n * @param {number} lower Lower angle limit.\n * @param {number} upper Upper angle limit.\n */\nRevoluteConstraint.prototype.setLimits = function (lower, upper) {\n    if(typeof(lower) === 'number'){\n        this.lowerLimit = lower;\n        this.lowerLimitEnabled = true;\n    } else {\n        this.lowerLimit = lower;\n        this.lowerLimitEnabled = false;\n    }\n\n    if(typeof(upper) === 'number'){\n        this.upperLimit = upper;\n        this.upperLimitEnabled = true;\n    } else {\n        this.upperLimit = upper;\n        this.upperLimitEnabled = false;\n    }\n};\n\nRevoluteConstraint.prototype.update = function(){\n    var bodyA =  this.bodyA,\n        bodyB =  this.bodyB,\n        pivotA = this.pivotA,\n        pivotB = this.pivotB,\n        eqs =    this.equations,\n        normal = eqs[0],\n        tangent= eqs[1],\n        x = eqs[0],\n        y = eqs[1],\n        upperLimit = this.upperLimit,\n        lowerLimit = this.lowerLimit,\n        upperLimitEquation = this.upperLimitEquation,\n        lowerLimitEquation = this.lowerLimitEquation;\n\n    var relAngle = this.angle = bodyB.angle - bodyA.angle;\n\n    if(this.upperLimitEnabled && relAngle > upperLimit){\n        upperLimitEquation.angle = upperLimit;\n        if(eqs.indexOf(upperLimitEquation) === -1){\n            eqs.push(upperLimitEquation);\n        }\n    } else {\n        var idx = eqs.indexOf(upperLimitEquation);\n        if(idx !== -1){\n            eqs.splice(idx,1);\n        }\n    }\n\n    if(this.lowerLimitEnabled && relAngle < lowerLimit){\n        lowerLimitEquation.angle = lowerLimit;\n        if(eqs.indexOf(lowerLimitEquation) === -1){\n            eqs.push(lowerLimitEquation);\n        }\n    } else {\n        var idx = eqs.indexOf(lowerLimitEquation);\n        if(idx !== -1){\n            eqs.splice(idx,1);\n        }\n    }\n\n    /*\n\n    The constraint violation is\n\n        g = xj + rj - xi - ri\n\n    ...where xi and xj are the body positions and ri and rj world-oriented offset vectors. Differentiate:\n\n        gdot = vj + wj x rj - vi - wi x ri\n\n    We split this into x and y directions. (let x and y be unit vectors along the respective axes)\n\n        gdot * x = ( vj + wj x rj - vi - wi x ri ) * x\n                 = ( vj*x + (wj x rj)*x -vi*x -(wi x ri)*x\n                 = ( vj*x + (rj x x)*wj -vi*x -(ri x x)*wi\n                 = [ -x   -(ri x x)   x   (rj x x)] * [vi wi vj wj]\n                 = G*W\n\n    ...and similar for y. We have then identified the jacobian entries for x and y directions:\n\n        Gx = [ x   (rj x x)   -x   -(ri x x)]\n        Gy = [ y   (rj x y)   -y   -(ri x y)]\n\n     */\n\n    vec2.rotate(worldPivotA, pivotA, bodyA.angle);\n    vec2.rotate(worldPivotB, pivotB, bodyB.angle);\n\n    // todo: these are a bit sparse. We could save some computations on making custom eq.computeGW functions, etc\n\n    x.G[0] = -1;\n    x.G[1] =  0;\n    x.G[2] = -vec2.crossLength(worldPivotA,xAxis);\n    x.G[3] =  1;\n    x.G[4] =  0;\n    x.G[5] =  vec2.crossLength(worldPivotB,xAxis);\n\n    y.G[0] =  0;\n    y.G[1] = -1;\n    y.G[2] = -vec2.crossLength(worldPivotA,yAxis);\n    y.G[3] =  0;\n    y.G[4] =  1;\n    y.G[5] =  vec2.crossLength(worldPivotB,yAxis);\n};\n\n/**\n * Enable the rotational motor\n * @method enableMotor\n */\nRevoluteConstraint.prototype.enableMotor = function(){\n    if(this.motorEnabled){\n        return;\n    }\n    this.equations.push(this.motorEquation);\n    this.motorEnabled = true;\n};\n\n/**\n * Disable the rotational motor\n * @method disableMotor\n */\nRevoluteConstraint.prototype.disableMotor = function(){\n    if(!this.motorEnabled){\n        return;\n    }\n    var i = this.equations.indexOf(this.motorEquation);\n    this.equations.splice(i,1);\n    this.motorEnabled = false;\n};\n\n/**\n * Check if the motor is enabled.\n * @method motorIsEnabled\n * @deprecated use property motorEnabled instead.\n * @return {Boolean}\n */\nRevoluteConstraint.prototype.motorIsEnabled = function(){\n    return !!this.motorEnabled;\n};\n\n/**\n * Set the speed of the rotational constraint motor\n * @method setMotorSpeed\n * @param  {Number} speed\n */\nRevoluteConstraint.prototype.setMotorSpeed = function(speed){\n    if(!this.motorEnabled){\n        return;\n    }\n    var i = this.equations.indexOf(this.motorEquation);\n    this.equations[i].relativeVelocity = speed;\n};\n\n/**\n * Get the speed of the rotational constraint motor\n * @method getMotorSpeed\n * @return {Number} The current speed, or false if the motor is not enabled.\n */\nRevoluteConstraint.prototype.getMotorSpeed = function(){\n    if(!this.motorEnabled){\n        return false;\n    }\n    return this.motorEquation.relativeVelocity;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///31\n");

/***/ }),
/* 32 */
/* no static exports found */
/* all exports used */
/*!*************************************************!*\
  !*** ./~/p2/src/equations/AngleLockEquation.js ***!
  \*************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Equation = __webpack_require__(/*! ./Equation */ 2),\n    vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = AngleLockEquation;\n\n/**\n * Locks the relative angle between two bodies. The constraint tries to keep the dot product between two vectors, local in each body, to zero. The local angle in body i is a parameter.\n *\n * @class AngleLockEquation\n * @constructor\n * @extends Equation\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {Object} [options]\n * @param {Number} [options.angle] Angle to add to the local vector in body A.\n * @param {Number} [options.ratio] Gear ratio\n */\nfunction AngleLockEquation(bodyA, bodyB, options){\n    options = options || {};\n    Equation.call(this,bodyA,bodyB,-Number.MAX_VALUE,Number.MAX_VALUE);\n    this.angle = options.angle || 0;\n\n    /**\n     * The gear ratio.\n     * @property {Number} ratio\n     * @private\n     * @see setRatio\n     */\n    this.ratio = typeof(options.ratio)===\"number\" ? options.ratio : 1;\n\n    this.setRatio(this.ratio);\n}\nAngleLockEquation.prototype = new Equation();\nAngleLockEquation.prototype.constructor = AngleLockEquation;\n\nAngleLockEquation.prototype.computeGq = function(){\n    return this.ratio * this.bodyA.angle - this.bodyB.angle + this.angle;\n};\n\n/**\n * Set the gear ratio for this equation\n * @method setRatio\n * @param {Number} ratio\n */\nAngleLockEquation.prototype.setRatio = function(ratio){\n    var G = this.G;\n    G[2] =  ratio;\n    G[5] = -1;\n    this.ratio = ratio;\n};\n\n/**\n * Set the max force for the equation.\n * @method setMaxTorque\n * @param {Number} torque\n */\nAngleLockEquation.prototype.setMaxTorque = function(torque){\n    this.maxForce =  torque;\n    this.minForce = -torque;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///32\n");

/***/ }),
/* 33 */
/* no static exports found */
/* all exports used */
/*!******************************************************!*\
  !*** ./~/p2/src/equations/RotationalLockEquation.js ***!
  \******************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Equation = __webpack_require__(/*! ./Equation */ 2),\n    vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = RotationalLockEquation;\n\n/**\n * Locks the relative angle between two bodies. The constraint tries to keep the dot product between two vectors, local in each body, to zero. The local angle in body i is a parameter.\n *\n * @class RotationalLockEquation\n * @constructor\n * @extends Equation\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {Object} [options]\n * @param {Number} [options.angle] Angle to add to the local vector in bodyA.\n */\nfunction RotationalLockEquation(bodyA, bodyB, options){\n    options = options || {};\n    Equation.call(this, bodyA, bodyB, -Number.MAX_VALUE, Number.MAX_VALUE);\n\n    /**\n     * @property {number} angle\n     */\n    this.angle = options.angle || 0;\n\n    var G = this.G;\n    G[2] =  1;\n    G[5] = -1;\n}\nRotationalLockEquation.prototype = new Equation();\nRotationalLockEquation.prototype.constructor = RotationalLockEquation;\n\nvar worldVectorA = vec2.create(),\n    worldVectorB = vec2.create(),\n    xAxis = vec2.fromValues(1,0),\n    yAxis = vec2.fromValues(0,1);\nRotationalLockEquation.prototype.computeGq = function(){\n    vec2.rotate(worldVectorA,xAxis,this.bodyA.angle+this.angle);\n    vec2.rotate(worldVectorB,yAxis,this.bodyB.angle);\n    return vec2.dot(worldVectorA,worldVectorB);\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///33\n");

/***/ }),
/* 34 */
/* no static exports found */
/* all exports used */
/*!**********************************************************!*\
  !*** ./~/p2/src/equations/RotationalVelocityEquation.js ***!
  \**********************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Equation = __webpack_require__(/*! ./Equation */ 2),\n    vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = RotationalVelocityEquation;\n\n/**\n * Syncs rotational velocity of two bodies, or sets a relative velocity (motor).\n *\n * @class RotationalVelocityEquation\n * @constructor\n * @extends Equation\n * @param {Body} bodyA\n * @param {Body} bodyB\n */\nfunction RotationalVelocityEquation(bodyA, bodyB){\n    Equation.call(this, bodyA, bodyB, -Number.MAX_VALUE, Number.MAX_VALUE);\n    this.relativeVelocity = 1;\n    this.ratio = 1;\n}\nRotationalVelocityEquation.prototype = new Equation();\nRotationalVelocityEquation.prototype.constructor = RotationalVelocityEquation;\nRotationalVelocityEquation.prototype.computeB = function(a,b,h){\n    var G = this.G;\n    G[2] = -1;\n    G[5] = this.ratio;\n\n    var GiMf = this.computeGiMf();\n    var GW = this.computeGW();\n    var B = - GW * b - h*GiMf;\n\n    return B;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMzQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy9lcXVhdGlvbnMvUm90YXRpb25hbFZlbG9jaXR5RXF1YXRpb24uanM/ZDM0YSJdLCJzb3VyY2VzQ29udGVudCI6WyJ2YXIgRXF1YXRpb24gPSByZXF1aXJlKFwiLi9FcXVhdGlvblwiKSxcbiAgICB2ZWMyID0gcmVxdWlyZSgnLi4vbWF0aC92ZWMyJyk7XG5cbm1vZHVsZS5leHBvcnRzID0gUm90YXRpb25hbFZlbG9jaXR5RXF1YXRpb247XG5cbi8qKlxuICogU3luY3Mgcm90YXRpb25hbCB2ZWxvY2l0eSBvZiB0d28gYm9kaWVzLCBvciBzZXRzIGEgcmVsYXRpdmUgdmVsb2NpdHkgKG1vdG9yKS5cbiAqXG4gKiBAY2xhc3MgUm90YXRpb25hbFZlbG9jaXR5RXF1YXRpb25cbiAqIEBjb25zdHJ1Y3RvclxuICogQGV4dGVuZHMgRXF1YXRpb25cbiAqIEBwYXJhbSB7Qm9keX0gYm9keUFcbiAqIEBwYXJhbSB7Qm9keX0gYm9keUJcbiAqL1xuZnVuY3Rpb24gUm90YXRpb25hbFZlbG9jaXR5RXF1YXRpb24oYm9keUEsIGJvZHlCKXtcbiAgICBFcXVhdGlvbi5jYWxsKHRoaXMsIGJvZHlBLCBib2R5QiwgLU51bWJlci5NQVhfVkFMVUUsIE51bWJlci5NQVhfVkFMVUUpO1xuICAgIHRoaXMucmVsYXRpdmVWZWxvY2l0eSA9IDE7XG4gICAgdGhpcy5yYXRpbyA9IDE7XG59XG5Sb3RhdGlvbmFsVmVsb2NpdHlFcXVhdGlvbi5wcm90b3R5cGUgPSBuZXcgRXF1YXRpb24oKTtcblJvdGF0aW9uYWxWZWxvY2l0eUVxdWF0aW9uLnByb3RvdHlwZS5jb25zdHJ1Y3RvciA9IFJvdGF0aW9uYWxWZWxvY2l0eUVxdWF0aW9uO1xuUm90YXRpb25hbFZlbG9jaXR5RXF1YXRpb24ucHJvdG90eXBlLmNvbXB1dGVCID0gZnVuY3Rpb24oYSxiLGgpe1xuICAgIHZhciBHID0gdGhpcy5HO1xuICAgIEdbMl0gPSAtMTtcbiAgICBHWzVdID0gdGhpcy5yYXRpbztcblxuICAgIHZhciBHaU1mID0gdGhpcy5jb21wdXRlR2lNZigpO1xuICAgIHZhciBHVyA9IHRoaXMuY29tcHV0ZUdXKCk7XG4gICAgdmFyIEIgPSAtIEdXICogYiAtIGgqR2lNZjtcblxuICAgIHJldHVybiBCO1xufTtcblxuXG5cbi8vLy8vLy8vLy8vLy8vLy8vL1xuLy8gV0VCUEFDSyBGT09URVJcbi8vIC4vfi9wMi9zcmMvZXF1YXRpb25zL1JvdGF0aW9uYWxWZWxvY2l0eUVxdWF0aW9uLmpzXG4vLyBtb2R1bGUgaWQgPSAzNFxuLy8gbW9kdWxlIGNodW5rcyA9IDAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///34\n");

/***/ }),
/* 35 */
/* no static exports found */
/* all exports used */
/*!**********************************************!*\
  !*** ./~/p2/src/material/ContactMaterial.js ***!
  \**********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Material = __webpack_require__(/*! ./Material */ 19);\nvar Equation = __webpack_require__(/*! ../equations/Equation */ 2);\n\nmodule.exports = ContactMaterial;\n\n/**\n * Defines what happens when two materials meet, such as what friction coefficient to use. You can also set other things such as restitution, surface velocity and constraint parameters.\n * @class ContactMaterial\n * @constructor\n * @param {Material} materialA\n * @param {Material} materialB\n * @param {Object}   [options]\n * @param {Number}   [options.friction=0.3]       Friction coefficient.\n * @param {Number}   [options.restitution=0]      Restitution coefficient aka \"bounciness\".\n * @param {Number}   [options.stiffness]          ContactEquation stiffness.\n * @param {Number}   [options.relaxation]         ContactEquation relaxation.\n * @param {Number}   [options.frictionStiffness]  FrictionEquation stiffness.\n * @param {Number}   [options.frictionRelaxation] FrictionEquation relaxation.\n * @param {Number}   [options.surfaceVelocity=0]  Surface velocity.\n * @author schteppe\n */\nfunction ContactMaterial(materialA, materialB, options){\n    options = options || {};\n\n    if(!(materialA instanceof Material) || !(materialB instanceof Material)){\n        throw new Error(\"First two arguments must be Material instances.\");\n    }\n\n    /**\n     * The contact material identifier\n     * @property id\n     * @type {Number}\n     */\n    this.id = ContactMaterial.idCounter++;\n\n    /**\n     * First material participating in the contact material\n     * @property materialA\n     * @type {Material}\n     */\n    this.materialA = materialA;\n\n    /**\n     * Second material participating in the contact material\n     * @property materialB\n     * @type {Material}\n     */\n    this.materialB = materialB;\n\n    /**\n     * Friction coefficient to use in the contact of these two materials. Friction = 0 will make the involved objects super slippery, and friction = 1 will make it much less slippery. A friction coefficient larger than 1 will allow for very large friction forces, which can be convenient for preventing car tires not slip on the ground.\n     * @property friction\n     * @type {Number}\n     * @default 0.3\n     */\n    this.friction = typeof(options.friction) !== \"undefined\" ? Number(options.friction) : 0.3;\n\n    /**\n     * Restitution, or \"bounciness\" to use in the contact of these two materials. A restitution of 0 will make no bounce, while restitution=1 will approximately bounce back with the same velocity the object came with.\n     * @property restitution\n     * @type {Number}\n     * @default 0\n     */\n    this.restitution = typeof(options.restitution) !== \"undefined\" ? Number(options.restitution) : 0;\n\n    /**\n     * Hardness of the contact. Less stiffness will make the objects penetrate more, and will make the contact act more like a spring than a contact force. Default value is {{#crossLink \"Equation/DEFAULT_STIFFNESS:property\"}}Equation.DEFAULT_STIFFNESS{{/crossLink}}.\n     * @property stiffness\n     * @type {Number}\n     */\n    this.stiffness = typeof(options.stiffness) !== \"undefined\" ? Number(options.stiffness) : Equation.DEFAULT_STIFFNESS;\n\n    /**\n     * Relaxation of the resulting ContactEquation that this ContactMaterial generate. Default value is {{#crossLink \"Equation/DEFAULT_RELAXATION:property\"}}Equation.DEFAULT_RELAXATION{{/crossLink}}.\n     * @property relaxation\n     * @type {Number}\n     */\n    this.relaxation = typeof(options.relaxation) !== \"undefined\" ? Number(options.relaxation) : Equation.DEFAULT_RELAXATION;\n\n    /**\n     * Stiffness of the resulting friction force. For most cases, the value of this property should be a large number. I cannot think of any case where you would want less frictionStiffness. Default value is {{#crossLink \"Equation/DEFAULT_STIFFNESS:property\"}}Equation.DEFAULT_STIFFNESS{{/crossLink}}.\n     * @property frictionStiffness\n     * @type {Number}\n     */\n    this.frictionStiffness = typeof(options.frictionStiffness) !== \"undefined\" ? Number(options.frictionStiffness) : Equation.DEFAULT_STIFFNESS;\n\n    /**\n     * Relaxation of the resulting friction force. The default value should be good for most simulations. Default value is {{#crossLink \"Equation/DEFAULT_RELAXATION:property\"}}Equation.DEFAULT_RELAXATION{{/crossLink}}.\n     * @property frictionRelaxation\n     * @type {Number}\n     */\n    this.frictionRelaxation = typeof(options.frictionRelaxation) !== \"undefined\" ? Number(options.frictionRelaxation)  : Equation.DEFAULT_RELAXATION;\n\n    /**\n     * Will add surface velocity to this material. If bodyA rests on top if bodyB, and the surface velocity is positive, bodyA will slide to the right.\n     * @property {Number} surfaceVelocity\n     * @default 0\n     */\n    this.surfaceVelocity = typeof(options.surfaceVelocity) !== \"undefined\" ? Number(options.surfaceVelocity) : 0;\n\n    /**\n     * Offset to be set on ContactEquations. A positive value will make the bodies penetrate more into each other. Can be useful in scenes where contacts need to be more persistent, for example when stacking. Aka \"cure for nervous contacts\".\n     * @property contactSkinSize\n     * @type {Number}\n     */\n    this.contactSkinSize = 0.005;\n}\n\nContactMaterial.idCounter = 0;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///35\n");

/***/ }),
/* 36 */
/* no static exports found */
/* all exports used */
/*!******************************************!*\
  !*** ./~/p2/src/objects/LinearSpring.js ***!
  \******************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\nvar Spring = __webpack_require__(/*! ./Spring */ 20);\nvar Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\nmodule.exports = LinearSpring;\n\n/**\n * A spring, connecting two bodies.\n *\n * The Spring explicitly adds force and angularForce to the bodies.\n *\n * @class LinearSpring\n * @extends Spring\n * @constructor\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {Object} [options]\n * @param {number} [options.restLength]   A number > 0. Default is the current distance between the world anchor points.\n * @param {number} [options.stiffness=100]  Spring constant (see Hookes Law). A number >= 0.\n * @param {number} [options.damping=1]      A number >= 0. Default: 1\n * @param {Array}  [options.worldAnchorA]   Where to hook the spring to body A, in world coordinates. Overrides the option \"localAnchorA\" if given.\n * @param {Array}  [options.worldAnchorB]\n * @param {Array}  [options.localAnchorA]   Where to hook the spring to body A, in local body coordinates. Defaults to the body center.\n * @param {Array}  [options.localAnchorB]\n */\nfunction LinearSpring(bodyA,bodyB,options){\n    options = options || {};\n\n    Spring.call(this, bodyA, bodyB, options);\n\n    /**\n     * Anchor for bodyA in local bodyA coordinates.\n     * @property localAnchorA\n     * @type {Array}\n     */\n    this.localAnchorA = vec2.fromValues(0,0);\n\n    /**\n     * Anchor for bodyB in local bodyB coordinates.\n     * @property localAnchorB\n     * @type {Array}\n     */\n    this.localAnchorB = vec2.fromValues(0,0);\n\n    if(options.localAnchorA){ vec2.copy(this.localAnchorA, options.localAnchorA); }\n    if(options.localAnchorB){ vec2.copy(this.localAnchorB, options.localAnchorB); }\n    if(options.worldAnchorA){ this.setWorldAnchorA(options.worldAnchorA); }\n    if(options.worldAnchorB){ this.setWorldAnchorB(options.worldAnchorB); }\n\n    var worldAnchorA = vec2.create();\n    var worldAnchorB = vec2.create();\n    this.getWorldAnchorA(worldAnchorA);\n    this.getWorldAnchorB(worldAnchorB);\n    var worldDistance = vec2.distance(worldAnchorA, worldAnchorB);\n\n    /**\n     * Rest length of the spring.\n     * @property restLength\n     * @type {number}\n     */\n    this.restLength = typeof(options.restLength) === \"number\" ? options.restLength : worldDistance;\n}\nLinearSpring.prototype = new Spring();\nLinearSpring.prototype.constructor = LinearSpring;\n\n/**\n * Set the anchor point on body A, using world coordinates.\n * @method setWorldAnchorA\n * @param {Array} worldAnchorA\n */\nLinearSpring.prototype.setWorldAnchorA = function(worldAnchorA){\n    this.bodyA.toLocalFrame(this.localAnchorA, worldAnchorA);\n};\n\n/**\n * Set the anchor point on body B, using world coordinates.\n * @method setWorldAnchorB\n * @param {Array} worldAnchorB\n */\nLinearSpring.prototype.setWorldAnchorB = function(worldAnchorB){\n    this.bodyB.toLocalFrame(this.localAnchorB, worldAnchorB);\n};\n\n/**\n * Get the anchor point on body A, in world coordinates.\n * @method getWorldAnchorA\n * @param {Array} result The vector to store the result in.\n */\nLinearSpring.prototype.getWorldAnchorA = function(result){\n    this.bodyA.toWorldFrame(result, this.localAnchorA);\n};\n\n/**\n * Get the anchor point on body B, in world coordinates.\n * @method getWorldAnchorB\n * @param {Array} result The vector to store the result in.\n */\nLinearSpring.prototype.getWorldAnchorB = function(result){\n    this.bodyB.toWorldFrame(result, this.localAnchorB);\n};\n\nvar applyForce_r =              vec2.create(),\n    applyForce_r_unit =         vec2.create(),\n    applyForce_u =              vec2.create(),\n    applyForce_f =              vec2.create(),\n    applyForce_worldAnchorA =   vec2.create(),\n    applyForce_worldAnchorB =   vec2.create(),\n    applyForce_ri =             vec2.create(),\n    applyForce_rj =             vec2.create(),\n    applyForce_tmp =            vec2.create();\n\n/**\n * Apply the spring force to the connected bodies.\n * @method applyForce\n */\nLinearSpring.prototype.applyForce = function(){\n    var k = this.stiffness,\n        d = this.damping,\n        l = this.restLength,\n        bodyA = this.bodyA,\n        bodyB = this.bodyB,\n        r = applyForce_r,\n        r_unit = applyForce_r_unit,\n        u = applyForce_u,\n        f = applyForce_f,\n        tmp = applyForce_tmp;\n\n    var worldAnchorA = applyForce_worldAnchorA,\n        worldAnchorB = applyForce_worldAnchorB,\n        ri = applyForce_ri,\n        rj = applyForce_rj;\n\n    // Get world anchors\n    this.getWorldAnchorA(worldAnchorA);\n    this.getWorldAnchorB(worldAnchorB);\n\n    // Get offset points\n    vec2.sub(ri, worldAnchorA, bodyA.position);\n    vec2.sub(rj, worldAnchorB, bodyB.position);\n\n    // Compute distance vector between world anchor points\n    vec2.sub(r, worldAnchorB, worldAnchorA);\n    var rlen = vec2.len(r);\n    vec2.normalize(r_unit,r);\n\n    //console.log(rlen)\n    //console.log(\"A\",vec2.str(worldAnchorA),\"B\",vec2.str(worldAnchorB))\n\n    // Compute relative velocity of the anchor points, u\n    vec2.sub(u, bodyB.velocity, bodyA.velocity);\n    vec2.crossZV(tmp, bodyB.angularVelocity, rj);\n    vec2.add(u, u, tmp);\n    vec2.crossZV(tmp, bodyA.angularVelocity, ri);\n    vec2.sub(u, u, tmp);\n\n    // F = - k * ( x - L ) - D * ( u )\n    vec2.scale(f, r_unit, -k*(rlen-l) - d*vec2.dot(u,r_unit));\n\n    // Add forces to bodies\n    vec2.sub( bodyA.force, bodyA.force, f);\n    vec2.add( bodyB.force, bodyB.force, f);\n\n    // Angular force\n    var ri_x_f = vec2.crossLength(ri, f);\n    var rj_x_f = vec2.crossLength(rj, f);\n    bodyA.angularForce -= ri_x_f;\n    bodyB.angularForce += rj_x_f;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///36\n");

/***/ }),
/* 37 */
/* no static exports found */
/* all exports used */
/*!**********************************************!*\
  !*** ./~/p2/src/objects/RotationalSpring.js ***!
  \**********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\nvar Spring = __webpack_require__(/*! ./Spring */ 20);\n\nmodule.exports = RotationalSpring;\n\n/**\n * A rotational spring, connecting two bodies rotation. This spring explicitly adds angularForce (torque) to the bodies.\n *\n * The spring can be combined with a {{#crossLink \"RevoluteConstraint\"}}{{/crossLink}} to make, for example, a mouse trap.\n *\n * @class RotationalSpring\n * @extends Spring\n * @constructor\n * @param {Body} bodyA\n * @param {Body} bodyB\n * @param {Object} [options]\n * @param {number} [options.restAngle] The relative angle of bodies at which the spring is at rest. If not given, it's set to the current relative angle between the bodies.\n * @param {number} [options.stiffness=100] Spring constant (see Hookes Law). A number >= 0.\n * @param {number} [options.damping=1] A number >= 0.\n */\nfunction RotationalSpring(bodyA, bodyB, options){\n    options = options || {};\n\n    Spring.call(this, bodyA, bodyB, options);\n\n    /**\n     * Rest angle of the spring.\n     * @property restAngle\n     * @type {number}\n     */\n    this.restAngle = typeof(options.restAngle) === \"number\" ? options.restAngle : bodyB.angle - bodyA.angle;\n}\nRotationalSpring.prototype = new Spring();\nRotationalSpring.prototype.constructor = RotationalSpring;\n\n/**\n * Apply the spring force to the connected bodies.\n * @method applyForce\n */\nRotationalSpring.prototype.applyForce = function(){\n    var k = this.stiffness,\n        d = this.damping,\n        l = this.restAngle,\n        bodyA = this.bodyA,\n        bodyB = this.bodyB,\n        x = bodyB.angle - bodyA.angle,\n        u = bodyB.angularVelocity - bodyA.angularVelocity;\n\n    var torque = - k * (x - l) - d * u * 0;\n\n    bodyA.angularForce -= torque;\n    bodyB.angularForce += torque;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///37\n");

/***/ }),
/* 38 */
/* no static exports found */
/* all exports used */
/*!********************************!*\
  !*** ./~/p2/src/shapes/Box.js ***!
  \********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   Shape = __webpack_require__(/*! ./Shape */ 3)\n,   Convex = __webpack_require__(/*! ./Convex */ 10);\n\nmodule.exports = Box;\n\n/**\n * Box shape class.\n * @class Box\n * @constructor\n * @param {object} [options] (Note that this options object will be passed on to the {{#crossLink \"Shape\"}}{{/crossLink}} constructor.)\n * @param {Number} [options.width=1] Total width of the box\n * @param {Number} [options.height=1] Total height of the box\n * @extends Convex\n */\nfunction Box(options){\n    if(typeof(arguments[0]) === 'number' && typeof(arguments[1]) === 'number'){\n        options = {\n            width: arguments[0],\n            height: arguments[1]\n        };\n        console.warn('The Rectangle has been renamed to Box and its constructor signature has changed. Please use the following format: new Box({ width: 1, height: 1, ... })');\n    }\n    options = options || {};\n\n    /**\n     * Total width of the box\n     * @property width\n     * @type {Number}\n     */\n    var width = this.width = options.width || 1;\n\n    /**\n     * Total height of the box\n     * @property height\n     * @type {Number}\n     */\n    var height = this.height = options.height || 1;\n\n    var verts = [\n        vec2.fromValues(-width/2, -height/2),\n        vec2.fromValues( width/2, -height/2),\n        vec2.fromValues( width/2,  height/2),\n        vec2.fromValues(-width/2,  height/2)\n    ];\n    var axes = [\n        vec2.fromValues(1, 0),\n        vec2.fromValues(0, 1)\n    ];\n\n    options.vertices = verts;\n    options.axes = axes;\n    options.type = Shape.BOX;\n    Convex.call(this, options);\n}\nBox.prototype = new Convex();\nBox.prototype.constructor = Box;\n\n/**\n * Compute moment of inertia\n * @method computeMomentOfInertia\n * @param  {Number} mass\n * @return {Number}\n */\nBox.prototype.computeMomentOfInertia = function(mass){\n    var w = this.width,\n        h = this.height;\n    return mass * (h*h + w*w) / 12;\n};\n\n/**\n * Update the bounding radius\n * @method updateBoundingRadius\n */\nBox.prototype.updateBoundingRadius = function(){\n    var w = this.width,\n        h = this.height;\n    this.boundingRadius = Math.sqrt(w*w + h*h) / 2;\n};\n\nvar corner1 = vec2.create(),\n    corner2 = vec2.create(),\n    corner3 = vec2.create(),\n    corner4 = vec2.create();\n\n/**\n * @method computeAABB\n * @param  {AABB}   out      The resulting AABB.\n * @param  {Array}  position\n * @param  {Number} angle\n */\nBox.prototype.computeAABB = function(out, position, angle){\n    out.setFromPoints(this.vertices,position,angle,0);\n};\n\nBox.prototype.updateArea = function(){\n    this.area = this.width * this.height;\n};\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///38\n");

/***/ }),
/* 39 */
/* no static exports found */
/* all exports used */
/*!************************************!*\
  !*** ./~/p2/src/shapes/Capsule.js ***!
  \************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Shape = __webpack_require__(/*! ./Shape */ 3)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = Capsule;\n\n/**\n * Capsule shape class.\n * @class Capsule\n * @constructor\n * @extends Shape\n * @param {object} [options] (Note that this options object will be passed on to the {{#crossLink \"Shape\"}}{{/crossLink}} constructor.)\n * @param {Number} [options.length=1] The distance between the end points\n * @param {Number} [options.radius=1] Radius of the capsule\n * @example\n *     var capsuleShape = new Capsule({\n *         length: 1,\n *         radius: 2\n *     });\n *     body.addShape(capsuleShape);\n */\nfunction Capsule(options){\n    if(typeof(arguments[0]) === 'number' && typeof(arguments[1]) === 'number'){\n        options = {\n            length: arguments[0],\n            radius: arguments[1]\n        };\n        console.warn('The Capsule constructor signature has changed. Please use the following format: new Capsule({ radius: 1, length: 1 })');\n    }\n    options = options || {};\n\n    /**\n     * The distance between the end points.\n     * @property {Number} length\n     */\n    this.length = options.length || 1;\n\n    /**\n     * The radius of the capsule.\n     * @property {Number} radius\n     */\n    this.radius = options.radius || 1;\n\n    options.type = Shape.CAPSULE;\n    Shape.call(this, options);\n}\nCapsule.prototype = new Shape();\nCapsule.prototype.constructor = Capsule;\n\n/**\n * Compute the mass moment of inertia of the Capsule.\n * @method conputeMomentOfInertia\n * @param  {Number} mass\n * @return {Number}\n * @todo\n */\nCapsule.prototype.computeMomentOfInertia = function(mass){\n    // Approximate with rectangle\n    var r = this.radius,\n        w = this.length + r, // 2*r is too much, 0 is too little\n        h = r*2;\n    return mass * (h*h + w*w) / 12;\n};\n\n/**\n * @method updateBoundingRadius\n */\nCapsule.prototype.updateBoundingRadius = function(){\n    this.boundingRadius = this.radius + this.length/2;\n};\n\n/**\n * @method updateArea\n */\nCapsule.prototype.updateArea = function(){\n    this.area = Math.PI * this.radius * this.radius + this.radius * 2 * this.length;\n};\n\nvar r = vec2.create();\n\n/**\n * @method computeAABB\n * @param  {AABB}   out      The resulting AABB.\n * @param  {Array}  position\n * @param  {Number} angle\n */\nCapsule.prototype.computeAABB = function(out, position, angle){\n    var radius = this.radius;\n\n    // Compute center position of one of the the circles, world oriented, but with local offset\n    vec2.set(r,this.length / 2,0);\n    if(angle !== 0){\n        vec2.rotate(r,r,angle);\n    }\n\n    // Get bounds\n    vec2.set(out.upperBound,  Math.max(r[0]+radius, -r[0]+radius),\n                              Math.max(r[1]+radius, -r[1]+radius));\n    vec2.set(out.lowerBound,  Math.min(r[0]-radius, -r[0]-radius),\n                              Math.min(r[1]-radius, -r[1]-radius));\n\n    // Add offset\n    vec2.add(out.lowerBound, out.lowerBound, position);\n    vec2.add(out.upperBound, out.upperBound, position);\n};\n\nvar intersectCapsule_hitPointWorld = vec2.create();\nvar intersectCapsule_normal = vec2.create();\nvar intersectCapsule_l0 = vec2.create();\nvar intersectCapsule_l1 = vec2.create();\nvar intersectCapsule_unit_y = vec2.fromValues(0,1);\n\n/**\n * @method raycast\n * @param  {RaycastResult} result\n * @param  {Ray} ray\n * @param  {array} position\n * @param  {number} angle\n */\nCapsule.prototype.raycast = function(result, ray, position, angle){\n    var from = ray.from;\n    var to = ray.to;\n    var direction = ray.direction;\n\n    var hitPointWorld = intersectCapsule_hitPointWorld;\n    var normal = intersectCapsule_normal;\n    var l0 = intersectCapsule_l0;\n    var l1 = intersectCapsule_l1;\n\n    // The sides\n    var halfLen = this.length / 2;\n    for(var i=0; i<2; i++){\n\n        // get start and end of the line\n        var y = this.radius * (i*2-1);\n        vec2.set(l0, -halfLen, y);\n        vec2.set(l1, halfLen, y);\n        vec2.toGlobalFrame(l0, l0, position, angle);\n        vec2.toGlobalFrame(l1, l1, position, angle);\n\n        var delta = vec2.getLineSegmentsIntersectionFraction(from, to, l0, l1);\n        if(delta >= 0){\n            vec2.rotate(normal, intersectCapsule_unit_y, angle);\n            vec2.scale(normal, normal, (i*2-1));\n            ray.reportIntersection(result, delta, normal, -1);\n            if(result.shouldStop(ray)){\n                return;\n            }\n        }\n    }\n\n    // Circles\n    var diagonalLengthSquared = Math.pow(this.radius, 2) + Math.pow(halfLen, 2);\n    for(var i=0; i<2; i++){\n        vec2.set(l0, halfLen * (i*2-1), 0);\n        vec2.toGlobalFrame(l0, l0, position, angle);\n\n        var a = Math.pow(to[0] - from[0], 2) + Math.pow(to[1] - from[1], 2);\n        var b = 2 * ((to[0] - from[0]) * (from[0] - l0[0]) + (to[1] - from[1]) * (from[1] - l0[1]));\n        var c = Math.pow(from[0] - l0[0], 2) + Math.pow(from[1] - l0[1], 2) - Math.pow(this.radius, 2);\n        var delta = Math.pow(b, 2) - 4 * a * c;\n\n        if(delta < 0){\n            // No intersection\n            continue;\n\n        } else if(delta === 0){\n            // single intersection point\n            vec2.lerp(hitPointWorld, from, to, delta);\n\n            if(vec2.squaredDistance(hitPointWorld, position) > diagonalLengthSquared){\n                vec2.sub(normal, hitPointWorld, l0);\n                vec2.normalize(normal,normal);\n                ray.reportIntersection(result, delta, normal, -1);\n                if(result.shouldStop(ray)){\n                    return;\n                }\n            }\n\n        } else {\n            var sqrtDelta = Math.sqrt(delta);\n            var inv2a = 1 / (2 * a);\n            var d1 = (- b - sqrtDelta) * inv2a;\n            var d2 = (- b + sqrtDelta) * inv2a;\n\n            if(d1 >= 0 && d1 <= 1){\n                vec2.lerp(hitPointWorld, from, to, d1);\n                if(vec2.squaredDistance(hitPointWorld, position) > diagonalLengthSquared){\n                    vec2.sub(normal, hitPointWorld, l0);\n                    vec2.normalize(normal,normal);\n                    ray.reportIntersection(result, d1, normal, -1);\n                    if(result.shouldStop(ray)){\n                        return;\n                    }\n                }\n            }\n\n            if(d2 >= 0 && d2 <= 1){\n                vec2.lerp(hitPointWorld, from, to, d2);\n                if(vec2.squaredDistance(hitPointWorld, position) > diagonalLengthSquared){\n                    vec2.sub(normal, hitPointWorld, l0);\n                    vec2.normalize(normal,normal);\n                    ray.reportIntersection(result, d2, normal, -1);\n                    if(result.shouldStop(ray)){\n                        return;\n                    }\n                }\n            }\n        }\n    }\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///39\n");

/***/ }),
/* 40 */
/* no static exports found */
/* all exports used */
/*!*********************************!*\
  !*** ./~/p2/src/shapes/Line.js ***!
  \*********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Shape = __webpack_require__(/*! ./Shape */ 3)\n,   vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = Line;\n\n/**\n * Line shape class. The line shape is along the x direction, and stretches from [-length/2, 0] to [length/2,0].\n * @class Line\n * @param {object} [options] (Note that this options object will be passed on to the {{#crossLink \"Shape\"}}{{/crossLink}} constructor.)\n * @param {Number} [options.length=1] The total length of the line\n * @extends Shape\n * @constructor\n */\nfunction Line(options){\n    if(typeof(arguments[0]) === 'number'){\n        options = {\n            length: arguments[0]\n        };\n        console.warn('The Line constructor signature has changed. Please use the following format: new Line({ length: 1, ... })');\n    }\n    options = options || {};\n\n    /**\n     * Length of this line\n     * @property {Number} length\n     * @default 1\n     */\n    this.length = options.length || 1;\n\n    options.type = Shape.LINE;\n    Shape.call(this, options);\n}\nLine.prototype = new Shape();\nLine.prototype.constructor = Line;\n\nLine.prototype.computeMomentOfInertia = function(mass){\n    return mass * Math.pow(this.length,2) / 12;\n};\n\nLine.prototype.updateBoundingRadius = function(){\n    this.boundingRadius = this.length/2;\n};\n\nvar points = [vec2.create(),vec2.create()];\n\n/**\n * @method computeAABB\n * @param  {AABB}   out      The resulting AABB.\n * @param  {Array}  position\n * @param  {Number} angle\n */\nLine.prototype.computeAABB = function(out, position, angle){\n    var l2 = this.length / 2;\n    vec2.set(points[0], -l2,  0);\n    vec2.set(points[1],  l2,  0);\n    out.setFromPoints(points,position,angle,0);\n};\n\nvar raycast_hitPoint = vec2.create();\nvar raycast_normal = vec2.create();\nvar raycast_l0 = vec2.create();\nvar raycast_l1 = vec2.create();\nvar raycast_unit_y = vec2.fromValues(0,1);\n\n/**\n * @method raycast\n * @param  {RaycastResult} result\n * @param  {Ray} ray\n * @param  {number} angle\n * @param  {array} position\n */\nLine.prototype.raycast = function(result, ray, position, angle){\n    var from = ray.from;\n    var to = ray.to;\n\n    var l0 = raycast_l0;\n    var l1 = raycast_l1;\n\n    // get start and end of the line\n    var halfLen = this.length / 2;\n    vec2.set(l0, -halfLen, 0);\n    vec2.set(l1, halfLen, 0);\n    vec2.toGlobalFrame(l0, l0, position, angle);\n    vec2.toGlobalFrame(l1, l1, position, angle);\n\n    var fraction = vec2.getLineSegmentsIntersectionFraction(l0, l1, from, to);\n    if(fraction >= 0){\n        var normal = raycast_normal;\n        vec2.rotate(normal, raycast_unit_y, angle); // todo: this should depend on which side the ray comes from\n        ray.reportIntersection(result, fraction, normal, -1);\n    }\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///40\n");

/***/ }),
/* 41 */
/* no static exports found */
/* all exports used */
/*!*************************************!*\
  !*** ./~/p2/src/solver/GSSolver.js ***!
  \*************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,   Solver = __webpack_require__(/*! ./Solver */ 23)\n,   Utils = __webpack_require__(/*! ../utils/Utils */ 1)\n,   FrictionEquation = __webpack_require__(/*! ../equations/FrictionEquation */ 9);\n\nmodule.exports = GSSolver;\n\n/**\n * Iterative Gauss-Seidel constraint equation solver.\n *\n * @class GSSolver\n * @constructor\n * @extends Solver\n * @param {Object} [options]\n * @param {Number} [options.iterations=10]\n * @param {Number} [options.tolerance=0]\n */\nfunction GSSolver(options){\n    Solver.call(this,options,Solver.GS);\n    options = options || {};\n\n    /**\n     * The max number of iterations to do when solving. More gives better results, but is more expensive.\n     * @property iterations\n     * @type {Number}\n     */\n    this.iterations = options.iterations || 10;\n\n    /**\n     * The error tolerance, per constraint. If the total error is below this limit, the solver will stop iterating. Set to zero for as good solution as possible, but to something larger than zero to make computations faster.\n     * @property tolerance\n     * @type {Number}\n     * @default 1e-7\n     */\n    this.tolerance = options.tolerance || 1e-7;\n\n    this.arrayStep = 30;\n    this.lambda = new Utils.ARRAY_TYPE(this.arrayStep);\n    this.Bs =     new Utils.ARRAY_TYPE(this.arrayStep);\n    this.invCs =  new Utils.ARRAY_TYPE(this.arrayStep);\n\n    /**\n     * Set to true to set all right hand side terms to zero when solving. Can be handy for a few applications.\n     * @property useZeroRHS\n     * @type {Boolean}\n     * @todo Remove, not used\n     */\n    this.useZeroRHS = false;\n\n    /**\n     * Number of solver iterations that are used to approximate normal forces used for friction (F_friction = mu * F_normal). These friction forces will override any other friction forces that are set. If you set frictionIterations = 0, then this feature will be disabled.\n     *\n     * Use only frictionIterations > 0 if the approximated normal force (F_normal = mass * gravity) is not good enough. Examples of where it can happen is in space games where gravity is zero, or in tall stacks where the normal force is large at bottom but small at top.\n     *\n     * @property frictionIterations\n     * @type {Number}\n     * @default 0\n     */\n    this.frictionIterations = options.frictionIterations !== undefined ? 0 : options.frictionIterations;\n\n    /**\n     * The number of iterations that were made during the last solve. If .tolerance is zero, this value will always be equal to .iterations, but if .tolerance is larger than zero, and the solver can quit early, then this number will be somewhere between 1 and .iterations.\n     * @property {Number} usedIterations\n     */\n    this.usedIterations = 0;\n}\nGSSolver.prototype = new Solver();\nGSSolver.prototype.constructor = GSSolver;\n\nfunction setArrayZero(array){\n    var l = array.length;\n    while(l--){\n        array[l] = +0.0;\n    }\n}\n\n/**\n * Solve the system of equations\n * @method solve\n * @param  {Number}  h       Time step\n * @param  {World}   world    World to solve\n */\nGSSolver.prototype.solve = function(h, world){\n\n    this.sortEquations();\n\n    var iter = 0,\n        maxIter = this.iterations,\n        maxFrictionIter = this.frictionIterations,\n        equations = this.equations,\n        Neq = equations.length,\n        tolSquared = Math.pow(this.tolerance*Neq, 2),\n        bodies = world.bodies,\n        Nbodies = world.bodies.length,\n        add = vec2.add,\n        set = vec2.set,\n        useZeroRHS = this.useZeroRHS,\n        lambda = this.lambda;\n\n    this.usedIterations = 0;\n\n    if(Neq){\n        for(var i=0; i!==Nbodies; i++){\n            var b = bodies[i];\n\n            // Update solve mass\n            b.updateSolveMassProperties();\n        }\n    }\n\n    // Things that does not change during iteration can be computed once\n    if(lambda.length < Neq){\n        lambda = this.lambda =  new Utils.ARRAY_TYPE(Neq + this.arrayStep);\n        this.Bs =               new Utils.ARRAY_TYPE(Neq + this.arrayStep);\n        this.invCs =            new Utils.ARRAY_TYPE(Neq + this.arrayStep);\n    }\n    setArrayZero(lambda);\n    var invCs = this.invCs,\n        Bs = this.Bs,\n        lambda = this.lambda;\n\n    for(var i=0; i!==equations.length; i++){\n        var c = equations[i];\n        if(c.timeStep !== h || c.needsUpdate){\n            c.timeStep = h;\n            c.update();\n        }\n        Bs[i] =     c.computeB(c.a,c.b,h);\n        invCs[i] =  c.computeInvC(c.epsilon);\n    }\n\n    var q, B, c, deltalambdaTot,i,j;\n\n    if(Neq !== 0){\n\n        for(i=0; i!==Nbodies; i++){\n            var b = bodies[i];\n\n            // Reset vlambda\n            b.resetConstraintVelocity();\n        }\n\n        if(maxFrictionIter){\n            // Iterate over contact equations to get normal forces\n            for(iter=0; iter!==maxFrictionIter; iter++){\n\n                // Accumulate the total error for each iteration.\n                deltalambdaTot = 0.0;\n\n                for(j=0; j!==Neq; j++){\n                    c = equations[j];\n\n                    var deltalambda = GSSolver.iterateEquation(j,c,c.epsilon,Bs,invCs,lambda,useZeroRHS,h,iter);\n                    deltalambdaTot += Math.abs(deltalambda);\n                }\n\n                this.usedIterations++;\n\n                // If the total error is small enough - stop iterate\n                if(deltalambdaTot*deltalambdaTot <= tolSquared){\n                    break;\n                }\n            }\n\n            GSSolver.updateMultipliers(equations, lambda, 1/h);\n\n            // Set computed friction force\n            for(j=0; j!==Neq; j++){\n                var eq = equations[j];\n                if(eq instanceof FrictionEquation){\n                    var f = 0.0;\n                    for(var k=0; k!==eq.contactEquations.length; k++){\n                        f += eq.contactEquations[k].multiplier;\n                    }\n                    f *= eq.frictionCoefficient / eq.contactEquations.length;\n                    eq.maxForce =  f;\n                    eq.minForce = -f;\n                }\n            }\n        }\n\n        // Iterate over all equations\n        for(iter=0; iter!==maxIter; iter++){\n\n            // Accumulate the total error for each iteration.\n            deltalambdaTot = 0.0;\n\n            for(j=0; j!==Neq; j++){\n                c = equations[j];\n\n                var deltalambda = GSSolver.iterateEquation(j,c,c.epsilon,Bs,invCs,lambda,useZeroRHS,h,iter);\n                deltalambdaTot += Math.abs(deltalambda);\n            }\n\n            this.usedIterations++;\n\n            // If the total error is small enough - stop iterate\n            if(deltalambdaTot*deltalambdaTot <= tolSquared){\n                break;\n            }\n        }\n\n        // Add result to velocity\n        for(i=0; i!==Nbodies; i++){\n            bodies[i].addConstraintVelocity();\n        }\n\n        GSSolver.updateMultipliers(equations, lambda, 1/h);\n    }\n};\n\n// Sets the .multiplier property of each equation\nGSSolver.updateMultipliers = function(equations, lambda, invDt){\n    // Set the .multiplier property of each equation\n    var l = equations.length;\n    while(l--){\n        equations[l].multiplier = lambda[l] * invDt;\n    }\n};\n\nGSSolver.iterateEquation = function(j,eq,eps,Bs,invCs,lambda,useZeroRHS,dt,iter){\n    // Compute iteration\n    var B = Bs[j],\n        invC = invCs[j],\n        lambdaj = lambda[j],\n        GWlambda = eq.computeGWlambda();\n\n    var maxForce = eq.maxForce,\n        minForce = eq.minForce;\n\n    if(useZeroRHS){\n        B = 0;\n    }\n\n    var deltalambda = invC * ( B - GWlambda - eps * lambdaj );\n\n    // Clamp if we are not within the min/max interval\n    var lambdaj_plus_deltalambda = lambdaj + deltalambda;\n    if(lambdaj_plus_deltalambda < minForce*dt){\n        deltalambda = minForce*dt - lambdaj;\n    } else if(lambdaj_plus_deltalambda > maxForce*dt){\n        deltalambda = maxForce*dt - lambdaj;\n    }\n    lambda[j] += deltalambda;\n    eq.addToWlambda(deltalambda);\n\n    return deltalambda;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///41\n");

/***/ }),
/* 42 */
/* no static exports found */
/* all exports used */
/*!***********************************************!*\
  !*** ./~/p2/src/utils/ContactEquationPool.js ***!
  \***********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var ContactEquation = __webpack_require__(/*! ../equations/ContactEquation */ 14);\nvar Pool = __webpack_require__(/*! ./Pool */ 8);\n\nmodule.exports = ContactEquationPool;\n\n/**\n * @class\n */\nfunction ContactEquationPool() {\n\tPool.apply(this, arguments);\n}\nContactEquationPool.prototype = new Pool();\nContactEquationPool.prototype.constructor = ContactEquationPool;\n\n/**\n * @method create\n * @return {ContactEquation}\n */\nContactEquationPool.prototype.create = function () {\n\treturn new ContactEquation();\n};\n\n/**\n * @method destroy\n * @param {ContactEquation} equation\n * @return {ContactEquationPool}\n */\nContactEquationPool.prototype.destroy = function (equation) {\n\tequation.bodyA = equation.bodyB = null;\n\treturn this;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDIuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy91dGlscy9Db250YWN0RXF1YXRpb25Qb29sLmpzP2NiNDIiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIENvbnRhY3RFcXVhdGlvbiA9IHJlcXVpcmUoJy4uL2VxdWF0aW9ucy9Db250YWN0RXF1YXRpb24nKTtcbnZhciBQb29sID0gcmVxdWlyZSgnLi9Qb29sJyk7XG5cbm1vZHVsZS5leHBvcnRzID0gQ29udGFjdEVxdWF0aW9uUG9vbDtcblxuLyoqXG4gKiBAY2xhc3NcbiAqL1xuZnVuY3Rpb24gQ29udGFjdEVxdWF0aW9uUG9vbCgpIHtcblx0UG9vbC5hcHBseSh0aGlzLCBhcmd1bWVudHMpO1xufVxuQ29udGFjdEVxdWF0aW9uUG9vbC5wcm90b3R5cGUgPSBuZXcgUG9vbCgpO1xuQ29udGFjdEVxdWF0aW9uUG9vbC5wcm90b3R5cGUuY29uc3RydWN0b3IgPSBDb250YWN0RXF1YXRpb25Qb29sO1xuXG4vKipcbiAqIEBtZXRob2QgY3JlYXRlXG4gKiBAcmV0dXJuIHtDb250YWN0RXF1YXRpb259XG4gKi9cbkNvbnRhY3RFcXVhdGlvblBvb2wucHJvdG90eXBlLmNyZWF0ZSA9IGZ1bmN0aW9uICgpIHtcblx0cmV0dXJuIG5ldyBDb250YWN0RXF1YXRpb24oKTtcbn07XG5cbi8qKlxuICogQG1ldGhvZCBkZXN0cm95XG4gKiBAcGFyYW0ge0NvbnRhY3RFcXVhdGlvbn0gZXF1YXRpb25cbiAqIEByZXR1cm4ge0NvbnRhY3RFcXVhdGlvblBvb2x9XG4gKi9cbkNvbnRhY3RFcXVhdGlvblBvb2wucHJvdG90eXBlLmRlc3Ryb3kgPSBmdW5jdGlvbiAoZXF1YXRpb24pIHtcblx0ZXF1YXRpb24uYm9keUEgPSBlcXVhdGlvbi5ib2R5QiA9IG51bGw7XG5cdHJldHVybiB0aGlzO1xufTtcblxuXG5cbi8vLy8vLy8vLy8vLy8vLy8vL1xuLy8gV0VCUEFDSyBGT09URVJcbi8vIC4vfi9wMi9zcmMvdXRpbHMvQ29udGFjdEVxdWF0aW9uUG9vbC5qc1xuLy8gbW9kdWxlIGlkID0gNDJcbi8vIG1vZHVsZSBjaHVua3MgPSAwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///42\n");

/***/ }),
/* 43 */
/* no static exports found */
/* all exports used */
/*!************************************************!*\
  !*** ./~/p2/src/utils/FrictionEquationPool.js ***!
  \************************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var FrictionEquation = __webpack_require__(/*! ../equations/FrictionEquation */ 9);\nvar Pool = __webpack_require__(/*! ./Pool */ 8);\n\nmodule.exports = FrictionEquationPool;\n\n/**\n * @class\n */\nfunction FrictionEquationPool() {\n\tPool.apply(this, arguments);\n}\nFrictionEquationPool.prototype = new Pool();\nFrictionEquationPool.prototype.constructor = FrictionEquationPool;\n\n/**\n * @method create\n * @return {FrictionEquation}\n */\nFrictionEquationPool.prototype.create = function () {\n\treturn new FrictionEquation();\n};\n\n/**\n * @method destroy\n * @param {FrictionEquation} equation\n * @return {FrictionEquationPool}\n */\nFrictionEquationPool.prototype.destroy = function (equation) {\n\tequation.bodyA = equation.bodyB = null;\n\treturn this;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy91dGlscy9GcmljdGlvbkVxdWF0aW9uUG9vbC5qcz9iZGY1Il0sInNvdXJjZXNDb250ZW50IjpbInZhciBGcmljdGlvbkVxdWF0aW9uID0gcmVxdWlyZSgnLi4vZXF1YXRpb25zL0ZyaWN0aW9uRXF1YXRpb24nKTtcbnZhciBQb29sID0gcmVxdWlyZSgnLi9Qb29sJyk7XG5cbm1vZHVsZS5leHBvcnRzID0gRnJpY3Rpb25FcXVhdGlvblBvb2w7XG5cbi8qKlxuICogQGNsYXNzXG4gKi9cbmZ1bmN0aW9uIEZyaWN0aW9uRXF1YXRpb25Qb29sKCkge1xuXHRQb29sLmFwcGx5KHRoaXMsIGFyZ3VtZW50cyk7XG59XG5GcmljdGlvbkVxdWF0aW9uUG9vbC5wcm90b3R5cGUgPSBuZXcgUG9vbCgpO1xuRnJpY3Rpb25FcXVhdGlvblBvb2wucHJvdG90eXBlLmNvbnN0cnVjdG9yID0gRnJpY3Rpb25FcXVhdGlvblBvb2w7XG5cbi8qKlxuICogQG1ldGhvZCBjcmVhdGVcbiAqIEByZXR1cm4ge0ZyaWN0aW9uRXF1YXRpb259XG4gKi9cbkZyaWN0aW9uRXF1YXRpb25Qb29sLnByb3RvdHlwZS5jcmVhdGUgPSBmdW5jdGlvbiAoKSB7XG5cdHJldHVybiBuZXcgRnJpY3Rpb25FcXVhdGlvbigpO1xufTtcblxuLyoqXG4gKiBAbWV0aG9kIGRlc3Ryb3lcbiAqIEBwYXJhbSB7RnJpY3Rpb25FcXVhdGlvbn0gZXF1YXRpb25cbiAqIEByZXR1cm4ge0ZyaWN0aW9uRXF1YXRpb25Qb29sfVxuICovXG5GcmljdGlvbkVxdWF0aW9uUG9vbC5wcm90b3R5cGUuZGVzdHJveSA9IGZ1bmN0aW9uIChlcXVhdGlvbikge1xuXHRlcXVhdGlvbi5ib2R5QSA9IGVxdWF0aW9uLmJvZHlCID0gbnVsbDtcblx0cmV0dXJuIHRoaXM7XG59O1xuXG5cblxuLy8vLy8vLy8vLy8vLy8vLy8vXG4vLyBXRUJQQUNLIEZPT1RFUlxuLy8gLi9+L3AyL3NyYy91dGlscy9GcmljdGlvbkVxdWF0aW9uUG9vbC5qc1xuLy8gbW9kdWxlIGlkID0gNDNcbi8vIG1vZHVsZSBjaHVua3MgPSAwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///43\n");

/***/ }),
/* 44 */
/* no static exports found */
/* all exports used */
/*!***********************************************!*\
  !*** ./~/p2/src/utils/OverlapKeeperRecord.js ***!
  \***********************************************/
/***/ (function(module, exports) {

eval("module.exports = OverlapKeeperRecord;\n\n/**\n * Overlap data container for the OverlapKeeper\n * @class OverlapKeeperRecord\n * @constructor\n * @param {Body} bodyA\n * @param {Shape} shapeA\n * @param {Body} bodyB\n * @param {Shape} shapeB\n */\nfunction OverlapKeeperRecord(bodyA, shapeA, bodyB, shapeB){\n    /**\n     * @property {Shape} shapeA\n     */\n    this.shapeA = shapeA;\n    /**\n     * @property {Shape} shapeB\n     */\n    this.shapeB = shapeB;\n    /**\n     * @property {Body} bodyA\n     */\n    this.bodyA = bodyA;\n    /**\n     * @property {Body} bodyB\n     */\n    this.bodyB = bodyB;\n}\n\n/**\n * Set the data for the record\n * @method set\n * @param {Body} bodyA\n * @param {Shape} shapeA\n * @param {Body} bodyB\n * @param {Shape} shapeB\n */\nOverlapKeeperRecord.prototype.set = function(bodyA, shapeA, bodyB, shapeB){\n    OverlapKeeperRecord.call(this, bodyA, shapeA, bodyB, shapeB);\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy91dGlscy9PdmVybGFwS2VlcGVyUmVjb3JkLmpzP2JlY2EiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSBPdmVybGFwS2VlcGVyUmVjb3JkO1xuXG4vKipcbiAqIE92ZXJsYXAgZGF0YSBjb250YWluZXIgZm9yIHRoZSBPdmVybGFwS2VlcGVyXG4gKiBAY2xhc3MgT3ZlcmxhcEtlZXBlclJlY29yZFxuICogQGNvbnN0cnVjdG9yXG4gKiBAcGFyYW0ge0JvZHl9IGJvZHlBXG4gKiBAcGFyYW0ge1NoYXBlfSBzaGFwZUFcbiAqIEBwYXJhbSB7Qm9keX0gYm9keUJcbiAqIEBwYXJhbSB7U2hhcGV9IHNoYXBlQlxuICovXG5mdW5jdGlvbiBPdmVybGFwS2VlcGVyUmVjb3JkKGJvZHlBLCBzaGFwZUEsIGJvZHlCLCBzaGFwZUIpe1xuICAgIC8qKlxuICAgICAqIEBwcm9wZXJ0eSB7U2hhcGV9IHNoYXBlQVxuICAgICAqL1xuICAgIHRoaXMuc2hhcGVBID0gc2hhcGVBO1xuICAgIC8qKlxuICAgICAqIEBwcm9wZXJ0eSB7U2hhcGV9IHNoYXBlQlxuICAgICAqL1xuICAgIHRoaXMuc2hhcGVCID0gc2hhcGVCO1xuICAgIC8qKlxuICAgICAqIEBwcm9wZXJ0eSB7Qm9keX0gYm9keUFcbiAgICAgKi9cbiAgICB0aGlzLmJvZHlBID0gYm9keUE7XG4gICAgLyoqXG4gICAgICogQHByb3BlcnR5IHtCb2R5fSBib2R5QlxuICAgICAqL1xuICAgIHRoaXMuYm9keUIgPSBib2R5Qjtcbn1cblxuLyoqXG4gKiBTZXQgdGhlIGRhdGEgZm9yIHRoZSByZWNvcmRcbiAqIEBtZXRob2Qgc2V0XG4gKiBAcGFyYW0ge0JvZHl9IGJvZHlBXG4gKiBAcGFyYW0ge1NoYXBlfSBzaGFwZUFcbiAqIEBwYXJhbSB7Qm9keX0gYm9keUJcbiAqIEBwYXJhbSB7U2hhcGV9IHNoYXBlQlxuICovXG5PdmVybGFwS2VlcGVyUmVjb3JkLnByb3RvdHlwZS5zZXQgPSBmdW5jdGlvbihib2R5QSwgc2hhcGVBLCBib2R5Qiwgc2hhcGVCKXtcbiAgICBPdmVybGFwS2VlcGVyUmVjb3JkLmNhbGwodGhpcywgYm9keUEsIHNoYXBlQSwgYm9keUIsIHNoYXBlQik7XG59O1xuXG5cblxuLy8vLy8vLy8vLy8vLy8vLy8vXG4vLyBXRUJQQUNLIEZPT1RFUlxuLy8gLi9+L3AyL3NyYy91dGlscy9PdmVybGFwS2VlcGVyUmVjb3JkLmpzXG4vLyBtb2R1bGUgaWQgPSA0NFxuLy8gbW9kdWxlIGNodW5rcyA9IDAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///44\n");

/***/ }),
/* 45 */
/* no static exports found */
/* all exports used */
/*!*******************************************!*\
  !*** ./~/p2/src/utils/TupleDictionary.js ***!
  \*******************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Utils = __webpack_require__(/*! ./Utils */ 1);\n\nmodule.exports = TupleDictionary;\n\n/**\n * @class TupleDictionary\n * @constructor\n */\nfunction TupleDictionary() {\n\n    /**\n     * The data storage\n     * @property data\n     * @type {Object}\n     */\n    this.data = {};\n\n    /**\n     * Keys that are currently used.\n     * @property {Array} keys\n     */\n    this.keys = [];\n}\n\n/**\n * Generate a key given two integers\n * @method getKey\n * @param  {number} i\n * @param  {number} j\n * @return {string}\n */\nTupleDictionary.prototype.getKey = function(id1, id2) {\n    id1 = id1|0;\n    id2 = id2|0;\n\n    if ( (id1|0) === (id2|0) ){\n        return -1;\n    }\n\n    // valid for values < 2^16\n    return ((id1|0) > (id2|0) ?\n        (id1 << 16) | (id2 & 0xFFFF) :\n        (id2 << 16) | (id1 & 0xFFFF))|0\n        ;\n};\n\n/**\n * @method getByKey\n * @param  {Number} key\n * @return {Object}\n */\nTupleDictionary.prototype.getByKey = function(key) {\n    key = key|0;\n    return this.data[key];\n};\n\n/**\n * @method get\n * @param  {Number} i\n * @param  {Number} j\n * @return {Number}\n */\nTupleDictionary.prototype.get = function(i, j) {\n    return this.data[this.getKey(i, j)];\n};\n\n/**\n * Set a value.\n * @method set\n * @param  {Number} i\n * @param  {Number} j\n * @param {Number} value\n */\nTupleDictionary.prototype.set = function(i, j, value) {\n    if(!value){\n        throw new Error(\"No data!\");\n    }\n\n    var key = this.getKey(i, j);\n\n    // Check if key already exists\n    if(!this.data[key]){\n        this.keys.push(key);\n    }\n\n    this.data[key] = value;\n\n    return key;\n};\n\n/**\n * Remove all data.\n * @method reset\n */\nTupleDictionary.prototype.reset = function() {\n    var data = this.data,\n        keys = this.keys;\n\n    var l = keys.length;\n    while(l--) {\n        delete data[keys[l]];\n    }\n\n    keys.length = 0;\n};\n\n/**\n * Copy another TupleDictionary. Note that all data in this dictionary will be removed.\n * @method copy\n * @param {TupleDictionary} dict The TupleDictionary to copy into this one.\n */\nTupleDictionary.prototype.copy = function(dict) {\n    this.reset();\n    Utils.appendArray(this.keys, dict.keys);\n    var l = dict.keys.length;\n    while(l--){\n        var key = dict.keys[l];\n        this.data[key] = dict.data[key];\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///45\n");

/***/ }),
/* 46 */
/* no static exports found */
/* all exports used */
/*!**********************************!*\
  !*** ./~/p2/src/world/Island.js ***!
  \**********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Body = __webpack_require__(/*! ../objects/Body */ 7);\n\nmodule.exports = Island;\n\n/**\n * An island of bodies connected with equations.\n * @class Island\n * @constructor\n */\nfunction Island(){\n\n    /**\n     * Current equations in this island.\n     * @property equations\n     * @type {Array}\n     */\n    this.equations = [];\n\n    /**\n     * Current bodies in this island.\n     * @property bodies\n     * @type {Array}\n     */\n    this.bodies = [];\n}\n\n/**\n * Clean this island from bodies and equations.\n * @method reset\n */\nIsland.prototype.reset = function(){\n    this.equations.length = this.bodies.length = 0;\n};\n\nvar bodyIds = [];\n\n/**\n * Get all unique bodies in this island.\n * @method getBodies\n * @return {Array} An array of Body\n */\nIsland.prototype.getBodies = function(result){\n    var bodies = result || [],\n        eqs = this.equations;\n    bodyIds.length = 0;\n    for(var i=0; i!==eqs.length; i++){\n        var eq = eqs[i];\n        if(bodyIds.indexOf(eq.bodyA.id)===-1){\n            bodies.push(eq.bodyA);\n            bodyIds.push(eq.bodyA.id);\n        }\n        if(bodyIds.indexOf(eq.bodyB.id)===-1){\n            bodies.push(eq.bodyB);\n            bodyIds.push(eq.bodyB.id);\n        }\n    }\n    return bodies;\n};\n\n/**\n * Check if the entire island wants to sleep.\n * @method wantsToSleep\n * @return {Boolean}\n */\nIsland.prototype.wantsToSleep = function(){\n    for(var i=0; i<this.bodies.length; i++){\n        var b = this.bodies[i];\n        if(b.type === Body.DYNAMIC && !b.wantsToSleep){\n            return false;\n        }\n    }\n    return true;\n};\n\n/**\n * Make all bodies in the island sleep.\n * @method sleep\n */\nIsland.prototype.sleep = function(){\n    for(var i=0; i<this.bodies.length; i++){\n        var b = this.bodies[i];\n        b.sleep();\n    }\n    return true;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///46\n");

/***/ }),
/* 47 */
/* no static exports found */
/* all exports used */
/*!**************************************!*\
  !*** ./~/p2/src/world/IslandNode.js ***!
  \**************************************/
/***/ (function(module, exports) {

eval("module.exports = IslandNode;\n\n/**\n * Holds a body and keeps track of some additional properties needed for graph traversal.\n * @class IslandNode\n * @constructor\n * @param {Body} body\n */\nfunction IslandNode(body){\n\n\t/**\n\t * The body that is contained in this node.\n\t * @property {Body} body\n\t */\n    this.body = body;\n\n    /**\n     * Neighboring IslandNodes\n     * @property {Array} neighbors\n     */\n    this.neighbors = [];\n\n    /**\n     * Equations connected to this node.\n     * @property {Array} equations\n     */\n    this.equations = [];\n\n    /**\n     * If this node was visiting during the graph traversal.\n     * @property visited\n     * @type {Boolean}\n     */\n    this.visited = false;\n}\n\n/**\n * Clean this node from bodies and equations.\n * @method reset\n */\nIslandNode.prototype.reset = function(){\n    this.equations.length = 0;\n    this.neighbors.length = 0;\n    this.visited = false;\n    this.body = null;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDcuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy93b3JsZC9Jc2xhbmROb2RlLmpzPzkyYzgiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSBJc2xhbmROb2RlO1xuXG4vKipcbiAqIEhvbGRzIGEgYm9keSBhbmQga2VlcHMgdHJhY2sgb2Ygc29tZSBhZGRpdGlvbmFsIHByb3BlcnRpZXMgbmVlZGVkIGZvciBncmFwaCB0cmF2ZXJzYWwuXG4gKiBAY2xhc3MgSXNsYW5kTm9kZVxuICogQGNvbnN0cnVjdG9yXG4gKiBAcGFyYW0ge0JvZHl9IGJvZHlcbiAqL1xuZnVuY3Rpb24gSXNsYW5kTm9kZShib2R5KXtcblxuXHQvKipcblx0ICogVGhlIGJvZHkgdGhhdCBpcyBjb250YWluZWQgaW4gdGhpcyBub2RlLlxuXHQgKiBAcHJvcGVydHkge0JvZHl9IGJvZHlcblx0ICovXG4gICAgdGhpcy5ib2R5ID0gYm9keTtcblxuICAgIC8qKlxuICAgICAqIE5laWdoYm9yaW5nIElzbGFuZE5vZGVzXG4gICAgICogQHByb3BlcnR5IHtBcnJheX0gbmVpZ2hib3JzXG4gICAgICovXG4gICAgdGhpcy5uZWlnaGJvcnMgPSBbXTtcblxuICAgIC8qKlxuICAgICAqIEVxdWF0aW9ucyBjb25uZWN0ZWQgdG8gdGhpcyBub2RlLlxuICAgICAqIEBwcm9wZXJ0eSB7QXJyYXl9IGVxdWF0aW9uc1xuICAgICAqL1xuICAgIHRoaXMuZXF1YXRpb25zID0gW107XG5cbiAgICAvKipcbiAgICAgKiBJZiB0aGlzIG5vZGUgd2FzIHZpc2l0aW5nIGR1cmluZyB0aGUgZ3JhcGggdHJhdmVyc2FsLlxuICAgICAqIEBwcm9wZXJ0eSB2aXNpdGVkXG4gICAgICogQHR5cGUge0Jvb2xlYW59XG4gICAgICovXG4gICAgdGhpcy52aXNpdGVkID0gZmFsc2U7XG59XG5cbi8qKlxuICogQ2xlYW4gdGhpcyBub2RlIGZyb20gYm9kaWVzIGFuZCBlcXVhdGlvbnMuXG4gKiBAbWV0aG9kIHJlc2V0XG4gKi9cbklzbGFuZE5vZGUucHJvdG90eXBlLnJlc2V0ID0gZnVuY3Rpb24oKXtcbiAgICB0aGlzLmVxdWF0aW9ucy5sZW5ndGggPSAwO1xuICAgIHRoaXMubmVpZ2hib3JzLmxlbmd0aCA9IDA7XG4gICAgdGhpcy52aXNpdGVkID0gZmFsc2U7XG4gICAgdGhpcy5ib2R5ID0gbnVsbDtcbn07XG5cblxuXG4vLy8vLy8vLy8vLy8vLy8vLy9cbi8vIFdFQlBBQ0sgRk9PVEVSXG4vLyAuL34vcDIvc3JjL3dvcmxkL0lzbGFuZE5vZGUuanNcbi8vIG1vZHVsZSBpZCA9IDQ3XG4vLyBtb2R1bGUgY2h1bmtzID0gMCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///47\n");

/***/ }),
/* 48 */
/* no static exports found */
/* all exports used */
/*!************************************!*\
  !*** ./~/poly-decomp/src/Point.js ***!
  \************************************/
/***/ (function(module, exports) {

eval("module.exports = Point;\n\n/**\n * Point related functions\n * @class Point\n */\nfunction Point(){};\n\n/**\n * Get the area of a triangle spanned by the three given points. Note that the area will be negative if the points are not given in counter-clockwise order.\n * @static\n * @method area\n * @param  {Array} a\n * @param  {Array} b\n * @param  {Array} c\n * @return {Number}\n */\nPoint.area = function(a,b,c){\n    return (((b[0] - a[0])*(c[1] - a[1]))-((c[0] - a[0])*(b[1] - a[1])));\n};\n\nPoint.left = function(a,b,c){\n    return Point.area(a,b,c) > 0;\n};\n\nPoint.leftOn = function(a,b,c) {\n    return Point.area(a, b, c) >= 0;\n};\n\nPoint.right = function(a,b,c) {\n    return Point.area(a, b, c) < 0;\n};\n\nPoint.rightOn = function(a,b,c) {\n    return Point.area(a, b, c) <= 0;\n};\n\nvar tmpPoint1 = [],\n    tmpPoint2 = [];\n\n/**\n * Check if three points are collinear\n * @method collinear\n * @param  {Array} a\n * @param  {Array} b\n * @param  {Array} c\n * @param  {Number} [thresholdAngle=0] Threshold angle to use when comparing the vectors. The function will return true if the angle between the resulting vectors is less than this value. Use zero for max precision.\n * @return {Boolean}\n */\nPoint.collinear = function(a,b,c,thresholdAngle) {\n    if(!thresholdAngle)\n        return Point.area(a, b, c) == 0;\n    else {\n        var ab = tmpPoint1,\n            bc = tmpPoint2;\n\n        ab[0] = b[0]-a[0];\n        ab[1] = b[1]-a[1];\n        bc[0] = c[0]-b[0];\n        bc[1] = c[1]-b[1];\n\n        var dot = ab[0]*bc[0] + ab[1]*bc[1],\n            magA = Math.sqrt(ab[0]*ab[0] + ab[1]*ab[1]),\n            magB = Math.sqrt(bc[0]*bc[0] + bc[1]*bc[1]),\n            angle = Math.acos(dot/(magA*magB));\n        return angle < thresholdAngle;\n    }\n};\n\nPoint.sqdist = function(a,b){\n    var dx = b[0] - a[0];\n    var dy = b[1] - a[1];\n    return dx * dx + dy * dy;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///48\n");

/***/ }),
/* 49 */
/* no static exports found */
/* all exports used */
/*!*************************************!*\
  !*** ./~/poly-decomp/src/Scalar.js ***!
  \*************************************/
/***/ (function(module, exports) {

eval("module.exports = Scalar;\n\n/**\n * Scalar functions\n * @class Scalar\n */\nfunction Scalar(){}\n\n/**\n * Check if two scalars are equal\n * @static\n * @method eq\n * @param  {Number} a\n * @param  {Number} b\n * @param  {Number} [precision]\n * @return {Boolean}\n */\nScalar.eq = function(a,b,precision){\n    precision = precision || 0;\n    return Math.abs(a-b) < precision;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNDkuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3BvbHktZGVjb21wL3NyYy9TY2FsYXIuanM/Y2RkMSJdLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9IFNjYWxhcjtcblxuLyoqXG4gKiBTY2FsYXIgZnVuY3Rpb25zXG4gKiBAY2xhc3MgU2NhbGFyXG4gKi9cbmZ1bmN0aW9uIFNjYWxhcigpe31cblxuLyoqXG4gKiBDaGVjayBpZiB0d28gc2NhbGFycyBhcmUgZXF1YWxcbiAqIEBzdGF0aWNcbiAqIEBtZXRob2QgZXFcbiAqIEBwYXJhbSAge051bWJlcn0gYVxuICogQHBhcmFtICB7TnVtYmVyfSBiXG4gKiBAcGFyYW0gIHtOdW1iZXJ9IFtwcmVjaXNpb25dXG4gKiBAcmV0dXJuIHtCb29sZWFufVxuICovXG5TY2FsYXIuZXEgPSBmdW5jdGlvbihhLGIscHJlY2lzaW9uKXtcbiAgICBwcmVjaXNpb24gPSBwcmVjaXNpb24gfHwgMDtcbiAgICByZXR1cm4gTWF0aC5hYnMoYS1iKSA8IHByZWNpc2lvbjtcbn07XG5cblxuXG4vLy8vLy8vLy8vLy8vLy8vLy9cbi8vIFdFQlBBQ0sgRk9PVEVSXG4vLyAuL34vcG9seS1kZWNvbXAvc3JjL1NjYWxhci5qc1xuLy8gbW9kdWxlIGlkID0gNDlcbi8vIG1vZHVsZSBjaHVua3MgPSAwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///49\n");

/***/ }),
/* 50 */
/* no static exports found */
/* all exports used */
/*!************************************!*\
  !*** ./~/poly-decomp/src/index.js ***!
  \************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("module.exports = {\n    Polygon : __webpack_require__(/*! ./Polygon */ 68),\n    Point : __webpack_require__(/*! ./Point */ 48),\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTAuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3BvbHktZGVjb21wL3NyYy9pbmRleC5qcz8xNDdkIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0ge1xuICAgIFBvbHlnb24gOiByZXF1aXJlKFwiLi9Qb2x5Z29uXCIpLFxuICAgIFBvaW50IDogcmVxdWlyZShcIi4vUG9pbnRcIiksXG59O1xuXG5cblxuLy8vLy8vLy8vLy8vLy8vLy8vXG4vLyBXRUJQQUNLIEZPT1RFUlxuLy8gLi9+L3BvbHktZGVjb21wL3NyYy9pbmRleC5qc1xuLy8gbW9kdWxlIGlkID0gNTBcbi8vIG1vZHVsZSBjaHVua3MgPSAwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///50\n");

/***/ }),
/* 51 */
/* exports provided: default */
/* all exports used */
/*!****************************!*\
  !*** ./src/js/LaserApi.js ***!
  \****************************/
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("Object.defineProperty(__webpack_exports__, \"__esModule\", { value: true });\n/**\r\n *\r\n * warning:\r\n *\r\n * YES I KNOW THIS CAN NOT USED WITH STATIC REFERENCES< IT WILL CONTINUE PROVIDING BETTER API INSTANCING FUNCTIONALITY IN FUTURE\r\n *\r\n */\r\n\r\nvar helper = __webpack_require__(/*! ./helper.js */ 17)\r\nvar laserConfig = __webpack_require__(/*! ./LaserApiConfig.js */ 4).default\r\n\r\n/* make sure to use https as the web audio api does not like http */\r\n//\r\n// if (location.protocol === 'http:' && location.hostname !== 'localhost' && location.hostname !== '0.0.0.0') {\r\n//     location.href = 'https:' + window.location.href.substrixng(window.location.protocol.length);\r\n// }\r\n\r\nfunction lerp(v0, v1, t) {\r\n\r\n    return (1 - t) * v0 + t * v1;\r\n\r\n}\r\n\r\nfunction lerp2d(v0, v1, t) {\r\n\r\n    return {\r\n        x: lerp(v0.x, v1.x, t),\r\n        y: lerp(v0.y, v1.y, t)\r\n    };\r\n\r\n}\r\nfunction lerp3d(v0, v1, t) {\r\n\r\n    return {\r\n        x: lerp(v0.x, v1.x, t),\r\n        y: lerp(v0.y, v1.y, t),\r\n        z: lerp(v0.z, v1.z, t)\r\n    };\r\n\r\n}\r\n\r\n// normalized coord in, normalized coord out\r\nfunction transformCoordinate(coord, mapping) {\r\n\r\n\r\n    // find p[ositions on x axises top and bottom\r\n    var tx1 = lerp2d(mapping.topleft, mapping.topright, coord.x);\r\n    var tx2 = lerp2d(mapping.bottomleft, mapping.bottomright, coord.x);\r\n    var result = lerp2d(tx1, tx2, coord.y);\r\n    // console.log('INput ', coord, 'output', result)\r\n    return result;\r\n}\r\n\r\nfunction getCoordinates() {\r\n\r\n    return laserConfig.transform\r\n}\r\nfunction setCoordinates(data) {\r\n    laserConfig.transform = data\r\n}\r\n\r\nfunction updateKnobs(rect) {\r\n    var knob1 = document.getElementById('knob1');\r\n    var knob2 = document.getElementById('knob2');\r\n    var knob3 = document.getElementById('knob3');\r\n    var knob4 = document.getElementById('knob4');\r\n    var container = document.getElementById('video').getBoundingClientRect();\r\n    knob1.style.top = rect.topleft.y * container.height;\r\n    knob1.style.left = rect.topleft.x * container.width;\r\n    knob2.style.top = rect.topright.y * container.height;\r\n    knob2.style.left = rect.topright.x * container.width;\r\n    knob3.style.top = rect.bottomleft.y * container.height;\r\n    knob3.style.left = rect.bottomleft.x * container.width;\r\n    knob4.style.top = rect.bottomright.y * container.height;\r\n    knob4.style.left = rect.bottomright.x * container.width;\r\n\r\n    //   console.log(rect, knob1.style.top, knob1.style.left, container.width, container.height)\r\n\r\n}\r\n\r\nfunction getColorDistance(col1, col2) {\r\n    var diff = []\r\n    diff[0] = col1[0] - col2[0];\r\n    diff[1] = col1[1] - col2[1];\r\n    diff[2] = col1[2] - col2[2];\r\n    var result = Math.sqrt(diff[0] * diff[0] + diff[1] * diff[1] + diff[2] * diff[2]);\r\n\r\n    // console.log('diff is .', col1, col2, result);\r\n\r\n    return result;\r\n}\r\nvar lastDate = performance.now()\r\n\r\nvar LaserApi =\r\n    {\r\n        lerp: lerp,\r\n        lerp2d: lerp2d,\r\n        lerp3d: lerp3d,\r\n\r\n        gRect: new Array(laserConfig.gridResolution * laserConfig.gridResolution),\r\n        globalImageData: null,\r\n        video: null,\r\n        canvas: null,\r\n\r\n        getInterestReqion: function (context, canvasColorOriginal) {\r\n\r\n            var resultImage = context.createImageData(laserConfig.testResolution.width, laserConfig.testResolution.height)\r\n\r\n            //  resultImage.drawImage(video, 0, 0, canvas.width, canvas.height);\r\n\r\n            for (var x = 0; x < laserConfig.testResolution.width; x++) {\r\n                for (var y = 0; y < laserConfig.testResolution.height; y++) {\r\n\r\n                    var indexnormal = (y * laserConfig.testResolution.width + x) * 4;\r\n\r\n                    var coordTransformed = transformCoordinate({\r\n                        x: x / laserConfig.testResolution.width,\r\n                        y: y / laserConfig.testResolution.height\r\n                    }, laserConfig.transform)\r\n\r\n                    coordTransformed.x *= laserConfig.testResolution.width\r\n                    coordTransformed.y *= laserConfig.testResolution.height\r\n                    //   console.log('coord', coordTransformed)\r\n                    var indexInput =( Math.floor(coordTransformed.y) * laserConfig.testResolution.width + Math.floor(coordTransformed.x)) * 4;\r\n\r\n                    if (getColorDistance(laserConfig.testColor, [\r\n                            canvasColorOriginal.data[indexInput],\r\n                            canvasColorOriginal.data[indexInput + 1],\r\n                            canvasColorOriginal.data[indexInput + 2]\r\n\r\n                        ]) < laserConfig.treshold) {\r\n\r\n\r\n                        resultImage.data[indexnormal] = canvasColorOriginal.data[indexInput];\r\n                        resultImage.data[indexnormal + 1] = canvasColorOriginal.data[indexInput + 1];\r\n                        resultImage.data[indexnormal + 2] = canvasColorOriginal.data[indexInput + 2];\r\n                        resultImage.data[indexnormal + 3] = canvasColorOriginal.data[indexInput + 3];\r\n\r\n                    }    else{\r\n\r\n                        resultImage.data[indexnormal] = 0;\r\n                        resultImage.data[indexnormal + 1] = 0;\r\n                        resultImage.data[indexnormal + 2] = 0;\r\n                        resultImage.data[indexnormal + 3] =255;\r\n                    }\r\n\r\n\r\n\r\n\r\n                }\r\n\r\n            }\r\n            return resultImage\r\n\r\n        },\r\n        getRectForInputImage: function (canvasColorOriginal) {\r\n\r\n            //     console.log('input image is ', canvasColorOriginal)\r\n            var gwidth = (canvasColorOriginal.width / laserConfig.gridResolution);\r\n            var gheight = (canvasColorOriginal.height / laserConfig.gridResolution)\r\n\r\n            for (var gy = 0; gy < laserConfig.gridResolution; gy++) {\r\n                for (var gx = 0; gx < laserConfig.gridResolution; gx++) {\r\n                    var gIndex = gy * laserConfig.gridResolution + gx;\r\n                    LaserApi.gRect[gIndex] = 0;\r\n                }\r\n            }\r\n\r\n            // lol, room for improvement to make it stop as soon as an adequate pixel has been found in subsection search should continue directly in next section\r\n            for (var x = 0; x < laserConfig.testResolution.width; x++) {\r\n                for (var y = 0; y < laserConfig.testResolution.height; y++) {\r\n\r\n                    /*var transformed = transformCoordinate({\r\n                     x: x / LaserApi.canvas.width,\r\n                     y: y / LaserApi.canvas.height\r\n                     }, transform);\r\n\r\n                     transformed.x *= LaserApi.canvas.width;\r\n                     transformed.y *= LaserApi.canvas.height;\r\n\r\n                     transformed.x = Math.round(transformed.x)\r\n                     transformed.y = Math.round(transformed.y)\r\n\r\n                     */\r\n\r\n                    var transformed = {\r\n                        x: x,\r\n                        y: y\r\n                    }\r\n\r\n                    if (x === 0 && y === 0) {\r\n                        //          console.log(\"transformed is \", transformed)\r\n                    }\r\n                    var index = (transformed.y * laserConfig.testResolution.width + transformed.x) * 4;\r\n                    var indexnormal = (y * laserConfig.testResolution.width + x) * 4;\r\n                    var gx = Math.floor(x / gwidth);\r\n                    var gy = Math.floor(y / gheight);\r\n                    var gIndex = gy * laserConfig.gridResolution + gx;\r\n                    if (LaserApi.gRect[gIndex] > 0) {\r\n                        //     break;\r\n                    }\r\n                    //canvasColor.data[index + 1] = 0;\r\n                    //canvasColor.data[index + 2] = 0;\r\n                    //                    if (canvasColor.data[index] > (canvasColor.data[index + 1] + canvasColor.data[index + 2])) {\r\n                    var diff = [];\r\n                    var current = [];\r\n                    current[0] = canvasColorOriginal.data[index];\r\n                    current[1] = canvasColorOriginal.data[index + 1];\r\n                    current[2] = canvasColorOriginal.data[index + 2];\r\n\r\n                    if (getColorDistance(laserConfig.testColor, [\r\n                            canvasColorOriginal.data[index],\r\n                            canvasColorOriginal.data[index + 1],\r\n                            canvasColorOriginal.data[index + 2]\r\n\r\n                        ]) < laserConfig.treshold) {\r\n                        /*  coordinates.push({\r\n                         x: x,\r\n                         x: x,\r\n                         y: y,\r\n                         r: canvasColor.data[index],\r\n                         g: canvasColor.data[index + 1],\r\n                         b: canvasColor.data[index + 2]\r\n                         });\r\n                         */\r\n                        // LaserApi.globalImageData.data[indexnormal] = 0;\r\n                        // LaserApi.globalImageData.data[indexnormal + 1] = 0;\r\n                        // LaserApi.globalImageData.data[indexnormal + 2] = 255;\r\n\r\n                        LaserApi.gRect[gIndex] = LaserApi.gRect[gIndex] + 1;\r\n\r\n                    } else {\r\n                        // LaserApi.globalImageData.data[indexnormal] *= 0.9;\r\n                        // LaserApi.globalImageData.data[indexnormal + 1] *= 0.9;\r\n                        // LaserApi.globalImageData.data[indexnormal + 2] *= 0.9;\r\n\r\n                        //LaserApi .gRect[gIndex] = 0;\r\n                    }\r\n                }\r\n\r\n            }\r\n            return LaserApi.gRect\r\n\r\n        },\r\n\r\n        init: function (video, canvas) {\r\n            LaserApi.video = video\r\n            LaserApi.canvas = canvas\r\n            LaserApi.context = canvas.getContext(\"2d\")\r\n            console.log('LaserApi Init() called', video, canvas)\r\n\r\n            // ask for mic permission\r\n            navigator.getUserMedia({\r\n                video: {\r\n                    width: laserConfig.videoResolution.width,\r\n                    height: laserConfig.videoResolution.height\r\n                }\r\n            }, function (stream) {\r\n\r\n                console.log('Stream received', stream)\r\n                video.srcObject = stream;\r\n                video.onloadedmetadata = function (e) {\r\n                    console.log('Metadata received', this)\r\n                    console.log('Metadata received', e)\r\n                    // Do something with the video here.\r\n                    video.play();\r\n                    LaserApi.canvas.width = Math.floor(video.videoWidth)\r\n                    LaserApi.canvas.height = Math.floor(video.videoHeight)\r\n                    LaserApi.canvas.style.width = LaserApi.canvas.width;\r\n                    LaserApi.canvas.style.height = LaserApi.canvas.height;\r\n\r\n                    LaserApi.updateCanvasRegular()\r\n                };\r\n\r\n            }, function () {\r\n\r\n            })\r\n\r\n        },\r\n        // main loop, calls the render method each 30ms + calculates the current average volume + activates the alarm\r\n        updateCanvasRegular: function () {\r\n\r\n            var currentDate = performance.now()\r\n            //     console.log('checking ', lastDate, currentDate);\r\n            if (currentDate - lastDate < laserConfig.tickIntervalMilliseconds) {\r\n                window.requestAnimationFrame(LaserApi.updateCanvasRegular);\r\n                return\r\n            }\r\n            //    console.log('returning ', lastDate, currentDate);\r\n            lastDate = currentDate\r\n\r\n            LaserApi.updateCanvas()\r\n            window.requestAnimationFrame(LaserApi.updateCanvasRegular);\r\n            /*  setTimeout(function () {\r\n\r\n\r\n             updateCanvas()\r\n             updateCanvasRegular()\r\n\r\n             }, 300)*/\r\n        },\r\n\r\n        // render canvas\r\n        updateCanvas: function (options) {\r\n\r\n            //    console.log('UpdateCanvas in api ///');\r\n            var transform = getCoordinates();\r\n\r\n            if (LaserApi.globalImageData === null) {\r\n                LaserApi.globalImageData = LaserApi.context.createImageData(LaserApi.canvas.width, LaserApi.canvas.height)\r\n                for (var i = 0; i < LaserApi.globalImageData.data.length; i += 4) {\r\n                    LaserApi.globalImageData.data[i + 0] = 0;\r\n                    LaserApi.globalImageData.data[i + 1] = 0;\r\n                    LaserApi.globalImageData.data[i + 2] = 0;\r\n                    LaserApi.globalImageData.data[i + 3] = 255;\r\n                }\r\n            }\r\n            if (LaserApi.canvas.width > 0) {\r\n\r\n                // context.clearRect(0, 0, canvas.width, canvas.height)\r\n                LaserApi.context.drawImage(video, 0, 0, canvas.width, canvas.height);\r\n\r\n                var canvasColorOriginal = LaserApi.context.getImageData(0, 0, LaserApi.canvas.width, LaserApi.canvas.height); // rgba e [0,255]\r\n                var canvasColor = LaserApi.context.getImageData(0, 0, LaserApi.canvas.width, LaserApi.canvas.height); // rgba e [0,255]\r\n                var pixels = canvasColor.data;\r\n\r\n                var gwidth = (LaserApi.canvas.width / laserConfig.gridResolution);\r\n                var gheight = (LaserApi.canvas.height / laserConfig.gridResolution)\r\n\r\n                for (var gy = 0; gy < laserConfig.gridResolution; gy++) {\r\n                    for (var gx = 0; gx < laserConfig.gridResolution; gx++) {\r\n                        var gIndex = gy * laserConfig.gridResolution + gx;\r\n                        LaserApi.gRect[gIndex] = 0;\r\n                    }\r\n                }\r\n\r\n                // lol, room for improvement to make it stop as soon as an adequate pixel has been found in subsection search should continue directly in next section\r\n                for (var x = 0; x < LaserApi.canvas.width; x++) {\r\n                    for (var y = 0; y < LaserApi.canvas.height; y++) {\r\n\r\n                        /*var transformed = transformCoordinate({\r\n                         x: x / LaserApi.canvas.width,\r\n                         y: y / LaserApi.canvas.height\r\n                         }, transform);\r\n\r\n                         transformed.x *= LaserApi.canvas.width;\r\n                         transformed.y *= LaserApi.canvas.height;\r\n\r\n                         transformed.x = Math.round(transformed.x)\r\n                         transformed.y = Math.round(transformed.y)\r\n\r\n                         */\r\n\r\n                        var transformed = {\r\n                            x: x,\r\n                            y: y\r\n                        }\r\n\r\n                        if (x === 0 && y === 0) {\r\n                            //          console.log(\"transformed is \", transformed)\r\n                        }\r\n                        var index = (transformed.y * LaserApi.canvas.width + transformed.x) * 4;\r\n                        var indexnormal = (y * LaserApi.canvas.width + x) * 4;\r\n                        var gx = Math.floor(x / gwidth);\r\n                        var gy = Math.floor(y / gheight);\r\n                        var gIndex = gy * laserConfig.gridResolution + gx;\r\n\r\n                        //canvasColor.data[index + 1] = 0;\r\n                        //canvasColor.data[index + 2] = 0;\r\n                        //                    if (canvasColor.data[index] > (canvasColor.data[index + 1] + canvasColor.data[index + 2])) {\r\n                        var diff = [];\r\n                        var current = [];\r\n                        current[0] = canvasColorOriginal.data[index];\r\n                        current[1] = canvasColorOriginal.data[index + 1];\r\n                        current[2] = canvasColorOriginal.data[index + 2];\r\n\r\n                        if (getColorDistance(laserConfig.testColor, [\r\n                                canvasColorOriginal.data[index],\r\n                                canvasColorOriginal.data[index + 1],\r\n                                canvasColorOriginal.data[index + 2]\r\n\r\n                            ]) < laserConfig.treshold) {\r\n                            /*  coordinates.push({\r\n                             x: x,\r\n                             x: x,\r\n                             y: y,\r\n                             r: canvasColor.data[index],\r\n                             g: canvasColor.data[index + 1],\r\n                             b: canvasColor.data[index + 2]\r\n                             });\r\n                             */\r\n                            LaserApi.globalImageData.data[indexnormal] = 0;\r\n                            LaserApi.globalImageData.data[indexnormal + 1] = 0;\r\n                            LaserApi.globalImageData.data[indexnormal + 2] = 255;\r\n\r\n                            LaserApi.gRect[gIndex] = LaserApi.gRect[gIndex] + 1;\r\n\r\n                        } else {\r\n                            LaserApi.globalImageData.data[indexnormal] *= 0.9;\r\n                            LaserApi.globalImageData.data[indexnormal + 1] *= 0.9;\r\n                            LaserApi.globalImageData.data[indexnormal + 2] *= 0.9;\r\n\r\n                            //LaserApi .gRect[gIndex] = 0;\r\n                        }\r\n                    }\r\n\r\n                }\r\n\r\n                LaserApi.context.putImageData(LaserApi.globalImageData, 0, 0);\r\n\r\n                for (var gx = 0; gx < laserConfig.gridResolution; gx++) {\r\n                    for (var gy = 0; gy < laserConfig.gridResolution; gy++) {\r\n                        var ggx = gx * gwidth;\r\n                        var ggy = gy * gheight;\r\n                        var gIndex = gy * laserConfig.gridResolution + gx;\r\n\r\n                        if (LaserApi.gRect[gIndex] > 0) {\r\n                            LaserApi.context.strokeStyle = \"#0000ff\";\r\n                            LaserApi.context.strokeRect(ggx, ggy, gwidth, gheight)\r\n                            LaserApi.context.strokeStyle = \"#0000ff\";\r\n                            LaserApi.context.font = \"10px Arial\";\r\n                            LaserApi.context.fillStyle = '#ffffff'\r\n                            LaserApi.context.textAlign = 'center'\r\n                            // context.fillText('' +LaserApi . gRect[gIndex], ggx + gwidth * 0.5, ggy + gheight * 0.5);\r\n\r\n                            LaserApi.context.fillRect(ggx, ggy, LaserApi.canvas.width / laserConfig.gridResolution, LaserApi.canvas.height / laserConfig.gridResolution)\r\n                        }\r\n                        else {\r\n                            // context.strokeStyle = \"#ffffff\";\r\n\r\n                        }\r\n\r\n                    }\r\n                }\r\n\r\n                // so at this point is time to call the callback method from our api listener\r\n\r\n                if (LaserApi.callback) {\r\n\r\n                    LaserApi.callback(LaserApi.gRect)\r\n\r\n                }\r\n\r\n            }\r\n\r\n        },\r\n        registerCallback: function (fn) {\r\n            // most simple callback saving for now, no events, no unregister nothing\r\n            LaserApi.callback = fn\r\n        }\r\n\r\n    }\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (LaserApi);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///51\n");

/***/ }),
/* 52 */
/* exports provided: default */
/* all exports used */
/*!************************!*\
  !*** ./src/js/util.js ***!
  \************************/
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("Object.defineProperty(__webpack_exports__, \"__esModule\", { value: true });\nfunction componentToHex(c) {\r\n    var hex = c.toString(16);\r\n    return hex.length == 1 ? \"0\" + hex : hex;\r\n}\r\n\r\nfunction rgbToHex(r, g, b) {\r\n    return \"#\" + componentToHex(r) + componentToHex(g) + componentToHex(b);\r\n}\r\n\r\nfunction hexToRgb(hex) {\r\n    var result = /^#?([a-f\\d]{2})([a-f\\d]{2})([a-f\\d]{2})$/i.exec(hex);\r\n    return result ? {\r\n            r: parseInt(result[1], 16),\r\n            g: parseInt(result[2], 16),\r\n            b: parseInt(result[3], 16)\r\n        } : null;\r\n}\r\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\r\n\r\n    componentToHex: componentToHex,\r\n    rgbToHex: rgbToHex,\r\n    hexToRgb: hexToRgb\r\n});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTIuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9zcmMvanMvdXRpbC5qcz8yZjE5Il0sInNvdXJjZXNDb250ZW50IjpbImZ1bmN0aW9uIGNvbXBvbmVudFRvSGV4KGMpIHtcclxuICAgIHZhciBoZXggPSBjLnRvU3RyaW5nKDE2KTtcclxuICAgIHJldHVybiBoZXgubGVuZ3RoID09IDEgPyBcIjBcIiArIGhleCA6IGhleDtcclxufVxyXG5cclxuZnVuY3Rpb24gcmdiVG9IZXgociwgZywgYikge1xyXG4gICAgcmV0dXJuIFwiI1wiICsgY29tcG9uZW50VG9IZXgocikgKyBjb21wb25lbnRUb0hleChnKSArIGNvbXBvbmVudFRvSGV4KGIpO1xyXG59XHJcblxyXG5mdW5jdGlvbiBoZXhUb1JnYihoZXgpIHtcclxuICAgIHZhciByZXN1bHQgPSAvXiM/KFthLWZcXGRdezJ9KShbYS1mXFxkXXsyfSkoW2EtZlxcZF17Mn0pJC9pLmV4ZWMoaGV4KTtcclxuICAgIHJldHVybiByZXN1bHQgPyB7XHJcbiAgICAgICAgICAgIHI6IHBhcnNlSW50KHJlc3VsdFsxXSwgMTYpLFxyXG4gICAgICAgICAgICBnOiBwYXJzZUludChyZXN1bHRbMl0sIDE2KSxcclxuICAgICAgICAgICAgYjogcGFyc2VJbnQocmVzdWx0WzNdLCAxNilcclxuICAgICAgICB9IDogbnVsbDtcclxufVxyXG5leHBvcnQgZGVmYXVsdHtcclxuXHJcbiAgICBjb21wb25lbnRUb0hleDogY29tcG9uZW50VG9IZXgsXHJcbiAgICByZ2JUb0hleDogcmdiVG9IZXgsXHJcbiAgICBoZXhUb1JnYjogaGV4VG9SZ2JcclxufVxyXG5cblxuXG4vLy8vLy8vLy8vLy8vLy8vLy9cbi8vIFdFQlBBQ0sgRk9PVEVSXG4vLyAuL3NyYy9qcy91dGlsLmpzXG4vLyBtb2R1bGUgaWQgPSA1MlxuLy8gbW9kdWxlIGNodW5rcyA9IDAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///52\n");

/***/ }),
/* 53 */
/* no static exports found */
/* all exports used */
/*!************************!*\
  !*** ./src/js/game.js ***!
  \************************/
/***/ (function(module, exports) {

eval("\r\nconsole.log('game starting')\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9zcmMvanMvZ2FtZS5qcz83M2E5Il0sInNvdXJjZXNDb250ZW50IjpbIlxyXG5jb25zb2xlLmxvZygnZ2FtZSBzdGFydGluZycpXHJcblxuXG5cbi8vLy8vLy8vLy8vLy8vLy8vL1xuLy8gV0VCUEFDSyBGT09URVJcbi8vIC4vc3JjL2pzL2dhbWUuanNcbi8vIG1vZHVsZSBpZCA9IDUzXG4vLyBtb2R1bGUgY2h1bmtzID0gMCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///53\n");

/***/ }),
/* 54 */
/* exports provided: default */
/* all exports used */
/*!************************!*\
  !*** ./src/js/view.js ***!
  \************************/
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("Object.defineProperty(__webpack_exports__, \"__esModule\", { value: true });\nvar helper = __webpack_require__(/*! ./helper.js */ 17)\r\nvar laserConfig = __webpack_require__(/*! ./LaserApiConfig */ 4).default\r\nvar Util = __webpack_require__(/*! ./util */ 52).default\r\nvar CanvasVideo = __webpack_require__(/*! ./CanvasVideo */ 70).default\r\nvar LaserApi = __webpack_require__(/*! ./LaserApi.js */ 51).default\r\nvar LaserApiPresets = __webpack_require__(/*! ./LaserApiPresets */ 71).default\r\nvar w3 = __webpack_require__(/*! ./../css/w3.css */ 55).default\r\n//var game01 = require('./setups/game-001-play-midi').default\r\n//var shader = require('./shader').default\r\nvar MainCanvas = __webpack_require__(/*! ./MasterCanvas */ 5).default\r\n// var game01 = require('./setups/game-002-moorhuni').default\r\n//var game01 = require('./setups/game-003-pong').default\r\n//var game01 = require('./setups/game-004-paint').default\r\nvar gameDebug = __webpack_require__(/*! ./setups/game-004-debug */ 79).default\r\nvar gameDebugCorners = __webpack_require__(/*! ./setups/game-004-debug-corners */ 77).default\r\nvar gameDebugTransform = __webpack_require__(/*! ./setups/game-004-debug-transform */ 78).default\r\nvar GameWrapper = __webpack_require__(/*! ./setups/game-wrapper */ 82).default\r\n//var game01 = require('./setups/game-005-switch').default\r\nvar games = [\r\n    new GameWrapper(__webpack_require__(/*! ./setups/game-001-play-midi */ 74).default),\r\n    new GameWrapper(__webpack_require__(/*! ./setups/game-002-moorhuni */ 75).default),\r\n    new GameWrapper(__webpack_require__(/*! ./setups/game-003-pong */ 76).default),\r\n    new GameWrapper(__webpack_require__(/*! ./setups/game-005-switch */ 80).default),\r\n    new GameWrapper(__webpack_require__(/*! ./setups/game-006-fade */ 81).default)\r\n]\r\nconsole.log('games are', games)\r\n/* make sure to use https as the web audio api does not like http */\r\nMainCanvas.init(document.getElementById('canvas'))\r\nCanvasVideo.init(document.getElementById('video'))\r\n\r\nfunction startGame(index) {\r\n\r\n    if (games[index].init) {\r\n        games[index].init();\r\n    }\r\n}\r\nfunction stopGame(index) {\r\n\r\n    if (games[index].stop) {\r\n        games[index].stop();\r\n    }\r\n}\r\nstartGame(0)\r\n\r\nfunction skewY(context, angle) {\r\n    context.setTransform(1, Math.tan((angle / 180.0) * Math.PI), 0, 1, 0, 0);\r\n}\r\nfunction skewX(context, angle) {\r\n    context.setTransform(1, 0, Math.tan((angle / 180.0) * Math.PI), 1, 1, 0, 0);\r\n}\r\nfunction skewXY(context, angle1, angle2) {\r\n    context.setTransform(1, Math.tan((angle1 / 180.0) * Math.PI), Math.tan((angle2 / 180.0) * Math.PI), 1, 1, 0, 0);\r\n}\r\n\r\nvar lastGameIndex = -1\r\n\r\nfunction frameHandler() {\r\n\r\n    // console.log('Re Rendering');\r\n    // console.log('Re Rendering', MainCanvas.getCanvas());\r\n\r\n    animationHandler();\r\n\r\n    //var transform = getTransformOfVideoInput()\r\n\r\n    MainCanvas.clear()\r\n    MainCanvas.getCanvas().width = laserConfig.canvasResolution.width\r\n    MainCanvas.getCanvas().height = laserConfig.canvasResolution.height\r\n    MainCanvas.getCanvas().style.width = laserConfig.canvasResolution.width\r\n    MainCanvas.getCanvas().style.height = laserConfig.canvasResolution.height\r\n    MainCanvas.get2dContext().save()\r\n    //   skewXY(MainCanvas.get2dContext(), document.getElementById('skewY').value, document.getElementById('skewX').value)\r\n    //skewX(MainCanvas.get2dContext(), document.getElementById('skewX').value)\r\n    //   MainCanvas.get2dContext().translate(transform.translate.x, transform.translate.y)\r\n    //   MainCanvas.get2dContext().translate(transform.translate.x, transform.translate.y)\r\n    //   MainCanvas.get2dContext().rotate((transform.rotate / 180.0) * Math.PI)\r\n\r\n    //    MainCanvas.get2dContext().scale(transform.scale, transform.scale)\r\n    //  console.log('Re rotate', transform.rotate);\r\n    MainCanvas.get2dContext().imageSmoothingEnabled = false\r\n\r\n    MainCanvas.get2dContext().drawImage(CanvasVideo.getVideo(), 0, 0, laserConfig.testResolution.width, laserConfig.testResolution.height);\r\n\r\n    var canvasColor = MainCanvas.get2dContext().getImageData(0, 0, laserConfig.testResolution.width, laserConfig.testResolution.height); // rgba e [0,255]\r\n\r\n    MainCanvas.get2dContext().restore()\r\n\r\n    MainCanvas.get2dContext().fillStyle = '#006666'\r\n\r\n    MainCanvas.get2dContext().strokeStyle = \"#0000ff\";\r\n    MainCanvas.get2dContext().strokeRect(0, 0, laserConfig.testResolution.width, laserConfig.testResolution.height)\r\n    var canvasColorInterest = LaserApi.getInterestReqion(MainCanvas.get2dContext(), canvasColor)\r\n    if (!laserConfig.debugVideo) {\r\n        MainCanvas.clear()\r\n    } else {\r\n\r\n        MainCanvas.get2dContext().putImageData(canvasColorInterest, laserConfig.testResolution.width, 0);\r\n\r\n        gameDebugCorners.handle(canvasColor)\r\n        gameDebugTransform.handle(canvasColor)\r\n    }\r\n    var laserGrid = LaserApi.getRectForInputImage(canvasColorInterest)\r\n\r\n    if (laserConfig.showDebug) {\r\n        gameDebug.handle(laserGrid)\r\n    }\r\n\r\n    if (lastGameIndex !== laserConfig.gameIndex) {\r\n\r\n        if (games[lastGameIndex] && games[lastGameIndex].stop)\r\n            games[lastGameIndex].stop(laserGrid)\r\n        lastGameIndex = laserConfig.gameIndex\r\n    }\r\n    if (laserConfig.showGame) {\r\n\r\n        games[laserConfig.gameIndex].handle(laserGrid)\r\n    }\r\n\r\n    setTimeout(frameHandler, 0)\r\n}\r\n\r\nvar presets = []\r\nsetTimeout(frameHandler, 1000)\r\nif (document.addEventListener) {\r\n    document.addEventListener('webkitfullscreenchange', exitHandler, false);\r\n    // document.addEventListener('fullscreenchange', exitHandler, false);\r\n}\r\n\r\ndocument.onkeydown = function (evt) {\r\n    if (isNaN(evt.key)) {\r\n        console.log(evt.key)\r\n        switch (evt.key) {\r\n            case 'd':\r\n                //   console.log('doing it ',laserConfig.showDebug )\r\n                laserConfig.showDebug = !laserConfig.showDebug\r\n                document.getElementById('showDebug').checked = laserConfig.showDebug\r\n                break;\r\n            case 'v':\r\n                //   console.log('doing it ',laserConfig.showDebug )\r\n                laserConfig.debugVideo = !laserConfig.debugVideo\r\n                document.getElementById('debugVideo').checked = laserConfig.debugVideo\r\n                break;\r\n            case 'g':\r\n                console.log('doing it ', laserConfig.showGame)\r\n                laserConfig.showGame = !laserConfig.showGame\r\n                document.getElementById('showGame').checked = laserConfig.showGame\r\n                break;\r\n            case 'f':\r\n\r\n                fullscreen()\r\n\r\n                break;\r\n            case 'F':\r\n\r\n                fullscreenEdit()\r\n\r\n                break;\r\n            case 's':\r\n                // make snapshot\r\n\r\n                var canvas = document.getElementById('canvas')\r\n                var snapshotCanvasHtml = document.getElementById('snapshotCanvas')\r\n                var video = document.getElementById('video')\r\n                var canvasVideo = document.getElementById('canvasVideo')\r\n                var context2dVideo = canvasVideo.getContext(\"2d\");\r\n\r\n                canvasVideo.width = 1920\r\n                canvasVideo.height = 1080\r\n\r\n                // draw snapshot im,age\r\n\r\n                context2dVideo.drawImage(video, 0, 0, 1920, 1080);\r\n                gameDebugTransform.drawQuad(canvasVideo.width, canvasVideo.height, context2dVideo, laserConfig.transform)\r\n\r\n                var snapshotVideoHtml = document.getElementById('snapshotVideo')\r\n                var snapshotImage = canvas.toDataURL('image/png')\r\n                snapshotCanvasHtml.src = snapshotImage\r\n\r\n                var snapshotVideoImage = canvasVideo.toDataURL('image/png')\r\n                snapshotVideoHtml.src = snapshotVideoImage\r\n\r\n                //     console.log('video image is ', snapshotVideoImage)\r\n\r\n                break;\r\n        }\r\n\r\n        laserConfig\r\n    }\r\n    else {\r\n        document.getElementById('presets-selector').value = evt.key\r\n        loadPreset(presets [evt.key])\r\n    }\r\n}\r\n\r\nfunction exitHandler(data) {\r\n    console.log('exitHandler', data)\r\n    if (document.webkitIsFullScreen || document.mozFullScreen || document.msFullscreenElement !== null) {\r\n    } else {\r\n\r\n        /* Run code on exit */\r\n        console.log('RESETTING RESOLUTION TO DEFAULT', laserConfig.canvasResolution)\r\n        laserConfig.canvasResolution.width = 640\r\n        laserConfig.canvasResolution.height = 480\r\n        games[laserConfig.gameIndex].init()\r\n\r\n    }\r\n}\r\nfunction fullscreen() {\r\n\r\n    console.log('fullscreen clicked')\r\n    var elem = document.getElementById(\"canvas\");\r\n    var canvascontainer = document.getElementById(\"canvascontainer\");\r\n    var editor = document.getElementById(\"editor\");\r\n    console.log('element is ', elem)\r\n    editor.style.display = 'none'\r\n    console.log('element is ', elem.getBoundingClientRect())\r\n\r\n    laserConfig.canvasResolution.width = screen.width * document.getElementById('playfieldScale').value\r\n    laserConfig.canvasResolution.height = screen.height * document.getElementById('playfieldScale').value\r\n    canvas.style.left = (screen.width - laserConfig.canvasResolution.width) / 2\r\n    canvas.style.top = (screen.height - laserConfig.canvasResolution.height) / 2\r\n    console.log('resolution is clicked', laserConfig.canvasResolution)\r\n    if (canvascontainer.webkitRequestFullscreen) {\r\n        canvascontainer.webkitRequestFullscreen();\r\n    }\r\n\r\n    games[laserConfig.gameIndex].init()\r\n\r\n}\r\nfunction fullscreenEdit() {\r\n\r\n    console.log('fullscreenedit clicked')\r\n    var elem = document.body;\r\n    var canvascontainer = document.getElementById(\"canvascontainer\");\r\n    console.log('element is ', elem)\r\n    editor.style.display = 'block'\r\n    var canvas = document.getElementById(\"canvas\");\r\n    console.log('element is ', elem)\r\n    console.log('element is ', canvascontainer)\r\n    console.log('element is ', elem.getBoundingClientRect())\r\n\r\n    // laserConfig.canvasResolution.width = 640\r\n    // laserConfig.canvasResolution.height = 480\r\n\r\n    laserConfig.canvasResolution.width = screen.width * document.getElementById('playfieldScale').value\r\n    laserConfig.canvasResolution.height = screen.height * document.getElementById('playfieldScale').value\r\n    canvas.style.left = (screen.width - laserConfig.canvasResolution.width) / 2\r\n    canvas.style.top = (screen.height - laserConfig.canvasResolution.height) / 2\r\n    console.log('resolution is clicked', laserConfig.canvasResolution)\r\n    if (canvascontainer.webkitRequestFullscreen) {\r\n        canvascontainer.webkitRequestFullscreen();\r\n    }\r\n\r\n    games[laserConfig.gameIndex].init()\r\n\r\n}\r\nfunction initHTML() {\r\n\r\n    document.getElementById('fullscreen_button').onclick = fullscreen\r\n    document.getElementById('fullscreenedit_button').onclick = fullscreenEdit\r\n    document.getElementById('save-preset-button').onclick = function () {\r\n\r\n        console.log('saving preset')\r\n\r\n        presets = JSON.parse(window.localStorage.getItem('laserPresets'))\r\n        if (presets === null) {\r\n            presets = {\r\n                presets: []\r\n            }\r\n        }\r\n\r\n        presets.presets.push({\r\n            name: document.getElementById('preset-name').value,\r\n            config: laserConfig\r\n        })\r\n\r\n        window.localStorage.setItem('laserPresets', JSON.stringify(presets))\r\n    }\r\n\r\n    for (var i = 0; i < games.length; i++) {\r\n\r\n        var option = document.createElement(\"option\");\r\n        option.text = \"Game #\" + i + ' - ' + games[i].getName();\r\n        option.value = i\r\n        if (i === laserConfig.gameIndex) {\r\n            option.selected = true\r\n        }\r\n        console.log('game found: ', option.text)\r\n        document.getElementById('game-selector').add(option);\r\n\r\n    }\r\n\r\n    document.getElementById('game-selector').onchange = function (evt) {\r\n\r\n        laserConfig.gameIndex = evt.target.value\r\n\r\n    }\r\n\r\n    document.getElementById('presets-selector').onchange = function (evt) {\r\n        document.getElementById('preset-name').value = presets[evt.target.value].name\r\n        console.log('selector changed', evt.target.value, presets[evt.target.value])\r\n        var preset = presets[evt.target.value]\r\n        var config = preset.config\r\n        delete config.transform\r\n        delete config.videoTransform\r\n        loadHtmlFromSettings(presets[evt.target.value].config)\r\n        games[laserConfig.gameIndex].init(preset.initData);\r\n\r\n    }\r\n}\r\n\r\nfunction loadPreset(preset) {\r\n    if (preset === undefined) {\r\n        return\r\n    }\r\n    if (preset === null) {\r\n        return\r\n    }\r\n    var config = preset.config\r\n    delete config.transform\r\n    delete config.videoTransform\r\n    loadHtmlFromSettings(config)\r\n    games[laserConfig.gameIndex].init(preset.initData);\r\n\r\n}\r\n\r\nfunction loadPresetsFromLocalStorage() {\r\n\r\n    var data = JSON.parse(window.localStorage.getItem('laserPresets'))\r\n\r\n    presets = LaserApiPresets\r\n    if (data) {\r\n        //    presets = presets.join(data.presets)\r\n    }\r\n\r\n    console.log('presets data is ', data)\r\n}\r\nfunction loadFromLocalStorage() {\r\n    loadPresetsFromLocalStorage()\r\n    var data = JSON.parse(window.localStorage.getItem('laser'))\r\n    if (data !== null) {\r\n        console.log('last data is ', data)\r\n\r\n        loadHtmlFromSettings(data.laserConfig)\r\n    }\r\n\r\n}\r\n\r\nfunction loadHtmlFromSettings(settings) {\r\n\r\n    console.log('loading settings', settings)\r\n    if (settings.treshold !== undefined) {\r\n        document.getElementById('treshold').value = settings.treshold\r\n        laserConfig.treshold = settings.treshold\r\n    }\r\n    if (settings.testColor !== undefined) {\r\n\r\n        document.getElementById('lasercolor').value = Util.rgbToHex(settings.testColor[0], settings.testColor[1], settings.testColor[2])\r\n\r\n        laserConfig.testColor = settings.testColor\r\n    }\r\n    if (settings.debugVideo !== undefined) {\r\n\r\n        document.getElementById('debugVideo').value = settings.debugVideo\r\n        laserConfig.debugVideo = settings.debugVideo\r\n\r\n    }\r\n    if (settings.playfieldScale !== undefined) {\r\n\r\n        document.getElementById('playfieldScale').value = settings.playfieldScale\r\n        laserConfig.debugVideo = settings.playfieldScale\r\n\r\n    }\r\n    if (settings.showGame !== undefined) {\r\n\r\n        document.getElementById('showGame').checked = settings.showGame\r\n        laserConfig.showGame = settings.showGame\r\n\r\n    }\r\n    if (settings.gameIndex !== undefined) {\r\n\r\n        console.log('loading settings gameIndex', settings)\r\n        laserConfig.gameIndex = settings.gameIndex\r\n        document.getElementById('game-selector').value = settings.gameIndex\r\n\r\n    }\r\n    if (settings.showDebug !== undefined) {\r\n\r\n        document.getElementById('showDebug').checked = settings.showDebug\r\n        laserConfig.showDebug = settings.showDebug\r\n\r\n    }\r\n    if (settings.debugVideo !== undefined) {\r\n\r\n        document.getElementById('debugVideo').checked = settings.debugVideo\r\n        laserConfig.debugVideo = settings.debugVideo\r\n\r\n    }\r\n    if (settings.gridResolution !== undefined) {\r\n\r\n        document.getElementById('gridResolution').value = settings.gridResolution\r\n        laserConfig.gridResolution = settings.gridResolution\r\n\r\n    }\r\n    /*\r\n     if (settings.videoTransform !== undefined) {\r\n     if (settings.videoTransform.skew !== undefined) {\r\n\r\n     document.getElementById('skewX').value = settings.videoTransform.skew.x\r\n     laserConfig.videoTransform.skew.x = settings.videoTransform.skew.x\r\n\r\n     }\r\n     }\r\n     if (settings.videoTransform !== undefined && settings.videoTransform.skew !== undefined) {\r\n\r\n     document.getElementById('skewY').value = settings.videoTransform.skew.y\r\n     laserConfig.videoTransform.skew.y = settings.videoTransform.skew.y\r\n\r\n     }\r\n\r\n     if (settings.videoTransform !== undefined) {\r\n\r\n     document.getElementById('rotateVideo').value = settings.videoTransform.rotate\r\n     document.getElementById('scaleVideo').value = settings.videoTransform.scale\r\n     document.getElementById('translateVideoX').value = settings.videoTransform.translate.x\r\n     document.getElementById('translateVideoY').value = settings.videoTransform.translate.y\r\n     laserConfig.videoTransform.rotateVideo = settings.videoTransform.rotateVideo\r\n     laserConfig.videoTransform.translateVideoX = settings.videoTransform.translateVideoX\r\n     laserConfig.videoTransform.scaleVideo = settings.videoTransform.scaleVideo\r\n     laserConfig.videoTransform.translateVideoY = settings.videoTransform.translateVideoY\r\n\r\n     setVideoTransform(settings.videoTransform)\r\n     }\r\n     */\r\n    if (settings.transform !== undefined) {\r\n\r\n        setCoordinates(settings.transform)\r\n    }\r\n\r\n}\r\nfunction saveToLocalStorage() {\r\n    var data = JSON.stringify({\r\n        laserConfig: laserConfig\r\n    })\r\n    // console.log('Saving to localstorage', data)\r\n    window.localStorage.setItem('laser', data)\r\n}\r\n\r\nfunction getCoordinatesForInputElement(elemprefix) {\r\n\r\n    var elem1x = document.getElementById(elemprefix + '_x');\r\n    var elem1y = document.getElementById(elemprefix + '_y');\r\n    return {\r\n        x: elem1x.value / 10000.0,\r\n        y: elem1y.value / 10000.0\r\n    }\r\n}\r\n\r\nfunction setCoordinatesForInputElement(elemprefix, data) {\r\n\r\n    var elem1x = document.getElementById(elemprefix + '_x');\r\n    var elem1y = document.getElementById(elemprefix + '_y');\r\n    elem1x.value = data.x * 10000.0;\r\n    elem1y.value = data.y * 10000.0;\r\n}\r\nfunction getCoordinates() {\r\n    return {\r\n        topleft: getCoordinatesForInputElement('topleft'),\r\n        topright: getCoordinatesForInputElement('topright'),\r\n        bottomleft: getCoordinatesForInputElement('bottomleft'),\r\n        bottomright: getCoordinatesForInputElement('bottomright')\r\n\r\n    }\r\n}\r\nfunction getTransformOfVideoInput() {\r\n\r\n    return {\r\n        rotate: document.getElementById('rotateVideo').value,\r\n        skew: {\r\n            x: document.getElementById('skewX').value,\r\n            y: document.getElementById('skewY').value\r\n\r\n        },\r\n        scale: document.getElementById('scaleVideo').value,\r\n        translate: {\r\n            x: document.getElementById('translateVideoX').value,\r\n            y: document.getElementById('translateVideoY').value,\r\n        }\r\n    }\r\n}\r\nfunction setCoordinates(data) {\r\n\r\n    setCoordinatesForInputElement('topleft', data.topleft);\r\n    setCoordinatesForInputElement('topright', data.topright);\r\n    setCoordinatesForInputElement('bottomleft', data.bottomleft);\r\n    setCoordinatesForInputElement('bottomright', data.bottomright);\r\n}\r\n\r\nfunction updateKnobs(rect) {\r\n    return\r\n    var knob1 = document.getElementById('knob1');\r\n    var knob2 = document.getElementById('knob2');\r\n    var knob3 = document.getElementById('knob3');\r\n    var knob4 = document.getElementById('knob4');\r\n    var container = document.getElementById('video').getBoundingClientRect();\r\n    knob1.style.top = rect.topleft.y * container.height;\r\n    knob1.style.left = rect.topleft.x * container.width;\r\n    knob2.style.top = rect.topright.y * container.height;\r\n    knob2.style.left = rect.topright.x * container.width;\r\n    knob3.style.top = rect.bottomleft.y * container.height;\r\n    knob3.style.left = rect.bottomleft.x * container.width;\r\n    knob4.style.top = rect.bottomright.y * container.height;\r\n    knob4.style.left = rect.bottomright.x * container.width;\r\n\r\n    //   console.log(rect, knob1.style.top, knob1.style.left, container.width, container.height)\r\n\r\n}\r\n\r\nfunction setVideoTransform(transform) {\r\n    return;\r\n    var video = document.getElementById('video')\r\n\r\n    var trans = ''\r\n    //\r\n    trans = 'translate(' + transform.translate.x + 'px,' + transform.translate.y + 'px) ';\r\n    trans += 'scale(' + transform.scale + ') ';\r\n    trans += 'rotate(' + transform.rotate + 'deg) ';\r\n    video.style.transform = trans\r\n\r\n    //  console.log('set tranform to ', trans)\r\n    //   console.log('set tranform to ', video.style.transform)\r\n\r\n}\r\n\r\nvar interval = 1000 / 25\r\nvar lastDate = performance.now()\r\n\r\nfunction animationHandler() {\r\n\r\n    laserConfig.treshold = document.getElementById('treshold').value\r\n    laserConfig.gridResolution = document.getElementById('gridResolution').value\r\n    laserConfig.debugVideo = document.getElementById('debugVideo').checked\r\n    laserConfig.showDebug = document.getElementById('showDebug').checked\r\n    laserConfig.showGame = document.getElementById('showGame').checked\r\n    laserConfig.gameIndex = document.getElementById('game-selector').value\r\n    laserConfig.playfieldScale = document.getElementById('playfieldScale').value\r\n    //  laserConfig.videoTransform = getTransformOfVideoInput()\r\n\r\n    laserConfig.testColor[0] = Util.hexToRgb(document.getElementById('lasercolor').value).r\r\n    laserConfig.testColor[1] = Util.hexToRgb(document.getElementById('lasercolor').value).g\r\n    laserConfig.testColor[2] = Util.hexToRgb(document.getElementById('lasercolor').value).b\r\n    laserConfig.transform = getCoordinates()\r\n    // console.log('config is ', laserConfig)\r\n    //     shader.start()\r\n    //  updateKnobs(laserConfig.transform)\r\n    // setVideoTransform(getTransformOfVideoInput());\r\n    saveToLocalStorage()\r\n\r\n}\r\nvar canvasSize = {\r\n\r\n    x: 512,\r\n    y: 512\r\n\r\n}\r\n\r\nfunction updatePresetSelector() {\r\n\r\n    document.getElementById('presets-selector').innerHTML = ''\r\n\r\n    var option = document.createElement(\"option\");\r\n    option.text = 'Select Preset'\r\n    option.disabled = true\r\n    option.selected = true\r\n\r\n    console.log('game found: ', option.text)\r\n    document.getElementById('presets-selector').add(option);\r\n    for (var i = 0; i < presets.length; i++\r\n    ) {\r\n        var option = document.createElement(\"option\");\r\n        option.text = \"Preset #\" + i + ' - ' + presets[i].name;\r\n        option.value = i\r\n\r\n        console.log('game preset found: ', option.text)\r\n        document.getElementById('presets-selector').add(option);\r\n\r\n    }\r\n\r\n}\r\ndocument.addEventListener(\"DOMContentLoaded\", function (event) {\r\n    initHTML()\r\n    loadFromLocalStorage();\r\n    updatePresetSelector();\r\n    fullscreen()\r\n    fullscreenEdit()\r\n\r\n})\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = ({});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///54\n");

/***/ }),
/* 55 */
/* no static exports found */
/* all exports used */
/*!************************!*\
  !*** ./src/css/w3.css ***!
  \************************/
/***/ (function(module, exports) {

eval("// removed by extract-text-webpack-plugin//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTUuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9zcmMvY3NzL3czLmNzcz8yNjQ1Il0sInNvdXJjZXNDb250ZW50IjpbIi8vIHJlbW92ZWQgYnkgZXh0cmFjdC10ZXh0LXdlYnBhY2stcGx1Z2luXG5cblxuLy8vLy8vLy8vLy8vLy8vLy8vXG4vLyBXRUJQQUNLIEZPT1RFUlxuLy8gLi9zcmMvY3NzL3czLmNzc1xuLy8gbW9kdWxlIGlkID0gNTVcbi8vIG1vZHVsZSBjaHVua3MgPSAwIl0sIm1hcHBpbmdzIjoiQUFBQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///55\n");

/***/ }),
/* 56 */
/* no static exports found */
/* all exports used */
/*!***********************************************!*\
  !*** ./~/p2/src/collision/NaiveBroadphase.js ***!
  \***********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Circle = __webpack_require__(/*! ../shapes/Circle */ 16),\n    Plane = __webpack_require__(/*! ../shapes/Plane */ 22),\n    Shape = __webpack_require__(/*! ../shapes/Shape */ 3),\n    Particle = __webpack_require__(/*! ../shapes/Particle */ 21),\n    Broadphase = __webpack_require__(/*! ../collision/Broadphase */ 12),\n    vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\n\nmodule.exports = NaiveBroadphase;\n\n/**\n * Naive broadphase implementation. Does N^2 tests.\n *\n * @class NaiveBroadphase\n * @constructor\n * @extends Broadphase\n */\nfunction NaiveBroadphase(){\n    Broadphase.call(this, Broadphase.NAIVE);\n}\nNaiveBroadphase.prototype = new Broadphase();\nNaiveBroadphase.prototype.constructor = NaiveBroadphase;\n\n/**\n * Get the colliding pairs\n * @method getCollisionPairs\n * @param  {World} world\n * @return {Array}\n */\nNaiveBroadphase.prototype.getCollisionPairs = function(world){\n    var bodies = world.bodies,\n        result = this.result;\n\n    result.length = 0;\n\n    for(var i=0, Ncolliding=bodies.length; i!==Ncolliding; i++){\n        var bi = bodies[i];\n\n        for(var j=0; j<i; j++){\n            var bj = bodies[j];\n\n            if(Broadphase.canCollide(bi,bj) && this.boundingVolumeCheck(bi,bj)){\n                result.push(bi,bj);\n            }\n        }\n    }\n\n    return result;\n};\n\n/**\n * Returns all the bodies within an AABB.\n * @method aabbQuery\n * @param  {World} world\n * @param  {AABB} aabb\n * @param {array} result An array to store resulting bodies in.\n * @return {array}\n */\nNaiveBroadphase.prototype.aabbQuery = function(world, aabb, result){\n    result = result || [];\n\n    var bodies = world.bodies;\n    for(var i = 0; i < bodies.length; i++){\n        var b = bodies[i];\n\n        if(b.aabbNeedsUpdate){\n            b.updateAABB();\n        }\n\n        if(b.aabb.overlaps(aabb)){\n            result.push(b);\n        }\n    }\n\n    return result;\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///56\n");

/***/ }),
/* 57 */
/* no static exports found */
/* all exports used */
/*!********************************!*\
  !*** ./~/p2/src/math/polyk.js ***!
  \********************************/
/***/ (function(module, exports) {

eval("\n    /*\n        PolyK library\n        url: http://polyk.ivank.net\n        Released under MIT licence.\n\n        Copyright (c) 2012 Ivan Kuckir\n\n        Permission is hereby granted, free of charge, to any person\n        obtaining a copy of this software and associated documentation\n        files (the \"Software\"), to deal in the Software without\n        restriction, including without limitation the rights to use,\n        copy, modify, merge, publish, distribute, sublicense, and/or sell\n        copies of the Software, and to permit persons to whom the\n        Software is furnished to do so, subject to the following\n        conditions:\n\n        The above copyright notice and this permission notice shall be\n        included in all copies or substantial portions of the Software.\n\n        THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n        EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES\n        OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n        NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT\n        HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\n        WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n        FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR\n        OTHER DEALINGS IN THE SOFTWARE.\n    */\n\n    var PolyK = {};\n\n    /*\n        Is Polygon self-intersecting?\n\n        O(n^2)\n    */\n    /*\n    PolyK.IsSimple = function(p)\n    {\n        var n = p.length>>1;\n        if(n<4) return true;\n        var a1 = new PolyK._P(), a2 = new PolyK._P();\n        var b1 = new PolyK._P(), b2 = new PolyK._P();\n        var c = new PolyK._P();\n\n        for(var i=0; i<n; i++)\n        {\n            a1.x = p[2*i  ];\n            a1.y = p[2*i+1];\n            if(i==n-1)  { a2.x = p[0    ];  a2.y = p[1    ]; }\n            else        { a2.x = p[2*i+2];  a2.y = p[2*i+3]; }\n\n            for(var j=0; j<n; j++)\n            {\n                if(Math.abs(i-j) < 2) continue;\n                if(j==n-1 && i==0) continue;\n                if(i==n-1 && j==0) continue;\n\n                b1.x = p[2*j  ];\n                b1.y = p[2*j+1];\n                if(j==n-1)  { b2.x = p[0    ];  b2.y = p[1    ]; }\n                else        { b2.x = p[2*j+2];  b2.y = p[2*j+3]; }\n\n                if(PolyK._GetLineIntersection(a1,a2,b1,b2,c) != null) return false;\n            }\n        }\n        return true;\n    }\n\n    PolyK.IsConvex = function(p)\n    {\n        if(p.length<6) return true;\n        var l = p.length - 4;\n        for(var i=0; i<l; i+=2)\n            if(!PolyK._convex(p[i], p[i+1], p[i+2], p[i+3], p[i+4], p[i+5])) return false;\n        if(!PolyK._convex(p[l  ], p[l+1], p[l+2], p[l+3], p[0], p[1])) return false;\n        if(!PolyK._convex(p[l+2], p[l+3], p[0  ], p[1  ], p[2], p[3])) return false;\n        return true;\n    }\n    */\n    PolyK.GetArea = function(p)\n    {\n        if(p.length <6) return 0;\n        var l = p.length - 2;\n        var sum = 0;\n        for(var i=0; i<l; i+=2)\n            sum += (p[i+2]-p[i]) * (p[i+1]+p[i+3]);\n        sum += (p[0]-p[l]) * (p[l+1]+p[1]);\n        return - sum * 0.5;\n    }\n    /*\n    PolyK.GetAABB = function(p)\n    {\n        var minx = Infinity;\n        var miny = Infinity;\n        var maxx = -minx;\n        var maxy = -miny;\n        for(var i=0; i<p.length; i+=2)\n        {\n            minx = Math.min(minx, p[i  ]);\n            maxx = Math.max(maxx, p[i  ]);\n            miny = Math.min(miny, p[i+1]);\n            maxy = Math.max(maxy, p[i+1]);\n        }\n        return {x:minx, y:miny, width:maxx-minx, height:maxy-miny};\n    }\n    */\n\n    PolyK.Triangulate = function(p)\n    {\n        var n = p.length>>1;\n        if(n<3) return [];\n        var tgs = [];\n        var avl = [];\n        for(var i=0; i<n; i++) avl.push(i);\n\n        var i = 0;\n        var al = n;\n        while(al > 3)\n        {\n            var i0 = avl[(i+0)%al];\n            var i1 = avl[(i+1)%al];\n            var i2 = avl[(i+2)%al];\n\n            var ax = p[2*i0],  ay = p[2*i0+1];\n            var bx = p[2*i1],  by = p[2*i1+1];\n            var cx = p[2*i2],  cy = p[2*i2+1];\n\n            var earFound = false;\n            if(PolyK._convex(ax, ay, bx, by, cx, cy))\n            {\n                earFound = true;\n                for(var j=0; j<al; j++)\n                {\n                    var vi = avl[j];\n                    if(vi==i0 || vi==i1 || vi==i2) continue;\n                    if(PolyK._PointInTriangle(p[2*vi], p[2*vi+1], ax, ay, bx, by, cx, cy)) {earFound = false; break;}\n                }\n            }\n            if(earFound)\n            {\n                tgs.push(i0, i1, i2);\n                avl.splice((i+1)%al, 1);\n                al--;\n                i= 0;\n            }\n            else if(i++ > 3*al) break;      // no convex angles :(\n        }\n        tgs.push(avl[0], avl[1], avl[2]);\n        return tgs;\n    }\n    /*\n    PolyK.ContainsPoint = function(p, px, py)\n    {\n        var n = p.length>>1;\n        var ax, ay, bx = p[2*n-2]-px, by = p[2*n-1]-py;\n        var depth = 0;\n        for(var i=0; i<n; i++)\n        {\n            ax = bx;  ay = by;\n            bx = p[2*i  ] - px;\n            by = p[2*i+1] - py;\n            if(ay< 0 && by< 0) continue;    // both \"up\" or both \"donw\"\n            if(ay>=0 && by>=0) continue;    // both \"up\" or both \"donw\"\n            if(ax< 0 && bx< 0) continue;\n\n            var lx = ax + (bx-ax)*(-ay)/(by-ay);\n            if(lx>0) depth++;\n        }\n        return (depth & 1) == 1;\n    }\n\n    PolyK.Slice = function(p, ax, ay, bx, by)\n    {\n        if(PolyK.ContainsPoint(p, ax, ay) || PolyK.ContainsPoint(p, bx, by)) return [p.slice(0)];\n\n        var a = new PolyK._P(ax, ay);\n        var b = new PolyK._P(bx, by);\n        var iscs = [];  // intersections\n        var ps = [];    // points\n        for(var i=0; i<p.length; i+=2) ps.push(new PolyK._P(p[i], p[i+1]));\n\n        for(var i=0; i<ps.length; i++)\n        {\n            var isc = new PolyK._P(0,0);\n            isc = PolyK._GetLineIntersection(a, b, ps[i], ps[(i+1)%ps.length], isc);\n\n            if(isc)\n            {\n                isc.flag = true;\n                iscs.push(isc);\n                ps.splice(i+1,0,isc);\n                i++;\n            }\n        }\n        if(iscs.length == 0) return [p.slice(0)];\n        var comp = function(u,v) {return PolyK._P.dist(a,u) - PolyK._P.dist(a,v); }\n        iscs.sort(comp);\n\n        var pgs = [];\n        var dir = 0;\n        while(iscs.length > 0)\n        {\n            var n = ps.length;\n            var i0 = iscs[0];\n            var i1 = iscs[1];\n            var ind0 = ps.indexOf(i0);\n            var ind1 = ps.indexOf(i1);\n            var solved = false;\n\n            if(PolyK._firstWithFlag(ps, ind0) == ind1) solved = true;\n            else\n            {\n                i0 = iscs[1];\n                i1 = iscs[0];\n                ind0 = ps.indexOf(i0);\n                ind1 = ps.indexOf(i1);\n                if(PolyK._firstWithFlag(ps, ind0) == ind1) solved = true;\n            }\n            if(solved)\n            {\n                dir--;\n                var pgn = PolyK._getPoints(ps, ind0, ind1);\n                pgs.push(pgn);\n                ps = PolyK._getPoints(ps, ind1, ind0);\n                i0.flag = i1.flag = false;\n                iscs.splice(0,2);\n                if(iscs.length == 0) pgs.push(ps);\n            }\n            else { dir++; iscs.reverse(); }\n            if(dir>1) break;\n        }\n        var result = [];\n        for(var i=0; i<pgs.length; i++)\n        {\n            var pg = pgs[i];\n            var npg = [];\n            for(var j=0; j<pg.length; j++) npg.push(pg[j].x, pg[j].y);\n            result.push(npg);\n        }\n        return result;\n    }\n\n    PolyK.Raycast = function(p, x, y, dx, dy, isc)\n    {\n        var l = p.length - 2;\n        var tp = PolyK._tp;\n        var a1 = tp[0], a2 = tp[1],\n        b1 = tp[2], b2 = tp[3], c = tp[4];\n        a1.x = x; a1.y = y;\n        a2.x = x+dx; a2.y = y+dy;\n\n        if(isc==null) isc = {dist:0, edge:0, norm:{x:0, y:0}, refl:{x:0, y:0}};\n        isc.dist = Infinity;\n\n        for(var i=0; i<l; i+=2)\n        {\n            b1.x = p[i  ];  b1.y = p[i+1];\n            b2.x = p[i+2];  b2.y = p[i+3];\n            var nisc = PolyK._RayLineIntersection(a1, a2, b1, b2, c);\n            if(nisc) PolyK._updateISC(dx, dy, a1, b1, b2, c, i/2, isc);\n        }\n        b1.x = b2.x;  b1.y = b2.y;\n        b2.x = p[0];  b2.y = p[1];\n        var nisc = PolyK._RayLineIntersection(a1, a2, b1, b2, c);\n        if(nisc) PolyK._updateISC(dx, dy, a1, b1, b2, c, p.length/2, isc);\n\n        return (isc.dist != Infinity) ? isc : null;\n    }\n\n    PolyK.ClosestEdge = function(p, x, y, isc)\n    {\n        var l = p.length - 2;\n        var tp = PolyK._tp;\n        var a1 = tp[0],\n        b1 = tp[2], b2 = tp[3], c = tp[4];\n        a1.x = x; a1.y = y;\n\n        if(isc==null) isc = {dist:0, edge:0, point:{x:0, y:0}, norm:{x:0, y:0}};\n        isc.dist = Infinity;\n\n        for(var i=0; i<l; i+=2)\n        {\n            b1.x = p[i  ];  b1.y = p[i+1];\n            b2.x = p[i+2];  b2.y = p[i+3];\n            PolyK._pointLineDist(a1, b1, b2, i>>1, isc);\n        }\n        b1.x = b2.x;  b1.y = b2.y;\n        b2.x = p[0];  b2.y = p[1];\n        PolyK._pointLineDist(a1, b1, b2, l>>1, isc);\n\n        var idst = 1/isc.dist;\n        isc.norm.x = (x-isc.point.x)*idst;\n        isc.norm.y = (y-isc.point.y)*idst;\n        return isc;\n    }\n\n    PolyK._pointLineDist = function(p, a, b, edge, isc)\n    {\n        var x = p.x, y = p.y, x1 = a.x, y1 = a.y, x2 = b.x, y2 = b.y;\n\n        var A = x - x1;\n        var B = y - y1;\n        var C = x2 - x1;\n        var D = y2 - y1;\n\n        var dot = A * C + B * D;\n        var len_sq = C * C + D * D;\n        var param = dot / len_sq;\n\n        var xx, yy;\n\n        if (param < 0 || (x1 == x2 && y1 == y2)) {\n            xx = x1;\n            yy = y1;\n        }\n        else if (param > 1) {\n            xx = x2;\n            yy = y2;\n        }\n        else {\n            xx = x1 + param * C;\n            yy = y1 + param * D;\n        }\n\n        var dx = x - xx;\n        var dy = y - yy;\n        var dst = Math.sqrt(dx * dx + dy * dy);\n        if(dst<isc.dist)\n        {\n            isc.dist = dst;\n            isc.edge = edge;\n            isc.point.x = xx;\n            isc.point.y = yy;\n        }\n    }\n\n    PolyK._updateISC = function(dx, dy, a1, b1, b2, c, edge, isc)\n    {\n        var nrl = PolyK._P.dist(a1, c);\n        if(nrl<isc.dist)\n        {\n            var ibl = 1/PolyK._P.dist(b1, b2);\n            var nx = -(b2.y-b1.y)*ibl;\n            var ny =  (b2.x-b1.x)*ibl;\n            var ddot = 2*(dx*nx+dy*ny);\n            isc.dist = nrl;\n            isc.norm.x = nx;\n            isc.norm.y = ny;\n            isc.refl.x = -ddot*nx+dx;\n            isc.refl.y = -ddot*ny+dy;\n            isc.edge = edge;\n        }\n    }\n\n    PolyK._getPoints = function(ps, ind0, ind1)\n    {\n        var n = ps.length;\n        var nps = [];\n        if(ind1<ind0) ind1 += n;\n        for(var i=ind0; i<= ind1; i++) nps.push(ps[i%n]);\n        return nps;\n    }\n\n    PolyK._firstWithFlag = function(ps, ind)\n    {\n        var n = ps.length;\n        while(true)\n        {\n            ind = (ind+1)%n;\n            if(ps[ind].flag) return ind;\n        }\n    }\n    */\n    PolyK._PointInTriangle = function(px, py, ax, ay, bx, by, cx, cy)\n    {\n        var v0x = cx-ax;\n        var v0y = cy-ay;\n        var v1x = bx-ax;\n        var v1y = by-ay;\n        var v2x = px-ax;\n        var v2y = py-ay;\n\n        var dot00 = v0x*v0x+v0y*v0y;\n        var dot01 = v0x*v1x+v0y*v1y;\n        var dot02 = v0x*v2x+v0y*v2y;\n        var dot11 = v1x*v1x+v1y*v1y;\n        var dot12 = v1x*v2x+v1y*v2y;\n\n        var invDenom = 1 / (dot00 * dot11 - dot01 * dot01);\n        var u = (dot11 * dot02 - dot01 * dot12) * invDenom;\n        var v = (dot00 * dot12 - dot01 * dot02) * invDenom;\n\n        // Check if point is in triangle\n        return (u >= 0) && (v >= 0) && (u + v < 1);\n    }\n    /*\n    PolyK._RayLineIntersection = function(a1, a2, b1, b2, c)\n    {\n        var dax = (a1.x-a2.x), dbx = (b1.x-b2.x);\n        var day = (a1.y-a2.y), dby = (b1.y-b2.y);\n\n        var Den = dax*dby - day*dbx;\n        if (Den == 0) return null;  // parallel\n\n        var A = (a1.x * a2.y - a1.y * a2.x);\n        var B = (b1.x * b2.y - b1.y * b2.x);\n\n        var I = c;\n        var iDen = 1/Den;\n        I.x = ( A*dbx - dax*B ) * iDen;\n        I.y = ( A*dby - day*B ) * iDen;\n\n        if(!PolyK._InRect(I, b1, b2)) return null;\n        if((day>0 && I.y>a1.y) || (day<0 && I.y<a1.y)) return null;\n        if((dax>0 && I.x>a1.x) || (dax<0 && I.x<a1.x)) return null;\n        return I;\n    }\n\n    PolyK._GetLineIntersection = function(a1, a2, b1, b2, c)\n    {\n        var dax = (a1.x-a2.x), dbx = (b1.x-b2.x);\n        var day = (a1.y-a2.y), dby = (b1.y-b2.y);\n\n        var Den = dax*dby - day*dbx;\n        if (Den == 0) return null;  // parallel\n\n        var A = (a1.x * a2.y - a1.y * a2.x);\n        var B = (b1.x * b2.y - b1.y * b2.x);\n\n        var I = c;\n        I.x = ( A*dbx - dax*B ) / Den;\n        I.y = ( A*dby - day*B ) / Den;\n\n        if(PolyK._InRect(I, a1, a2) && PolyK._InRect(I, b1, b2)) return I;\n        return null;\n    }\n\n    PolyK._InRect = function(a, b, c)\n    {\n        if  (b.x == c.x) return (a.y>=Math.min(b.y, c.y) && a.y<=Math.max(b.y, c.y));\n        if  (b.y == c.y) return (a.x>=Math.min(b.x, c.x) && a.x<=Math.max(b.x, c.x));\n\n        if(a.x >= Math.min(b.x, c.x) && a.x <= Math.max(b.x, c.x)\n        && a.y >= Math.min(b.y, c.y) && a.y <= Math.max(b.y, c.y))\n        return true;\n        return false;\n    }\n    */\n    PolyK._convex = function(ax, ay, bx, by, cx, cy)\n    {\n        return (ay-by)*(cx-bx) + (bx-ax)*(cy-by) >= 0;\n    }\n    /*\n    PolyK._P = function(x,y)\n    {\n        this.x = x;\n        this.y = y;\n        this.flag = false;\n    }\n    PolyK._P.prototype.toString = function()\n    {\n        return \"Point [\"+this.x+\", \"+this.y+\"]\";\n    }\n    PolyK._P.dist = function(a,b)\n    {\n        var dx = b.x-a.x;\n        var dy = b.y-a.y;\n        return Math.sqrt(dx*dx + dy*dy);\n    }\n\n    PolyK._tp = [];\n    for(var i=0; i<10; i++) PolyK._tp.push(new PolyK._P(0,0));\n        */\n\nmodule.exports = PolyK;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///57\n");

/***/ }),
/* 58 */
/* no static exports found */
/* all exports used */
/*!********************************************!*\
  !*** ./~/p2/src/objects/TopDownVehicle.js ***!
  \********************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var vec2 = __webpack_require__(/*! ../math/vec2 */ 0);\nvar Utils = __webpack_require__(/*! ../utils/Utils */ 1);\nvar Constraint = __webpack_require__(/*! ../constraints/Constraint */ 6);\nvar FrictionEquation = __webpack_require__(/*! ../equations/FrictionEquation */ 9);\nvar Body = __webpack_require__(/*! ../objects/Body */ 7);\n\nmodule.exports = TopDownVehicle;\n\n/**\n * @class TopDownVehicle\n * @constructor\n * @param {Body} chassisBody A dynamic body, already added to the world.\n * @param {Object} [options]\n *\n * @example\n *\n *     // Create a dynamic body for the chassis\n *     var chassisBody = new Body({\n *         mass: 1\n *     });\n *     var boxShape = new Box({ width: 0.5, height: 1 });\n *     chassisBody.addShape(boxShape);\n *     world.addBody(chassisBody);\n *\n *     // Create the vehicle\n *     var vehicle = new TopDownVehicle(chassisBody);\n *\n *     // Add one front wheel and one back wheel - we don't actually need four :)\n *     var frontWheel = vehicle.addWheel({\n *         localPosition: [0, 0.5] // front\n *     });\n *     frontWheel.setSideFriction(4);\n *\n *     // Back wheel\n *     var backWheel = vehicle.addWheel({\n *         localPosition: [0, -0.5] // back\n *     });\n *     backWheel.setSideFriction(3); // Less side friction on back wheel makes it easier to drift\n *     vehicle.addToWorld(world);\n *\n *     // Steer value zero means straight forward. Positive is left and negative right.\n *     frontWheel.steerValue = Math.PI / 16;\n *\n *     // Engine force forward\n *     backWheel.engineForce = 10;\n *     backWheel.setBrakeForce(0);\n */\nfunction TopDownVehicle(chassisBody, options){\n    options = options || {};\n\n    /**\n     * @property {Body} chassisBody\n     */\n    this.chassisBody = chassisBody;\n\n    /**\n     * @property {Array} wheels\n     */\n    this.wheels = [];\n\n    // A dummy body to constrain the chassis to\n    this.groundBody = new Body({ mass: 0 });\n\n    this.world = null;\n\n    var that = this;\n    this.preStepCallback = function(){\n        that.update();\n    };\n}\n\n/**\n * @method addToWorld\n * @param {World} world\n */\nTopDownVehicle.prototype.addToWorld = function(world){\n    this.world = world;\n    world.addBody(this.groundBody);\n    world.on('preStep', this.preStepCallback);\n    for (var i = 0; i < this.wheels.length; i++) {\n        var wheel = this.wheels[i];\n        world.addConstraint(wheel);\n    }\n};\n\n/**\n * @method removeFromWorld\n * @param {World} world\n */\nTopDownVehicle.prototype.removeFromWorld = function(){\n    var world = this.world;\n    world.removeBody(this.groundBody);\n    world.off('preStep', this.preStepCallback);\n    for (var i = 0; i < this.wheels.length; i++) {\n        var wheel = this.wheels[i];\n        world.removeConstraint(wheel);\n    }\n    this.world = null;\n};\n\n/**\n * @method addWheel\n * @param {object} [wheelOptions]\n * @return {WheelConstraint}\n */\nTopDownVehicle.prototype.addWheel = function(wheelOptions){\n    var wheel = new WheelConstraint(this,wheelOptions);\n    this.wheels.push(wheel);\n    return wheel;\n};\n\n/**\n * @method update\n */\nTopDownVehicle.prototype.update = function(){\n    for (var i = 0; i < this.wheels.length; i++) {\n        this.wheels[i].update();\n    }\n};\n\n/**\n * @class WheelConstraint\n * @constructor\n * @extends {Constraint}\n * @param {Vehicle} vehicle\n * @param {object} [options]\n * @param {Array} [options.localForwardVector]The local wheel forward vector in local body space. Default is zero.\n * @param {Array} [options.localPosition] The local position of the wheen in the chassis body. Default is zero - the center of the body.\n * @param {Array} [options.sideFriction=5] The max friction force in the sideways direction.\n */\nfunction WheelConstraint(vehicle, options){\n    options = options || {};\n\n    this.vehicle = vehicle;\n\n    this.forwardEquation = new FrictionEquation(vehicle.chassisBody, vehicle.groundBody);\n\n    this.sideEquation = new FrictionEquation(vehicle.chassisBody, vehicle.groundBody);\n\n    /**\n     * @property {number} steerValue\n     */\n    this.steerValue = 0;\n\n    /**\n     * @property {number} engineForce\n     */\n    this.engineForce = 0;\n\n    this.setSideFriction(options.sideFriction !== undefined ? options.sideFriction : 5);\n\n    /**\n     * @property {Array} localForwardVector\n     */\n    this.localForwardVector = vec2.fromValues(0, 1);\n    if(options.localForwardVector){\n        vec2.copy(this.localForwardVector, options.localForwardVector);\n    }\n\n    /**\n     * @property {Array} localPosition\n     */\n    this.localPosition = vec2.fromValues(0, 0);\n    if(options.localPosition){\n        vec2.copy(this.localPosition, options.localPosition);\n    }\n\n    Constraint.apply(this, vehicle.chassisBody, vehicle.groundBody);\n\n    this.equations.push(\n        this.forwardEquation,\n        this.sideEquation\n    );\n\n    this.setBrakeForce(0);\n}\nWheelConstraint.prototype = new Constraint();\n\n/**\n * @method setForwardFriction\n */\nWheelConstraint.prototype.setBrakeForce = function(force){\n    this.forwardEquation.setSlipForce(force);\n};\n\n/**\n * @method setSideFriction\n */\nWheelConstraint.prototype.setSideFriction = function(force){\n    this.sideEquation.setSlipForce(force);\n};\n\nvar worldVelocity = vec2.create();\nvar relativePoint = vec2.create();\n\n/**\n * @method getSpeed\n */\nWheelConstraint.prototype.getSpeed = function(){\n    this.vehicle.chassisBody.vectorToWorldFrame(relativePoint, this.localForwardVector);\n    this.vehicle.chassisBody.getVelocityAtPoint(worldVelocity, relativePoint);\n    return vec2.dot(worldVelocity, relativePoint);\n};\n\nvar tmpVec = vec2.create();\n\n/**\n * @method update\n */\nWheelConstraint.prototype.update = function(){\n\n    // Directional\n    this.vehicle.chassisBody.vectorToWorldFrame(this.forwardEquation.t, this.localForwardVector);\n    vec2.rotate(this.sideEquation.t, this.localForwardVector, Math.PI / 2);\n    this.vehicle.chassisBody.vectorToWorldFrame(this.sideEquation.t, this.sideEquation.t);\n\n    vec2.rotate(this.forwardEquation.t, this.forwardEquation.t, this.steerValue);\n    vec2.rotate(this.sideEquation.t, this.sideEquation.t, this.steerValue);\n\n    // Attachment point\n    this.vehicle.chassisBody.toWorldFrame(this.forwardEquation.contactPointB, this.localPosition);\n    vec2.copy(this.sideEquation.contactPointB, this.forwardEquation.contactPointB);\n\n    this.vehicle.chassisBody.vectorToWorldFrame(this.forwardEquation.contactPointA, this.localPosition);\n    vec2.copy(this.sideEquation.contactPointA, this.forwardEquation.contactPointA);\n\n    // Add engine force\n    vec2.normalize(tmpVec, this.forwardEquation.t);\n    vec2.scale(tmpVec, tmpVec, this.engineForce);\n\n    this.vehicle.chassisBody.applyForce(tmpVec, this.forwardEquation.contactPointA);\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNTguanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9+L3AyL3NyYy9vYmplY3RzL1RvcERvd25WZWhpY2xlLmpzPzZhOWMiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIHZlYzIgPSByZXF1aXJlKCcuLi9tYXRoL3ZlYzInKTtcbnZhciBVdGlscyA9IHJlcXVpcmUoJy4uL3V0aWxzL1V0aWxzJyk7XG52YXIgQ29uc3RyYWludCA9IHJlcXVpcmUoJy4uL2NvbnN0cmFpbnRzL0NvbnN0cmFpbnQnKTtcbnZhciBGcmljdGlvbkVxdWF0aW9uID0gcmVxdWlyZSgnLi4vZXF1YXRpb25zL0ZyaWN0aW9uRXF1YXRpb24nKTtcbnZhciBCb2R5ID0gcmVxdWlyZSgnLi4vb2JqZWN0cy9Cb2R5Jyk7XG5cbm1vZHVsZS5leHBvcnRzID0gVG9wRG93blZlaGljbGU7XG5cbi8qKlxuICogQGNsYXNzIFRvcERvd25WZWhpY2xlXG4gKiBAY29uc3RydWN0b3JcbiAqIEBwYXJhbSB7Qm9keX0gY2hhc3Npc0JvZHkgQSBkeW5hbWljIGJvZHksIGFscmVhZHkgYWRkZWQgdG8gdGhlIHdvcmxkLlxuICogQHBhcmFtIHtPYmplY3R9IFtvcHRpb25zXVxuICpcbiAqIEBleGFtcGxlXG4gKlxuICogICAgIC8vIENyZWF0ZSBhIGR5bmFtaWMgYm9keSBmb3IgdGhlIGNoYXNzaXNcbiAqICAgICB2YXIgY2hhc3Npc0JvZHkgPSBuZXcgQm9keSh7XG4gKiAgICAgICAgIG1hc3M6IDFcbiAqICAgICB9KTtcbiAqICAgICB2YXIgYm94U2hhcGUgPSBuZXcgQm94KHsgd2lkdGg6IDAuNSwgaGVpZ2h0OiAxIH0pO1xuICogICAgIGNoYXNzaXNCb2R5LmFkZFNoYXBlKGJveFNoYXBlKTtcbiAqICAgICB3b3JsZC5hZGRCb2R5KGNoYXNzaXNCb2R5KTtcbiAqXG4gKiAgICAgLy8gQ3JlYXRlIHRoZSB2ZWhpY2xlXG4gKiAgICAgdmFyIHZlaGljbGUgPSBuZXcgVG9wRG93blZlaGljbGUoY2hhc3Npc0JvZHkpO1xuICpcbiAqICAgICAvLyBBZGQgb25lIGZyb250IHdoZWVsIGFuZCBvbmUgYmFjayB3aGVlbCAtIHdlIGRvbid0IGFjdHVhbGx5IG5lZWQgZm91ciA6KVxuICogICAgIHZhciBmcm9udFdoZWVsID0gdmVoaWNsZS5hZGRXaGVlbCh7XG4gKiAgICAgICAgIGxvY2FsUG9zaXRpb246IFswLCAwLjVdIC8vIGZyb250XG4gKiAgICAgfSk7XG4gKiAgICAgZnJvbnRXaGVlbC5zZXRTaWRlRnJpY3Rpb24oNCk7XG4gKlxuICogICAgIC8vIEJhY2sgd2hlZWxcbiAqICAgICB2YXIgYmFja1doZWVsID0gdmVoaWNsZS5hZGRXaGVlbCh7XG4gKiAgICAgICAgIGxvY2FsUG9zaXRpb246IFswLCAtMC41XSAvLyBiYWNrXG4gKiAgICAgfSk7XG4gKiAgICAgYmFja1doZWVsLnNldFNpZGVGcmljdGlvbigzKTsgLy8gTGVzcyBzaWRlIGZyaWN0aW9uIG9uIGJhY2sgd2hlZWwgbWFrZXMgaXQgZWFzaWVyIHRvIGRyaWZ0XG4gKiAgICAgdmVoaWNsZS5hZGRUb1dvcmxkKHdvcmxkKTtcbiAqXG4gKiAgICAgLy8gU3RlZXIgdmFsdWUgemVybyBtZWFucyBzdHJhaWdodCBmb3J3YXJkLiBQb3NpdGl2ZSBpcyBsZWZ0IGFuZCBuZWdhdGl2ZSByaWdodC5cbiAqICAgICBmcm9udFdoZWVsLnN0ZWVyVmFsdWUgPSBNYXRoLlBJIC8gMTY7XG4gKlxuICogICAgIC8vIEVuZ2luZSBmb3JjZSBmb3J3YXJkXG4gKiAgICAgYmFja1doZWVsLmVuZ2luZUZvcmNlID0gMTA7XG4gKiAgICAgYmFja1doZWVsLnNldEJyYWtlRm9yY2UoMCk7XG4gKi9cbmZ1bmN0aW9uIFRvcERvd25WZWhpY2xlKGNoYXNzaXNCb2R5LCBvcHRpb25zKXtcbiAgICBvcHRpb25zID0gb3B0aW9ucyB8fCB7fTtcblxuICAgIC8qKlxuICAgICAqIEBwcm9wZXJ0eSB7Qm9keX0gY2hhc3Npc0JvZHlcbiAgICAgKi9cbiAgICB0aGlzLmNoYXNzaXNCb2R5ID0gY2hhc3Npc0JvZHk7XG5cbiAgICAvKipcbiAgICAgKiBAcHJvcGVydHkge0FycmF5fSB3aGVlbHNcbiAgICAgKi9cbiAgICB0aGlzLndoZWVscyA9IFtdO1xuXG4gICAgLy8gQSBkdW1teSBib2R5IHRvIGNvbnN0cmFpbiB0aGUgY2hhc3NpcyB0b1xuICAgIHRoaXMuZ3JvdW5kQm9keSA9IG5ldyBCb2R5KHsgbWFzczogMCB9KTtcblxuICAgIHRoaXMud29ybGQgPSBudWxsO1xuXG4gICAgdmFyIHRoYXQgPSB0aGlzO1xuICAgIHRoaXMucHJlU3RlcENhbGxiYWNrID0gZnVuY3Rpb24oKXtcbiAgICAgICAgdGhhdC51cGRhdGUoKTtcbiAgICB9O1xufVxuXG4vKipcbiAqIEBtZXRob2QgYWRkVG9Xb3JsZFxuICogQHBhcmFtIHtXb3JsZH0gd29ybGRcbiAqL1xuVG9wRG93blZlaGljbGUucHJvdG90eXBlLmFkZFRvV29ybGQgPSBmdW5jdGlvbih3b3JsZCl7XG4gICAgdGhpcy53b3JsZCA9IHdvcmxkO1xuICAgIHdvcmxkLmFkZEJvZHkodGhpcy5ncm91bmRCb2R5KTtcbiAgICB3b3JsZC5vbigncHJlU3RlcCcsIHRoaXMucHJlU3RlcENhbGxiYWNrKTtcbiAgICBmb3IgKHZhciBpID0gMDsgaSA8IHRoaXMud2hlZWxzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgIHZhciB3aGVlbCA9IHRoaXMud2hlZWxzW2ldO1xuICAgICAgICB3b3JsZC5hZGRDb25zdHJhaW50KHdoZWVsKTtcbiAgICB9XG59O1xuXG4vKipcbiAqIEBtZXRob2QgcmVtb3ZlRnJvbVdvcmxkXG4gKiBAcGFyYW0ge1dvcmxkfSB3b3JsZFxuICovXG5Ub3BEb3duVmVoaWNsZS5wcm90b3R5cGUucmVtb3ZlRnJvbVdvcmxkID0gZnVuY3Rpb24oKXtcbiAgICB2YXIgd29ybGQgPSB0aGlzLndvcmxkO1xuICAgIHdvcmxkLnJlbW92ZUJvZHkodGhpcy5ncm91bmRCb2R5KTtcbiAgICB3b3JsZC5vZmYoJ3ByZVN0ZXAnLCB0aGlzLnByZVN0ZXBDYWxsYmFjayk7XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCB0aGlzLndoZWVscy5sZW5ndGg7IGkrKykge1xuICAgICAgICB2YXIgd2hlZWwgPSB0aGlzLndoZWVsc1tpXTtcbiAgICAgICAgd29ybGQucmVtb3ZlQ29uc3RyYWludCh3aGVlbCk7XG4gICAgfVxuICAgIHRoaXMud29ybGQgPSBudWxsO1xufTtcblxuLyoqXG4gKiBAbWV0aG9kIGFkZFdoZWVsXG4gKiBAcGFyYW0ge29iamVjdH0gW3doZWVsT3B0aW9uc11cbiAqIEByZXR1cm4ge1doZWVsQ29uc3RyYWludH1cbiAqL1xuVG9wRG93blZlaGljbGUucHJvdG90eXBlLmFkZFdoZWVsID0gZnVuY3Rpb24od2hlZWxPcHRpb25zKXtcbiAgICB2YXIgd2hlZWwgPSBuZXcgV2hlZWxDb25zdHJhaW50KHRoaXMsd2hlZWxPcHRpb25zKTtcbiAgICB0aGlzLndoZWVscy5wdXNoKHdoZWVsKTtcbiAgICByZXR1cm4gd2hlZWw7XG59O1xuXG4vKipcbiAqIEBtZXRob2QgdXBkYXRlXG4gKi9cblRvcERvd25WZWhpY2xlLnByb3RvdHlwZS51cGRhdGUgPSBmdW5jdGlvbigpe1xuICAgIGZvciAodmFyIGkgPSAwOyBpIDwgdGhpcy53aGVlbHMubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgdGhpcy53aGVlbHNbaV0udXBkYXRlKCk7XG4gICAgfVxufTtcblxuLyoqXG4gKiBAY2xhc3MgV2hlZWxDb25zdHJhaW50XG4gKiBAY29uc3RydWN0b3JcbiAqIEBleHRlbmRzIHtDb25zdHJhaW50fVxuICogQHBhcmFtIHtWZWhpY2xlfSB2ZWhpY2xlXG4gKiBAcGFyYW0ge29iamVjdH0gW29wdGlvbnNdXG4gKiBAcGFyYW0ge0FycmF5fSBbb3B0aW9ucy5sb2NhbEZvcndhcmRWZWN0b3JdVGhlIGxvY2FsIHdoZWVsIGZvcndhcmQgdmVjdG9yIGluIGxvY2FsIGJvZHkgc3BhY2UuIERlZmF1bHQgaXMgemVyby5cbiAqIEBwYXJhbSB7QXJyYXl9IFtvcHRpb25zLmxvY2FsUG9zaXRpb25dIFRoZSBsb2NhbCBwb3NpdGlvbiBvZiB0aGUgd2hlZW4gaW4gdGhlIGNoYXNzaXMgYm9keS4gRGVmYXVsdCBpcyB6ZXJvIC0gdGhlIGNlbnRlciBvZiB0aGUgYm9keS5cbiAqIEBwYXJhbSB7QXJyYXl9IFtvcHRpb25zLnNpZGVGcmljdGlvbj01XSBUaGUgbWF4IGZyaWN0aW9uIGZvcmNlIGluIHRoZSBzaWRld2F5cyBkaXJlY3Rpb24uXG4gKi9cbmZ1bmN0aW9uIFdoZWVsQ29uc3RyYWludCh2ZWhpY2xlLCBvcHRpb25zKXtcbiAgICBvcHRpb25zID0gb3B0aW9ucyB8fCB7fTtcblxuICAgIHRoaXMudmVoaWNsZSA9IHZlaGljbGU7XG5cbiAgICB0aGlzLmZvcndhcmRFcXVhdGlvbiA9IG5ldyBGcmljdGlvbkVxdWF0aW9uKHZlaGljbGUuY2hhc3Npc0JvZHksIHZlaGljbGUuZ3JvdW5kQm9keSk7XG5cbiAgICB0aGlzLnNpZGVFcXVhdGlvbiA9IG5ldyBGcmljdGlvbkVxdWF0aW9uKHZlaGljbGUuY2hhc3Npc0JvZHksIHZlaGljbGUuZ3JvdW5kQm9keSk7XG5cbiAgICAvKipcbiAgICAgKiBAcHJvcGVydHkge251bWJlcn0gc3RlZXJWYWx1ZVxuICAgICAqL1xuICAgIHRoaXMuc3RlZXJWYWx1ZSA9IDA7XG5cbiAgICAvKipcbiAgICAgKiBAcHJvcGVydHkge251bWJlcn0gZW5naW5lRm9yY2VcbiAgICAgKi9cbiAgICB0aGlzLmVuZ2luZUZvcmNlID0gMDtcblxuICAgIHRoaXMuc2V0U2lkZUZyaWN0aW9uKG9wdGlvbnMuc2lkZUZyaWN0aW9uICE9PSB1bmRlZmluZWQgPyBvcHRpb25zLnNpZGVGcmljdGlvbiA6IDUpO1xuXG4gICAgLyoqXG4gICAgICogQHByb3BlcnR5IHtBcnJheX0gbG9jYWxGb3J3YXJkVmVjdG9yXG4gICAgICovXG4gICAgdGhpcy5sb2NhbEZvcndhcmRWZWN0b3IgPSB2ZWMyLmZyb21WYWx1ZXMoMCwgMSk7XG4gICAgaWYob3B0aW9ucy5sb2NhbEZvcndhcmRWZWN0b3Ipe1xuICAgICAgICB2ZWMyLmNvcHkodGhpcy5sb2NhbEZvcndhcmRWZWN0b3IsIG9wdGlvbnMubG9jYWxGb3J3YXJkVmVjdG9yKTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBAcHJvcGVydHkge0FycmF5fSBsb2NhbFBvc2l0aW9uXG4gICAgICovXG4gICAgdGhpcy5sb2NhbFBvc2l0aW9uID0gdmVjMi5mcm9tVmFsdWVzKDAsIDApO1xuICAgIGlmKG9wdGlvbnMubG9jYWxQb3NpdGlvbil7XG4gICAgICAgIHZlYzIuY29weSh0aGlzLmxvY2FsUG9zaXRpb24sIG9wdGlvbnMubG9jYWxQb3NpdGlvbik7XG4gICAgfVxuXG4gICAgQ29uc3RyYWludC5hcHBseSh0aGlzLCB2ZWhpY2xlLmNoYXNzaXNCb2R5LCB2ZWhpY2xlLmdyb3VuZEJvZHkpO1xuXG4gICAgdGhpcy5lcXVhdGlvbnMucHVzaChcbiAgICAgICAgdGhpcy5mb3J3YXJkRXF1YXRpb24sXG4gICAgICAgIHRoaXMuc2lkZUVxdWF0aW9uXG4gICAgKTtcblxuICAgIHRoaXMuc2V0QnJha2VGb3JjZSgwKTtcbn1cbldoZWVsQ29uc3RyYWludC5wcm90b3R5cGUgPSBuZXcgQ29uc3RyYWludCgpO1xuXG4vKipcbiAqIEBtZXRob2Qgc2V0Rm9yd2FyZEZyaWN0aW9uXG4gKi9cbldoZWVsQ29uc3RyYWludC5wcm90b3R5cGUuc2V0QnJha2VGb3JjZSA9IGZ1bmN0aW9uKGZvcmNlKXtcbiAgICB0aGlzLmZvcndhcmRFcXVhdGlvbi5zZXRTbGlwRm9yY2UoZm9yY2UpO1xufTtcblxuLyoqXG4gKiBAbWV0aG9kIHNldFNpZGVGcmljdGlvblxuICovXG5XaGVlbENvbnN0cmFpbnQucHJvdG90eXBlLnNldFNpZGVGcmljdGlvbiA9IGZ1bmN0aW9uKGZvcmNlKXtcbiAgICB0aGlzLnNpZGVFcXVhdGlvbi5zZXRTbGlwRm9yY2UoZm9yY2UpO1xufTtcblxudmFyIHdvcmxkVmVsb2NpdHkgPSB2ZWMyLmNyZWF0ZSgpO1xudmFyIHJlbGF0aXZlUG9pbnQgPSB2ZWMyLmNyZWF0ZSgpO1xuXG4vKipcbiAqIEBtZXRob2QgZ2V0U3BlZWRcbiAqL1xuV2hlZWxDb25zdHJhaW50LnByb3RvdHlwZS5nZXRTcGVlZCA9IGZ1bmN0aW9uKCl7XG4gICAgdGhpcy52ZWhpY2xlLmNoYXNzaXNCb2R5LnZlY3RvclRvV29ybGRGcmFtZShyZWxhdGl2ZVBvaW50LCB0aGlzLmxvY2FsRm9yd2FyZFZlY3Rvcik7XG4gICAgdGhpcy52ZWhpY2xlLmNoYXNzaXNCb2R5LmdldFZlbG9jaXR5QXRQb2ludCh3b3JsZFZlbG9jaXR5LCByZWxhdGl2ZVBvaW50KTtcbiAgICByZXR1cm4gdmVjMi5kb3Qod29ybGRWZWxvY2l0eSwgcmVsYXRpdmVQb2ludCk7XG59O1xuXG52YXIgdG1wVmVjID0gdmVjMi5jcmVhdGUoKTtcblxuLyoqXG4gKiBAbWV0aG9kIHVwZGF0ZVxuICovXG5XaGVlbENvbnN0cmFpbnQucHJvdG90eXBlLnVwZGF0ZSA9IGZ1bmN0aW9uKCl7XG5cbiAgICAvLyBEaXJlY3Rpb25hbFxuICAgIHRoaXMudmVoaWNsZS5jaGFzc2lzQm9keS52ZWN0b3JUb1dvcmxkRnJhbWUodGhpcy5mb3J3YXJkRXF1YXRpb24udCwgdGhpcy5sb2NhbEZvcndhcmRWZWN0b3IpO1xuICAgIHZlYzIucm90YXRlKHRoaXMuc2lkZUVxdWF0aW9uLnQsIHRoaXMubG9jYWxGb3J3YXJkVmVjdG9yLCBNYXRoLlBJIC8gMik7XG4gICAgdGhpcy52ZWhpY2xlLmNoYXNzaXNCb2R5LnZlY3RvclRvV29ybGRGcmFtZSh0aGlzLnNpZGVFcXVhdGlvbi50LCB0aGlzLnNpZGVFcXVhdGlvbi50KTtcblxuICAgIHZlYzIucm90YXRlKHRoaXMuZm9yd2FyZEVxdWF0aW9uLnQsIHRoaXMuZm9yd2FyZEVxdWF0aW9uLnQsIHRoaXMuc3RlZXJWYWx1ZSk7XG4gICAgdmVjMi5yb3RhdGUodGhpcy5zaWRlRXF1YXRpb24udCwgdGhpcy5zaWRlRXF1YXRpb24udCwgdGhpcy5zdGVlclZhbHVlKTtcblxuICAgIC8vIEF0dGFjaG1lbnQgcG9pbnRcbiAgICB0aGlzLnZlaGljbGUuY2hhc3Npc0JvZHkudG9Xb3JsZEZyYW1lKHRoaXMuZm9yd2FyZEVxdWF0aW9uLmNvbnRhY3RQb2ludEIsIHRoaXMubG9jYWxQb3NpdGlvbik7XG4gICAgdmVjMi5jb3B5KHRoaXMuc2lkZUVxdWF0aW9uLmNvbnRhY3RQb2ludEIsIHRoaXMuZm9yd2FyZEVxdWF0aW9uLmNvbnRhY3RQb2ludEIpO1xuXG4gICAgdGhpcy52ZWhpY2xlLmNoYXNzaXNCb2R5LnZlY3RvclRvV29ybGRGcmFtZSh0aGlzLmZvcndhcmRFcXVhdGlvbi5jb250YWN0UG9pbnRBLCB0aGlzLmxvY2FsUG9zaXRpb24pO1xuICAgIHZlYzIuY29weSh0aGlzLnNpZGVFcXVhdGlvbi5jb250YWN0UG9pbnRBLCB0aGlzLmZvcndhcmRFcXVhdGlvbi5jb250YWN0UG9pbnRBKTtcblxuICAgIC8vIEFkZCBlbmdpbmUgZm9yY2VcbiAgICB2ZWMyLm5vcm1hbGl6ZSh0bXBWZWMsIHRoaXMuZm9yd2FyZEVxdWF0aW9uLnQpO1xuICAgIHZlYzIuc2NhbGUodG1wVmVjLCB0bXBWZWMsIHRoaXMuZW5naW5lRm9yY2UpO1xuXG4gICAgdGhpcy52ZWhpY2xlLmNoYXNzaXNCb2R5LmFwcGx5Rm9yY2UodG1wVmVjLCB0aGlzLmZvcndhcmRFcXVhdGlvbi5jb250YWN0UG9pbnRBKTtcbn07XG5cblxuLy8vLy8vLy8vLy8vLy8vLy8vXG4vLyBXRUJQQUNLIEZPT1RFUlxuLy8gLi9+L3AyL3NyYy9vYmplY3RzL1RvcERvd25WZWhpY2xlLmpzXG4vLyBtb2R1bGUgaWQgPSA1OFxuLy8gbW9kdWxlIGNodW5rcyA9IDAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///58\n");

/***/ }),
/* 59 */
/* no static exports found */
/* all exports used */
/*!************************!*\
  !*** ./~/p2/src/p2.js ***!
  \************************/
/***/ (function(module, exports, __webpack_require__) {

eval("// Export p2 classes\nvar p2 = module.exports = {\n    AABB :                          __webpack_require__(/*! ./collision/AABB */ 11),\n    AngleLockEquation :             __webpack_require__(/*! ./equations/AngleLockEquation */ 32),\n    Body :                          __webpack_require__(/*! ./objects/Body */ 7),\n    Broadphase :                    __webpack_require__(/*! ./collision/Broadphase */ 12),\n    Capsule :                       __webpack_require__(/*! ./shapes/Capsule */ 39),\n    Circle :                        __webpack_require__(/*! ./shapes/Circle */ 16),\n    Constraint :                    __webpack_require__(/*! ./constraints/Constraint */ 6),\n    ContactEquation :               __webpack_require__(/*! ./equations/ContactEquation */ 14),\n    ContactEquationPool :           __webpack_require__(/*! ./utils/ContactEquationPool */ 42),\n    ContactMaterial :               __webpack_require__(/*! ./material/ContactMaterial */ 35),\n    Convex :                        __webpack_require__(/*! ./shapes/Convex */ 10),\n    DistanceConstraint :            __webpack_require__(/*! ./constraints/DistanceConstraint */ 27),\n    Equation :                      __webpack_require__(/*! ./equations/Equation */ 2),\n    EventEmitter :                  __webpack_require__(/*! ./events/EventEmitter */ 15),\n    FrictionEquation :              __webpack_require__(/*! ./equations/FrictionEquation */ 9),\n    FrictionEquationPool :          __webpack_require__(/*! ./utils/FrictionEquationPool */ 43),\n    GearConstraint :                __webpack_require__(/*! ./constraints/GearConstraint */ 28),\n    GSSolver :                      __webpack_require__(/*! ./solver/GSSolver */ 41),\n    Heightfield :                   __webpack_require__(/*! ./shapes/Heightfield */ 60),\n    Line :                          __webpack_require__(/*! ./shapes/Line */ 40),\n    LockConstraint :                __webpack_require__(/*! ./constraints/LockConstraint */ 29),\n    Material :                      __webpack_require__(/*! ./material/Material */ 19),\n    Narrowphase :                   __webpack_require__(/*! ./collision/Narrowphase */ 25),\n    NaiveBroadphase :               __webpack_require__(/*! ./collision/NaiveBroadphase */ 56),\n    Particle :                      __webpack_require__(/*! ./shapes/Particle */ 21),\n    Plane :                         __webpack_require__(/*! ./shapes/Plane */ 22),\n    Pool :                          __webpack_require__(/*! ./utils/Pool */ 8),\n    RevoluteConstraint :            __webpack_require__(/*! ./constraints/RevoluteConstraint */ 31),\n    PrismaticConstraint :           __webpack_require__(/*! ./constraints/PrismaticConstraint */ 30),\n    Ray :                           __webpack_require__(/*! ./collision/Ray */ 13),\n    RaycastResult :                 __webpack_require__(/*! ./collision/RaycastResult */ 18),\n    Box :                           __webpack_require__(/*! ./shapes/Box */ 38),\n    RotationalVelocityEquation :    __webpack_require__(/*! ./equations/RotationalVelocityEquation */ 34),\n    SAPBroadphase :                 __webpack_require__(/*! ./collision/SAPBroadphase */ 26),\n    Shape :                         __webpack_require__(/*! ./shapes/Shape */ 3),\n    Solver :                        __webpack_require__(/*! ./solver/Solver */ 23),\n    Spring :                        __webpack_require__(/*! ./objects/Spring */ 20),\n    TopDownVehicle :                __webpack_require__(/*! ./objects/TopDownVehicle */ 58),\n    LinearSpring :                  __webpack_require__(/*! ./objects/LinearSpring */ 36),\n    RotationalSpring :              __webpack_require__(/*! ./objects/RotationalSpring */ 37),\n    Utils :                         __webpack_require__(/*! ./utils/Utils */ 1),\n    World :                         __webpack_require__(/*! ./world/World */ 66),\n    vec2 :                          __webpack_require__(/*! ./math/vec2 */ 0),\n    version :                       __webpack_require__(/*! ../package.json */ 24).version,\n};\n\nObject.defineProperty(p2, 'Rectangle', {\n    get: function() {\n        console.warn('The Rectangle class has been renamed to Box.');\n        return this.Box;\n    }\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///59\n");

/***/ }),
/* 60 */
/* no static exports found */
/* all exports used */
/*!****************************************!*\
  !*** ./~/p2/src/shapes/Heightfield.js ***!
  \****************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("var Shape = __webpack_require__(/*! ./Shape */ 3)\n,    vec2 = __webpack_require__(/*! ../math/vec2 */ 0)\n,    Utils = __webpack_require__(/*! ../utils/Utils */ 1);\n\nmodule.exports = Heightfield;\n\n/**\n * Heightfield shape class. Height data is given as an array. These data points are spread out evenly with a distance \"elementWidth\".\n * @class Heightfield\n * @extends Shape\n * @constructor\n * @param {object} [options] (Note that this options object will be passed on to the {{#crossLink \"Shape\"}}{{/crossLink}} constructor.)\n * @param {array} [options.heights] An array of Y values that will be used to construct the terrain.\n * @param {Number} [options.minValue] Minimum value of the data points in the data array. Will be computed automatically if not given.\n * @param {Number} [options.maxValue] Maximum value.\n * @param {Number} [options.elementWidth=0.1] World spacing between the data points in X direction.\n *\n * @example\n *     // Generate some height data (y-values).\n *     var heights = [];\n *     for(var i = 0; i < 1000; i++){\n *         var y = 0.5 * Math.cos(0.2 * i);\n *         heights.push(y);\n *     }\n *\n *     // Create the heightfield shape\n *     var heightfieldShape = new Heightfield({\n *         heights: heights,\n *         elementWidth: 1 // Distance between the data points in X direction\n *     });\n *     var heightfieldBody = new Body();\n *     heightfieldBody.addShape(heightfieldShape);\n *     world.addBody(heightfieldBody);\n *\n * @todo Should use a scale property with X and Y direction instead of just elementWidth\n */\nfunction Heightfield(options){\n    if(Array.isArray(arguments[0])){\n        options = {\n            heights: arguments[0]\n        };\n\n        if(typeof(arguments[1]) === 'object'){\n            for(var key in arguments[1]){\n                options[key] = arguments[1][key];\n            }\n        }\n\n        console.warn('The Heightfield constructor signature has changed. Please use the following format: new Heightfield({ heights: [...], ... })');\n    }\n    options = options || {};\n\n    /**\n     * An array of numbers, or height values, that are 