﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DestroyOnCollision : MonoBehaviour
{

    public GameObject effect;
    public float effectspamtime = 1.0f;

    // Use this for initialization
    void Start()
    {

    }

    // Update is called once per frame
    void Update()
    {

    }

    void OnCollisionEnter2D(Collision2D coll)
    {
        if (coll.gameObject.tag == "asteroid" || coll.gameObject.tag == "Player")
        {
            // Create the explosion effect when destroyed.
            GameObject effectobj = Instantiate(effect);
            effectobj.transform.position = this.gameObject.transform.position;

            // Destroy them after time.
            Destroy(this.gameObject);
            Destroy(effectobj, effectspamtime);

            GameObject target = GameObject.FindWithTag("Player");
            if(target)  
                target.GetComponent<PlayerHealth>().points += 1;
        }
    }

}
