#version 440
layout (triangles) in;
layout (line_strip, max_vertices = 6) out;

in VS_OUT {
    vec3 normal;
	vec3 tangent;
	vec3 bitangent;
} gs_in[];

const float MAGNITUDE = 0.4;

void GenerateLine(int index)
{
    gl_Position = gl_in[index].gl_Position;
    EmitVertex();
    gl_Position = gl_in[index].gl_Position + vec4(gs_in[index].normal, 0.0) * MAGNITUDE;
    EmitVertex();
    EndPrimitive();
}

void GenerateTangent(int index)
{
	gl_Position = gl_in[index].gl_Position;
    EmitVertex();
    gl_Position = gl_in[index].gl_Position + vec4(gs_in[index].tangent, 0.0) * MAGNITUDE;
    EmitVertex();
    EndPrimitive();
}

void GenerateBiTangent(int index)
{
	gl_Position = gl_in[index].gl_Position;
    EmitVertex();
    gl_Position = gl_in[index].gl_Position + vec4(gs_in[index].bitangent, 0.0) * MAGNITUDE;
    EmitVertex();
    EndPrimitive();
}

void main()
{
  GenerateLine(0); // first vertex normal
  GenerateLine(1); // second vertex normal
  GenerateLine(2); // third vertex normal

 // GenerateTangent(0); // first vertex normal
 // GenerateTangent(1); // second vertex normal
 // GenerateTangent(2); // third vertex normal
 //
 // GenerateBiTangent(0); // first vertex normal
 // GenerateBiTangent(1); // second vertex normal
 // GenerateBiTangent(2); // third vertex normal
}  