function searchTheInternetForHorses(retryCount) {
	if(retryCount === undefined) retryCount = 5;

	return fetch("https://api.cognitive.microsoft.com/bing/v5.0/images/search/?count=70&offset=0&q=horse", {
		headers: {
			"Ocp-Apim-Subscription-Key": "27f579a3d7d7457c9a108affb6a4b55e"
		}
	})
	.then(function(response) { return response.json(); })
	.then(result => result.value.map(x => x.thumbnailUrl))
	.then(loadImages)
	.catch(function() {
		if(retryCount > 0)
			return searchTheInternetForHorses(retryCount - 1);

		var fallbackImage = new Image();
		fallbackImage.src = "https://cdn.pixabay.com/photo/2015/11/02/18/37/horse-1018835_960_720.jpg";
		return [ fallbackImage ];
	})
}

function loadImages(urls) {
	return new Promise(function(resolve) {
		var numLoaded = 0;
		var outputImages = [];
		for(var i in urls) {
			let image = new Image();
			image.src = urls[i];
			image.onload = image.onerror = function() {
				numLoaded++;
				outputImages.push(image);

				if(numLoaded >= urls.length)
					resolve(outputImages);
			}
		}
	});
}


var canvas, ctx;
var horseImages;
var rainbow;
var music;

const $ = document.querySelector.bind(document);

window.addEventListener("load", init);
window.addEventListener("resize", resize);

function init() {
	canvas = $("#c")
	ctx = canvas.getContext("2d");
	music = $("#music");
	resize();
	searchTheInternetForHorses().then(function(horses) {
		horseImages = horses;

		requestAnimationFrame(frame);
		music.play();
	});
}

function resize() {
	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;
}

function frame(timeMs) {
	requestAnimationFrame(frame);
	draw();
}

function cos1(v) {
	return Math.cos(v * 2 * Math.PI);
}

var rainbowColors = [
	"#f00",
	"#ff0",
	"#0f0",
	"#0ff",
	"#00f",
	"#f0f"
]

function createRainbow(ctx, x, width) {
	let rainbow = ctx.createLinearGradient(x, 0, x + width, 100);
	for(var i in rainbowColors) {
		var offset = i / (rainbowColors.length-1);
		rainbow.addColorStop(offset, rainbowColors[i]);
	}
	return rainbow;
}

var messages = [
	"HELLO DEMOBIT",
	"THIS IS NOT A COMPOFILLER",
	"IS VERY SERIOUS",
	"READY... SET...",
	"HORSE",
	"GREETINGS TO HORSE",
	"FUCKINGS TO EVERYONE ELSE",
	"NOTEPAD IS BETTER THAN EMACS",
	"BOOBS",
	"I CAN'T THINK OF ANYTHING MORE TO PUT HERE",
	"WHY THE FUCK ARE YOU STILL WATCHING THIS",
	"TURN THIS SHIT OFF IMMEDIATELY",
	"OR I WILL START DESTROYING AMIGAS",
	"HEH NOT REALLY THO",
	"TO ANYONE WHO SURVIVED THIS, CONGRATULATIONS",
	"THERE WILL BE NO PRIZE",
	"THERE WILL BE NO HORSE",
	"OKAY I'M DONE",
];


const bpm = 160;
const beatDuration = 60 / bpm;

function randomElem(array) {
	return array[Math.floor(Math.random() * array.length)];
}

/// ENOUGH BOOTSTRAPPING LETS DO COOL SHIT

function draw() {
	var t = music.currentTime;

	var w = canvas.width;
	var h = canvas.height;

	ctx.clearRect(0,0,w,h);

	if(t > (beatDuration * 4 * 16)) {

		ctx.fillStyle = createRainbow(ctx, w, -w);
		ctx.fillRect(0,0,w,h);


		ctx.save();
		ctx.rotate(cos1(t/beatDuration) * 0.2);
		var horseImage = horseImages[Math.floor(t/beatDuration) % horseImages.length];
		ctx.drawImage(horseImage, 0,0, w, h);
		ctx.restore();
	}

	if((t % beatDuration) < (beatDuration/2)) {
		var messageIndex = Math.floor(t / beatDuration / 16);
		var message = (messageIndex >= messages.length) ? "NOT A DEMO BY SEBBERT" : messages[messageIndex];

		ctx.font = '50pt "Comic Sans MS", "Comic Sans", "Papyrus"';
		var messageWidth = ctx.measureText(message).width;
		var messageX = Math.max(0, (w/2) - (messageWidth / 2));
		var messageY = h / 2;
		ctx.fillStyle = createRainbow(ctx, messageX, messageWidth);


		ctx.strokeStyle = "#000";
		ctx.lineWidth = 8;
		ctx.strokeText(message, messageX, messageY, w);

		ctx.strokeStyle = "#fff";
		ctx.lineWidth = 4;
		ctx.strokeText(message, messageX, messageY, w);
		ctx.fillText(message, messageX, messageY, w);
	}


}