// Pixels On The Line
// A simple slideshow 
// All images by Exocet
// Music by Exocet, original melody (butchered beyond recognition) and help from Glafouk 
// Nov-Dec 2017, final version Jan 2018

#include <SPI.h>
#include <Gamebuino.h>
Gamebuino gb;

int easing[16] = {8, 6, 5, 4, 4, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1};
int i = -1;
int y = -48;

//Instruments
const unsigned int bip[] PROGMEM = {0x002,0xB4AF,0x2BF7};
const uint16_t* const instrumentSet[] PROGMEM = {bip};

//Patterns
const unsigned int p1[] PROGMEM = {0x810,0x800,0x208,0x408,0x210,0x404,0x400,0x810,0x800,0x224,0x424,0x200,0x410,0x424,0x810,0x800,0x208,0x408,0x210,0x404,0x400,0x810,0x800,0x224,0x424,0x200,0x410,0x424,0x000 };
const unsigned int p2[] PROGMEM = {0x45C,0x25C,0x25C,0x468,0x470,0x478,0x27C,0x478,0x268,0x270,0x254,0x45C,0x25C,0x25C,0x468,0x470,0x468,0x270,0x468,0x154,0x154,0x168,0x168,0x15C,0x170,0x45C,0x25C,0x25C,0x468,0x470,0x478,0x27C,0x478,0x268,0x270,0x254,0x45C,0x25C,0x25C,0x438,0x440,0x438,0x240,0x438,0x154,0x154,0x168,0x168,0x15C,0x170,0x000 };
const unsigned int p3[] PROGMEM = {0x1BC,0x1BC,0x2A8,0x2B4,0x298,0x4A8,0x1A8,0x1AC,0x1A8,0x198,0x2A8,0x298,0x2AC,0x28C,0x4A8,0x498,0x1BC,0x1BC,0x2A8,0x2B4,0x2A0,0x4B4,0x1A8,0x1B4,0x1A8,0x1B4,0x2BC,0x2A0,0x2A8,0x1B4,0x2A8,0x1B4,0x2BC,0x18C,0x198,0x2A0,0x1BC,0x1BC,0x2A8,0x2B4,0x298,0x4A8,0x1A8,0x1AC,0x1A8,0x198,0x2A8,0x298,0x2AC,0x28C,0x4A8,0x498,0x1BC,0x1BC,0x2A8,0x2B4,0x2A0,0x4B4,0x1A8,0x1B4,0x1A8,0x1B4,0x2BC,0x2A0,0x2A8,0x1B4,0x2A8,0x1B4,0x2BC,0x18C,0x198,0x2A0,0x000 };
const unsigned int p4[] PROGMEM = {0x810,0x800,0x208,0x408,0x210,0x404,0x400,0x810,0x800,0x224,0x424,0x200,0x410,0x424,0x810,0x800,0x208,0x408,0x210,0x404,0x400,0x810,0x800,0x224,0x424,0x200,0x410,0x424,0x000 };
const unsigned int p5[] PROGMEM = {0x17C,0x7DFC,0x268,0x000 };
const uint16_t* const patternSet[] PROGMEM = {p1,p2,p3,p4,p5};

//Tracks
const unsigned int track0[] PROGMEM = {0x000,0x000,0x000,0x000,0x000,0x000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF };
const unsigned int track1[] PROGMEM = {0x004,0x001,0x003,0x001,0x003,0xFFFFFFFF,0x001,0xFFFFFFFF,0xFFFFFFFF,0xFFFF };
const unsigned int track2[] PROGMEM = {0x004,0xFFFFFFFF,0x002,0x002,0x002,0x002,0x002,0x002,0x002,0xFFFF };
const unsigned int track3[] PROGMEM = {0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF };

//Images
const byte img1[] PROGMEM = {88,48,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11000000,B00001100,B00000000,B00000000,B00000110,B00000000,B00000000,B00000011,B11110000,
B11111111,B11111111,B11000000,B00001100,B00000000,B00000000,B00000110,B00000000,B00000000,B00000011,B11110000,
B11111111,B11111111,B11000000,B00001100,B00000000,B00000000,B00000110,B00000000,B00000000,B00000011,B11110000,
B11111111,B11111111,B11000000,B00001100,B00000000,B00000000,B00000110,B00000000,B00000000,B00000011,B11110000,
B11111111,B11111111,B10000000,B00001000,B00000001,B11111111,B11111100,B00000000,B11111111,B11111111,B11110000,
B11111111,B11111111,B10000000,B00001000,B00000001,B11111111,B11111100,B00000000,B11111111,B11111111,B11110000,
B11111111,B11111111,B10010001,B00011001,B00010000,B00000001,B11111100,B01000100,B00000000,B11111111,B11110000,
B11111000,B00000001,B10000000,B00011000,B00000000,B00000001,B11111100,B00000000,B00000000,B11111111,B11110000,
B11111010,B10101001,B10101010,B10011010,B10101010,B10101001,B11111100,B10101010,B10101010,B11111111,B11110000,
B11110000,B00000001,B10000000,B00010000,B00000000,B00000001,B11111000,B00000000,B00000000,B11111111,B11110000,
B11110010,B10101001,B00101010,B10010010,B10101001,B11111111,B11111010,B10101000,B11111111,B11111111,B11110000,
B11110101,B01010000,B01010101,B00110101,B01010011,B11111111,B11111001,B01010101,B11111111,B11111111,B11110000,
B11110111,B10111011,B10111011,B10110110,B11101011,B11111111,B11111010,B11101101,B11111111,B00111111,B11110000,
B11110011,B11111111,B11111111,B00110111,B11111011,B11111111,B11111011,B11111101,B11111110,B00111111,B11110000,
B11111000,B00000000,B00000000,B01110000,B00000011,B11111111,B11111000,B00000001,B11111110,B00111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111000,B00011111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B00000000,B00000000,B11110000,
B11111111,B11111111,B11111111,B11110111,B01110110,B11010101,B00100100,B00000001,B00000110,B01100000,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11000110,B01100011,B11110000,
B11111111,B11111111,B11101101,B11011011,B01010100,B10010001,B00000000,B00000000,B01100000,B00000111,B11110000,
B11101111,B01101101,B01010100,B10000000,B00000000,B00000000,B00000000,B00000000,B00100000,B00001111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11100000,B00000111,B11110000,
B11111111,B11111111,B01111011,B10110110,B11010101,B01001001,B00100000,B00000000,B01000011,B10000111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11000111,B11000111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111110,B10101100,B10001110,B00100100,B11110001,B01010011,B11001110,B01010001,B11111111,B11110000,
B11111111,B11111110,B10101011,B11011110,B11010101,B01110111,B01010101,B11110101,B01011101,B11111111,B11110000,
B11111111,B11111010,B10101000,B11011110,B01010101,B11110011,B01010101,B11101101,B01011011,B11111111,B11110000,
B11111111,B11111010,B10101110,B11011110,B11010101,B11110111,B01010101,B11011101,B01011011,B11111111,B11110000,
B11111111,B11111100,B11001001,B11011110,B11001101,B11110111,B10010101,B11000100,B11011011,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
};

const byte img2[] PROGMEM = {88,48,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B01000100,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000101,B00010000,B10000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00101010,B10101010,B10101010,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000001,B01010101,B01010101,B01010100,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000010,B10101010,B10101010,B10101010,B10101000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000101,B01010101,B01010101,B01010101,B00100000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00101010,B10101010,B10101010,B10101010,B10101010,B10000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00010101,B01011111,B11111111,B01010101,B01010000,B00000000,B00000000,B00000000,
B00000000,B00000000,B10101010,B10101010,B11101010,B10101010,B11111010,B10100000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B01010111,B01000100,B01001000,B00010111,B01010010,B00000000,B00000000,B00000000,
B00000000,B00000010,B10101010,B10101110,B00101010,B10101010,B00001011,B10101000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000001,B01010010,B01010101,B01010101,B01010010,B01010101,B00000000,B00000000,B00000000,
B00000000,B00001010,B10101010,B10100010,B10111111,B11111010,B10101100,B10111010,B10010000,B00000000,B00000000,
B00000000,B00000000,B00000101,B01000001,B01011111,B11111101,B11011101,B00011111,B00100000,B00000000,B00000000,
B00000000,B00001010,B10101010,B10000011,B11111111,B11111111,B11111110,B10101110,B10100010,B00000000,B00000000,
B00000000,B00000000,B00000101,B00000101,B11111111,B11111111,B11111101,B11000111,B11000010,B00000000,B00000000,
B00000000,B00000010,B10101010,B01001111,B11111111,B11111111,B11111111,B11101011,B10100100,B00100000,B00000000,
B00000000,B00000000,B00010100,B00010111,B11110101,B00010101,B01111111,B11110111,B11001000,B00100000,B00000000,
B00000000,B00001010,B10101101,B00111111,B11100000,B10101011,B11101011,B11111110,B10010000,B01000100,B00000000,
B00000000,B00000000,B01011000,B01011111,B11000000,B01000101,B01110101,B01111101,B01100000,B10000100,B00000000,
B00000000,B00000010,B10111010,B11111011,B11100000,B11101010,B11101010,B10111111,B11100011,B00001000,B00000000,
B00000000,B00000000,B01010001,B11010111,B01000000,B11110000,B01110101,B01011111,B01001100,B00010000,B00000000,
B00000000,B00001010,B10101011,B10101111,B10100001,B11111010,B11111010,B10101111,B11111000,B00100000,B00000000,
B00000000,B00000001,B01000111,B01000111,B01010111,B11110101,B01110000,B00010111,B11010000,B11000000,B00000000,
B00000000,B00000010,B11101110,B10000111,B10101111,B11111010,B11110000,B00101011,B11101111,B00000000,B00000000,
B00000000,B00000001,B10001101,B00000111,B00000111,B11110001,B01110000,B00000101,B11111100,B00000000,B00000000,
B00000000,B00001010,B10111010,B10000011,B10101011,B11101011,B11100000,B00101011,B10100000,B00000000,B00000000,
B00000000,B00000001,B00110100,B00000011,B01010001,B01000101,B01100000,B00000111,B01000000,B00000000,B00000000,
B00000000,B00000011,B10101010,B10000001,B11101010,B10101111,B11000000,B00101110,B10100000,B00000000,B00000000,
B00000000,B00000000,B01010100,B00000001,B11000000,B01010101,B11000000,B00001101,B00000000,B00000000,B00000000,
B00000000,B00001010,B10101010,B10000000,B11111010,B10111111,B10000000,B10111010,B10000000,B00000000,B00000000,
B00000000,B00000000,B11010101,B00000000,B01110101,B01010111,B00000000,B01110000,B00000000,B00000000,B00000000,
B00000000,B00001001,B11101010,B10100000,B00111111,B11111110,B00000000,B11101010,B00000000,B00000000,B00000000,
B00000000,B00000001,B11111111,B10000000,B00001111,B11111000,B00000011,B10000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00001111,B11111101,B00000011,B11100000,B00101110,B10101000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000001,B01111111,B11110100,B00000101,B11110000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00001011,B11111111,B11111111,B11101010,B10000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00101111,B11111110,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00001010,B10101010,B10101000,B10000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000101,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00101010,B00001010,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000001,B01010000,B00000000,B00000000,B00000000,B01100000,
B00000000,B00000000,B00000000,B00000000,B00000010,B10101010,B10100000,B00000000,B00000000,B00000000,B10100000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00010101,B00000000,B00000000,B00000000,B00000000,B11100000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B10000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B01100000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
};

const byte img3[] PROGMEM = {88,48,
B00000000,B00000000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000011,B00110000,B00000001,B11000000,
B00000000,B00000000,B00110000,B01100000,B00000000,B00000000,B00000000,B11000001,B11100000,B00000011,B10000000,
B00000000,B00000000,B00110000,B01100000,B00000000,B00000000,B00000000,B11000000,B11000000,B00000111,B00000000,
B00000000,B00000000,B00110000,B00110000,B00000000,B01000000,B00000001,B10000000,B00000000,B00001110,B00000000,
B00000000,B00000000,B00110000,B00011000,B00000010,B11101000,B00000011,B00000000,B00000000,B00011100,B00000000,
B00000000,B00000000,B01111000,B00001100,B00000001,B11110000,B00000110,B00000000,B11000000,B00111000,B00000000,
B00000000,B00000000,B11001100,B00000110,B00001111,B01011110,B00001100,B00000001,B11100000,B01110000,B00000000,
B11111111,B11100000,B11001100,B00000010,B00011011,B10110111,B00001000,B00000011,B00111111,B11100000,B00010000,
B11111111,B11110000,B01111000,B00000010,B00110101,B10101011,B10001000,B00000011,B00111111,B11000000,B00110000,
B00000000,B00111000,B00110000,B00000010,B00101011,B10110111,B10101000,B00000001,B11100000,B00000000,B01110000,
B00000000,B00011100,B00000000,B00000010,B00110111,B11111111,B10001000,B00000000,B11000000,B00000000,B11100000,
B00000000,B00001110,B00000000,B00000011,B00111111,B11011111,B11011000,B00000000,B00000000,B00000001,B11000000,
B00001100,B00000111,B00110000,B00000001,B10011111,B11101111,B00110000,B00000000,B00000000,B00000011,B10000000,
B00011110,B00000011,B11111000,B00000000,B11001110,B10111110,B01100000,B00000000,B11000000,B00000111,B00000000,
B00110011,B00000001,B11001100,B00000000,B01111110,B01101111,B11000000,B00000001,B11100000,B00001110,B00000000,
B00110011,B00000000,B11001100,B00000000,B00111010,B10111111,B10000000,B00000011,B00111111,B11111100,B00000000,
B00011110,B00000000,B01111000,B00000000,B00011111,B00101111,B01000000,B00000011,B00111111,B11111000,B00000000,
B00001100,B00000000,B00110000,B00000000,B00011010,B11011110,B10000000,B00000001,B11100000,B00000000,B00000000,
B00001100,B00000000,B00000000,B00000000,B11111110,B10101111,B11100000,B00000000,B11000000,B00000000,B00000000,
B00001100,B00000000,B00000000,B00000111,B10110111,B11111101,B11111100,B00000000,B00000000,B00000000,B00000000,
B00001100,B00000000,B00000000,B00111100,B01001011,B10111000,B01000111,B10000000,B00000000,B00000011,B00000000,
B00001100,B00000001,B11111111,B11100000,B11010101,B11110010,B00100000,B11111111,B11110000,B00000111,B10000000,
B00001100,B00000001,B10000000,B00000001,B00111010,B11100101,B00010000,B00000000,B00110000,B00001100,B11000000,
B00001100,B00000000,B00000000,B00000010,B00101100,B11101011,B10101000,B00000000,B00000000,B00001100,B11000000,
B00001110,B00000000,B00000000,B00000100,B01111001,B10110011,B11010100,B00000000,B00000000,B00000111,B10000000,
B00000111,B00000011,B00000000,B00001000,B10110101,B10110101,B10001010,B00000000,B00000000,B00000011,B00000000,
B00000011,B10000111,B10000000,B00010001,B00011001,B11110111,B00010001,B00000000,B00000000,B00000011,B00000000,
B00000001,B11111100,B11000000,B00100000,B00111100,B10100101,B10101000,B10000000,B00000000,B00000011,B00000000,
B00000000,B11111100,B11000000,B01000100,B01111010,B11101011,B11010000,B01000000,B00000000,B00000011,B00000000,
B00000000,B00000111,B10000000,B10001000,B10110100,B11100111,B10100010,B00100000,B00000000,B00000011,B00000000,
B00000000,B00000011,B00000001,B00010001,B00011010,B10100011,B01010001,B00010000,B00000000,B00000011,B00000000,
B00000000,B00000000,B00000010,B00000010,B01111100,B11110111,B10100000,B10001000,B00000000,B00000011,B00000000,
B00000000,B00000000,B00000100,B01000000,B11011001,B10110011,B01010100,B01000100,B00000000,B00000111,B00000000,
B00000000,B00000011,B00000100,B10001001,B10010011,B11111001,B00100010,B00000100,B00001100,B00001110,B00000000,
B00000000,B00000111,B10001000,B00010011,B00011110,B01011110,B00010001,B00010010,B00011110,B00011100,B00000000,
B11111111,B11111100,B11001010,B00000000,B01111000,B11111111,B11000000,B00001010,B00110011,B11111000,B00000000,
B11111111,B11111100,B11001000,B01000011,B10000111,B01111110,B10111000,B01000010,B00110011,B11110000,B00000000,
B00000000,B00000111,B10001011,B10000110,B00000011,B11111000,B00001100,B00111010,B00011110,B00000000,B00000000,
B00000000,B00000011,B00001000,B00011001,B00000000,B11101010,B10010011,B00000010,B00001100,B00000000,B00000000,
B00000000,B00000000,B00001000,B01100001,B10000000,B00000000,B00110000,B11000010,B00000000,B00000000,B00000000,
B00001100,B00000000,B00000111,B10000000,B10000000,B00101010,B00100000,B00111100,B00000000,B00000000,B00000000,
B00011110,B00000000,B00000000,B00000000,B10000000,B00000000,B00100000,B00000000,B00001100,B00000000,B00000000,
B00110011,B11111100,B00000000,B00000001,B10000000,B00000000,B00110000,B00000000,B00011110,B00000000,B01100000,
B00110011,B11111110,B00000000,B00000011,B00000000,B00000000,B00011000,B00000000,B00110011,B11110000,B10100000,
B00011110,B00000111,B00000000,B00000110,B00000000,B00000000,B00001100,B00000000,B00110011,B11111000,B11100000,
B00001100,B00000011,B10000000,B00001100,B00000000,B00000000,B00000110,B00000000,B00011110,B00011100,B10000000,
B00000000,B00000001,B11000000,B00011000,B00000000,B00000000,B00000011,B00000000,B00001100,B00001110,B01100000,
B00000000,B00000000,B11100000,B00011000,B00000000,B00000000,B00000011,B00000000,B00000000,B00000111,B00000000,
};

const byte img4[] PROGMEM = {88,48,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B10000000,B00000000,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111100,B00101011,B10111010,B00011111,B11111111,B10111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11110001,B01010101,B01110101,B01000111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11001010,B10101110,B10101110,B11110001,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B10011101,B01011111,B11010101,B01010100,B11111111,B11111111,B11111111,B11111111,B10110000,
B11111110,B11111111,B00111010,B10101010,B10101010,B10111110,B01111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111100,B00010001,B00010000,B00010101,B01010101,B00011111,B11111111,B11110111,B11111111,B11110000,
B11111111,B11111010,B10101010,B10101010,B00101010,B11101111,B11001111,B11011111,B11111111,B11101111,B11110000,
B11111111,B11110101,B01000100,B01000100,B01110001,B01010101,B01100111,B11111111,B11111111,B11000111,B11110000,
B11111111,B11110010,B10101010,B10101010,B10101010,B10111011,B11110111,B11111111,B11111111,B11101111,B11110000,
B11101111,B11100001,B00000000,B00000000,B00010001,B01010101,B01010011,B11111111,B11111111,B11111110,B11110000,
B11111111,B11001010,B00101010,B10101010,B00001010,B00101111,B10111001,B11111111,B11111111,B11111111,B11110000,
B11111111,B10000100,B01000000,B00000000,B01000100,B01010101,B01011100,B11111111,B11111111,B11111111,B11110000,
B11111111,B10101000,B10100010,B00100010,B10001010,B10001011,B11111110,B11111111,B01111111,B11111111,B11110000,
B11111111,B01010000,B00000000,B00000000,B00000001,B01010101,B11010110,B01111111,B11111111,B11111111,B11110000,
B11111111,B00100010,B10101000,B10001010,B10101010,B11101111,B11111111,B01111111,B11111111,B01111111,B01110000,
B11111110,B01000100,B00000000,B00000000,B00000100,B01010101,B11011111,B00111111,B11111111,B11111111,B11110000,
B11111110,B10001000,B10100010,B00000000,B10101010,B00001011,B11111111,B10111111,B11111111,B11111111,B11110000,
B11111110,B01010000,B00000000,B00000000,B00000001,B00010101,B01010111,B10111111,B11111111,B11111111,B11110000,
B11111100,B11101010,B00101000,B10000010,B10101000,B10101111,B11111101,B10011111,B11111111,B11111111,B11110000,
B11111101,B01010100,B00000000,B00000000,B01010101,B00010111,B01011111,B11011111,B11111111,B11111111,B11110000,
B11111100,B10101010,B00100000,B00100010,B10101010,B10001011,B11111101,B11011111,B11111111,B11111111,B11110000,
B11111101,B01010001,B00000000,B00000000,B00010111,B01000101,B01011110,B11011111,B11111111,B11111111,B11110000,
B11111100,B11101010,B00001000,B10101010,B10111110,B10100111,B11111101,B11011111,B11111111,B11111111,B11110000,
B11111101,B01010100,B00000000,B00000000,B01011111,B01010101,B11111110,B11011111,B11111111,B11111111,B11110000,
B11111101,B10101010,B10100010,B10101010,B11101010,B10111011,B11111101,B11011111,B11110111,B11111111,B11110000,
B11111101,B01010111,B00000000,B00000000,B01011100,B01010101,B01010111,B11011111,B11111111,B11111111,B11110000,
B11111100,B11101110,B10101010,B10101010,B10101000,B11101111,B11111101,B11011111,B11111111,B11111111,B11110000,
B11111101,B01011111,B01000100,B01000100,B01010001,B01010101,B11011111,B11011111,B11111111,B11111111,B11110000,
B11111101,B10101010,B10101010,B10101010,B10101010,B10111111,B11111111,B11011111,B11111111,B11111111,B11110000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B11101010,B11110101,B01111010,B10111100,B10100110,B11011011,B00101001,B11101010,B11110101,B01111010,B10110000,
B01010100,B00001010,B10000101,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B10000011,B11110000,B01111100,B00111110,B01111011,B11011110,B11110011,B11100001,B11110000,B01111110,B00000000,
B01111110,B00001111,B11000011,B11111001,B11110111,B11011111,B01111100,B11111110,B00011111,B10000011,B11110000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00111111,B11000011,B11111111,B10011111,B11011111,B11011111,B11011111,B11001111,B11111110,B00011111,B11100000,
B11111100,B00111111,B11111110,B01111111,B10111111,B11011111,B11101111,B11110011,B11111111,B11100001,B11110000,
B10000011,B11111111,B11111001,B11111111,B01111111,B11011111,B11110111,B11111100,B11111111,B11111110,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B11111111,B11111111,B10011111,B11111101,B11111111,B11011111,B11111101,B11111111,B11001111,B11111111,B11110000,
B11111111,B11111110,B01111111,B11111011,B11111111,B11011111,B11111110,B11111111,B11110011,B11111111,B11110000,
B11111111,B11111001,B11111111,B11110111,B11111111,B11011111,B11111111,B01111111,B11111100,B11111111,B11110000,
B11111111,B11100111,B11111111,B11101111,B11111111,B11011111,B11111111,B10111111,B11111111,B00111111,B11110000,
B11111111,B10011111,B11111111,B11011111,B11111111,B11011111,B11111111,B11011111,B11111111,B11001111,B11110000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B11111101,B11111111,B11111111,B01111111,B11111111,B11011111,B11111111,B11110111,B11111111,B11111101,B11110000,
};

const byte img5[] PROGMEM = {88,48,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B00000000,B11100101,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111010,B10101010,B10111111,B11111110,B00000111,B10001011,B11011111,B11111111,B11110000,
B11111111,B11111111,B01010101,B01010101,B01010101,B01010110,B00111111,B11111111,B10111111,B11111111,B11110000,
B11111111,B11111110,B10101010,B10101010,B10101010,B10101000,B00001110,B00000001,B11111111,B10111111,B11110000,
B11111111,B11110101,B01010101,B01010101,B01010101,B01010000,B00111000,B00000000,B00111111,B11010101,B11110000,
B11111111,B10101010,B10101010,B10101010,B10101010,B10100100,B11100000,B00000011,B10011111,B10101010,B10110000,
B11111111,B01010101,B01111111,B11010101,B01010101,B01001011,B10000000,B00001111,B11111111,B11010101,B01010000,
B11111110,B10101011,B11111110,B10101010,B10101010,B10010110,B00000011,B11111111,B11111111,B10101010,B10100000,
B11111101,B01011111,B11010101,B01010101,B01010101,B01011000,B00011111,B00000000,B11111111,B11010101,B01010000,
B11111010,B11111110,B10101010,B10101010,B10101010,B10010000,B01110000,B00000011,B11111111,B11101010,B10100000,
B11111101,B11111101,B01010101,B01010101,B11110101,B01000001,B11000000,B00011111,B11111111,B11010101,B01010000,
B11111111,B11111010,B10101010,B10101010,B11111110,B10000011,B00000001,B11111111,B11111111,B11101010,B10100000,
B11111111,B11010101,B01010111,B01010101,B01011111,B00000100,B00001111,B11111111,B11111111,B11010101,B01010000,
B11111111,B10101010,B10101111,B10101010,B10101111,B10001000,B00111110,B00000111,B11111111,B11101010,B10100000,
B11111111,B11010101,B01011100,B11010101,B01011111,B00000000,B11110000,B00000111,B11111111,B11110101,B01010000,
B11111111,B10101010,B10111111,B11101010,B10111110,B10000011,B11000000,B00000111,B11111111,B11111010,B10100000,
B11111111,B11010101,B01111111,B11110101,B01110101,B00000111,B10000000,B00001111,B11111111,B11110101,B01010000,
B11111111,B11101010,B11111111,B11111010,B10101010,B10001111,B00000000,B00011111,B11111111,B11111010,B10100000,
B01011111,B11110101,B11010001,B00101101,B01010101,B00001110,B01111111,B11111111,B11111111,B11110101,B01010000,
B10101011,B11111011,B11111111,B11111110,B10101010,B11111110,B11001111,B11111111,B11111111,B11111010,B10100000,
B01010101,B01010111,B11111111,B11111111,B01010101,B01111110,B00011111,B11111111,B11111111,B11110101,B01010000,
B10101010,B10101111,B11111111,B11111111,B10101010,B01001110,B00111111,B11011111,B11111111,B11111010,B10100000,
B01000100,B01011101,B00001010,B11000101,B11010100,B11011110,B01111111,B10011111,B11111111,B11110101,B01010000,
B10101010,B10111111,B11111111,B11111111,B11101001,B11011110,B01111111,B10011111,B11111111,B11101000,B10000000,
B00010001,B01111111,B11111111,B11111111,B11110101,B11001100,B00111111,B00011111,B11111111,B11110101,B01010000,
B01000100,B01111111,B11111111,B11111111,B11111101,B01101100,B00000000,B00001100,B00011111,B11100010,B00100000,
B00000000,B11100000,B10101100,B01010100,B00011101,B01101100,B00000000,B00001110,B00111111,B11001000,B10000000,
B00010001,B11111111,B11111111,B11111111,B11111110,B01110100,B00000000,B00011111,B11111111,B11000000,B00000000,
B00000011,B11111111,B11111111,B11111111,B11111110,B01111100,B00000000,B11111111,B11111111,B11000010,B00100000,
B00000111,B11111111,B11111111,B11111111,B11111111,B00111100,B00000000,B01111111,B11111111,B11000000,B00000000,
B11001110,B00100010,B10001001,B00001100,B01101011,B00111100,B00000000,B00111111,B11111111,B11000000,B00000000,
B11111111,B11111111,B11111111,B11111111,B11111111,B00101110,B00000000,B11111111,B11111111,B11000000,B00000000,
B11111111,B11111111,B11111111,B11111111,B11111111,B00101110,B00000011,B11111111,B11111111,B11100001,B01110000,
B11111111,B11111111,B11111111,B11111111,B11111110,B00100111,B00000111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111101,B01010101,B01111110,B00100111,B00000000,B00000111,B11111111,B11111111,B11110000,
B11111111,B11111110,B11101110,B11111111,B11111110,B00000111,B10000000,B00001111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111110,B00000111,B11000000,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111100,B00001111,B11100000,B01111111,B11111111,B11111111,B11110000,
B01010101,B01010101,B01010111,B11111111,B01010100,B00001101,B11110000,B00000111,B11111111,B11111111,B11110000,
B11101110,B11111111,B11111111,B11101110,B11101101,B00001101,B11111000,B00001111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B01010101,B01111001,B00001001,B11011110,B00111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111011,B10111011,B11111011,B00011011,B11001111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111101,B01010101,B01010111,B11110110,B00111011,B11000111,B11111111,B11111111,B11111111,B10010000,
B11111110,B11101110,B11101110,B11111111,B11110110,B01110011,B11000011,B11111111,B11111111,B11111111,B01010000,
B11111111,B11111111,B11111111,B11111111,B11101110,B01110111,B10000000,B11111111,B11111111,B11111111,B00010000,
B11111111,B11111111,B11111111,B11111111,B11101100,B11100111,B10000000,B11111111,B11111111,B11111111,B01110000,
B01010101,B01010101,B11111111,B11111111,B11011100,B11101111,B00000001,B11111111,B11111111,B11111111,B10010000,
B11101110,B11101110,B11101111,B11111111,B11011101,B11101110,B00000001,B11111111,B11111111,B11111111,B11110000,
};


const byte img6[] PROGMEM = {88,48,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111111,B11111111,B10111111,B11111111,B11111101,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111101,B11111111,B10111111,B11111111,B11111101,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111101,B11111111,B10111111,B11111111,B11111101,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111101,B11111111,B10110111,B11111111,B11111101,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111101,B11111110,B10110111,B11111111,B11111101,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111111,B11111101,B11111110,B10010111,B11111111,B11111101,B10111111,B11111111,B11110000,
B11111111,B11111101,B11111111,B11111101,B11111110,B10010101,B11111101,B11111101,B00111111,B11111111,B11110000,
B11111111,B11111101,B11111111,B11111111,B11111111,B11110111,B11111111,B11111100,B00111101,B11111111,B11110000,
B11111111,B11111101,B11111111,B11110000,B01111100,B00000001,B11111101,B11111100,B00111101,B11111111,B11110000,
B11111111,B11111101,B11111111,B11110000,B01111101,B01010001,B11111101,B11111000,B00111101,B11111111,B11110000,
B11011111,B11111101,B10111111,B11111111,B11111100,B00000001,B11111101,B11110000,B00111101,B11111111,B11110000,
B11111111,B11111101,B10111111,B11000100,B01111100,B00000001,B11111101,B11110000,B00111101,B11111111,B11110000,
B11011111,B11111101,B10111111,B11111100,B01111111,B11111111,B11111101,B11110000,B00111101,B11111111,B11110000,
B11011111,B11111111,B11111111,B10000100,B01111111,B00000111,B11110101,B11110000,B00111101,B11111111,B11110000,
B11011111,B11111000,B00001111,B11111100,B01111011,B11111111,B01110001,B11110000,B00111100,B11111111,B11110000,
B11011111,B11111000,B00001111,B00000100,B01111011,B00000111,B11110001,B10110000,B00111100,B11111111,B11110000,
B11011111,B11111111,B11111111,B11111100,B01111011,B01000111,B01110000,B11110000,B00111100,B11111111,B11110000,
B11011111,B11000001,B00000111,B00000100,B01111011,B00000111,B11110000,B01110000,B00111100,B11111111,B11110000,
B11011111,B11000001,B01010111,B11111100,B01111001,B00010111,B01110000,B00110000,B00111100,B11111111,B11110000,
B10001111,B11010101,B00000111,B00000100,B01111111,B00000111,B01110000,B00110000,B10110000,B00000000,B00110000,
B10001111,B11000001,B01010111,B11111100,B01111111,B01010111,B01110000,B00110001,B00110101,B11111011,B10110000,
B10001111,B11000001,B00000111,B00000100,B01111111,B00000111,B01110000,B00110010,B00110000,B00000000,B00110000,
B11111111,B11000001,B11111111,B11111100,B01101111,B11111111,B01110000,B00110100,B10110111,B11110101,B10110000,
B00000011,B11000000,B00001111,B00000100,B01101100,B00000001,B01110000,B00110001,B00110000,B00000000,B00110000,
B01111111,B11111000,B00101111,B11111100,B01101100,B00000001,B11110000,B00100010,B10110110,B11111110,B10110000,
B01100011,B10001000,B00001111,B10000100,B01101111,B11111111,B11110000,B00110101,B10110000,B00000000,B00110000,
B01101011,B10101010,B10101111,B11111100,B01111110,B00000011,B11110000,B00110011,B10110110,B10110101,B10110000,
B01100011,B10001000,B00001111,B11000100,B01101010,B10100011,B10100000,B10110111,B00110000,B00110000,B00110000,
B01101011,B11111000,B00001111,B11111100,B01110100,B00000011,B01010001,B00110110,B10110111,B10110101,B00110000,
B01100011,B11000000,B00001111,B11000000,B01101010,B00101011,B11110010,B00110101,B00110000,B00110000,B00110000,
B01101011,B11000001,B11111111,B11000000,B01110100,B00000011,B10100100,B10110010,B00110101,B10110111,B10110000,
B01100011,B11111111,B00000111,B11000111,B11101010,B10101011,B01010001,B00110100,B10110000,B00110000,B00110000,
B00001011,B11100001,B01010111,B10000100,B01110100,B00000011,B10100010,B10110001,B00110111,B10110100,B10110000,
B01100011,B11101111,B00000111,B00000111,B11111011,B11111111,B01010101,B10100010,B00110000,B00110000,B00110000,
B00001011,B11000001,B11111110,B01000100,B00110101,B11111111,B10100011,B10110100,B00110110,B10110101,B10010000,
B01100011,B11000000,B00001100,B11000111,B11111010,B00000011,B01010111,B00110000,B00110000,B00110000,B00110000,
B00001011,B11111111,B11111001,B11000100,B00011110,B00101011,B10100110,B10110000,B00110111,B10100111,B00100000,
B01100001,B11000000,B00001011,B11000111,B11111110,B00000011,B01010101,B00110000,B00010000,B00110000,B00010000,
B00000000,B11000010,B00001111,B11000100,B00011110,B10001011,B10100010,B00110000,B00110101,B10010111,B10100000,
B00000000,B01000000,B00001111,B11000111,B11111010,B00000011,B01010000,B00010000,B00100000,B00100000,B00000000,
B00000000,B00000010,B00001110,B11000100,B00011100,B00000001,B10100000,B00110000,B00010111,B10010101,B10010000,
B00000000,B00000000,B00001011,B10000111,B11111010,B00000011,B11110000,B00100000,B00100000,B00100000,B00000000,
B00000000,B00000010,B00000101,B01000100,B00010100,B00000011,B01010000,B00010000,B00000101,B00000001,B00000000,
B00000000,B00000000,B00001000,B10000111,B11101010,B00000010,B10100000,B00100000,B00010000,B00010000,B00000000,
B00000000,B00000000,B00000000,B00000100,B00000000,B00000001,B00010000,B00000000,B00000010,B00000100,B00000000,
B00000000,B00000000,B00000101,B00000111,B00000100,B00000000,B01000000,B00010000,B00000000,B00100000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
};

const byte img7[] PROGMEM = {88,48,
B11111111,B11111110,B10101000,B00000000,B00000000,B00000000,B00100010,B10101011,B11101111,B11111111,B11110000,
B11111111,B11111100,B00010000,B00000000,B00000000,B00000101,B00000000,B00000011,B11110111,B11111111,B11110000,
B11111111,B11111110,B10101000,B00000000,B00000000,B00000010,B10000000,B10101111,B11101111,B11111111,B11110000,
B11111111,B11111100,B00010000,B00000000,B00000000,B00001000,B00000000,B00000111,B11010111,B11111111,B11110000,
B11111111,B11111110,B10101000,B00000100,B01000000,B00000000,B00000010,B10101111,B11101111,B11111111,B11110000,
B11111111,B11111110,B01011000,B00001010,B00000000,B00000000,B00000000,B00000011,B11010111,B11111111,B11110000,
B11111111,B11111110,B10101000,B00000000,B10000000,B00000000,B00000010,B10101011,B10101111,B11111111,B11110000,
B11111111,B11111111,B01011000,B00000000,B00000000,B00000000,B00001000,B00000011,B11111111,B11111111,B11110000,
B11111111,B11111110,B11110000,B00000000,B10101010,B00000010,B00100010,B10101011,B10101111,B11111111,B11110000,
B11111111,B11111111,B01010000,B00000001,B01000100,B00010101,B01010101,B01010001,B11011111,B11111111,B11110000,
B11111111,B11111110,B10100000,B00101010,B10101010,B10000010,B10101010,B10101011,B11101111,B11111111,B11110000,
B11111111,B11111111,B11100000,B01010101,B01010111,B01010101,B01010111,B01010101,B11011111,B11111111,B11110000,
B11111111,B11111111,B11000010,B10111111,B11101010,B10101010,B10111111,B11111010,B11101111,B11111111,B11110000,
B11111111,B11111111,B10000111,B11111111,B11111101,B01010101,B11111111,B11111101,B11111111,B11111111,B11110000,
B11111111,B11111111,B00001111,B11111111,B11111111,B10111011,B11111111,B11111110,B11111111,B11111111,B11110000,
B11111111,B11111110,B00011111,B11111111,B11111101,B01010111,B11111111,B11111111,B01110111,B11111111,B11110000,
B11111111,B11111110,B00111111,B11111111,B11111111,B10101111,B11111111,B11111111,B10111111,B11111111,B11110000,
B11111111,B11111110,B00111111,B11111111,B11111111,B01011111,B11111111,B11111111,B11010111,B11111111,B11110000,
B11111111,B11111100,B01111111,B11111111,B11111111,B10101111,B11111111,B11111111,B11101111,B11111111,B11110000,
B11111111,B11111100,B01111111,B11111111,B11111110,B00000111,B11111111,B11111111,B11000111,B11111111,B11110000,
B11111111,B11111100,B01111111,B11111111,B11111100,B10001011,B11111111,B11111111,B11101111,B11111111,B11110000,
B11111111,B11111110,B01111111,B11111111,B11111101,B00000111,B11110111,B11111111,B11100111,B11111111,B11110000,
B11111111,B11111011,B11111111,B01111101,B10111000,B10001011,B11111111,B01111111,B11101011,B11111111,B11110000,
B11111111,B11111000,B01111011,B11011111,B11111100,B00000111,B11110101,B11111111,B11100111,B11111111,B11110000,
B11111111,B11111000,B01111110,B10101110,B10111000,B00001011,B11111011,B10110111,B11101011,B11111111,B11110000,
B11111111,B11111000,B01111011,B01010101,B11111000,B00000101,B11010101,B01011011,B11100011,B11111111,B11110000,
B11111111,B11111010,B11111110,B10101011,B11110010,B01100011,B11111010,B10110111,B11100011,B11111111,B11110000,
B11111111,B11111000,B00111111,B11011111,B11100000,B11110000,B11110111,B01111111,B11000011,B11111111,B11110000,
B11111111,B11111010,B10111111,B11111111,B10001010,B11110000,B00111110,B10101111,B10101011,B11111111,B11110000,
B11111111,B11110000,B00001111,B11111110,B00000001,B11111000,B00001111,B11111110,B00000001,B11111111,B11110000,
B11111111,B11101000,B10100111,B11111000,B00000011,B11111100,B00000011,B11111010,B10101011,B11111111,B11110000,
B11111111,B11110000,B00000000,B01100000,B00000011,B11111100,B00000000,B00010000,B00000101,B11111111,B11110000,
B11111111,B11101000,B00000000,B11000000,B10000111,B11111110,B10101000,B00011010,B11101011,B11111111,B11110000,
B11111111,B11110000,B01010001,B10000000,B00000111,B11111110,B00000000,B00001111,B11010111,B11111111,B11110000,
B11111111,B11111000,B00101011,B00011110,B00100111,B11111111,B00101000,B00000110,B10101011,B11111111,B11110000,
B11111111,B11111101,B00010111,B11111111,B00001111,B11111111,B00000001,B11111101,B01011111,B11111111,B11110000,
B11111111,B11111110,B10101110,B11111111,B00001111,B11101111,B00000011,B11111110,B10111111,B11111111,B11110000,
B11111111,B11111111,B01010101,B01010111,B00001111,B11111111,B10000111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111011,B10111111,B00011111,B10101010,B10000111,B11111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111101,B01010111,B00011111,B11011111,B11000111,B01010111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111110,B10101011,B00011010,B10101110,B11000110,B10111111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111110,B00000110,B00011111,B11011101,B11000111,B11010111,B11111111,B11111111,B11110000,
B11111111,B11111111,B11111110,B10101011,B00001110,B10101111,B10000110,B10101111,B11111111,B11111111,B10010000,
B11111111,B11111111,B11111110,B00000101,B00000111,B01010101,B00000101,B01011111,B11111111,B11111111,B01010000,
B11111111,B11111111,B11111111,B00101010,B00000011,B10101010,B00000010,B10101111,B11111111,B11111111,B00010000,
B11111111,B11111111,B11111110,B00000001,B00000001,B01010100,B00000101,B01011111,B11111111,B11111111,B01110000,
B11111111,B11111111,B11111111,B00001010,B00100000,B00100000,B10010010,B00101111,B11111111,B11111111,B10010000,
B11111111,B11111111,B11111111,B00000000,B01010100,B00000000,B00000101,B01011111,B11111111,B11111111,B11110000,
};

const byte img8[] PROGMEM = {88,48,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B01010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B10100000,
B01010111,B00101001,B01111010,B00011100,B00011001,B11000011,B10100101,B11100000,B10001011,B10011110,B10100000,
B00000100,B10101001,B01000010,B00100000,B00100101,B00100001,B00100101,B00000000,B10001010,B01010000,B00000000,
B00000111,B00100110,B01110010,B00011000,B00100101,B00100001,B00111101,B11000000,B10001010,B01011100,B00000000,
B00000100,B00101001,B01000010,B00000100,B00100101,B00100001,B00100101,B00000000,B10001010,B01010000,B00000000,
B00000100,B00101001,B01111011,B10111000,B00011001,B00100001,B00100101,B11100000,B11101010,B01011110,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00001111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00100000,B01100100,B10010011,B10011011,B10100100,B11000000,B01001110,B00001011,B01000100,B01101110,B01100000,
B01010000,B10001010,B10010010,B00100001,B00101010,B10100000,B10101000,B00001010,B10101010,B10001000,B10000000,
B01110000,B10001010,B10010011,B00100001,B00101010,B10100000,B10101100,B00001010,B10101110,B10101100,B01000000,
B01010000,B10001010,B10010010,B00100001,B00101010,B10100000,B10101000,B00001010,B10101010,B10101000,B00100000,
B01010000,B01100100,B11011011,B10011001,B00100100,B10100000,B01001000,B00001010,B10101010,B01101110,B11000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00011010,B00100011,B01110100,B10100000,B11001100,B01001010,B10110000,B00010011,B00000011,B01001010,B00000000,
B00010101,B01010100,B00100100,B10100000,B10101010,B10101010,B10101000,B00101010,B10000010,B10101010,B00000000,
B00010101,B01010010,B00100100,B01000000,B10101100,B11101010,B10101000,B00101010,B10000010,B10100100,B00000000,
B00010101,B01010001,B00100100,B01000000,B10101010,B10101010,B10101000,B00101010,B10000010,B10100100,B00000000,
B00010101,B00100110,B00100110,B01000000,B11001010,B10100101,B00101000,B00010010,B10000010,B10100100,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B11010001,B00110011,B00101100,B01100000,B01100100,B11010011,B01001010,B11101110,B00000000,B00000000,
B00000000,B10101010,B10101010,B10101010,B10000000,B10001010,B10101010,B10101010,B01001000,B00000000,B00000000,
B00000000,B10101010,B10110010,B10101010,B10100000,B10001010,B10101010,B10101010,B01001100,B00000000,B00000000,
B00000000,B10101010,B10101010,B10101010,B10100000,B10001010,B10101010,B10101010,B01001000,B00000000,B00000000,
B00000000,B10101001,B00101010,B10101010,B01100000,B01100100,B10101010,B10100110,B01001110,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B01100111,B01001110,B01000110,B11101100,B00001001,B11000011,B00100010,B01010101,B11000011,B00010011,B01110000,
B01010100,B01001000,B10101000,B10001010,B00010100,B10000100,B01010101,B01010101,B00000000,B10101001,B00010000,
B01100110,B01001100,B11100100,B11001010,B00011100,B10000100,B01010101,B01100101,B10000001,B00101001,B00100000,
B01010100,B01001000,B10100010,B10001010,B00010100,B10000100,B01010101,B01010101,B00000010,B00101001,B00100000,
B01010111,B01101110,B10101100,B11101100,B00010100,B10000011,B00100010,B01010101,B11000011,B10010001,B00100000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
};

const byte logo[] PROGMEM = {88,32,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00001111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111101,B01000000,
B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00011010,B10101011,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111101,B01000000,
B00010000,B00000000,B00000000,B00000000,B00000011,B11111111,B11100000,B00000000,B00000000,B00000000,B00000000,
B00010000,B00001111,B11000000,B00000000,B00000010,B00001000,B00100000,B00000000,B00000000,B00000000,B00000000,
B00010000,B00010000,B00100000,B11111111,B11000010,B11101011,B10100001,B11111111,B10000000,B00000000,B00000000,
B00010011,B11010111,B10100001,B00000000,B00100010,B11101011,B10100010,B00000000,B01000000,B00000000,B00000000,
B00010010,B01010100,B10100001,B00000000,B00100010,B11101011,B10100010,B00000000,B01000000,B00000000,B00000000,
B00010010,B01010100,B10100001,B11111111,B11100010,B11101011,B10100011,B11111111,B11000000,B00000000,B00000000,
B00010011,B11010111,B10100001,B11111111,B11100010,B11101011,B10100011,B11111111,B11000000,B00000000,B00000000,
B00010011,B11010111,B10100001,B11111111,B11100010,B11101011,B10100011,B11111111,B11000000,B00000000,B00000000,
B00010011,B11010111,B10100001,B11111111,B11100010,B11101011,B10100011,B11111111,B11000000,B00000000,B00000000,
B00010000,B00010111,B10100000,B11111111,B11001010,B11101011,B10101001,B11111111,B10000000,B00000000,B00000000,
B00010000,B00010000,B00100000,B00000000,B00000010,B00001000,B00100000,B00000000,B00000000,B00000000,B00000000,
B00010000,B00010000,B00100000,B00000000,B00000010,B00001000,B00100000,B00000000,B00000000,B00000000,B00000000,
B00010000,B00010000,B00100000,B00000000,B00000010,B00001000,B00100000,B00000000,B00000000,B00000000,B00000000,
B00111111,B11111111,B11111111,B11111111,B11111110,B00001000,B00111111,B11111111,B10101000,B00000000,B00000000,
B00111010,B10101010,B10101010,B10101010,B10101010,B00001000,B00101010,B10101010,B10000000,B00000000,B00000000,
B00111101,B01010101,B01010101,B01010101,B01010110,B00001000,B00110101,B01010101,B00101000,B00000000,B00000000,
B00111010,B10101010,B10101010,B10101010,B10101010,B00001000,B00101010,B10101010,B10000000,B00000000,B00000000,
B00111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B10101000,B00000000,B00000000,
B00011000,B00000000,B01111000,B00000000,B00011110,B00000000,B00111111,B11111111,B10101000,B00000000,B00000000,
B00011000,B01111000,B01111000,B01111000,B00011111,B11111111,B11111111,B11111111,B10101000,B00000000,B00000000,
B00011000,B11111100,B01111000,B11111100,B00011111,B11111111,B11111111,B11111111,B10101000,B00000000,B00000000,
B00011000,B11001111,B11111111,B11001100,B00000000,B11111111,B11111111,B11111111,B10101000,B00000000,B00000000,
B00011000,B11001111,B11111111,B11001100,B00000000,B11111111,B11111111,B11000000,B00000000,B00000000,B00000000,
B00000000,B11111100,B00000000,B11111100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B01111000,B00000000,B01111000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B10101000,B00000000,B00000000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B10101000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
};

void slideIn(byte myimg[])
{
  gb.display.drawBitmap(0,y,myimg);
  if (i < 16)
  {
     i = ++i; 
     y = y + (easing[i]);
  }  
}


void slideOut(byte myimg[])
{
  gb.display.drawBitmap(0,y,myimg);
  if (i > -1)
  {
     i = --i; 
     y = y - (easing[i+1]);
  }  
}

void setup() {
  gb.begin();
  gb.titleScreen(F("Pixels On The Line"),logo);
  gb.battery.show = false;
  gb.backlight.set(255);
  gb.setFrameRate(15); // decreasing frame rate to 15 as the music sounds better this way :)

  byte timer = 0;

  int i = -1;
  int y = -48;
  

// music setup
  for (int i = 0; i < NUM_CHANNELS; i++)  
    {
    gb.sound.changePatternSet(patternSet,i);
    switch(i)
    {
      case 0:
      gb.sound.playTrack(track0,0);
    break;
      case 1:
      gb.sound.playTrack(track1,1);
    break;
      case 2:
      gb.sound.playTrack(track2,2);
    break;
      case 3:
      gb.sound.playTrack(track3,3);
    break;
    }
  }
}


void loop() {
  bool exit = false;
  short timer = 0;

 
while (!exit)
  { 
  if(gb.update())
  {
   timer++; 
 
    if(timer < 75)
    {
      slideIn(img1);
    }

    if(timer >= 75 and timer < 100)
    {
      slideOut(img1);
    }  

    if(timer >= 100 and timer < 175)
    {
      slideIn(img2);
    }

    if(timer >= 175 and timer < 200)
    {
      slideOut(img2);
    }

    if(timer >= 200 and timer < 275)
    {
      slideIn(img3);
    }

    if(timer >= 275 and timer < 300)
    {
      slideOut(img3);
    }

        if(timer >= 300 and timer < 375)
    {
      slideIn(img4);
    }

    if(timer >= 375 and timer < 400)
    {
      slideOut(img4);
    }

        if(timer >= 400 and timer < 475)
    {
      slideIn(img5);
    }

    if(timer >= 475 and timer < 500)
    {
      slideOut(img5);
    }

        if(timer >= 500 and timer < 575)
    {
      slideIn(img6);
    }

    if(timer >= 575 and timer < 600)
    {
      slideOut(img6);
    }

        if(timer >= 600 and timer < 675)
    {
      slideIn(img7);
    }

    if(timer >= 675 and timer < 700)
    {
      slideOut(img7);
    }


    if(timer >= 700 and timer < 775)
    {
      slideIn(img8);
    }

    if(timer >= 775 and timer < 800)
    {
      slideOut(img8);
    }

    if(timer == 800 or gb.buttons.pressed(BTN_C))
    {
      exit = true;
     }    
 }
}

for (int w = 0; w < NUM_CHANNELS; w++)
   {
     gb.sound.stopTrack(w);
   }
setup ();

  
}
